/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ucar.unidata.idv.control.ControlWidget;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.PlanViewControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import visad.VisADException;
import visad.util.Util;

public class TopographyControl
extends PlanViewControl {
    Grid2DDisplayable gridDisplay;
    boolean isSmoothed;

    public TopographyControl() {
        this.setAttributeFlags(24);
    }

    @Override
    public DisplayableData createPlanDisplay() throws VisADException, RemoteException {
        this.gridDisplay = new Grid2DDisplayable("topo_" + this.paramName, true);
        this.gridDisplay.setTextureEnable(!this.isSmoothed);
        this.gridDisplay.setPolygonMode(this.getPolygonMode());
        this.gridDisplay.setUseDefaultRenderer(true);
        this.addAttributedDisplayable(this.gridDisplay);
        return this.gridDisplay;
    }

    @Override
    protected void addTopographyMap() throws VisADException, RemoteException {
        this.addTopographyMap(0);
    }

    @Override
    public boolean getMultipleIsTopography() {
        return true;
    }

    @Override
    public void getControlWidgets(List<ControlWidget> controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        JCheckBox toggle = new JCheckBox("", this.isSmoothed);
        toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TopographyControl.this.isSmoothed = ((JCheckBox)e.getSource()).isSelected();
                    TopographyControl.this.getGridDisplay().setTextureEnable(!TopographyControl.this.isSmoothed);
                }
                catch (Exception ve) {
                    DisplayControlBase.logException("setSmoothed", ve);
                }
            }
        });
        JComponent right = toggle;
        if (Util.canDoJava3D()) {
            this.getGridDisplay().setPointSize(this.getPointSize());
            JPanel tmpComp = GuiUtils.hgrid(Misc.newList(GuiUtils.rLabel("Display Mode: "), this.getPolyModeComboBox()), 0);
            right = GuiUtils.left(GuiUtils.hgrid(Misc.newList(toggle, tmpComp), 0));
        }
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Shade Colors:"), right));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Point Size:"), GuiUtils.left(this.doMakePointSizeWidget())));
    }

    protected Grid2DDisplayable getGridDisplay() {
        return this.gridDisplay;
    }

    public void setSmoothed(boolean v) {
        this.isSmoothed = v;
    }

    public boolean getSmoothed() {
        return this.isSmoothed;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    @Override
    public void setPointSize(float value) {
        super.setPointSize(value);
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setPointSize(this.getPointSize());
            }
            catch (Exception e) {
                TopographyControl.logException("Setting point size", e);
            }
        }
    }
}

