/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.Grid3DSoundingDataNode;
import ucar.unidata.idv.control.SoundingDataNode;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.SampledSet;
import visad.Set;
import visad.Unit;
import visad.VisADException;

final class TimeSeriesGrid3DSoundingDataNode
extends Grid3DSoundingDataNode {
    private SampledSet timeDomain;
    private Unit timeUnit;
    private int index = -1;
    private int timeCount;

    TimeSeriesGrid3DSoundingDataNode(SoundingDataNode.Listener listener) throws VisADException, RemoteException {
        super(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setField(Field field) throws VisADException, RemoteException {
        if (field == null) {
            throw new NullPointerException();
        }
        TimeSeriesGrid3DSoundingDataNode timeSeriesGrid3DSoundingDataNode = this;
        synchronized (timeSeriesGrid3DSoundingDataNode) {
            this.timeCount = field.getLength();
            this.timeDomain = (SampledSet)field.getDomainSet();
            this.timeUnit = this.timeDomain.getSetUnits()[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setOutputTimeIndex() throws VisADException, RemoteException {
        int timeI = -1;
        TimeSeriesGrid3DSoundingDataNode timeSeriesGrid3DSoundingDataNode = this;
        synchronized (timeSeriesGrid3DSoundingDataNode) {
            int i;
            if (this.inTime != null && this.timeDomain != null && (i = this.timeDomain.doubleToIndex(new double[][]{{this.inTime.getValue(this.timeUnit)}})[0]) != this.index) {
                timeI = this.index = i;
            }
        }
        if (timeI != -1) {
            this.setOutputTimeIndex(timeI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setOutputProfiles() throws VisADException, RemoteException {
        FlatField[] tempPros = null;
        FlatField[] dewPros = null;
        FlatField[] windPros = null;
        TimeSeriesGrid3DSoundingDataNode timeSeriesGrid3DSoundingDataNode = this;
        synchronized (timeSeriesGrid3DSoundingDataNode) {
            if (this.inLoc != null && this.field != null) {
                FieldImpl timeSer = GridUtil.getProfileAtLatLonPoint((FieldImpl)this.field, this.inLoc, 100);
                Boolean ensble = GridUtil.hasEnsemble(timeSer);
                if (ensble.booleanValue()) {
                    FieldImpl sample = (FieldImpl)timeSer.getSample(0);
                    Set ensDomain = sample.getDomainSet();
                    int len = ensDomain.getLength();
                    tempPros = new FlatField[this.timeCount * len];
                    dewPros = new FlatField[this.timeCount * len];
                    windPros = new FlatField[this.timeCount * len];
                } else {
                    tempPros = new FlatField[this.timeCount];
                    dewPros = new FlatField[this.timeCount];
                    windPros = new FlatField[this.timeCount];
                }
                for (int i = 0; i < this.timeCount; ++i) {
                    if (ensble.booleanValue()) {
                        FieldImpl sample = (FieldImpl)timeSer.getSample(i);
                        Set ensDomain = sample.getDomainSet();
                        int len = ensDomain.getLength();
                        for (int j = 0; j < len; ++j) {
                            float[][] values = ((Field)sample.getSample(i)).getFloats();
                            tempPros[i] = this.makeTempProfile(values[0]);
                            dewPros[i] = this.makeDewProfile(values[1]);
                            if (values.length <= 2) continue;
                            windPros[i] = this.makeWindProfile(new float[][]{values[2], values[3]});
                        }
                        continue;
                    }
                    float[][] values = ((Field)timeSer.getSample(i)).getFloats();
                    tempPros[i] = this.makeTempProfile(values[0]);
                    dewPros[i] = this.makeDewProfile(values[1]);
                    if (values.length <= 2) continue;
                    windPros[i] = this.makeWindProfile(new float[][]{values[2], values[3]});
                }
            }
        }
        if (tempPros != null) {
            this.setOutputProfiles(tempPros, dewPros, windPros);
        }
    }
}

