/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.LineProbeControl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Range;
import ucar.visad.UtcDate;
import ucar.visad.display.Animation;
import ucar.visad.display.Displayable;
import ucar.visad.display.IndicatorPoint;
import ucar.visad.display.ProfileLine;
import ucar.visad.display.XYDisplay;
import visad.AxisScale;
import visad.DateTime;
import visad.FieldImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;
import visad.util.DataUtility;

public class TimeSeriesControl
extends LineProbeControl {
    public static final String SHARE_PROFILE = "TimeSeriesControl.SHARE_PROFILE";
    private XYDisplay timeSeriesDisplay;
    private FieldImpl grid;
    private ProfileLine lineDispbl;
    private IndicatorPoint indicator;
    private JLabel paramLabel;
    private JLabel positionLabel;
    private JLabel timeLabel;
    private boolean isSequence = false;
    private PropertyChangeListener animationListener;

    public TimeSeriesControl() {
        this.setAttributeFlags(52);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.timeSeriesDisplay = new XYDisplay("timeseries_of_data", RealType.Time, RealType.YAxis);
        this.addDisplayMaster(this.timeSeriesDisplay);
        this.timeSeriesDisplay.showAxisScales(true);
        this.timeSeriesDisplay.getYAxisScale().setSnapToBox(true);
        this.timeSeriesDisplay.getXAxisScale().setSnapToBox(true);
        this.lineDispbl = new ProfileLine("timeseries");
        this.addAttributedDisplayable(this.lineDispbl, 4);
        this.indicator = new IndicatorPoint("indicator", new RealTupleType(RealType.Time, RealType.YAxis));
        this.addAttributedDisplayable(this.indicator, 4);
        this.indicator.setPointSize(5.0f);
        this.indicator.setVisible(true);
        Unit newUnit = this.getDisplayUnit();
        if (newUnit != null) {
            this.timeSeriesDisplay.setYDisplayUnit(newUnit);
        }
        this.lineDispbl.setVisible(true);
        this.timeSeriesDisplay.setDisplayables(new Displayable[]{this.lineDispbl, this.indicator});
        this.timeSeriesDisplay.draw();
        this.doMakeProbe();
        return this.setData(dataChoice);
    }

    @Override
    protected boolean shouldAddAnimationListener() {
        return true;
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            this.updateIndicatorPosition();
        }
        catch (Exception exc) {
            TimeSeriesControl.logException("changePosition", exc);
        }
        super.timeChanged(time);
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            this.setViewParameters();
            this.loadTimeSeries(this.getPosition());
        }
        catch (Exception exc) {
            TimeSeriesControl.logException("initDone", exc);
        }
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws RemoteException, VisADException {
        Hashtable props;
        EarthLocation elt;
        if (!super.setData(dataChoice)) {
            return false;
        }
        this.grid = this.getGridDataInstance().getGrid();
        if (!GridUtil.isTimeSequence(this.grid) || GridUtil.getTimeSet(this.grid).getLength() <= 1) {
            throw new VisADException("Need more than one time to create a time series");
        }
        if (this.getHaveInitialized()) {
            this.setViewParameters();
        }
        if (dataChoice.getProperties() != null && (elt = (EarthLocation)(props = dataChoice.getProperties()).get("INITIAL_PROBE_EARTHLOCATION")) != null && this.getInitialPosition() == null) {
            RealTuple rt = this.earthToBoxTuple(elt);
            Real[] reals = rt.getRealComponents();
            this.setProbePosition(new RealTuple(new Real[]{reals[0], reals[1]}));
        }
        this.loadTimeSeries(this.getPosition());
        return true;
    }

    private void setViewParameters() throws VisADException, RemoteException {
        if (this.getGridDataInstance() != null) {
            this.timeSeriesDisplay.setYAxisType(this.getGridDataInstance().getRealType(0));
            if (this.paramLabel != null) {
                this.paramLabel.setText(this.getGridDataInstance().getDataChoice().toString());
            }
            this.setRange(this.timeSeriesDisplay);
            this.applyDisplayUnit();
            AxisScale yAxis = this.timeSeriesDisplay.getYAxisScale();
            yAxis.setTitle(this.paramName);
            yAxis.setSnapToBox(true);
            this.setXAxisLabels((SampledSet)GridUtil.getTimeSet(this.grid));
        }
    }

    private void setRange(XYDisplay display) throws VisADException, RemoteException {
        Range range = this.getRange();
        display.setYRange(range.getMin(), range.getMax());
    }

    @Override
    protected void applyDisplayUnit() throws VisADException, RemoteException {
        super.applyDisplayUnit();
        this.timeSeriesDisplay.setYDisplayUnit(this.getDisplayUnit());
    }

    @Override
    protected void applyRange() throws VisADException, RemoteException {
        super.applyRange();
        this.timeSeriesDisplay.setYDisplayUnit(this.getDisplayUnit());
        this.setRange(this.timeSeriesDisplay);
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.positionLabel = new JLabel(" ", 2);
        this.timeLabel = new JLabel(" ", 2);
        this.paramLabel = new JLabel(" ", 2);
        JComponent cmp = (JComponent)this.timeSeriesDisplay.getComponent();
        cmp.setPreferredSize(new Dimension(450, 450));
        return GuiUtils.centerBottom(GuiUtils.topCenterBottom(this.paramLabel, cmp, GuiUtils.vbox(this.positionLabel, this.timeLabel)), this.doMakeWidgetComponent());
    }

    @Override
    protected void probePositionChanged(RealTuple position) {
        try {
            this.loadTimeSeries(this.getPosition());
        }
        catch (Exception exc) {
            TimeSeriesControl.logException("probePositionChanged", exc);
        }
    }

    public void loadTimeSeries(RealTuple position) throws VisADException, RemoteException {
        Real[] reals;
        if (!this.getHaveInitialized() || this.grid == null) {
            return;
        }
        LatLonPoint llp = null;
        RealTupleType rttype = (RealTupleType)position.getType();
        if (rttype.equals(RealTupleType.SpatialCartesian2DTuple)) {
            reals = position.getRealComponents();
            EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{reals[0].getValue(), reals[1].getValue(), 1.0});
            llp = elt.getLatLonPoint();
        } else if (rttype.equals(RealTupleType.SpatialEarth2DTuple)) {
            reals = position.getRealComponents();
            llp = new LatLonTuple(reals[1], reals[0]);
        } else if (rttype.equals(RealTupleType.LatitudeLongitudeTuple)) {
            reals = position.getRealComponents();
            llp = new LatLonTuple(reals[0], reals[1]);
        } else {
            throw new VisADException("Can't convert position to navigable point");
        }
        FieldImpl newFI = GridUtil.sample(this.grid, llp, this.getDefaultSamplingModeValue());
        this.lineDispbl.setData(newFI);
        this.updateIndicatorPosition();
        if (this.positionLabel != null) {
            this.positionLabel.setText(this.getDisplayConventions().formatLatLonPoint(llp));
        }
    }

    private void updateIndicatorPosition() throws VisADException, RemoteException {
        Animation anime = this.getViewAnimation();
        if (anime == null) {
            return;
        }
        if (this.lineDispbl == null || !this.lineDispbl.hasData()) {
            return;
        }
        Set timeSet = anime.getSet();
        int pos = 0;
        if (timeSet != null) {
            pos = anime.getCurrent();
        } else {
            timeSet = ((FieldImpl)this.lineDispbl.getData()).getDomainSet();
        }
        RealTuple timeTuple = DataUtility.getSample(timeSet, pos);
        RealTuple range = (RealTuple)((FieldImpl)this.lineDispbl.getData()).evaluate(timeTuple);
        this.indicator.setPoint(new RealTuple(new Real[]{(Real)timeTuple.getComponent(0), (Real)range.getComponent(0)}));
        if (this.timeLabel != null) {
            this.timeLabel.setText("Time: " + (Real)timeTuple.getComponent(0));
        }
    }

    private void setXAxisLabels(SampledSet timeSet) throws VisADException {
        try {
            if (timeSet == null) {
                return;
            }
            Real startTime = (Real)DataUtility.getSample(timeSet, 0).getComponent(0);
            double start = startTime.getValue();
            Real endTime = (Real)DataUtility.getSample(timeSet, timeSet.getLength() - 1).getComponent(0);
            double end = endTime.getValue();
            Hashtable<Double, String> timeLabels = new Hashtable<Double, String>();
            int numSteps = timeSet.getLength();
            int step = numSteps < 5 ? 1 : timeSet.getLength() / 5;
            double majorTickSpacing = endTime.getValue() - startTime.getValue();
            for (int k = 0; k < timeSet.getLength(); k += step) {
                Real r = (Real)DataUtility.getSample(timeSet, k).getComponent(0);
                double time = r.getValue();
                if (k == step) {
                    majorTickSpacing = time - start;
                }
                timeLabels.put(new Double(time), UtcDate.formatUtcDate(new DateTime(r), "dd'/'HH"));
            }
            timeLabels.put(new Double(end), UtcDate.formatUtcDate(new DateTime(endTime), "dd'/'HH"));
            this.timeSeriesDisplay.setXRange(start, end);
            AxisScale xScale = this.timeSeriesDisplay.getXAxisScale();
            xScale.setTickBase(start);
            double averageTickSpacing = end - start;
            xScale.setMajorTickSpacing(averageTickSpacing * (double)step);
            xScale.setMinorTickSpacing(averageTickSpacing);
            xScale.setLabelTable(timeLabels);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

