/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.TimeHeightViewManager;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.LineProbeControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.GuiUtils;
import ucar.visad.display.ColorScale;
import ucar.visad.display.Contour2DDisplayable;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.XYDisplay;
import visad.AxisScale;
import visad.CoordinateSystem;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DDoubleSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;
import visad.util.DataUtility;

public class TimeHeightControl
extends LineProbeControl {
    public static final String SHARE_PROFILE = "TimeHeightControl.SHARE_PROFILE";
    private XYDisplay profileDisplay;
    private FieldImpl fieldImpl;
    private DisplayableData dataDisplay;
    private Contour2DDisplayable contourDisplay;
    private boolean isLatestOnLeft = true;
    private boolean showAsContours = true;
    private Color foreground;
    private Color background;
    private LatLonWidget latLonWidget;
    protected TimeHeightViewManager timeHeightView;

    public TimeHeightControl() {
        this.setAttributeFlags(20);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.timeHeightView = new TimeHeightViewManager(this.getViewContext(), new ViewDescriptor("timeheight_of_" + this.paramName), "showControlLegend=false;wireframe=true;"){};
        this.profileDisplay = this.timeHeightView.getTimeHeightDisplay();
        this.profileDisplay.setAspect(1.0, 0.6);
        if (this.foreground != null) {
            this.timeHeightView.setColors(this.foreground, this.background);
        }
        this.doMakeProbe();
        this.addViewManager(this.timeHeightView);
        if (this.showAsContours) {
            this.dataDisplay = new Contour2DDisplayable("th_color_" + this.paramName, true, true);
            this.dataDisplay.setVisible(true);
            this.contourDisplay = new Contour2DDisplayable("th_contour_" + this.paramName);
            this.contourDisplay.setVisible(true);
            this.addDisplayable((Displayable)this.dataDisplay, this.timeHeightView, 42);
            this.addDisplayable((Displayable)this.contourDisplay, this.timeHeightView, 38);
        } else {
            this.dataDisplay = this.createDataDisplay();
            this.addDisplayable((Displayable)this.dataDisplay, this.timeHeightView, this.getDataDisplayFlags());
        }
        return this.setData(dataChoice);
    }

    @Override
    protected String getDefaultDisplayListTemplate() {
        return "%shortname% - %position% %timestamp%";
    }

    protected int getDataDisplayFlags() {
        return 40;
    }

    protected DisplayableData createDataDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable dataDisplay = new Grid2DDisplayable("th_color_" + this.paramName, true);
        dataDisplay.setTextureEnable(true);
        dataDisplay.setVisible(true);
        return dataDisplay;
    }

    public DisplayableData getDataDisplay() {
        return this.dataDisplay;
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.setData(dataChoice)) {
            return false;
        }
        this.fieldImpl = this.getGridDataInstance().getGrid();
        boolean isSequence = GridUtil.isTimeSequence(this.fieldImpl);
        if (!isSequence || this.fieldImpl.getDomainSet().getLength() <= 1) {
            throw new VisADException("Need more than one time to create a TimeHeight Cross Section");
        }
        this.setXAxisLabels((SampledSet)this.fieldImpl.getDomainSet());
        return true;
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            this.loadProfile(this.getPosition());
            this.profileDisplay.draw();
        }
        catch (Exception exc) {
            TimeHeightControl.logException("initDone", exc);
        }
    }

    protected ViewManager getTimeHeightViewManager() {
        return this.timeHeightView;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        return GuiUtils.centerBottom(this.timeHeightView.getContents(), this.doMakeWidgetComponent());
    }

    protected void displayTHForCoord(FieldImpl fi, int NN) throws VisADException, RemoteException {
        Set timeSet = fi.getDomainSet();
        double[][] timeVals = timeSet.getDoubles();
        RealTupleType newDomainType = new RealTupleType(RealType.Altitude, RealType.Time);
        TupleType parmType = GridUtil.getParamType(fi);
        int numParms = parmType.getNumberOfRealComponents();
        FunctionType newFieldType = new FunctionType(newDomainType, parmType);
        SampledSet ss = GridUtil.getSpatialDomain(fi);
        RealType height = (RealType)((SetType)ss.getType()).getDomain().getComponent(NN);
        float[][] latlonalt = ss.getSamples();
        Unit zUnit = ss.getSetUnits()[NN];
        if (!height.equals(RealType.Altitude)) {
            CoordinateSystem cs = ss.getCoordinateSystem();
            latlonalt = cs.toReference(latlonalt, ss.getSetUnits());
            zUnit = cs.getReferenceUnits()[cs.getReference().getIndex(RealType.Altitude)];
        }
        int numTimes = timeVals[0].length;
        int numAlts = ss.getLength();
        double[][] newDomainVals = new double[2][numTimes * numAlts];
        int l = 0;
        for (int j = 0; j < numTimes; ++j) {
            for (int i = 0; i < numAlts; ++i) {
                newDomainVals[0][l] = latlonalt[NN][i];
                newDomainVals[1][l] = timeVals[0][j];
                ++l;
            }
        }
        Gridded2DDoubleSet newDomain = new Gridded2DDoubleSet((MathType)newDomainType, newDomainVals, numAlts, numTimes, (CoordinateSystem)null, new Unit[]{zUnit, timeSet.getSetUnits()[0]}, (ErrorEstimate[])null);
        float[][] newRangeVals = new float[numParms][numTimes * numAlts];
        int index = 0;
        for (int i = 0; i < numTimes; ++i) {
            FlatField ff = (FlatField)fi.getSample(i);
            float[][] vals = ff.getFloats(false);
            for (int j = 0; j < numParms; ++j) {
                System.arraycopy(vals[j], 0, newRangeVals[j], index, numAlts);
            }
            index += numAlts;
        }
        FlatField profile = new FlatField(newFieldType, newDomain);
        profile.setSamples(newRangeVals, false);
        ((GridDisplayable)((Object)this.dataDisplay)).loadData(profile);
        if (this.showAsContours) {
            RealType[] origTypes = parmType.getRealComponents();
            RealType[] parmTypes = new RealType[numParms];
            for (int i = 0; i < numParms; ++i) {
                RealType parm = origTypes[i];
                parmTypes[i] = RealType.getRealType(parm.getName() + "_color", parm.getDefaultUnit());
            }
            RealTupleType colorType = new RealTupleType(parmTypes);
            FieldImpl profileOther = GridUtil.setParamType((FieldImpl)profile, colorType, false);
            this.contourDisplay.loadData(profileOther);
        }
    }

    @Override
    protected void probePositionChanged(RealTuple position) {
        try {
            this.loadProfile(position);
        }
        catch (Exception exc) {
            TimeHeightControl.logException("probePositionChanged", exc);
        }
    }

    public void loadProfile(RealTuple position) throws VisADException, RemoteException {
        if (!this.getHaveInitialized()) {
            return;
        }
        if (this.fieldImpl == null || position == null) {
            return;
        }
        LatLonPoint llp = this.getPositionLL(position);
        FieldImpl newFI = GridUtil.getProfileAtLatLonPoint(this.fieldImpl, llp, this.getDefaultSamplingModeValue());
        if (newFI != null) {
            this.displayTHForCoord(newFI, 2);
        }
        if (llp != null) {
            this.positionText = this.getDisplayConventions().formatLatLonPoint(llp);
            if (this.latLonWidget != null) {
                this.latLonWidget.setLat(this.getDisplayConventions().formatLatLon(llp.getLatitude().getValue()));
                this.latLonWidget.setLon(this.getDisplayConventions().formatLatLon(llp.getLongitude().getValue()));
            }
            this.updateLegendLabel();
        }
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        ActionListener llListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TimeHeightControl.this.handleLatLonWidgetChange();
            }
        };
        this.latLonWidget = new LatLonWidget("Lat: ", "Lon: ", llListener);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Position: "), this.latLonWidget));
        super.getControlWidgets(controlWidgets);
        JCheckBox toggle = new JCheckBox("", this.isLatestOnLeft);
        toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeHeightControl.this.isLatestOnLeft = ((JCheckBox)e.getSource()).isSelected();
                try {
                    TimeHeightControl.this.setXAxisValues();
                }
                catch (VisADException ve) {
                    DisplayControlBase.userMessage("couldn't set order");
                }
            }
        });
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Latest Data on Left: "), GuiUtils.leftCenter(toggle, GuiUtils.filler())));
    }

    private void handleLatLonWidgetChange() {
        try {
            double lat = this.latLonWidget.getLat();
            double lon = this.latLonWidget.getLon();
            double[] xyz = this.earthToBox(TimeHeightControl.makeEarthLocation(lat, lon, 0.0));
            this.setProbePosition(xyz[0], xyz[1]);
        }
        catch (Exception exc) {
            TimeHeightControl.logException("Error setting lat/lon", exc);
        }
    }

    private void setXAxisValues() throws VisADException {
        if (this.getGridDataInstance() == null) {
            return;
        }
        SampledSet timeSet = (SampledSet)this.getGridDataInstance().getGrid().getDomainSet();
        this.setXAxisLabels(timeSet);
    }

    private void setXAxisLabels(SampledSet timeSet) throws VisADException {
        try {
            if (timeSet == null) {
                return;
            }
            Real startTime = (Real)DataUtility.getSample(timeSet, 0).getComponent(0);
            double start = startTime.getValue();
            Real endTime = (Real)DataUtility.getSample(timeSet, timeSet.getLength() - 1).getComponent(0);
            double end = endTime.getValue();
            Hashtable<Double, String> timeLabels = new Hashtable<Double, String>();
            int numSteps = timeSet.getLength();
            int step = numSteps < 5 ? 1 : timeSet.getLength() / 5;
            double majorTickSpacing = endTime.getValue() - startTime.getValue();
            String format = majorTickSpacing >= 86400.0 ? "dd'/'HH" : "HH:mm";
            for (int k = 0; k < timeSet.getLength(); k += step) {
                Real r = (Real)DataUtility.getSample(timeSet, k).getComponent(0);
                double time = r.getValue();
                if (k == step) {
                    majorTickSpacing = time - start;
                }
                DateTime dt = new DateTime(r);
                timeLabels.put(new Double(time), dt.formattedString(format, dt.getFormatTimeZone()));
            }
            DateTime dt = new DateTime(endTime);
            timeLabels.put(new Double(end), dt.formattedString(format, dt.getFormatTimeZone()));
            if (this.isLatestOnLeft) {
                this.profileDisplay.setXRange(end, start);
            } else {
                this.profileDisplay.setXRange(start, end);
            }
            AxisScale xScale = this.profileDisplay.getXAxisScale();
            xScale.setTickBase(start);
            double averageTickSpacing = end - start;
            xScale.setMajorTickSpacing(averageTickSpacing * (double)step);
            xScale.setMinorTickSpacing(averageTickSpacing);
            xScale.setLabelTable(timeLabels);
            xScale.setTitle("Time (" + dt.formattedString("z", dt.getFormatTimeZone()) + ")");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public LatLonPoint getPositionLL(RealTuple position) throws VisADException, RemoteException {
        LatLonPoint llp = null;
        RealTupleType rttype = (RealTupleType)position.getType();
        if (rttype.equals(RealTupleType.SpatialCartesian2DTuple)) {
            Real[] reals = position.getRealComponents();
            EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{reals[0].getValue(), reals[1].getValue(), 1.0});
            llp = elt.getLatLonPoint();
        } else if (rttype.equals(RealTupleType.SpatialEarth2DTuple)) {
            Real[] reals = position.getRealComponents();
            llp = new LatLonTuple(reals[1], reals[0]);
        } else if (rttype.equals(RealTupleType.LatitudeLongitudeTuple)) {
            Real[] reals = position.getRealComponents();
            llp = new LatLonTuple(reals[0], reals[1]);
        } else {
            throw new VisADException("Can't convert position to navigable point");
        }
        return llp;
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        items.add("separator");
        if (forMenuBar) {
            JMenu xsMenu = this.timeHeightView.makeViewMenu();
            xsMenu.setText("Time Height View");
            items.add(xsMenu);
            items.add(this.doMakeProbeMenu(new JMenu("Probe")));
        }
    }

    @Override
    protected void doMakeColorScales() throws VisADException, RemoteException {
        this.colorScales = new ArrayList();
        if (this.colorScaleInfo == null) {
            this.colorScaleInfo = this.getDefaultColorScaleInfo();
        }
        ColorScale colorScale = new ColorScale(this.getColorScaleInfo());
        this.addDisplayable((Displayable)colorScale, this.timeHeightView, 8);
        this.colorScales.add(colorScale);
    }

    @Override
    public void addPropertiesComponents(JTabbedPane jtp) {
        super.addPropertiesComponents(jtp);
        if (this.timeHeightView != null) {
            jtp.add("Time Height View", this.timeHeightView.getPropertiesComponent());
        }
    }

    @Override
    public boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        if (this.timeHeightView != null) {
            return this.timeHeightView.applyProperties();
        }
        return true;
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        try {
            this.setXAxisValues();
        }
        catch (Exception exc) {
            TimeHeightControl.logException("applyPreferences", exc);
        }
    }

    public void setLatestOnLeft(boolean yesorno) {
        this.isLatestOnLeft = yesorno;
    }

    public boolean getLatestOnLeft() {
        return this.isLatestOnLeft;
    }

    public void setShowAsImage(boolean yesorno) {
        this.showAsContours = !yesorno;
    }

    public void setShowAsContours(boolean yesorno) {
        this.showAsContours = yesorno;
    }

    public boolean getShowAsContours() {
        return this.showAsContours;
    }

    public Color getForeground() {
        return this.getTimeHeightViewManager().getForeground();
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.getTimeHeightViewManager().getBackground();
    }

    public void setBackground(Color color) {
        this.background = color;
    }
}

