/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.visad.display.Displayable;
import ucar.visad.display.Grid3DDisplayable;
import visad.Data;
import visad.FieldImpl;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public class ThreeDSurfaceControl
extends GridDisplayControl {
    Grid3DDisplayable myDisplay;
    private double lastRawLevel;
    public static final String SHARE_SURFACEVALUE = "ThreeDSurfaceControl.SHARE_FIELDSURFACEVALUE";
    private String OldSmoothingType = "None";
    private int OldSmoothingFactor = 0;
    public static final String SHARE_TRANSPARENCY = "ThreeDSurfaceControl.SHARE_TRANSPARENCY";
    private boolean ignoreUIEvents = false;
    float alpha = 1.0f;
    double levelSliderPercent = Double.NaN;
    double surfaceValue = Double.NaN;
    private JLabel levelLabel;
    private JTextField levelReadout;
    private JSlider levelSlider;
    private Range levelRange = new Range(0.0, 100000.0);
    private JComponent[] sliderComps;
    private String lastReadout;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!this.isDisplay3D()) {
            ThreeDSurfaceControl.userMessage("Can't display IsoSurface in 2D display");
            return false;
        }
        this.myDisplay = new Grid3DDisplayable("3diso_" + dataChoice, true);
        this.makeInitialWidgets();
        if (!this.setData(dataChoice)) {
            return false;
        }
        this.setAttributeFlags(8);
        if (this.haveMultipleFields()) {
            this.addDisplayable((Displayable)this.myDisplay, 8312);
        } else {
            this.addDisplayable((Displayable)this.myDisplay, 8248);
        }
        return true;
    }

    @Override
    public void initDone() {
        super.initDone();
        if ((double)this.alpha != 1.0) {
            this.adjustTransparency(this.alpha, true);
        }
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList("%value%"));
        labels.addAll(Misc.newList("Isosurface Value"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        patterns.add("%value%");
        values.add(this.levelReadout.getText());
    }

    @Override
    protected void displayUnitChanged(Unit oldUnit, Unit newUnit) {
        super.displayUnitChanged(oldUnit, newUnit);
        try {
            this.setSliderValues();
            this.adjustSliderLabel(this.getWholeDisplayValue(this.lastRawLevel));
        }
        catch (Exception exc) {
            ThreeDSurfaceControl.logException("Handling display unit change", exc);
        }
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (!super.setData(choice)) {
            return false;
        }
        this.myDisplay.setColoredByAnother(this.haveMultipleFields());
        this.myDisplay.setGrid3D(this.getGrid(this.getGridDataInstance()));
        this.setSliderValues();
        double initialValue = this.surfaceValue;
        if (Double.isNaN(initialValue)) {
            initialValue = !Double.isNaN(this.levelSliderPercent) ? this.getRawLevelFromSlider() : this.getDataRange().getMid();
        }
        this.setLevelWithRawValue(initialValue);
        String magStr = (String)choice.getProperty("MAG");
        if (choice instanceof DerivedDataChoice) {
            DerivedDataChoice dchoice = (DerivedDataChoice)choice;
            List dlist = dchoice.getChoices();
            DataChoice dc = (DataChoice)dlist.get(0);
            magStr = (String)dc.getProperty("MAG");
        }
        if (magStr != null && !magStr.isEmpty()) {
            System.out.println(" MAG " + this.resolutionReadout);
            this.resolutionReadout = magStr;
        } else {
            this.resolutionReadout = null;
        }
        return true;
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        super.resetData();
        this.OldSmoothingType = "None";
        this.applySmoothing();
    }

    private void makeInitialWidgets() {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    if (!ThreeDSurfaceControl.this.getHaveInitialized() || ThreeDSurfaceControl.this.ignoreUIEvents) {
                        return;
                    }
                    double newRawLevel = ThreeDSurfaceControl.this.getRawLevelFromSlider();
                    if (ThreeDSurfaceControl.this.levelSlider.getValueIsAdjusting()) {
                        ThreeDSurfaceControl.this.adjustSliderLabel(ThreeDSurfaceControl.this.getWholeDisplayValue(newRawLevel));
                    } else {
                        ThreeDSurfaceControl.this.setLevelWithRawValue(newRawLevel);
                    }
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("adjust level ", exc);
                }
            }
        };
        this.sliderComps = GuiUtils.makeSliderPopup(0, this.levelRange.getMaxInt(), this.levelRange.getMaxInt() / 2, listener);
        this.levelSlider = new JSlider(0, 0, this.levelRange.getMaxInt(), this.levelRange.getMaxInt() / 2);
        this.levelSlider = (JSlider)this.sliderComps[1];
        this.sliderComps[0].setToolTipText("Change Isosurface Value");
        this.levelSlider.setPaintTicks(true);
        this.levelSlider.setPaintLabels(true);
        this.levelSlider.setPaintTrack(true);
        this.levelSlider.setToolTipText("Reset value of isosurface");
        this.levelSlider.setMaximumSize(new Dimension(300, 40));
        this.levelSlider.setAlignmentX(0.5f);
        this.levelSlider.addChangeListener(listener);
        this.levelLabel = new JLabel("   ");
        this.levelLabel.setToolTipText("Click to Change Display Unit");
        this.levelLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                ThreeDSurfaceControl.this.changeDisplayUnit();
            }
        });
        this.levelReadout = new JTextField("   ", 6);
        this.levelReadout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ThreeDSurfaceControl.this.ignoreUIEvents) {
                    return;
                }
                try {
                    double displayLevel = Misc.parseNumber(ThreeDSurfaceControl.this.levelReadout.getText().trim());
                    double rawValue = ThreeDSurfaceControl.this.convertDisplayToRaw(displayLevel);
                    ThreeDSurfaceControl.this.setLevelWithRawValue(rawValue);
                }
                catch (NumberFormatException nfe) {
                    DisplayControlBase.userMessage("Incorrect format: " + ThreeDSurfaceControl.this.levelReadout.getText());
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Setting level", exc);
                }
            }
        });
    }

    @Override
    protected void applySmoothing() throws VisADException, RemoteException {
        if (!(!this.checkFlag(8192) || this.myDisplay == null || this.getSmoothingType().equalsIgnoreCase("None") && this.OldSmoothingType.equalsIgnoreCase("None") || this.getSmoothingType().equals(this.OldSmoothingType) && this.getSmoothingFactor() == this.OldSmoothingFactor)) {
            this.OldSmoothingType = this.getSmoothingType();
            this.OldSmoothingFactor = this.getSmoothingFactor();
            try {
                FieldImpl sdata = GridUtil.smooth(this.getGrid(this.getGridDataInstance()), this.getSmoothingType(), this.getSmoothingFactor());
                this.myDisplay.setGrid3D(sdata);
            }
            catch (Exception ve) {
                ThreeDSurfaceControl.logException("applySmoothing", ve);
            }
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        return GuiUtils.left(this.doMakeWidgetComponent());
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        JPanel labelPanel = GuiUtils.wrap(GuiUtils.hflow(Misc.newList(this.levelReadout, this.levelLabel, GuiUtils.inset((Component)this.sliderComps[0], new Insets(0, 5, 0, 0)))));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Isosurface Value:"), GuiUtils.left(labelPanel)));
    }

    private RealType getDataRealType() {
        return this.getGridDataInstance().getRealType(0);
    }

    private Unit getDataUnit() {
        return this.getDataRealType().getDefaultUnit();
    }

    private Range getDataRange() {
        return this.getGridDataInstance().getRange(0);
    }

    private double convertRawToDisplay(double rawValue) throws VisADException, RemoteException {
        Real dispVal = new Real(this.getDataRealType(), rawValue);
        try {
            if (this.getDisplayUnit() != null && Unit.canConvert(this.getDisplayUnit(), this.getDataUnit())) {
                return dispVal.getValue(this.getDisplayUnit());
            }
            return dispVal.getValue();
        }
        catch (Exception exc) {
            ThreeDSurfaceControl.logException("getting display value", exc);
            return 0.0;
        }
    }

    private double convertDisplayToRaw(double displayLevel) throws VisADException, RemoteException {
        Unit rawDataUnit = this.getDataUnit();
        if (rawDataUnit != null && this.getDisplayUnit() != null) {
            return rawDataUnit.toThis(displayLevel, this.getDisplayUnit());
        }
        return displayLevel;
    }

    private double getWholeDisplayValue(double rawLevel) throws VisADException, RemoteException {
        double displayLevel = this.convertRawToDisplay(rawLevel);
        return displayLevel;
    }

    public void setLevelWithRawValue(double rawLevel) throws VisADException, RemoteException {
        this.setLevelWithRawValue(rawLevel, true);
    }

    private void setLevelWithRawValue(double rawLevel, boolean andDoShare) throws VisADException, RemoteException {
        this.lastRawLevel = rawLevel;
        double displayValue = this.getWholeDisplayValue(rawLevel);
        boolean lastIgnore = this.ignoreUIEvents;
        this.ignoreUIEvents = true;
        this.adjustSliderLabel(displayValue);
        this.levelSliderPercent = this.getDataRange().getPercent(rawLevel);
        GuiUtils.setSliderPercent(this.levelSlider, this.levelSliderPercent);
        this.ignoreUIEvents = lastIgnore;
        Unit rawDataUnit = this.getDataUnit();
        if (rawDataUnit != null && this.getDisplayUnit() != null) {
            Real newVal = new Real(this.getDataRealType(), displayValue, this.getDisplayUnit());
            rawLevel = newVal.getValue(rawDataUnit);
        }
        this.myDisplay.setSurfaceValue((float)rawLevel);
        this.updateDisplayList();
        if (andDoShare) {
            this.doShareExternal(SHARE_SURFACEVALUE, new Double(this.lastRawLevel));
        }
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        try {
            if (dataId.equals(SHARE_SURFACEVALUE)) {
                this.setLevelWithRawValue((Double)data[0], false);
            } else if (dataId.equals(SHARE_TRANSPARENCY)) {
                float newAlpha = ((Float)data[0]).floatValue();
                this.adjustTransparency(newAlpha, false);
            } else {
                super.receiveShareData(from, dataId, data);
            }
        }
        catch (Exception exc) {
            ThreeDSurfaceControl.logException("Error in processing shared state:" + dataId, exc);
        }
    }

    private void adjustSliderLabel(double displayValue) throws VisADException, RemoteException {
        String unitLabel = "   ";
        if (this.getDisplayUnit() != null) {
            unitLabel = " " + this.getDisplayUnit();
        }
        String value = this.getDisplayConventions().format(displayValue);
        this.lastReadout = value + unitLabel;
        boolean lastIgnore = this.ignoreUIEvents;
        this.ignoreUIEvents = true;
        this.levelReadout.setText(value);
        this.ignoreUIEvents = lastIgnore;
        this.levelLabel.setText(unitLabel);
        this.updateLegendLabel();
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        if (this.lastReadout != null) {
            labels.add("Value: " + this.lastReadout);
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setLevelSliderPercent(double level) {
        this.levelSliderPercent = level;
    }

    private double getRawLevelFromSlider() {
        this.levelSliderPercent = GuiUtils.getSliderPercent(this.levelSlider);
        return this.getDataRange().getValueOfPercent(this.levelSliderPercent);
    }

    private void adjustTransparency(float newAlpha, boolean andDoShare) {
        try {
            this.alpha = newAlpha;
            float[][] table = ColorTable.changeTransparency(this.myDisplay.getColorPalette(), this.alpha);
            ColorTable t = new ColorTable(this.getColorTable());
            t.setTableArray(table);
            this.setColorTable(t);
            if (andDoShare) {
                this.doShareExternal(SHARE_TRANSPARENCY, new Float(this.alpha));
            }
        }
        catch (Exception exc) {
            ThreeDSurfaceControl.logException("Change transparency", exc);
        }
    }

    public void setSliderValues() throws VisADException, RemoteException {
        Unit rangeUnit;
        boolean lastIgnore = this.ignoreUIEvents;
        this.ignoreUIEvents = true;
        Range r = this.getDataRange();
        double span = r.getAbsSpan();
        Real dmin = new Real(this.getDataRealType(), r.getMin());
        Real dmax = new Real(this.getDataRealType(), r.getMax());
        Real dspan = new Real(this.getDataRealType(), r.getAbsSpan());
        span = dspan.getValue(rangeUnit = Unit.canConvert(this.getDisplayUnit(), this.getDataUnit()) ? this.getDisplayUnit() : this.getDataUnit());
        if (span > 50.0) {
            this.levelRange.set(dmin.getValue(rangeUnit), dmax.getValue(rangeUnit) + 0.5);
            if (this.levelRange.getAbsSpan() < 40.0) {
                this.levelRange.setMin((double)(2 * (this.levelRange.getMinInt() / 2)));
                if (this.levelRange.getMin() < 0.0) {
                    this.levelRange.setMin(this.levelRange.getMinInt() - 2);
                }
            } else {
                this.levelRange.setMin(5 * (this.levelRange.getMinInt() / 5));
                if (this.levelRange.getMinInt() < 0) {
                    this.levelRange.setMin(this.levelRange.getMinInt() - 5);
                }
            }
            this.levelSlider.setMinimum(this.levelRange.getMinInt());
            this.levelSlider.setMaximum(this.levelRange.getMaxInt());
            int spacing = this.levelRange.getSpanInt() / 4;
            if (spacing > 10 && spacing <= 100) {
                spacing = 10 * (spacing / 10);
            }
            if (spacing > 100) {
                spacing = 100 * (spacing / 100);
            }
            this.levelSlider.setMajorTickSpacing(spacing);
            this.levelSlider.setMinorTickSpacing(spacing / 2);
            this.levelSlider.setPaintTicks(true);
            this.levelSlider.setLabelTable(this.levelSlider.createStandardLabels(spacing));
        } else {
            float fmin = 0.0f;
            float fmax = 100000.0f;
            float fmid = 50000.0f;
            fmin = (float)dmin.getValue(rangeUnit);
            fmax = (float)dmax.getValue(rangeUnit);
            fmid = (fmax + fmin) / 2.0f;
            float spacing = (fmax - fmin) / 4.0f;
            int ispace = this.levelRange.getSpanInt() / 4;
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            for (int n = 0; n <= 4; ++n) {
                labels.put(new Integer(this.levelRange.getMinInt() + n * ispace), new JLabel(this.getDisplayConventions().format(fmin + (float)n * spacing)));
            }
            this.levelSlider.setLabelTable(labels);
        }
        GuiUtils.setSliderPercent(this.levelSlider, this.levelSliderPercent);
        this.ignoreUIEvents = lastIgnore;
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        dsd.addPropertyValue(new Double(this.getSurfaceValue()), "levelWithRawValue", "Isosurface Value", "Display");
    }

    public void setSurfaceValue(double value) {
        this.surfaceValue = value;
    }

    public double getSurfaceValue() {
        if (this.myDisplay != null) {
            return this.myDisplay.getSurfaceValue();
        }
        return Double.NaN;
    }

    @Override
    public boolean canExportData() {
        return true;
    }

    @Override
    protected Data getDisplayedData() throws VisADException, RemoteException {
        if (this.myDisplay == null || this.myDisplay.getData() == null) {
            return null;
        }
        return this.myDisplay.getData();
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return true;
    }
}

