/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.text.Product;
import ucar.unidata.data.text.ProductGroup;
import ucar.unidata.data.text.ProductType;
import ucar.unidata.data.text.TextProductDataSource;
import ucar.unidata.idv.control.StationLocationControl;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.ui.TextSearcher;
import ucar.unidata.util.Cache;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import visad.DateTime;
import visad.Real;
import visad.VisADException;

public class TextProductControl
extends StationLocationControl
implements HyperlinkListener {
    public static final String TEXT_TYPE = "Text";
    public static final String HTML_TYPE = "HTML";
    private int hours = -1;
    private JComboBox dateSelectionCbx;
    private JCheckBox showGlossaryCbx;
    private boolean showGlossary = false;
    private String currentText = "";
    private TextProductDataSource dataSource;
    private List<ProductGroup> productGroups;
    JTree productTree;
    private JTabbedPane textTabbedPane;
    private boolean ignoreTimeChanges = false;
    private ProductType productType;
    private List<Product> products;
    private JTextComponent textComp;
    private JEditorPane htmlComp;
    private JLabel stationLabel;
    private NamedStationTable stationTable;
    private List<NamedStationImpl> selectedStations = new ArrayList<NamedStationImpl>();
    private List<String> selectedStationIds;
    private Pattern allPattern = null;
    private NamedStationTable currentTable;
    private List stationList = new ArrayList();
    private Cache htmlCache = new Cache(10);
    private Font htmlFont;
    private Font fixedFont;
    private String displayType = "Text";
    private Hashtable<String, List> stationsForProduct = new Hashtable();

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        String url;
        URL tmp = e.getURL();
        String string = url = tmp != null ? tmp.toString() : e.getDescription();
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                String content = IOUtil.readContents("https://forecast.weather.gov/glossary.php?word=" + url, this.getClass());
                int idx = content.indexOf("<html");
                if (idx >= 0) {
                    content = content.substring(idx);
                }
                if ((idx = content.indexOf("<hr")) >= 0) {
                    content = content.substring(0, idx);
                }
                content = content.replaceAll("<!--.*-->", "");
                content = content.replaceAll("<dt>", "");
                content = content.replaceAll("</dt><dd>", "<br>");
                JEditorPane pane = new JEditorPane();
                pane.setEditable(false);
                pane.setContentType("text/html");
                pane.setText(content);
                pane.setPreferredSize(new Dimension(500, 250));
                JLabel lbl = new JLabel(content);
                GuiUtils.showOkDialog(null, "Definition: " + url, pane, null);
            }
            catch (Exception exc) {
                TextProductControl.logException("Could not fetch definition", exc);
            }
        } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED || e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            // empty if block
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        if (this.productGroups == null) {
            return new JLabel("Could not load product data");
        }
        JTabbedPane tabs = this.doMakeTabs(false, false);
        this.setCenterOnClick(false);
        this.htmlComp = new JEditorPane();
        this.htmlComp.addHyperlinkListener(this);
        this.htmlComp.setEditable(false);
        this.htmlComp.setContentType("text/html");
        this.htmlFont = this.htmlComp.getFont();
        this.fixedFont = new Font("Monospaced", this.htmlFont.getStyle(), this.htmlFont.getSize());
        this.textComp = new JTextArea("", 30, 80);
        GuiUtils.setFixedWidthFont(this.textComp);
        this.textComp.setEditable(false);
        TextSearcher textSearcher = new TextSearcher(this.textComp);
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("Product Groups");
        DefaultMutableTreeNode selectedNode = null;
        for (ProductGroup productGroup : this.productGroups) {
            DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(productGroup);
            treeRoot.add(groupNode);
            for (ProductType type : productGroup.getProductTypes()) {
                DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(type);
                groupNode.add(typeNode);
                if (!Misc.equals(type, this.productType)) continue;
                selectedNode = typeNode;
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot);
        this.productTree = new JTree(treeModel){

            @Override
            public String getToolTipText() {
                if (TextProductControl.this.productType != null) {
                    return "Current selected product:" + TextProductControl.this.productType.getId();
                }
                return super.getToolTipText();
            }
        };
        this.productTree.setToolTipText("Products");
        ToolTipManager.sharedInstance().registerComponent(this.productTree);
        this.productTree.setRootVisible(false);
        this.productTree.setShowsRootHandles(true);
        if (selectedNode != null) {
            Object[] path = treeModel.getPathToRoot(selectedNode);
            this.productTree.setSelectionPath(new TreePath(path));
            this.productTree.expandPath(new TreePath(path));
        }
        this.productTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TextProductControl.this.productType = TextProductControl.this.getSelectedProductType();
                TextProductControl.this.updateText();
            }
        });
        Object[] dateSelectionItems = new Object[]{new TwoFacedObject((Object)"Most Recent", -1), new TwoFacedObject((Object)"1 Hour", 1), new TwoFacedObject((Object)"3 Hours", 3), new TwoFacedObject((Object)"6 Hours", 6), new TwoFacedObject((Object)"12 Hours", 12), new TwoFacedObject((Object)"24 Hours", 24), new TwoFacedObject((Object)"36 Hours", 36), new TwoFacedObject((Object)"48 Hours", 48), new TwoFacedObject((Object)"All", 0)};
        TwoFacedObject selectedTfo = TwoFacedObject.findId(new Integer(this.hours), Misc.toList(dateSelectionItems));
        this.dateSelectionCbx = new JComboBox<Object>(dateSelectionItems);
        if (selectedTfo != null) {
            this.dateSelectionCbx.setSelectedItem(selectedTfo);
        }
        this.dateSelectionCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextProductControl.this.updateText();
            }
        });
        JScrollPane treeScroller = GuiUtils.makeScrollPane(this.productTree, 250, 100);
        treeScroller.setMinimumSize(new Dimension(250, 100));
        JPanel treeComp = GuiUtils.centerBottom(treeScroller, GuiUtils.inset((Component)GuiUtils.vbox(new JLabel("Time Covered:"), this.dateSelectionCbx), 5));
        this.stationLabel = new JLabel(" ");
        JScrollPane textScroller = new JScrollPane(this.textComp);
        JScrollPane htmlScroller = new JScrollPane(this.htmlComp);
        textScroller.setVerticalScrollBarPolicy(22);
        htmlScroller.setVerticalScrollBarPolicy(22);
        JPanel textHolder = GuiUtils.centerBottom(textScroller, textSearcher);
        this.textTabbedPane = new JTabbedPane(3);
        this.showGlossaryCbx = new JCheckBox("Show Glossary", this.showGlossary);
        this.showGlossaryCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextProductControl.this.setText(TextProductControl.this.currentText, true);
            }
        });
        this.textTabbedPane.addTab(TEXT_TYPE, textHolder);
        this.textTabbedPane.addTab(HTML_TYPE, GuiUtils.centerBottom(htmlScroller, GuiUtils.right(this.showGlossaryCbx)));
        this.textTabbedPane.setSelectedIndex(this.getTextTabIndex(this.displayType));
        GuiUtils.tmpInsets = GuiUtils.INSETS_2;
        JPanel topComp = GuiUtils.leftRight(GuiUtils.bottom(this.stationLabel), this.getAnimationWidget().getContents());
        JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.bottom(new JLabel("Products")), topComp, treeComp, this.textTabbedPane}, 2, new double[]{0.0, 1.0}, GuiUtils.WT_NY);
        this.updateText();
        tabs.insertTab("Products", null, contents, "", 0);
        tabs.setSelectedIndex(0);
        return tabs;
    }

    private int getTextTabIndex(String tabName) {
        return tabName.equalsIgnoreCase(HTML_TYPE) ? 1 : 0;
    }

    private ProductType getSelectedProductType() {
        TreePath[] paths = this.productTree.getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return null;
        }
        for (int i = 0; i < paths.length; ++i) {
            DefaultMutableTreeNode dmtn;
            Object userObject;
            Object last = paths[i].getLastPathComponent();
            if (last == null || !(last instanceof DefaultMutableTreeNode) || !((userObject = (dmtn = (DefaultMutableTreeNode)last).getUserObject()) instanceof ProductType)) continue;
            return (ProductType)userObject;
        }
        return null;
    }

    @Override
    protected List getStationList() {
        return this.stationList;
    }

    @Override
    protected void selectedStationsChanged(List selectionList) throws VisADException, RemoteException {
        super.selectedStationsChanged(selectionList);
        if (selectionList.equals(this.selectedStations)) {
            this.updateStationLabel();
            return;
        }
        this.selectedStations = new ArrayList<NamedStationImpl>(selectionList);
        if (this.productType != null) {
            this.stationsForProduct.put(this.productType.getId(), new ArrayList<NamedStationImpl>(this.selectedStations));
        }
        this.updateStationLabel();
        this.updateText();
    }

    private void updateStationLabel() {
        if (this.stationLabel != null) {
            StringBuffer sb = new StringBuffer();
            for (NamedStationImpl station : this.selectedStations) {
                String state = (String)station.getProperty("st", "");
                String name = station.getName();
                name = name.replace("_", " ");
                sb.append(name + (state.equals("") ? " " : ", ") + state);
                sb.append(";");
            }
            String label = sb.toString();
            if (label.length() > 50) {
                label = label.substring(0, 49) + "...";
            }
            this.stationLabel.setText(label);
            this.stationLabel.setToolTipText(sb.toString());
        }
    }

    public void updateText() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                TextProductControl.this.showWaitCursor();
                try {
                    TextProductControl.this.setText("Loading...", false);
                    TextProductControl.this.updateTextInner();
                }
                catch (Exception exc) {
                    TextProductControl.this.setText("Error:" + exc, false);
                }
                finally {
                    TextProductControl.this.showNormalCursor();
                }
            }
        });
    }

    protected void xxxaddSelectedToList(List listOfStations) {
    }

    private void updateSelectedStations() throws VisADException, RemoteException {
        List<NamedStationImpl> tmp = this.selectedStations;
        this.selectedStations = new ArrayList<NamedStationImpl>();
        for (NamedStationImpl station : tmp) {
            int idx = this.stationList.indexOf(station);
            if (idx < 0) continue;
            this.selectedStations.add((NamedStationImpl)this.stationList.get(idx));
        }
        this.setSelectedStations(this.selectedStations);
        this.updateStationLabel();
    }

    private void updateTextInner() {
        try {
            List lastStations;
            NamedStationTable newTable = this.dataSource.getStations(this.productType, this.getDateSelection());
            if (newTable != this.currentTable) {
                this.stationList = newTable != null ? new ArrayList(newTable.values()) : new ArrayList();
                List<String> tmpIds = this.selectedStationIds;
                this.selectedStationIds = null;
                if (tmpIds != null) {
                    this.selectedStations = new ArrayList<NamedStationImpl>();
                    Hashtable<String, String> map = new Hashtable<String, String>();
                    for (String id : tmpIds) {
                        map.put(id, id);
                    }
                    for (NamedStationImpl station : this.stationList) {
                        if (map.get(station.getID()) == null) continue;
                        this.selectedStations.add(station);
                    }
                }
                if (this.stationList.size() == 1) {
                    this.selectedStations.clear();
                    this.selectedStations.add((NamedStationImpl)this.stationList.get(0));
                    this.updateStationLabel();
                }
                this.updateSelectedStations();
                this.loadData();
                this.currentTable = newTable;
            }
            if (this.selectedStations.size() == 0 && this.productType != null && (lastStations = this.stationsForProduct.get(this.productType.getId())) != null) {
                this.selectedStations = new ArrayList<NamedStationImpl>(lastStations);
                this.updateSelectedStations();
            }
            this.products = this.productType != null && this.haveSelectedStations() ? this.dataSource.readProducts(this.productType, this.selectedStations, this.getDateSelection()) : new ArrayList<Product>();
            this.products = Misc.sort(this.products);
            ArrayList<DateTime> dateTimes = new ArrayList<DateTime>();
            for (Product product : this.products) {
                if (product.getDate() == null) continue;
                dateTimes.add(new DateTime(product.getDate()));
            }
            this.ignoreTimeChanges = true;
            if (dateTimes.size() > 0) {
                this.getAnimationWidget().setBaseTimes(Util.makeTimeSet(dateTimes));
                this.getAnimationWidget().gotoEnd();
            } else {
                this.getAnimationWidget().setBaseTimes(null);
            }
            this.ignoreTimeChanges = false;
            if (this.products.size() == 0) {
                this.setText("No products found", false);
            } else {
                this.setText(this.products.get(this.products.size() - 1).getContent(), true);
            }
        }
        catch (Exception exc) {
            TextProductControl.logException("Error updating product text", exc);
        }
    }

    private DateSelection getDateSelection() {
        long hours = this.getHours();
        if (hours == -1L) {
            return new DateSelection(true, 1);
        }
        if (hours == 0L) {
            return new DateSelection(true);
        }
        int count = Integer.MAX_VALUE;
        DateSelection dateSelection = new DateSelection(2, -DateUtil.hoursToMillis(hours), 1, 0.0);
        dateSelection.setNowTime(new Date());
        return dateSelection;
    }

    private String convertToHtml(String text) {
        int i;
        if (this.allPattern == null) {
            try {
                List<String> tmp = StringUtil.split(IOUtil.readContents("/ucar/unidata/idv/control/nwsglossary.txt", this.getClass()), "\n", true, true);
                StringBuffer pattern = new StringBuffer("([ ]+)(");
                for (String word : tmp) {
                    if (word.length() <= 3) continue;
                    word = word.toUpperCase();
                    word = word.replace("(", "\\(");
                    word = word.replace(")", "\\)");
                    word = word.replace("+", "\\+");
                    word = word.replace(".", "\\.");
                    word = word.replace("*", "\\*");
                    pattern.append(word);
                    pattern.append("|");
                }
                pattern.append(")([\\. ]+)");
                this.allPattern = Pattern.compile(pattern.toString());
            }
            catch (Exception exc) {
                TextProductControl.logException("Reading glossary", exc);
            }
        }
        for (NamedStationImpl station : this.selectedStations) {
            text = text.replace(" " + station.getID() + " ", " <b>" + station.getID() + "</b> ");
        }
        text = text.replaceAll("\r", "");
        text = text.replaceAll("[\n]+\\.([^\\.\n]+)\\.\\.\\.[\\s]*", "\n<div style=\"background-color:#c3d9ff; font-weight: bold; padding-left:2px; padding-top:2px;margin-top:15px;\">$1</div>\n");
        text = text.replaceAll("\n+\\&\\&[\\s]*\n", "\n\n");
        text = text.replaceAll("\n\\=\\=[\\s]*\n", "<hr>");
        text = text.replaceAll("\n\\=[\\s]*\n", "\n");
        text = text.replaceAll("\n\\$\\$[\\s]*\n", "<hr>");
        text = text.replaceAll("([^\\.]+)\\.[ ]+\n", "$1.<p>");
        text = text.replaceAll("\n+<", "<");
        text = text.replaceAll(">\n+", ">");
        text = text.replaceAll("<p><div", "<div");
        String[] icons = new String[]{"partlycloudy.png", "partlycloudy.png", "cloudy.png", "cloudy.png", "partlysunny.png", "sunny.png", "rainy.png", "rainy.png"};
        String[] patterns = new String[]{"PARTLY CLOUDY", "PTCLDY", "MOSTLY CLOUDY", "MOCLDY", "PARTLY SUNNY", "SUNNY", "RAIN SHOWERS", "SHWRS"};
        for (i = 0; i < icons.length; ++i) {
            text = text.replace(patterns[i], "PATTERN" + i + "<img src=idvresource:/ucar/unidata/idv/control/images/" + icons[i] + ">");
        }
        for (i = 0; i < icons.length; ++i) {
            text = text.replace("PATTERN" + i, patterns[i]);
        }
        if (this.getShowGlossary()) {
            text = this.allPattern.matcher(text).replaceAll("$1<a href=\"$2\">$2</a>$3");
        }
        text = text.replace("\\s+\n", "<p>");
        text = text.replace("\n", "<br>");
        text = "<text>" + text + "</html>";
        return text;
    }

    public static void main(String[] args) throws Exception {
        String text = IOUtil.readContents(args[0], TextProductControl.class);
        text = text.replaceAll("\r", "");
        System.out.println(text);
    }

    private boolean haveSelectedStations() {
        return this.selectedStations.size() > 0;
    }

    protected void setText(String newText, boolean fromProduct) {
        this.currentText = newText;
        String html = "";
        String text = "";
        if (this.productType == null) {
            fromProduct = false;
            text = "Please select a product";
            html = "Please select a product";
        } else if (!this.haveSelectedStations()) {
            if (this.selectedStationIds != null && this.selectedStationIds.size() > 0) {
                text = "";
                html = "";
                fromProduct = false;
            } else {
                text = "Please select a station";
                html = "Please select a station";
                fromProduct = false;
            }
        } else {
            text = newText;
            String key = this.getShowGlossary() + "_" + newText;
            html = (String)this.htmlCache.get(key);
            if (html == null) {
                long t1 = System.currentTimeMillis();
                html = this.productType.getRenderAsHtml() ? this.convertToHtml(newText) : newText;
                long t2 = System.currentTimeMillis();
                this.htmlCache.put(key, html);
            }
        }
        final String finalText = text;
        final String finalHtml = html;
        final boolean finalFromProduct = fromProduct;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextProductControl.this.htmlComp.setText("");
                if (finalFromProduct && TextProductControl.this.productType != null) {
                    if (TextProductControl.this.productType.getRenderAsHtml()) {
                        TextProductControl.this.htmlComp.setFont(TextProductControl.this.htmlFont);
                        TextProductControl.this.htmlComp.setContentType("text/html");
                        TextProductControl.this.showGlossaryCbx.setEnabled(true);
                    } else {
                        TextProductControl.this.htmlComp.setFont(TextProductControl.this.fixedFont);
                        TextProductControl.this.htmlComp.setContentType("text");
                        TextProductControl.this.showGlossaryCbx.setEnabled(false);
                    }
                } else {
                    TextProductControl.this.htmlComp.setFont(TextProductControl.this.htmlFont);
                    TextProductControl.this.htmlComp.setContentType("text/html");
                    TextProductControl.this.showGlossaryCbx.setEnabled(false);
                }
                TextProductControl.this.textComp.setText(finalText);
                TextProductControl.this.htmlComp.setText(finalHtml);
                TextProductControl.this.textComp.setCaretPosition(0);
                TextProductControl.this.textComp.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                TextProductControl.this.htmlComp.setCaretPosition(0);
                TextProductControl.this.htmlComp.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            if (this.ignoreTimeChanges) {
                return;
            }
            int idx = this.getInternalAnimation().getCurrent();
            if (idx >= 0 && idx < this.products.size()) {
                this.setText(this.products.get(idx).getContent(), true);
            } else {
                this.setText("", false);
            }
        }
        catch (Exception exc) {
            TextProductControl.logException("Error setting time", exc);
        }
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        ArrayList dataSources = new ArrayList();
        dataChoice.getDataSources(dataSources);
        if (dataSources.size() != 1) {
            TextProductControl.userMessage("Could not find Text Product  Data Source");
            return false;
        }
        if (!(dataSources.get(0) instanceof TextProductDataSource)) {
            TextProductControl.userMessage("Could not find Text Product  Data Source");
            return false;
        }
        this.dataSource = (TextProductDataSource)dataSources.get(0);
        this.productGroups = this.dataSource.getProductGroups();
        return super.init(dataChoice);
    }

    public void setDisplayType(String type) {
        this.displayType = type;
    }

    public String getDisplayType() {
        if (this.textTabbedPane != null) {
            String tabText = this.textTabbedPane.getTitleAt(this.textTabbedPane.getSelectedIndex());
            return tabText.equalsIgnoreCase(HTML_TYPE) ? HTML_TYPE : TEXT_TYPE;
        }
        return this.displayType;
    }

    public void setProductType(ProductType value) {
        this.productType = value;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public void setSelectedStationIds(List<String> value) {
        this.selectedStationIds = value;
    }

    public List<String> getSelectedStationIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (NamedStationImpl station : this.selectedStations) {
            ids.add(station.getID());
        }
        return ids;
    }

    public void setHours(int value) {
        this.hours = value;
    }

    public int getHours() {
        TwoFacedObject tfo;
        if (this.dateSelectionCbx != null && (tfo = (TwoFacedObject)this.dateSelectionCbx.getSelectedItem()) != null) {
            this.hours = new Integer(tfo.getId().toString());
        }
        return this.hours;
    }

    public void setShowGlossary(boolean value) {
        this.showGlossary = value;
    }

    public boolean getShowGlossary() {
        if (this.showGlossaryCbx != null) {
            this.showGlossary = this.showGlossaryCbx.isSelected();
        }
        return this.showGlossary;
    }
}

