/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.ScrollPane;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FormView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.AppletFrame;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.ui.FineLineBorder;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.visad.display.CompositeDisplayable;
import visad.VisADException;

public class TextDisplayControl
extends DisplayControlImpl
implements HyperlinkListener,
MouseMotionListener,
MouseListener {
    public static final String SHARE_URL = "TextDisplayControl.SHARE_URL";
    public static final String TAG_INTERNALIMAGE = "intimg";
    public static final String TAG_VIEW = "view";
    public static final String TAG_DISPLAY = "display";
    public static final String TAG_APPLET = "applet";
    public static final String TAG_COMPONENT = "component";
    public static final int DEFAULT_WIDTH = 450;
    public static final int DEFAULT_HEIGHT = 200;
    public static final Dimension EDITOR_PREFERRRED_SIZE = new Dimension(100, 200);
    public static final Dimension SCROLLPANE_PREFERRRED_SIZE = new Dimension(450, 200);
    private long lastTimeSettingMouseOverLabel = 0L;
    private List displayControls;
    String filename;
    ArrayList history = new ArrayList();
    ArrayList glyphHistory = new ArrayList();
    Vector colorList;
    private List glyphs = new ArrayList();
    private PolyGlyph currentGlyph = null;
    JComboBox glyphWidthBox;
    JComboBox colorBox;
    int historyIdx = -1;
    private JLabel mouseOverLabel = new JLabel("     ");
    private JButton fBtn;
    private JButton bBtn;
    private MyEditorPane editor;
    CompositeDisplayable displayHolder;
    private ScrollPane scroller;
    private JScrollPane jscroller;
    private JTextField urlField = new JTextField();
    private MyEditorPane legendEditor;
    private JLabel sideLegendReadout;
    private boolean showHtmlInLegend = false;
    boolean didone = false;
    private HTMLEditorKit editorKit;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (this.history.size() > 0) {
            if (this.history.get(this.historyIdx) != "file:null") {
                this.filename = (String)this.history.get(this.historyIdx);
            }
            this.setFieldUrl(this.filename);
            this.checkHistory();
        } else {
            if (dataChoice == null || !this.setData(dataChoice)) {
                this.displayHolder = new CompositeDisplayable();
                this.displayHolder.setUseTimesInAnimation(this.getUseTimesInAnimation());
                this.addDisplayable(this.displayHolder);
                return true;
            }
            this.filename = dataChoice.getStringId();
            this.goToUrl(this.filename);
        }
        this.displayHolder = new CompositeDisplayable();
        this.displayHolder.setUseTimesInAnimation(this.getUseTimesInAnimation());
        this.addDisplayable(this.displayHolder);
        return true;
    }

    @Override
    protected String getTitle() {
        if (this.filename != null) {
            return this.filename;
        }
        return super.getTitle();
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.urlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fieldUrl = TextDisplayControl.this.getFieldUrl().trim();
                if (!TextDisplayControl.this.getCurrentUrl().equals(fieldUrl)) {
                    TextDisplayControl.this.click(fieldUrl, true);
                }
            }
        });
        this.fBtn = GuiUtils.getImageButton("/ucar/unidata/idv/control/images/Forward16.gif", this.getClass());
        this.fBtn.setToolTipText("Forward");
        this.bBtn = GuiUtils.getImageButton("/ucar/unidata/idv/control/images/Back16.gif", this.getClass());
        this.bBtn.setToolTipText("Back");
        this.checkHistory();
        this.fBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextDisplayControl.this.history(1);
            }
        });
        this.bBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextDisplayControl.this.history(-1);
            }
        });
        this.scroller = new ScrollPane(1){

            @Override
            public void doLayout() {
                if (System.currentTimeMillis() - TextDisplayControl.this.lastTimeSettingMouseOverLabel < 1000L) {
                    return;
                }
                super.doLayout();
            }
        };
        this.glyphWidthBox = new JComboBox(new Vector(Misc.newList(new Float(1.0), new Float(2.0), new Float(3.0), new Float(4.0))));
        this.initColors();
        this.colorBox = new JComboBox(this.colorList);
        JPanel drawingPanel = GuiUtils.hflow(Misc.newList(new JLabel("Width: "), this.glyphWidthBox, new JLabel("Color: "), this.colorBox));
        boolean doJScroller = false;
        this.editor = new MyEditorPane();
        this.editor.setEditable(false);
        this.editor.addHyperlinkListener(this);
        this.editor.setContentType("text/html");
        this.editor.setEditorKit(this.getEditorKit());
        this.editor.addMouseMotionListener(this);
        this.editor.addMouseListener(this);
        this.legendEditor = new MyEditorPane();
        this.legendEditor.setEditable(false);
        this.legendEditor.addHyperlinkListener(this);
        this.legendEditor.setContentType("text/html");
        this.legendEditor.setEditorKit(this.getEditorKit());
        this.legendEditor.addMouseMotionListener(this);
        this.legendEditor.addMouseListener(this);
        this.processUrl(this.filename, true, false);
        if (!doJScroller) {
            this.scroller.add(this.editor);
        }
        this.editor.setPreferredSize(EDITOR_PREFERRRED_SIZE);
        this.legendEditor.setPreferredSize(EDITOR_PREFERRRED_SIZE);
        if (doJScroller) {
            this.jscroller = new JScrollPane(this.editor, 20, 30);
            JViewport vp = this.jscroller.getViewport();
            vp.setViewSize(new Dimension(450, 200));
        } else {
            this.scroller.setSize(SCROLLPANE_PREFERRRED_SIZE);
        }
        JButton goBtn = GuiUtils.makeButton("Go:", this, "reload");
        JButton reloadBtn = GuiUtils.getImageButton("/ucar/unidata/idv/control/images/Refresh16.gif", this.getClass());
        reloadBtn.setToolTipText("Reload page");
        reloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextDisplayControl.this.reload();
            }
        });
        JButton viewSrcBtn = GuiUtils.getImageButton("/ucar/unidata/idv/control/images/Source16.gif", this.getClass());
        viewSrcBtn.setToolTipText("View source");
        viewSrcBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextDisplayControl.this.viewSource();
            }
        });
        JPanel historyPanel = GuiUtils.hbox(Misc.newList(this.bBtn, this.fBtn));
        JPanel urlPanel = GuiUtils.hbox((Component)goBtn, (Component)this.urlField, (Component)reloadBtn, viewSrcBtn);
        JPanel controls = GuiUtils.hbox(Misc.newList(historyPanel, new JLabel("  "), urlPanel));
        if (this.shouldBeDrawing()) {
            controls = GuiUtils.vbox((Component)controls, GuiUtils.left(drawingPanel));
        }
        if (doJScroller) {
            return GuiUtils.topCenter(controls, this.jscroller);
        }
        return GuiUtils.topCenter(controls, this.scroller);
    }

    private void initColors() {
        this.colorList = new Vector();
        this.colorList.add(new TwoFacedObject((Object)"black", Color.black));
        this.colorList.add(new TwoFacedObject((Object)"blue", Color.blue));
        this.colorList.add(new TwoFacedObject((Object)"cyan", Color.cyan));
        this.colorList.add(new TwoFacedObject((Object)"dark gray", Color.darkGray));
        this.colorList.add(new TwoFacedObject((Object)"gray", Color.gray));
        this.colorList.add(new TwoFacedObject((Object)"green", Color.green));
        this.colorList.add(new TwoFacedObject((Object)"light gray", Color.lightGray));
        this.colorList.add(new TwoFacedObject((Object)"magenta", Color.magenta));
        this.colorList.add(new TwoFacedObject((Object)"orange", Color.orange));
        this.colorList.add(new TwoFacedObject((Object)"pink", Color.pink));
        this.colorList.add(new TwoFacedObject((Object)"red", Color.red));
        this.colorList.add(new TwoFacedObject((Object)"yellow", Color.yellow));
        this.colorList.add(new TwoFacedObject((Object)"white", Color.white));
    }

    private boolean shouldBeDrawing() {
        return false;
    }

    private float getGlyphLineWidth() {
        return ((Float)this.glyphWidthBox.getSelectedItem()).floatValue();
    }

    private Color getGlyphColor() {
        return (Color)((TwoFacedObject)this.colorBox.getSelectedItem()).getId();
    }

    private void paintEditor(Graphics g) {
        if (!this.shouldBeDrawing()) {
            return;
        }
        for (int i = 0; i < this.glyphs.size(); ++i) {
            PolyGlyph glyph = (PolyGlyph)this.glyphs.get(i);
            glyph.paint(g);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.shouldBeDrawing()) {
            return;
        }
        if (this.currentGlyph == null) {
            this.currentGlyph = new PolyGlyph(this.getGlyphLineWidth(), this.getGlyphColor());
            this.glyphs.add(this.currentGlyph);
        }
        this.currentGlyph.addPoint(e.getX(), e.getY());
        this.editor.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.currentGlyph != null) {
            this.currentGlyph = null;
            this.editor.repaint();
        }
    }

    private void viewSource() {
        JTextArea t = new JTextArea(this.editor.getText());
        JScrollPane sp = new JScrollPane(t, 20, 30);
        sp.setPreferredSize(new Dimension(400, 500));
        final JFrame f = new JFrame("File: " + this.filename);
        JButton btn = new JButton("Close");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                f.dispose();
            }
        });
        JPanel contents = GuiUtils.centerBottom(sp, GuiUtils.wrap(btn));
        GuiUtils.packWindow(f, contents, true);
    }

    public void reload() {
        this.click(this.getFieldUrl(), false);
    }

    public void print(Element elem, String tab) {
        AttributeSet attrs = elem.getAttributes();
        System.err.println(tab + "Tag: " + attrs.getAttribute(StyleConstants.NameAttribute));
        Enumeration<?> names = attrs.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name.equals(StyleConstants.NameAttribute)) continue;
            System.err.println("  " + tab + "" + name + " =" + attrs.getAttribute(name));
        }
        System.err.println(tab + "children:");
        for (int i = 0; i < elem.getElementCount(); ++i) {
            this.print(elem.getElement(i), tab + "  ");
        }
        System.err.println(tab + "done children");
    }

    boolean hasEndTag(Element elem) {
        AttributeSet attrs = elem.getAttributes();
        Enumeration<?> names = attrs.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (!name.toString().equals("endtag")) continue;
            return true;
        }
        return false;
    }

    private HTMLEditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.editorKit = new HTMLEditorKit(){

                @Override
                public ViewFactory getViewFactory() {
                    return new MyHTMLFactory();
                }

                public String toString() {
                    return "MyEditorKit";
                }

                class MyHTMLFactory
                extends HTMLEditorKit.HTMLFactory {
                    MyHTMLFactory() {
                    }

                    @Override
                    public View create(Element elem) {
                        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
                        if (o.toString().equals(TextDisplayControl.TAG_VIEW)) {
                            return new ViewWrapper(elem);
                        }
                        if (o.toString().equals(TextDisplayControl.TAG_INTERNALIMAGE)) {
                            return new ImageWrapper(elem);
                        }
                        if (o.toString().equals(TextDisplayControl.TAG_DISPLAY)) {
                            return new DisplayWrapper(elem);
                        }
                        if (o.toString().equals(TextDisplayControl.TAG_COMPONENT)) {
                            return new ComponentWrapper(elem);
                        }
                        if (o.toString().equals(TextDisplayControl.TAG_APPLET)) {
                            if (TextDisplayControl.this.hasEndTag(elem)) {
                                return super.create(elem);
                            }
                            Element parent = elem;
                            while (parent.getParentElement() != null) {
                                parent = parent.getParentElement();
                            }
                            if (!TextDisplayControl.this.didone) {
                                TextDisplayControl.this.didone = true;
                                System.err.println("Applet:");
                                TextDisplayControl.this.print(parent, "    ");
                            }
                            return new AppletWrapper(elem);
                        }
                        if (o.equals(HTML.Tag.INPUT)) {
                            return new FormWrapper(elem);
                        }
                        return super.create(elem);
                    }
                }
            };
        }
        return this.editorKit;
    }

    public ArrayList getHistory() {
        return this.history;
    }

    public void setHistory(ArrayList h) {
        this.history = h;
    }

    public ArrayList getGlyphHistory() {
        return this.glyphHistory;
    }

    public void setGlyphHistory(ArrayList h) {
        this.glyphHistory = h;
    }

    public void setGlyphs(List value) {
        this.glyphs = value;
    }

    public List getGlyphs() {
        return this.glyphs;
    }

    public int getHistoryIdx() {
        return this.historyIdx;
    }

    public void setHistoryIdx(int h) {
        this.historyIdx = h;
    }

    protected Component doMakeMainButtonPanel() {
        JButton removeControl = this.doMakeRemoveControl("Remove this " + this.getDisplayName());
        this.mouseOverLabel.setBorder(new FineLineBorder(1));
        JPanel buttonPanel = GuiUtils.centerRight(this.mouseOverLabel, removeControl);
        return GuiUtils.inset((Component)buttonPanel, 2);
    }

    public void processForm(String action, String data) {
        if (action == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(data, "&");
        String root = this.getRootPath();
        if (root == null) {
            root = ".";
        } else if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        action = StringUtil.replace(action, "%HTMLROOT%", root);
        try {
            while (tok.hasMoreTokens()) {
                String nameValue = tok.nextToken();
                int idx = nameValue.indexOf("=");
                if (idx < 0) continue;
                nameValue = URLDecoder.decode(nameValue, "UTF-8");
                action = StringUtil.replace(action, "%" + nameValue.substring(0, idx).trim() + "%", nameValue.substring(idx + 1));
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new WrapperException(uee);
        }
        if (this.processByTheIdv(action)) {
            return;
        }
        try {
            String result = Misc.doPost(action, data);
            if (result == null) {
                LogUtil.userMessage("Unable to post form to: " + action);
            } else {
                this.editor.setText(result.toString());
                this.legendEditor.setText(result.toString());
                this.goToUrl(action);
            }
        }
        catch (Exception exc) {
            TextDisplayControl.logException("Posting form", exc);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e.getURL() == null) {
                this.click(e.getDescription(), true);
            } else {
                this.click(e.getURL().toString(), true);
            }
        } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            String desc = StringUtil.replace(StringUtil.replace(e.getDescription(), "idv:", ""), "idv.", "");
            this.lastTimeSettingMouseOverLabel = System.currentTimeMillis();
            this.mouseOverLabel.setText(desc);
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.lastTimeSettingMouseOverLabel = System.currentTimeMillis();
            this.mouseOverLabel.setText("                  ");
        }
    }

    public String getRootPath() {
        int idx;
        if (this.filename != null && (idx = this.filename.lastIndexOf("/")) >= 0) {
            return this.filename.substring(0, idx + 1);
        }
        return null;
    }

    public void click(String linkText, boolean doHistory) {
        this.click(linkText, doHistory, true);
    }

    public void click(String linkText, boolean doHistory, boolean andShare) {
        URL url;
        block9: {
            this.lastTimeSettingMouseOverLabel = 0L;
            url = null;
            try {
                url = new URL(linkText);
            }
            catch (Exception e) {
                String root = this.getRootPath();
                if (root == null) break block9;
                try {
                    url = new URL(root + linkText);
                }
                catch (Exception e2) {
                    try {
                        url = new URL("file:" + root + linkText);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (url == null) {
            try {
                url = new URL("file:" + linkText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.processUrl(url, doHistory, andShare);
    }

    private void processUrl(String linkText, boolean doHistory, boolean andShare) {
        URL url = null;
        try {
            url = new URL(linkText);
        }
        catch (Exception e) {
            try {
                url = new URL("file:" + linkText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.processUrl(url, doHistory, andShare);
    }

    private void processUrl(URL url, boolean doHistory, boolean andShare) {
        if (this.getHaveInitialized() && this.processByTheIdv(url.toString())) {
            return;
        }
        try {
            this.clearViewManagers();
            this.clearDisplayControls();
        }
        catch (Exception exc) {
            TextDisplayControl.logException("Clearing display controls", exc);
        }
        URL currentUrl = this.editor.getPage();
        try {
            this.editor.setPage("file:/some/bad/file/path/to/trick/the/editor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editor.setText("");
        this.editor.setEditorKit(this.getEditorKit());
        try {
            if (IOUtil.isImageFile(url.toString())) {
                this.editor.setText("<img src=\"" + url + "\">");
                this.legendEditor.setText("<img src=\"" + url + "\">");
            } else {
                File dir = this.getDirectory(url.toString());
                if (dir != null) {
                    dir = dir.getAbsoluteFile();
                    StringBuffer sb = new StringBuffer();
                    File[] files = dir.listFiles();
                    File parent = dir.getParentFile();
                    sb.append("<html><body><h2>Index of: " + dir + "</h2><hr>\n");
                    if (parent != null) {
                        sb.append("<a href=\"file:" + parent + "\">Up to higher level directory</a><p>");
                    }
                    sb.append("<table>");
                    if (files != null) {
                        int i;
                        Arrays.sort(files, new Comparator(){

                            public int compare(Object o1, Object o2) {
                                return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
                            }
                        });
                        boolean didone = false;
                        for (i = 0; i < files.length; ++i) {
                            if (!files[i].isDirectory()) continue;
                            if (!didone) {
                                sb.append("<tr><td><b>Directories</b></td></tr>\n");
                            }
                            didone = true;
                            sb.append("<tr  valign=\"bottom\"><td>&nbsp;&nbsp;&nbsp;<intimg src=\"/auxdata/ui/icons/Folder.gif\"> <a href=\"file:" + files[i] + "\">" + IOUtil.getFileTail(files[i].toString()) + "</a></td><td></td></tr>\n");
                        }
                        didone = false;
                        for (i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) continue;
                            if (!didone) {
                                sb.append("<tr><td><b>Files</b></td></tr>\n");
                            }
                            didone = true;
                            long len = files[i].length();
                            String lenStr = len < 1000L ? len + " B" : (int)(len / 1000L) + " KB";
                            sb.append("<tr valign=\"bottom\"><td>&nbsp;&nbsp;&nbsp;<intimg src=\"/auxdata/ui/icons/File.gif\"> <a href=\"file:" + files[i] + "\">" + IOUtil.getFileTail(files[i].toString()) + "</a></td><td align=\"right\"><b>" + lenStr + "</b></td></tr>\n");
                        }
                    }
                    sb.append("</table></body></html>");
                    this.editor.setText(sb.toString());
                    this.legendEditor.setText(sb.toString());
                } else {
                    this.editor.setPage(url);
                    this.legendEditor.setPage(url);
                }
            }
        }
        catch (Exception e) {
            TextDisplayControl.logException("Error opening url:" + url, e);
            return;
        }
        this.filename = url.toString();
        if (andShare) {
            this.doShare((Object)SHARE_URL, this.filename);
        }
        this.setTitle(this.filename);
        if (doHistory) {
            this.goToUrl(this.filename);
        } else {
            this.setFieldUrl(this.filename);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    private File getDirectory(String path) {
        String file;
        File dir;
        if (path.startsWith("file:") && (dir = new File(file = path.substring(5))).exists() && dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (dataId.equals(SHARE_URL)) {
            // empty if block
        }
        super.receiveShareData(from, dataId, data);
    }

    @Override
    public String getDisplayName() {
        return "HTML Text Display";
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        super.doRemove();
        this.clearDisplayControls();
    }

    private void clearDisplayControls() throws RemoteException, VisADException {
        if (this.displayControls == null) {
            return;
        }
        for (int i = 0; i < this.displayControls.size(); ++i) {
            ((DisplayControl)this.displayControls.get(i)).doRemove();
        }
        this.displayControls = null;
    }

    private void addDisplayControl(DisplayControl dc) {
        if (this.displayControls == null) {
            this.displayControls = new ArrayList();
        }
        this.displayControls.add(dc);
    }

    private String getFieldUrl() {
        return this.urlField.getText();
    }

    private void setFieldUrl(String url) {
        this.urlField.setText(url);
    }

    public String getCurrentUrl() {
        return (String)this.history.get(this.historyIdx);
    }

    public void history(int delta) {
        this.historyIdx += delta;
        if (this.historyIdx < 0) {
            this.historyIdx = 0;
        } else if (this.historyIdx >= this.history.size()) {
            this.historyIdx = this.history.size() - 1;
        }
        this.checkHistory();
        this.click((String)this.history.get(this.historyIdx), false);
    }

    public void goToUrl(String url) {
        int i = this.historyIdx + 1;
        while (i < this.history.size()) {
            this.history.remove(i);
        }
        if (!(url = url.trim()).startsWith("file:") && new File(url).exists()) {
            url = "file:" + url;
        }
        this.history.add(url);
        ++this.historyIdx;
        this.setFieldUrl(url);
        this.checkHistory();
    }

    private void checkHistory() {
        if (this.fBtn != null) {
            this.bBtn.setEnabled(this.historyIdx > 0);
            this.fBtn.setEnabled(this.historyIdx < this.history.size() - 1);
        }
    }

    private void waitCursor() {
        this.editor.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void normalCursor() {
        this.editor.setCursor(Cursor.getPredefinedCursor(0));
    }

    private boolean processByTheIdv(String action) {
        if (this.getDirectory(action) != null) {
            return false;
        }
        int idx = (action = action.trim()).indexOf("jython:");
        if (idx >= 0) {
            action = action.substring(idx);
        } else if (IOUtil.isHtmlFile(action) || IOUtil.isTextFile(action) || IOUtil.isImageFile(action)) {
            return false;
        }
        final String theAction = action;
        Misc.run(new Runnable(){

            @Override
            public void run() {
                TextDisplayControl.this.waitCursor();
                try {
                    TextDisplayControl.this.getControlContext().handleAction(theAction, null);
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Decoding file:" + theAction, exc);
                }
                TextDisplayControl.this.normalCursor();
            }
        });
        return true;
    }

    @Override
    public void writeTestArchive(String archiveName) {
        try {
            archiveName = archiveName + "_" + this.getDisplayId();
            String guiImageFile = archiveName + "_editor.jpg";
            this.toFront();
            Misc.sleep(200L);
            System.err.println("Writing image:" + guiImageFile);
            ImageUtils.writeImageToFile(this.editor, guiImageFile);
            super.writeTestArchive(archiveName);
        }
        catch (Exception exc) {
            TextDisplayControl.logException("writing image", exc);
        }
    }

    public boolean getShowSideLegend() {
        return true;
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        if (this.sideLegendReadout == null) {
            this.sideLegendReadout = new JLabel("<html><br></html>");
        }
        this.setShowHtmlInLegend(this.showHtmlInLegend);
        return GuiUtils.vbox(parentComp, this.sideLegendReadout, this.legendEditor);
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        ViewManager viewManager = this.getViewManager();
        items.add("separator");
        items.add(GuiUtils.makeCheckboxMenuItem("Show Html In Legend", this, "showHtmlInLegend", null));
        if (forMenuBar) {
            JMenu hovMenu = viewManager.makeViewMenu();
            hovMenu.setText("Text/Html View");
            items.add(hovMenu);
        }
    }

    public boolean getShowHtmlInLegend() {
        return this.showHtmlInLegend;
    }

    public void setShowHtmlInLegend(boolean value) {
        this.showHtmlInLegend = value;
        if (this.sideLegendReadout != null) {
            this.legendEditor.setVisible(value);
            this.sideLegendReadout.setVisible(value);
        }
        this.updateLegendLabel();
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties, List preSelectedDataChoices) {
        super.initAfterUnPersistence(vc, properties, preSelectedDataChoices);
        try {
            this.reload();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MyEditorPane
    extends JEditorPane {
        @Override
        public void paint(Graphics g) {
            super.paint(g);
            TextDisplayControl.this.paintEditor(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension min;
            Dimension d = EDITOR_PREFERRRED_SIZE;
            Component port = this.getPort();
            TextUI ui = this.getUI();
            int prefWidth = d.width;
            int prefHeight = d.height;
            if (!this.getScrollableTracksViewportWidth()) {
                int w = port.getWidth();
                min = ui.getMinimumSize(this);
                if (w != 0 && w < min.width) {
                    prefWidth = min.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                int h = port.getHeight();
                min = ui.getMinimumSize(this);
                if (h != 0 && h < min.height) {
                    prefHeight = min.height;
                }
            }
            if (prefWidth != d.width || prefHeight != d.height) {
                d = new Dimension(prefWidth, prefHeight);
            }
            return d;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Component port = this.getPort();
            TextUI ui = this.getUI();
            int w = port.getWidth();
            Dimension min = ui.getMinimumSize(this);
            Dimension max = ui.getMaximumSize(this);
            return w >= min.width && w <= max.width;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Component port = this.getPort();
            TextUI ui = this.getUI();
            int h = port.getHeight();
            Dimension min = ui.getMinimumSize(this);
            if (h >= min.height) {
                Dimension max = ui.getMaximumSize(this);
                if (h <= max.height) {
                    return true;
                }
            }
            return false;
        }

        private Component getPort() {
            if (this.getParent() instanceof JViewport) {
                return this.getParent();
            }
            return TextDisplayControl.this.scroller;
        }
    }

    class AppletWrapper
    extends ComponentWrapper {
        AppletFrame frame;

        AppletWrapper(Element e) {
            super(e);
        }

        @Override
        protected Component createComponentInner() {
            AttributeSet attrs = this.element.getAttributes();
            Enumeration<?> names = attrs.getAttributeNames();
            int w = 400;
            int h = 300;
            String code = null;
            String codebase = null;
            String baseDir = null;
            Hashtable<String, String> params = new Hashtable<String, String>();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                String sname = name.toString().toLowerCase().trim();
                String value = attrs.getAttribute(name).toString();
                if (sname.equals("code")) {
                    code = value;
                    continue;
                }
                if (sname.equals("width")) {
                    w = new Integer(value);
                    continue;
                }
                if (sname.equals("height")) {
                    h = new Integer(value);
                    continue;
                }
                if (sname.equals("codebase")) {
                    codebase = value;
                    continue;
                }
                params.put(sname, value);
            }
            if (code == null) {
                return new JLabel("No \"code\" attribute given");
            }
            try {
                if (codebase != null) {
                    // empty if block
                }
                Applet a = (Applet)Class.forName(code).newInstance();
                return new AppletFrame(a, w, h, baseDir, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new JLabel("Error: " + code + " " + e.getMessage());
            }
        }
    }

    class ImageWrapper
    extends ComponentWrapper {
        ImageWrapper(Element e) {
            super(e);
        }

        @Override
        protected Component createComponentInner() {
            AttributeSet attrs = this.element.getAttributes();
            Enumeration<?> names = attrs.getAttributeNames();
            String src = null;
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                String value = attrs.getAttribute(name).toString();
                if (!name.toString().trim().equalsIgnoreCase("src")) continue;
                src = value;
                break;
            }
            if (src == null) {
                return new JLabel("no src");
            }
            ImageIcon icon = GuiUtils.getImageIcon(src);
            if (icon == null) {
                return new JLabel("bad image:" + src);
            }
            JLabel lbl = new JLabel(icon);
            lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            lbl.setPreferredSize(new Dimension(icon.getIconHeight(), icon.getIconWidth()));
            return lbl;
        }
    }

    class ComponentWrapper
    extends ComponentView {
        Element element;
        protected Component comp;

        public ComponentWrapper(Element e) {
            super(e);
            this.element = e;
        }

        @Override
        protected Component createComponent() {
            if (this.comp == null) {
                try {
                    this.comp = this.createComponentInner();
                }
                catch (Exception exc) {
                    this.comp = new JLabel("Error:" + exc.getMessage());
                    exc.printStackTrace();
                }
            }
            return this.comp;
        }

        protected Component createComponentInner() {
            return new JLabel("Comp");
        }
    }

    class DisplayWrapper
    extends ComponentView {
        JLabel errorLabel;
        DisplayControlImpl display;
        Element element;

        DisplayWrapper(Element e) {
            super(e);
            this.element = e;
        }

        protected DisplayControlImpl createDisplayControl() {
            StringBuffer properties = new StringBuffer("");
            String displayName = null;
            String dataSourceName = null;
            String paramName = null;
            AttributeSet attrs = this.element.getAttributes();
            Enumeration<?> names = attrs.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                String value = attrs.getAttribute(name).toString();
                if (name.toString().equalsIgnoreCase(TextDisplayControl.TAG_DISPLAY)) {
                    displayName = value;
                    continue;
                }
                if (name.toString().equalsIgnoreCase("data")) {
                    dataSourceName = value;
                    continue;
                }
                if (name.toString().equalsIgnoreCase("param")) {
                    paramName = value;
                    continue;
                }
                properties.append(name.toString());
                properties.append("=");
                properties.append(value);
                properties.append(";");
            }
            if (displayName == null) {
                this.errorLabel = new JLabel("Error: No \"display\" attribute given");
                return null;
            }
            if (dataSourceName == null) {
                this.errorLabel = new JLabel("Error: No \"data\" attribute given");
                return null;
            }
            if (paramName == null) {
                this.errorLabel = new JLabel("Error: No \"param\" attribute given");
                return null;
            }
            properties.append("makeWindow=false;");
            this.display = (DisplayControlImpl)TextDisplayControl.this.getControlContext().createDisplay(dataSourceName, paramName, displayName, properties.toString(), false);
            if (this.display != null) {
                TextDisplayControl.this.addDisplayControl(this.display);
            } else {
                this.errorLabel = new JLabel("Error: Failed to create display of type: " + displayName);
            }
            return this.display;
        }

        @Override
        protected Component createComponent() {
            try {
                if (this.errorLabel != null) {
                    this.errorLabel.setBackground(Color.lightGray);
                    return this.errorLabel;
                }
                if (this.display == null) {
                    this.display = this.createDisplayControl();
                }
                if (this.display == null) {
                    if (this.errorLabel == null) {
                        this.errorLabel = new JLabel("Error creating display");
                    }
                    return this.errorLabel;
                }
                return this.display.getOuterContents();
            }
            catch (Exception exc) {
                DisplayControlBase.logException("TextDisplayControl.createComponent", exc);
                this.errorLabel = new JLabel("Error");
                return this.errorLabel;
            }
        }
    }

    class ViewWrapper
    extends ComponentView {
        ViewManager viewManager;
        Element element;

        ViewWrapper(Element e) {
            super(e);
            this.element = e;
        }

        protected ViewManager createViewManager() {
            AttributeSet attrs = this.element.getAttributes();
            Enumeration<?> names = attrs.getAttributeNames();
            String viewName = "viewmanager";
            StringBuffer properties = new StringBuffer("");
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                String value = attrs.getAttribute(name).toString();
                if (name.toString().equalsIgnoreCase("id")) {
                    viewName = value;
                    continue;
                }
                if (name.toString().equalsIgnoreCase("props")) {
                    if (!value.endsWith(";")) {
                        properties.append(";");
                    }
                    properties.append(value);
                    continue;
                }
                properties.append(name.toString());
                properties.append("=");
                properties.append(value);
                properties.append(";");
            }
            ViewManager viewManager = TextDisplayControl.this.getControlContext().getViewManager(new ViewDescriptor(viewName), false, properties.toString());
            TextDisplayControl.this.addViewManager(viewManager);
            return viewManager;
        }

        @Override
        protected Component createComponent() {
            try {
                if (this.viewManager == null) {
                    this.viewManager = this.createViewManager();
                }
                if (this.viewManager == null) {
                    return null;
                }
                return this.viewManager.getContents();
            }
            catch (Exception exc) {
                DisplayControlBase.logException("TextDisplayControl.createComponent", exc);
                return new JLabel("Error");
            }
        }
    }

    class FormWrapper
    extends FormView {
        public FormWrapper(Element elem) {
            super(elem);
        }

        @Override
        protected void submitData(String data) {
            Element elt;
            for (elt = this.getElement(); elt != null && !elt.getName().equals("form"); elt = elt.getParentElement()) {
            }
            if (elt == null && (elt = this.getElement()) == null) {
                return;
            }
            TextDisplayControl.this.processForm(this.getAction(elt), data);
        }

        public String getAction(Element formElement) {
            AttributeSet formAttr = formElement.getAttributes();
            Enumeration<?> names = formAttr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object obj = names.nextElement();
            }
            String action = (String)formAttr.getAttribute(HTML.Attribute.ACTION);
            if (action == null && (formAttr = (AttributeSet)formAttr.getAttribute(HTML.Tag.FORM)) != null) {
                action = (String)formAttr.getAttribute(HTML.Attribute.ACTION);
                names = formAttr.getAttributeNames();
                while (names.hasMoreElements()) {
                    Object obj = names.nextElement();
                }
            }
            return action;
        }
    }

    public static class PolyGlyph {
        Polygon polygon = new Polygon();
        float width;
        Color color;
        Stroke stroke;

        public PolyGlyph() {
        }

        public PolyGlyph(float width, Color color) {
            this.width = width;
            this.color = color;
        }

        public void paint(Graphics g) {
            g.setColor(this.color == null ? Color.black : this.color);
            if (this.stroke == null) {
                this.stroke = new BasicStroke(this.width);
            }
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(this.stroke);
            }
            g.drawPolyline(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
        }

        public void addPoint(int x, int y) {
            this.polygon.addPoint(x, y);
        }

        public void setColor(Color value) {
            this.color = value;
        }

        public Color getColor() {
            return this.color;
        }

        public void setWidth(float value) {
            this.width = value;
        }

        public float getWidth() {
            return this.width;
        }

        public void setXPoints(int[] value) {
            this.polygon.xpoints = value;
        }

        public int[] getXPoints() {
            return this.polygon.xpoints;
        }

        public void setYPoints(int[] value) {
            this.polygon.ypoints = value;
        }

        public int[] getYPoints() {
            return this.polygon.ypoints;
        }

        public void setNPoints(int value) {
            this.polygon.npoints = value;
        }

        public int getNPoints() {
            return this.polygon.npoints;
        }
    }
}

