/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataTimeRange;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointDataInstance;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.gis.SpatialGrid;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.LayoutModelWidget;
import ucar.unidata.idv.control.ObsDisplayControl;
import ucar.unidata.idv.control.RangeColorPreview;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.idv.control.chart.PointParam;
import ucar.unidata.idv.control.chart.TimeSeriesChart;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.PropertyFilter;
import ucar.unidata.ui.symbol.CloudCoverageSymbol;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.StationModelManager;
import ucar.unidata.ui.symbol.TextSymbol;
import ucar.unidata.ui.symbol.ValueSymbol;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LayoutUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.GlobeDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.StationModelDisplayable;
import visad.CommonUnit;
import visad.Data;
import visad.DisplayEvent;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.Set;
import visad.SetType;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;
import visad.georef.EarthLocation;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;

public class StationModelControl
extends ObsDisplayControl {
    protected static ImageIcon lockIcon;
    protected static ImageIcon unlockIcon;
    private boolean shouldUseAltitude = true;
    private boolean inGlobe = false;
    protected JPanel zPositionPanel;
    private TimeSeriesChart timeSeries;
    private JComponent plotPanel;
    private static final Data DUMMY_DATA;
    private JTable table;
    private JScrollPane tableScroller;
    private Range lastRange;
    private Range timeRange;
    private MyTableModel tableModel;
    private List tableRows = new ArrayList();
    private List chartParams = new ArrayList();
    private EarthLocation lastEarthLocation = null;
    private PointOb currentTableOb;
    private List<PointOb> selectedObs = new ArrayList<PointOb>();
    private PointOb selectedOb;
    private String selectedObId = null;
    private String idFieldName;
    private LatLonPoint selectedObLocation;
    private JLabel selectedObLbl;
    private int idIndex = -1;
    private JButton changeButton;
    protected LayoutModelWidget layoutModelWidget;
    StationModelDisplayable myDisplay;
    private DisplayableData timesHolder = null;
    StationModel stationModel;
    private JPanel sideLegendExtra;
    String modelName;
    private SpatialGrid stationGrid;
    private boolean declutter = true;
    private boolean onlyShowFiltered = true;
    private boolean matchAll = true;
    private boolean filtersEnabled = true;
    protected boolean stationsLocked = false;
    protected List filters = new ArrayList();
    private PropertyFilter.FilterGui filterGui;
    private boolean useLastTime = false;
    private JButton lockBtn;
    private JSlider densitySlider;
    protected List densityComps = new ArrayList();
    protected List timeDeclutterComps = new ArrayList();
    protected FieldImpl lastDeclutteredData;
    protected FieldImpl currentStationData;
    private Rectangle2D lastViewBounds = null;
    private double[] lastRotation;
    private boolean haveSetInitialScale = false;
    private float lastViewScale = -1.0f;
    private float displayableScale = 1.0f;
    private float declutterFilter = 0.8f;
    private JLabel stationLabel;
    private String tmpStationModelName;
    private boolean showAllTimes;
    private boolean waitingToLoad = false;
    private long lastTimeLoadDataWasCalled;
    private Object LOADDATA_MUTEX = new Object();
    private int loadDataTimestamp = 0;
    private Object MUTEX = new Object();
    private JComponent timeDeclutterLeft;
    private JComponent timeDeclutterRight;
    private boolean askedUserToDeclutterTime = false;
    private Range stationModelRange;
    private ColorTable stationModelColorTable;
    private static final String[] TIMES_TO_USE;
    private boolean useDataTimes = true;
    private RangeColorPreview rangeColorPreview = null;
    JTextField kmzWidthFld;
    JTextField kmzHeightFld;
    JTextField kmzNameFld;
    GuiUtils.ColorSwatch kmzColorSwatch;
    private static Color tableDisableColor;
    private final Object DISPLAYABLE_MUTEX = new Object();
    private static final long SLEEPTIME_MS = 200L;

    @Override
    protected boolean canDoProgressiveResolution() {
        return true;
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties) {
        super.initAfterUnPersistence(vc, properties);
        if (!this.useZPosition()) {
            this.shouldUseAltitude = false;
        }
        try {
            this.myDisplay.setShouldUseAltitude(this.shouldUseAltitude);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.stationModel != null) {
            StationModelManager smm = this.getControlContext().getStationModelManager();
            StationModel currentOne = smm.getStationModel(this.stationModel.getName());
            if (currentOne != null) {
                this.stationModel = currentOne;
            } else {
                smm.addStationModel(this.stationModel);
            }
        }
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        String stationModelScale;
        if (this.tmpStationModelName == null && dataChoice != null) {
            String sm;
            this.tmpStationModelName = dataChoice.getProperty("prop.stationmodelname", null);
            if (this.getDataSelection() != null && (sm = (String)this.getDataSelection().getProperty("prop.stationmodelname")) != null) {
                this.tmpStationModelName = sm;
            }
            if (this.tmpStationModelName == null) {
                if (this.getControlContext().getStationModelManager().getStationModel("Default") != null) {
                    this.tmpStationModelName = "Default";
                } else if (this.getControlContext().getStationModelManager().getStationModel("Location") != null) {
                    this.tmpStationModelName = "Location";
                }
            }
        }
        this.myDisplay = this.createStationModelDisplayable();
        if (!this.useZPosition()) {
            this.shouldUseAltitude = false;
        }
        this.inGlobe = this.getNavigatedDisplay() instanceof GlobeDisplay;
        this.initDisplayable(this.myDisplay);
        this.timesHolder = new LineDrawing("ob_time" + dataChoice);
        this.timesHolder.setManipulable(false);
        this.timesHolder.setVisible(false);
        this.addDisplayable(this.timesHolder);
        this.lastViewBounds = null;
        if (dataChoice != null && (stationModelScale = (String)dataChoice.getProperty("prop.stationmodelscale")) != null) {
            this.setDisplayableScale(Float.parseFloat(stationModelScale));
        }
        this.setScaleOnDisplayable();
        this.getControlContext().getStationModelManager().addPropertyChangeListener(this);
        boolean ok = this.setData(dataChoice);
        if (!ok) {
            return false;
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (StationModelControl.this.getHaveInitialized()) {
                    StationModelControl.this.applyFilters();
                }
            }
        };
        this.filterGui = new PropertyFilter.FilterGui(this.filters, this.getFilterNames(), this.filtersEnabled, this.matchAll, listener);
        return ok;
    }

    @Override
    protected void doInitialUpdateLegendAndList() {
    }

    protected void initDisplayable(StationModelDisplayable myDisplay) throws VisADException, RemoteException {
        if (this.inGlobe) {
            myDisplay.setRotateShapes(true);
        }
        myDisplay.setShouldUseAltitude(this.shouldUseAltitude);
    }

    @Override
    public void initDone() {
        super.initDone();
        if (!this.getWasUnPersisted() && this.chartParams == null) {
            this.chartParams = new ArrayList();
        }
        this.loadData();
    }

    @Override
    public boolean isInitDone() {
        if (!super.isInitDone()) {
            return false;
        }
        return !this.waitingToLoad;
    }

    @Override
    public Image getImage(String what) throws Exception {
        if (what != null && what.equals("chart")) {
            this.setMainPanelDimensions();
            if (!this.getIdv().getArgsManager().getIsOffScreen()) {
                GuiUtils.showComponentInTabs(this.getChart().getContents());
            }
            return ImageUtils.getImage(this.getChart().getContents());
        }
        return super.getImage(what);
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    protected JComponent doMakeSideLegendComponent() {
        JComponent legendComp = super.doMakeSideLegendComponent();
        this.sideLegendExtra = new JPanel();
        this.sideLegendExtra.setLayout(new BoxLayout(this.sideLegendExtra, 1));
        this.fillSideLegend();
        return GuiUtils.centerBottom(legendComp, this.sideLegendExtra);
    }

    private void fillSideLegend() {
        if (this.sideLegendExtra == null) {
            return;
        }
        Range newRange = null;
        ColorTable newColorTable = null;
        try {
            this.sideLegendExtra.removeAll();
            if (this.stationModel == null) {
                this.stationModelRange = null;
                this.stationModelColorTable = null;
                return;
            }
            this.sideLegendExtra.add(GuiUtils.left(new JLabel("Layout model:" + this.stationModel.getDisplayName())));
            List<Object[]> ctComps = new ArrayList();
            Iterator iter = this.stationModel.iterator();
            while (iter.hasNext()) {
                MetSymbol metSymbol = (MetSymbol)iter.next();
                ColorTable ct = metSymbol.getColorTable();
                Range range = metSymbol.getColorTableRange();
                if (ct != null && this.stationModelColorTable == null && range != null) {
                    newColorTable = ct;
                    newRange = range;
                }
                String param = metSymbol.getColorTableParam();
                if (ct == null || param == null) continue;
                this.rangeColorPreview = new RangeColorPreview(ct.getColorList(), this.getDisplayConventions(), param.equalsIgnoreCase("time"));
                this.rangeColorPreview.setRange(range);
                Rectangle b = metSymbol.getBounds();
                ctComps.add(new Object[]{new Integer(b.y), GuiUtils.topCenter(GuiUtils.left(new JLabel(param + ":")), this.rangeColorPreview.doMakeContents())});
            }
            ctComps = Misc.sortTuples(ctComps, true);
            for (Object[] pair : ctComps) {
                this.sideLegendExtra.add((Component)pair[1]);
            }
            GuiUtils.setFontOnTree(this.sideLegendExtra, GuiUtils.buttonFont.deriveFont(10.0f));
            this.sideLegendExtra.validate();
            this.sideLegendExtra.repaint();
            if (!Misc.equals(newRange, this.stationModelRange) || !Misc.equals(newColorTable, this.stationModelColorTable)) {
                this.stationModelRange = newRange;
                this.stationModelColorTable = newColorTable;
                this.applyColorTable();
                this.applyRange();
            }
        }
        catch (Exception exc) {
            StationModelControl.logException("Creating color table previews", exc);
        }
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            this.getChart().timeChanged();
            this.updateTimes();
            this.applyTimeRange();
        }
        catch (Exception exc) {
            StationModelControl.logException("Property change", exc);
        }
        super.timeChanged(time);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("prop.resourcechange")) {
            StationModel changedModel = (StationModel)evt.getNewValue();
            this.handleChangedStationModel(changedModel);
        } else if (evt.getPropertyName().equals("prop.resourceremove")) {
            StationModel changedModel = (StationModel)evt.getOldValue();
            if (this.stationModel.getName().equals(changedModel.getName())) {
                this.handleStationModelChange();
            }
        }
        super.propertyChange(evt);
    }

    protected void handleChangedStationModel(StationModel changedModel) {
        if (this.stationModel.getName().equals(changedModel.getName())) {
            this.setStationModel(changedModel);
        }
    }

    private void handleStationModelChange() {
        StationModel changedModel = null;
        if (this.stationModel != null) {
            changedModel = this.getControlContext().getStationModelManager().getStationModel(this.stationModel.getName());
        }
        if (changedModel != null) {
            if (changedModel != this.stationModel) {
                this.setStationModel(changedModel);
            }
            return;
        }
        this.setStationModel(this.getControlContext().getStationModelManager().getDefaultStationModel());
    }

    private void updateTimes() {
        try {
            FieldImpl theField = this.getCurrentTimeStep(false);
            this.enableTable();
            if (theField == null || this.selectedOb == null) {
                this.disableTable();
                return;
            }
            Set domainSet = theField.getDomainSet();
            int numObs = domainSet.getLength();
            PointOb theOb = null;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < numObs; ++i) {
                PointOb ob;
                Data tmp = theField.getSample(i);
                if (!(tmp instanceof PointOb) || !this.isSelected(ob = (PointOb)tmp)) continue;
                theOb = ob;
                break;
            }
            if (theOb == null) {
                this.disableTable();
                return;
            }
            this.updateTable(theOb);
        }
        catch (Exception e) {
            StationModelControl.logException("Updating times", e);
        }
    }

    private void disableTable() {
        if (this.table != null) {
            this.table.setBackground(tableDisableColor);
            this.table.repaint();
        }
    }

    private void enableTable() {
        if (this.table != null) {
            this.table.setBackground(Color.white);
        }
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Projection From Observations";
    }

    private void findSelectedObs(FieldImpl theField, List<PointOb> obs) throws VisADException, RemoteException {
        Set domainSet = theField.getDomainSet();
        int numObs = domainSet.getLength();
        boolean cnt = false;
        for (int i = 0; i < numObs; ++i) {
            PointOb ob;
            Data tmp = theField.getSample(i);
            if (!(tmp instanceof PointOb) || !this.isSelected(ob = (PointOb)tmp)) continue;
            obs.add(ob);
        }
    }

    private boolean isSelected(PointOb ob) throws VisADException, RemoteException {
        if (this.selectedObId != null && this.idIndex < 0) {
            this.getId(ob);
        }
        if (this.selectedObId != null && this.idIndex >= 0) {
            Tuple tuple = (Tuple)ob.getData();
            TupleType tupleType = (TupleType)tuple.getType();
            MathType[] types = tupleType.getComponents();
            String obId = tuple.getComponent(this.idIndex).toString();
            return this.selectedObId.equals(obId);
        }
        if (this.selectedObLocation != null) {
            LatLonPoint llp = ob.getEarthLocation().getLatLonPoint();
            return llp.equals(this.selectedObLocation);
        }
        return false;
    }

    private String getId(PointOb ob) throws VisADException, RemoteException {
        String name;
        MathType type;
        this.idFieldName = null;
        this.idIndex = -1;
        if (ob == null) {
            return null;
        }
        Tuple tuple = (Tuple)ob.getData();
        TupleType tupleType = (TupleType)tuple.getType();
        MathType[] types = tupleType.getComponents();
        Object id = null;
        int typeIdx = 0;
        for (typeIdx = 0; typeIdx < types.length; ++typeIdx) {
            type = types[typeIdx];
            if (!(type instanceof TextType) || !this.isIdParam(name = type.toString())) continue;
            this.idFieldName = StringUtil.replace(name, "(Text)", "");
            this.idIndex = typeIdx;
            String putativeId = tuple.getComponent(typeIdx).toString().trim();
            if (putativeId.isEmpty()) continue;
            return tuple.getComponent(typeIdx).toString();
        }
        typeIdx = 0;
        for (typeIdx = 0; typeIdx < types.length; ++typeIdx) {
            type = types[typeIdx];
            if (type instanceof TextType || !this.isIdParam(name = type.toString())) continue;
            this.idIndex = typeIdx;
            this.idFieldName = name;
            return tuple.getComponent(typeIdx).toString();
        }
        return null;
    }

    private List<PointOb> findSelectedObs() throws VisADException, RemoteException {
        ArrayList<PointOb> obs = new ArrayList<PointOb>();
        PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
        if (pdi == null) {
            return obs;
        }
        FieldImpl data = pdi.getTimeSequence();
        if (data == null) {
            return obs;
        }
        boolean isTimeSequence = GridUtil.isTimeSequence(data);
        if (isTimeSequence) {
            Set timeSet = data.getDomainSet();
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)data.getSample(i);
                this.findSelectedObs(oneTime, obs);
            }
        } else {
            this.findSelectedObs(data, obs);
        }
        return obs;
    }

    @Override
    public MapProjection getDataProjection() {
        try {
            PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
            if (pdi == null) {
                return null;
            }
            FieldImpl data = pdi.getPointObs();
            if (data == null) {
                return null;
            }
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            boolean cnt = false;
            boolean isTimeSequence = GridUtil.isTimeSequence(data);
            ArrayList<double[]> boxes = new ArrayList<double[]>();
            if (isTimeSequence) {
                Set timeSet = data.getDomainSet();
                int numTimes = timeSet.getLength();
                for (int i = 0; i < numTimes; ++i) {
                    FieldImpl oneTime = (FieldImpl)data.getSample(i);
                    boxes.add(PointObFactory.getBoundingBoxOneTime(oneTime));
                }
            } else {
                boxes.add(PointObFactory.getBoundingBoxOneTime(data));
            }
            for (int i = 0; i < boxes.size(); ++i) {
                double[] bbox = (double[])boxes.get(i);
                minY = Math.min(bbox[0], minY);
                maxY = Math.max(bbox[0], maxY);
                minY = Math.min(bbox[2], minY);
                maxY = Math.max(bbox[2], maxY);
                minX = Math.min(bbox[1], minX);
                maxX = Math.max(bbox[1], maxX);
                minX = Math.min(bbox[3], minX);
                maxX = Math.max(bbox[3], maxX);
            }
            return Util.makeMapProjection(minY, minX, maxY, maxX);
        }
        catch (Exception exc) {
            StationModelControl.logException("Error reading xml", exc);
            return null;
        }
    }

    @Override
    public void handleDisplayChanged(DisplayEvent evt) {
        try {
            int id = evt.getId();
            InputEvent inputEvent = evt.getInputEvent();
            if (id == 12) {
                this.setScaleOnDisplayable();
            } else if (id == 1 && !inputEvent.isShiftDown()) {
                double[] coords = this.screenToBox(evt.getX(), evt.getY(), this.getZPosition());
                this.lastEarthLocation = this.boxToEarth(coords);
                this.handleMousePressed(this.lastEarthLocation, evt);
            }
        }
        catch (Exception e) {
            StationModelControl.logException("Handling display event changed", e);
        }
    }

    private FieldImpl getCurrentTimeStep(boolean justVisible) throws VisADException, RemoteException {
        FieldImpl data;
        PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
        if (pdi == null) {
            return null;
        }
        FieldImpl fieldImpl = data = justVisible ? this.currentStationData : pdi.getTimeSequence();
        if (data == null) {
            return null;
        }
        boolean isTimeSequence = GridUtil.isTimeSequence(data);
        if (isTimeSequence) {
            return (FieldImpl)data.evaluate(this.getViewAnimation().getAniValue(), 100, 202);
        }
        return data;
    }

    private void setSelectedOb(PointOb ob) throws VisADException, RemoteException {
        this.selectedOb = ob;
        if (ob == null) {
            this.selectedObs = new ArrayList<PointOb>();
            this.selectedObId = null;
            this.selectedObLocation = null;
            this.idIndex = -1;
        } else {
            this.selectedObId = this.getId(ob);
            this.selectedObLocation = ob.getEarthLocation().getLatLonPoint();
            this.selectedObs = this.findSelectedObs();
        }
        this.setXYPlot(this.selectedObs);
        if (this.selectedObLbl == null) {
            return;
        }
        if (this.selectedOb == null) {
            this.selectedObLbl.setText("  ");
            this.getChart().setEmptyChartLabel("Select a station in the main display");
        } else {
            String label;
            if (this.selectedObId != null) {
                label = "Station: " + this.selectedObId;
                if (this.idFieldName != null) {
                    label = label + " (" + this.idFieldName + ")";
                }
            } else {
                label = "Location: " + this.selectedObLocation;
            }
            this.selectedObLbl.setText(label);
            this.getChart().setEmptyChartLabel("Right click on observation in table to add to chart");
        }
        this.updateTable(ob);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleMousePressed(EarthLocation el, DisplayEvent evt) {
        try {
            if (!this.isGuiShown() || !this.getDisplayVisibility()) {
                return;
            }
            PointOb ob = null;
            FieldImpl theField = this.getCurrentTimeStep(true);
            if (theField != null) {
                ob = this.findClosestOb(el, theField);
            }
            this.setSelectedOb(ob);
            if (ob == null) return;
        }
        catch (Exception e) {
            StationModelControl.logException("Handling mouse move event", e);
        }
    }

    protected PointOb findClosestOb(EarthLocation el, FieldImpl theField) throws VisADException, RemoteException {
        if (el == null || theField == null) {
            return null;
        }
        Set domainSet = theField.getDomainSet();
        int numObs = domainSet.getLength();
        PointOb closestOb = null;
        LatLonPoint llp = el.getLatLonPoint();
        Object bearing = null;
        Component comp = this.myDisplay.getDisplayMaster().getDisplayComponent();
        Rectangle bounds = comp.getBounds();
        int[] clickPt = this.boxToScreen(this.earthToBox(el));
        double minDistance = 20.0;
        for (int i = 0; i < numObs; ++i) {
            PointOb ob;
            EarthLocation obEl;
            int[] obScreen;
            double distance;
            Data tmp = theField.getSample(i);
            if (!(tmp instanceof PointOb) || !((distance = GuiUtils.distance(obScreen = this.boxToScreen(this.earthToBox(obEl = (ob = (PointOb)tmp).getEarthLocation())), clickPt)) < minDistance)) continue;
            closestOb = ob;
            minDistance = distance;
        }
        return closestOb;
    }

    protected void updateTable(PointOb ob) {
        this.updateTable(ob, false);
    }

    private void updateTable(PointOb ob, boolean force) {
        if (!force && Misc.equals(ob, this.currentTableOb)) {
            return;
        }
        this.enableTable();
        this.currentTableOb = ob;
        this.tableRows = new ArrayList();
        if (ob == null) {
            if (this.tableModel != null) {
                this.tableModel.fireTableStructureChanged();
            }
            return;
        }
        try {
            Tuple tuple = (Tuple)ob.getData();
            TupleType tupleType = (TupleType)tuple.getType();
            MathType[] types = tupleType.getComponents();
            int[] indices = this.getIndicesToShow(tupleType);
            List cols = this.getFieldsToShow(tupleType);
            for (int colIdx = 0; colIdx < indices.length; ++colIdx) {
                String name = null;
                String value = null;
                int typeIdx = indices[colIdx];
                if (typeIdx != -1) {
                    name = Util.cleanTypeName(types[typeIdx]);
                    Data dataElement = tuple.getComponent(typeIdx);
                    value = this.getColValue(dataElement, types[typeIdx], true).toString();
                    if (value.equals("NaN")) {
                        value = "--";
                    }
                } else {
                    name = cols.get(colIdx).toString();
                    EarthLocation el = ob.getEarthLocation();
                    if (cols.get(colIdx).equals("lat")) {
                        value = this.getColValue(el.getLatitude(), RealType.Latitude, true).toString();
                    } else if (cols.get(colIdx).equals("lon")) {
                        value = this.getColValue(el.getLongitude(), RealType.Longitude, true).toString();
                    } else if (cols.get(colIdx).equals("alt")) {
                        value = this.getColValue(el.getAltitude(), RealType.Altitude, true).toString();
                    } else if (cols.get(colIdx).equals("time")) {
                        value = this.getShowDataRaw() ? Util.formatReal(ob.getDateTime()) : ob.getDateTime().toString();
                    }
                }
                if (value == null) continue;
                ArrayList<String> rowVector = new ArrayList<String>();
                rowVector.add(this.getParamLabel(name));
                rowVector.add(value);
                if (this.isIdParam(name)) {
                    this.tableRows.add(0, rowVector);
                    continue;
                }
                this.tableRows.add(rowVector);
            }
            if (this.tableModel != null) {
                this.table.repaint();
            }
        }
        catch (Exception e) {
            StationModelControl.logException("Updating table", e);
        }
    }

    private PointParam getPointParam(String paramName) {
        for (int i = 0; i < this.chartParams.size(); ++i) {
            PointParam pointParam = (PointParam)this.chartParams.get(i);
            if (!pointParam.getName().equals(paramName)) continue;
            return pointParam;
        }
        return null;
    }

    public void addChartParam(String paramName) {
        PointParam pointParam = this.getPointParam(paramName);
        if (pointParam == null) {
            this.chartParams.add(new PointParam(paramName));
        } else {
            pointParam.getLineState().setVisible(true);
        }
        this.chartChanged();
    }

    public void chartChanged() {
        try {
            this.setXYPlot(this.findSelectedObs());
            this.table.repaint();
        }
        catch (Exception exc) {
            StationModelControl.logException("Removing chart parameter", exc);
        }
    }

    public void removeChartParam(PointParam pointParam) {
        pointParam.getLineState().setVisible(false);
        this.chartChanged();
    }

    public void toFront(PointParam pointParam) {
        this.chartParams.remove(pointParam);
        this.chartParams.add(0, pointParam);
        this.chartChanged();
    }

    private void setXYPlot(List<PointOb> obs) throws VisADException, RemoteException {
        this.getChart().setPointObs(obs, this.chartParams);
    }

    @Override
    public void firstFrameDone() {
        super.firstFrameDone();
        this.loadDataInAWhile();
    }

    protected StationModelDisplayable createStationModelDisplayable() throws VisADException, RemoteException {
        this.myDisplay = new StationModelDisplayable(this.getStationModel(), this.getControlContext().getJythonManager());
        this.addDisplayable((Displayable)this.myDisplay, 1160);
        return this.myDisplay;
    }

    @Override
    public Range getRangeToApply() throws RemoteException, VisADException {
        return this.stationModelRange;
    }

    @Override
    protected ColorTable getInitialColorTable() {
        return null;
    }

    @Override
    protected ColorTable getColorTableToApply() {
        return this.stationModelColorTable;
    }

    @Override
    public ColorTable getColorTable() {
        return this.stationModelColorTable;
    }

    @Override
    public Range getRangeForColorTable() throws RemoteException, VisADException {
        return this.getRangeToApply();
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (!super.setData(choice)) {
            return false;
        }
        if (this.getHaveInitialized()) {
            this.loadData();
        }
        return true;
    }

    @Override
    public void applyTimeRange() {
        try {
            double endDate;
            DataTimeRange dataTimeRange = this.getDataTimeRange(true);
            if (this.timeRange == null) {
                return;
            }
            Real startReal = new Real(RealType.Time, this.timeRange.getMin());
            Real endReal = new Real(RealType.Time, this.timeRange.getMax());
            Animation anime = this.getViewAnimation();
            Real aniValue = anime != null ? anime.getAniValue() : null;
            Real[] startEnd = this.getDataTimeRange().getTimeRange(startReal, endReal, aniValue);
            double startDate = startEnd[0].getValue(CommonUnit.secondsSinceTheEpoch);
            if (!Misc.equals(this.lastRange, new Range(startDate, endDate = startEnd[1].getValue(CommonUnit.secondsSinceTheEpoch)))) {
                this.lastRange = new Range(startDate, endDate);
                if (this.myDisplay != null) {
                    this.myDisplay.setSelectedRange(startDate, endDate);
                }
            }
            if (this.rangeColorPreview != null && this.rangeColorPreview.getIsTime()) {
                this.rangeColorPreview.setRange(new Range(startDate, endDate));
            }
        }
        catch (Exception e) {
            StationModelControl.logException("applyTimeRange", e);
        }
    }

    private Range getRangeForTimeSelect() throws VisADException, RemoteException {
        Range range = null;
        if (this.timesHolder != null && !this.timesHolder.getData().equals(DUMMY_DATA)) {
            Set timeSet = (Set)this.timesHolder.getData();
            double[][] doubles = timeSet.getDoubles(false);
            double start = doubles[0][0];
            double end = doubles[0][timeSet.getLength() - 1];
            range = new Range(start, end);
        }
        return range;
    }

    protected void loadDataInThread() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                StationModelControl.this.showWaitCursor();
                try {
                    StationModelControl.this.loadData();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Loading data", exc);
                }
                StationModelControl.this.showNormalCursor();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadData() {
        int myTimestamp = ++this.loadDataTimestamp;
        try {
            List<PointOb> obs;
            Object tmp;
            boolean isTimeSequence;
            if (!this.getActive()) {
                return;
            }
            if (!this.haveSetInitialScale) {
                this.setScaleOnDisplayable();
            }
            this.haveSetInitialScale = true;
            this.lastViewScale = this.getScaleFromDisplayable();
            this.lastViewBounds = this.calculateRectangle();
            LinearLatLonSet llBounds = this.calculateLatLonBounds(this.lastViewBounds);
            LogUtil.message("Observation display: loading data");
            Trace.call1("getDataInstance");
            PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
            if (pdi == null || this.myDisplay == null) {
                return;
            }
            Trace.call2("getDataInstance");
            Trace.call1("StationModelControl.loadData");
            FieldImpl data = null;
            if (this.isInTransectView() || llBounds == null) {
                Trace.call1("getObs-1");
                data = pdi.getTimeSequence();
                Trace.call2("getObs-1");
            } else {
                Trace.call1("getObs-2");
                data = pdi.getTimeSequence(llBounds);
                Trace.call2("getObs-2");
            }
            if (data == null) {
                return;
            }
            if (!this.getActive()) {
                return;
            }
            FieldImpl theData = data;
            if (this.filtersEnabled && this.filters.size() > 0) {
                this.lastDeclutteredData = null;
                try {
                    LogUtil.message("Observation display: filtering data");
                    Trace.call1("filterData");
                    theData = this.filterData(theData);
                    Trace.call2("filterData");
                }
                catch (Exception exc) {
                    StationModelControl.logException("Processing filters", exc);
                }
            }
            if (!this.getTimeDeclutterEnabled() && (isTimeSequence = GridUtil.isTimeSequence(theData))) {
                Set timeSet = theData.getDomainSet();
                if (!this.getAskedUserToDeclutterTime() && timeSet.getLength() > 1000) {
                    if (!this.isInitDone()) {
                        int numTimes = timeSet.getLength();
                        FieldImpl ob0 = (FieldImpl)theData.getSample(0);
                        PointOb ob00 = (PointOb)ob0.getSample(0);
                        double time0 = ob00.getDateTime().getValue();
                        FieldImpl obE = (FieldImpl)theData.getSample(numTimes - 1);
                        ob00 = (PointOb)obE.getSample(0);
                        double timeE = ob00.getDateTime().getValue();
                        int seconds0 = (int)(timeE - time0) / 1000;
                        super.updateTimeDeclutterMinutes(seconds0 / 60);
                    }
                    this.setAskedUserToDeclutterTime(true);
                    if (!GuiUtils.askYesNo("Time Declutter", new JLabel("<html>There are " + timeSet.getLength() + " time steps in the data.<br>Do you want to show them all?"))) {
                        this.setTimeDeclutterEnabled(true);
                    }
                }
            }
            if (this.getTimeDeclutterEnabled()) {
                this.lastDeclutteredData = null;
                isTimeSequence = GridUtil.isTimeSequence(theData);
                LogUtil.message("Observation display: subsetting times");
                Trace.call1("doDeclutterTime");
                theData = this.doDeclutterTime(theData);
                GuiUtils.enableComponents(this.timeDeclutterComps, this.getTimeDeclutterEnabled());
                Trace.call2("doDeclutterTime");
            }
            if (!this.getUseDataTimes()) {
                this.setDataTimes(theData);
                this.timeRange = this.getRangeForTimeSelect();
                theData = PointObFactory.removeTimeDimension(theData);
            }
            if (this.declutter) {
                if (!this.stationsLocked || this.lastDeclutteredData == null) {
                    Trace.call1("doDeclutter");
                    tmp = this.doDeclutter(theData, myTimestamp);
                    if (tmp == null) {
                        return;
                    }
                    this.lastDeclutteredData = tmp;
                    Trace.call2("doDeclutter");
                }
                theData = this.lastDeclutteredData;
            }
            tmp = this.DISPLAYABLE_MUTEX;
            synchronized (tmp) {
                boolean okToSet = true;
                if (this.currentStationData == null || theData != null) {
                    // empty if block
                }
                this.currentStationData = theData;
                if (okToSet) {
                    LogUtil.message("Observation display: creating display");
                    Trace.call1("setStationData");
                    this.myDisplay.setStationData(theData);
                    Trace.call2("setStationData");
                    LogUtil.message("");
                }
            }
            Trace.call2("StationModelControl.loadData");
            this.getViewAnimation();
            if ((this.selectedObId != null || this.selectedObLocation != null) && (obs = this.findSelectedObs()).size() > 0) {
                this.setSelectedOb(obs.get(0));
            }
            this.applyTimeRange();
        }
        catch (Exception excp) {
            StationModelControl.logException("loading data ", excp);
        }
        this.updateLegendAndList();
    }

    private Component doMakeTimeOptionWidget() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JRadioButton b = (JRadioButton)ae.getSource();
                StationModelControl.this.setUseDataTimes(b.getText().equals(TIMES_TO_USE[0]));
            }
        };
        ButtonGroup bg = new ButtonGroup();
        JRadioButton single = new JRadioButton(TIMES_TO_USE[0], this.getUseDataTimes());
        bg.add(single);
        single.addActionListener(listener);
        JRadioButton range = new JRadioButton(TIMES_TO_USE[1], !this.getUseDataTimes());
        bg.add(range);
        range.addActionListener(listener);
        return GuiUtils.hbox(single, range);
    }

    private Component doMakeTimeDeclutterWidget() {
        JComponent[] timeDeclutterComps = this.getTimeDeclutterComps();
        JPanel timeDeclutter = GuiUtils.left(GuiUtils.hflow(Misc.newList(new Component[]{this.addTimeDeclutterComp(new JLabel("Use every:  ")), this.addTimeDeclutterComp(timeDeclutterComps[1]), this.addTimeDeclutterComp(new JLabel(" minutes ")), timeDeclutterComps[0], new JLabel("enabled")}), 2, 1));
        return timeDeclutter;
    }

    private boolean hasDataChanged(FieldImpl newData, FieldImpl oldData) throws RemoteException, VisADException {
        boolean isTimeSequence = GridUtil.isTimeSequence(newData);
        if (isTimeSequence != GridUtil.isTimeSequence(oldData)) {
            return true;
        }
        if (isTimeSequence) {
            Set timeSet = newData.getDomainSet();
            int numTimes = timeSet.getLength();
            if (numTimes != oldData.getDomainSet().getLength()) {
                return true;
            }
            for (int i = 0; i < timeSet.getLength(); ++i) {
                FieldImpl timeFieldOld;
                FieldImpl timeFieldNew = (FieldImpl)newData.getSample(i);
                if (!this.hasTimeFieldChanged(timeFieldNew, timeFieldOld = (FieldImpl)oldData.getSample(i))) continue;
                return true;
            }
        } else if (this.hasTimeFieldChanged(newData, oldData)) {
            return true;
        }
        return false;
    }

    private boolean hasTimeFieldChanged(FieldImpl newData, FieldImpl oldData) throws RemoteException, VisADException {
        Set newDomainSet = newData.getDomainSet();
        int numObs = newDomainSet.getLength();
        if (numObs != oldData.getDomainSet().getLength()) {
            return true;
        }
        for (int i = 0; i < numObs; ++i) {
            if (newData.getSample(i) == oldData.getSample(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected TupleType getTupleType() throws RemoteException, VisADException {
        PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
        if (pdi == null) {
            return null;
        }
        FieldImpl obs = pdi.getPointObs();
        PointOb ob = (PointOb)obs.getSample(0);
        return (TupleType)((Tuple)ob.getData()).getType();
    }

    protected float getScaleFromDisplayable() {
        if (this.myDisplay != null) {
            return this.myDisplay.getScale();
        }
        return 0.0f;
    }

    public void setScaleOnDisplayable() throws RemoteException, VisADException {
        this.setScaleOnDisplayable(this.getDisplayScale() * this.displayableScale);
    }

    protected void setScaleOnDisplayable(float f) throws RemoteException, VisADException {
        if (this.myDisplay != null) {
            this.myDisplay.setScale(f);
        }
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        this.clearDataInstance();
        super.resetData();
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        Misc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    StationModelControl.this.setScaleOnDisplayable();
                    StationModelControl.this.loadData();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("handling projection change", exc);
                }
            }
        });
    }

    @Override
    public void transectChanged() {
        super.transectChanged();
        this.loadDataInThread();
    }

    @Override
    protected void fieldSelectorChanged() {
        this.updateTable(this.currentTableOb, true);
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        if (this.timeSeries != null) {
            ArrayList<Object> chartItems = new ArrayList<Object>();
            chartItems.add(GuiUtils.makeCheckboxMenuItem("Show Chart Thumbnail", this.getChart(), "showThumb", null));
            this.getChart().addViewMenuItems(chartItems);
            chartItems.add("separator");
            chartItems.addAll(this.getChartMenuItems());
            JMenu chartMenu = GuiUtils.makeMenu("Chart", chartItems);
            items.add("separator");
            items.add(chartMenu);
            items.add("separator");
            items.add(GuiUtils.makeMenuItem("Show Field Selector", this, "showFieldSelector"));
            items.add(GuiUtils.makeCheckboxMenuItem("Show Raw Data", this, "showDataRaw", null));
        }
    }

    protected FieldImpl filterData(FieldImpl obs) throws Exception {
        boolean isTimeSequence = GridUtil.isTimeSequence(obs);
        FieldImpl filteredField = null;
        if (isTimeSequence) {
            Set timeSet = obs.getDomainSet();
            filteredField = new FieldImpl((FunctionType)obs.getType(), timeSet);
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)obs.getSample(i);
                FieldImpl subTime = this.doTheActualFiltering(oneTime);
                if (subTime == null) continue;
                filteredField.setSample(i, (Data)subTime, false);
            }
        } else {
            filteredField = this.doTheActualFiltering(obs);
        }
        return filteredField;
    }

    private FieldImpl doTheActualFiltering(FieldImpl pointObs) throws Exception {
        if (pointObs == null || pointObs.isMissing()) {
            return pointObs;
        }
        FieldImpl retField = null;
        Set domainSet = pointObs.getDomainSet();
        int numObs = domainSet.getLength();
        Vector<PointOb> v = new Vector<PointOb>();
        Object[] tmpValues = new Object[this.filters.size()];
        for (int i = 0; i < numObs; ++i) {
            Data tmp = pointObs.getSample(i);
            if (!(tmp instanceof PointOb)) continue;
            PointOb ob = (PointOb)tmp;
            Tuple tuple = (Tuple)ob.getData();
            TupleType tupleType = (TupleType)tuple.getType();
            MathType[] types = tupleType.getComponents();
            String[] typeNames = new String[types.length];
            for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
                typeNames[typeIdx] = types[typeIdx].toString();
            }
            boolean ok = true;
            boolean matchedSome = false;
            for (int filterIdx = 0; ok && filterIdx < this.filters.size(); ++filterIdx) {
                PropertyFilter filter = (PropertyFilter)this.filters.get(filterIdx);
                String paramName = filter.getName();
                Data dataElement = null;
                if (paramName.equals("lat")) {
                    dataElement = ob.getEarthLocation().getLatitude();
                } else if (paramName.equals("lon")) {
                    dataElement = ob.getEarthLocation().getLongitude();
                } else if (paramName.equals("alt")) {
                    dataElement = ob.getEarthLocation().getAltitude();
                } else {
                    int dataIndex = -1;
                    for (int typeIdx = 0; dataIndex == -1 && typeIdx < typeNames.length; ++typeIdx) {
                        if (!paramName.equals(typeNames[typeIdx])) continue;
                        dataIndex = typeIdx;
                    }
                    if (dataIndex < 0) continue;
                    dataElement = tuple.getComponent(dataIndex);
                }
                if (dataElement == null) continue;
                if (dataElement.isMissing()) {
                    if (!this.matchAll) continue;
                    ok = false;
                    continue;
                }
                boolean filterOk = false;
                if (!(dataElement instanceof Real) || !filter.isNumericOperator()) {
                    filterOk = filter.ok(((Object)dataElement).toString().trim());
                } else {
                    Real obsReal = dataElement;
                    if (tmpValues[filterIdx] == null) {
                        String filterValue = filter.getValue().trim();
                        tmpValues[filterIdx] = filterValue;
                        Real filterReal = Util.toReal(filterValue);
                        if (filterReal != null) {
                            tmpValues[filterIdx] = obsReal.getUnit() == null ? new Double(filterReal.getValue()) : new Double(filterReal.getValue(obsReal.getUnit()));
                        }
                    }
                    filterOk = filter.ok(dataElement, tmpValues[filterIdx]);
                }
                if (filterOk) {
                    matchedSome = true;
                    if (this.matchAll) continue;
                    break;
                }
                if (!this.matchAll) continue;
                ok = false;
            }
            if (!ok || !matchedSome) continue;
            v.add(ob);
        }
        if (v.isEmpty()) {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), 1));
        } else if (v.size() == numObs) {
            retField = pointObs;
        } else {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), v.size()));
            retField.setSamples(v.toArray(new PointOb[v.size()]), false);
        }
        return retField;
    }

    public void setTheStationModel(StationModel value) {
        this.stationModel = value;
    }

    public StationModel getTheStationModel() {
        return this.stationModel;
    }

    public StationModel getStationModel() {
        if (this.stationModel == null) {
            this.stationModel = this.createStationModel();
        }
        return this.stationModel;
    }

    private void setStationModel(StationModel sm) {
        try {
            this.stationModel = sm;
            if (this.layoutModelWidget != null) {
                this.layoutModelWidget.setLayoutModel(sm);
            }
            this.myDisplay.setStationModel(sm, false);
            this.loadData();
            this.fillSideLegend();
        }
        catch (Exception exc) {
            StationModelControl.logException("setting station model", exc);
        }
    }

    public void setStationModelFromWidget(StationModel sm) {
        this.setStationModel(sm);
    }

    protected void setLayoutModel(String id, StationModel stationModel) {
        this.setStationModel(stationModel);
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        return GuiUtils.vbox(parentComp, this.getChart().getThumb());
    }

    public String getStationModelName() {
        return this.getStationModel().getName();
    }

    public void setStationModelName(String n) {
        if (this.tmpStationModelName != null && this.getControlContext() != null) {
            this.tmpStationModelName = n;
            StationModel sm = this.createStationModel();
            this.setStationModel(sm);
        } else {
            this.tmpStationModelName = n;
        }
    }

    private StationModel createStationModel() {
        StationModel stationModel = null;
        if (this.tmpStationModelName != null) {
            stationModel = this.getControlContext().getStationModelManager().getStationModel(this.tmpStationModelName);
            if (stationModel == null) {
                LogUtil.userErrorMessage("Unable to find layout model: " + this.tmpStationModelName + ". Using default");
            }
            this.tmpStationModelName = null;
        }
        if (stationModel == null) {
            stationModel = this.getControlContext().getStationModelManager().getDefaultStationModel();
        }
        if (stationModel == null) {
            stationModel = this.makeDefaultStationModel();
        }
        return stationModel;
    }

    private StationModel makeDefaultStationModel() {
        ArrayList<MetSymbol> l = new ArrayList<MetSymbol>();
        ValueSymbol tSym = new ValueSymbol(-20, -10, "T", "Temperature");
        tSym.setForeground(Color.red);
        Unit u = SI.kelvin;
        try {
            u = Parser.parse("degF");
        }
        catch (Exception exception) {
            // empty catch block
        }
        tSym.setTheDisplayUnit(u);
        l.add(tSym);
        ValueSymbol tdSym = new ValueSymbol(-20, 10, "TD", "DewPoint", u);
        tdSym.setForeground(Color.green);
        l.add(tdSym);
        ValueSymbol pslSym = new ValueSymbol(20, -10, "PSL", "Sea Level Pressure");
        pslSym.setForeground(Color.magenta);
        pslSym.setNumberFormatString("####.0");
        l.add(pslSym);
        TextSymbol idSym = new TextSymbol(0, 20, "ID", "Station ID");
        idSym.setForeground(Color.gray);
        l.add(idSym);
        CloudCoverageSymbol cc = new CloudCoverageSymbol(0, 0, "CC1", "CC1");
        cc.setForeground(Color.white);
        l.add(cc);
        return new StationModel("Layout model", l);
    }

    public JButton getLockButton() {
        if (this.lockBtn == null) {
            this.lockBtn = new JButton(lockIcon);
            this.lockBtn.setContentAreaFilled(false);
            this.lockBtn.setBorder(BorderFactory.createEmptyBorder());
            this.lockBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    StationModelControl.this.setStationsLocked(!StationModelControl.this.stationsLocked);
                }
            });
            this.updateLockButton();
        }
        return this.lockBtn;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        JCheckBox toggle = new JCheckBox("", this.declutter);
        toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StationModelControl.this.setDeclutter(((JCheckBox)e.getSource()).isSelected());
                StationModelControl.this.loadDataInThread();
            }
        });
        JButton testButton = GuiUtils.makeButton("Test", this, "test");
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Declutter:"), GuiUtils.hbox(Misc.newList(new Object[]{toggle, this.getLockButton(), GuiUtils.filler(), this.addDensityComp(GuiUtils.rLabel(" Density: ")), this.getDensityControl()}))));
        GuiUtils.enableComponents(this.densityComps, this.declutter);
        final JTextField scaleField = new JTextField(Misc.format(this.displayableScale), 5);
        ActionListener scaleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    StationModelControl.this.setDisplayableScale((float)Misc.parseNumber(scaleField.getText()));
                }
                catch (Exception nfe) {
                    StationModelControl.this.userErrorMessage("Bad scale format");
                }
            }
        };
        scaleField.addActionListener(scaleListener);
        JButton scaleBtn = new JButton("Apply");
        scaleBtn.addActionListener(scaleListener);
        this.layoutModelWidget = new LayoutModelWidget(this, (Object)this, "setStationModelFromWidget", this.getStationModel());
        JPanel stationModelPanel = GuiUtils.hbox((Component)GuiUtils.left(this.layoutModelWidget), (Component)GuiUtils.rLabel("   Scale:"), GuiUtils.hflow(Misc.newList(scaleField, scaleBtn), 4, 0));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Layout Model:"), GuiUtils.left(stationModelPanel)));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(this.getLineWidthWidgetLabel() + ": "), this.getLineWidthWidget().getContents(false)));
        if (this.useZPosition()) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.top(GuiUtils.rLabel("Vertical Position: ")), this.doMakeVerticalPositionPanel()));
        }
    }

    public void test() {
        this.loadDataInThread();
    }

    public void editStationTable() {
        this.getControlContext().getStationModelManager().show(this.stationModel);
    }

    private List getTableRows() {
        if (this.tableRows == null) {
            this.tableRows = new ArrayList();
        }
        return this.tableRows;
    }

    protected JPanel doMakeVerticalPositionPanel() {
        this.zPositionPanel = GuiUtils.hgrid(this.doMakeZPositionSlider(), GuiUtils.filler());
        GuiUtils.enableTree(this.zPositionPanel, !this.shouldUseAltitude);
        JRadioButton[] jrbs = GuiUtils.makeRadioButtons(Misc.newList("Altitude (if available)", "Fixed position:"), this.shouldUseAltitude ? 0 : 1, this, "setShouldUseAltitudeIndex");
        return GuiUtils.doLayout(new Component[]{GuiUtils.left(GuiUtils.hbox(jrbs[0], jrbs[1])), this.zPositionPanel}, 1, GuiUtils.WT_Y, GuiUtils.WT_N);
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        JComponent widgets = this.doMakeWidgetComponent();
        this.tableModel = new MyTableModel();
        int width = 300;
        if (this.timeSeries != null) {
            this.timeSeries.setControl(this);
        }
        this.table = new JTable(this.tableModel);
        this.table.setToolTipText("Double click to add to or remove from chart. Right click change settings");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                boolean isShowing;
                if (!SwingUtilities.isRightMouseButton(e) && e.getClickCount() <= 1) {
                    return;
                }
                int row = StationModelControl.this.table.rowAtPoint(e.getPoint());
                if (row < 0 || row >= StationModelControl.this.getTableRows().size()) {
                    return;
                }
                PointParam pointParam = StationModelControl.this.getPointParam(StationModelControl.this.paramName);
                JPopupMenu popupMenu = new JPopupMenu();
                String paramName = (String)StationModelControl.this.tableModel.getValueAt(row, 0, false);
                boolean bl = isShowing = pointParam != null && pointParam.getLineState().getVisible();
                if (!SwingUtilities.isRightMouseButton(e) && e.getClickCount() > 1) {
                    if (!isShowing) {
                        StationModelControl.this.addChartParam(paramName);
                    } else {
                        StationModelControl.this.removeChartParam(pointParam);
                    }
                    return;
                }
                if (!isShowing) {
                    popupMenu.add(GuiUtils.makeMenuItem("Add To Chart", StationModelControl.this, "addChartParam", paramName));
                    if (StationModelControl.this.chartParams.size() > 0) {
                        popupMenu.addSeparator();
                    }
                }
                GuiUtils.makePopupMenu(popupMenu, StationModelControl.this.getChartMenuItems());
                popupMenu.show(StationModelControl.this.table, e.getX(), e.getY());
            }
        });
        this.table.setPreferredScrollableViewportSize(new Dimension(width, 100));
        this.tableScroller = new JScrollPane(this.table);
        this.tableScroller.setPreferredSize(new Dimension(width, 100));
        this.getChart().getContents().setPreferredSize(new Dimension(width, 200));
        this.selectedObLbl = new JLabel(" ");
        this.getChart().setEmptyChartLabel("Select a station in the main display");
        this.plotPanel = GuiUtils.centerBottom(this.getChart().getContents(), this.tableScroller);
        ArrayList<Component> timeWidgets = new ArrayList<Component>();
        timeWidgets.add(GuiUtils.rLabel("Show:"));
        timeWidgets.add(this.doMakeTimeOptionWidget());
        this.getDataTimeRange(true).setOneLineLabel(true);
        JPanel timeModePanel = GuiUtils.leftCenter(GuiUtils.wrap(GuiUtils.makeImageButton("/auxdata/ui/icons/calendar_edit.png", this, "showTimeRangeDialog")), GuiUtils.inset((Component)this.getDataTimeRange(true).getTimeModeLabel(), new Insets(0, 10, 0, 0)));
        timeWidgets.add(GuiUtils.rLabel("Range:"));
        timeWidgets.add(timeModePanel);
        timeWidgets.add(GuiUtils.rLabel("Declutter:"));
        timeWidgets.add(this.doMakeTimeDeclutterWidget());
        GuiUtils.enableComponents(this.timeDeclutterComps, this.getTimeDeclutterEnabled());
        JPanel plotComp = GuiUtils.topCenter(GuiUtils.inset((Component)this.selectedObLbl, 3), this.plotPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Layout", GuiUtils.top(widgets));
        LayoutUtil.tmpInsets = LayoutUtil.INSETS_5;
        JPanel timeComp = LayoutUtil.doLayout(timeWidgets, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        tabbedPane.add("Times", GuiUtils.topLeft(timeComp));
        tabbedPane.add("Plot", plotComp);
        tabbedPane.add("Filters", this.doMakeFilterGui(false));
        return tabbedPane;
    }

    private List getChartMenuItems() {
        ArrayList<JMenu> menuItems = new ArrayList<JMenu>();
        for (int i = 0; i < this.chartParams.size(); ++i) {
            PointParam pointParam = (PointParam)this.chartParams.get(i);
            LineState lineState = pointParam.getLineState();
            if (!lineState.getValid() || !lineState.getVisible()) continue;
            JMenu paramMenu = new JMenu(pointParam.getName());
            menuItems.add(paramMenu);
            paramMenu.add(GuiUtils.makeMenuItem("Remove From Chart", this, "removeChartParam", pointParam));
            paramMenu.add(GuiUtils.makeMenuItem("To Front", this, "toFront", pointParam));
            paramMenu.add(GuiUtils.makeMenuItem("Chart Properties", this, "showLineProperties", pointParam));
        }
        return menuItems;
    }

    public void showLineProperties(PointParam pointParam) {
        PropertyChangeListener listener;
        LineState lineState = pointParam.getLineState();
        if (!lineState.showPropertiesDialog(listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StationModelControl.this.chartChanged();
            }
        }, this.getChart().getPlotNames(), this.getChart().getCurrentRanges())) {
            return;
        }
    }

    @Override
    protected void timeDeclutterChanged() {
        this.lastDeclutteredData = null;
        GuiUtils.enableComponents(this.timeDeclutterComps, this.getTimeDeclutterEnabled());
        this.loadDataInThread();
    }

    protected JComponent addDensityComp(JComponent comp) {
        this.densityComps.add(comp);
        return comp;
    }

    protected JComponent addTimeDeclutterComp(JComponent comp) {
        this.timeDeclutterComps.add(comp);
        return comp;
    }

    protected JPanel getDensityControl() {
        this.densitySlider = new JSlider(0, 10, 0);
        this.addDensityComp(this.densitySlider);
        GuiUtils.setSliderPercent(this.densitySlider, 1.0 - (double)this.declutterFilter);
        this.densitySlider.setToolTipText("Control the density of the plot displays");
        this.densitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (StationModelControl.this.densitySlider.getValueIsAdjusting()) {
                    return;
                }
                float newValue = 1.0f - (float)GuiUtils.getSliderPercent(StationModelControl.this.densitySlider);
                if (newValue == StationModelControl.this.declutterFilter) {
                    return;
                }
                StationModelControl.this.setDeclutterFilter(newValue);
                if (StationModelControl.this.getDeclutter()) {
                    StationModelControl.this.loadDataInThread();
                }
            }
        });
        JPanel comp = GuiUtils.doLayout(new Component[]{this.addDensityComp(GuiUtils.rLabel("Low ")), this.densitySlider, this.addDensityComp(GuiUtils.lLabel(" High"))}, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
        return GuiUtils.hgrid(comp, GuiUtils.filler());
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        this.makeStationModelEditMenuItems(items, forMenuBar);
        super.getEditMenuItems(items, forMenuBar);
    }

    protected void makeStationModelEditMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.makeMenuItem("Layout Model...", this, "editStationTable"));
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        if (this.getDataTimeRange() != null) {
            dsd.addPropertyValue(this.getDataTimeRange(), "dataTimeRange", "Accumulation Times", "Display");
        }
        dsd.addPropertyValue(new Boolean(this.getUseDataTimes()), "useDataTimes", "Use Data Times", "Display");
        dsd.addPropertyValue(this.getStationModelName(), "stationModelName", "Layout Model", "Display");
        if (!this.isChartEnabled()) {
            return;
        }
        try {
            TimeSeriesChart clonedTimeSeries = (TimeSeriesChart)this.getIdv().decodeObject(this.getIdv().encodeObject(this.timeSeries, false));
            clonedTimeSeries.setControl(null);
            ArrayList<PointParam> tmp = new ArrayList<PointParam>();
            for (int i = 0; i < this.chartParams.size(); ++i) {
                PointParam cp = (PointParam)this.chartParams.get(i);
                if (!cp.getLineState().getVisible()) continue;
                tmp.add(cp);
            }
            String label = StringUtil.join(",", tmp);
            TwoFacedObject tfo = new TwoFacedObject((Object)label, new Object[]{clonedTimeSeries, tmp});
            dsd.addPropertyValue(tfo, "chartSettings", "Chart Settings", "Display");
        }
        catch (Exception exc) {
            StationModelControl.logException("Applying chart settings", exc);
        }
    }

    public void setChartSettings(TwoFacedObject tfo) {
        try {
            Object[] a = (Object[])tfo.getId();
            this.timeSeries = (TimeSeriesChart)this.getIdv().decodeObject(this.getIdv().encodeObject(a[0], false));
            this.timeSeries.setControl(this);
            this.chartParams = new ArrayList((List)a[1]);
            if (this.plotPanel != null) {
                this.plotPanel.removeAll();
                this.plotPanel.add("Center", this.getChart().getContents());
                this.plotPanel.add("South", this.tableScroller);
                this.plotPanel.invalidate();
                this.plotPanel.validate();
                this.plotPanel.repaint();
                this.getChart().getContents().repaint(5L);
                this.chartChanged();
            }
        }
        catch (Exception exc) {
            StationModelControl.logException("Applying chart settings", exc);
        }
    }

    protected boolean isChartEnabled() {
        return true;
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        PointDataInstance pdi;
        super.getSaveMenuItems(items, forMenuBar);
        if (this.isChartEnabled()) {
            items.add(GuiUtils.makeMenuItem("Save Chart Image...", this.getChart(), "saveImage"));
        }
        if ((pdi = (PointDataInstance)this.getDataInstance()) != null) {
            items.add(GuiUtils.makeMenuItem("Export to NetCDF...", this, "exportAsNetcdf", null, true));
            items.add(GuiUtils.makeMenuItem("Export to KMZ...", this, "exportAsKmz", null, true));
        }
        if (this.table != null && this.table.getModel().getRowCount() > 0) {
            items.add(GuiUtils.makeMenuItem("Export Selected Observation...", this, "exportAsCsv"));
        }
    }

    public void exportAsKmz() {
        try {
            if (this.kmzWidthFld == null) {
                this.kmzWidthFld = new JTextField("80", 5);
                this.kmzHeightFld = new JTextField("80", 5);
                this.kmzNameFld = new JTextField("Point Observations");
                this.kmzColorSwatch = new GuiUtils.ColorSwatch(Color.white, "KMZ Icon Color", true);
            }
            JComponent widgets = GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("Name:"), this.kmzNameFld, GuiUtils.rLabel("Icon Size:"), GuiUtils.left(GuiUtils.hbox((Component)this.kmzWidthFld, (Component)new JLabel(" X "), this.kmzHeightFld)), GuiUtils.rLabel("BG Color:"), this.kmzColorSwatch.getPanel()});
            JComboBox publishCbx = this.getIdv().getPublishManager().getSelector("kmz.export");
            JComponent accessory = publishCbx != null ? GuiUtils.topBottom(widgets, publishCbx) : widgets;
            String filename = FileManager.getWriteFile(FileManager.FILTER_KMZ, ".kmz", (JComponent)GuiUtils.top(accessory));
            if (filename == null) {
                return;
            }
            if (!this.myDisplay.writeKmzFile(new File(filename), this.currentStationData, this.kmzNameFld.getText(), new Integer(this.kmzWidthFld.getText().trim()), new Integer(this.kmzHeightFld.getText().trim()), this.kmzColorSwatch.getColor())) {
                return;
            }
            this.getIdv().getPublishManager().publishContent(filename, null, publishCbx);
        }
        catch (Exception exc) {
            StationModelControl.logException("Exporting point data to kmz", exc);
        }
    }

    public void exportAsCsv() {
        GuiUtils.exportAsCsv(this.table.getModel());
    }

    protected boolean haveFilters() {
        return this.filtersEnabled && this.filters.size() > 0;
    }

    public void initFilters() {
        if (this.filterGui != null) {
            this.filters = this.filterGui.getFilters();
            this.matchAll = this.filterGui.getMatchAll();
            this.filtersEnabled = this.filterGui.getEnabled();
        }
    }

    public void applyFilters() {
        this.lastDeclutteredData = null;
        this.initFilters();
        this.loadData();
    }

    protected JComponent doMakeFilterGui(boolean includeAll) {
        JComponent buttons = GuiUtils.makeButton("Apply Filters", this, "applyFilters");
        if (includeAll) {
            JRadioButton[] rbs = GuiUtils.makeRadioButtons(Misc.newList("Only show these", "Always show these"), this.onlyShowFiltered ? 0 : 1, this, "handleOnlyShow");
            buttons = GuiUtils.hbox((Component)buttons, (Component)rbs[0], rbs[1]);
        }
        JPanel gui = GuiUtils.topCenter(GuiUtils.left(GuiUtils.inset((Component)buttons, 5)), this.filterGui.getContents());
        return gui;
    }

    public void handleOnlyShow(int index) {
        this.setOnlyShowFiltered(index == 0);
    }

    protected List getFilterNames() {
        try {
            PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
            if (pdi == null) {
                return null;
            }
            FieldImpl data = pdi.getPointObs();
            Set domainSet = data.getDomainSet();
            int numObs = domainSet.getLength();
            if (numObs == 0) {
                return null;
            }
            PointOb ob = (PointOb)data.getSample(0);
            Data tuple = ob.getData();
            TupleType tupleType = (TupleType)tuple.getType();
            ArrayList<Object> names = new ArrayList<Object>();
            MathType[] types = tupleType.getComponents();
            names.add("--");
            for (int i = 0; i < types.length; ++i) {
                String typeId = types[i].toString();
                String typeName = Util.cleanTypeName(typeId);
                names.add(new TwoFacedObject((Object)typeName, typeId));
            }
            names.add(new TwoFacedObject((Object)"Latitude", "lat"));
            names.add(new TwoFacedObject((Object)"Longitude", "lon"));
            names.add(new TwoFacedObject((Object)"Altitude", "alt"));
            return names;
        }
        catch (Exception exc) {
            StationModelControl.logException("Getting filter names", exc);
            return null;
        }
    }

    protected void updateLockButton() {
        this.lockBtn.setIcon(this.stationsLocked ? lockIcon : unlockIcon);
        this.lockBtn.setToolTipText(this.stationsLocked ? "Unlock station display" : "Lock station display");
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        this.getControlContext().getStationModelManager().removePropertyChangeListener(this);
        this.rangeColorPreview = null;
        super.doRemove();
    }

    private void setDataTimes(FieldImpl timeData) throws VisADException, RemoteException {
        if (this.timesHolder == null) {
            return;
        }
        if (this.getUseDataTimes()) {
            this.timesHolder.setData(DUMMY_DATA);
            return;
        }
        if (GridUtil.isTimeSequence(timeData)) {
            Set timeSet = timeData.getDomainSet();
            this.timesHolder.setData(timeSet);
        }
    }

    private FieldImpl doDeclutter(FieldImpl obs, int timestamp) throws VisADException, RemoteException {
        long millis = System.currentTimeMillis();
        boolean isTimeSequence = GridUtil.isTimeSequence(obs);
        FieldImpl declutteredField = null;
        if (isTimeSequence) {
            Set timeSet = obs.getDomainSet();
            declutteredField = new FieldImpl((FunctionType)obs.getType(), timeSet);
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)obs.getSample(i);
                FieldImpl subTime = this.doTheActualDecluttering(oneTime, timestamp);
                if (timestamp != this.loadDataTimestamp) {
                    return null;
                }
                if (subTime == null) continue;
                declutteredField.setSample(i, (Data)subTime, false);
            }
        } else {
            declutteredField = this.doTheActualDecluttering(obs, timestamp);
        }
        return declutteredField;
    }

    private FieldImpl doTheActualDecluttering(FieldImpl pointObs, int timestamp) throws VisADException, RemoteException {
        if (pointObs == null || pointObs.isMissing()) {
            return pointObs;
        }
        FieldImpl retField = null;
        Set domainSet = pointObs.getDomainSet();
        int numObs = domainSet.getLength();
        Vector<PointOb> v = new Vector<PointOb>();
        long t1 = System.currentTimeMillis();
        Rectangle glyphBounds = this.getStationModel().getBounds();
        float myScale = this.getScale() * 0.0025f * this.getDeclutterFilter();
        Rectangle2D.Double scaledGlyphBounds = new Rectangle2D.Double(glyphBounds.getX() * (double)myScale, glyphBounds.getY() * (double)myScale, glyphBounds.getWidth() * (double)myScale, glyphBounds.getHeight() * (double)myScale);
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        Rectangle2D.Double obBounds = new Rectangle2D.Double();
        obBounds.width = ((RectangularShape)scaledGlyphBounds).getWidth();
        obBounds.height = ((RectangularShape)scaledGlyphBounds).getHeight();
        Rectangle2D bounds = this.getBounds();
        if (this.stationGrid == null) {
            this.stationGrid = new SpatialGrid(200, 200);
        }
        this.stationGrid.clear();
        this.stationGrid.setGrid(bounds, scaledGlyphBounds);
        if (this.getDeclutterFilter() < 0.3f) {
            // empty if block
        }
        double[] xyz = new double[3];
        for (int i = 0; i < numObs; ++i) {
            if (timestamp != this.loadDataTimestamp) {
                return null;
            }
            PointOb ob = (PointOb)pointObs.getSample(i);
            xyz = navDisplay.getSpatialCoordinates(ob.getEarthLocation(), xyz, 0.0);
            obBounds.x = xyz[0];
            obBounds.y = xyz[1];
            if (!this.stationGrid.markIfClear(obBounds, "") && !this.isSelected(ob)) continue;
            v.add(ob);
        }
        long t2 = System.currentTimeMillis();
        if (v.isEmpty()) {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), 1));
            retField.setSample(0, pointObs.getSample(0), false);
        } else if (v.size() == numObs) {
            retField = pointObs;
        } else {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), v.size()));
            retField.setSamples(v.toArray(new PointOb[v.size()]), false, false);
        }
        long t3 = System.currentTimeMillis();
        return retField;
    }

    public void setDeclutter(boolean v) {
        this.declutter = v;
        GuiUtils.enableComponents(this.densityComps, this.declutter);
    }

    public boolean getDeclutter() {
        return this.declutter;
    }

    public void setStationsLocked(boolean v) {
        this.stationsLocked = v;
        if (this.lockBtn != null) {
            this.updateLockButton();
        }
    }

    public boolean getStationsLocked() {
        return this.stationsLocked;
    }

    public void setDeclutterFilter(float filter) {
        this.declutterFilter = filter;
    }

    public float getDeclutterFilter() {
        return this.declutterFilter;
    }

    protected float getScale() {
        return this.getScaleFromDisplayable();
    }

    protected Rectangle2D getBounds() {
        return this.calculateRectangle();
    }

    protected LinearLatLonSet calculateLatLonBounds(Rectangle2D screenBounds) {
        if (screenBounds.getWidth() == 0.0 || screenBounds.getHeight() == 0.0) {
            return null;
        }
        LinearLatLonSet bounds = null;
        try {
            Rectangle2D.Double rect = this.getNavigatedDisplay().getLatLonBox();
            bounds = new LinearLatLonSet((MathType)RealTupleType.LatitudeLongitudeTuple, rect.y, rect.y + rect.height, 11, rect.x, rect.x + rect.width, 11);
        }
        catch (Exception e) {
            try {
                bounds = new LinearLatLonSet((MathType)RealTupleType.LatitudeLongitudeTuple, -90.0, 90.0, 19, -180.0, 180.0, 37);
            }
            catch (Exception ne) {
                StationModelControl.logException("calculating LLLSet ", ne);
            }
        }
        return bounds;
    }

    protected float decodeFilterString(String filter) {
        if (filter.toLowerCase().startsWith("y")) {
            return 1.0f;
        }
        if (filter.toLowerCase().startsWith("n")) {
            return 0.01f;
        }
        float value = this.getDeclutterFilter();
        try {
            value = (float)Misc.parseNumber(filter);
            if (value == 0.0f) {
                value = 0.001f;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public String getColorWidgetLabel() {
        return "Color";
    }

    public void setFilters(List value) {
        this.filters = value;
    }

    public List getFilters() {
        return this.filters;
    }

    public void setMatchAll(boolean value) {
        this.matchAll = value;
    }

    public boolean getMatchAll() {
        return this.matchAll;
    }

    public void setFiltersEnabled(boolean value) {
        this.filtersEnabled = value;
    }

    public boolean getFiltersEnabled() {
        return this.filtersEnabled;
    }

    public void setShowAllTimes(boolean value) {
        this.setUseDataTimes(!value);
    }

    public void setUseDataTimes(boolean value) {
        this.useDataTimes = value;
        if (this.getHaveInitialized()) {
            try {
                this.loadDataInThread();
            }
            catch (Exception e) {
                StationModelControl.logException("setUseDataTimes", e);
            }
        }
    }

    public boolean getUseDataTimes() {
        return this.useDataTimes;
    }

    public float getDisplayableScale() {
        return this.displayableScale;
    }

    public void setDisplayableScale(float f) {
        this.displayableScale = f;
        if (this.myDisplay != null) {
            try {
                this.setScaleOnDisplayable();
            }
            catch (Exception exc) {
                StationModelControl.logException("Setting scale ", exc);
            }
        }
    }

    public void setUseLastTime(boolean value) {
        this.useLastTime = value;
    }

    public boolean getUseLastTime() {
        return this.useLastTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewpointChanged() {
        super.viewpointChanged();
        Object object = this.MUTEX;
        synchronized (object) {
            if (!this.getHaveInitialized() || !this.getActive()) {
                return;
            }
            Rectangle2D newBounds = this.calculateRectangle();
            boolean shouldReload = false;
            if (this.inGlobe) {
                double[] rotation = this.getNavigatedDisplay().getRotation();
                if (this.lastRotation == null) {
                    shouldReload = true;
                } else if (!Arrays.equals(rotation, this.lastRotation)) {
                    shouldReload = true;
                }
                this.lastRotation = rotation;
            }
            if (!shouldReload) {
                if (this.lastViewBounds == null || this.lastViewBounds.getWidth() == 0.0 || this.lastViewBounds.getHeight() == 0.0) {
                    shouldReload = true;
                } else if (!newBounds.equals(this.lastViewBounds)) {
                    double widthratio = newBounds.getWidth() / this.lastViewBounds.getWidth();
                    double heightratio = newBounds.getHeight() / this.lastViewBounds.getHeight();
                    double xdiff = Math.abs(newBounds.getX() - this.lastViewBounds.getX());
                    double ydiff = Math.abs(newBounds.getY() - this.lastViewBounds.getY());
                    if ((widthratio < 0.8 || widthratio > 1.2) && (heightratio < 0.8 || heightratio > 1.2) || xdiff > 0.2 * this.lastViewBounds.getWidth() || ydiff > 0.2 * this.lastViewBounds.getHeight()) {
                        shouldReload = true;
                    }
                }
                float newScale = this.getScaleFromDisplayable();
                if (Float.floatToIntBits(this.lastViewScale) != Float.floatToIntBits(newScale)) {
                    shouldReload = true;
                }
            }
            if (shouldReload) {
                if (!this.stationsLocked) {
                    this.loadDataInAWhile();
                } else if (this.inGlobe) {
                    this.loadDataInAWhile();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDataInAWhile() {
        DataLoader dataLoader;
        this.lastTimeLoadDataWasCalled = System.currentTimeMillis();
        Object object = this.LOADDATA_MUTEX;
        synchronized (object) {
            if (this.waitingToLoad) {
                return;
            }
            this.waitingToLoad = true;
            dataLoader = new DataLoader();
        }
        Misc.runInABit(200L, dataLoader);
    }

    public void setOnlyShowFiltered(boolean value) {
        this.onlyShowFiltered = value;
        if (this.getHaveInitialized()) {
            this.loadData();
        }
    }

    public boolean getOnlyShowFiltered() {
        return this.onlyShowFiltered;
    }

    public void setShouldUseAltitude(boolean value) {
        this.shouldUseAltitude = value;
        if (this.myDisplay != null) {
            try {
                this.myDisplay.setShouldUseAltitude(this.shouldUseAltitude);
                if (!this.shouldUseAltitude) {
                    this.applyZPosition();
                }
            }
            catch (Exception exc) {
                StationModelControl.logException("Setting shouldUseAltitude", exc);
            }
        }
        if (this.zPositionPanel != null) {
            GuiUtils.enableTree(this.zPositionPanel, !this.shouldUseAltitude);
        }
    }

    public boolean getShouldUseAltitude() {
        return this.shouldUseAltitude;
    }

    public void setShouldUseAltitudeIndex(int index) {
        this.setShouldUseAltitude(index == 0);
    }

    public void setAskedUserToDeclutterTime(boolean value) {
        this.askedUserToDeclutterTime = value;
    }

    public boolean getAskedUserToDeclutterTime() {
        return this.askedUserToDeclutterTime;
    }

    public void setChartParams(List value) {
        this.chartParams = value;
    }

    public List getChartParams() {
        return this.chartParams;
    }

    public void setSelectedObId(String value) {
        this.selectedObId = value;
    }

    public String getSelectedObId() {
        return this.selectedObId;
    }

    public void setTimeSeries(TimeSeriesChart value) {
        this.timeSeries = value;
    }

    public TimeSeriesChart getTimeSeries() {
        return this.timeSeries;
    }

    public TimeSeriesChart getChart() {
        if (this.timeSeries == null) {
            this.timeSeries = new TimeSeriesChart(this, "Plot");
            this.timeSeries.setEmptyChartLabel("Select a station in the main display");
            this.timeSeries.showAnimationTime(true);
        }
        return this.timeSeries;
    }

    public void setShowThumbNail(boolean value) {
        this.getChart().setShowThumb(value);
    }

    public void setSelectedObLocation(LatLonPoint value) {
        this.selectedObLocation = value;
    }

    public LatLonPoint getSelectedObLocation() {
        return this.selectedObLocation;
    }

    @Override
    public synchronized void dataChanged() {
        try {
            this.updateDataSelection(this.getDataSelection());
        }
        catch (Exception exc) {
            StationModelControl.logException("dataChanged", exc);
        }
        super.dataChanged();
    }

    static {
        DUMMY_DATA = new Real(0.0);
        lockIcon = GuiUtils.getImageIcon("/ucar/unidata/idv/control/images/lock.png");
        unlockIcon = GuiUtils.getImageIcon("/ucar/unidata/idv/control/images/lock_open.png");
        TIMES_TO_USE = new String[]{"Individual", "Multiple"};
        tableDisableColor = new Color(230, 230, 230);
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public int getRowCount() {
            return Math.max(StationModelControl.this.getTableRows().size(), 30);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.getValueAt(row, column, true);
        }

        public Object getValueAt(int row, int column, boolean forTable) {
            List tableRows = StationModelControl.this.getTableRows();
            if (row >= tableRows.size()) {
                return "";
            }
            List rowData = (List)tableRows.get(row);
            if (forTable && column == 0) {
                String name = (String)rowData.get(column);
                PointParam pointParam = StationModelControl.this.getPointParam(name);
                if (pointParam != null && pointParam.getLineState().getVisible()) {
                    name = name + " (in chart)";
                }
                return name;
            }
            if (column < rowData.size()) {
                return rowData.get(column);
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Field";
            }
            return "Value";
        }
    }

    private class DataLoader
    implements Runnable {
        long lastCheckLoadTime;

        public DataLoader() {
            this.lastCheckLoadTime = StationModelControl.this.lastTimeLoadDataWasCalled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean sleepAndContinue = false;
                boolean bl = sleepAndContinue = StationModelControl.this.lastTimeLoadDataWasCalled != this.lastCheckLoadTime;
                if (!sleepAndContinue) break;
                this.lastCheckLoadTime = StationModelControl.this.lastTimeLoadDataWasCalled;
                Misc.sleep(200L);
            }
            StationModelControl.this.loadData();
            Object object = StationModelControl.this.LOADDATA_MUTEX;
            synchronized (object) {
                StationModelControl.this.waitingToLoad = false;
            }
        }
    }
}

