/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.gis.SpatialGrid;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.LayoutModelWidget;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.StationModelControl;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.ui.PropertyFilter;
import ucar.unidata.ui.TableSorter;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.StationLocationDisplayable;
import ucar.visad.display.StationModelDisplayable;
import visad.CommonUnit;
import visad.Data;
import visad.DisplayEvent;
import visad.Gridded3DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.Text;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.MapProjection;
import visad.georef.NamedLocation;

public class StationLocationControl
extends StationModelControl {
    private final Object DISPLAYABLE_MUTEX = new Object();
    List displayedStations = new ArrayList();
    List sortedDisplayedStations = new ArrayList();
    private StationLocationDisplayable locationDisplayable;
    private StationLocationDisplayable selectedDisplayable;
    private LineDrawing coordDisplayable;
    private JPanel coordAttributePanel;
    private JLabel coordAttributeLabel;
    private List stationTableNames = new ArrayList();
    private boolean useStationModel = false;
    private JTabbedPane tabbedPane;
    private JComponent stationModelPanel;
    private JComponent symbolPanel;
    private boolean readoutInLegend = false;
    private String stationTableName = null;
    private Hashtable extraStations = new Hashtable();
    private boolean enabled = true;
    private boolean centerOnClick = true;
    private JList stationJList;
    private JEditorPane readoutText;
    private JScrollPane readoutSP;
    private JPanel readoutComp;
    private JComponent readoutLegendHolder;
    private JComponent readoutGuiHolder;
    private List selectionList = new ArrayList();
    private List lastDeclutteredStationList;
    private int symbolType = 2;
    private int idType = 1;
    private boolean showSymbol = true;
    private boolean showId = true;
    private LocationTable locationsTable;
    private LocationTableModel locationsTableModel;
    private LocationTable allLocationsTable;
    private LocationTableModel allLocationsTableModel;
    private boolean checkedCursorReadout = false;
    private boolean doCursorReadout = false;

    public StationLocationControl() {
        this.setStationModelName("Location");
        this.setShouldUseAltitude(false);
        this.setAttributeFlags(4);
    }

    @Override
    public void initAsPrototype() {
        super.initAsPrototype();
        this.stationTableNames = new ArrayList();
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.lastDeclutteredStationList = null;
        if (this.stationTableName != null && this.stationTableNames.size() == 0) {
            this.stationTableNames.add(this.stationTableName);
            this.stationTableName = null;
        }
        if (dataChoice != null) {
            try {
                Data d = dataChoice.getData(null);
                if (d instanceof Text) {
                    this.loadXml(((Text)d).getValue());
                }
            }
            catch (Exception exc) {
                StationLocationControl.logException("Error reading xml", exc);
                return false;
            }
        }
        return super.init(dataChoice);
    }

    private void loadXml(String filename) throws Exception {
        Trace.call1("StationLocationControl making stations");
        NamedStationTable table = NamedStationTable.createStationTableFromFile(filename);
        Trace.call2("StationLocationControl making stations");
        String tableName = table.getName();
        if (!this.stationTableNames.contains(tableName)) {
            this.stationTableNames.add(tableName);
        }
        this.extraStations.put(tableName, table);
    }

    @Override
    protected boolean isChartEnabled() {
        return false;
    }

    @Override
    protected List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        Hashtable properties;
        String url;
        List stations;
        if (!this.checkedCursorReadout) {
            stations = this.getStationList();
            if (stations.size() == 0) {
                return null;
            }
            NamedStationImpl tmp = (NamedStationImpl)stations.get(0);
            Hashtable properties2 = tmp.getProperties();
            if (properties2.get("imageurl") != null) {
                this.doCursorReadout = true;
            }
            this.checkedCursorReadout = true;
        }
        if (!this.doCursorReadout) {
            return null;
        }
        stations = this.getStationList();
        NamedStationImpl closest = null;
        double minDistance = 0.0;
        LatLonPointImpl llp = new LatLonPointImpl(el.getLatitude().getValue(CommonUnit.degree), el.getLongitude().getValue(CommonUnit.degree));
        for (NamedStationImpl station : stations) {
            EarthLocation el2 = station.getEarthLocation();
            LatLonPointImpl llp2 = new LatLonPointImpl(el2.getLatitude().getValue(CommonUnit.degree), el2.getLongitude().getValue(CommonUnit.degree));
            Bearing bearing = Bearing.calculateBearing(llp, (LatLonPoint)llp2, null);
            double distance = bearing.getDistance();
            if (closest != null && !(distance < minDistance)) continue;
            minDistance = distance;
            closest = station;
        }
        if (closest != null && (url = (String)(properties = closest.getProperties()).get("imageurl")) != null) {
            ReadoutInfo info = new ReadoutInfo(this, null, closest.getEarthLocation(), null);
            info.setImageUrl(url);
            info.setImageName(closest.getName());
            samples.add(info);
        }
        return null;
    }

    @Override
    public MapProjection getDataProjection() {
        return null;
    }

    @Override
    public boolean hasMapProjection() {
        return true;
    }

    @Override
    public MapProjection getDataProjectionForMenu() {
        try {
            List stations = this.getStationList();
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            int cnt = 0;
            for (NamedStationImpl station : stations) {
                NamedLocation ob = station.getNamedLocation();
                visad.georef.LatLonPoint llp = ob.getEarthLocation().getLatLonPoint();
                double lat = llp.getLatitude().getValue(CommonUnit.degree);
                double lon = llp.getLongitude().getValue(CommonUnit.degree);
                if (lat != lat || lon != lon) continue;
                ++cnt;
                if (Math.abs(lat) <= 90.0) {
                    minY = Math.min(minY, lat);
                    maxY = Math.max(maxY, lat);
                }
                if (!(Math.abs(lon) <= 180.0)) continue;
                minX = Math.min(minX, lon);
                maxX = Math.max(maxX, lon);
            }
            if (cnt < 1) {
                return null;
            }
            if (cnt == 1) {
                minX -= 2.0;
                maxX += 2.0;
                minY -= 2.0;
                maxY += 2.0;
            }
            return Util.makeMapProjection(minY, minX, maxY, maxX);
        }
        catch (Exception exc) {
            StationLocationControl.logException("Error reading xml", exc);
            return null;
        }
    }

    @Override
    public void reloadDataSource() throws RemoteException, VisADException {
        this.resetData();
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Projection From Locations";
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        if (!this.getHaveInitialized()) {
            return;
        }
        List choices = this.getDataChoices();
        if (choices.size() == 0) {
            return;
        }
        this.stationTableNames = new ArrayList();
        this.extraStations = new Hashtable();
        DataChoice dataChoice = (DataChoice)choices.get(0);
        Data d = dataChoice.getData(null);
        if (d instanceof Text) {
            try {
                String xml = ((Text)d).getValue();
                this.loadXml(xml);
                this.stationsChanged();
            }
            catch (Exception exc) {
                StationLocationControl.logException("Error reading xml", exc);
            }
        }
    }

    @Override
    public void initDone() {
        super.initDone();
    }

    @Override
    protected void handleChangedStationModel(StationModel changedModel) {
        if (this.useStationModel) {
            super.handleChangedStationModel(changedModel);
        }
    }

    @Override
    protected StationModelDisplayable createStationModelDisplayable() throws VisADException, RemoteException {
        this.locationDisplayable = new StationLocationDisplayable("location displayable", this.getControlContext().getJythonManager());
        this.locationDisplayable.setShouldUseAltitude(false);
        this.addDisplayable((Displayable)this.locationDisplayable, 132);
        this.selectedDisplayable = new StationLocationDisplayable("selected displayable", this.getControlContext().getJythonManager());
        this.selectedDisplayable.setShouldUseAltitude(false);
        this.addDisplayable((Displayable)this.selectedDisplayable, 132);
        this.selectedDisplayable.setRotateShapes(true);
        StationModel sm = this.getControlContext().getStationModelManager().getSelectedStationModel();
        if (sm != null) {
            this.selectedDisplayable.setStationModel(sm);
        }
        this.updateSelectedDisplayable();
        return this.locationDisplayable;
    }

    @Override
    protected void initDisplayable(StationModelDisplayable myDisplay) throws VisADException, RemoteException {
        super.initDisplayable(myDisplay);
        myDisplay.setRotateShapes(true);
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (this.getHaveInitialized()) {
            this.loadDataInAWhile();
        }
        return true;
    }

    @Override
    protected void loadDataInAWhile() {
        super.loadDataInAWhile();
        try {
            this.updateSelectedDisplayable();
        }
        catch (Exception excp) {
            StationLocationControl.logException("Updating selected displayable", excp);
        }
    }

    @Override
    protected void handleMousePressed(EarthLocation el, DisplayEvent event) {
        if (!this.isGuiShown()) {
            return;
        }
        if (!StationLocationControl.isLeftButtonDown(event)) {
            return;
        }
        if (this.displayedStations == null) {
            return;
        }
        if (!this.getDisplayVisibility()) {
            return;
        }
        if (!this.getEnabled() || !this.getHaveInitialized() || this.getMakeWindow() && !this.getWindowVisible()) {
            return;
        }
        try {
            InputEvent inputEvent = event.getInputEvent();
            if (inputEvent.isShiftDown()) {
                return;
            }
            if (!inputEvent.isControlDown()) {
                this.selectionList.clear();
            }
            Bearing bearing = null;
            NamedStationImpl closest = null;
            double distance = Double.MAX_VALUE;
            EarthLocation minEL = null;
            ArrayList stations = new ArrayList(this.displayedStations);
            for (NamedStationImpl station : stations) {
                double tmpDistance;
                NamedLocation ob = station.getNamedLocation();
                if (Math.abs(ob.getEarthLocation().getLatLonPoint().getLatitude().getValue()) > 90.0 || Math.abs(ob.getEarthLocation().getLatLonPoint().getLongitude().getValue()) > 360.0 || !((tmpDistance = (bearing = Util.calculateBearing(ob.getEarthLocation().getLatLonPoint(), el.getLatLonPoint(), bearing)).getDistance()) < distance)) continue;
                closest = station;
                distance = tmpDistance;
                minEL = ob.getEarthLocation();
            }
            if (closest != null) {
                int[] obScreen = this.earthToScreen(minEL);
                double screenDistance = GuiUtils.distance(obScreen[0], obScreen[1], event.getX(), event.getY());
                if (screenDistance > 50.0) {
                    return;
                }
                if (!this.selectionList.contains(closest)) {
                    this.selectionList.add(closest);
                    if (this.tabbedPane != null) {
                        // empty if block
                    }
                } else if (inputEvent.isControlDown()) {
                    this.selectionList.remove(closest);
                }
            }
            this.selectedStationsChanged(this.selectionList);
            this.showSelectedInReadout();
            if (this.centerOnClick) {
                this.getNavigatedDisplay().center(el, true);
            }
        }
        catch (Exception excp) {
            StationLocationControl.logException("Finding closest location", excp);
        }
    }

    protected void selectedStationsChanged(List selectionList) throws VisADException, RemoteException {
        this.updateSelectedDisplayable();
    }

    protected void setSelectedStations(List<NamedStationImpl> stations) throws VisADException, RemoteException {
        this.selectionList = new ArrayList<NamedStationImpl>(stations);
        this.updateSelectedDisplayable();
    }

    private void updateSelectedDisplayable() throws VisADException, RemoteException {
        if (this.selectedDisplayable == null) {
            return;
        }
        StationModel sm = this.getControlContext().getStationModelManager().getSelectedStationModel();
        if (sm != null) {
            this.selectedDisplayable.setStationModel(sm);
        }
        this.selectedDisplayable.setStations(this.selectionList);
    }

    @Override
    protected void setScaleOnDisplayable(float f) throws RemoteException, VisADException {
        super.setScaleOnDisplayable(f);
        if (this.selectedDisplayable != null) {
            this.selectedDisplayable.setScale(f);
        }
    }

    private String cleanupHtml(String s) {
        s = StringUtil.replace(s, "/>", ">");
        s = s.trim();
        return s;
    }

    private StringBuffer getHtml(NamedStationImpl location) {
        StringBuffer sb = new StringBuffer();
        Hashtable properties = location.getProperties();
        Enumeration keys = properties.keys();
        NamedLocation locationOb = location.getNamedLocation();
        EarthLocation locationEl = locationOb.getEarthLocation();
        visad.georef.LatLonPoint llp = locationEl.getLatLonPoint();
        DisplayConventions dc = this.getDisplayConventions();
        String llLabel = dc.formatLatLon(llp.getLatitude().getValue()) + "/" + dc.formatLatLon(llp.getLongitude().getValue());
        StringBuffer entrySB = new StringBuffer();
        entrySB.append("<table>\n");
        entrySB.append("<tr><td><b>Name</b>:</td><td> " + location.getName() + "</td></tr>\n");
        entrySB.append("<tr><td><b>Lat/Lon</b>:</td><td> " + llLabel + "</td></tr>\n");
        String description = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            String lbl = key.toString();
            if (lbl.equalsIgnoreCase("name") || lbl.equalsIgnoreCase("lat") || lbl.equalsIgnoreCase("lon")) continue;
            if (lbl.equalsIgnoreCase("description")) {
                description = (String)properties.get(key);
                continue;
            }
            lbl = lbl.substring(0, 1).toUpperCase() + lbl.substring(1);
            entrySB.append("<tr valign=\"top\"><td><b>" + lbl + "</b>&nbsp;</td><td> " + properties.get(key) + "</td></tr>\n");
        }
        entrySB.append("</table>\n");
        String html = this.cleanupHtml(description);
        sb.append(html);
        sb.append(entrySB);
        return sb;
    }

    private void showSelectedInReadout() {
        if (this.selectionList.size() == 0) {
            this.readoutText.setText("<html></html>");
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            NamedStationImpl location = (NamedStationImpl)this.selectionList.get(i);
            sb.append(this.getHtml(location));
        }
        if (this.readoutText != null && sb != null) {
            this.readoutText.setText("<html>" + this.getStationTableDescription() + sb.toString() + "</html>");
            GuiUtils.scrollToTop(this.readoutText);
        }
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        return GuiUtils.vbox(parentComp, this.readoutLegendHolder);
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        for (int i = 0; i < this.stationTableNames.size() && i < 3; ++i) {
            labels.add(this.stationTableNames.get(i));
        }
    }

    @Override
    public String getMenuLabel() {
        if (this.stationTableNames.size() > 0) {
            String label = "Locations:";
            for (int i = 0; i < this.stationTableNames.size() && i < 3; ++i) {
                label = label + " " + this.stationTableNames.get(i);
            }
            return label;
        }
        return super.getMenuLabel();
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        return null;
    }

    @Override
    protected List getFilterNames() {
        List stations = this.getStationList();
        if (stations == null || stations.size() == 0) {
            return Misc.newList("Name");
        }
        NamedStationImpl station = (NamedStationImpl)stations.get(0);
        Hashtable properties = station.getProperties();
        Enumeration keys = properties.keys();
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add("--");
        boolean haveName = false;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!haveName && key.toLowerCase().equals("name")) {
                haveName = true;
            }
            keyList.add(key);
        }
        if (!haveName) {
            keyList.add(0, "Name");
        }
        return keyList;
    }

    @Override
    protected String getDetailsContents() {
        StringBuffer sb = new StringBuffer(super.getDetailsContents());
        List names = this.getFilterNames();
        names.remove(0);
        sb.append("<b>Location property names:</b><ul><li>");
        sb.append(StringUtil.join("<li>", names));
        sb.append("</ul>");
        return sb.toString();
    }

    private List filter(List stations) {
        if (stations == null) {
            return new ArrayList();
        }
        this.initFilters();
        if (!this.getFiltersEnabled()) {
            return stations;
        }
        ArrayList<NamedStationImpl> result = new ArrayList<NamedStationImpl>();
        boolean matchAll = this.getMatchAll();
        for (NamedStationImpl station : stations) {
            boolean ok = true;
            Hashtable objectProperties = station.getProperties();
            for (int i = 0; i < this.filters.size(); ++i) {
                PropertyFilter filter = (PropertyFilter)this.filters.get(i);
                String objectValue = filter.getName().equals("Name") ? station.getName() : objectProperties.get(filter.getName());
                if (objectValue == null) {
                    ok = false;
                    break;
                }
                ok = filter.ok(objectValue);
                if (matchAll && !ok || !matchAll && ok) break;
            }
            if (!ok) continue;
            result.add(station);
        }
        return result;
    }

    private List subsetStations(List stations) throws VisADException, RemoteException {
        Rectangle2D rbounds = this.calculateRectangle();
        if (rbounds == null) {
            return new ArrayList();
        }
        LinearLatLonSet bounds = this.calculateLatLonBounds(rbounds);
        if (bounds == null) {
            return new ArrayList();
        }
        Unit[] units = bounds.getSetUnits();
        int latIndex = ((RealType)((SetType)bounds.getType()).getDomain().getComponent(0)).equals(RealType.Latitude) ? 0 : 1;
        Vector<NamedStationImpl> v = new Vector<NamedStationImpl>();
        float[][] values = new float[2][1];
        Trace.call1("StationLocationControl.subset");
        Rectangle screenBounds = this.getScreenBounds();
        for (int i = 0; i < stations.size(); ++i) {
            NamedStationImpl st = (NamedStationImpl)stations.get(i);
            EarthLocation el = st.getEarthLocation();
            values[0][0] = (float)el.getLatitude().getValue(units[latIndex]);
            values[1][0] = (float)el.getLongitude().getValue(units[1 - latIndex]);
            float[][] grids = bounds.valueToGrid(values);
            if (grids[0][0] != grids[0][0] || grids[1][0] != grids[1][0]) continue;
            v.add(st);
        }
        Trace.call2("StationLocationControl.subset");
        return v;
    }

    private void updateTable() {
        final List sortedStations = Misc.sort(this.displayedStations);
        final List allSortedStations = Misc.sort(this.getStationList());
        GuiUtils.invokeInSwingThread(new Runnable(){

            @Override
            public void run() {
                StationLocationControl.this.locationsTableModel.setLocations(sortedStations);
                StationLocationControl.this.allLocationsTableModel.setLocations(allSortedStations);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData() {
        block24: {
            try {
                boolean alwaysShow;
                this.updateDisplayable();
                List listOfStations = this.getStationList();
                List filteredStations = this.filter(listOfStations);
                boolean bl = alwaysShow = !this.getOnlyShowFiltered() && this.haveFilters();
                if (this.getOnlyShowFiltered()) {
                    listOfStations = filteredStations;
                }
                listOfStations = this.subsetStations(listOfStations);
                if (this.getDeclutter()) {
                    if (this.stationsLocked && this.lastDeclutteredStationList != null) {
                        listOfStations = this.lastDeclutteredStationList;
                    } else {
                        Trace.call1("StationLocationControl.declutter");
                        listOfStations = this.declutter(listOfStations, alwaysShow ? filteredStations : null);
                        Trace.call2("StationLocationControl.declutter");
                    }
                    this.lastDeclutteredStationList = listOfStations;
                } else {
                    this.lastDeclutteredStationList = null;
                }
                if (alwaysShow) {
                    for (int i = 0; i < filteredStations.size(); ++i) {
                        Object selectedLocation = filteredStations.get(i);
                        if (listOfStations.contains(selectedLocation)) continue;
                        listOfStations.add(selectedLocation);
                    }
                }
                this.addSelectedToList(listOfStations);
                if (this.locationsTable != null) {
                    if (this.locationsTable.lastClicked != null && !listOfStations.contains(this.locationsTable.lastClicked)) {
                        listOfStations.add(this.locationsTable.lastClicked);
                    }
                    if (this.allLocationsTable.lastClicked != null && !listOfStations.contains(this.allLocationsTable.lastClicked)) {
                        listOfStations.add(this.allLocationsTable.lastClicked);
                    }
                }
                if (listOfStations == null) break block24;
                Object object = this.DISPLAYABLE_MUTEX;
                synchronized (object) {
                    this.displayedStations = listOfStations;
                    if (this.selectedDisplayable != null) {
                        // empty if block
                    }
                    if (this.locationDisplayable != null) {
                        Trace.call1("setStations");
                        this.locationDisplayable.setStations(listOfStations);
                        Trace.call2("setStations");
                        if (this.locationsTableModel != null) {
                            this.updateTable();
                        }
                        ArrayList<Gridded3DSet> datum = null;
                        for (int i = 0; i < listOfStations.size(); ++i) {
                            NamedStationImpl st = (NamedStationImpl)listOfStations.get(i);
                            List coords = st.getCoords();
                            if (coords == null) continue;
                            for (int coordIdx = 0; coordIdx < coords.size(); ++coordIdx) {
                                float[][] coord = Misc.toFloat((double[][])coords.get(coordIdx));
                                RealTupleType coordMathType = coord.length == 2 ? new RealTupleType(RealType.Longitude, RealType.Latitude) : new RealTupleType(RealType.Longitude, RealType.Latitude, RealType.Altitude);
                                Gridded3DSet data = new Gridded3DSet((MathType)coordMathType, coord, coord[0].length);
                                if (datum == null) {
                                    datum = new ArrayList<Gridded3DSet>();
                                }
                                datum.add(data);
                            }
                        }
                        if (datum != null) {
                            if (this.coordDisplayable == null) {
                                this.coordDisplayable = new LineDrawing("station lines");
                                this.addDisplayable((Displayable)this.coordDisplayable, 1028);
                                if (this.coordAttributeLabel == null) {
                                    this.coordAttributeLabel = new JLabel("");
                                    this.coordAttributePanel = new JPanel(new BorderLayout());
                                }
                                this.coordAttributeLabel.setText("Line Width:");
                                this.coordAttributePanel.add("Center", this.getLineWidthWidget().getContents(false));
                            }
                            SampledSet[] coordArray = datum.toArray(new SampledSet[datum.size()]);
                            UnionSet unionSet = new UnionSet(coordArray);
                            this.coordDisplayable.setData(unionSet);
                        }
                    }
                }
            }
            catch (Exception excp) {
                StationLocationControl.logException("loading data ", excp);
            }
        }
    }

    protected void addSelectedToList(List listOfStations) {
        for (int i = 0; i < this.selectionList.size(); ++i) {
            Object selectedLocation = this.selectionList.get(i);
            if (listOfStations.contains(selectedLocation)) continue;
            listOfStations.add(selectedLocation);
        }
    }

    protected String getStationTableDescription() {
        StringBuffer sb = new StringBuffer();
        int cnt = 0;
        for (int j = 0; j < this.stationTableNames.size(); ++j) {
            String name = (String)this.stationTableNames.get(j);
            NamedStationTable stationTable = this.getControlContext().getResourceManager().findLocations(name);
            if (stationTable == null) {
                stationTable = (NamedStationTable)this.extraStations.get(name);
            }
            if (stationTable == null || stationTable.getDescription() == null) continue;
            if (cnt != 0) {
                sb.append("<br>");
            }
            sb.append(stationTable.getDescription());
            ++cnt;
        }
        return sb.toString();
    }

    protected List getStationList() {
        ArrayList stations = new ArrayList();
        for (int j = 0; j < this.stationTableNames.size(); ++j) {
            String name = (String)this.stationTableNames.get(j);
            NamedStationTable stationTable = this.getControlContext().getResourceManager().findLocations(name);
            if (stationTable != null) {
                stations.addAll(stationTable.values());
                continue;
            }
            stationTable = (NamedStationTable)this.extraStations.get(name);
            if (stationTable == null) continue;
            stations.addAll(stationTable.values());
        }
        return stations;
    }

    public StationModel getMyStationModel() {
        if (this.locationDisplayable != null && !this.useStationModel) {
            return this.locationDisplayable.getStationModel();
        }
        return super.getStationModel();
    }

    private List declutter(List stations, List preLoad) throws VisADException, RemoteException {
        EarthLocation el;
        if (stations == null || stations.isEmpty()) {
            return stations;
        }
        Rectangle obView = this.getMyStationModel().getBounds();
        float myScale = this.getScale() * 0.0025f * this.getDeclutterFilter();
        Rectangle2D.Double viewBounds = new Rectangle2D.Double(obView.getX() * (double)myScale, obView.getY() * (double)myScale, obView.getWidth() * (double)myScale, obView.getHeight() * (double)myScale);
        Vector<NamedStationImpl> v = new Vector<NamedStationImpl>();
        SpatialGrid stationGrid = new SpatialGrid(100, 100);
        stationGrid.clear();
        stationGrid.setGrid(this.getBounds(), viewBounds);
        double[] xyz = null;
        Rectangle2D.Double obBounds = new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)viewBounds).getWidth(), ((RectangularShape)viewBounds).getHeight());
        double vbX = ((RectangularShape)viewBounds).getX();
        double vbY = ((RectangularShape)viewBounds).getY();
        if (preLoad != null) {
            for (NamedStationImpl station : preLoad) {
                el = station.getEarthLocation();
                xyz = this.earthToBox(el);
                obBounds.x = xyz[0] + vbX;
                obBounds.y = xyz[1] + vbY;
                stationGrid.markIfClear(obBounds, el);
                stations.remove(station);
            }
        }
        for (NamedStationImpl station : stations) {
            el = station.getEarthLocation();
            xyz = this.earthToBox(el);
            obBounds.x = xyz[0] + vbX;
            obBounds.y = xyz[1] + vbY;
            if (!stationGrid.markIfClear(obBounds, el)) continue;
            v.add(station);
        }
        return v;
    }

    public void setStationTableName(String value) {
        this.stationTableName = value;
    }

    public void setStationTableNames(List value) {
        this.stationTableNames = value;
    }

    public List getStationTableNames() {
        return this.stationTableNames;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        return this.doMakeTabs(true, true);
    }

    protected JTabbedPane doMakeTabs(boolean showDataSets, boolean showFilters) throws VisADException, RemoteException {
        this.readoutLegendHolder = new JPanel(new BorderLayout());
        this.readoutGuiHolder = new JPanel(new BorderLayout());
        this.readoutText = new JEditorPane();
        GuiUtils.addLinkListener(this.readoutText);
        this.readoutText.setEditable(false);
        this.readoutText.setContentType("text/html");
        this.readoutComp = new JPanel(new BorderLayout());
        this.readoutSP = new JScrollPane(this.readoutText, 22, 30);
        this.readoutComp.add("Center", this.readoutSP);
        this.readoutGuiHolder.add("Center", this.readoutComp);
        this.tabbedPane = GuiUtils.getNestedTabbedPane();
        JPanel readoutContents = GuiUtils.topCenter(GuiUtils.left(GuiUtils.hbox(GuiUtils.makeCheckbox("Listen for clicks", this, "enabled"), GuiUtils.makeCheckbox("Center on selected", this, "centerOnClick"))), this.readoutGuiHolder);
        this.locationsTableModel = new LocationTableModel(this.sortedDisplayedStations);
        this.allLocationsTableModel = new LocationTableModel(this.getStationList());
        this.locationsTable = new LocationTable(this.locationsTableModel){

            @Override
            public String toString() {
                return "locations";
            }
        };
        this.allLocationsTable = new LocationTable(this.allLocationsTableModel){

            @Override
            public String toString() {
                return "all locations";
            }
        };
        JTabbedPane locationTab = GuiUtils.getNestedTabbedPane();
        locationTab.add("All Locations", this.allLocationsTable.getScroller());
        locationTab.add("Displayed Locations", this.locationsTable.getScroller());
        locationTab.setPreferredSize(new Dimension(200, 250));
        readoutContents.setPreferredSize(new Dimension(200, 250));
        JPanel locationComp = GuiUtils.doLayout(new Component[]{locationTab, readoutContents}, 1, GuiUtils.WT_Y, new double[]{1.0, 3.0});
        this.tabbedPane.add("Display", this.doMakeDisplayPanel());
        this.tabbedPane.add("Locations", locationComp);
        if (showDataSets) {
            this.tabbedPane.add("Data Sets", this.doMakeStationListPanel());
        }
        if (showFilters) {
            this.tabbedPane.add("Filters", this.doMakeFilterGui(true));
        }
        return this.tabbedPane;
    }

    protected JComponent doMakeDisplayPanel() {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        JCheckBox toggle = GuiUtils.makeCheckbox("", this, "declutter");
        comps.add(GuiUtils.rLabel("Declutter:"));
        comps.add(GuiUtils.hbox(Misc.newList(toggle, this.getLockButton(), new JLabel("Density: "), this.getDensityControl()), 5));
        comps.add(new JLabel(" "));
        comps.add(new JLabel(" "));
        Vector<TwoFacedObject> idItems = new Vector<TwoFacedObject>();
        for (int i = 0; i < StationLocationDisplayable.IDS.length; ++i) {
            idItems.add(new TwoFacedObject((Object)StationLocationDisplayable.ID_NAMES[i], new Integer(StationLocationDisplayable.IDS[i])));
        }
        final JComboBox idBox = new JComboBox(idItems);
        idBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TwoFacedObject tfo = (TwoFacedObject)idBox.getSelectedItem();
                StationLocationControl.this.idType = (Integer)tfo.getId();
                StationLocationControl.this.updateDisplayable();
            }
        });
        Vector<TwoFacedObject> symbolItems = new Vector<TwoFacedObject>();
        for (int i = 0; i < StationLocationDisplayable.SYMBOLS.length; ++i) {
            symbolItems.add(new TwoFacedObject((Object)StationLocationDisplayable.SYMBOL_NAMES[i], new Integer(StationLocationDisplayable.SYMBOLS[i])));
        }
        final JComboBox symbolBox = new JComboBox(symbolItems);
        symbolBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TwoFacedObject tfo = (TwoFacedObject)symbolBox.getSelectedItem();
                StationLocationControl.this.symbolType = (Integer)tfo.getId();
                StationLocationControl.this.updateDisplayable();
            }
        });
        this.layoutModelWidget = new LayoutModelWidget(this, (Object)this, "setStationModelFromWidget", this.getStationModel());
        this.stationModelPanel = this.layoutModelWidget;
        JRadioButton[] displayRbs = GuiUtils.makeRadioButtons(Misc.newList("Predefined:", "Layout Model:"), this.useStationModel ? 1 : 0, this, "buttonPressed");
        JCheckBox idShow = GuiUtils.makeCheckbox("", this, "showId");
        JCheckBox symbolShow = GuiUtils.makeCheckbox("", this, "showSymbol");
        List symbolComps = Misc.newList(GuiUtils.rLabel("Id:  "), idBox, idShow);
        symbolComps.add(GuiUtils.rLabel("Symbol:  "));
        symbolComps.add(symbolBox);
        symbolComps.add(symbolShow);
        symbolComps.add(GuiUtils.rLabel("Color:  "));
        symbolComps.add(this.doMakeColorControl(this.getColor()));
        symbolComps.add(GuiUtils.filler());
        GuiUtils.tmpInsets = new Insets(4, 0, 0, 0);
        this.symbolPanel = GuiUtils.doLayout(symbolComps, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
        this.symbolPanel = GuiUtils.left(this.symbolPanel);
        if (!this.useStationModel) {
            GuiUtils.enableTree(this.stationModelPanel, false);
        } else {
            GuiUtils.enableTree(this.symbolPanel, false);
        }
        JPanel displayPanel = GuiUtils.doLayout(new Component[]{displayRbs[0], displayRbs[1], this.symbolPanel, GuiUtils.top(GuiUtils.left(this.stationModelPanel))}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        comps.add(GuiUtils.top(GuiUtils.rLabel("Display:")));
        comps.add(GuiUtils.left(displayPanel));
        comps.add(new JLabel(" "));
        comps.add(new JLabel(" "));
        comps.add(GuiUtils.top(GuiUtils.rLabel("Vertical Position:")));
        comps.add(this.doMakeVerticalPositionPanel());
        if (this.coordAttributeLabel == null) {
            this.coordAttributeLabel = new JLabel("");
            this.coordAttributePanel = new JPanel(new BorderLayout());
        }
        comps.add(this.coordAttributeLabel);
        comps.add(this.coordAttributePanel);
        GuiUtils.tmpInsets = new Insets(4, 4, 0, 4);
        JPanel topPanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        GuiUtils.enableComponents(this.densityComps, this.getDeclutter());
        return GuiUtils.top(topPanel);
    }

    protected JComponent doMakeStationListPanel() {
        this.stationJList = new JList();
        this.stationJList.setToolTipText("<html>Press 'Up' or 'Down' arrow to move selected station list.<br>Press 'Delete' to remove selected station list.</html>");
        this.stationJList.setVisibleRowCount(4);
        this.stationJList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object selected = StationLocationControl.this.stationJList.getSelectedValue();
                if (selected == null) {
                    return;
                }
                if (e.getKeyCode() == 40) {
                    int index = StationLocationControl.this.stationJList.getSelectedIndex();
                    if (index >= StationLocationControl.this.stationTableNames.size() - 1) {
                        return;
                    }
                    selected = StationLocationControl.this.stationTableNames.remove(index);
                    StationLocationControl.this.stationTableNames.add(index + 1, selected);
                } else if (e.getKeyCode() == 38) {
                    int index = StationLocationControl.this.stationJList.getSelectedIndex();
                    if (index == 0) {
                        return;
                    }
                    selected = StationLocationControl.this.stationTableNames.remove(index);
                    StationLocationControl.this.stationTableNames.add(index - 1, selected);
                } else if (GuiUtils.isDeleteEvent(e)) {
                    StationLocationControl.this.stationTableNames.remove(selected);
                } else {
                    return;
                }
                StationLocationControl.this.stationsChanged();
            }
        });
        JScrollPane stationScroller = GuiUtils.makeScrollPane(this.stationJList, 200, 100);
        this.stationJList.setListData(new Vector(this.stationTableNames));
        return stationScroller;
    }

    public void buttonPressed(int index) {
        if (this.stationModelPanel == null || this.symbolPanel == null) {
            return;
        }
        this.useStationModel = index == 1;
        GuiUtils.enableTree(this.stationModelPanel, this.useStationModel);
        GuiUtils.enableTree(this.symbolPanel, !this.useStationModel);
        this.updateDisplayable();
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        List namedStations = this.getStationList();
        if (namedStations != null && namedStations.size() > 0) {
            items.add(GuiUtils.makeMenuItem("Export Locations...", this, "exportLocations"));
        }
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        MapViewManager mvm = this.getMapViewManager();
        if (mvm != null) {
            items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Show Flythrough", this, "showFlythrough", null), "/auxdata/ui/icons/plane.png"));
        }
        super.getViewMenuItems(items, forMenuBar);
    }

    public void showFlythrough() throws Exception {
        MapViewManager mvm = this.getMapViewManager();
        ArrayList<FlythroughPoint> points = new ArrayList<FlythroughPoint>();
        List sortedStations = Misc.sort(this.displayedStations);
        for (int i = 0; i < sortedStations.size(); ++i) {
            NamedStationImpl station = (NamedStationImpl)sortedStations.get(i);
            FlythroughPoint pt = new FlythroughPoint(station.getEarthLocation());
            pt.setDescription(this.getHtml(station).toString());
            points.add(pt);
        }
        mvm.flythrough(points);
    }

    public void exportLocations() {
        PatternFileFilter xmlFilter = new PatternFileFilter(".+\\.xml", "Location XML Format", ".xml");
        String filename = FileManager.getWriteFile(xmlFilter, ".xml");
        if (filename == null) {
            return;
        }
        try {
            List stations = this.getStationList();
            String xml = NamedStationTable.getStationXml(IOUtil.getFileTail(filename), null, stations);
            IOUtil.writeFile(new File(filename), xml);
        }
        catch (Exception exc) {
            StationLocationControl.logException("Writing locations", exc);
        }
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        ObjectListener listener = new ObjectListener(""){

            @Override
            public void actionPerformed(ActionEvent ae, Object obj) {
                String name = ((NamedStationTable)obj).getFullName();
                StationLocationControl.this.stationTableNames.add(name);
                StationLocationControl.this.stationsChanged();
            }
        };
        List stationTables = this.getControlContext().getLocationList();
        items.add(GuiUtils.makeMenu("Add Locations", NamedStationTable.makeMenuItems(stationTables, listener)));
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    protected void makeStationModelEditMenuItems(List items, boolean forMenuBar) {
    }

    private void stationsChanged() {
        this.lastDeclutteredStationList = null;
        if (this.stationJList != null) {
            this.stationJList.setListData(new Vector(this.stationTableNames));
        }
        this.loadData();
        this.updateLegendLabel();
    }

    private Component[] makeRadio(String prefix, int onId, int[] ids, String[] names) {
        ButtonGroup typeGroup = new ButtonGroup();
        Component[] comps = new Component[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            JRadioButton rb = new JRadioButton(names[i], ids[i] == onId);
            rb.setActionCommand(prefix + ids[i]);
            rb.addActionListener(this);
            typeGroup.add(rb);
            comps[i] = rb;
        }
        return comps;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.startsWith("symbol")) {
            this.symbolType = new Integer(cmd.substring(6));
            this.updateDisplayable();
        } else if (cmd.startsWith("id")) {
            this.idType = new Integer(cmd.substring(2));
            this.updateDisplayable();
        } else {
            super.actionPerformed(ae);
        }
    }

    private void updateDisplayable() {
        try {
            if (this.locationDisplayable != null) {
                if (this.useStationModel) {
                    this.locationDisplayable.setStationModel(super.getStationModel());
                    this.locationDisplayable.updateDisplayable();
                } else {
                    this.locationDisplayable.setDisplayState(this.symbolType, this.showSymbol, this.idType, this.showId);
                }
            }
        }
        catch (Exception exc) {
            StationLocationControl.logException("Updating displayable", exc);
        }
    }

    public void setSymbolType(int value) {
        this.symbolType = value;
    }

    public int getSymbolType() {
        return this.symbolType;
    }

    public void setIdType(int value) {
        this.idType = value;
    }

    public int getIdType() {
        return this.idType;
    }

    public void setShowSymbol(boolean value) {
        this.showSymbol = value;
        if (this.getHaveInitialized()) {
            this.updateDisplayable();
        }
    }

    public boolean getShowSymbol() {
        return this.showSymbol;
    }

    public void setShowId(boolean value) {
        this.showId = value;
        if (this.getHaveInitialized()) {
            this.updateDisplayable();
        }
    }

    public boolean getShowId() {
        return this.showId;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setCenterOnClick(boolean value) {
        this.centerOnClick = value;
    }

    public boolean getCenterOnClick() {
        return this.centerOnClick;
    }

    public void setUseStationModel(boolean value) {
        this.useStationModel = value;
    }

    public boolean getUseStationModel() {
        return this.useStationModel;
    }

    @Override
    public void setOnlyShowFiltered(boolean value) {
        this.lastDeclutteredStationList = null;
        super.setOnlyShowFiltered(value);
    }

    @Override
    public void setDeclutter(boolean v) {
        super.setDeclutter(v);
        if (this.getHaveInitialized()) {
            Misc.run(this, "loadData");
        }
    }

    public void setDetailsInLegend(boolean value) {
        if (this.readoutInLegend == value) {
            return;
        }
        this.readoutInLegend = value;
        if (this.readoutLegendHolder != null) {
            if (value) {
                this.readoutLegendHolder.add("Center", this.readoutComp);
            } else {
                this.readoutGuiHolder.add("Center", this.readoutComp);
            }
        }
    }

    public boolean getDetailsInLegend() {
        return this.readoutInLegend;
    }

    private class LocationTableModel
    extends AbstractTableModel {
        List locations;
        List attributes;

        public LocationTableModel(List locations) {
            this.locations = locations;
            this.attributes = new ArrayList();
            List tmp = StationLocationControl.this.getStationList();
            if (tmp != null && tmp.size() > 0) {
                NamedStationImpl station = (NamedStationImpl)tmp.get(0);
                Hashtable properties = station.getProperties();
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("name")) continue;
                    this.attributes.add(key);
                }
            }
        }

        public void setLocations(List l) {
            if (!Misc.equals(l, this.locations)) {
                this.locations = l;
                this.fireTableStructureChanged();
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.locations.size();
        }

        @Override
        public int getColumnCount() {
            return 1 + this.attributes.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            int index;
            if (row >= this.locations.size()) {
                return "";
            }
            NamedStationImpl station = (NamedStationImpl)this.locations.get(row);
            if (column == 0) {
                String id = station.getID();
                String name = station.getName();
                if (id != null && id.trim().length() > 0 && !Misc.equals(id, name)) {
                    return name + " (" + id + ")";
                }
                return name;
            }
            if (column > 0 && (index = column - 1) >= 0 && index < this.attributes.size()) {
                Object key = this.attributes.get(index);
                Object o = station.getProperties().get(key);
                if (o != null) {
                    o = StringUtil.stripTags(o.toString());
                }
                return o;
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            int index;
            if (column == 0) {
                return "Name";
            }
            if (column > 0 && (index = column - 1) >= 0 && index < this.attributes.size()) {
                return (String)this.attributes.get(index);
            }
            return "";
        }
    }

    private class LocationTable
    extends JTable {
        LocationTableModel myTableModel;
        TableSorter mySorter;
        NamedStationImpl lastClicked;
        boolean initialized = false;

        public LocationTable(LocationTableModel tableModel) {
            this.myTableModel = tableModel;
            this.mySorter = new TableSorter(tableModel);
            this.setModel(this.mySorter);
            this.setSelectionMode(0);
            this.setToolTipText("<html>Click to center; <br>Shift-Click to center and zoom in<br>Control-Click to center and zoom out</html>");
            this.mySorter.setTableHeader(this.getTableHeader());
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    NamedStationImpl station;
                    String k = KeyEvent.getKeyText(ke.getKeyCode()).toLowerCase();
                    if (k.length() > 1) {
                        return;
                    }
                    int selectedRow = LocationTable.this.getSelectedRow();
                    selectedRow = selectedRow < 0 ? 0 : (k.compareTo((station = (NamedStationImpl)LocationTable.this.myTableModel.locations.get(selectedRow)).getName().toLowerCase().substring(0, 1)) >= 0 ? ++selectedRow : 0);
                    for (int row = selectedRow; row < LocationTable.this.myTableModel.locations.size(); ++row) {
                        NamedStationImpl station2 = (NamedStationImpl)LocationTable.this.myTableModel.locations.get(row);
                        if (!station2.getName().toLowerCase().startsWith(k)) continue;
                        LocationTable.this.lastClicked = station2;
                        LocationTable.this.setRowSelectionInterval(row, row);
                        GuiUtils.makeRowVisible(LocationTable.this, row);
                        try {
                            LocationTable.this.stationSelected(station2);
                            if (!StationLocationControl.this.getCenterOnClick()) break;
                            StationLocationControl.this.getNavigatedDisplay().center(station2.getEarthLocation(), true);
                        }
                        catch (Exception exc) {
                            DisplayControlBase.logException("Setting location", exc);
                        }
                        break;
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        return;
                    }
                    int row = LocationTable.this.mySorter.modelIndex(LocationTable.this.rowAtPoint(e.getPoint()));
                    List locations = LocationTable.this.myTableModel.locations;
                    if (row < 0 || row >= locations.size()) {
                        return;
                    }
                    try {
                        NamedStationImpl station;
                        LocationTable.this.lastClicked = station = (NamedStationImpl)locations.get(row);
                        if (e.isShiftDown() || e.isControlDown()) {
                            if (StationLocationControl.this.getCenterOnClick()) {
                                StationLocationControl.this.getNavigatedDisplay().centerAndZoom(station.getEarthLocation(), true, e.isShiftDown() ? 2.0 : 0.5);
                            }
                        } else if (StationLocationControl.this.getCenterOnClick()) {
                            StationLocationControl.this.getNavigatedDisplay().center(station.getEarthLocation(), true);
                        }
                        LocationTable.this.stationSelected(station);
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("Setting location", exc);
                    }
                }
            });
            this.initialized = true;
        }

        public JScrollPane getScroller() {
            JScrollPane sp = new JScrollPane(this);
            sp.setPreferredSize(new Dimension(300, 200));
            return sp;
        }

        protected void stationSelected(NamedStationImpl station) throws VisADException, RemoteException {
            if (!StationLocationControl.this.selectionList.contains(station)) {
                StationLocationControl.this.selectionList.clear();
                StationLocationControl.this.selectionList.add(station);
                StationLocationControl.this.selectedStationsChanged(StationLocationControl.this.selectionList);
                StationLocationControl.this.showSelectedInReadout();
            }
        }

        protected void clearSelectedStations() throws VisADException, RemoteException {
            StationLocationControl.this.selectionList.clear();
            StationLocationControl.this.selectedStationsChanged(StationLocationControl.this.selectionList);
            StationLocationControl.this.showSelectedInReadout();
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            super.valueChanged(event);
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (!this.initialized) {
                return;
            }
            if (!StationLocationControl.this.getEnabled()) {
                return;
            }
            List locations = this.myTableModel.locations;
            int row = this.getSelectedRow();
            if (row < 0 || row >= locations.size()) {
                return;
            }
            try {
                NamedStationImpl station = (NamedStationImpl)locations.get(row);
                if (this.lastClicked == station) {
                    return;
                }
                if (StationLocationControl.this.getCenterOnClick()) {
                    StationLocationControl.this.getNavigatedDisplay().center(station.getEarthLocation(), true);
                }
                this.stationSelected(station);
            }
            catch (Exception exc) {
                DisplayControlBase.logException("Setting location", exc);
            }
        }
    }
}

