/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.ui.TableSorter;
import ucar.visad.Util;
import ucar.visad.quantities.Direction;
import ucar.visad.quantities.PolarHorizontalWind;
import ucar.visad.quantities.Speed;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Field;
import visad.FunctionType;
import visad.InverseCoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class SoundingTable
extends JTable {
    private AbstractTableModel model = null;
    private TableSorter sorter = null;
    private Field[] soundings;
    private float[][] rangeData;
    private float[][] domainData;
    private int numDomainCols;
    private int numRangeCols;
    private String[] columnNames;
    private int currSounding = 0;
    private boolean showUAndV = false;
    private boolean haveUV = false;
    private boolean transformWinds = false;
    private CoordinateSystem windTransform = null;
    private Unit[] csUnits;

    public SoundingTable(DisplayControlImpl display) {
    }

    public void setSoundings(Field[] soundings) throws VisADException, RemoteException {
        this.soundings = soundings;
        if (soundings != null) {
            this.setupTable(soundings[0]);
            this.setSounding(soundings[this.currSounding]);
        }
    }

    public void setCurrentSounding(int index) throws VisADException, RemoteException {
        if (this.soundings == null || index < 0 || index >= this.soundings.length) {
            return;
        }
        this.currSounding = index;
        this.setSounding(this.soundings[this.currSounding]);
    }

    private void setSounding(Field sounding) throws VisADException, RemoteException {
        this.domainData = null;
        Set domain = sounding.getDomainSet();
        CoordinateSystem cs = domain.getCoordinateSystem();
        float[][] domSamples = domain.getSamples(false);
        if (cs != null) {
            String toUnit;
            float[][] domFloats = Set.copyFloats(domSamples);
            String fromUnit = sounding.getDomainUnits()[0].toString();
            if (!fromUnit.equals(toUnit = cs.getCoordinateSystemUnits()[0].toString()) && SimpleUnit.isCompatible(fromUnit, toUnit)) {
                float conversionFactor = (float)SimpleUnit.getConversionFactor(fromUnit, toUnit);
                for (int i = 0; i < domFloats.length; ++i) {
                    for (int j = 0; j < domFloats[i].length; ++j) {
                        domFloats[i][j] = domFloats[i][j] * conversionFactor;
                    }
                }
            }
            float[][] refData = cs.toReference(domFloats);
            this.domainData = new float[][]{domSamples[0], refData[0]};
        }
        RealType[] rangeComps = ((FunctionType)sounding.getType()).getRealComponents();
        this.rangeData = sounding.getFloats(false);
        if (rangeComps.length > 2) {
            boolean bl = this.transformWinds = this.showUAndV && !this.haveUV || !this.showUAndV && this.haveUV;
            if (!this.transformWinds) {
                for (int i = 2; i < 4; ++i) {
                    this.columnNames[this.numDomainCols + i] = this.makeColumnName(rangeComps[i], rangeComps[i].getDefaultUnit());
                }
            } else {
                RealTupleType refType = this.windTransform.getReference();
                Unit[] refUnits = this.windTransform.getReferenceUnits();
                for (int i = 0; i < 2; ++i) {
                    this.columnNames[this.numDomainCols + i + 2] = this.makeColumnName((RealType)refType.getComponent(i), refUnits[i]);
                }
                float[][] newVals = this.windTransform.toReference(Set.copyFloats(new float[][]{this.rangeData[2], this.rangeData[3]}));
                this.rangeData[2] = newVals[0];
                this.rangeData[3] = newVals[1];
            }
        }
        this.sorter.setTableModel(this.model);
    }

    private void setupTable(Field sounding) throws VisADException, RemoteException {
        Set domain = sounding.getDomainSet();
        CoordinateSystem cs = domain.getCoordinateSystem();
        this.numDomainCols = domain.getDimension();
        if (cs != null) {
            ++this.numDomainCols;
        }
        RealType[] rangeComps = ((FunctionType)sounding.getType()).getRealComponents();
        this.numRangeCols = rangeComps.length;
        this.columnNames = new String[this.numDomainCols + this.numRangeCols];
        SetType t = (SetType)domain.getType();
        Unit[] units = domain.getSetUnits();
        RealTupleType rtt = t.getDomain();
        RealType[] comps = rtt.getRealComponents();
        this.columnNames[0] = this.makeColumnName(comps[0], units[0]);
        if (cs != null) {
            RealTupleType refType = cs.getReference();
            RealType[] refComps = refType.getRealComponents();
            Unit[] refUnits = cs.getReferenceUnits();
            this.columnNames[1] = this.makeColumnName(refComps[0], refUnits[0]);
        }
        for (int i = 0; i < rangeComps.length; ++i) {
            this.columnNames[this.numDomainCols + i] = this.makeColumnName(rangeComps[i], rangeComps[i].getDefaultUnit());
        }
        if (rangeComps.length > 2) {
            this.csUnits = new Unit[]{rangeComps[2].getDefaultUnit(), rangeComps[3].getDefaultUnit()};
            this.haveUV = Unit.canConvert(this.csUnits[0], CommonUnit.meterPerSecond) && Unit.canConvert(this.csUnits[1], CommonUnit.meterPerSecond);
            this.windTransform = this.haveUV ? new InverseCoordinateSystem(new RealTupleType(Speed.getRealType(), Direction.getRealType()), new PolarHorizontalWind.PolarCoordinateSystem(new RealTupleType(rangeComps[2], rangeComps[3]), CommonUnit.meterPerSecond, CommonUnit.degree)) : new PolarHorizontalWind.PolarCoordinateSystem(this.csUnits[0], this.csUnits[1]);
        }
        if (this.model == null) {
            this.model = new SoundingTableModel();
            this.sorter = new TableSorter(this.model);
            JTableHeader header = this.getTableHeader();
            header.setToolTipText("Click to sort");
            this.sorter.setTableHeader(this.getTableHeader());
            this.setModel(this.sorter);
            this.setAutoResizeMode(2);
            this.setPreferredScrollableViewportSize(new Dimension(400, 200));
            this.getTableHeader().setReorderingAllowed(false);
        }
    }

    private String makeColumnName(RealType rt, Unit unit) {
        return Util.cleanTypeName(rt) + " [" + unit + "]";
    }

    public void setShowUVComps(boolean showUV) {
        this.showUAndV = showUV;
        try {
            this.setCurrentSounding(this.currSounding);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class SoundingTableModel
    extends AbstractTableModel {
        SoundingTableModel() {
        }

        @Override
        public int getColumnCount() {
            return SoundingTable.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (SoundingTable.this.domainData == null) {
                return 0;
            }
            return SoundingTable.this.domainData[0].length;
        }

        @Override
        public String getColumnName(int col) {
            return SoundingTable.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                if (col < SoundingTable.this.numDomainCols) {
                    return new Float(SoundingTable.this.domainData[col][row]);
                }
                return new Float(SoundingTable.this.rangeData[col - SoundingTable.this.numDomainCols][row]);
            }
            catch (Exception enr) {
                return Float.valueOf(Float.NaN);
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

