/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import ucar.unidata.util.LogUtil;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.TypeException;
import visad.VisADException;

public class SoundingProfile
extends LineDrawing {
    public static final String FIELD = "field";
    private Real rangeValue;
    private Real pressure;
    private Field clearField;
    private FunctionType funcType;

    public SoundingProfile(String name, FunctionType funcType) throws VisADException, RemoteException {
        super(name);
        this.setLineWidth(3.0f);
        this.setPointSize(4.0f);
        this.funcType = funcType;
        this.clearField = new FlatField(funcType, new Integer1DSet((MathType)funcType.getDomain(), 2));
        this.setData(this.clearField);
    }

    protected SoundingProfile(SoundingProfile that) throws RemoteException, VisADException {
        super(that);
        this.funcType = that.funcType;
    }

    public void setProfile(Field field) throws TypeException, RemoteException, VisADException {
        FunctionType funcType = (FunctionType)this.clearField.getType();
        try {
            Util.vetType(funcType, field);
        }
        catch (TypeException te) {
            Util.vetType(new FunctionType(RealType.Time, funcType), field);
        }
        this.setData(field);
    }

    public Field getProfile() throws VisADException, RemoteException {
        return (Field)this.getData();
    }

    @Override
    protected void dataChange() throws VisADException, RemoteException {
        this.firePropertyChange(FIELD, null, this.getProfile());
    }

    public boolean equals(Object obj) {
        SoundingProfile that;
        boolean equals = !(obj instanceof SoundingProfile) ? false : this == (that = (SoundingProfile)obj) || this.clearField.equals(that.clearField) && super.equals(that);
        return equals;
    }

    public int hashCode() {
        return this.clearField.hashCode() ^ super.hashCode();
    }

    public void clear() {
        try {
            this.setProfile(this.clearField);
        }
        catch (VisADException e) {
            LogUtil.logException("clear(): ", e);
        }
        catch (RemoteException e) {
            LogUtil.logException(".clear(): ", e);
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new SoundingProfile(this);
    }
}

