/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.unidata.idv.control.RaobSoundingDataNode;
import ucar.unidata.idv.control.SingleTimeGrid3DSoundingDataNode;
import ucar.unidata.idv.control.SoundingDataNode;
import ucar.unidata.idv.control.TimeSeriesGrid3DSoundingDataNode;
import ucar.unidata.idv.control.TrackSoundingDataNode;
import visad.Data;
import visad.DateTime;
import visad.Field;
import visad.FunctionType;
import visad.MathType;
import visad.SampledSet;
import visad.TupleType;
import visad.VisADException;
import visad.georef.LatLonPoint;

final class SoundingDataNodeWrapper
extends SoundingDataNode {
    private volatile SoundingDataNode node;
    private final SoundingDataNode.Listener innerEar = new SoundingDataNode.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimeIndex(int index, SoundingDataNode source) throws VisADException, RemoteException {
            1 var3_3 = this;
            synchronized (var3_3) {
                if (index == SoundingDataNodeWrapper.this.outIndex) {
                    index = -1;
                } else {
                    SoundingDataNodeWrapper.this.outIndex = index;
                }
            }
            if (index != -1) {
                SoundingDataNodeWrapper.this.setOutputTimeIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimes(SampledSet times, SoundingDataNode source) throws VisADException, RemoteException {
            1 var3_3 = this;
            synchronized (var3_3) {
                if (times.equals(SoundingDataNodeWrapper.this.outTimes)) {
                    times = null;
                } else {
                    SoundingDataNodeWrapper.this.outTimes = times;
                }
            }
            if (times != null) {
                SoundingDataNodeWrapper.this.setOutputTimes(times);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLocation(LatLonPoint loc, SoundingDataNode source) throws VisADException, RemoteException {
            1 var3_3 = this;
            synchronized (var3_3) {
                if (loc.equals(SoundingDataNodeWrapper.this.outLoc)) {
                    loc = null;
                } else {
                    SoundingDataNodeWrapper.this.outLoc = loc;
                }
            }
            if (loc != null) {
                SoundingDataNodeWrapper.this.setOutputLocation(loc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLocations(SampledSet locs, SoundingDataNode source) throws VisADException, RemoteException {
            1 var3_3 = this;
            synchronized (var3_3) {
                if (locs.equals(SoundingDataNodeWrapper.this.outLocs)) {
                    locs = null;
                } else {
                    SoundingDataNodeWrapper.this.outLocs = locs;
                }
            }
            if (locs != null) {
                SoundingDataNodeWrapper.this.setOutputLocations(locs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProfiles(Field[] tempPros, Field[] dewPros, Field[] windPros, SoundingDataNode source) throws VisADException, RemoteException {
            1 var5_5 = this;
            synchronized (var5_5) {
                if (Arrays.equals(tempPros, SoundingDataNodeWrapper.this.outTempPros) && Arrays.equals(dewPros, SoundingDataNodeWrapper.this.outDewPros) && Arrays.equals(windPros, SoundingDataNodeWrapper.this.outWindPros)) {
                    tempPros = null;
                } else {
                    SoundingDataNodeWrapper.access$402(SoundingDataNodeWrapper.this, tempPros);
                    SoundingDataNodeWrapper.access$502(SoundingDataNodeWrapper.this, dewPros);
                    SoundingDataNodeWrapper.access$602(SoundingDataNodeWrapper.this, windPros);
                }
            }
            if (tempPros != null) {
                SoundingDataNodeWrapper.this.setOutputProfiles(tempPros, dewPros, windPros);
            }
        }
    };
    private int outIndex = -1;
    private SampledSet outTimes;
    private LatLonPoint outLoc;
    private SampledSet outLocs;
    private Field[] outTempPros;
    private Field[] outDewPros;
    private Field[] outWindPros;

    SoundingDataNodeWrapper(SoundingDataNode.Listener listener) throws VisADException, RemoteException {
        super(listener);
    }

    @Override
    public void setData(Data data) throws VisADException, RemoteException {
        MathType type = data.getType();
        if (type instanceof TupleType) {
            this.changeNodeAndData(new RaobSoundingDataNode(this.innerEar), data);
        } else if (((FunctionType)type).getRange() instanceof TupleType) {
            this.changeNodeAndData(new TrackSoundingDataNode(this.innerEar), data);
        } else if (((Field)data).getLength() == 1) {
            this.changeNodeAndData(new SingleTimeGrid3DSoundingDataNode(this.innerEar), data);
        } else {
            this.changeNodeAndData(new TimeSeriesGrid3DSoundingDataNode(this.innerEar), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeNodeAndData(SoundingDataNode newNode, Data data) throws VisADException, RemoteException {
        SoundingDataNodeWrapper soundingDataNodeWrapper = this;
        synchronized (soundingDataNodeWrapper) {
            this.node = newNode;
        }
        newNode.setData(data);
    }

    @Override
    public void setLocation(LatLonPoint loc) throws VisADException, RemoteException {
        this.node.setLocation(loc);
    }

    @Override
    public void setTime(DateTime time) throws VisADException, RemoteException {
        this.node.setTime(time);
    }

    static /* synthetic */ Field[] access$402(SoundingDataNodeWrapper x0, Field[] x1) {
        x0.outTempPros = x1;
        return x1;
    }

    static /* synthetic */ Field[] access$502(SoundingDataNodeWrapper x0, Field[] x1) {
        x0.outDewPros = x1;
        return x1;
    }

    static /* synthetic */ Field[] access$602(SoundingDataNodeWrapper x0, Field[] x1) {
        x0.outWindPros = x1;
        return x1;
    }
}

