/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import ucar.unidata.idv.control.SoundingDataNodeWrapper;
import visad.Data;
import visad.DateTime;
import visad.Field;
import visad.SampledSet;
import visad.VisADException;
import visad.georef.LatLonPoint;

abstract class SoundingDataNode {
    private final Listener listener;
    protected DateTime inTime;
    protected LatLonPoint inLoc;

    SoundingDataNode(Listener listener) throws VisADException, RemoteException {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
        this.setOutputTimeIndex(0);
    }

    public static SoundingDataNode getInstance(Listener listener) throws VisADException, RemoteException {
        return new SoundingDataNodeWrapper(listener);
    }

    public abstract void setData(Data var1) throws VisADException, RemoteException;

    public void setLocation(LatLonPoint loc) throws VisADException, RemoteException {
    }

    public void setTime(DateTime time) throws VisADException, RemoteException {
    }

    final void setOutputTimeIndex(int index) throws VisADException, RemoteException {
        this.listener.setTimeIndex(index, this);
    }

    final void setOutputTimes(SampledSet times) throws VisADException, RemoteException {
        this.listener.setTimes(times, this);
    }

    final void setOutputLocation(LatLonPoint loc) throws VisADException, RemoteException {
        this.listener.setLocation(loc, this);
    }

    final void setOutputLocations(SampledSet locs) throws VisADException, RemoteException {
        this.listener.setLocations(locs, this);
    }

    final void setOutputProfiles(Field[] tempPros, Field[] dewPros, Field[] windPros) throws VisADException, RemoteException {
        this.listener.setProfiles(tempPros, dewPros, windPros, this);
    }

    public static interface Listener {
        public void setTimeIndex(int var1, SoundingDataNode var2) throws VisADException, RemoteException;

        public void setTimes(SampledSet var1, SoundingDataNode var2) throws VisADException, RemoteException;

        public void setLocation(LatLonPoint var1, SoundingDataNode var2) throws VisADException, RemoteException;

        public void setLocations(SampledSet var1, SoundingDataNode var2) throws VisADException, RemoteException;

        public void setProfiles(Field[] var1, Field[] var2, Field[] var3, SoundingDataNode var4) throws VisADException, RemoteException;
    }
}

