/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.gis.shapefile.DbaseData;
import ucar.unidata.gis.shapefile.DbaseFile;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.ui.PropertyFilter;
import ucar.unidata.ui.TableSorter;
import ucar.unidata.ui.TwoListPanel;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.data.MapSet;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.Data;
import visad.FieldImpl;
import visad.FunctionType;
import visad.RealTupleType;
import visad.SampledSet;
import visad.Set;
import visad.UnionSet;
import visad.VisADException;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;

public class ShapefileControl
extends DisplayControlImpl {
    private PropertyFilter.FilterGui filterGui;
    private boolean filtersEnabled = true;
    private boolean matchAll = true;
    protected List filters = new ArrayList();
    protected List allFields = new ArrayList();
    protected List selectedFields = new ArrayList();
    protected List uniqueFields = new ArrayList();
    private TwoListPanel fieldSelectorPanel;
    private TwoListPanel fieldUniquePanel;
    private JDialog selectorWindow;
    private JDialog uniqueWindow;
    private Data mainData;
    LineDrawing myDisplay;
    int lineWidth = 1;
    private DbaseFile dbFile;
    private String[] fieldNames;
    private List mapSets;
    private boolean hasProperties = false;
    boolean[] passTheFilter;
    private List tableCols = new ArrayList();
    private List visibleRows = new ArrayList();
    private List colNames = new ArrayList();
    private JTable dbTable;
    private Object TABLE_MUTEX = new Object();
    private AbstractTableModel dbModel;
    private TableSorter sorter;
    private JPanel contents;

    public ShapefileControl() {
        this.setAttributeFlags(20);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.myDisplay = new LineDrawing("Map " + dataChoice);
        this.addDisplayable((Displayable)this.myDisplay, 132);
        boolean ok = this.setData(dataChoice);
        if (ok) {
            this.setContents(this.doMakeContents());
        }
        return ok;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        JComponent mainContents = (JComponent)super.doMakeContents();
        if (!this.hasProperties) {
            return GuiUtils.left(GuiUtils.top(mainContents));
        }
        this.contents = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.contents, 20, 30);
        sp.setBorder(null);
        sp.getVerticalScrollBar().setUnitIncrement(10);
        JViewport vp = sp.getViewport();
        vp.setViewSize(new Dimension(600, 200));
        sp.setPreferredSize(new Dimension(600, 200));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Display", GuiUtils.topCenter(mainContents, sp));
        tabbedPane.add("Filters", this.makeFilterGui());
        tabbedPane.add("Table", this.doMakeTable());
        return tabbedPane;
    }

    private void handleFieldSelectorEvent(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_APPLY) || cmd.equals(GuiUtils.CMD_OK)) {
            this.selectedFields = new ArrayList(this.fieldSelectorPanel.getCurrentEntries());
            this.populateTable();
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL) || cmd.equals(GuiUtils.CMD_OK)) {
            this.selectorWindow.setVisible(false);
        }
    }

    private void handleFieldUniqueEvent(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_APPLY) || cmd.equals(GuiUtils.CMD_OK)) {
            this.uniqueFields = new ArrayList(this.fieldUniquePanel.getCurrentEntries());
            this.populateTable();
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL) || cmd.equals(GuiUtils.CMD_OK)) {
            this.uniqueWindow.setVisible(false);
        }
    }

    public void showFieldSelector() {
        if (this.selectorWindow == null) {
            this.fieldSelectorPanel = new TwoListPanel(new ArrayList(), "All Fields", new ArrayList(), "Current Fields", null);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ShapefileControl.this.handleFieldSelectorEvent(ae);
                }
            };
            JPanel buttons = GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_APPLY, GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL});
            JPanel contents = GuiUtils.centerBottom(this.fieldSelectorPanel, buttons);
            this.selectorWindow = GuiUtils.createDialog(null, "Field Selector", false);
            this.selectorWindow.getContentPane().add(contents);
            this.selectorWindow.pack();
        }
        if (this.selectedFields.size() == 0) {
            this.selectedFields = new ArrayList(this.allFields);
        }
        this.fieldSelectorPanel.reinitialize(this.allFields, this.selectedFields);
        this.selectorWindow.setVisible(true);
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    public void showUniqueSelector() {
        if (this.uniqueWindow == null) {
            this.fieldUniquePanel = new TwoListPanel(new ArrayList(), "All Fields", new ArrayList(), "Current Fields", null);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ShapefileControl.this.handleFieldUniqueEvent(ae);
                }
            };
            JPanel buttons = GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_APPLY, GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL});
            JPanel contents = GuiUtils.centerBottom(this.fieldUniquePanel, buttons);
            this.uniqueWindow = GuiUtils.createDialog(null, "Unique Field Selector", false);
            this.uniqueWindow.getContentPane().add(contents);
            this.uniqueWindow.pack();
        }
        this.fieldUniquePanel.reinitialize(this.allFields, this.uniqueFields);
        this.uniqueWindow.setVisible(true);
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        ArrayList<JMenuItem> l = new ArrayList<JMenuItem>();
        if (this.hasProperties) {
            l.add(GuiUtils.makeMenuItem("Export Table...", this, "exportTable"));
        }
        if (this.mainData instanceof SampledSet) {
            l.add(GuiUtils.makeMenuItem("Export Displayed Shapes...", this, "exportShapes"));
        }
        if (!l.isEmpty()) {
            items.addAll(l);
        }
    }

    public void exportTable() {
        GuiUtils.exportAsCsv(this.sorter);
    }

    private void populateTable() {
        int valueIdx;
        List values;
        String fieldName;
        int fieldIdx;
        if (this.mapSets == null || !this.hasProperties || this.dbModel == null) {
            return;
        }
        this.visibleRows = new ArrayList();
        this.tableCols = new ArrayList();
        this.colNames = new ArrayList();
        int numRecords = this.mapSets.size();
        ArrayList comps = new ArrayList();
        boolean[] unique = null;
        if (this.uniqueFields.size() > 0) {
            unique = new boolean[numRecords];
            Arrays.fill(unique, true);
            for (fieldIdx = 0; fieldIdx < this.fieldNames.length; ++fieldIdx) {
                fieldName = this.fieldNames[fieldIdx];
                if (!this.uniqueFields.contains(fieldName) || this.selectedFields.size() > 0 && !this.selectedFields.contains(fieldName)) continue;
                DbaseData dbData = this.dbFile.getField(fieldIdx);
                Hashtable uniqueMap = new Hashtable();
                values = dbData.asList();
                for (valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                    if (!unique[valueIdx] || !this.passTheFilter[valueIdx]) continue;
                    Object v = values.get(valueIdx);
                    if (uniqueMap.get(v) != null) {
                        unique[valueIdx] = false;
                        continue;
                    }
                    uniqueMap.put(v, v);
                }
            }
        }
        for (fieldIdx = 0; fieldIdx < this.fieldNames.length; ++fieldIdx) {
            fieldName = this.fieldNames[fieldIdx];
            if (this.selectedFields.size() > 0 && !this.selectedFields.contains(fieldName)) continue;
            ArrayList data = new ArrayList();
            this.tableCols.add(data);
            this.colNames.add(fieldName);
            DbaseData dbData = this.dbFile.getField(fieldIdx);
            values = dbData.asList();
            for (valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                if (!this.passTheFilter[valueIdx] || unique != null && !unique[valueIdx]) continue;
                data.add(values.get(valueIdx));
            }
        }
        this.dbModel.fireTableStructureChanged();
    }

    private JComponent doMakeTable() {
        ArrayList comps = new ArrayList();
        for (int fieldIdx = 0; fieldIdx < this.fieldNames.length; ++fieldIdx) {
            this.allFields.add(this.fieldNames[fieldIdx]);
        }
        this.dbModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public int getRowCount() {
                if (ShapefileControl.this.tableCols.size() > 0) {
                    List colData = (List)ShapefileControl.this.tableCols.get(0);
                    return colData.size();
                }
                return 0;
            }

            @Override
            public int getColumnCount() {
                return ShapefileControl.this.colNames.size();
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object getValueAt(int row, int column) {
                Object object = ShapefileControl.this.TABLE_MUTEX;
                synchronized (object) {
                    List colData;
                    if (column < ShapefileControl.this.tableCols.size() && row < (colData = (List)ShapefileControl.this.tableCols.get(column)).size()) {
                        return colData.get(row);
                    }
                    return "";
                }
            }

            @Override
            public String getColumnName(int column) {
                return (String)ShapefileControl.this.colNames.get(column);
            }
        };
        this.sorter = new TableSorter(this.dbModel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Comparator getComparator(int column) {
                Object object = ShapefileControl.this.TABLE_MUTEX;
                synchronized (object) {
                    List rowData;
                    if (ShapefileControl.this.dbModel.getRowCount() > 0 && (rowData = (List)ShapefileControl.this.tableCols.get(0)).get(column) instanceof Double) {
                        return COMPARABLE_COMAPRATOR;
                    }
                    return super.getComparator(column);
                }
            }
        };
        this.dbTable = new JTable(this.sorter);
        JTableHeader header = this.dbTable.getTableHeader();
        this.sorter.setTableHeader(this.dbTable.getTableHeader());
        int width = 300;
        int height = 400;
        JScrollPane scroller = GuiUtils.makeScrollPane(this.dbTable, width, height);
        scroller.setPreferredSize(new Dimension(width, height));
        scroller.setMinimumSize(new Dimension(width, height));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        tablePanel.add(header);
        tablePanel.add(scroller);
        this.populateTable();
        JPanel buttons = GuiUtils.left(GuiUtils.hbox(GuiUtils.makeButton("Select Fields to Show", this, "showFieldSelector"), GuiUtils.makeButton("Select Unique Fields", this, "showUniqueSelector")));
        return GuiUtils.topCenter(buttons, tablePanel);
    }

    private void getShapesXml(SampledSet set, StringBuffer sb) throws VisADException, RemoteException {
        if (set instanceof UnionSet) {
            SampledSet[] sets = ((UnionSet)set).getSets();
            for (int setIdx = 0; setIdx < sets.length; ++setIdx) {
                this.getShapesXml(sets[setIdx], sb);
            }
        } else {
            sb.append("<polygon points=\"");
            float[][] samples = set.getSamples(false);
            for (int ptIdx = 0; ptIdx < samples[0].length; ++ptIdx) {
                if (ptIdx > 0) {
                    sb.append(",");
                }
                sb.append("" + samples[1][ptIdx]);
                sb.append("," + samples[0][ptIdx]);
            }
            sb.append("\"/>\n");
        }
    }

    public void exportShapes() {
        String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml");
        if (filename == null) {
            return;
        }
        try {
            StringBuffer sb = new StringBuffer("<shapes>\n");
            SampledSet theData = (SampledSet)this.applyFilters(this.mainData);
            this.getShapesXml(theData, sb);
            sb.append("</shapes>\n");
            IOUtil.writeFile(filename, sb.toString());
        }
        catch (Exception exc) {
            ShapefileControl.logException("Exporting shapes", exc);
        }
    }

    private JComponent makeFilterGui() {
        ArrayList<String> filterNames = new ArrayList<String>();
        for (int fieldIdx = 0; fieldIdx < this.fieldNames.length; ++fieldIdx) {
            filterNames.add(this.fieldNames[fieldIdx]);
        }
        this.filterGui = new PropertyFilter.FilterGui(this.filters, filterNames, this.filtersEnabled, this.matchAll);
        return GuiUtils.topCenter(GuiUtils.left(GuiUtils.makeButton("Apply Filters", this, "handleFilterApply")), this.filterGui.getContents());
    }

    public void handleFilterApply() {
        try {
            this.loadData();
        }
        catch (Exception exc) {
            ShapefileControl.logException("Setting filters", exc);
        }
    }

    private Data applyFilters(Data data) {
        if (!this.hasProperties) {
            return data;
        }
        Data d = data;
        if (this.passTheFilter != null) {
            Arrays.fill(this.passTheFilter, true);
        }
        if (this.filters.size() == 0 || !this.filtersEnabled) {
            return data;
        }
        if (data instanceof FieldImpl) {
            try {
                FieldImpl newFI;
                FieldImpl fi = (FieldImpl)data;
                if (GridUtil.isSequence(fi)) {
                    Set domainSet = fi.getDomainSet();
                    newFI = new FieldImpl((FunctionType)fi.getType(), domainSet);
                    for (int i = 0; i < domainSet.getLength(); ++i) {
                        SampledSet s = this.applyFilters((SampledSet)fi.getSample(i, false));
                        if (s == null) continue;
                        newFI.setSample(i, (Data)s, false);
                    }
                } else {
                    throw new BadDataException("Can't handle data of type: " + fi.getType());
                }
                d = newFI;
            }
            catch (Exception exc) {
                ShapefileControl.logException("Applying flters", exc);
            }
        } else if (data instanceof SampledSet) {
            d = this.applyFilters((SampledSet)data);
        }
        return d;
    }

    private SampledSet applyFilters(SampledSet data) {
        if (this.passTheFilter != null) {
            Arrays.fill(this.passTheFilter, true);
        }
        if (this.filters.size() == 0 || !this.filtersEnabled) {
            return data;
        }
        ArrayList features = new ArrayList();
        block2: for (int i = 0; i < this.filters.size(); ++i) {
            PropertyFilter filter = (PropertyFilter)this.filters.get(i);
            DbaseData dbData = this.dbFile.getField(filter.getName());
            if (dbData == null) {
                System.err.println("null dbdata:" + filter.getName());
                continue;
            }
            List values = dbData.asList();
            for (int valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                boolean ok = true;
                ok = filter.ok(values.get(valueIdx));
                if (this.matchAll && !ok) {
                    this.passTheFilter[valueIdx] = false;
                    continue;
                }
                if (this.matchAll || !ok) continue;
                this.passTheFilter[valueIdx] = true;
                continue block2;
            }
        }
        if (!(data instanceof UnionSet)) {
            return data;
        }
        ArrayList<SampledSet> okData = new ArrayList<SampledSet>();
        SampledSet[] sets = ((UnionSet)data).getSets();
        for (int i = 0; i < this.passTheFilter.length; ++i) {
            if (!this.passTheFilter[i]) continue;
            okData.add(sets[i]);
        }
        SampledSet[] ss = new SampledSet[okData.size()];
        System.arraycopy(okData.toArray(), 0, ss, 0, ss.length);
        if (ss.length > 0) {
            try {
                return new UnionSet(ss[0].getType(), ss, null, null, null, false);
            }
            catch (Exception exc) {
                ShapefileControl.logException("Applying flters", exc);
            }
        }
        LogUtil.userErrorMessage("The filter returned zero results");
        return null;
    }

    private void loadData() throws VisADException, RemoteException {
        if (this.filterGui != null) {
            this.filters = this.filterGui.getFilters();
            this.matchAll = this.filterGui.getMatchAll();
            this.filtersEnabled = this.filterGui.getEnabled();
        }
        Data theData = this.applyFilters(this.mainData);
        this.populateTable();
        if (theData != null) {
            this.myDisplay.setData(theData);
        }
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        Object[] sets;
        if (!super.setData(choice)) {
            return false;
        }
        this.mainData = this.getDataInstance().getData();
        if (this.mainData == null) {
            return false;
        }
        this.mapSets = null;
        this.hasProperties = false;
        if (this.mainData instanceof UnionSet && (sets = ((UnionSet)this.mainData).getSets()).length > 0 && sets[0] instanceof MapSet) {
            this.mapSets = Misc.toList(sets);
            List names = ((MapSet)this.mapSets.get(0)).getPropertyNames();
            if (names != null && names.size() > 0) {
                this.hasProperties = true;
                this.fieldNames = names.toArray(new String[names.size()]);
                this.passTheFilter = new boolean[this.mapSets.size()];
                Arrays.fill(this.passTheFilter, true);
            }
        }
        Hashtable requestProperties = this.getRequestProperties();
        this.dbFile = (DbaseFile)requestProperties.get("PROP_DBFILE");
        this.setLineWidth(this.lineWidth);
        this.loadData();
        return true;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Set Line Width:"), this.doMakeWidthSlider()));
    }

    @Override
    public String getColorWidgetLabel() {
        return "Line Color";
    }

    private Component doMakeWidthSlider() {
        JSlider slider = new JSlider(1, 10, this.getLineWidth());
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setToolTipText("Change width of map lines");
        slider.setMajorTickSpacing(5);
        slider.setMinorTickSpacing(1);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slide = (JSlider)e.getSource();
                if (slide.getValueIsAdjusting()) {
                    return;
                }
                ShapefileControl.this.setLineWidth(slide.getValue());
            }
        });
        return slider;
    }

    @Override
    public void setLineWidth(int width) {
        try {
            if (this.myDisplay != null) {
                this.myDisplay.setLineWidth(width);
            }
            this.lineWidth = width;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setFiltersEnabled(boolean value) {
        this.filtersEnabled = value;
    }

    public boolean getFiltersEnabled() {
        return this.filtersEnabled;
    }

    public void setFilters(List value) {
        this.filters = value;
    }

    public List getFilters() {
        return this.filters;
    }

    public void setMatchAll(boolean value) {
        this.matchAll = value;
    }

    public boolean getMatchAll() {
        return this.matchAll;
    }

    public void setSelectedFields(List value) {
        this.selectedFields = value;
    }

    public List getSelectedFields() {
        return this.selectedFields;
    }

    public void setUniqueFields(List value) {
        this.uniqueFields = value;
    }

    public List getUniqueFields() {
        return this.uniqueFields;
    }

    @Override
    public boolean hasMapProjection() {
        return this.mainData instanceof UnionSet;
    }

    @Override
    public MapProjection getDataProjection() {
        try {
            Object projSet = null;
            Rectangle2D.Float rect = null;
            if (this.mainData instanceof FieldImpl) {
                FieldImpl fi = (FieldImpl)this.mainData;
                if (GridUtil.isSequence(fi)) {
                    Set domain = fi.getDomainSet();
                    for (int i = 0; i < domain.getLength(); ++i) {
                        Rectangle2D.Float subRect;
                        UnionSet s = (UnionSet)fi.getSample(i, false);
                        SampledSet[] sets = s.getSets();
                        if (sets.length <= 0 || (subRect = this.getBounds(sets)) == null) continue;
                        if (rect == null) {
                            rect = subRect;
                            continue;
                        }
                        rect.add(subRect);
                    }
                }
            } else if (this.mainData instanceof UnionSet) {
                rect = this.getBounds(((UnionSet)this.mainData).getSets());
            } else if (this.mainData instanceof SampledSet) {
                rect = this.getBounds(new SampledSet[]{(SampledSet)this.mainData});
            }
            if (rect == null) {
                return null;
            }
            return new TrivialMapProjection(RealTupleType.SpatialEarth2DTuple, rect);
        }
        catch (Exception exc) {
            ShapefileControl.logException("Creating map projection", exc);
            return null;
        }
    }

    private Rectangle2D.Float getBounds(SampledSet[] sets) throws VisADException {
        if (sets.length == 0) {
            return null;
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        boolean flipRect = false;
        for (int i = 0; i < sets.length; ++i) {
            float[] hi = sets[i].getHi();
            float[] low = sets[i].getLow();
            if (i == 0) {
                minX = low[0];
                minY = low[1];
                maxX = hi[0];
                maxY = hi[1];
            } else {
                minX = Math.min(minX, (double)low[0]);
                minY = Math.min(minY, (double)low[1]);
                maxX = Math.max(maxX, (double)hi[0]);
                maxY = Math.max(maxY, (double)hi[1]);
            }
            if (!GridUtil.isLatLonOrder(sets[i])) continue;
            flipRect = true;
        }
        Rectangle2D.Float rect = new Rectangle2D.Float((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
        if (flipRect) {
            float tmp = rect.x;
            rect.x = rect.y;
            rect.y = tmp;
            tmp = rect.width;
            rect.width = rect.height;
            rect.height = tmp;
        }
        return rect;
    }
}

