/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import ucar.unidata.idv.control.ControlWidget;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.RangeDialog;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Range;

public class SelectRangeWidget
extends ControlWidget {
    private Range range;
    private JLabel label = new JLabel("Clip Displayed Range:", 4);
    private JButton button;
    private JCheckBox enabledCbx;
    private JLabel rhLabel = new JLabel(" ");
    private RangeDialog rangeDialog;

    public SelectRangeWidget(DisplayControlImpl control, Range range) {
        this(control, range, "Change Range");
    }

    public SelectRangeWidget(DisplayControlImpl control, Range range, String dialogTitle) {
        super(control);
        this.setRange(range);
        this.button = new JButton("Change");
        this.enabledCbx = GuiUtils.makeCheckbox("", this, "selectRangeEnabled");
        this.button.addActionListener(this);
        this.rhLabel.setEnabled(this.enabledCbx.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.showChangeRangeDialog();
    }

    public void showChangeRangeDialog() {
        if (this.rangeDialog == null) {
            this.rangeDialog = new RangeDialog(this.getDisplayControl(), this.range, "Change Visible Range", "setSelectRange", this.button);
        }
        this.rangeDialog.showDialog();
    }

    public void setRange(Range r) {
        this.range = r;
        if (r != null) {
            this.rhLabel.setText("From: " + this.getDisplayConventions().format(r.getMin()) + " To: " + this.getDisplayConventions().format(r.getMax()));
            if (this.rangeDialog != null) {
                this.rangeDialog.setRangeDialog(r);
            }
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void fillList(List l, int columns) {
        l.add(this.label);
        l.add(GuiUtils.doLayout(new Component[]{this.enabledCbx, GuiUtils.inset((Component)this.button, new Insets(0, 8, 0, 0)), new Label(" "), this.rhLabel}, 4, GuiUtils.WT_NNNY, GuiUtils.WT_N));
    }

    public boolean getSelectRangeEnabled() {
        return this.displayControl.getSelectRangeEnabled();
    }

    public void setSelectRangeEnabled(boolean v) {
        this.rhLabel.setEnabled(v);
        this.displayControl.setSelectRangeEnabled(v);
    }

    public Range getRangeFromColorTable() {
        Range ctRange = null;
        ColorTable originalCT = this.getDisplayControl().getOldColorTableOrInitialColorTable();
        if (originalCT != null) {
            ctRange = originalCT.getRange();
        }
        return ctRange;
    }

    @Override
    public void doRemove() {
        super.doRemove();
        if (this.rangeDialog != null) {
            this.rangeDialog.doRemove();
            this.rangeDialog = null;
        }
    }
}

