/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import edu.wisc.ssec.mcidasv.data.hydra.CurveDrawer;
import edu.wisc.ssec.mcidasv.data.hydra.HistogramField;
import edu.wisc.ssec.mcidasv.data.hydra.HydraRGBDisplayable;
import edu.wisc.ssec.mcidasv.data.hydra.LongitudeLatitudeCoordinateSystem;
import edu.wisc.ssec.mcidasv.data.hydra.MultiSpectralData;
import edu.wisc.ssec.mcidasv.data.hydra.StatsTable;
import edu.wisc.ssec.mcidasv.data.hydra.SubsetRubberBandBox;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.ColorTableWidget;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.Grid2DReadoutProbe;
import ucar.unidata.idv.control.LambertAEA;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.colortable.ColorTableManager;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.view.geoloc.MapProjectionDisplayJ3D;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.MapLines;
import ucar.visad.display.RGBDisplayable;
import ucar.visad.display.RubberBandBox;
import ucar.visad.display.XYDisplay;
import visad.Action;
import visad.AxisScale;
import visad.BaseColorControl;
import visad.CachingCoordinateSystem;
import visad.CellImpl;
import visad.CoordinateSystem;
import visad.Data;
import visad.DelaunayCustom;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.UnionSet;
import visad.VisADException;
import visad.data.mcidas.BaseMapAdapter;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;
import visad.python.JPythonMethods;

public class ScatterDisplay
extends DisplayControlImpl {
    private static final Logger logger = LoggerFactory.getLogger(ScatterDisplay.class);
    private Container container;
    private FlatField X_field;
    private FlatField Y_field;
    private FlatField Area_field;
    private double total_area;
    private DisplayMaster scatterMaster = null;
    private DisplayMaster dspMasterX;
    private DisplayMaster dspMasterY;
    private HistogramField histoField;
    private FlatField mask_field;
    private float[][] mask_range;
    private float[][] scatterFieldRange;
    private Data X_data;
    private Data Y_data;
    private String X_name;
    private String Y_name;
    private boolean cancel = false;
    private ScatterDisplayable scatterMarkDsp;
    private BoxCurveSwitch boxCurveSwitch;
    public DataChoice dataChoiceX = null;
    public DataChoice dataChoiceY = null;
    public DataSelection dataSelectionX = null;
    public DataSelection dataSelectionY = null;
    JComponent ctwCompX;
    JComponent ctwCompY;
    int n_selectors = 3;
    List<ScatterBoxSelector> scatterBoxSelectors = new ArrayList<ScatterBoxSelector>();
    List<ScatterCurveSelector> scatterCurveSelectors = new ArrayList<ScatterCurveSelector>();
    List<ImageBoxSelector> imageXBoxSelectors = new ArrayList<ImageBoxSelector>();
    List<ImageBoxSelector> imageYBoxSelectors = new ArrayList<ImageBoxSelector>();
    List<ImageCurveSelector> imageXCurveSelectors = new ArrayList<ImageCurveSelector>();
    List<ImageCurveSelector> imageYCurveSelectors = new ArrayList<ImageCurveSelector>();
    JToggleButton[] selectorToggleButtons = new JToggleButton[this.n_selectors];
    Color[] selectorColors = new Color[]{Color.magenta, Color.green, Color.blue};
    float[][] maskColorPalette = new float[][]{{0.8f, 0.0f, 0.0f}, {0.0f, 0.8f, 0.0f}, {0.8f, 0.0f, 0.8f}};
    float[][] markPaletteBlackBackground = new float[][]{{1.0f, 0.8f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.8f, 0.0f}, {1.0f, 0.8f, 0.0f, 0.8f}};
    float[][] markPaletteWhiteBackground = new float[][]{{0.0f, 0.8f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.8f, 0.0f}, {0.0f, 0.8f, 0.0f, 0.8f}};
    private boolean blackBackground = true;
    JRadioButton bgColorBlack;
    JRadioButton bgColorWhite;
    ButtonGroup bgColorGroup;
    JButton computeStatsButton;
    StatsTable statsTable;
    boolean selectByCurve = false;
    JMenu viewMenu = null;
    Component[] threeComps = null;

    public ScatterDisplay() {
        this.setHelpUrl("idv.controls.misc.scatteranalysiscontrol");
    }

    @Override
    public boolean init(List choices) throws VisADException, RemoteException {
        this.bgColorBlack = new JRadioButton("Black");
        this.bgColorBlack.addActionListener(e -> {
            this.scatterMaster.setForeground(Color.white);
            this.scatterMaster.setBackground(Color.black);
            this.setBlackBackground(true);
            try {
                this.scatterMarkDsp.setColorPalette(this.markPaletteBlackBackground);
            }
            catch (Exception ex) {
                logger.error("could not change color palette", ex);
            }
        });
        this.bgColorWhite = new JRadioButton("White");
        this.bgColorWhite.addActionListener(e -> {
            this.scatterMaster.setForeground(Color.black);
            this.scatterMaster.setBackground(Color.white);
            this.setBlackBackground(false);
            try {
                this.scatterMarkDsp.setColorPalette(this.markPaletteWhiteBackground);
            }
            catch (Exception ex) {
                logger.error("could not change color palette", ex);
            }
        });
        this.bgColorGroup = new ButtonGroup();
        this.bgColorGroup.add(this.bgColorBlack);
        this.bgColorGroup.add(this.bgColorWhite);
        this.bgColorBlack.setSelected(this.getBlackBackground());
        this.bgColorWhite.setSelected(!this.getBlackBackground());
        if (this.dataChoiceX != null && this.dataChoiceY != null) {
            this.setupFromUnpersistence();
        } else {
            try {
                this.setup();
            }
            catch (VisADException vade) {
                return false;
            }
        }
        this.mask_field = new FlatField(new FunctionType(((FunctionType)this.X_field.getType()).getDomain(), RealType.Generic), this.X_field.getDomainSet());
        int len = this.X_field.getDomainSet().getLength();
        int[] lens = ((Gridded2DSet)this.X_field.getDomainSet()).getLengths();
        this.mask_range = new float[1][len];
        for (int t = 0; t < len; ++t) {
            this.mask_range[0][t] = Float.NaN;
        }
        this.mask_range[0][0] = 0.0f;
        this.mask_field.setSamples(this.mask_range, false);
        try {
            int binSize = lens[0] * lens[1] / 65536 * 4 / 10;
            if (binSize < 2) {
                binSize = 2;
            }
            this.histoField = new HistogramField(this.X_field, this.Y_field, this.mask_field, 256, binSize);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        Range rangeX = this.getImageRange(this.X_field);
        Range rangeY = this.getImageRange(this.Y_field);
        ColorTable clrTableX = this.getColorTable(this.X_field);
        ColorTable clrTableY = this.getColorTable(this.Y_field);
        this.dspMasterX = this.makeImageDisplay(this.getDataProjection(this.X_field), this.X_field, this.mask_field, rangeX, clrTableX);
        this.dspMasterY = this.makeImageDisplay(this.getDataProjection(this.Y_field), this.Y_field, this.mask_field, rangeY, clrTableY);
        this.dspMasterX.addDisplayListener(e -> {
            double[] yProjection;
            double[] xProjection = this.dspMasterX.getProjectionMatrix();
            if (xProjection.equals(yProjection = this.dspMasterY.getProjectionMatrix())) {
                return;
            }
            try {
                this.dspMasterY.setProjectionMatrix(xProjection);
            }
            catch (Exception ex) {
                LogUtil.logException("dspMasterX.displayChanged", ex);
            }
        });
        this.dspMasterY.addDisplayListener(e -> {
            double[] xProjection = this.dspMasterX.getProjectionMatrix();
            double[] yProjection = this.dspMasterY.getProjectionMatrix();
            if (yProjection.equals(xProjection)) {
                return;
            }
            try {
                this.dspMasterX.setProjectionMatrix(yProjection);
            }
            catch (Exception ex) {
                LogUtil.logException("dspMasterX.displayChanged", ex);
            }
        });
        this.X_name = ((FunctionType)this.X_field.getType()).getFlatRange().getRealComponents()[0].getName();
        this.Y_name = ((FunctionType)this.Y_field.getType()).getFlatRange().getRealComponents()[0].getName();
        if (this.statsTable != null) {
            this.statsTable.setNames(this.X_name, this.Y_name);
        }
        Grid2DReadoutProbe probeX = new Grid2DReadoutProbe(this.X_field, this.dspMasterX);
        Grid2DReadoutProbe probeY = new Grid2DReadoutProbe(this.Y_field, this.dspMasterY);
        probeX.doMakeProbe(Color.red, this.dspMasterX);
        probeY.doMakeProbe(Color.red, this.dspMasterY);
        ImageControl dCntrl = new ImageControl((HydraRGBDisplayable)this.dspMasterX.getDisplayables(0), this.getDisplayConventions());
        ColorTableWidget ctw1 = new ColorTableWidget(dCntrl, ColorTableManager.getManager(), clrTableX, rangeX);
        this.ctwCompX = ctw1.getLegendPanel(0);
        dCntrl.ctw = ctw1;
        dCntrl = new ImageControl((HydraRGBDisplayable)this.dspMasterY.getDisplayables(0), this.getDisplayConventions());
        ctw1 = new ColorTableWidget(dCntrl, ColorTableManager.getManager(), clrTableY, rangeY);
        this.ctwCompY = ctw1.getLegendPanel(0);
        dCntrl.ctw = ctw1;
        return true;
    }

    public void setup() throws VisADException, RemoteException {
        this.dataSelectionX = this.getDataSelection();
        this.dataChoiceX = this.getDataChoice();
        Hashtable<String, Object> tt = this.getRequestProperties();
        if (tt == null) {
            tt = new Hashtable<String, Object>();
        }
        tt.put("id", this.dataChoiceX.getId());
        this.X_data = this.dataChoiceX.getData(this.dataSelectionX, tt);
        int idx = 0;
        if (this.dataSelectionX != null && this.dataSelectionX.getTimes() != null) {
            idx = this.dataSelectionX.getTimes().size() - 1;
        } else if (this.getUsesTimeDriver() && this.dataChoiceX.getAllDateTimes() != null) {
            idx = 0;
        } else if (this.dataSelectionX.getTimes() == null && this.dataChoiceX.getAllDateTimes() != null) {
            idx = this.dataChoiceX.getAllDateTimes().size() - 1;
        }
        if (this.X_data instanceof FlatField) {
            this.X_field = (FlatField)this.X_data;
        } else if (this.X_data instanceof FieldImpl) {
            this.X_field = (FlatField)((FieldImpl)this.X_data).getSample(idx);
        }
        this.popupDataDialog("select Y Axis field", this.container, false, null);
        if (this.cancel) {
            throw new VisADException("Scatter Display Canceled");
        }
        this.dataSelectionY = this.getDataSelection();
        this.dataChoiceY = this.getDataChoice();
        Hashtable<String, Object> tt1 = this.getRequestProperties();
        if (tt1 == null) {
            tt1 = new Hashtable<String, Object>();
        }
        tt1.put("id", this.dataChoiceY.getId());
        this.dataSelectionY.setGeoSelection(this.dataSelectionX.getGeoSelection());
        this.Y_data = this.dataChoiceY.getData(this.dataSelectionY, tt1);
        int idy = 0;
        if (this.dataSelectionY != null && this.dataSelectionY.getTimes() != null) {
            idy = this.dataSelectionY.getTimes().size() - 1;
        } else if (this.getUsesTimeDriver() && this.dataChoiceY.getAllDateTimes() != null) {
            idy = 0;
        } else if (this.dataSelectionY.getTimes() == null && this.dataChoiceY.getAllDateTimes() != null) {
            idy = this.dataChoiceY.getAllDateTimes().size() - 1;
        }
        if (this.Y_data instanceof FlatField) {
            this.Y_field = (FlatField)this.Y_data;
        } else if (this.Y_data instanceof FieldImpl) {
            this.Y_field = (FlatField)((FieldImpl)this.Y_data).getSample(idy);
        }
        if (!this.X_field.getDomainSet().equals(this.Y_field.getDomainSet())) {
            this.Y_field = this.resample(this.X_field, this.Y_field);
        }
        this.Area_field = JPythonMethods.createAreaField(this.X_field);
        this.statsTable = new StatsTable();
    }

    public void setupFromUnpersistence() throws VisADException, RemoteException {
        this.X_data = this.dataChoiceX.getData(this.dataSelectionX);
        if (this.X_data instanceof FlatField) {
            this.X_field = (FlatField)this.X_data;
        } else if (this.X_data instanceof FieldImpl) {
            this.X_field = (FlatField)((FieldImpl)this.X_data).getSample(0);
        }
        this.Y_data = this.dataChoiceY.getData(this.dataSelectionY);
        if (this.Y_data instanceof FlatField) {
            this.Y_field = (FlatField)this.Y_data;
        } else if (this.X_data instanceof FieldImpl) {
            this.Y_field = (FlatField)((FieldImpl)this.Y_data).getSample(0);
        }
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties, List preSelectedDataChoices) {
        float[][] bgPalette;
        Color bg;
        Color fg;
        super.initAfterUnPersistence(vc, properties, preSelectedDataChoices);
        if (this.getBlackBackground()) {
            fg = Color.white;
            bg = Color.black;
            bgPalette = this.markPaletteBlackBackground;
        } else {
            fg = Color.black;
            bg = Color.white;
            bgPalette = this.markPaletteWhiteBackground;
        }
        this.scatterMaster.setForeground(fg);
        this.scatterMaster.setBackground(bg);
        try {
            this.scatterMarkDsp.setColorPalette(bgPalette);
        }
        catch (Exception ex) {
            logger.error("could not change color palette", ex);
        }
    }

    @Override
    protected void popupDataDialog(String dialogMessage, Component from, boolean multiples, List categories) {
        List<DataChoice> choices = this.selectDataChoices(dialogMessage, from, multiples, categories);
        if (choices == null || choices.size() == 0) {
            logger.debug("popupDataDialog, no data choice, user canceled");
            this.cancel = true;
            return;
        }
        List clonedList = DataChoice.cloneDataChoices((List)((Object)choices.get(0)));
        this.dataSelection = ((DataChoice)clonedList.get(0)).getDataSelection();
        try {
            this.addNewData(clonedList);
        }
        catch (Exception exc) {
            ScatterDisplay.logException("Selecting new data", exc);
        }
    }

    @Override
    public void initDone() {
        try {
            int k;
            this.scatterMaster = this.makeScatterDisplay();
            this.scatterMaster.draw();
            for (k = 0; k < this.n_selectors; ++k) {
                this.scatterBoxSelectors.add(new ScatterBoxSelector(this.scatterMaster, this.selectorColors[k], k));
                this.scatterCurveSelectors.add(new ScatterCurveSelector(this.scatterMaster, this.selectorColors[k], k));
            }
            this.threeComps[0] = this.dspMasterX.getComponent();
            this.threeComps[1] = this.dspMasterY.getComponent();
            this.threeComps[2] = this.scatterMaster.getComponent();
            this.container.repaint();
            for (k = 0; k < this.n_selectors; ++k) {
                SubsetRubberBandBox X_subsetBox = new SubsetRubberBandBox(this.getIsLatLon(this.X_field), this.X_field, ((MapProjectionDisplayJ3D)this.dspMasterX).getDisplayCoordinateSystem(), 1, false);
                X_subsetBox.setColor(this.selectorColors[k]);
                ImageBoxSelector markX = new ImageBoxSelector(X_subsetBox, this.X_field.getDomainSet(), this.dspMasterX, this.selectorColors[k], (float)k + 1.0f, this.statsTable);
                SubsetRubberBandBox Y_subsetBox = new SubsetRubberBandBox(this.getIsLatLon(this.Y_field), this.Y_field, ((MapProjectionDisplayJ3D)this.dspMasterY).getDisplayCoordinateSystem(), 1, false);
                Y_subsetBox.setColor(this.selectorColors[k]);
                ImageBoxSelector markY = new ImageBoxSelector(Y_subsetBox, this.Y_field.getDomainSet(), this.dspMasterY, this.selectorColors[k], (float)k + 1.0f, this.statsTable);
                markX.setOther(markY);
                markY.setOther(markX);
                this.imageXBoxSelectors.add(markX);
                this.imageYBoxSelectors.add(markY);
            }
            for (k = 0; k < this.n_selectors; ++k) {
                CurveDrawer curveDraw = new CurveDrawer(RealType.Longitude, RealType.Latitude, 1);
                curveDraw.setColor(this.selectorColors[k]);
                curveDraw.setLineWidth(2.0f);
                ImageCurveSelector curveX = new ImageCurveSelector(curveDraw, this.X_field, this.dspMasterX, this.selectorColors[k], (float)k + 1.0f, this.statsTable);
                curveX.setActive(false);
                curveDraw.addAction((Action)curveX);
                curveX.setVisible(false);
                this.dspMasterX.addDisplayable((Displayable)curveDraw);
                curveDraw = new CurveDrawer(RealType.Longitude, RealType.Latitude, 1);
                curveDraw.setColor(this.selectorColors[k]);
                curveDraw.setLineWidth(2.0f);
                ImageCurveSelector curveY = new ImageCurveSelector(curveDraw, this.Y_field, this.dspMasterY, this.selectorColors[k], (float)k + 1.0f, this.statsTable);
                curveY.setActive(false);
                curveDraw.addAction((Action)curveY);
                curveY.setVisible(false);
                this.dspMasterY.addDisplayable((Displayable)curveDraw);
                curveX.setOther(curveY);
                curveY.setOther(curveX);
                this.imageXCurveSelectors.add(curveX);
                this.imageYCurveSelectors.add(curveY);
            }
            for (k = 0; k < this.n_selectors; ++k) {
                JToggleButton jtog = this.selectorToggleButtons[k];
                jtog.addActionListener(e -> {
                    int idx = Integer.valueOf(e.getActionCommand());
                    try {
                        for (int i = 0; i < this.n_selectors; ++i) {
                            ScatterBoxSelector boxSel = this.scatterBoxSelectors.get(i);
                            ImageBoxSelector imageXbox = this.imageXBoxSelectors.get(i);
                            ImageBoxSelector imageYbox = this.imageYBoxSelectors.get(i);
                            ScatterCurveSelector curveSel = this.scatterCurveSelectors.get(i);
                            ImageCurveSelector imageXcurve = this.imageXCurveSelectors.get(i);
                            ImageCurveSelector imageYcurve = this.imageYCurveSelectors.get(i);
                            if (i == idx) {
                                if (!this.selectorToggleButtons[i].isSelected()) {
                                    if (this.statsTable != null) {
                                        this.statsTable.resetValues(i);
                                    }
                                    boxSel.reset();
                                    boxSel.setActive(false);
                                    boxSel.setVisible(false);
                                    imageXbox.reset();
                                    imageXbox.setActive(false);
                                    imageXbox.setVisible(false);
                                    imageYbox.reset();
                                    imageYbox.setActive(false);
                                    imageYbox.setVisible(false);
                                    curveSel.reset();
                                    curveSel.setActive(false);
                                    curveSel.setVisible(false);
                                    imageXcurve.reset();
                                    imageXcurve.setActive(false);
                                    imageXcurve.setVisible(false);
                                    imageYcurve.reset();
                                    imageYcurve.setActive(false);
                                    imageYcurve.setVisible(false);
                                    this.selectorToggleButtons[i].setSelected(true);
                                }
                                boxSel.setActive(!this.getSelectByCurve());
                                boxSel.setVisible(!this.getSelectByCurve());
                                imageXbox.setActive(!this.getSelectByCurve());
                                imageXbox.setVisible(!this.getSelectByCurve());
                                imageYbox.setActive(!this.getSelectByCurve());
                                imageYbox.setVisible(!this.getSelectByCurve());
                                curveSel.setActive(this.getSelectByCurve());
                                curveSel.setVisible(this.getSelectByCurve());
                                imageXcurve.setActive(this.getSelectByCurve());
                                imageXcurve.setVisible(this.getSelectByCurve());
                                imageYcurve.setActive(this.getSelectByCurve());
                                imageYcurve.setVisible(this.getSelectByCurve());
                                continue;
                            }
                            this.selectorToggleButtons[i].setSelected(false);
                            boxSel.setActive(false);
                            boxSel.setVisible(false);
                            imageXbox.setActive(false);
                            imageXbox.setVisible(false);
                            imageYbox.setActive(false);
                            imageYbox.setVisible(false);
                            curveSel.setActive(false);
                            curveSel.setVisible(false);
                            imageXcurve.setActive(false);
                            imageXcurve.setVisible(false);
                            imageYcurve.setActive(false);
                            imageYcurve.setVisible(false);
                        }
                    }
                    catch (Exception exc) {
                        System.out.println(exc);
                    }
                });
                ScatterBoxSelector boxSel = this.scatterBoxSelectors.get(k);
                ImageBoxSelector imageXbox = this.imageXBoxSelectors.get(k);
                ImageBoxSelector imageYbox = this.imageYBoxSelectors.get(k);
                ScatterCurveSelector curveSel = this.scatterCurveSelectors.get(k);
                ImageCurveSelector imageXcurve = this.imageXCurveSelectors.get(k);
                ImageCurveSelector imageYcurve = this.imageYCurveSelectors.get(k);
                if (k == 0) {
                    jtog.setSelected(true);
                    boxSel.setActive(!this.getSelectByCurve());
                    boxSel.setVisible(!this.getSelectByCurve());
                    imageXbox.setActive(!this.getSelectByCurve());
                    imageXbox.setVisible(!this.getSelectByCurve());
                    imageYbox.setActive(!this.getSelectByCurve());
                    imageYbox.setVisible(!this.getSelectByCurve());
                    curveSel.setActive(this.getSelectByCurve());
                    curveSel.setVisible(this.getSelectByCurve());
                    imageXcurve.setActive(this.getSelectByCurve());
                    imageXcurve.setVisible(this.getSelectByCurve());
                    imageYcurve.setActive(this.getSelectByCurve());
                    imageYcurve.setVisible(this.getSelectByCurve());
                    continue;
                }
                boxSel.setActive(false);
                boxSel.setVisible(false);
                imageXbox.setActive(false);
                imageXbox.setVisible(false);
                imageYbox.setActive(false);
                imageYbox.setVisible(false);
                curveSel.setActive(false);
                curveSel.setVisible(false);
                imageXcurve.setActive(false);
                imageXcurve.setVisible(false);
                imageYcurve.setActive(false);
                imageYcurve.setVisible(false);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public DisplayMaster makeScatterDisplay() throws VisADException, RemoteException {
        ScatterDisplayable scatterDsp = new ScatterDisplayable("scatter", RealType.getRealType("mask"), this.markPaletteBlackBackground, false);
        float[] valsX = this.X_field.getFloats(false)[0];
        float[] valsY = this.Y_field.getFloats(false)[0];
        Integer1DSet set = new Integer1DSet(valsX.length);
        FlatField scatter = new FlatField(new FunctionType(RealType.Generic, new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.getRealType("mask"))), set);
        float[] mask = new float[valsX.length];
        for (int k = 0; k < mask.length; ++k) {
            mask[k] = 0.0f;
        }
        this.scatterFieldRange = new float[][]{valsX, valsY, mask};
        scatter.setSamples(this.scatterFieldRange);
        scatterDsp.setPointSize(2.0f);
        scatterDsp.setRangeForColor(0.0, this.n_selectors);
        float[] xRange = ScatterDisplay.minmax(valsX);
        float[] yRange = ScatterDisplay.minmax(valsY);
        scatterDsp.setData(scatter);
        this.scatterMarkDsp = new ScatterDisplayable("scatter", RealType.getRealType("mask"), this.markPaletteBlackBackground, false);
        set = new Integer1DSet(2);
        scatter = new FlatField(new FunctionType(RealType.Generic, new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.getRealType("mask"))), set);
        this.scatterMarkDsp.setData(scatter);
        this.scatterMarkDsp.setPointSize(2.0f);
        this.scatterMarkDsp.setRangeForColor(0.0, this.n_selectors);
        DisplayMaster master = this.scatterMaster;
        ((XYDisplay)master).showAxisScales(true);
        AxisScale scaleX = ((XYDisplay)master).getXAxisScale();
        scaleX.setTitle(this.X_name);
        AxisScale scaleY = ((XYDisplay)master).getYAxisScale();
        scaleY.setTitle(this.Y_name);
        ((XYDisplay)master).setXRange(xRange[0], xRange[1]);
        ((XYDisplay)master).setYRange(yRange[0], yRange[1]);
        master.addDisplayable(scatterDsp);
        master.addDisplayable(this.scatterMarkDsp);
        return master;
    }

    @Override
    public Container doMakeContents() {
        JPanel pane = new JPanel(new GridLayout(1, 3));
        this.threeComps = new Component[]{null, null, null};
        this.threeComps[0] = this.dspMasterX.getComponent();
        this.threeComps[1] = this.dspMasterY.getComponent();
        this.threeComps[2] = this.getScatterTabComponent();
        JPanel panelX = new JPanel(new BorderLayout());
        panelX.setBorder(new EmptyBorder(4, 4, 4, 4));
        panelX.add(this.threeComps[0], "Center");
        panelX.add((Component)this.ctwCompX, "South");
        JPanel panelY = new JPanel(new BorderLayout());
        panelY.setBorder(new EmptyBorder(4, 4, 4, 4));
        panelY.add(this.threeComps[1], "Center");
        panelY.add((Component)this.ctwCompY, "South");
        JPanel panelS = new JPanel(new BorderLayout());
        panelS.setBorder(new EmptyBorder(4, 4, 4, 4));
        panelS.add(this.threeComps[2], "Center");
        pane.add(panelX);
        pane.add(panelY);
        pane.add(panelS);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JRadioButton boxSelect = new JRadioButton("Box");
        boxSelect.setSelected(true);
        JRadioButton curveSelect = new JRadioButton("Curve");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(boxSelect);
        buttonGroup.add(curveSelect);
        buttonPanel.add(boxSelect);
        buttonPanel.add(curveSelect);
        this.boxCurveSwitch = new BoxCurveSwitch();
        boxSelect.addActionListener(this.boxCurveSwitch);
        curveSelect.addActionListener(this.boxCurveSwitch);
        JPanel toggleButtonPanel = new JPanel(new FlowLayout());
        for (int k = 0; k < this.n_selectors; ++k) {
            JToggleButton jtog = new JToggleButton(GuiUtils.getImageIcon("/ucar/unidata/idv/images/subset12.jpg"));
            jtog.setBorder(new CompoundBorder(new LineBorder(this.selectorColors[k], 2), new EmptyBorder(4, 4, 4, 4)));
            jtog.setActionCommand(String.valueOf(k));
            toggleButtonPanel.add(jtog);
            this.selectorToggleButtons[k] = jtog;
        }
        buttonPanel.add(toggleButtonPanel);
        JButton computeStatsButton = new JButton("compute statistics");
        computeStatsButton.addActionListener(e -> {
            if (this.statsTable == null) {
                this.statsTable = new StatsTable();
            }
            this.statsTable.setIsShowing();
            this.statsTable.setFields(this.X_field, this.Y_field, 0);
        });
        buttonPanel.add(computeStatsButton);
        buttonPanel.add(new JLabel("Background Color:"));
        buttonPanel.add(this.bgColorBlack);
        buttonPanel.add(this.bgColorWhite);
        JPanel new_pane = new JPanel(new BorderLayout());
        new_pane.add((Component)pane, "Center");
        new_pane.add((Component)buttonPanel, "South");
        this.container = new_pane;
        return this.container;
    }

    public void setBlackBackground(boolean value) {
        this.blackBackground = value;
    }

    public boolean getBlackBackground() {
        return this.blackBackground;
    }

    protected Component getScatterTabComponent() {
        try {
            this.scatterMaster = new XYDisplay("Scatter", RealType.XAxis, RealType.YAxis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.scatterMaster.getComponent();
    }

    public DisplayMaster makeImageDisplay(MapProjection mapProj, FlatField image, FlatField mask_image, Range imageRange, ColorTable colorTable) throws VisADException, RemoteException {
        MapProjectionDisplayJ3D mapProjDsp = new MapProjectionDisplayJ3D(2);
        mapProjDsp.enableRubberBanding(false);
        MapProjectionDisplayJ3D dspMaster = mapProjDsp;
        mapProjDsp.setMapProjection(mapProj);
        RealType imageRangeType = ((FunctionType)image.getType()).getFlatRange().getRealComponents()[0];
        boolean alphaflag = false;
        HydraRGBDisplayable imageDsp = new HydraRGBDisplayable("image", imageRangeType, null, alphaflag, null);
        imageDsp.setData((Data)image);
        dspMaster.addDisplayable((Displayable)imageDsp);
        this.addMapDisplayables(mapProjDsp);
        if (mask_image != null) {
            ScatterDisplayable maskDsp = new ScatterDisplayable("mask", RealType.Generic, this.maskColorPalette, false);
            maskDsp.setData(mask_image);
            maskDsp.setRangeForColor(0.0, this.n_selectors - 1);
            dspMaster.addDisplayable(maskDsp);
        }
        dspMaster.draw();
        ScalarMap colorMap = imageDsp.getColorMap();
        colorMap.setRange(imageRange.getMin(), imageRange.getMax());
        BaseColorControl clrCntrl = (BaseColorControl)colorMap.getControl();
        Object ct = colorTable.getColorTable();
        if (!alphaflag && ((float[][])ct).length == 4) {
            float[][] new_ct = new float[][]{ct[0], ct[1], ct[2]};
            ct = new_ct;
        }
        clrCntrl.setTable((float[][])ct);
        return dspMaster;
    }

    public Range getImageRange(FlatField image) throws VisADException, RemoteException {
        DisplayConventions dc = this.getDisplayConventions();
        Range[] range = GridUtil.fieldMinMax(image);
        Range imageRange = range[0];
        RealType imageRangeType = ((FunctionType)image.getType()).getFlatRange().getRealComponents()[0];
        String canonicalName = DataAlias.aliasToCanonical(imageRangeType.getName());
        Range dfltRange = dc.getParamRange(canonicalName, null);
        if (dfltRange == null) {
            imageRange = range[0];
        } else if (!(imageRange.getMax() - imageRange.getMin() < dfltRange.getMax() - dfltRange.getMin())) {
            imageRange = dfltRange;
        }
        return imageRange;
    }

    public ColorTable getColorTable(FlatField image) throws VisADException, RemoteException {
        RealType imageRangeType = ((FunctionType)image.getType()).getFlatRange().getRealComponents()[0];
        DisplayConventions dc = this.getDisplayConventions();
        return dc.getParamColorTable(imageRangeType.getName());
    }

    public MapProjection getDataProjection(FlatField image) throws VisADException, RemoteException {
        MapProjection mp = null;
        FunctionType fnc_type = (FunctionType)image.getType();
        RealTupleType rtt = fnc_type.getDomain();
        CoordinateSystem cs = rtt.getCoordinateSystem();
        Set domainSet = image.getDomainSet();
        if (cs instanceof CachingCoordinateSystem) {
            cs = ((CachingCoordinateSystem)cs).getCachedCoordinateSystem();
        }
        if (cs instanceof MapProjection) {
            return (MapProjection)cs;
        }
        if (cs instanceof LongitudeLatitudeCoordinateSystem) {
            Rectangle2D rect = MultiSpectralData.getLonLatBoundingBox((FlatField)image);
            try {
                mp = new LambertAEA(rect);
            }
            catch (Exception e) {
                System.out.println(" getDataProjection" + e);
            }
            return mp;
        }
        float minLon = Float.NaN;
        float minLat = Float.NaN;
        float delLon = Float.NaN;
        float delLat = Float.NaN;
        if (domainSet instanceof LinearLatLonSet) {
            MathType type0 = ((SetType)domainSet.getType()).getDomain().getComponent(0);
            int latI = RealType.Latitude.equals(type0) ? 0 : 1;
            int lonI = latI == 1 ? 0 : 1;
            float[] min = ((LinearLatLonSet)domainSet).getLow();
            float[] max = ((LinearLatLonSet)domainSet).getHi();
            minLon = min[lonI];
            minLat = min[latI];
            delLon = max[lonI] - min[lonI];
            delLat = max[latI] - min[latI];
            try {
                mp = new TrivialMapProjection(RealTupleType.SpatialEarth2DTuple, new Rectangle2D.Float(minLon, minLat, delLon, delLat));
            }
            catch (Exception e) {
                ScatterDisplay.logException("MultiSpectralControl.getDataProjection", e);
            }
            return mp;
        }
        if (domainSet instanceof Gridded2DSet) {
            rtt = ((SetType)domainSet.getType()).getDomain();
            rtt = RealTupleType.SpatialEarth2DTuple;
            if (!rtt.equals(RealTupleType.SpatialEarth2DTuple) && !rtt.equals(RealTupleType.LatitudeLongitudeTuple)) {
                minLon = -180.0f;
                minLat = -90.0f;
                delLon = 360.0f;
                delLat = 180.0f;
            } else {
                int latI = rtt.equals(RealTupleType.SpatialEarth2DTuple) ? 1 : 0;
                int lonI = latI == 1 ? 0 : 1;
                float[] min = ((Gridded2DSet)domainSet).getLow();
                float[] max = ((Gridded2DSet)domainSet).getHi();
                minLon = min[lonI];
                minLat = min[latI];
                delLon = max[lonI] - min[lonI];
                delLat = max[latI] - min[latI];
            }
        }
        try {
            mp = new TrivialMapProjection(RealTupleType.SpatialEarth2DTuple, new Rectangle2D.Float(minLon, minLat, delLon, delLat));
        }
        catch (Exception e) {
            ScatterDisplay.logException("MultiSpectralControl.getDataProjection", e);
        }
        return mp;
    }

    public void addMapDisplayables(MapProjectionDisplayJ3D mapProjDsp) throws VisADException, RemoteException {
        BaseMapAdapter mapAdapter;
        MapLines mapLines = new MapLines("maplines");
        URL mapSource = mapProjDsp.getClass().getResource("/auxdata/maps/OUTLSUPU");
        try {
            mapAdapter = new BaseMapAdapter(mapSource);
            mapLines.setMapLines(mapAdapter.getData());
            mapLines.setColor(Color.cyan);
            mapProjDsp.addDisplayable(mapLines);
        }
        catch (Exception excp) {
            System.out.println("Can't open map file " + mapSource);
            System.out.println(excp);
        }
        mapLines = new MapLines("maplines");
        mapSource = mapProjDsp.getClass().getResource("/auxdata/maps/OUTLSUPW");
        try {
            mapAdapter = new BaseMapAdapter(mapSource);
            mapLines.setMapLines(mapAdapter.getData());
            mapLines.setColor(Color.cyan);
            mapProjDsp.addDisplayable(mapLines);
        }
        catch (Exception excp) {
            System.out.println("Can't open map file " + mapSource);
            System.out.println(excp);
        }
        mapLines = new MapLines("maplines");
        mapSource = mapProjDsp.getClass().getResource("/auxdata/maps/OUTLHPOL");
        try {
            mapAdapter = new BaseMapAdapter(mapSource);
            mapLines.setMapLines(mapAdapter.getData());
            mapLines.setColor(Color.cyan);
            mapProjDsp.addDisplayable(mapLines);
        }
        catch (Exception excp) {
            System.out.println("Can't open map file " + mapSource);
            System.out.println(excp);
        }
    }

    public boolean getSelectByCurve() {
        return this.selectByCurve;
    }

    private FlatField resample(FlatField X_field, FlatField Y_field) throws VisADException, RemoteException {
        Gridded2DSet domSet;
        RealTupleType X_domainRef = null;
        RealTupleType Y_domainRef = null;
        float[][] coords = null;
        int[] indexes = null;
        float[][] Yvalues = Y_field.getFloats(false);
        float[][] Xsamples = ((SampledSet)X_field.getDomainSet()).getSamples(false);
        CoordinateSystem X_cs = X_field.getDomainCoordinateSystem();
        if (X_cs == null) {
            RealTupleType realTupleType = ((FunctionType)X_field.getType()).getDomain();
        } else {
            X_domainRef = X_cs.getReference();
        }
        CoordinateSystem Y_cs = Y_field.getDomainCoordinateSystem();
        if (Y_cs == null) {
            RealTupleType realTupleType = ((FunctionType)Y_field.getType()).getDomain();
        } else {
            Y_domainRef = Y_cs.getReference();
        }
        if (X_domainRef != null && Y_domainRef != null) {
            Xsamples = X_cs.toReference(Xsamples);
            coords = Y_cs.fromReference(Xsamples);
            indexes = ((SampledSet)Y_field.getDomainSet()).valueToIndex(coords);
        } else if (X_domainRef == null && Y_domainRef != null) {
            Xsamples = Y_cs.fromReference(Xsamples);
            indexes = ((SampledSet)Y_field.getDomainSet()).valueToIndex(Xsamples);
        } else if (X_domainRef != null && Y_domainRef == null) {
            Xsamples = X_cs.toReference(Xsamples);
            domSet = (Gridded2DSet)Y_field.getDomainSet();
            float[] hi = domSet.getHi();
            if (hi[0] <= 180.0f) {
                for (int t = 0; t < Xsamples[0].length; ++t) {
                    if (!(Xsamples[0][t] > 180.0f)) continue;
                    float[] fArray = Xsamples[0];
                    int n = t;
                    fArray[n] = fArray[n] - 360.0f;
                }
            }
            indexes = ((SampledSet)Y_field.getDomainSet()).valueToIndex(Xsamples);
        } else if (X_domainRef == null && Y_domainRef == null) {
            domSet = (Gridded2DSet)Y_field.getDomainSet();
            indexes = domSet.valueToIndex(Xsamples);
        }
        float[][] new_values = new float[1][indexes.length];
        for (int k = 0; k < indexes.length; ++k) {
            new_values[0][k] = Float.NaN;
            if (indexes[k] < 0) continue;
            new_values[0][k] = Yvalues[0][indexes[k]];
        }
        FunctionType ftype = new FunctionType(((FunctionType)X_field.getType()).getDomain(), ((FunctionType)Y_field.getType()).getRange());
        Y_field = new FlatField(ftype, X_field.getDomainSet());
        Y_field.setSamples(new_values);
        return Y_field;
    }

    public static float[] minmax(float[] values) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int k = 0; k < values.length; ++k) {
            float val = values[k];
            if (val != val || !(val < Float.POSITIVE_INFINITY) || !(val > Float.NEGATIVE_INFINITY)) continue;
            if (val < min) {
                min = val;
            }
            if (!(val > max)) continue;
            max = val;
        }
        return new float[]{min, max};
    }

    public boolean getIsLatLon(FlatField field) throws VisADException, RemoteException {
        boolean isLL = false;
        FunctionType fnc_type = (FunctionType)field.getType();
        RealTupleType rtt = fnc_type.getDomain();
        if (rtt.equals(RealTupleType.LatitudeLongitudeTuple)) {
            isLL = true;
        } else if (!rtt.equals(RealTupleType.SpatialEarth2DTuple) && (rtt = fnc_type.getDomain().getCoordinateSystem().getReference()).equals(RealTupleType.LatitudeLongitudeTuple)) {
            isLL = true;
        }
        return isLL;
    }

    protected void getViewMenuItems1(List menus, boolean forMenuBar) {
        super.getViewMenuItems(menus, forMenuBar);
        if (forMenuBar) {
            JMenu svMenu = this.makeViewMenu();
            svMenu.setText("Sounding Chart");
            menus.add(svMenu);
        }
    }

    public JMenu makeViewMenu() {
        ViewManager vm = new ViewManager();
        vm.setShowControlLegend(false);
        JMenu viewMenu = GuiUtils.makeDynamicMenu("View", vm, "firstInitializeViewMenu");
        viewMenu.setMnemonic(GuiUtils.charToKeyCode("V"));
        if (this.viewMenu == null) {
            this.viewMenu = viewMenu;
        }
        return viewMenu;
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeMenuItem("Save Scatter Display ...", this, "saveImage"));
    }

    public void saveImage() {
        JComboBox publishCbx = this.getIdv().getPublishManager().getSelector("nc.export");
        String filename = FileManager.getWriteFile(FileManager.FILTER_IMAGE, ".jpg", (JComponent)(publishCbx != null ? GuiUtils.top(publishCbx) : null));
        if (filename == null) {
            return;
        }
        try {
            BufferedImage bufferedImage = this.makeBufferedImage(this.container);
            if (filename.endsWith(".pdf")) {
                FileOutputStream fos = new FileOutputStream(filename);
                ImageUtils.writePDF(fos, (JComponent)this.container);
                ((OutputStream)fos).close();
                return;
            }
            ImageUtils.writeImageToFile((Image)bufferedImage, filename);
            this.getIdv().getPublishManager().publishContent(filename, null, publishCbx);
        }
        catch (Exception exc) {
            LogUtil.logException("Capturing image", exc);
        }
    }

    public BufferedImage makeBufferedImage(Component comp) throws AWTException {
        Dimension dim = comp.getSize();
        Point loc = comp.getLocationOnScreen();
        GraphicsConfiguration gc = comp.getGraphicsConfiguration();
        Robot robot = new Robot(gc.getDevice());
        if (gc.getBounds().x > 0 || gc.getBounds().y > 0) {
            System.err.println("Offsetting location:" + loc + " by gc bounds: " + gc.getBounds().x + " " + gc.getBounds().y);
            loc.x -= gc.getBounds().x;
            loc.y -= gc.getBounds().y;
            System.err.println("new location:" + loc);
        }
        if (dim.width <= 0 || dim.height <= 0) {
            throw new IllegalStateException("Bad component size:" + dim.width + " X " + dim.height);
        }
        this.toFront();
        Misc.sleep(250L);
        BufferedImage image = null;
        try {
            image = robot.createScreenCapture(new Rectangle(loc.x, loc.y, dim.width, dim.height));
        }
        catch (Exception exc) {
            ScatterDisplay.logException("Error capturing image:  location:" + loc.x + "x" + loc.y + " dimension:" + dim.width + "x" + dim.height, exc);
        }
        return image;
    }

    private class BoxCurveSwitch
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            try {
                if (cmd.equals("Box")) {
                    ScatterDisplay.this.selectByCurve = false;
                } else if (cmd.equals("Curve")) {
                    ScatterDisplay.this.selectByCurve = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ScatterCurveSelector
    extends CellImpl
    implements DisplayListener {
        CurveDrawer curveDraw = new CurveDrawer(RealType.XAxis, RealType.YAxis, 1);
        boolean init = false;
        UnionSet last_uSet = null;
        boolean active = true;
        float maskVal = 0.0f;
        LineDrawing selectCurve;

        ScatterCurveSelector(DisplayMaster master, Color color, float maskVal) throws VisADException, RemoteException {
            this.curveDraw.setColor(color);
            this.curveDraw.setLineWidth(2.0f);
            this.curveDraw.setData((Data)new UnionSet(new Gridded2DSet[]{new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{ScatterDisplay.this.scatterFieldRange[0][0]}, {ScatterDisplay.this.scatterFieldRange[1][0]}}, 1)}));
            this.selectCurve = new LineDrawing("select");
            this.selectCurve.setColor(color);
            this.selectCurve.setLineWidth(2.0f);
            master.addDisplayable((Displayable)this.curveDraw);
            master.addDisplayable(this.selectCurve);
            this.maskVal = maskVal;
            this.curveDraw.addAction((Action)this);
            master.addDisplayListener(this);
        }

        @Override
        public void displayChanged(DisplayEvent de) throws VisADException, RemoteException {
            if (de.getId() == 7 && this.active) {
                UnionSet uSet = this.curveDraw.getCurves();
                if (uSet == this.last_uSet) {
                    return;
                }
                SampledSet[] sets = uSet.getSets();
                int s_idx = sets.length - 1;
                float[][] crv = sets[s_idx].getSamples();
                this.last_uSet = new UnionSet(new SampledSet[]{sets[s_idx]});
                this.curveDraw.setCurves(this.last_uSet);
                this.selectCurve.setData(this.last_uSet);
                try {
                    ScatterDisplay.this.histoField.clearMaskField(this.maskVal);
                    ScatterDisplay.this.histoField.markMaskFieldByCurve(crv, this.maskVal);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void doAction() throws VisADException, RemoteException {
            if (!this.init) {
                this.init = true;
                return;
            }
        }

        public void setVisible(boolean visible) throws VisADException, RemoteException {
            this.curveDraw.setVisible(visible);
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void reset() throws Exception {
            if (!this.active) {
                return;
            }
            this.curveDraw.setData((Data)new UnionSet(new Gridded2DSet[]{new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{ScatterDisplay.this.scatterFieldRange[0][0]}, {ScatterDisplay.this.scatterFieldRange[1][0]}}, 1)}));
            this.selectCurve.setData(new UnionSet(new Gridded2DSet[]{new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{ScatterDisplay.this.scatterFieldRange[0][0]}, {ScatterDisplay.this.scatterFieldRange[1][0]}}, 1)}));
            ScatterDisplay.this.histoField.resetMaskField(this.maskVal);
        }
    }

    private class ScatterBoxSelector
    extends CellImpl {
        boolean init = false;
        double[] x_coords = new double[2];
        double[] y_coords = new double[2];
        RubberBandBox rbb;
        LineDrawing selectBox = new LineDrawing("select");
        boolean active = true;
        float maskVal = 0.0f;

        ScatterBoxSelector(DisplayMaster master, Color color, float maskVal) throws VisADException, RemoteException {
            this.selectBox.setColor(color);
            this.rbb = new RubberBandBox(RealType.XAxis, RealType.YAxis, 1);
            this.rbb.setColor(color);
            this.rbb.addAction(this);
            master.addDisplayable(this.rbb);
            master.addDisplayable(this.selectBox);
            this.maskVal = maskVal;
        }

        @Override
        public void doAction() throws VisADException, RemoteException {
            if (!this.init) {
                this.init = true;
                return;
            }
            if (!this.active) {
                return;
            }
            Gridded2DSet set = this.rbb.getBounds();
            float[] low = set.getLow();
            float[] hi = set.getHi();
            this.x_coords[0] = low[0];
            this.x_coords[1] = hi[0];
            this.y_coords[0] = low[1];
            this.y_coords[1] = hi[1];
            SampledSet[] sets = new SampledSet[]{new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{low[0], hi[0]}, {low[1], low[1]}}, 2), new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{hi[0], hi[0]}, {low[1], hi[1]}}, 2), new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{hi[0], low[0]}, {hi[1], hi[1]}}, 2), new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{low[0], low[0]}, {hi[1], low[1]}}, 2)};
            UnionSet uset = new UnionSet(sets);
            this.selectBox.setData(uset);
            try {
                ScatterDisplay.this.histoField.markMaskFieldByRange(this.x_coords, this.y_coords, this.maskVal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setVisible(boolean visible) throws VisADException, RemoteException {
            this.rbb.setVisible(visible);
            if (visible) {
                this.selectBox.setVisible(visible);
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void reset() throws Exception {
            if (!this.active) {
                return;
            }
            this.selectBox.setVisible(false);
            this.selectBox.setData(new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}}, 2));
            ScatterDisplay.this.histoField.resetMaskField(this.maskVal);
        }
    }

    private class ImageBoxSelector
    extends CellImpl {
        boolean init = false;
        boolean active = true;
        SubsetRubberBandBox subsetBox;
        Set imageDomain;
        int domainLen_0;
        LineDrawing lastBox;
        ImageBoxSelector other;
        float maskVal;
        boolean earthCoordDomain = false;
        StatsTable myTable = null;
        int myTableIndex = 0;

        ImageBoxSelector(SubsetRubberBandBox subsetBox, Set imageDomain, DisplayMaster master, Color color, float maskVal, StatsTable mst) throws VisADException, RemoteException {
            this.myTable = mst;
            this.myTableIndex = 0;
            if (color == Color.magenta) {
                this.myTableIndex = 1;
            }
            if (color == Color.green) {
                this.myTableIndex = 2;
            }
            if (color == Color.blue) {
                this.myTableIndex = 3;
            }
            this.subsetBox = subsetBox;
            this.imageDomain = imageDomain;
            int[] lens = ((Gridded2DSet)imageDomain).getLengths();
            this.maskVal = maskVal;
            this.domainLen_0 = lens[0];
            this.lastBox = new LineDrawing("last_box");
            this.lastBox.setColor(color);
            master.addDisplayable(this.lastBox);
            subsetBox.addAction((Action)this);
            master.addDisplayable((Displayable)subsetBox);
            RealTupleType rtt = ((SetType)imageDomain.getType()).getDomain();
            if (rtt.equals(RealTupleType.SpatialEarth2DTuple) || rtt.equals(RealTupleType.LatitudeLongitudeTuple)) {
                this.earthCoordDomain = true;
            }
        }

        @Override
        public void doAction() throws VisADException, RemoteException {
            int k;
            float[][] corners;
            if (!this.init) {
                this.init = true;
                return;
            }
            if (!this.active) {
                return;
            }
            Gridded2DSet set = this.subsetBox.getBounds();
            float[][] coords = corners = set.getSamples(false);
            if (corners == null) {
                return;
            }
            if (this.imageDomain instanceof Linear2DSet || !this.earthCoordDomain) {
                coords = ((Gridded2DSet)this.imageDomain).valueToGrid(corners);
            }
            float[] coords_0 = coords[0];
            float[] coords_1 = coords[1];
            int low_0 = Math.round(Math.min(coords_0[0], coords_0[1]));
            int low_1 = Math.round(Math.min(coords_1[0], coords_1[1]));
            int hi_0 = Math.round(Math.max(coords_0[0], coords_0[1]));
            int hi_1 = Math.round(Math.max(coords_1[0], coords_1[1]));
            int len_0 = hi_0 - low_0 + 1;
            int len_1 = hi_1 - low_1 + 1;
            int len = len_0 * len_1;
            float[][] markScatter = new float[3][len];
            int[] selected = new int[len];
            for (int j = 0; j < len_1; ++j) {
                for (int i = 0; i < len_0; ++i) {
                    int idx = (j + low_1) * this.domainLen_0 + (i + low_0);
                    k = j * len_0 + i;
                    markScatter[0][k] = ScatterDisplay.this.scatterFieldRange[0][idx];
                    markScatter[1][k] = ScatterDisplay.this.scatterFieldRange[1][idx];
                    markScatter[2][k] = this.maskVal;
                    selected[k] = idx;
                }
            }
            int last_len = 0;
            float[][] lastMark = ((FlatField)ScatterDisplay.this.scatterMarkDsp.getData()).getFloats(false);
            float[][] tmp = new float[3][lastMark[0].length];
            for (k = 0; k < lastMark[0].length; ++k) {
                if (lastMark[2][k] == this.maskVal) continue;
                tmp[0][last_len] = lastMark[0][k];
                tmp[1][last_len] = lastMark[1][k];
                tmp[2][last_len] = lastMark[2][k];
                ++last_len;
            }
            float[][] newMarkScatter = new float[3][len + last_len];
            System.arraycopy(tmp[0], 0, newMarkScatter[0], 0, last_len);
            System.arraycopy(tmp[1], 0, newMarkScatter[1], 0, last_len);
            System.arraycopy(tmp[2], 0, newMarkScatter[2], 0, last_len);
            System.arraycopy(markScatter[0], 0, newMarkScatter[0], last_len, len);
            System.arraycopy(markScatter[1], 0, newMarkScatter[1], last_len, len);
            System.arraycopy(markScatter[2], 0, newMarkScatter[2], last_len, len);
            Integer1DSet dset = new Integer1DSet(len + last_len);
            FlatField scatterFieldMark = new FlatField(new FunctionType(RealType.Generic, new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.getRealType("mask"))), dset);
            scatterFieldMark.setSamples(newMarkScatter, false);
            ScatterDisplay.this.scatterMarkDsp.setData(scatterFieldMark);
            if (this.myTable != null) {
                ScatterDisplay.this.total_area = JPythonMethods.computeSum(ScatterDisplay.this.Area_field, selected);
                this.myTable.setPoints(markScatter, len, this.myTableIndex, ScatterDisplay.this.total_area);
            }
            this.updateBox();
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVisible(boolean visible) throws VisADException, RemoteException {
            this.subsetBox.setVisible(visible);
            if (visible) {
                this.lastBox.setVisible(visible);
            }
        }

        public void reset() throws VisADException, RemoteException {
            FlatField scatterFieldMark;
            Gridded2DSet set2D = new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{{0.0f}, {0.0f}}, 1);
            this.lastBox.setVisible(false);
            this.lastBox.setData(set2D);
            float[][] lastMark = ((FlatField)ScatterDisplay.this.scatterMarkDsp.getData()).getFloats(false);
            float[][] tmp = new float[3][lastMark[0].length];
            int cnt = 0;
            for (int k = 0; k < lastMark[0].length; ++k) {
                if (lastMark[2][k] == this.maskVal) continue;
                tmp[0][cnt] = lastMark[0][k];
                tmp[1][cnt] = lastMark[1][k];
                tmp[2][cnt] = lastMark[2][k];
                ++cnt;
            }
            if (cnt == 2) {
                Integer1DSet dset = new Integer1DSet(2);
                scatterFieldMark = new FlatField(new FunctionType(RealType.Generic, new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.getRealType("mask"))), dset);
                float[][] markScatter = new float[3][2];
                for (int k = 0; k < 2; ++k) {
                    markScatter[0][k] = ScatterDisplay.this.scatterFieldRange[0][k];
                    markScatter[1][k] = ScatterDisplay.this.scatterFieldRange[1][k];
                    markScatter[2][k] = 0.0f;
                }
                scatterFieldMark.setSamples(markScatter, false);
            } else {
                Integer1DSet dset = new Integer1DSet(cnt);
                scatterFieldMark = new FlatField(new FunctionType(RealType.Generic, new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.getRealType("mask"))), dset);
                float[][] markScatter = new float[3][cnt];
                for (int k = 0; k < cnt; ++k) {
                    markScatter[0][k] = tmp[0][k];
                    markScatter[1][k] = tmp[1][k];
                    markScatter[2][k] = tmp[2][k];
                }
                scatterFieldMark.setSamples(markScatter, false);
            }
            ScatterDisplay.this.scatterMarkDsp.setData(scatterFieldMark);
        }

        public void setOther(ImageBoxSelector other) {
            this.other = other;
        }

        public void updateBox() throws VisADException, RemoteException {
            Gridded3DSet set3D = this.subsetBox.getLastBox();
            float[][] samples = set3D.getSamples(false);
            Gridded2DSet set2D = new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])new float[][]{samples[0], samples[1]}, samples[0].length);
            this.lastBox.setData(set2D);
            this.other.updateBox(set2D);
        }

        public void updateBox(Gridded2DSet set2D) throws VisADException, RemoteException {
            this.lastBox.setData(set2D);
        }
    }

    private class ImageCurveSelector
    extends CellImpl
    implements DisplayListener {
        boolean init = false;
        CurveDrawer curveDraw;
        DisplayMaster dspMaster;
        Gridded2DSet domainSet;
        CoordinateSystem cs;
        int domainLen_0;
        int domainLen_1;
        ImageCurveSelector other;
        UnionSet last_uSet = null;
        boolean imageLatLon = false;
        boolean active = true;
        float maskVal;
        LineDrawing lastCurve;
        StatsTable myTable = null;
        int myTableIndex = 0;

        ImageCurveSelector(CurveDrawer curveDraw, FlatField image, DisplayMaster master, Color color, float maskVal, StatsTable mst) throws VisADException, RemoteException {
            this.curveDraw = curveDraw;
            this.maskVal = maskVal;
            this.myTable = mst;
            this.myTableIndex = 0;
            if (color == Color.magenta) {
                this.myTableIndex = 1;
            }
            if (color == Color.green) {
                this.myTableIndex = 2;
            }
            if (color == Color.blue) {
                this.myTableIndex = 3;
            }
            this.dspMaster = master;
            this.dspMaster.addDisplayListener(this);
            this.domainSet = (Gridded2DSet)image.getDomainSet();
            int[] lens = this.domainSet.getLengths();
            this.domainLen_0 = lens[0];
            this.domainLen_1 = lens[1];
            this.cs = ((FunctionType)image.getType()).getDomain().getCoordinateSystem();
            RealTupleType reference = null;
            reference = this.cs != null ? this.cs.getReference() : ((SetType)this.domainSet.getType()).getDomain();
            RealType[] rtypes = reference.getRealComponents();
            if (rtypes[0].equals(RealType.Latitude)) {
                this.imageLatLon = true;
            }
            this.lastCurve = new LineDrawing("lastCurve");
            this.lastCurve.setColor(color);
            this.lastCurve.setLineWidth(2.0f);
            master.addDisplayable(this.lastCurve);
        }

        @Override
        public void displayChanged(DisplayEvent de) throws VisADException, RemoteException {
            if (de.getId() == 7 && this.active) {
                float[][] crv;
                UnionSet uSet = this.curveDraw.getCurves();
                if (uSet == this.last_uSet) {
                    return;
                }
                SampledSet[] sets = uSet.getSets();
                int s_idx = sets.length - 1;
                if (this.cs != null) {
                    crv = sets[s_idx].getSamples();
                    if (this.imageLatLon) {
                        float[] tmp = crv[0];
                        crv[0] = crv[1];
                        crv[1] = tmp;
                    }
                    crv = this.cs.fromReference(crv);
                    crv = this.domainSet.valueToGrid(crv);
                } else {
                    crv = sets[s_idx].getSamples();
                    crv = this.domainSet.valueToGrid(crv);
                }
                float[][] onImage = new float[2][crv[0].length];
                int cnt = 0;
                for (int i = 0; i < crv[0].length; ++i) {
                    if (!(crv[0][i] >= 0.0f) || !(crv[0][i] <= (float)this.domainLen_0) || !(crv[1][i] >= 0.0f) || !(crv[1][i] <= (float)this.domainLen_1)) continue;
                    onImage[0][cnt] = crv[0][i];
                    onImage[1][cnt] = crv[1][i];
                    ++cnt;
                }
                this.last_uSet = uSet = new UnionSet(new SampledSet[]{sets[s_idx]});
                this.lastCurve.setData(this.last_uSet);
                this.curveDraw.setCurves(uSet);
                this.other.updateCurve(sets[s_idx]);
                if (cnt == 0) {
                    return;
                }
                float[][] tmp = new float[2][cnt];
                System.arraycopy(onImage[0], 0, tmp[0], 0, cnt);
                System.arraycopy(onImage[1], 0, tmp[1], 0, cnt);
                onImage = tmp;
                float[] minmaxvals = ScatterDisplay.minmax(onImage[0]);
                int low_0 = Math.round(minmaxvals[0]);
                int hi_0 = Math.round(minmaxvals[1]);
                minmaxvals = ScatterDisplay.minmax(onImage[1]);
                int low_1 = Math.round(minmaxvals[0]);
                int hi_1 = Math.round(minmaxvals[1]);
                int len_0 = hi_0 - low_0 + 1;
                int len_1 = hi_1 - low_1 + 1;
                int len = len_0 * len_1;
                tmp = new float[3][len];
                int[] tmpsel = new int[len];
                int num_inside = 0;
                for (int j = 0; j < len_1; ++j) {
                    for (int i = 0; i < len_0; ++i) {
                        int idx = (j + low_1) * this.domainLen_0 + (i + low_0);
                        float x = i + low_0;
                        float y = j + low_1;
                        if (!DelaunayCustom.inside(crv, x, y)) continue;
                        tmp[0][num_inside] = ScatterDisplay.this.scatterFieldRange[0][idx];
                        tmp[1][num_inside] = ScatterDisplay.this.scatterFieldRange[1][idx];
                        tmp[2][num_inside] = this.maskVal;
                        tmpsel[num_inside] = idx;
                        ++num_inside;
                    }
                }
                len = num_inside;
                float[][] markScatter = new float[3][len];
                System.arraycopy(tmp[0], 0, markScatter[0], 0, len);
                System.arraycopy(tmp[1], 0, markScatter[1], 0, len);
                System.arraycopy(tmp[2], 0, markScatter[2], 0, len);
                int last_len = 0;
                float[][] lastMark = ((FlatField)ScatterDisplay.this.scatterMarkDsp.getData()).getFloats(false);
                tmp = new float[3][lastMark[0].length];
                for (int k = 0; k < lastMark[0].length; ++k) {
                    if (lastMark[2][k] == this.maskVal) continue;
                    tmp[0][last_len] = lastMark[0][k];
                    tmp[1][last_len] = lastMark[1][k];
                    tmp[2][last_len] = lastMark[2][k];
                    ++last_len;
                }
                float[][] newMarkScatter = new float[3][len + last_len];
                System.arraycopy(tmp[0], 0, newMarkScatter[0], 0, last_len);
                System.arraycopy(tmp[1], 0, newMarkScatter[1], 0, last_len);
                System.arraycopy(tmp[2], 0, newMarkScatter[2], 0, last_len);
                System.arraycopy(markScatter[0], 0, newMarkScatter[0], last_len, len);
                System.arraycopy(markScatter[1], 0, newMarkScatter[1], last_len, len);
                System.arraycopy(markScatter[2], 0, newMarkScatter[2], last_len, len);
                Integer1DSet dset = new Integer1DSet(len + last_len);
                FlatField scatterFieldMark = new FlatField(new FunctionType(RealType.Generic, new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.getRealType("mask"))), dset);
                scatterFieldMark.setSamples(newMarkScatter, false);
                ScatterDisplay.this.scatterMarkDsp.setData(scatterFieldMark);
                if (this.myTable != null) {
                    int[] selected = new int[len];
                    System.arraycopy(tmpsel, 0, selected, 0, len);
                    ScatterDisplay.this.total_area = JPythonMethods.computeSum(ScatterDisplay.this.Area_field, selected);
                    this.myTable.setPoints(markScatter, len, this.myTableIndex, ScatterDisplay.this.total_area);
                }
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void reset() throws VisADException, RemoteException {
            float[][] lastMark = ((FlatField)ScatterDisplay.this.scatterMarkDsp.getData()).getFloats(false);
            float[][] tmp = new float[3][lastMark[0].length];
            int cnt = 0;
            for (int k = 0; k < lastMark[0].length; ++k) {
                if (lastMark[2][k] == this.maskVal) continue;
                tmp[0][cnt] = lastMark[0][k];
                tmp[1][cnt] = lastMark[1][k];
                tmp[2][cnt] = lastMark[2][k];
                ++cnt;
            }
            RealTupleType type = ((SetType)this.curveDraw.getCurves().getType()).getDomain();
            this.curveDraw.setCurves(new UnionSet(new Gridded2DSet[]{new Gridded2DSet((MathType)type, (float[][])new float[][]{{0.0f}, {0.0f}}, 1)}));
            this.lastCurve.setData(new UnionSet(new Gridded2DSet[]{new Gridded2DSet((MathType)type, (float[][])new float[][]{{0.0f}, {0.0f}}, 1)}));
            FlatField scatterFieldMark = null;
            if (cnt == 0) {
                Integer1DSet dset = new Integer1DSet(2);
                scatterFieldMark = new FlatField(new FunctionType(RealType.Generic, new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.getRealType("mask"))), dset);
                float[][] markScatter = new float[3][2];
                for (int k = 0; k < 2; ++k) {
                    markScatter[0][k] = ScatterDisplay.this.scatterFieldRange[0][k];
                    markScatter[1][k] = ScatterDisplay.this.scatterFieldRange[1][k];
                    markScatter[2][k] = 0.0f;
                }
                scatterFieldMark.setSamples(markScatter, false);
            } else {
                Integer1DSet dset = new Integer1DSet(cnt);
                scatterFieldMark = new FlatField(new FunctionType(RealType.Generic, new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.getRealType("mask"))), dset);
                float[][] markScatter = new float[3][cnt];
                for (int k = 0; k < cnt; ++k) {
                    markScatter[0][k] = tmp[0][k];
                    markScatter[1][k] = tmp[1][k];
                    markScatter[2][k] = tmp[2][k];
                }
                scatterFieldMark.setSamples(markScatter, false);
            }
            ScatterDisplay.this.scatterMarkDsp.setData(scatterFieldMark);
        }

        public void updateCurve(SampledSet set) throws VisADException, RemoteException {
            this.last_uSet = new UnionSet(new SampledSet[]{set});
            this.curveDraw.setCurves(this.last_uSet);
            this.lastCurve.setData(this.last_uSet);
        }

        public void setOther(ImageCurveSelector other) {
            this.other = other;
        }

        @Override
        public void doAction() throws VisADException, RemoteException {
            if (!this.init) {
                this.init = true;
                return;
            }
        }

        public void setVisible(boolean visible) throws VisADException, RemoteException {
            this.curveDraw.setVisible(visible);
        }
    }

    private class ImageControl
    extends DisplayControlImpl {
        HydraRGBDisplayable rgbDisp;
        DisplayConventions dc;
        ColorTableWidget ctw;

        ImageControl(HydraRGBDisplayable rgbDisp, DisplayConventions dc) {
            this.rgbDisp = rgbDisp;
            this.dc = dc;
        }

        @Override
        public void setRange(Range r) throws VisADException, RemoteException {
            if (r != null) {
                this.rgbDisp.setRangeForColor(r.getMin(), r.getMax());
            }
        }

        @Override
        public DisplayConventions getDisplayConventions() {
            return this.dc;
        }

        @Override
        public void setColorTable(ColorTable ct) {
            try {
                this.ctw.setColorTable(ct);
                ScalarMap colorMap = this.rgbDisp.getColorMap();
                BaseColorControl clrCntrl = (BaseColorControl)colorMap.getControl();
                int numComps = clrCntrl.getNumberOfComponents();
                float[][] clrTable = ct.getColorTable();
                float[][] newTable = null;
                if (numComps != clrTable.length) {
                    if (numComps < clrTable.length) {
                        newTable = new float[numComps][clrTable[0].length];
                        for (int k = 0; k < numComps; ++k) {
                            System.arraycopy(clrTable[k], 0, newTable[k], 0, newTable[0].length);
                        }
                    } else if (numComps > clrTable.length) {
                        newTable = new float[numComps][clrTable[0].length];
                        for (int k = 0; k < clrTable.length; ++k) {
                            System.arraycopy(clrTable[k], 0, newTable[k], 0, newTable[0].length);
                        }
                        newTable[3] = new float[clrTable[0].length];
                    }
                } else {
                    newTable = new float[numComps][clrTable[0].length];
                    for (int k = 0; k < clrTable.length; ++k) {
                        System.arraycopy(clrTable[k], 0, newTable[k], 0, newTable[0].length);
                    }
                }
                clrCntrl.setTable(newTable);
            }
            catch (Exception e) {
                LogUtil.logException("Problem changing color table", e);
            }
        }
    }

    private class ScatterDisplayable
    extends RGBDisplayable {
        ScatterDisplayable(String name, RealType rgbRealType, float[][] colorPalette, boolean alphaflag) throws VisADException, RemoteException {
            super(name, rgbRealType, colorPalette, alphaflag);
        }
    }
}

