/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.idv.control.SoundingDataNode;
import ucar.visad.Util;
import visad.Data;
import visad.DateTime;
import visad.Field;
import visad.Real;
import visad.RealTuple;
import visad.SampledSet;
import visad.Set;
import visad.SingletonSet;
import visad.Tuple;
import visad.VisADException;
import visad.georef.LatLonTuple;
import visad.georef.NamedLocationTuple;

final class RaobSoundingDataNode
extends SoundingDataNode {
    private DateTime[] dateTimes;
    private List stations;
    private Hashtable<String, List> stationsTuples;
    private String[] stationIds;

    RaobSoundingDataNode(SoundingDataNode.Listener listener) throws VisADException, RemoteException {
        super(listener);
    }

    public void setData1(Data data) throws VisADException, RemoteException {
        Tuple tuple = (Tuple)data;
        this.setData(tuple);
    }

    public void setData(Tuple data) throws VisADException, RemoteException {
        Tuple tuple = data;
        SingletonSet outTimes = new SingletonSet(new RealTuple(new Real[]{(DateTime)tuple.getComponent(0)}));
        NamedLocationTuple station = (NamedLocationTuple)tuple.getComponent(1);
        LatLonTuple outLoc = new LatLonTuple(station.getLatitude(), station.getLongitude());
        SingletonSet outLocs = new SingletonSet(outLoc);
        Field[] tempPros = new Field[]{(Field)tuple.getComponent(2)};
        Field[] dewPros = new Field[]{(Field)tuple.getComponent(3)};
        Field[] windPros = new Field[]{(Field)tuple.getComponent(4)};
        this.setOutputTimes(outTimes);
        this.setOutputLocation(outLoc);
        this.setOutputLocations(outLocs);
        this.setOutputProfiles(tempPros, dewPros, windPros);
    }

    @Override
    public void setData(Data data) throws VisADException, RemoteException {
        Tuple tuple = (Tuple)data;
        Field[] tempPros = new Field[tuple.getDimension()];
        Field[] dewPros = new Field[tempPros.length];
        Field[] windPros = new Field[tempPros.length];
        this.dateTimes = new DateTime[tempPros.length];
        this.stationIds = new String[tempPros.length];
        this.stations = new ArrayList();
        this.stationsTuples = new Hashtable();
        LatLonTuple[] outLoc = new LatLonTuple[tempPros.length];
        for (int i = 0; i < tempPros.length; ++i) {
            ArrayList<Tuple> tupleList;
            Tuple ob = (Tuple)tuple.getComponent(i);
            this.dateTimes[i] = (DateTime)ob.getComponent(0);
            NamedLocationTuple station = (NamedLocationTuple)ob.getComponent(1);
            this.stationIds[i] = station.getIdentifier().toString() + " " + ((DateTime)ob.getComponent(0)).toString();
            if (!this.stations.contains(station.getIdentifier().toString())) {
                this.stations.add(station.getIdentifier().toString());
            }
            if ((tupleList = this.stationsTuples.get(this.stationIds[i])) == null) {
                tupleList = new ArrayList<Tuple>();
                this.stationsTuples.put(station.getIdentifier().toString(), tupleList);
            }
            tupleList.add(ob);
            outLoc[i] = new LatLonTuple(station.getLatitude(), station.getLongitude());
            tempPros[i] = (Field)ob.getComponent(2);
            dewPros[i] = (Field)ob.getComponent(3);
            windPros[i] = (Field)ob.getComponent(4);
        }
        this.setOutputTimes((SampledSet)this.getDataTimeSet(this.dateTimes));
        this.setOutputLocations(tempPros[0]);
        this.setOutputProfiles(tempPros, dewPros, windPros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(DateTime time) throws VisADException, RemoteException {
        if (time == null) {
            throw new NullPointerException();
        }
        boolean notify = false;
        RaobSoundingDataNode raobSoundingDataNode = this;
        synchronized (raobSoundingDataNode) {
            if (!time.equals(this.inTime)) {
                this.inTime = time;
                notify = true;
            }
        }
        int idx = this.getTimeIndex(time);
        if (notify) {
            this.setOutputTimeIndex(idx);
        }
    }

    protected int getTimeIndex(DateTime time) {
        int i = 0;
        for (DateTime dt : this.dateTimes) {
            if (dt.getValue() == time.getValue()) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected Set getDataTimeSet(DateTime[] data) throws RemoteException, VisADException {
        Set aniSet = null;
        ArrayList<DateTime> times = null;
        times = new ArrayList<DateTime>();
        for (DateTime t : data) {
            if (times.contains(t)) continue;
            times.add(t);
        }
        aniSet = Util.makeTimeSet(times);
        return aniSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setOutputLocations(Field data) throws VisADException, RemoteException {
        SampledSet locs = null;
        RaobSoundingDataNode raobSoundingDataNode = this;
        synchronized (raobSoundingDataNode) {
            if (data != null) {
                locs = (SampledSet)data.getDomainSet();
            }
        }
        if (locs != null) {
            this.setOutputLocations(locs);
        }
    }
}

