/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.AerologicalSoundingControl;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.SoundingDataNode;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationWidget;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.IndicatorPoint;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.PickableLineDrawing;
import ucar.visad.functiontypes.AirTemperatureProfile;
import ucar.visad.functiontypes.CartesianHorizontalWindOfPressure;
import ucar.visad.functiontypes.DewPointProfile;
import ucar.visad.functiontypes.InSituAirTemperatureProfile;
import visad.ActionImpl;
import visad.Data;
import visad.DateTime;
import visad.Field;
import visad.FieldImpl;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.georef.LatLonPoint;
import visad.georef.NamedLocationTuple;

public class RaobSoundingControl
extends AerologicalSoundingControl {
    private List stations;
    Hashtable<String, List> stationsTimes;
    Hashtable<String, Set> stationsTimeSet;
    Hashtable<String, Tuple> stationsTuple;
    private static final MathType templateType;
    private Data data;
    private LatLonPoint[] latLons;
    private PickableLineDrawing stationProbes = new PickableLineDrawing("RAOB Points");
    private IndicatorPoint selectedStation = new IndicatorPoint("Selected Station", RealTupleType.LatitudeLongitudeTuple);
    private JComboBox stationMenu;
    private JComboBox stMenu;
    private int selectedStationIndex = -1;
    private DisplayableData timesHolder;
    private Component widget;
    private Container container;
    private SoundingDataNode dataNode;
    String listlabel = null;
    private boolean profilesVisibility = false;

    public RaobSoundingControl() throws VisADException, RemoteException {
        super(true);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        int i;
        if (!super.init()) {
            return false;
        }
        this.setSpatialLoci(this.stationProbes);
        if (!this.setData(dataChoice)) {
            return false;
        }
        Tuple entries = (Tuple)this.getDataInstance().getData();
        int length = entries.getDimension();
        this.stations = new ArrayList();
        LatLonPoint[] slatLons = new LatLonPoint[length];
        Hashtable stationsTuples = new Hashtable();
        this.stationsTuple = new Hashtable();
        this.stationsTimes = new Hashtable();
        this.stationsTimeSet = new Hashtable();
        int j = 0;
        for (i = 0; i < length; ++i) {
            Tuple ob = (Tuple)entries.getComponent(i);
            NamedLocationTuple station = (NamedLocationTuple)ob.getComponent(1);
            String stName = station.getIdentifier().toString();
            if (!this.stations.contains(stName)) {
                this.stations.add(stName);
                slatLons[j++] = station.getLatLonPoint();
            }
            ArrayList<DateTime> timeList = this.stationsTimes.get(stName);
            ArrayList<Tuple> tupleList = (ArrayList<Tuple>)stationsTuples.get(stName);
            if (tupleList == null) {
                tupleList = new ArrayList<Tuple>();
                stationsTuples.put(stName, tupleList);
            }
            if (timeList == null) {
                timeList = new ArrayList<DateTime>();
                this.stationsTimes.put(stName, timeList);
            }
            timeList.add((DateTime)ob.getComponent(0));
            tupleList.add(ob);
        }
        this.latLons = new LatLonPoint[this.stations.size()];
        for (i = 0; i < this.stations.size(); ++i) {
            this.latLons[i] = slatLons[i];
            String st = (String)this.stations.get(i);
            List tuples = (List)stationsTuples.get(st);
            Data[] tpData = tuples.toArray(new Data[tuples.size()]);
            TupleType tupleType = Tuple.buildTupleType(tpData);
            Tuple tp = new Tuple(tupleType, tpData);
            this.stationsTuple.put(st, tp);
            this.stationsTimeSet.put(st, Util.makeTimeSet(this.stationsTimes.get(st)));
        }
        this.stationProbes.setData(Util.indexedField(this.latLons, false));
        this.stationProbes.addAction(new ActionImpl("Station Probe Action"){
            private boolean first;
            {
                this.first = true;
            }

            @Override
            public void doAction() {
                if (this.first) {
                    this.first = false;
                } else {
                    Misc.run(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = RaobSoundingControl.this.stationProbes.getCloseIndex();
                                if (i >= 0 && RaobSoundingControl.this.stMenu != null) {
                                    RaobSoundingControl.this.selectedStation.setPoint((RealTuple)((Object)RaobSoundingControl.this.latLons[i]));
                                    RaobSoundingControl.this.setSelectedStationIndex(i);
                                    RaobSoundingControl.this.stMenu.setSelectedIndex(i);
                                    RaobSoundingControl.this.setStation(i);
                                }
                            }
                            catch (Exception ex) {
                                DisplayControlBase.logException(ex);
                            }
                        }
                    });
                }
            }
        });
        Object[] ids = this.stations.toArray();
        this.stMenu = new JComboBox<Object>(ids);
        this.stMenu.setToolTipText("Stations");
        this.stMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    int i = RaobSoundingControl.this.stMenu.getSelectedIndex();
                    String st = (String)RaobSoundingControl.this.stations.get(i);
                    int index = RaobSoundingControl.this.getSelectedStationIndex();
                    RaobSoundingControl.this.setStation(index);
                    RaobSoundingControl.this.dataNode.setData(RaobSoundingControl.this.stationsTuple.get(st));
                    Set timeset = RaobSoundingControl.this.getDataTimeSet();
                    RaobSoundingControl.this.dataNode.setOutputTimes((SampledSet)timeset);
                    if (RaobSoundingControl.this.getProfilesVisibility()) {
                        RaobSoundingControl.this.setPairProfilesVisibility(true);
                    }
                    RaobSoundingControl.this.updateHeaderLabel();
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        Set times = this.getDataTimeSet();
        RealType timeType = (RealType)((SetType)times.getType()).getDomain().getComponent(0);
        if (this.timesHolder == null) {
            this.timesHolder = new LineDrawing("times ref");
        }
        FieldImpl dummy = new FieldImpl(new FunctionType(timeType, AirTemperatureProfile.instance()), times);
        int n = times.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            dummy.setSample(i2, AirTemperatureProfile.instance().missingData());
        }
        this.timesHolder.setData(dummy);
        Animation animation = this.getInternalAnimation(timeType);
        this.getSoundingView().setExternalAnimation(animation, this.getAnimationWidget());
        this.aeroDisplay.addDisplayable(animation);
        this.aeroDisplay.addDisplayable(this.timesHolder);
        this.container = Box.createHorizontalBox();
        this.container.add(GuiUtils.wrap(this.getAnimationWidget().getContents(false)));
        this.widget = GuiUtils.topBottom(GuiUtils.inset((Component)GuiUtils.label("Station: ", this.stMenu), 8), this.container);
        this.setPointSize();
        String stName = (String)this.stations.get(0);
        this.addDisplayable((Displayable)this.stationProbes, 4);
        this.addDisplayable((Displayable)this.selectedStation, 4);
        if (this.getSelectedStationIndex() >= 0) {
            this.selectedStation.setPoint((RealTuple)((Object)this.latLons[this.getSelectedStationIndex()]));
        }
        this.dataNode = SoundingDataNode.getInstance(new Listener());
        Tuple tp = this.stationsTuple.get(stName);
        this.dataNode.setData(tp);
        this.updateHeaderLabel();
        return true;
    }

    public Set subSetProfilesTimeSet(String st) throws Exception {
        List timeList = this.stationsTimes.get(st);
        int size = timeList.size();
        return Util.makeTimeSet(timeList.subList(0, size - 1));
    }

    public void setPairProfilesVisibility(boolean visible) throws Exception {
        this.profilesVisibility = visible;
        Set s = this.getDataTimeSet();
        int len = s.getLength();
        if (len < 2) {
            return;
        }
        AnimationWidget aniWidget = this.getAnimationWidget();
        aniWidget.gotoIndex(0);
        aniWidget.setRunning(false);
        if (visible) {
            int i = this.stMenu.getSelectedIndex();
            String st = (String)this.stations.get(i);
            Set timeset = this.subSetProfilesTimeSet(st);
            this.dataNode.setOutputTimes((SampledSet)timeset);
        } else {
            Set timeset = this.getDataTimeSet();
            this.dataNode.setOutputTimes((SampledSet)timeset);
        }
        this.aeroDisplay.setProfilesVisibility(visible, 0);
        if (visible) {
            if (s != null) {
                double[][] samples = s.getDoubles();
                DateTime dt = new DateTime(samples[0][1], s.getSetUnits()[0]);
                DateTime dt1 = new DateTime(samples[0][0], s.getSetUnits()[0]);
                this.listlabel = dt1.dateString() + ":" + dt1.timeString() + " and " + dt.dateString() + ":" + dt.timeString();
            }
        } else {
            this.listlabel = null;
        }
        this.updateDisplayList();
    }

    public boolean getProfilesVisibility() {
        return this.profilesVisibility;
    }

    @Override
    protected Data getDisplayListData() {
        Text data = null;
        Data d = super.getDisplayListData();
        TextType tt = TextType.getTextType("Display_List_Text");
        if (this.listlabel != null) {
            try {
                String label = "Skew-T ";
                data = new Text(tt, label + this.listlabel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        return d;
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        super.doRemove();
        this.stations = null;
        this.data = null;
        this.latLons = null;
        this.stationProbes = null;
        this.stationMenu = null;
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            super.timeChanged(time);
            this.dataNode.setTime(new DateTime(time));
            if (this.getProfilesVisibility()) {
                AnimationWidget aniWidget = this.getAnimationWidget();
                int n = aniWidget.getTimes().length;
                int idx = 0;
                for (int i = 0; i < n; ++i) {
                    if (!new DateTime(time).equals(aniWidget.getTimeAtIndex(i))) continue;
                    idx = i;
                }
                this.aeroDisplay.setProfilesVisibility(true, idx);
                Set s = this.getDataTimeSet();
                if (s != null) {
                    double[][] samples = s.getDoubles();
                    DateTime dt = new DateTime(samples[0][idx + 1], s.getSetUnits()[0]);
                    DateTime dt1 = new DateTime(samples[0][idx], s.getSetUnits()[0]);
                    this.listlabel = dt1.dateString() + ":" + dt1.timeString() + " and " + dt.dateString() + ":" + dt.timeString();
                }
                this.updateDisplayList();
            }
        }
        catch (Exception ex) {
            RaobSoundingControl.logException("timeValueChanged", ex);
        }
    }

    public void setSelectedStationIndex(int value) {
        this.selectedStationIndex = value;
    }

    public int getSelectedStationIndex_Old() {
        if (this.stationMenu != null) {
            return this.stationMenu.getSelectedIndex();
        }
        return -1;
    }

    public int getSelectedStationIndex() {
        if (this.selectedStationIndex != -1) {
            return this.selectedStationIndex;
        }
        if (this.stMenu != null) {
            return this.stMenu.getSelectedIndex();
        }
        return 0;
    }

    @Override
    protected String getSpatialLociLabel() {
        return "Stations";
    }

    @Override
    public void setSpatialLociVisible(boolean visible) throws VisADException, RemoteException {
        super.setSpatialLociVisible(visible);
        this.selectedStation.setVisible(this.getDisplayVisibility() && visible);
    }

    @Override
    Component getSpecificWidget() {
        return this.widget;
    }

    private void setStation(int index) throws VisADException, RemoteException {
        this.selectedStation.setPoint((RealTuple)((Object)this.latLons[index]));
        this.setLocation(this.latLons[index]);
        this.getDisplayListData();
        this.getSoundingView().updateDisplayList();
    }

    private Field addPressure(Field windField, Field tempField) throws VisADException, RemoteException {
        return Util.convertDomain(windField, ((FunctionType)tempField.getType()).getDomain(), tempField.getDomainCoordinateSystem());
    }

    private void setPointSize() {
        try {
            this.stationProbes.setPointSize(5.0f);
            this.selectedStation.setPointSize(10.0f);
        }
        catch (Exception exc) {
            RaobSoundingControl.logException("Set point size ", exc);
        }
    }

    @Override
    protected Set getDataTimeSet() throws RemoteException, VisADException {
        Set aniSet = null;
        int index = this.getSelectedStationIndex();
        aniSet = this.stationsTimeSet.get(this.stations.get(index));
        return aniSet;
    }

    @Override
    protected void updateHeaderLabel() {
        int index;
        List times;
        int timeIdx = this.getCurrentIdx();
        if (timeIdx >= (times = this.stationsTimes.get(this.stations.get(index = this.getSelectedStationIndex()))).size()) {
            timeIdx = times.size() - 1;
        }
        String timeStr = ((DateTime)times.get(timeIdx)).toString();
        if (index >= 0) {
            this.headerLabel.setText(this.stations.get(index) + " " + timeStr);
        } else {
            super.updateHeaderLabel();
        }
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList("%station%"));
        labels.addAll(Misc.newList("Station"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        List stations = this.stations;
        int index = this.getSelectedStationIndex();
        if (index >= 0 && stations != null && index < stations.size()) {
            patterns.add("%station%");
            values.add("" + stations.get(index));
        }
    }

    static {
        try {
            templateType = new TupleType(new MathType[]{RealType.Time, RealTupleType.LatitudeLongitudeAltitude, InSituAirTemperatureProfile.instance(), DewPointProfile.instance(), CartesianHorizontalWindOfPressure.instance()});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private class Listener
    implements SoundingDataNode.Listener {
        private Listener() throws VisADException, RemoteException {
        }

        @Override
        public void setTimeIndex(int index, SoundingDataNode source) throws VisADException, RemoteException {
            RaobSoundingControl.this.setSounding(index);
        }

        public int getTimeIndex() throws VisADException, RemoteException {
            return RaobSoundingControl.this.getCurrentIdx();
        }

        @Override
        public void setTimes(SampledSet times, SoundingDataNode source) throws VisADException, RemoteException {
            RealType timeType = (RealType)((SetType)times.getType()).getDomain().getComponent(0);
            if (RaobSoundingControl.this.timesHolder == null) {
                RaobSoundingControl.this.timesHolder = new LineDrawing("times ref");
            }
            FieldImpl dummy = new FieldImpl(new FunctionType(timeType, AirTemperatureProfile.instance()), times);
            int n = times.getLength();
            for (int i = 0; i < n; ++i) {
                dummy.setSample(i, AirTemperatureProfile.instance().missingData());
            }
            RaobSoundingControl.this.timesHolder.setData(dummy);
        }

        @Override
        public void setLocation(LatLonPoint loc, SoundingDataNode source) throws VisADException, RemoteException {
            double lat = loc.getLatitude().getValue();
            RaobSoundingControl.this.aeroDisplay.setBarbOrientation(lat >= 0.0 ? 0 : 1);
        }

        @Override
        public void setLocations(SampledSet locs, SoundingDataNode source) throws VisADException, RemoteException {
        }

        @Override
        public void setProfiles(Field[] tempPros, Field[] dewPros, Field[] windPros, SoundingDataNode source) throws VisADException, RemoteException {
            RaobSoundingControl.this.setSoundings(tempPros, dewPros, windPros);
        }
    }
}

