/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import ucar.unidata.idv.control.CrossSectionControl;
import ucar.unidata.idv.control.DataTransectControl;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.RangeWidget;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Removable;

public class RangeDialog
implements RangeWidget,
Removable {
    private DisplayControlImpl displayControl;
    private final String CMD_RANGE_DEFAULT = "cmd.range.default";
    private final String CMD_RANGE_DATA = "cmd.range.data";
    private final String CMD_RANGE_COLORTABLE = "cmd.range.colortable";
    private JTextField rangeMinField;
    private JTextField rangeMaxField;
    private JButton rangePopupBtn;
    private String dialogTitle;
    private String setRangeMethod;
    private Range range;
    private Component launcher;
    private JDialog dialog;
    private JComponent contents;

    public RangeDialog(DisplayControlImpl displayControl, Range r, String title, String setRangeMethod) {
        this(displayControl, r, title, setRangeMethod, displayControl.getWindow());
    }

    public RangeDialog(DisplayControlImpl displayControl, Range r, String title, String setRangeMethod, Component launcher) {
        this.displayControl = displayControl;
        this.range = r;
        this.dialogTitle = title;
        this.setRangeMethod = setRangeMethod;
        this.launcher = launcher;
        this.doMakeDialog();
    }

    public void doMakeDialog() {
        this.rangePopupBtn = GuiUtils.makeButton("Use Predefined", this, "rangePopup");
        this.rangeMinField = new JTextField(this.format(this.range.getMin()), 6);
        this.rangeMaxField = new JTextField(this.format(this.range.getMax()), 6);
        List comps = Misc.newList(new JLabel("New Range    From: "), this.rangeMinField, new JLabel("To: "), this.rangeMaxField, GuiUtils.inset((Component)this.rangePopupBtn, new Insets(0, 5, 0, 0)));
        this.dialog = new JDialog((Frame)null, this.dialogTitle, true);
        JPanel mainContents = GuiUtils.inset((Component)GuiUtils.hflow(comps), 5);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
                    try {
                        Range newRange = new Range(Misc.parseNumber(RangeDialog.this.rangeMinField.getText()), Misc.parseNumber(RangeDialog.this.rangeMaxField.getText()));
                        RangeDialog.this.handleNewRange(newRange);
                        RangeDialog.this.handleNewRange(newRange);
                    }
                    catch (NumberFormatException pe) {
                        LogUtil.userMessage("Invalid numeric format");
                        return;
                    }
                }
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                    RangeDialog.this.dialog.setVisible(false);
                    RangeDialog.this.dialog.dispose();
                }
            }
        };
        this.rangeMinField.addActionListener(listener);
        this.rangeMaxField.addActionListener(listener);
        this.rangeMinField.setActionCommand(GuiUtils.CMD_OK);
        this.rangeMaxField.setActionCommand(GuiUtils.CMD_OK);
        this.contents = GuiUtils.centerBottom(mainContents, GuiUtils.makeApplyOkCancelButtons(listener));
        this.dialog.getContentPane().add(this.contents);
        this.dialog.pack();
    }

    @Override
    public void doRemove() {
        if (this.contents != null) {
            GuiUtils.empty(this.contents, true);
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.dialog = null;
        this.displayControl = null;
    }

    public void showDialog() {
        GuiUtils.showDialogNearSrc(this.launcher, this.dialog);
    }

    public void setRangeFromPopup(String cmd) {
        Range r = null;
        if (!(this.displayControl instanceof DataTransectControl) && this.displayControl instanceof CrossSectionControl) {
            CrossSectionControl csc = (CrossSectionControl)this.displayControl;
            if (cmd.equals("cmd.range.data")) {
                r = csc.getDataVerticalRange();
                if (r == null) {
                    r = csc.getDefaultVerticalRange();
                }
            } else if (cmd.equals("cmd.range.default")) {
                try {
                    r = csc.getDefaultVerticalRange();
                }
                catch (Exception exception) {}
            }
        } else if (cmd.equals("cmd.range.colortable")) {
            ColorTable originalCT = this.displayControl.getOldColorTableOrInitialColorTable();
            if (originalCT != null) {
                r = originalCT.getRange();
            }
        } else if (cmd.equals("cmd.range.data")) {
            r = this.displayControl.getColorRangeFromData();
        } else if (cmd.equals("cmd.range.default")) {
            try {
                r = this.displayControl.getColorRangeFromData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setRangeDialog(r);
    }

    @Override
    public void setRangeDialog(Range r) {
        if (r != null) {
            this.rangeMinField.setText(this.format(r.getMin()));
            this.rangeMaxField.setText(this.format(r.getMax()));
        }
    }

    public void rangePopup() {
        try {
            Range ctRange = null;
            ColorTable originalCT = this.displayControl.getOldColorTableOrInitialColorTable();
            if (originalCT != null) {
                ctRange = originalCT.getRange();
            }
            ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
            items.add(GuiUtils.makeMenuItem("Default Range", this, "setRangeFromPopup", "cmd.range.default"));
            items.add(GuiUtils.makeMenuItem("From All Data", this, "setRangeFromPopup", "cmd.range.data"));
            if (ctRange != null) {
                items.add(GuiUtils.makeMenuItem("From Color Table", this, "setRangeFromPopup", "cmd.range.colortable"));
            }
            this.displayControl.addToRangeMenu((RangeWidget)this, items);
            JPopupMenu popup = GuiUtils.makePopupMenu(items);
            Dimension d = this.rangePopupBtn.getSize();
            popup.show(this.rangePopupBtn, 0, d.height);
        }
        catch (Exception exc) {
            this.logException("Range popup", exc);
        }
    }

    private String format(double value) {
        return this.displayControl.getDisplayConventions().format(value);
    }

    public void logException(String message, Exception exc) {
        DisplayControlImpl.logException(message, exc);
    }

    private void handleNewRange(Range newRange) {
        if (Misc.equals(this.range, newRange)) {
            return;
        }
        if (this.setRangeMethod != null) {
            try {
                Method theMethod = Misc.findMethod(this.displayControl.getClass(), this.setRangeMethod, new Class[]{newRange.getClass()});
                theMethod.invoke((Object)this.displayControl, newRange);
            }
            catch (Exception exc2) {
                this.logException("propertyChange", exc2);
            }
        }
    }
}

