/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.ui.colortable.ColorTableCanvas;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.visad.UtcDate;
import visad.DateTime;
import visad.Unit;
import visad.VisADException;

public class RangeColorPreview
extends JPanel
implements MouseMotionListener,
MouseListener {
    boolean forMain;
    int legendType;
    DisplayConventions displayConventions;
    private static Font rangeFont;
    private int previewMouseX;
    private boolean mouseInPreview = false;
    JLabel lowerLbl;
    JLabel upperLbl;
    JLabel middleLbl;
    Range range;
    Dimension myPreferredSize;
    private boolean isTime;
    private List<Color> colors;

    public RangeColorPreview(List<Color> colors, DisplayConventions dc) {
        this(colors, dc, 1, false, false);
    }

    public RangeColorPreview(List<Color> colors, DisplayConventions dc, boolean isTime) {
        this(colors, dc, 1, false, isTime);
    }

    public RangeColorPreview(List<Color> colors, DisplayConventions dc, int legendType, boolean forMain) {
        this(colors, dc, 1, forMain, false);
    }

    public RangeColorPreview(List<Color> colors, DisplayConventions dc, int legendType, boolean forMain, boolean isTime) {
        this.colors = colors;
        this.forMain = forMain;
        this.displayConventions = dc;
        this.legendType = legendType;
        this.isTime = isTime;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.lowerLbl = new JLabel(StringUtil.padRight("", 5), 4);
        this.upperLbl = new JLabel(StringUtil.padLeft("", 5), 2);
        this.middleLbl = new JLabel(StringUtil.padRight("", 5), 4);
        Font lblFont = this.lowerLbl.getFont();
        Font monoFont = new Font("Monospaced", lblFont.getStyle(), lblFont.getSize());
        if (this.forSideLegend()) {
            this.lowerLbl.setFont(monoFont);
            this.upperLbl.setFont(monoFont);
            this.middleLbl.setFont(monoFont);
        }
    }

    public Dimension xxxgetMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, 15);
    }

    public void setMyPreferredSize(Dimension size) {
        this.myPreferredSize = size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myPreferredSize != null ? this.myPreferredSize : super.getPreferredSize();
    }

    public JPanel doMakeContents() {
        if (!this.forMain) {
            switch (this.legendType) {
                case 1: {
                    this.setMyPreferredSize(new Dimension(175, 15));
                    this.lowerLbl.setHorizontalAlignment(2);
                    this.upperLbl.setHorizontalAlignment(4);
                    this.middleLbl.setHorizontalAlignment(0);
                    JPanel labels = GuiUtils.leftRight(this.lowerLbl, this.upperLbl);
                    JPanel comp = GuiUtils.doLayout(new Component[]{this, labels}, 1, GuiUtils.WT_Y, GuiUtils.WT_NN);
                    return GuiUtils.left(comp);
                }
            }
            this.setMyPreferredSize(new Dimension(150, 15));
            return GuiUtils.doLayout(new Component[]{this.lowerLbl, this, this.upperLbl}, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
        }
        this.setMyPreferredSize(new Dimension(125, 15));
        this.setMinimumSize(new Dimension(125, 15));
        return GuiUtils.leftCenterRight(this.lowerLbl, GuiUtils.bottom(this), this.upperLbl);
    }

    public Range getRange() {
        return this.range;
    }

    protected boolean forSideLegend() {
        return !this.forMain && this.legendType == 1;
    }

    public void setRange(Range range) {
        this.setRange(range, null);
    }

    public void setRange(Range range, Unit unit) {
        String upper;
        String lower;
        this.range = range;
        String unitString = "";
        if (unit != null) {
            unitString = unit.toString();
            if (this.forSideLegend() && unitString.length() > 12) {
                unitString = unitString.substring(0, 12) + ".";
            }
            unitString = " " + unitString;
        }
        if (range != null) {
            if (!this.isTime) {
                lower = this.displayConventions.format(range.getMin());
                upper = this.forSideLegend() ? this.displayConventions.format(range.getMax()) : this.displayConventions.format(range.getMax()) + unitString;
            } else {
                try {
                    lower = UtcDate.getHHMM(new DateTime(range.getMin()));
                    upper = UtcDate.getHHMM(new DateTime(range.getMax()));
                }
                catch (VisADException ve) {
                    lower = "";
                    upper = "";
                }
            }
        } else {
            lower = "";
            upper = "";
        }
        if (!this.forSideLegend()) {
            this.lowerLbl.setText(StringUtil.padLeft(lower, 5));
            this.upperLbl.setText(StringUtil.padRight(upper, 5));
        } else {
            this.lowerLbl.setText(lower);
            this.middleLbl.setText(unitString);
            this.upperLbl.setText(upper);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        ColorTableCanvas.paintColors(g, this.getBounds(), this.colors, false, false, null);
        if (!this.mouseInPreview) {
            return;
        }
        if (rangeFont == null) {
            rangeFont = g.getFont().deriveFont(10.0f);
        }
        Rectangle bounds = this.getBounds();
        if (bounds.width == 0 || this.getRange() == null) {
            return;
        }
        double percent = (double)this.previewMouseX / (double)bounds.width;
        double value = this.getRange().getValueOfPercent(percent);
        String rangeString = "";
        if (this.isTime) {
            try {
                rangeString = UtcDate.getHHMM(new DateTime(value));
            }
            catch (VisADException ve) {
                rangeString = "";
            }
        }
        if (rangeString.length() == 0) {
            rangeString = this.displayConventions.format(value);
        }
        g.setFont(rangeFont);
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D sBounds = fm.getStringBounds(rangeString, g);
        int width = fm.stringWidth(rangeString);
        g.setColor(Color.lightGray);
        g.fillRect(2, (int)((double)(bounds.y + bounds.height) - sBounds.getHeight()), (int)sBounds.getWidth(), (int)sBounds.getHeight());
        g.drawLine(this.previewMouseX, 0, this.previewMouseX, bounds.height - 2);
        g.setColor(Color.black);
        g.drawString(rangeString, 2, bounds.height - 1);
    }

    public void setColors(List<Color> colors) {
        this.colors = colors;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.previewMouseX = e.getX();
        this.mouseInPreview = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.mouseInPreview = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    public boolean getIsTime() {
        return this.isTime;
    }
}

