/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.display.CrossSectionSelector;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import visad.CommonUnit;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.VisADRay;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;

public class RangeAndBearingControl
extends DisplayControlImpl
implements ActionListener,
PropertyChangeListener,
DisplayableData.DragAdapter {
    public static final int POINT_START = 0;
    public static final int POINT_END = 1;
    public static final String PROP_DECLINATION = "declination";
    public static final String CMD_STATION_START = "station_start";
    public static final String CMD_STATION_END = "station_end";
    public static final String CMD_FLD_START = "cmdfldstart";
    public static final String CMD_FLD_END = "cmdfldend";
    public static final String CMD_PLANET_CHOICE = "cmdplanet";
    public static final String SHARE_RBCLINE = "DisplayControlImpl.SHARE_TRANSECT";
    public static final String SHARE_STATION_START = "share_station_start";
    public static final String SHARE_STATION_END = "share_station_end";
    public static final String SHARE_LOCATION_START = "share_loc_start";
    public static final String SHARE_LOCATION_END = "share_loc_end";
    private CrossSectionSelector csSelector;
    private boolean usingMagneticNorthStart = false;
    private boolean usingMagneticNorthEnd = false;
    private boolean canHaveDeclination = false;
    private double range = 0.0;
    private double bearing = 0.0;
    private double backazimuth = 0.0;
    private Earth planet;
    private NamedStationImpl startStation;
    private NamedStationImpl endStation;
    JComboBox stationStartCB;
    JComboBox stationEndCB;
    JComboBox planetCB;
    JRadioButton useListBtn;
    JRadioButton useFldBtn;
    JTextField rad1Fld;
    JTextField rad2Fld;
    private JLabel rangeLbl;
    private JLabel rangeUnitLbl;
    private JLabel bearingValueLbl;
    private JLabel bearingLbl;
    private JLabel azimuthLbl;
    private JLabel azimuthValueLbl;
    private JTextField startLatFld;
    private JTextField startLonFld;
    private JTextField endLatFld;
    private JTextField endLonFld;
    private float startLat = Float.NaN;
    private float startLon = Float.NaN;
    private float endLat = Float.NaN;
    private float endLon = Float.NaN;
    private boolean acceptEventsFromSelector = true;
    private String stationTableName;
    private List stationList = null;

    public RangeAndBearingControl() {
        this.setAttributeFlags(36);
    }

    public CrossSectionSelector getCrossSectionSelector() {
        return this.csSelector;
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (this.getDisplayUnit() == null) {
            this.setDisplayUnit(this.getDefaultDistanceUnit());
        }
        this.createCrossSectionSelector();
        this.csSelector.setPointSize(this.getDisplayScale());
        this.csSelector.setAutoSize(true);
        this.addDisplayable((Displayable)this.csSelector, 132);
        this.setContents(this.doMakeContents());
        if (Float.isNaN(this.startLat)) {
            this.setLatLonFromSelector();
        } else {
            this.setSelectorPosition();
        }
        this.updateFields();
        this.setRangeAndBearing();
        return true;
    }

    private void setStations() {
        NamedStationTable stationTable = this.stationTableName == null ? this.getControlContext().getResourceManager().getDefaultStations() : this.getControlContext().getResourceManager().findLocations(this.stationTableName);
        if (stationTable == null) {
            this.stationList = new ArrayList();
        } else {
            this.stationList = new ArrayList(stationTable.values());
            this.stationList = new ArrayList(Misc.sort(this.stationList));
        }
        this.canHaveDeclination = false;
        for (int i = 0; i < this.stationList.size(); ++i) {
            NamedStationImpl station = (NamedStationImpl)this.stationList.get(i);
            if (station.getProperties().get(PROP_DECLINATION) == null) continue;
            this.canHaveDeclination = true;
            break;
        }
        RangeAndBearingControl.setStations(this.stationList, this.stationStartCB);
        RangeAndBearingControl.setStations(this.stationList, this.stationEndCB);
    }

    private void updateStationBoxes() {
        if (this.stationStartCB != null) {
            if (this.startStation != null && this.stationList.indexOf(this.startStation) != -1) {
                this.stationStartCB.setSelectedItem(RangeAndBearingControl.createStationTfo(this.startStation));
            } else {
                this.stationStartCB.setSelectedIndex(0);
            }
        }
        if (this.stationEndCB != null) {
            if (this.endStation != null && this.stationList.indexOf(this.endStation) != -1) {
                this.stationEndCB.setSelectedItem(RangeAndBearingControl.createStationTfo(this.endStation));
            } else {
                this.stationEndCB.setSelectedIndex(0);
            }
        }
    }

    private void updateFields() {
        if (this.startLatFld != null) {
            this.startLatFld.setText(this.getDisplayConventions().formatLatLon(this.startLat));
            this.startLonFld.setText(this.getDisplayConventions().formatLatLon(this.startLon));
            this.endLatFld.setText(this.getDisplayConventions().formatLatLon(this.endLat));
            this.endLonFld.setText(this.getDisplayConventions().formatLatLon(this.endLon));
        }
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        ObjectListener listener = new ObjectListener(""){

            @Override
            public void actionPerformed(ActionEvent ae, Object obj) {
                RangeAndBearingControl.this.stationTableName = ((NamedStationTable)obj).getName();
                RangeAndBearingControl.this.clearStations();
                RangeAndBearingControl.this.setStations();
            }
        };
        List stationTables = this.getControlContext().getLocationList();
        items.add(GuiUtils.makeMenu("Set Locations", NamedStationTable.makeMenuItems(stationTables, listener)));
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        if (this.startLatFld != null) {
            this.startLatFld.removeActionListener(this);
            this.startLonFld.removeActionListener(this);
            this.endLatFld.removeActionListener(this);
            this.endLonFld.removeActionListener(this);
        }
        if (this.csSelector != null) {
            this.csSelector.removeStartPropertyChangeListener(this);
            this.csSelector.removeEndPropertyChangeListener(this);
            this.csSelector.removeMidPropertyChangeListener(this);
            this.csSelector = null;
        }
        super.doRemove();
    }

    private JTextField getField(String command) {
        JTextField fld = new JTextField(6);
        fld.addActionListener(this);
        fld.setActionCommand(command);
        return fld;
    }

    private void clearStations() {
        this.startStation = null;
        this.endStation = null;
        this.checkStationWidgets();
        try {
            this.setRangeAndBearing();
        }
        catch (Exception exc) {
            RangeAndBearingControl.logException("setRangeAndBearing", exc);
        }
    }

    private void checkStationWidgets() {
        if (this.stationStartCB != null && this.startStation == null) {
            this.stationStartCB.setSelectedIndex(0);
        }
        if (this.stationEndCB != null && this.endStation == null) {
            this.stationEndCB.setSelectedIndex(0);
        }
    }

    @Override
    public Container doMakeContents() {
        try {
            Font monoFont = Font.decode("monospaced");
            this.rangeUnitLbl = new JLabel(" ");
            this.rangeLbl = new JLabel(" ");
            this.bearingValueLbl = new JLabel("<html>" + StringUtil.repeat("&nbsp;", 18) + "</html>");
            this.azimuthValueLbl = new JLabel("<html>" + StringUtil.repeat("&nbsp;", 18) + "</html>");
            this.rangeLbl.setFont(monoFont);
            this.bearingValueLbl.setFont(monoFont);
            this.azimuthValueLbl.setFont(monoFont);
            this.startLatFld = this.getField(CMD_FLD_START);
            this.startLonFld = this.getField(CMD_FLD_START);
            this.endLatFld = this.getField(CMD_FLD_END);
            this.endLonFld = this.getField(CMD_FLD_END);
            this.stationStartCB = new JComboBox();
            this.stationEndCB = new JComboBox();
            this.stationStartCB.setFont(Font.decode("monospaced"));
            this.stationEndCB.setFont(Font.decode("monospaced"));
            this.setStations();
            this.updateStationBoxes();
            this.stationStartCB.addActionListener(this);
            this.stationStartCB.setActionCommand(CMD_STATION_START);
            this.stationEndCB.addActionListener(this);
            this.stationEndCB.setActionCommand(CMD_STATION_END);
            if (this.planet == null) {
                this.planet = new Earth(6378137.0, 6356752.0, 0.0, "Earth");
            }
            JButton applyBtn = GuiUtils.makeApplyButton(this);
            applyBtn.setMargin(new Insets(0, 0, 0, 0));
            Hashtable<JButton, Integer> fills = new Hashtable<JButton, Integer>();
            fills.put(applyBtn, new Integer(0));
            GuiUtils.setHFill();
            ArrayList<JLabel> list = new ArrayList<JLabel>();
            list.add(GuiUtils.rLabel("   Distance: "));
            list.add(this.rangeLbl);
            list.add(GuiUtils.rLabel("  "));
            list.add(this.rangeUnitLbl);
            this.bearingLbl = GuiUtils.rLabel("  Azimuth: ");
            list.add(this.bearingLbl);
            list.add(this.bearingValueLbl);
            this.azimuthLbl = GuiUtils.rLabel("   Back Azimuth: ");
            list.add(this.azimuthLbl);
            list.add(this.azimuthValueLbl);
            JPanel rangePanel = GuiUtils.hbox(list);
            JPanel startCbPanel = GuiUtils.wrap(this.stationStartCB);
            JPanel endCbPanel = GuiUtils.wrap(this.stationEndCB);
            GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
            JPanel latLonPanel = GuiUtils.doLayout(new JPanel(), new Component[]{GuiUtils.filler(), new JLabel("Latitude"), new JLabel("Longitude"), GuiUtils.filler(), GuiUtils.rLabel("From:"), this.startLatFld, this.startLonFld, startCbPanel, GuiUtils.rLabel("To:"), this.endLatFld, this.endLonFld, endCbPanel, GuiUtils.filler(), applyBtn}, 4, GuiUtils.WT_N, GuiUtils.WT_N, null, fills, null);
            return GuiUtils.top(GuiUtils.topCenterBottom(rangePanel, GuiUtils.left(latLonPanel), this.doMakeWidgetComponent()));
        }
        catch (Exception exc) {
            RangeAndBearingControl.logException("doMakeContents", exc);
            return null;
        }
    }

    private void createCrossSectionSelector() throws VisADException, RemoteException {
        double[] right = this.getNavigatedDisplay().getScreenUpperRight();
        double[] center = this.getNavigatedDisplay().getScreenCenter();
        right[1] = center[1];
        double width = right[0] - center[0];
        RealTuple start = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{center[0], center[1]});
        RealTuple end = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{center[0] + 0.6 * width, right[1]});
        RealTuple[] positions = this.makeDefaultLinePosition(this.getNavigatedDisplay());
        this.csSelector = new CrossSectionSelector(positions[0], positions[1], Color.red);
        this.csSelector.addStartPropertyChangeListener(this);
        this.csSelector.addEndPropertyChangeListener(this);
        this.csSelector.addMidPropertyChangeListener(this);
        this.csSelector.getStartSelectorPoint().setDragAdapter(this);
        this.csSelector.getEndSelectorPoint().setDragAdapter(this);
        this.csSelector.getMiddleSelectorPoint().setDragAdapter(this);
        if (this.inGlobeDisplay()) {
            this.csSelector.setInterpolateLinePoints(true);
        }
    }

    @Override
    protected void addPropertiesComponents(JTabbedPane jtp) {
        super.addPropertiesComponents(jtp);
        Earth[] planets = new Earth[]{new Earth(6378137.0, 6356752.0, 0.0, "Earth"), new Earth(2440000.0, 2440000.0, 0.0, "Mercury"), new Earth(6120000.0, 6120000.0, 0.0, "Venus"), new Earth(3393500.0, 3363200.0, 0.0, "Mars"), new Earth(7.14E7, 6.67733E7, 0.0, "Jupiter"), new Earth(6.033E7, 5.5021E7, 0.0, "Saturn"), new Earth(2.59E7, 2.53302E7, 0.0, "Uranus"), new Earth(2.475E7, 2.42499E7, 0.0, "Neptune")};
        Vector<TwoFacedObject> tfos = new Vector<TwoFacedObject>();
        TwoFacedObject selected = null;
        for (Earth aPlanet : planets) {
            TwoFacedObject tfo = new TwoFacedObject((Object)(aPlanet.getName() + " (" + aPlanet.getEquatorRadius() / 1000.0 + "x" + aPlanet.getPoleRadius() / 1000.0 + ")"), aPlanet);
            tfos.add(tfo);
            if (!Misc.equals(aPlanet, this.planet)) continue;
            selected = tfo;
        }
        this.planetCB = new JComboBox(tfos);
        if (selected != null) {
            this.planetCB.setSelectedItem(selected);
        }
        this.useListBtn = new JRadioButton("Use predefined:", selected != null);
        this.useFldBtn = new JRadioButton("Enter your own value:", selected == null);
        GuiUtils.buttonGroup(this.useListBtn, this.useFldBtn);
        this.rad1Fld = new JTextField(this.planet.getEquatorRadius() / 1000.0 + "", 10);
        this.rad2Fld = new JTextField(this.planet.getPoleRadius() / 1000.0 + "", 10);
        JComponent contents = GuiUtils.formLayout(Misc.newList(this.useListBtn, GuiUtils.left(this.planetCB), this.useFldBtn, GuiUtils.formLayout(new Object[]{GuiUtils.rLabel("Equatorial Radius:"), GuiUtils.left(this.rad1Fld), GuiUtils.rLabel("Polar Radius:"), GuiUtils.left(this.rad2Fld)})));
        contents = GuiUtils.top(contents);
        jtp.add("Planet", contents);
    }

    @Override
    public boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        if (this.planetCB == null) {
            return true;
        }
        TwoFacedObject selected = (TwoFacedObject)this.planetCB.getSelectedItem();
        if (this.useListBtn.isSelected()) {
            this.planet = (Earth)selected.getId();
        } else {
            double plrad1 = 6378.137;
            double plrad2 = 6356.75231;
            try {
                plrad1 = Double.parseDouble(this.rad1Fld.getText().trim());
                plrad2 = Double.parseDouble(this.rad2Fld.getText().trim());
            }
            catch (NumberFormatException plnfe) {
                RangeAndBearingControl.userMessage("Invalid number format");
                return false;
            }
            this.planet = new Earth(1000.0 * plrad1, 1000.0 * plrad2, 0.0);
        }
        this.clearStations();
        return true;
    }

    public RealTuple[] makeDefaultLinePosition(NavigatedDisplay mapDisplay) throws VisADException, RemoteException {
        if (this.inGlobeDisplay()) {
            Point3d p = new Point3d(0.0, 0.0, 1.0);
            NavigatedDisplay navDisplay = this.getNavigatedDisplay();
            navDisplay.applyRotation(p);
            EarthLocation pt = this.boxToEarth(p.x, p.y, p.z, false);
            return new RealTuple[]{this.getRealTupleForPoint((float)pt.getLatitude().getValue(), (float)pt.getLongitude().getValue()), this.getRealTupleForPoint((float)pt.getLatitude().getValue() - 10.0f, (float)pt.getLongitude().getValue())};
        }
        double[] right = mapDisplay.getScreenUpperRight();
        double[] center = mapDisplay.getScreenCenter();
        right[1] = center[1];
        double width = right[0] - center[0];
        EarthLocationTuple el1 = (EarthLocationTuple)mapDisplay.getEarthLocation(center[0], center[1], 0.0, false);
        EarthLocationTuple el2 = (EarthLocationTuple)mapDisplay.getEarthLocation(center[0] + 0.6 * width, right[1], 0.0, false);
        return new RealTuple[]{this.getRealTupleForPoint((float)el1.getLatitude().getValue(), (float)el1.getLongitude().getValue()), this.getRealTupleForPoint((float)el2.getLatitude().getValue(), (float)el2.getLongitude().getValue())};
    }

    @Override
    public boolean constrainDragPoint(float[] position) {
        try {
            double altitude = this.getSelectorAltitude();
            EarthLocation pt = this.boxToEarth(position[0], position[1], position[2], false);
            double[] xyz = this.earthToBox(new EarthLocationTuple(pt.getLatitude().getValue(), pt.getLongitude().getValue(), altitude));
            if (this.inGlobeDisplay()) {
                position[0] = (float)xyz[0];
                position[1] = (float)xyz[1];
                position[2] = (float)xyz[2];
            } else {
                position[2] = (float)xyz[2];
            }
            return true;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public boolean handleDragDirect(VisADRay ray, boolean first, int mouseModifiers) {
        return true;
    }

    @Override
    public boolean handleAddPoint(float[] x) {
        return true;
    }

    @Override
    protected double getInitialZPosition() {
        if (this.inGlobeDisplay()) {
            return 0.0;
        }
        return super.getInitialZPosition();
    }

    @Override
    protected void applyZPosition() throws VisADException, RemoteException {
        this.setSelectorPosition();
    }

    public double getSelectorAltitude() throws VisADException, RemoteException {
        double zPosition = this.getZPosition();
        if (this.inGlobeDisplay()) {
            zPosition = this.getZPosition() + 1.0 + 0.01;
        }
        EarthLocation el = this.boxToEarth(new double[]{0.0, 0.0, zPosition});
        return el.getAltitude().getValue();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.getHaveInitialized()) {
            return;
        }
        if (!this.acceptEventsFromSelector) {
            return;
        }
        String prop = evt.getPropertyName();
        if (prop.equals("SelectorDisplay.startpoint")) {
            this.startStation = null;
        } else if (prop.equals("SelectorDisplay.endpoint")) {
            this.endStation = null;
        } else if (prop.equals("SelectorDisplay.midpoint")) {
            this.startStation = null;
            this.endStation = null;
        } else {
            return;
        }
        this.transectPositionChanged(true);
    }

    public void transectPositionChanged(boolean fromSelector) {
        try {
            if (fromSelector) {
                this.setLatLonFromSelector();
                this.checkStationWidgets();
            }
            CrossSectionSelector cs = this.getCrossSectionSelector();
            this.doShare((Object)SHARE_RBCLINE, new Object[]{cs.getStartPoint(), cs.getEndPoint()});
        }
        catch (Exception exc) {
            RangeAndBearingControl.logException("Error in transectPositionChanged ", exc);
        }
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (dataId.equals(SHARE_RBCLINE)) {
            if (this.csSelector == null) {
                return;
            }
            try {
                this.csSelector.setPosition((RealTuple)data[0], (RealTuple)data[1]);
            }
            catch (Exception e) {
                RangeAndBearingControl.logException("receiveShareData:" + dataId, e);
            }
        } else if (dataId.equals(SHARE_STATION_START)) {
            NamedStationImpl station = (NamedStationImpl)data[0];
            this.stationStartCB.setSelectedItem(RangeAndBearingControl.createStationTfo(station));
            this.updateFields();
        } else if (dataId.equals(SHARE_STATION_END)) {
            NamedStationImpl station = (NamedStationImpl)data[0];
            this.stationEndCB.setSelectedItem(RangeAndBearingControl.createStationTfo(station));
            this.updateFields();
        } else if (!dataId.equals(SHARE_LOCATION_START) && !dataId.equals(SHARE_LOCATION_END)) {
            super.receiveShareData(from, dataId, data);
        }
    }

    private EarthLocationTuple getEarthLocation(double x, double y) throws VisADException, RemoteException {
        return (EarthLocationTuple)this.boxToEarth(new double[]{x, y, 1.0});
    }

    private LatLonPoint getLatLonPoint(double x, double y) throws VisADException, RemoteException {
        return this.getEarthLocation(x, y).getLatLonPoint();
    }

    private LatLonPoint getLatLonPoint(RealTuple rt) throws VisADException, RemoteException {
        if (rt.getType().equals(RealTupleType.SpatialEarth3DTuple)) {
            return new LatLonTuple((Real)rt.getComponent(1), (Real)rt.getComponent(0));
        }
        return this.getEarthLocation(((Real)rt.getComponent(0)).getValue(), ((Real)rt.getComponent(1)).getValue()).getLatLonPoint();
    }

    private void setRangeAndBearing() throws VisADException, RemoteException {
        Bearing result = Bearing.calculateBearing(this.planet, new LatLonPointImpl(this.startLat, this.startLon), new LatLonPointImpl(this.endLat, this.endLon), null);
        this.range = result.getDistance();
        this.bearing = result.getAngle();
        this.backazimuth = result.getBackAzimuth();
        this.usingMagneticNorthStart = false;
        this.usingMagneticNorthEnd = false;
        if (this.startStation != null && this.startStation.getProperties().get(PROP_DECLINATION) != null) {
            this.usingMagneticNorthStart = true;
            this.bearing -= Misc.parseDouble((String)this.startStation.getProperties().get(PROP_DECLINATION));
        }
        if (this.endStation != null && this.endStation.getProperties().get(PROP_DECLINATION) != null) {
            this.usingMagneticNorthEnd = true;
            this.backazimuth -= Misc.parseDouble((String)this.endStation.getProperties().get(PROP_DECLINATION));
        }
        if (this.rangeLbl != null && this.bearingValueLbl != null && this.azimuthValueLbl != null) {
            Unit displayUnit = this.getDisplayUnit();
            this.rangeUnitLbl.setText("" + displayUnit);
            this.range = displayUnit.toThis(1000.0 * this.range, CommonUnit.meter);
            String extra1 = "";
            String extra2 = "";
            if (this.canHaveDeclination) {
                extra1 = this.usingMagneticNorthStart ? "magnetic" : "absolute";
                extra2 = this.usingMagneticNorthEnd ? "magnetic" : "absolute";
                extra1 = "&nbsp;<u><b>" + extra1 + "</b></u>";
                extra2 = "&nbsp;<u><b>" + extra2 + "</b></u>";
            } else {
                extra2 = extra1 = StringUtil.repeat("&nbsp;", 9);
            }
            this.rangeLbl.setText(StringUtil.padLeft(this.getDisplayConventions().formatDistance(this.range), 8));
            this.bearingValueLbl.setText("<html>" + this.padLabel(this.getDisplayConventions().formatAngle(this.bearing)) + extra1 + "</html>");
            this.azimuthValueLbl.setText("<html>" + this.padLabel(this.getDisplayConventions().formatAngle(this.backazimuth)) + extra2 + "</html>");
            this.updateLegendLabel();
        }
    }

    private String padLabel(String l) {
        int diff = 7 - l.length();
        if (diff > 0) {
            l = StringUtil.repeat("&nbsp;", diff) + l;
        }
        return l;
    }

    @Override
    protected boolean setNewDisplayUnit(Unit newUnit, boolean applyToDisplayable) {
        if (!super.setNewDisplayUnit(newUnit, applyToDisplayable)) {
            return false;
        }
        if (newUnit == null) {
            return true;
        }
        try {
            this.setRangeAndBearing();
        }
        catch (Exception exc) {
            RangeAndBearingControl.logException("Setting display unit", exc);
        }
        return true;
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        labels.add("Distance: " + this.getDisplayConventions().formatDistance(this.range) + " " + this.getDisplayUnit());
        String label = "Azimuth: " + this.getDisplayConventions().formatAngle(this.bearing);
        if (this.canHaveDeclination) {
            label = label + " " + (this.usingMagneticNorthStart ? "magnetic" : "absolute");
        }
        labels.add(label);
        label = "Back azimuth: " + this.getDisplayConventions().formatAngle(this.backazimuth);
        if (this.canHaveDeclination) {
            label = label + " " + (this.usingMagneticNorthEnd ? "magnetic" : "absolute");
        }
        labels.add(label);
    }

    private float getLatitude(JTextField f) {
        try {
            float v = (float)Misc.decodeLatLon(f.getText());
            v = Math.max(-90.0f, v);
            return Math.min(90.0f, v);
        }
        catch (NumberFormatException nfe) {
            this.userErrorMessage("Incorrect format:" + f.getText());
            return 0.0f;
        }
    }

    private float getLongitude(JTextField f) {
        try {
            float v = (float)Misc.decodeLatLon(f.getText());
            v = Math.max(-180.0f, v);
            return Math.min(360.0f, v);
        }
        catch (NumberFormatException nfe) {
            this.userErrorMessage("Incorrect format:" + f.getText());
            return 0.0f;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.getOkToFireEvents()) {
            return;
        }
        try {
            String cmd = event.getActionCommand();
            if (cmd.equals(CMD_STATION_START) || cmd.equals(CMD_STATION_END)) {
                NamedStationImpl station = RangeAndBearingControl.getSelectedStation((JComboBox)event.getSource());
                if (station == null) {
                    return;
                }
                if (cmd.equals(CMD_STATION_START)) {
                    this.startStation = station;
                    this.setLatLon(0, (float)station.getLatitude(), (float)station.getLongitude());
                    this.doShare((Object)SHARE_LOCATION_START, new Object[]{this.startStation});
                } else {
                    this.endStation = station;
                    this.setLatLon(1, (float)station.getLatitude(), (float)station.getLongitude());
                    this.doShare((Object)SHARE_LOCATION_END, new Object[]{this.endStation});
                }
                this.updateFields();
                return;
            }
            if (cmd.equals(CMD_FLD_START)) {
                this.setLatLon(0, this.getLatitude(this.startLatFld), this.getLongitude(this.startLonFld));
            } else if (cmd.equals(CMD_FLD_END)) {
                this.setLatLon(1, this.getLatitude(this.endLatFld), this.getLongitude(this.endLonFld));
            } else if (cmd.equals(GuiUtils.CMD_APPLY)) {
                this.setLatLon(0, this.getLatitude(this.startLatFld), this.getLongitude(this.startLonFld), true);
                this.setLatLon(1, this.getLatitude(this.endLatFld), this.getLongitude(this.endLonFld), true);
            } else if (!cmd.equals(CMD_PLANET_CHOICE)) {
                super.actionPerformed(event);
                return;
            }
            this.clearStations();
        }
        catch (Exception exc) {
            RangeAndBearingControl.logException("RadarGridControl.actionPerformed", exc);
        }
    }

    public RealTuple getPointOfSelector(int which) throws VisADException, RemoteException {
        if (which == 0) {
            return this.csSelector != null ? this.csSelector.getStartPoint() : null;
        }
        return this.csSelector != null ? this.csSelector.getEndPoint() : null;
    }

    private void setLatLonFromSelector() throws VisADException, RemoteException {
        this.setLatLon(0, this.getLatLonPoint(this.getPointOfSelector(0)), false);
        this.setLatLon(1, this.getLatLonPoint(this.getPointOfSelector(1)), false);
        this.updateFields();
    }

    private void setLatLon(int which, LatLonPoint llp, boolean updateSelector) throws VisADException, RemoteException {
        this.setLatLon(which, (float)llp.getLatitude().getValue(), (float)llp.getLongitude().getValue(), updateSelector);
    }

    private void setLatLon(int which, float lat, float lon) throws VisADException, RemoteException {
        this.setLatLon(which, lat, lon, true);
    }

    private void setLatLon(int which, float lat, float lon, boolean updateSelector) throws VisADException, RemoteException {
        RealTuple rt;
        if (which == 1) {
            if (this.endLat == lat && this.endLon == lon) {
                return;
            }
            this.endLat = lat;
            this.endLon = lon;
        } else {
            if (this.startLat == lat && this.startLon == lon) {
                return;
            }
            this.startLat = lat;
            this.startLon = lon;
        }
        this.setRangeAndBearing();
        if (updateSelector && (rt = this.getRealTupleForPoint(lat, lon)) != null) {
            this.acceptEventsFromSelector = false;
            this.csSelector.setPoint(which, rt);
            this.transectPositionChanged(false);
            this.acceptEventsFromSelector = true;
        }
    }

    private void setSelectorPosition() throws VisADException, RemoteException {
        this.csSelector.setPosition(this.getRealTupleForPoint(this.startLat, this.startLon), this.getRealTupleForPoint(this.endLat, this.endLon));
    }

    private RealTuple getRealTupleForPoint(float rlat, float rlon) throws VisADException, RemoteException {
        return new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{rlon, rlat, this.getSelectorAltitude()});
    }

    public void setStartLat(float value) {
        this.startLat = value;
    }

    public float getStartLat() {
        return this.startLat;
    }

    public void setStartLon(float value) {
        this.startLon = value;
    }

    public float getStartLon() {
        return this.startLon;
    }

    public void setEndLat(float value) {
        this.endLat = value;
    }

    public float getEndLat() {
        return this.endLat;
    }

    public void setEndLon(float value) {
        this.endLon = value;
    }

    public float getEndLon() {
        return this.endLon;
    }

    public void setStartPoint(RealTuple rt) {
    }

    public void setEndPoint(RealTuple rt) {
    }

    public NamedStationImpl getStartStation() {
        return this.startStation;
    }

    public void setStartStation(NamedStationImpl n) {
        this.startStation = n;
    }

    public NamedStationImpl getEndStation() {
        return this.endStation;
    }

    public void setEndStation(NamedStationImpl n) {
        this.endStation = n;
    }

    public void setStationTableName(String value) {
        this.stationTableName = value;
    }

    public String getStationTableName() {
        return this.stationTableName;
    }

    public void setPlanet(Earth value) {
        this.planet = value;
    }

    public Earth getPlanet() {
        return this.planet;
    }
}

