/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.WindTimeHeightControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import visad.FieldImpl;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;

public class RadarVWPControl
extends WindTimeHeightControl {
    private String stationName;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        boolean result = super.init(dataChoice);
        if (!result) {
            return result;
        }
        EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{0.0, 0.0, -1.0});
        LatLonPoint llp = elt.getLatLonPoint();
        int nameLen = Math.min(3, dataChoice.getName().length());
        this.stationName = dataChoice.getName().substring(0, nameLen);
        if (llp != null) {
            this.latitude = (float)elt.getLatitude().getValue();
            this.longitude = (float)elt.getLongitude().getValue();
        }
        return result;
    }

    @Override
    protected boolean initStation(DataChoice dataChoice) throws VisADException, RemoteException {
        super.initStation(dataChoice);
        Misc.run(new Runnable(){

            @Override
            public void run() {
                RadarVWPControl.this.showWaitCursor();
                try {
                    RadarVWPControl.this.fieldImpl = (FieldImpl)RadarVWPControl.this.getDataInstance().getData();
                    RadarVWPControl.this.haveNewStation = true;
                    if ((double)RadarVWPControl.this.latitude >= 0.0) {
                        RadarVWPControl.this.wbDisplayable.setBarbOrientation(0);
                    } else {
                        RadarVWPControl.this.wbDisplayable.setBarbOrientation(1);
                    }
                    RadarVWPControl.this.setLabel();
                    if (RadarVWPControl.this.wbDisplayable != null) {
                        RadarVWPControl.this.wbDisplayable.loadData(RadarVWPControl.this.fieldImpl);
                    }
                    RadarVWPControl.this.setXAxisValues(RadarVWPControl.this.fieldImpl.getDomainSet());
                }
                catch (Exception excp) {
                    DisplayControlBase.logException(" load wind vectors ", excp);
                }
                RadarVWPControl.this.showNormalCursor();
                RadarVWPControl.this.haveNewStation = false;
            }
        });
        return true;
    }

    @Override
    protected Hashtable getRequestProperties() {
        Hashtable props = super.getRequestProperties();
        props.put("Level2RadarDataSource.VWP", new Float(0.0));
        return props;
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        JCheckBox toggle = new JCheckBox("", this.isLatestOnLeft);
        toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RadarVWPControl.this.isLatestOnLeft = ((JCheckBox)e.getSource()).isSelected();
                try {
                    RadarVWPControl.this.setXAxisValues();
                }
                catch (VisADException ve) {
                    DisplayControlBase.userMessage("Couldn't set order");
                }
            }
        });
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Latest data on left: "), GuiUtils.leftCenter(toggle, GuiUtils.filler())));
    }

    @Override
    protected void setLabel() {
        if (this.plotLabel != null) {
            this.plotLabel.setText(this.stationName + "  Lat " + this.latitude + "  Long " + this.longitude);
        }
    }

    @Override
    protected String getTitle() {
        return this.stationName + " VAD Wind Profile";
    }
}

