/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.radar.CDMRadarDataSource;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.idv.control.ColorPlanViewControl;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.util.GuiUtils;
import ucar.visad.RadarMapProjection;
import visad.FlatField;
import visad.Gridded2DSet;
import visad.Real;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.georef.EarthLocation;
import visad.georef.LatLonPoint;

public class RadarSweepControl
extends ColorPlanViewControl {
    public static final String SHARE_ANGLE = "RadarSweepControl.SHARE_ANGLE";
    private JLabel stationLabel = new JLabel("   ");
    private double currentAngle = -1.0;
    private boolean use3D = true;

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        Hashtable props = choice.getProperties();
        if (!super.setData(choice)) {
            return false;
        }
        NamedStation ns = null;
        if (props != null) {
            ns = (NamedStation)props.get("station location");
        }
        int shortNameLen = Math.min(3, choice.getName().length());
        String shortName = choice.getName().substring(0, shortNameLen);
        if (ns != null) {
            this.stationLabel.setText(ns.getIdentifier() + " " + this.getDisplayConventions().formatEarthLocation(ns.getNamedLocation(), true));
        } else {
            this.stationLabel.setText(shortName);
        }
        this.updateLegendAndList();
        return true;
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (this.use3D && !this.isDisplay3D()) {
            RadarSweepControl.userMessage("Can't display 3D sweep in 2D display");
            return false;
        }
        if (dataChoice.getName().startsWith("ucar.unidata.util")) {
            dataChoice.setName(dataChoice.getDescription());
        }
        return super.init(dataChoice);
    }

    @Override
    protected Hashtable getRequestProperties() {
        Hashtable props = super.getRequestProperties();
        props.put("Level2RadarDataSource.2Dor3D", this.use3D ? "Level2RadarDataSource.3D" : "Level2RadarDataSource.2D");
        props.put("Level2RadarDataSource.volumeorsweep", "Level2RadarDataSource.sweep");
        return props;
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Station:"), this.stationLabel));
    }

    private void applyNewAngle(double newAngle) {
        if (newAngle != this.currentAngle) {
            this.currentAngle = newAngle;
            this.getRequestProperties().put("Level2RadarDataSource.angle", new Double(this.currentAngle));
            this.updateLegendAndList();
            try {
                this.resetData();
                this.doShare((Object)SHARE_ANGLE, new Double(this.currentAngle));
            }
            catch (Exception exc) {
                RadarSweepControl.logException("Getting new angle", exc);
            }
        }
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (!this.getHaveInitialized()) {
            return;
        }
        if (dataId.equals(SHARE_ANGLE)) {
            try {
                this.applyNewAngle((Double)data[0]);
            }
            catch (Exception exc) {
                RadarSweepControl.logException("receiveShareData.angle", exc);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    @Override
    protected boolean shouldUseZPosition() {
        return !this.use3D;
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        if (this.currentAngle >= 0.0) {
            labels.add((this.use3D ? "3D" : "2D") + " sweep, elev " + this.getDisplayConventions().formatAngle(this.currentAngle));
        } else {
            labels.add((this.use3D ? "3D" : "2D") + " sweep");
        }
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        if (this.currentLevel == null) {
            List levelsList;
            this.currentLevel = this.getDataSelection().getFromLevel();
            if (this.currentLevel == null && (levelsList = dataChoice.getAllLevels(this.getDataSelection())) != null && levelsList.size() > 0) {
                this.currentLevel = levelsList.get(0);
            }
        }
        this.getDataSelection().setLevel(this.currentLevel);
        return super.doMakeDataInstance(dataChoice);
    }

    @Override
    protected boolean shouldShowZSelector() {
        return false;
    }

    public void setUse3D(boolean value) {
        this.use3D = value;
    }

    public boolean getUse3D() {
        return this.use3D;
    }

    public void setCurrentAngle(double value) {
        this.currentAngle = value;
    }

    private double getCurrentAngle() {
        return this.currentAngle;
    }

    @Override
    public boolean getAllowSmoothing() {
        return false;
    }

    @Override
    public String getLevelsLabel() {
        return "Elevation Angles:";
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Radar Projection";
    }

    protected List getCursorReadoutInner11(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        if (this.currentSlice == null) {
            return null;
        }
        RadarMapProjection rp = (RadarMapProjection)this.getDataProjection();
        LatLonPoint radarLocation = rp.getCenterLatLon();
        FlatField d = (FlatField)this.currentSlice.getSample(0);
        Gridded2DSet ds = (Gridded2DSet)d.getDomainSet();
        Radar2DCoordinateSystem rcoord = (Radar2DCoordinateSystem)d.getDomainCoordinateSystem();
        float[] center = rcoord.getCenterPoint();
        float[] values = d.getFloats()[0];
        float lat1 = (float)el.getLatitude().getValue();
        float lon1 = (float)el.getLongitude().getValue();
        Bearing b1 = this.getBearing(radarLocation, lat1, lon1);
        double azimuth1 = b1.getAngle();
        double range1 = b1.getDistance();
        double[][] pvalues = new double[2][1];
        pvalues[0][0] = range1;
        pvalues[1][0] = azimuth1;
        int[] pidx = ds.doubleToIndex(pvalues);
        this.currentSlice.getSample(0);
        ArrayList<String> result = new ArrayList<String>();
        Real r = GridUtil.sampleToReal(this.currentSlice, el, animationValue, this.getSamplingModeValue(this.getObjectStore().get("DisplayControlImpl.SamplingMode", DEFAULT_SAMPLING_MODE)));
        if (r != null) {
            ReadoutInfo readoutInfo = new ReadoutInfo(this, r, el, animationValue);
            readoutInfo.setUnit(this.getDisplayUnit());
            readoutInfo.setRange(this.getRange());
            samples.add(readoutInfo);
        }
        if (r != null && !r.isMissing()) {
            result.add("<tr><td>" + this.getMenuLabel() + ":</td><td  align=\"right\">" + this.formatForCursorReadout(r) + (this.currentLevel != null ? "@" + this.currentLevel : "") + "</td></tr>");
        }
        return result;
    }

    public Bearing getBearing(LatLonPoint radarLocation, double lat, double lon) {
        Bearing b1 = Bearing.calculateBearing(radarLocation.getLatitude().getValue(), radarLocation.getLongitude().getValue(), lat, lon, null);
        return b1;
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return false;
    }

    @Override
    public void doExport(String what, String filename) throws Exception {
        if (what.contains("netcdf")) {
            List sources = this.getDataSources();
            CDMRadarDataSource cdmRadar = (CDMRadarDataSource)sources.get(0);
            String fileIn = cdmRadar.getDataPaths().toString();
            NetcdfFile ncfileIn = NetcdfDataset.openFile(fileIn, null);
            NetcdfFileWriter.Version version = NetcdfFileWriter.Version.netcdf3;
            NetcdfFileWriter ncOut = NetcdfFileWriter.createNew(version, filename);
            ncfileIn.close();
        }
    }
}

