/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.ColorCrossSectionControl;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Range;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.display.CrossSectionSelector;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import ucar.visad.display.XSDisplay;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Length;
import visad.AxisScale;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar3DCoordinateSystem;
import visad.georef.EarthLocation;

public class RadarRhiControl
extends ColorCrossSectionControl {
    public static final String SHARE_ANGLE = "RadarRhiControl.SHARE_ANGLE";
    protected float currentAngle = Float.NaN;
    private float lastLoadedAz = Float.NaN;
    protected JLabel stationLabel = new JLabel("   ");
    private EarthLocation centerPoint;
    private double defaultLen = 1.0;
    private double currentCSLineLen = 0.2;
    JComboBox azimuthSelector;
    private int timestamp = 0;
    private double R = 6371.01;
    private boolean use3D = true;
    protected Object currentLevel;
    private Container viewContents;

    public RadarRhiControl() {
        this.setAttributeFlags(60);
    }

    @Override
    protected boolean useZPosition() {
        return false;
    }

    @Override
    public void initDone() {
        try {
            this.setRequestProperties();
            this.getCrossSectionViewManager().setNewDisplayTitle("RHI  Azimuth: " + this.getDisplayConventions().formatAngle(this.currentAngle));
            if (this.getVerticalAxisRange() == null) {
                this.setVerticalAxisRange(new Range(0.0, 20000.0));
            }
            this.updateAxisLabels();
            this.loadDataFromLine();
            FieldImpl fieldImpl = (FieldImpl)this.getGridDataInstance().getGrid().getSample(0);
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(fieldImpl);
            Unit xUnit = domainSet.getSetUnits()[0];
            String unitlabel = xUnit.toString();
            if (unitlabel.equalsIgnoreCase("1000.0 m")) {
                unitlabel = "km";
            }
            this.csSelector.clearDisplayables();
        }
        catch (Exception e) {
            RadarRhiControl.logException("Initializing the csSelector", e);
        }
    }

    private void updateAxisLabels() {
        try {
            XSDisplay xsDisplay = this.crossSectionView.getXSDisplay();
            AxisScale yScale = xsDisplay.getYAxisScale();
            yScale.setMajorTickSpacing((int)(this.getVerticalAxisRange().getMax() / 5.0));
            yScale.setMinorTickSpacing(yScale.getMajorTickSpacing() / 5.0);
            yScale.setTitle("Altitude MSL (m)");
            yScale.setSnapToBox(true);
            yScale.createStandardLabels(this.getVerticalAxisRange().getMax(), 0.0, 0.0, yScale.getMajorTickSpacing());
            yScale.setGridLinesVisible(true);
            xsDisplay.setXRange(0.0, 400.0);
            AxisScale xScale = xsDisplay.getXAxisScale();
            xScale.setMajorTickSpacing(100.0);
            xScale.setMinorTickSpacing(50.0);
            xScale.setSnapToBox(true);
            xScale.createStandardLabels(400.0, 0.0, 0.0, 100.0);
            xScale.setSnapToBox(true);
            xScale.setGridLinesVisible(true);
        }
        catch (Exception e) {
            RadarRhiControl.logException("updating axis labels", e);
        }
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        List levelsList;
        this.currentLevel = this.getDataSelection().getFromLevel();
        if (this.currentLevel == null && (levelsList = choice.getAllLevels(this.getDataSelection())) != null && levelsList.size() > 0) {
            this.currentLevel = levelsList.get(0);
        }
        Real c = (Real)this.currentLevel;
        this.currentAngle = (float)c.getValue();
        this.getDataSelection().setLevel(this.currentLevel);
        DataSelection tmpSelection = new DataSelection(this.getDataSelection());
        tmpSelection.setFromLevel(null);
        tmpSelection.setToLevel(null);
        List levelsList1 = choice.getAllLevels(tmpSelection);
        ArrayList<TwoFacedObject> levels = new ArrayList<TwoFacedObject>();
        if (levelsList1.size() >= 1) {
            for (int i = 0; i < levelsList1.size(); ++i) {
                String azim = levelsList1.get(i).toString();
                String as = this.getDisplayConventions().formatAngle(Float.parseFloat(azim));
                TwoFacedObject tobj = new TwoFacedObject((Object)as, azim);
                levels.add(tobj);
            }
        }
        this.setRequestProperties();
        if (!super.setData(choice)) {
            return false;
        }
        this.azimuthSelector = new JComboBox();
        GuiUtils.setListData(this.azimuthSelector, levels);
        this.azimuthSelector.setSelectedItem(this.currentLevel);
        this.azimuthSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (RadarRhiControl.this.azimuthSelector.getSelectedItem() == null) {
                        return;
                    }
                    String azim = TwoFacedObject.getIdString(RadarRhiControl.this.azimuthSelector.getSelectedItem());
                    RadarRhiControl.this.currentAngle = Float.parseFloat(azim);
                    RadarRhiControl.this.setRequestProperties();
                    RadarRhiControl.this.crossSectionChanged();
                }
                catch (Exception ve) {
                    DisplayControlBase.logException(" change azimath ", ve);
                }
            }
        });
        return true;
    }

    @Override
    protected String getCrossSectionViewLabel() {
        return "RHISWEEP";
    }

    public void setUse3D(boolean value) {
        this.use3D = value;
    }

    public boolean getUse3D() {
        return this.use3D;
    }

    @Override
    public void crossSectionChanged() {
        try {
            this.setRequestProperties();
            this.loadDataFromLine();
            List choices = this.getDataChoices();
            if (this.getCrossSectionViewManager() != null) {
                this.getCrossSectionViewManager().setNewDisplayTitle(((DataChoice)choices.get(0)).getName() + " Azimuth " + this.getDisplayConventions().formatAngle(this.currentAngle));
                this.updateLegendLabel();
            }
            this.doShare((Object)"DisplayControlImpl.SHARE_TRANSECT", this);
        }
        catch (Exception exc) {
            RadarRhiControl.logException("crossSectionChanged", exc);
        }
    }

    protected void centerLinePosition() throws VisADException, RemoteException {
        List choices = this.getDataChoices();
        this.getCrossSectionViewManager().setNewDisplayTitle(((DataChoice)choices.get(0)).getName() + " Azimuth " + this.getDisplayConventions().formatAngle(this.currentAngle));
    }

    @Override
    protected DisplayableData createXSDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable display = new Grid2DDisplayable("vcs_col" + this.paramName, true);
        display.setTextureEnable(true);
        this.addAttributedDisplayable(display, 8);
        return display;
    }

    @Override
    protected DisplayableData createVCSDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable display = new Grid2DDisplayable("vcs_" + this.paramName, true);
        display.setTextureEnable(true);
        this.addAttributedDisplayable(display, 8);
        return display;
    }

    @Override
    public String getColorWidgetLabel() {
        return "Selector Line Color";
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Azimuth:"), GuiUtils.left(this.azimuthSelector)));
    }

    @Override
    protected JComponent getDisplayTabComponent() {
        this.viewContents = this.crossSectionView.getContents();
        this.crossSectionView.setContentsBorder(null);
        return GuiUtils.centerBottom(this.viewContents, GuiUtils.left(GuiUtils.label("Station: ", this.stationLabel)));
    }

    public void setCurrentAngle(float az) {
        this.currentAngle = az;
    }

    public void getCurrentAngle(float az) {
        this.currentAngle = az;
    }

    public float getBeamAzimuth() {
        return this.currentAngle;
    }

    @Override
    protected void createCrossSectionSelector() throws VisADException, RemoteException {
        this.csSelector = new CrossSectionSelector();
        this.csSelector.setVisible(false);
    }

    private boolean setCSLineLength(double len) {
        return true;
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (!this.getHaveInitialized()) {
            return;
        }
        if (dataId.equals(SHARE_ANGLE)) {
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        labels.add("Azimuth: " + this.getDisplayConventions().formatAngle(this.currentAngle));
    }

    @Override
    protected void updateLegendLabel() {
        super.updateLegendLabel();
        this.getCrossSectionViewManager().setNewDisplayTitle(((DataChoice)this.getDataChoices().get(0)).getName() + " Azimuth " + this.getDisplayConventions().formatAngle(this.currentAngle));
    }

    @Override
    protected void loadDataFromLine() throws VisADException, RemoteException {
        if (!this.getHaveInitialized() || this.lastLoadedAz == this.currentAngle) {
            return;
        }
        this.getRequestProperties().put("Level2RadarDataSource.azimuth", new Double(this.currentAngle));
        this.getGridDataInstance().reInitialize();
        FieldImpl grid = this.getGridDataInstance().getGrid();
        if (grid == null) {
            return;
        }
        this.loadData(grid);
        this.lastLoadedAz = this.currentAngle;
    }

    @Override
    protected Hashtable getRequestProperties() {
        Hashtable props = super.getRequestProperties();
        props.put("Level2RadarDataSource.azimuth", new Double(this.currentAngle));
        return props;
    }

    protected void setRequestProperties() {
        this.getRequestProperties().put("Level2RadarDataSource.azimuth", new Double(this.currentAngle));
    }

    @Override
    protected FieldImpl make2DData(FieldImpl inputfieldImpl) throws VisADException, RemoteException {
        FieldImpl fi = null;
        boolean istimeSequence = GridUtil.isTimeSequence(inputfieldImpl);
        if (istimeSequence) {
            Set timeSet = inputfieldImpl.getDomainSet();
            int numTimes = timeSet.getLength();
            RealTupleType timeType = ((FunctionType)inputfieldImpl.getType()).getDomain();
            for (int ti = 0; ti < numTimes; ++ti) {
                FieldImpl one3DFI = (FieldImpl)inputfieldImpl.getSample(ti);
                FieldImpl one2DFI = this.make2DDataAtOneTime(one3DFI);
                if (ti == 0) {
                    FunctionType fiFunction = new FunctionType(timeType, (FunctionType)one2DFI.getType());
                    fi = new FieldImpl(fiFunction, timeSet);
                }
                if (one2DFI == null) continue;
                fi.setSample(ti, (Data)one2DFI, false);
            }
        } else {
            fi = this.make2DDataAtOneTime(inputfieldImpl);
        }
        return fi;
    }

    private FieldImpl make2DDataAtOneTime(FieldImpl inputfieldImpl) throws VisADException, RemoteException {
        FieldImpl fi = null;
        Object testff = null;
        Set indexSet = null;
        int numBeams = 1;
        if (inputfieldImpl.getDomainDimension() == 1) {
            indexSet = inputfieldImpl.getDomainSet();
            numBeams = indexSet.getLength();
        }
        for (int bi = 0; bi < numBeams; ++bi) {
            FieldImpl fieldImpl = (FieldImpl)inputfieldImpl.getSample(bi);
            if (fieldImpl.isMissing()) continue;
            float[][] signalVals = fieldImpl.getFloats(false);
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(fieldImpl);
            Radar3DCoordinateSystem transform = (Radar3DCoordinateSystem)domainSet.getCoordinateSystem();
            float stationElev = transform.getCenterPoint()[2];
            float[][] domainSamples = domainSet.getSamples(false);
            float[] ranges = domainSamples[0];
            float[] azimuths = domainSamples[1];
            float[] elevs = domainSamples[2];
            float[][] plane = new float[2][domainSet.getLength()];
            for (int i = 0; i < plane[0].length; ++i) {
                float dx;
                double range = ranges[i] / 1000.0f;
                double elevation = Math.toRadians(elevs[i]);
                plane[0][i] = dx = (float)(range * Math.cos(elevation));
                plane[1][i] = 1000.0f * (float)(range * Math.sin(elevation)) + stationElev + 1000.0f * (float)((double)(dx * dx) / 12742.0);
            }
            RealType xType = null;
            if (this.crossSectionView != null) {
                XSDisplay xs = this.crossSectionView.getXSDisplay();
                xType = xs.getXAxisType();
            } else {
                xType = Length.getRealType();
            }
            RealTupleType xzRTT = new RealTupleType(xType, RealType.Altitude);
            int sizeX = domainSet.getLengths()[0];
            int sizeZ = domainSet.getLengths()[1];
            Unit zUnit = transform == null ? domainSet.getSetUnits()[2] : transform.getReferenceUnits()[2];
            Gridded2DSet oneBeamG2DS = new Gridded2DSet(xzRTT, plane, sizeX, sizeZ, null, new Unit[]{CommonUnits.KILOMETER, zUnit}, null, false);
            RealTupleType oneBeamMT = (RealTupleType)this.getGridDataInstance().getRangeType();
            FunctionType oneBeamFT = new FunctionType(xzRTT, oneBeamMT);
            FlatField oneBeamFF = new FlatField(oneBeamFT, oneBeamG2DS);
            oneBeamFF.setSamples(signalVals, false);
            if (bi == 0) {
                RealType indexType = RealType.getRealType("integer_index");
                FunctionType fiFunction = new FunctionType(indexType, oneBeamFF.getType());
                Integer1DSet intSet = new Integer1DSet(numBeams);
                fi = new FieldImpl(fiFunction, intSet);
                fi.setSample(bi, (Data)oneBeamFF, false);
                continue;
            }
            fi.setSample(bi, (Data)oneBeamFF, false);
        }
        return fi;
    }

    @Override
    public boolean getAllowSmoothing() {
        return false;
    }

    @Override
    public boolean getAllowAutoScale() {
        return false;
    }

    @Override
    public boolean getAutoScaleYAxis() {
        return false;
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Radar Projection";
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return false;
    }
}

