/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.metdata.Station;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.visad.display.RadarGrid;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.DisplayEvent;
import visad.FieldImpl;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;
import visad.georef.MapProjection;

public class RadarGridControl
extends DisplayControlImpl
implements ActionListener {
    static final String CMD_RR_SPACING = "rrspacing";
    static final String CMD_LBL_SPACING = "lblspacing";
    static final String CMD_RAD_SPACING = "radspacing";
    static final String CMD_RR_COLOR = "rrcolor";
    static final String CMD_LBL_COLOR = "lblcolor";
    static final String CMD_RAD_COLOR = "radcolor";
    static final String CMD_RR_WIDTH = "rrwidth";
    static final String CMD_LBL_WIDTH = "lblwidth";
    static final String CMD_RAD_WIDTH = "radwidth";
    static final String CMD_RR_VIS = "rrvis";
    static final String CMD_LBL_VIS = "lblvis";
    static final String CMD_RAD_VIS = "radvis";
    static final String CMD_RR_RADIUS = "rrmaximumradius";
    static final String CMD_STATIONNAMES = "stationnames";
    static final String CMD_CENTER_LON = "center_lon";
    static final String CMD_CENTER_LAT = "center_lat";
    private static final String CMD_RAD_UNIT = "rad_unit";
    private static final String CMD_LBL_UNIT = "label_unit";
    private static final String CMD_RR_UNIT = "rr_unit";
    private static final String CMD_RRMAX_UNIT = "rrmax_unit";
    private Font labelFont;
    private RadarGrid rangeRings;
    private JCheckBox positionAtClickCbx;
    private Color radColor = Color.gray;
    private Color rrColor = Color.gray;
    private List<JLabel> distanceUnitLabels;
    private Color lblColor = Color.gray;
    static final Vector rrSpacingList = Misc.toVector(new String[]{"1", "2", "5", "10", "15", "20", "25", "50", "100"});
    static final Vector lblSpacingList = Misc.toVector(new String[]{"1", "2", "5", "10", "15", "20", "25", "50", "100", "200"});
    static final Vector radSpacingList = Misc.toVector(new String[]{"5", "10", "15", "30", "45", "60", "90"});
    static final Vector rrMaxRadiusList = Misc.toVector(new String[]{"100", "200", "250", "300", "400", "500"});
    private static final Vector distanceUnits = Misc.toVector(new Unit[]{CommonUnits.KILOMETER, CommonUnits.MILE, CommonUnits.NAUTICAL_MILE});
    private static final Vector radialUnits = Misc.toVector(new Unit[]{CommonUnit.degree, CommonUnit.radian});
    private String stationTableName;
    private double rrSpacing = 50.0;
    private double lblSpacing = 100.0;
    private double radSpacing = 30.0;
    private double rrMaxRadius = 300.0;
    private boolean rrVisible = true;
    private boolean lblVisible = true;
    private boolean radVisible = true;
    private int rrWidth = 1;
    private int lblWidth = 1;
    private int radWidth = 1;
    private Unit rrUnit = CommonUnits.KILOMETER;
    private Unit rrMaxUnit = CommonUnits.KILOMETER;
    private Unit lblUnit = CommonUnits.KILOMETER;
    private Unit radUnit = CommonUnit.degree;
    private double lat = Double.NaN;
    private double lon = Double.NaN;
    private JLabel positionLabel;
    private JTextField latField;
    private JTextField lonField;
    private List stationList;
    private JComboBox stationCbx = null;
    private int stationIdx = 0;
    private String initStationLocation;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        super.init(dataChoice);
        LatLonPoint llp = new LatLonTuple(0.0, 0.0);
        llp = this.findCenterPoint(dataChoice);
        if (this.getDisplayUnit() == null) {
            this.setDisplayUnit(this.getDefaultDistanceUnit());
        }
        this.rangeRings = new RadarGrid(llp, this.rrColor, this.getDisplayUnit());
        if (this.labelFont != null) {
            this.rangeRings.setFont(this.labelFont);
        }
        this.rangeRings.setVisible(this.getDisplayVisibility());
        this.rangeRings.setAzimuthLineColor(this.radColor);
        this.rangeRings.setRangeRingColor(this.rrColor);
        this.rangeRings.setLabelColor(this.lblColor);
        this.rangeRings.setRangeRingSpacing(this.rrSpacing, this.rrMaxRadius);
        this.rangeRings.setRadialInterval(this.radSpacing);
        this.rangeRings.setLabelSpacing(this.lblSpacing);
        this.rangeRings.setMaxRadius(this.rrMaxRadius);
        this.rangeRings.setLabelSize(this.getDisplayScale());
        this.rangeRings.setLabelLineWidth(this.lblWidth);
        this.rangeRings.setRangeRingLineWidth(this.rrWidth);
        this.rangeRings.setRadialLineWidth(this.radWidth);
        this.addDisplayable(this.rangeRings);
        this.addAttributedDisplayable(this.rangeRings, 128);
        this.applyVisibilityFlags();
        if (llp != null && this.positionLabel != null) {
            this.positionLabel.setText(llp.toString());
        }
        if (this.initStationLocation != null) {
            NamedStationTable stationTable = this.setStations();
            Station station = stationTable.get(this.initStationLocation);
            if (station != null) {
                this.setLatLon(station.getLatitude(), station.getLongitude(), false);
            } else {
                System.err.println("RangeRings: Could not find station:" + this.initStationLocation);
            }
        }
        return true;
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        this.rangeRings = null;
        super.doRemove();
    }

    private NamedStationTable setStations() {
        NamedStationTable stationTable = this.stationTableName == null ? this.getControlContext().getResourceManager().findLocations("NEXRAD Sites") : this.getControlContext().getResourceManager().findLocations(this.stationTableName);
        this.stationList = stationTable == null ? new ArrayList() : new ArrayList(Misc.sort(new ArrayList(stationTable.values())));
        if (this.stationCbx != null) {
            RadarGridControl.setStations(this.stationList, this.stationCbx);
            this.stationCbx.setSelectedIndex(this.stationIdx);
        }
        return stationTable;
    }

    protected boolean setData(LatLonPoint llp) throws VisADException, RemoteException {
        this.rangeRings.setCenterPoint(llp);
        if (this.positionLabel != null) {
            this.positionLabel.setText(llp.toString());
        }
        return true;
    }

    public RadarGrid getRadarGrid() {
        return this.rangeRings;
    }

    JComponent makeColorBox(final String cmd, Color color) {
        GuiUtils.ColorSwatch swatch = new GuiUtils.ColorSwatch(color, "Set Color"){

            @Override
            public void userSelectedNewColor(Color c) {
                super.userSelectedNewColor(c);
                try {
                    if (cmd.equals(RadarGridControl.CMD_RAD_COLOR)) {
                        RadarGridControl.this.rangeRings.setAzimuthLineColor(RadarGridControl.this.radColor = c);
                    } else if (cmd.equals(RadarGridControl.CMD_RR_COLOR)) {
                        RadarGridControl.this.rangeRings.setRangeRingColor(RadarGridControl.this.rrColor = c);
                    } else if (cmd.equals(RadarGridControl.CMD_LBL_COLOR)) {
                        RadarGridControl.this.rangeRings.setLabelColor(RadarGridControl.this.lblColor = c);
                    }
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("setting color", exc);
                }
            }
        };
        return swatch;
    }

    private JComboBox makeLineWidthBox(String cmd, int width) {
        JComboBox jcb = GuiUtils.createValueBox(this, cmd, width, Misc.createIntervalList(1, 10, 1), false);
        return jcb;
    }

    private JComboBox makeUnitBox(Vector units, String cmd, Unit selected) {
        if (!units.contains(selected)) {
            units.add(selected);
        }
        JComboBox jcb = new JComboBox(units);
        jcb.setSelectedItem(selected);
        jcb.setEditable(false);
        jcb.addActionListener(this);
        jcb.setActionCommand(cmd);
        return jcb;
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        ObjectListener listener = new ObjectListener(""){

            @Override
            public void actionPerformed(ActionEvent ae, Object obj) {
                RadarGridControl.this.stationTableName = ((NamedStationTable)obj).getFullName();
                RadarGridControl.this.stationIdx = 0;
                RadarGridControl.this.setStations();
            }
        };
        List stationTables = this.getControlContext().getLocationList();
        items.add(GuiUtils.makeMenu("Set Locations", NamedStationTable.makeMenuItems(stationTables, listener)));
        super.getEditMenuItems(items, forMenuBar);
    }

    JComponent makeSpacingBox(Vector spacings, String command, double selected) {
        String value = selected == (double)((int)selected) ? "" + (int)selected : "" + selected;
        if (!spacings.contains(value)) {
            spacings.add(value);
        }
        JComboBox jcb = new JComboBox(spacings);
        jcb.setSelectedItem(value);
        jcb.setEditable(true);
        jcb.addActionListener(this);
        jcb.setActionCommand(command);
        return GuiUtils.wrap(jcb);
    }

    JCheckBox makeCbx(String label, String command, boolean v) {
        JCheckBox jcb = new JCheckBox(label, v);
        jcb.addActionListener(this);
        jcb.setActionCommand(command);
        return jcb;
    }

    @Override
    public Container doMakeContents() {
        this.positionAtClickCbx = new JCheckBox("Position at click", false);
        this.positionLabel = new JLabel(" ", 2);
        boolean set = false;
        if (Double.isNaN(this.lat)) {
            this.lat = this.rangeRings.getCenterLatitude();
        } else {
            set = true;
        }
        if (Double.isNaN(this.lon)) {
            this.lon = this.rangeRings.getCenterLongitude();
        } else {
            set = true;
        }
        if (set) {
            try {
                this.rangeRings.setCenterPoint(this.lat, this.lon);
            }
            catch (Exception exc) {
                RadarGridControl.logException("setting center point", exc);
            }
        }
        this.latField = new JTextField(this.getDisplayConventions().formatLatLon(this.lat), 7);
        this.latField.addActionListener(this);
        this.latField.setActionCommand(CMD_CENTER_LAT);
        this.lonField = new JTextField(this.getDisplayConventions().formatLatLon(this.lon), 7);
        this.lonField.addActionListener(this);
        this.lonField.setActionCommand(CMD_CENTER_LON);
        double[] stretchy = new double[]{0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0};
        this.distanceUnitLabels = new ArrayList<JLabel>();
        String distUnitText = " (" + this.getDisplayUnit() + ") ";
        for (int i = 0; i < 3; ++i) {
            this.distanceUnitLabels.add(new JLabel(distUnitText));
        }
        Component[] comps = new Component[]{GuiUtils.filler(), GuiUtils.cLabel("Visible"), GuiUtils.cLabel(" Spacing "), GuiUtils.cLabel(" Unit "), GuiUtils.cLabel(" Color "), GuiUtils.filler(), GuiUtils.cLabel(" Line Width "), GuiUtils.rLabel("Range Rings: "), GuiUtils.hbox(new JLabel("  "), this.makeCbx("", CMD_RR_VIS, this.rrVisible)), this.makeSpacingBox(rrSpacingList, CMD_RR_SPACING, this.rrSpacing), this.distanceUnitLabels.get(0), this.makeColorBox(CMD_RR_COLOR, this.rrColor), GuiUtils.filler(), this.makeLineWidthBox(CMD_RR_WIDTH, this.rrWidth), GuiUtils.rLabel("Radials: "), GuiUtils.hbox(new JLabel("  "), this.makeCbx("", CMD_RAD_VIS, this.radVisible)), this.makeSpacingBox(radSpacingList, CMD_RAD_SPACING, this.radSpacing), new JLabel(" (deg) "), this.makeColorBox(CMD_RAD_COLOR, this.radColor), GuiUtils.filler(), this.makeLineWidthBox(CMD_RAD_WIDTH, this.radWidth), GuiUtils.rLabel("Labels: "), GuiUtils.hbox(new JLabel("  "), this.makeCbx("", CMD_LBL_VIS, this.lblVisible)), this.makeSpacingBox(lblSpacingList, CMD_LBL_SPACING, this.lblSpacing), this.distanceUnitLabels.get(1), this.makeColorBox(CMD_LBL_COLOR, this.lblColor), GuiUtils.filler(), this.makeLineWidthBox(CMD_LBL_WIDTH, this.lblWidth), GuiUtils.rLabel(" "), new JLabel("Max. Radius: "), this.makeSpacingBox(rrMaxRadiusList, CMD_RR_RADIUS, this.rrMaxRadius), this.distanceUnitLabels.get(2), GuiUtils.filler(), GuiUtils.filler(), GuiUtils.filler()};
        GuiUtils.tmpInsets = new Insets(2, 0, 2, 0);
        JPanel top = GuiUtils.doLayout(comps, 7, stretchy, GuiUtils.WT_N);
        ArrayList<JComponent> bottomComps = new ArrayList<JComponent>();
        this.stationCbx = new JComboBox();
        this.stationCbx.setFont(Font.decode("monospaced"));
        this.setStations();
        this.stationCbx.setSelectedIndex(this.stationIdx);
        this.stationCbx.addActionListener(this);
        this.stationCbx.setActionCommand(CMD_STATIONNAMES);
        bottomComps.add(GuiUtils.rLabel("Location:  "));
        bottomComps.add(GuiUtils.left(GuiUtils.wrap(this.stationCbx)));
        bottomComps.add(GuiUtils.rLabel("Center:"));
        bottomComps.add(GuiUtils.left(GuiUtils.hflow(Misc.newList(new JLabel(" Latitude: "), this.latField, new JLabel(" Longitude: "), this.lonField))));
        bottomComps.add(GuiUtils.rLabel(" "));
        bottomComps.add(GuiUtils.left(this.positionAtClickCbx));
        bottomComps.add(GuiUtils.rLabel("Vertical Position:"));
        bottomComps.add(GuiUtils.hgrid(this.doMakeZPositionSlider(), GuiUtils.filler()));
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel bottom = GuiUtils.doLayout(bottomComps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Location", GuiUtils.top(GuiUtils.inset((Component)bottom, 5)));
        tabbedPane.add("Settings", GuiUtils.top(GuiUtils.inset((Component)top, 5)));
        return tabbedPane;
    }

    Color getColor(ActionEvent event) {
        JComboBox box = (JComboBox)event.getSource();
        return this.getDisplayConventions().getColor((String)box.getSelectedItem());
    }

    private int getWidth(ActionEvent event) {
        JComboBox box = (JComboBox)event.getSource();
        return GuiUtils.getBoxValue(box);
    }

    double getSpacing(ActionEvent event, double min, double max) {
        JComboBox box = (JComboBox)event.getSource();
        String spacing = (String)box.getSelectedItem();
        return Math.min(max, Math.max(min, Misc.parseNumber(spacing)));
    }

    double getMaxRadius(ActionEvent event, double min, double max) {
        JComboBox box = (JComboBox)event.getSource();
        String radius = (String)box.getSelectedItem();
        return Math.min(max, Math.max(min, Misc.parseNumber(radius)));
    }

    boolean getVisible(ActionEvent event) {
        JCheckBox box = (JCheckBox)event.getSource();
        return box.isSelected();
    }

    @Override
    public void setDisplayVisibility(boolean on) {
        if (this.settingVisibility) {
            return;
        }
        super.setDisplayVisibility(on);
        this.applyVisibilityFlags();
    }

    private void applyVisibilityFlags() {
        if (this.rangeRings == null) {
            return;
        }
        try {
            boolean visibility = this.getDisplayVisibility();
            this.rangeRings.setRangeRingsVisible(this.rrVisible && visibility);
            this.rangeRings.setAzimuthLinesVisible(this.radVisible && visibility);
            this.rangeRings.setLabelsVisible(this.lblVisible && visibility);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        if (this.lat != this.lat || this.lon != this.lon) {
            return;
        }
        labels.add("Position: " + this.getDisplayConventions().formatLatLon(this.lat) + " " + this.getDisplayConventions().formatLatLon(this.lon));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.getOkToFireEvents()) {
            return;
        }
        try {
            String cmd = event.getActionCommand();
            if (cmd.equals(CMD_RAD_COLOR)) {
                this.radColor = this.getColor(event);
                this.rangeRings.setAzimuthLineColor(this.radColor);
            } else if (cmd.equals(CMD_RR_COLOR)) {
                this.rrColor = this.getColor(event);
                this.rangeRings.setRangeRingColor(this.rrColor);
            } else if (cmd.equals(CMD_RR_RADIUS)) {
                this.rrMaxRadius = this.getMaxRadius(event, 1.0, 6000.0);
                this.rangeRings.setMaxRadius(this.rrMaxRadius);
            } else if (cmd.equals(CMD_LBL_COLOR)) {
                this.lblColor = this.getColor(event);
                this.rangeRings.setLabelColor(this.lblColor);
            } else if (cmd.equals(CMD_RR_SPACING)) {
                this.rrSpacing = this.getSpacing(event, 0.01, 6000.0);
                this.rangeRings.setRangeRingSpacing(this.rrSpacing, this.rrMaxRadius);
            } else if (cmd.equals(CMD_LBL_SPACING)) {
                this.lblSpacing = this.getSpacing(event, 0.01, 6000.0);
                this.rangeRings.setLabelSpacing(this.lblSpacing);
                this.rangeRings.setLabelColor(this.lblColor);
                this.rangeRings.setLabelsVisible(this.lblVisible);
            } else if (cmd.equals(CMD_RAD_SPACING)) {
                this.radSpacing = this.getSpacing(event, 0.01, 360.0);
                this.rangeRings.setRadialInterval(this.radSpacing);
            } else if (cmd.equals(CMD_RR_VIS)) {
                this.rrVisible = this.getVisible(event);
                this.rangeRings.setRangeRingsVisible(this.rrVisible);
            } else if (cmd.equals(CMD_RAD_VIS)) {
                this.radVisible = this.getVisible(event);
                this.rangeRings.setAzimuthLinesVisible(this.radVisible);
            } else if (cmd.equals(CMD_LBL_VIS)) {
                this.lblVisible = this.getVisible(event);
                this.rangeRings.setLabelsVisible(this.lblVisible);
            } else if (cmd.equals(CMD_RR_WIDTH)) {
                this.rrWidth = this.getWidth(event);
                this.rangeRings.setRangeRingLineWidth(this.rrWidth);
            } else if (cmd.equals(CMD_RAD_WIDTH)) {
                this.radWidth = this.getWidth(event);
                this.rangeRings.setRadialLineWidth(this.radWidth);
            } else if (cmd.equals(CMD_LBL_WIDTH)) {
                this.lblWidth = this.getWidth(event);
                this.rangeRings.setLabelLineWidth(this.lblWidth);
            } else if (cmd.equals(CMD_STATIONNAMES)) {
                this.stationIdx = this.stationCbx.getSelectedIndex();
                NamedStationImpl nsi = RadarGridControl.getSelectedStation(this.stationCbx);
                if (nsi == null) {
                    return;
                }
                this.setLatLon(nsi.getLatitude(), nsi.getLongitude(), false);
            } else if (cmd.equals(CMD_CENTER_LAT) || cmd.equals(CMD_CENTER_LON)) {
                this.setLatLon(Math.max(-90.0, Math.min(90.0, Misc.parseNumber(this.latField.getText()))), Misc.parseNumber(this.lonField.getText()), true);
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception exc) {
            RadarGridControl.logException("RadarGridControl.actionPerformed", exc);
        }
    }

    private void setLatLon(double lat, double lon, boolean andResetStationMenu) {
        try {
            this.lat = lat;
            this.lon = lon;
            this.rangeRings.setCenterPoint(lat, lon);
            if (this.stationCbx != null) {
                if (andResetStationMenu) {
                    this.stationCbx.setSelectedIndex(0);
                }
                this.updateLegendLabel();
                this.latField.setText(this.getDisplayConventions().formatLatLon(lat));
                this.lonField.setText(this.getDisplayConventions().formatLatLon(lon));
            }
        }
        catch (Exception exc) {
            RadarGridControl.logException("Setting lat/lon", exc);
        }
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    public void handleDisplayChanged(DisplayEvent event) {
        if (this.positionAtClickCbx == null || !this.positionAtClickCbx.isSelected()) {
            return;
        }
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent == null) {
            return;
        }
        if (!this.getHaveInitialized() || this.getMakeWindow() && !this.getWindowVisible()) {
            return;
        }
        try {
            int mods = inputEvent.getModifiers();
            int id = event.getId();
            if (id == 1 && (mods & 0x10) != 0) {
                double[] boxCoords = this.screenToBox(event.getX(), event.getY(), this.getZPosition());
                EarthLocation el = this.boxToEarth(boxCoords);
                this.setLatLon(el.getLatitude().getValue(), el.getLongitude().getValue(), true);
            }
        }
        catch (Exception exc) {
            RadarGridControl.logException("Handling mouse click", exc);
        }
    }

    private LatLonPoint findCenterPoint(DataChoice dc) throws RemoteException, VisADException {
        if (dc == null) {
            if (this.getNavigatedDisplay() != null) {
                return this.getNavigatedDisplay().getCenterPoint().getLatLonPoint();
            }
            if (this.stationList != null) {
                NamedStationImpl station = (NamedStationImpl)this.stationList.get(this.stationIdx);
                return station.getNamedLocation().getLatLonPoint();
            }
            return new LatLonTuple(39.0, -100.0);
        }
        FieldImpl fi = (FieldImpl)dc.getData(null, this.getRequestProperties());
        MapProjection mp = GridUtil.getNavigation(fi);
        Rectangle2D box = mp.getDefaultMapArea();
        double cx = box.getX() + box.getWidth() / 2.0;
        double cy = box.getY() + box.getHeight() / 2.0;
        Object llarr = new double[][]{{0.0}, {0.0}};
        llarr = mp.isLatLonOrder() ? (Object)mp.toReference(new double[][]{{cx}, {cy}}) : (Object)mp.toReference(new double[][]{{cy}, {cx}});
        return new LatLonTuple(llarr[0][0], llarr[1][0]);
    }

    public void setRadColor(Color value) {
        this.radColor = value;
    }

    public Color getRadColor() {
        return this.radColor;
    }

    public void setRrColor(Color value) {
        this.rrColor = value;
    }

    public Color getRrColor() {
        return this.rrColor;
    }

    public void setLblColor(Color value) {
        this.lblColor = value;
    }

    public Color getLblColor() {
        return this.lblColor;
    }

    public void setRrSpacing(double value) {
        this.rrSpacing = value;
    }

    public double getRrSpacing() {
        return this.rrSpacing;
    }

    public void setLblSpacing(double value) {
        this.lblSpacing = value;
    }

    public double getLblSpacing() {
        return this.lblSpacing;
    }

    public void setRadSpacing(double value) {
        this.radSpacing = value;
    }

    public double getRadSpacing() {
        return this.radSpacing;
    }

    public void setRrVisible(boolean value) {
        this.rrVisible = value;
    }

    public boolean getRrVisible() {
        return this.rrVisible;
    }

    public void setLblVisible(boolean value) {
        this.lblVisible = value;
    }

    public boolean getLblVisible() {
        return this.lblVisible;
    }

    public void setRadVisible(boolean value) {
        this.radVisible = value;
    }

    public boolean getRadVisible() {
        return this.radVisible;
    }

    public void setLat(double value) {
        this.lat = value;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLon(double value) {
        this.lon = value;
    }

    public double getLon() {
        return this.lon;
    }

    public int getStationIdx() {
        return this.stationIdx;
    }

    public void setStationIdx(int idx) {
        this.stationIdx = idx;
    }

    public void setMaxRadius(double value) {
        this.rrMaxRadius = value;
    }

    public double getMaxRadius() {
        return this.rrMaxRadius;
    }

    public void setRadWidth(int width) {
        this.radWidth = width;
    }

    public int getRadWidth() {
        return this.radWidth;
    }

    public int getLblWidth() {
        return this.lblWidth;
    }

    public void setLblWidth(int width) {
        this.lblWidth = width;
    }

    public int getRrWidth() {
        return this.rrWidth;
    }

    public void setRrWidth(int width) {
        this.rrWidth = width;
    }

    public void setVerticalValue(double value) throws RemoteException, VisADException {
        super.setZPosition(value);
    }

    public void setStationTableName(String value) {
        this.stationTableName = value;
    }

    public String getStationTableName() {
        return this.stationTableName;
    }

    public void setLabelFont(Font value) {
        this.labelFont = value;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setInitStationLocation(String l) {
        this.initStationLocation = l;
    }

    @Override
    public void setDisplayUnit(Unit newUnit) {
        super.setDisplayUnit(newUnit);
        if (this.distanceUnitLabels != null) {
            for (JLabel label : this.distanceUnitLabels) {
                label.setText(" (" + newUnit + ") ");
            }
        }
    }
}

