/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.DisplayInfo;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.ColorCrossSectionControl;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Range;
import ucar.visad.RadarMapProjection;
import ucar.visad.display.CrossSectionSelector;
import visad.FieldImpl;
import visad.GriddedSet;
import visad.RealTuple;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar3DCoordinateSystem;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;

public class RadarCrossSectionControl
extends ColorCrossSectionControl {
    private double defaultLen = 1.0;
    private double currentCSLineLen = 0.2;

    @Override
    public void initDone() {
        try {
            this.setRequestProperties();
            this.setVerticalAxisRange(new Range(0.0, 20000.0));
            this.loadDataFromLine();
            GridDataInstance ginst = this.getGridDataInstance();
            if (ginst == null) {
                return;
            }
            FieldImpl fieldImpl = (FieldImpl)ginst.getGrid().getSample(0);
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(fieldImpl);
            Unit xUnit = domainSet.getSetUnits()[0];
            String unitlabel = xUnit.toString();
            if (unitlabel.equalsIgnoreCase("1000.0 m")) {
                unitlabel = "km";
            }
            this.updateCenterPoint();
        }
        catch (Exception e) {
            RadarCrossSectionControl.logException("Initializing the csSelector", e);
        }
        this.csSelector.addPropertyChangeListener(this);
        this.updatePositionWidget();
    }

    @Override
    public Range getDefaultVerticalRange() {
        return new Range(0.0, 20000.0);
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (!super.setData(choice)) {
            System.out.println("set data is false");
            return false;
        }
        this.dataIs3D = true;
        this.updateCenterPoint();
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectorDisplay.position")) {
            this.crossSectionChanged();
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    public void crossSectionChanged() {
        try {
            this.setVerticalAxisRange(new Range(0.0, 20000.0));
            this.loadDataFromLine();
            this.updateLegendLabel();
            this.updatePositionWidget();
            CrossSectionSelector cs = this.getCrossSectionSelector();
            this.doShare((Object)"DisplayControlImpl.SHARE_TRANSECT", new Object[]{cs.getStartPoint(), cs.getEndPoint()});
        }
        catch (Exception exc) {
            RadarCrossSectionControl.logException("Error in crossSectionChanged ", exc);
        }
    }

    private String fmt(double latlon) {
        return this.getDisplayConventions().formatLatLon(latlon);
    }

    private void updatePositionWidget() {
        try {
            if (this.startLLW == null) {
                return;
            }
            EarthLocation[] coords = this.getLineCoords();
            this.startLLW.setLatLon(this.fmt(coords[0].getLatitude().getValue()), this.fmt(coords[0].getLongitude().getValue()));
            this.endLLW.setLatLon(this.fmt(coords[1].getLatitude().getValue()), this.fmt(coords[1].getLongitude().getValue()));
        }
        catch (Exception exc) {
            RadarCrossSectionControl.logException("Error setting position ", exc);
        }
    }

    @Override
    protected Hashtable getRequestProperties() {
        Hashtable props = super.getRequestProperties();
        props.put("Level2RadarDataSource.verticalcrosssection", new Boolean(true));
        if (this.startLocation != null && this.endLocation != null) {
            props.put("Level2RadarDataSource.verticalcrosssectionstart", this.startLocation);
            props.put("Level2RadarDataSource.verticalcrosssectionend", this.endLocation);
        }
        return props;
    }

    protected void setRequestProperties() throws VisADException, RemoteException {
        this.getRequestProperties().put("Level2RadarDataSource.verticalcrosssection", new Boolean(true));
        if (this.startLocation == null || this.endLocation == null) {
            RadarMapProjection rp;
            MapViewManager mm = this.getMapViewManager();
            MapProjection mp = mm.getMainProjection();
            try {
                rp = (RadarMapProjection)mp;
            }
            catch (ClassCastException ce) {
                LogUtil.consoleMessage("Radar projection cast error\n");
                return;
            }
            LatLonPoint llp = rp.getCenterLatLon();
            this.initLinePosition((float)llp.getLatitude().getValue(), (float)llp.getLongitude().getValue());
        }
        this.getRequestProperties().put("Level2RadarDataSource.verticalcrosssectionstart", this.startLocation);
        this.getRequestProperties().put("Level2RadarDataSource.verticalcrosssectionend", this.endLocation);
    }

    public void setStartLocation(EarthLocation sl) {
        this.startLocation = sl;
    }

    public EarthLocation getStartLocation() {
        return this.startLocation;
    }

    public void setEndLocation(EarthLocation sl) {
        this.endLocation = sl;
    }

    public EarthLocation getEndLocation() {
        return this.endLocation;
    }

    @Override
    public MapViewManager getMapViewManager() {
        List displayList = this.getDisplayInfos();
        int n = displayList.size();
        for (int i = 0; i < n; ++i) {
            DisplayInfo info = (DisplayInfo)displayList.get(i);
            ViewManager vm = info.getViewManager();
            if (!(vm instanceof MapViewManager)) continue;
            return (MapViewManager)vm;
        }
        return null;
    }

    protected void initLinePosition(float stationLat, float stationLon) throws VisADException, RemoteException {
        if (this.getVerticalAxisRange() == null) {
            this.setVerticalAxisRange(new Range(0.0, 20000.0));
        }
        LatLonPointImpl lp1 = Bearing.findPoint(stationLat, (double)stationLon, 0.0, 150.0, null);
        LatLonPointImpl lp2 = Bearing.findPoint(stationLat, (double)stationLon, 180.0, 150.0, null);
        this.startLocation = new EarthLocationTuple(lp2.getLatitude(), lp2.getLongitude(), 0.0);
        this.endLocation = new EarthLocationTuple(lp1.getLatitude(), lp1.getLongitude(), 0.0);
    }

    @Override
    protected void loadDataFromLine() throws VisADException, RemoteException {
        if (!this.getHaveInitialized()) {
            return;
        }
        this.setRequestProperties();
        EarthLocation[] elArray = this.getLineCoords();
        this.startLocation = elArray[0];
        this.endLocation = elArray[1];
        GridDataInstance ginst = this.getGridDataInstance();
        if (ginst == null) {
            return;
        }
        ginst.reInitialize();
        FieldImpl grid = ginst.getGrid();
        this.dataIs3D = true;
        this.loadData(grid);
    }

    @Override
    protected void createCrossSectionSelector() throws VisADException, RemoteException {
        this.csSelector = new CrossSectionSelector();
        this.csSelector.setZValue(0.99);
        this.setCSLineLength(this.defaultLen);
        this.setRequestProperties();
    }

    private boolean setCSLineLength(double len) {
        if (this.csSelector == null) {
            return false;
        }
        Object center = null;
        try {
            double[] box;
            double[] box2;
            double x1 = 0.0;
            double y1 = 0.0;
            if (this.startLocation != null && (box2 = this.earthToBox(this.startLocation)) != null) {
                x1 = box2[0];
                y1 = box2[1];
            }
            RealTuple start = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x1, y1});
            double x2 = 0.0;
            double y2 = 0.0;
            if (this.endLocation != null && (box = this.earthToBox(this.endLocation)) != null) {
                x2 = box[0];
                y2 = box[1];
            }
            RealTuple newend = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x2, y2});
            this.csSelector.setPosition(start, newend);
        }
        catch (Exception e) {
            RadarCrossSectionControl.logException("setCSLineLength:", e);
            return false;
        }
        return true;
    }

    protected void updateCenterPoint() throws VisADException, RemoteException {
        GridDataInstance ginst = this.getGridDataInstance();
        if (ginst == null) {
            return;
        }
        FieldImpl fieldImpl = ginst.getGrid();
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(fieldImpl);
        Radar3DCoordinateSystem transform = (Radar3DCoordinateSystem)domainSet.getCoordinateSystem();
        if (this.startLocation == null || this.endLocation == null) {
            float stationLat = transform.getCenterPoint()[0];
            float stationLon = transform.getCenterPoint()[1];
            float stationEl = transform.getCenterPoint()[2];
            List choices = this.getDataChoices();
            String staname = ((DataChoice)choices.get(0)).getName();
            this.initLinePosition(stationLat, stationLon);
            this.setCSLineLength(this.defaultLen);
        }
    }

    @Override
    public boolean getAllowAutoScale() {
        return false;
    }

    @Override
    public boolean getAutoScaleYAxis() {
        return false;
    }

    @Override
    protected void setPosition(EarthLocation startLoc, EarthLocation endLoc) throws VisADException, RemoteException {
        double x1 = 0.0;
        double y1 = 0.0;
        double[] box1 = this.earthToBox(startLoc);
        if (box1 != null) {
            x1 = box1[0];
            y1 = box1[1];
        }
        RealTuple start = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x1, y1});
        double x2 = 0.0;
        double y2 = 0.0;
        double[] box2 = this.earthToBox(startLoc);
        if (box2 != null) {
            x2 = box2[0];
            y2 = box2[1];
        }
        RealTuple end = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x2, y2});
        this.csSelector.setPosition(start, end);
        this.startLocation = startLoc;
        this.endLocation = endLoc;
        this.csSelector.setZValue(0.99);
        this.setCSLineLength(this.defaultLen);
        this.setRequestProperties();
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return false;
    }
}

