/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.ImageRGBDisplayable;
import visad.BaseColorControl;
import visad.CoordinateSystem;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;
import visad.georef.MapProjection;

public class RGBCompositeControl
extends DisplayControlImpl {
    public static final String FORMULA_IN_PROGRESS_FLAG = "Formula_Active";
    private ImageRGBDisplayable imageDisplay;
    private DisplayMaster displayMaster;
    private ScalarMap redMap = null;
    private ScalarMap grnMap = null;
    private ScalarMap bluMap = null;
    float[][] redTable = null;
    float[][] grnTable = null;
    float[][] bluTable = null;
    private final double[] redRange = new double[]{Double.NaN, Double.NaN};
    private final double[] grnRange = new double[]{Double.NaN, Double.NaN};
    private final double[] bluRange = new double[]{Double.NaN, Double.NaN};
    final double[] initRedRange = new double[]{Double.NaN, Double.NaN};
    final double[] initGrnRange = new double[]{Double.NaN, Double.NaN};
    final double[] initBluRange = new double[]{Double.NaN, Double.NaN};
    private FieldImpl imageField = null;
    private MapProjection mapProjection = null;
    private double gamma = 1.0;
    private double redGamma = 1.0;
    private double grnGamma = 1.0;
    private double bluGamma = 1.0;
    private final JTextField gammaTxtFld = new JTextField(Float.toString(1.0f), 4);
    private final JTextField redGammaTxtFld = new JTextField(Float.toString(1.0f), 4);
    private final JTextField grnGammaTxtFld = new JTextField(Float.toString(1.0f), 4);
    private final JTextField bluGammaTxtFld = new JTextField(Float.toString(1.0f), 4);
    private final JTextField redLowTxtFld = new JTextField(Float.toString(1.0f), 10);
    private final JTextField redHighTxtFld = new JTextField(Float.toString(1.0f), 10);
    private final JTextField grnLowTxtFld = new JTextField(Float.toString(1.0f), 10);
    private final JTextField grnHighTxtFld = new JTextField(Float.toString(1.0f), 10);
    private final JTextField bluLowTxtFld = new JTextField(Float.toString(1.0f), 10);
    private final JTextField bluHighTxtFld = new JTextField(Float.toString(1.0f), 10);

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.displayMaster = this.getViewManager().getMaster();
        DataSelection dataSelection = this.getDataSelection();
        Hashtable ht = this.getIdv().getViewManager().getProperties();
        ht.put(FORMULA_IN_PROGRESS_FLAG, true);
        this.imageField = (FieldImpl)dataChoice.getData(dataSelection);
        this.imageDisplay = new ImageRGBDisplayable("rgb composite", null, false, this.imageField);
        ht.put(FORMULA_IN_PROGRESS_FLAG, false);
        Iterator iter = this.imageDisplay.getScalarMapSet().iterator();
        while (iter.hasNext()) {
            ScalarMap map = (ScalarMap)iter.next();
            if (map.getScalarName().startsWith("redimage")) {
                this.redMap = map;
            }
            if (map.getScalarName().startsWith("greenimage")) {
                this.grnMap = map;
            }
            if (!map.getScalarName().startsWith("blueimage")) continue;
            this.bluMap = map;
        }
        if (this.checkRange()) {
            double[] redRange = this.getRedRange();
            double[] grnRange = this.getGrnRange();
            double[] bluRange = this.getBluRange();
            this.initRedRange[0] = redRange[0];
            this.initRedRange[1] = redRange[1];
            this.initGrnRange[0] = grnRange[0];
            this.initGrnRange[1] = grnRange[1];
            this.initBluRange[0] = bluRange[0];
            this.initBluRange[1] = bluRange[1];
            this.redLowTxtFld.setText(Float.toString((float)redRange[0]));
            this.redHighTxtFld.setText(Float.toString((float)redRange[1]));
            this.grnLowTxtFld.setText(Float.toString((float)grnRange[0]));
            this.grnHighTxtFld.setText(Float.toString((float)grnRange[1]));
            this.bluLowTxtFld.setText(Float.toString((float)bluRange[0]));
            this.bluHighTxtFld.setText(Float.toString((float)bluRange[1]));
            this.gammaTxtFld.setText(Float.toString((float)this.gamma));
            this.redGammaTxtFld.setText(Float.toString((float)this.redGamma));
            this.grnGammaTxtFld.setText(Float.toString((float)this.grnGamma));
            this.bluGammaTxtFld.setText(Float.toString((float)this.bluGamma));
            this.redMap.setRange(redRange[0], redRange[1]);
            this.grnMap.setRange(grnRange[0], grnRange[1]);
            this.bluMap.setRange(bluRange[0], bluRange[1]);
        } else {
            this.redMap.resetAutoScale();
            this.grnMap.resetAutoScale();
            this.bluMap.resetAutoScale();
            this.redMap.addScalarMapListener(new ColorMapListener(this.redMap, this.initRedRange, this.redRange, this.redLowTxtFld, this.redHighTxtFld));
            this.grnMap.addScalarMapListener(new ColorMapListener(this.grnMap, this.initGrnRange, this.grnRange, this.grnLowTxtFld, this.grnHighTxtFld));
            this.bluMap.addScalarMapListener(new ColorMapListener(this.bluMap, this.initBluRange, this.bluRange, this.bluLowTxtFld, this.bluHighTxtFld));
        }
        this.setShowInDisplayList(true);
        this.addDisplayable((Displayable)this.imageDisplay, 136);
        return true;
    }

    @Override
    public void initDone() {
        while (null == this.redMap.getControl()) {
        }
        this.redTable = ((BaseColorControl)this.redMap.getControl()).getTable();
        while (null == this.grnMap.getControl()) {
        }
        this.grnTable = ((BaseColorControl)this.grnMap.getControl()).getTable();
        while (null == this.bluMap.getControl()) {
        }
        this.bluTable = ((BaseColorControl)this.bluMap.getControl()).getTable();
        float[][] newRedTbl = this.getZeroOutArray(this.redTable);
        float[][] newGrnTbl = this.getZeroOutArray(this.grnTable);
        float[][] newBluTbl = this.getZeroOutArray(this.bluTable);
        for (int k = 0; k < this.redTable[0].length; ++k) {
            newRedTbl[0][k] = (float)Math.pow(this.redTable[0][k], this.redGamma);
            newGrnTbl[1][k] = (float)Math.pow(this.grnTable[1][k], this.grnGamma);
            newBluTbl[2][k] = (float)Math.pow(this.bluTable[2][k], this.bluGamma);
        }
        try {
            this.displayMaster.setDisplayInactive();
            ((BaseColorControl)this.redMap.getControl()).setTable(newRedTbl);
            ((BaseColorControl)this.grnMap.getControl()).setTable(newGrnTbl);
            ((BaseColorControl)this.bluMap.getControl()).setTable(newBluTbl);
            this.imageDisplay.loadData(this.imageField);
            this.displayMaster.setDisplayActive();
        }
        catch (Exception ex) {
            LogUtil.logException("setDisplayInactive", ex);
        }
    }

    @Override
    public MapProjection getDataProjection() {
        CoordinateSystem cs = null;
        try {
            Data dat;
            if (this.imageField instanceof FlatField) {
                cs = ((FunctionType)this.imageField.getType()).getDomain().getCoordinateSystem();
            } else if (this.imageField instanceof FieldImpl && (dat = this.imageField.getSample(0, false)) instanceof FlatField) {
                FlatField img = (FlatField)dat;
                cs = ((FunctionType)img.getType()).getDomain().getCoordinateSystem();
            }
        }
        catch (Exception ex) {
            LogUtil.logException("problem accessing data", ex);
        }
        if (cs instanceof MapProjection) {
            this.mapProjection = (MapProjection)cs;
        }
        return this.mapProjection;
    }

    boolean checkRange() {
        return !Double.isNaN(this.redRange[0]) && !Double.isNaN(this.grnRange[0]) && !Double.isNaN(this.bluRange[0]);
    }

    private void updateRedRange(double lo, double hi) {
        this.redRange[0] = lo;
        this.redRange[1] = hi;
        this.redHighTxtFld.setText(Float.toString((float)hi));
        this.redLowTxtFld.setText(Float.toString((float)lo));
        try {
            this.redMap.setRange(lo, hi);
        }
        catch (RemoteException | VisADException ex) {
            LogUtil.logException("redMap.setRange", ex);
        }
    }

    public void setRedRange(double[] range) {
        this.redRange[0] = range[0];
        this.redRange[1] = range[1];
    }

    public double[] getRedRange() {
        return new double[]{this.redRange[0], this.redRange[1]};
    }

    private void updateGrnRange(double lo, double hi) {
        this.grnRange[0] = lo;
        this.grnRange[1] = hi;
        this.grnHighTxtFld.setText(Float.toString((float)hi));
        this.grnLowTxtFld.setText(Float.toString((float)lo));
        try {
            this.grnMap.setRange(lo, hi);
        }
        catch (RemoteException | VisADException ex) {
            LogUtil.logException("grnMap.setRange", ex);
        }
    }

    public void setGrnRange(double[] range) {
        this.grnRange[0] = range[0];
        this.grnRange[1] = range[1];
    }

    public double[] getGrnRange() {
        return new double[]{this.grnRange[0], this.grnRange[1]};
    }

    private void updateBluRange(double lo, double hi) {
        this.bluRange[0] = lo;
        this.bluRange[1] = hi;
        this.bluHighTxtFld.setText(Float.toString((float)hi));
        this.bluLowTxtFld.setText(Float.toString((float)lo));
        try {
            this.bluMap.setRange(lo, hi);
        }
        catch (RemoteException | VisADException ex) {
            LogUtil.logException("bluMap.setRange", ex);
        }
    }

    public void setBluRange(double[] range) {
        this.bluRange[0] = range[0];
        this.bluRange[1] = range[1];
    }

    public double[] getBluRange() {
        return new double[]{this.bluRange[0], this.bluRange[1]};
    }

    public void setRedGamma(double gamma) {
        this.redGamma = gamma;
    }

    public double getRedGamma() {
        return this.redGamma;
    }

    public void setGrnGamma(double gamma) {
        this.grnGamma = gamma;
    }

    public double getGrnGamma() {
        return this.grnGamma;
    }

    public void setBluGamma(double gamma) {
        this.bluGamma = gamma;
    }

    public double getBluGamma() {
        return this.bluGamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public double getGamma() {
        return this.gamma;
    }

    private void updateGamma(double gamma) {
        this.setGamma(gamma);
        this.setRedGamma(gamma);
        this.setGrnGamma(gamma);
        this.setBluGamma(gamma);
        this.redGammaTxtFld.setText(Float.toString((float)gamma));
        this.grnGammaTxtFld.setText(Float.toString((float)gamma));
        this.bluGammaTxtFld.setText(Float.toString((float)gamma));
        float[][] newRedTbl = this.getZeroOutArray(this.redTable);
        float[][] newGrnTbl = this.getZeroOutArray(this.grnTable);
        float[][] newBluTbl = this.getZeroOutArray(this.bluTable);
        for (int k = 0; k < this.redTable[0].length; ++k) {
            newRedTbl[0][k] = (float)Math.pow(this.redTable[0][k], gamma);
            newGrnTbl[1][k] = (float)Math.pow(this.grnTable[1][k], gamma);
            newBluTbl[2][k] = (float)Math.pow(this.bluTable[2][k], gamma);
        }
        try {
            this.displayMaster.setDisplayInactive();
            ((BaseColorControl)this.redMap.getControl()).setTable(newRedTbl);
            ((BaseColorControl)this.grnMap.getControl()).setTable(newGrnTbl);
            ((BaseColorControl)this.bluMap.getControl()).setTable(newBluTbl);
            this.displayMaster.setDisplayActive();
        }
        catch (Exception ex) {
            LogUtil.logException("setDisplayInactive", ex);
        }
    }

    private void updateRedGamma(double gamma) {
        this.setRedGamma(gamma);
        float[][] newRedTbl = this.getZeroOutArray(this.redTable);
        for (int k = 0; k < this.redTable[0].length; ++k) {
            newRedTbl[0][k] = (float)Math.pow(this.redTable[0][k], gamma);
        }
        try {
            this.displayMaster.setDisplayInactive();
            ((BaseColorControl)this.redMap.getControl()).setTable(newRedTbl);
            this.displayMaster.setDisplayActive();
        }
        catch (Exception ex) {
            LogUtil.logException("setDisplayInactive", ex);
        }
    }

    private void updateGrnGamma(double gamma) {
        this.setGrnGamma(gamma);
        float[][] newGrnTbl = this.getZeroOutArray(this.grnTable);
        for (int k = 0; k < this.grnTable[0].length; ++k) {
            newGrnTbl[1][k] = (float)Math.pow(this.grnTable[1][k], gamma);
        }
        try {
            this.displayMaster.setDisplayInactive();
            ((BaseColorControl)this.grnMap.getControl()).setTable(newGrnTbl);
            this.displayMaster.setDisplayActive();
        }
        catch (Exception ex) {
            LogUtil.logException("setDisplayInactive", ex);
        }
    }

    private void updateBluGamma(double gamma) {
        this.setBluGamma(gamma);
        float[][] newBluTbl = this.getZeroOutArray(this.bluTable);
        for (int k = 0; k < this.bluTable[0].length; ++k) {
            newBluTbl[2][k] = (float)Math.pow(this.bluTable[2][k], gamma);
        }
        try {
            this.displayMaster.setDisplayInactive();
            ((BaseColorControl)this.bluMap.getControl()).setTable(newBluTbl);
            this.displayMaster.setDisplayActive();
        }
        catch (Exception ex) {
            LogUtil.logException("setDisplayInactive", ex);
        }
    }

    public float[][] getZeroOutArray(float[][] array) {
        float[][] newArray = new float[array.length][array[0].length];
        for (int i = 0; i < newArray.length; ++i) {
            for (int j = 0; j < newArray[0].length; ++j) {
                newArray[i][j] = 0.0f;
            }
        }
        return newArray;
    }

    @Override
    protected ColorTable getInitialColorTable() {
        return this.getDisplayConventions().getParamColorTable("image");
    }

    @Override
    public Container doMakeContents() {
        JButton allGammaButton = new JButton("Apply to All Gamma Fields");
        allGammaButton.addActionListener(e -> {
            String tmp = this.gammaTxtFld.getText().trim();
            this.updateGamma(Double.valueOf(tmp));
        });
        this.gammaTxtFld.addActionListener(e -> {
            String tmp = this.gammaTxtFld.getText().trim();
            this.updateGamma(Double.valueOf(tmp));
        });
        this.redLowTxtFld.addActionListener(e -> {
            String tmp = this.redLowTxtFld.getText().trim();
            this.updateRedRange(Double.valueOf(tmp), this.redRange[1]);
        });
        this.redHighTxtFld.addActionListener(e -> {
            String tmp = this.redHighTxtFld.getText().trim();
            this.updateRedRange(this.redRange[0], Double.valueOf(tmp));
        });
        this.redGammaTxtFld.addActionListener(e -> {
            String tmp = this.redGammaTxtFld.getText().trim();
            this.updateRedGamma(Double.valueOf(tmp));
        });
        JButton redReset = new JButton("Reset");
        redReset.addActionListener(e -> {
            this.updateRedRange(this.initRedRange[0], this.initRedRange[1]);
            this.redRange[0] = this.initRedRange[0];
            this.redRange[1] = this.initRedRange[1];
            this.redLowTxtFld.setText(Float.toString((float)this.redRange[0]));
            this.redHighTxtFld.setText(Float.toString((float)this.redRange[1]));
            this.updateRedGamma(1.0);
            this.redGammaTxtFld.setText("1.0");
        });
        this.grnLowTxtFld.addActionListener(e -> {
            String tmp = this.grnLowTxtFld.getText().trim();
            this.updateGrnRange(Double.valueOf(tmp), this.grnRange[1]);
        });
        this.grnHighTxtFld.addActionListener(e -> {
            String tmp = this.grnHighTxtFld.getText().trim();
            this.updateGrnRange(this.grnRange[0], Double.valueOf(tmp));
        });
        this.grnGammaTxtFld.addActionListener(e -> {
            String tmp = this.grnGammaTxtFld.getText().trim();
            this.updateGrnGamma(Double.valueOf(tmp));
        });
        JButton grnReset = new JButton("Reset");
        grnReset.addActionListener(e -> {
            this.updateGrnRange(this.initGrnRange[0], this.initGrnRange[1]);
            this.grnRange[0] = this.initGrnRange[0];
            this.grnRange[1] = this.initGrnRange[1];
            this.grnLowTxtFld.setText(Float.toString((float)this.grnRange[0]));
            this.grnHighTxtFld.setText(Float.toString((float)this.grnRange[1]));
            this.updateGrnGamma(1.0);
            this.grnGammaTxtFld.setText("1.0");
        });
        this.bluLowTxtFld.addActionListener(e -> {
            String tmp = this.bluLowTxtFld.getText().trim();
            this.updateBluRange(Double.valueOf(tmp), this.bluRange[1]);
        });
        this.bluHighTxtFld.addActionListener(e -> {
            String tmp = this.bluHighTxtFld.getText().trim();
            this.updateBluRange(this.bluRange[0], Double.valueOf(tmp));
        });
        this.bluGammaTxtFld.addActionListener(e -> {
            String tmp = this.bluGammaTxtFld.getText().trim();
            this.updateBluGamma(Double.valueOf(tmp));
        });
        JButton bluReset = new JButton("Reset");
        bluReset.addActionListener(e -> {
            this.updateBluRange(this.initBluRange[0], this.initBluRange[1]);
            this.bluRange[0] = this.initBluRange[0];
            this.bluRange[1] = this.initBluRange[1];
            this.bluLowTxtFld.setText(Float.toString((float)this.bluRange[0]));
            this.bluHighTxtFld.setText(Float.toString((float)this.bluRange[1]));
            this.updateBluGamma(1.0);
            this.bluGammaTxtFld.setText("1.0");
        });
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(e -> {
            String redLow = this.redLowTxtFld.getText().trim();
            String redHigh = this.redHighTxtFld.getText().trim();
            this.updateRedRange(Double.valueOf(redLow), Double.valueOf(redHigh));
            String grnLow = this.grnLowTxtFld.getText().trim();
            String grnHigh = this.grnHighTxtFld.getText().trim();
            this.updateGrnRange(Double.valueOf(grnLow), Double.valueOf(grnHigh));
            String bluLow = this.bluLowTxtFld.getText().trim();
            String bluHigh = this.bluHighTxtFld.getText().trim();
            this.updateBluRange(Double.valueOf(bluLow), Double.valueOf(bluHigh));
            String tmp = this.redGammaTxtFld.getText().trim();
            this.updateRedGamma(Double.valueOf(tmp));
            tmp = this.grnGammaTxtFld.getText().trim();
            this.updateGrnGamma(Double.valueOf(tmp));
            tmp = this.bluGammaTxtFld.getText().trim();
            this.updateBluGamma(Double.valueOf(tmp));
        });
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel topPanel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Red range: "), this.redLowTxtFld, this.redHighTxtFld, GuiUtils.cLabel("Red Gamma: "), this.redGammaTxtFld, redReset, GuiUtils.rLabel("Green range: "), this.grnLowTxtFld, this.grnHighTxtFld, GuiUtils.cLabel("Green Gamma: "), this.grnGammaTxtFld, grnReset, GuiUtils.rLabel("Blue range: "), this.bluLowTxtFld, this.bluHighTxtFld, GuiUtils.cLabel("Blue Gamma: "), this.bluGammaTxtFld, bluReset, GuiUtils.filler(), GuiUtils.filler(), GuiUtils.filler(), GuiUtils.filler(), GuiUtils.filler(), applyButton}, 6, GuiUtils.WT_N, GuiUtils.WT_N);
        JPanel bottomPanel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Common Gamma: "), this.gammaTxtFld, allGammaButton, GuiUtils.rLabel("Vertical Position: "), this.doMakeZPositionSlider(), GuiUtils.filler()}, 3, GuiUtils.WT_N, GuiUtils.WT_N);
        JPanel mainPanel = GuiUtils.vbox((Component)topPanel, bottomPanel);
        mainPanel = GuiUtils.topLeft(mainPanel);
        return mainPanel;
    }

    private class ColorMapListener
    implements ScalarMapListener {
        ScalarMap clrMap;
        double[] range = null;
        double[] initRange = null;
        JTextField lowTxtFld;
        JTextField highTxtFld;

        ColorMapListener(ScalarMap clrMap, double[] initRange, double[] range, JTextField lowTxtFld, JTextField highTxtFld) {
            this.clrMap = clrMap;
            this.lowTxtFld = lowTxtFld;
            this.highTxtFld = highTxtFld;
            this.range = range;
            this.initRange = initRange;
        }

        @Override
        public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
        }

        @Override
        public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
            if (event.getId() == 1) {
                double[] rng = this.clrMap.getRange();
                boolean shouldRemove = false;
                if (!Double.isNaN(rng[0]) && !Double.isNaN(rng[1]) && Double.isNaN(this.initRange[0]) && Double.isNaN(this.initRange[1])) {
                    shouldRemove = true;
                }
                this.range[0] = rng[0];
                this.range[1] = rng[1];
                this.initRange[0] = rng[0];
                this.initRange[1] = rng[1];
                this.lowTxtFld.setText(Float.toString((float)rng[0]));
                this.highTxtFld.setText(Float.toString((float)rng[1]));
                if (shouldRemove) {
                    this.clrMap.removeScalarMapListener(this);
                    this.clrMap.disableAutoScale();
                }
            } else if (event.getId() == 2) {
                double[] rng = this.clrMap.getRange();
                this.range[0] = rng[0];
                this.range[1] = rng[1];
            }
        }
    }
}

