/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.WindTimeHeightControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.display.ColorScale;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineProbe;
import visad.CommonUnit;
import visad.FieldImpl;
import visad.VisADException;
import visad.georef.EarthLocation;

public class ProfilerTimeHeightControl
extends WindTimeHeightControl {
    private LineProbe lineProbe;
    private JComboBox stationsBox;
    private Color foreground;
    private Color background;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        boolean result = super.init(dataChoice);
        if (this.foreground != null) {
            this.timeHeightView.setColors(this.foreground, this.background);
        }
        return result;
    }

    @Override
    protected boolean initStation(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.initStation(dataChoice)) {
            return false;
        }
        Misc.run(new Runnable(){

            @Override
            public void run() {
                ProfilerTimeHeightControl.this.showWaitCursor();
                try {
                    if (ProfilerTimeHeightControl.this.getDataInstance() == null) {
                        return;
                    }
                    ProfilerTimeHeightControl.this.fieldImpl = (FieldImpl)ProfilerTimeHeightControl.this.getDataInstance().getData();
                    if (ProfilerTimeHeightControl.this.fieldImpl == null) {
                        return;
                    }
                    ProfilerTimeHeightControl.this.haveNewStation = true;
                    EarthLocation location = null;
                    Object id = ProfilerTimeHeightControl.this.currentDataChoice.getId();
                    if (id instanceof NamedStation) {
                        location = ((NamedStation)id).getNamedLocation();
                    } else if (id instanceof EarthLocation) {
                        location = (EarthLocation)id;
                    }
                    ProfilerTimeHeightControl.this.latitude = (float)location.getLatitude().getValue(CommonUnit.degree);
                    ProfilerTimeHeightControl.this.longitude = (float)location.getLongitude().getValue(CommonUnit.degree);
                    if ((double)ProfilerTimeHeightControl.this.latitude >= 0.0) {
                        ProfilerTimeHeightControl.this.wbDisplayable.setBarbOrientation(0);
                    } else {
                        ProfilerTimeHeightControl.this.wbDisplayable.setBarbOrientation(1);
                    }
                    ProfilerTimeHeightControl.this.labelName = " " + ProfilerTimeHeightControl.this.currentDataChoice.getId().toString();
                    ProfilerTimeHeightControl.this.setLabel();
                    ProfilerTimeHeightControl.this.wbDisplayable.loadData(ProfilerTimeHeightControl.this.fieldImpl);
                    ProfilerTimeHeightControl.this.resetDataVerticalInterval(ProfilerTimeHeightControl.this.currentVerticalInt);
                    ProfilerTimeHeightControl.this.setXAxisValues(ProfilerTimeHeightControl.this.fieldImpl.getDomainSet());
                    ProfilerTimeHeightControl.this.setYAxisValues(ProfilerTimeHeightControl.this.fieldImpl);
                }
                catch (Exception excp) {
                    DisplayControlBase.logException("File selection", excp);
                }
                try {
                    ProfilerTimeHeightControl.this.lineProbe.setPosition(ProfilerTimeHeightControl.this.getRealTupleForPoint(ProfilerTimeHeightControl.this.latitude, ProfilerTimeHeightControl.this.longitude));
                }
                catch (Exception excp) {
                    DisplayControlBase.logException(" line probe set position ", excp);
                }
                ProfilerTimeHeightControl.this.showNormalCursor();
                ProfilerTimeHeightControl.this.haveNewStation = false;
            }
        });
        return true;
    }

    @Override
    protected void initDisplayables() throws VisADException, RemoteException {
        super.initDisplayables();
        this.lineProbe = new LineProbe();
        this.lineProbe.setManipulable(false);
        this.lineProbe.setPointSize(this.getDisplayScale());
        this.lineProbe.setAutoSize(true);
        this.addDisplayable(this.lineProbe);
    }

    @Override
    protected void setLabel() {
        if (this.plotLabel != null) {
            this.plotLabel.setText(this.labelName + " Profiler Lat: " + this.latitude + "  Long: " + this.longitude);
        }
    }

    @Override
    protected void doMakeColorScales() throws VisADException, RemoteException {
        this.colorScales = new ArrayList();
        if (this.colorScaleInfo == null) {
            this.colorScaleInfo = this.getDefaultColorScaleInfo();
        }
        ColorScale colorScale = new ColorScale(this.getColorScaleInfo());
        this.addDisplayable((Displayable)colorScale, this.timeHeightView, 8);
        this.colorScales.add(colorScale);
    }

    @Override
    public void addPropertiesComponents(JTabbedPane jtp) {
        super.addPropertiesComponents(jtp);
        if (this.timeHeightView != null) {
            jtp.add("Time Height View", this.timeHeightView.getPropertiesComponent());
        }
    }

    @Override
    protected void getViewMenuItems(List menus, boolean forMenuBar) {
        super.getViewMenuItems(menus, forMenuBar);
        menus.add("separator");
        if (forMenuBar) {
            JMenu csvMenu = this.timeHeightView.makeViewMenu();
            csvMenu.setText("Profiler View");
            menus.add(csvMenu);
        }
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        JCheckBox toggle = new JCheckBox("", this.isLatestOnLeft);
        toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerTimeHeightControl.this.isLatestOnLeft = ((JCheckBox)e.getSource()).isSelected();
                try {
                    ProfilerTimeHeightControl.this.setXAxisValues();
                    ProfilerTimeHeightControl.this.setYAxisValues();
                }
                catch (VisADException ve) {
                    DisplayControlBase.userMessage("couldn't set order");
                }
            }
        });
        if (this.compositeDataChoice != null) {
            this.stationsBox = new JComboBox(new Vector(this.compositeDataChoice.getDataChoices()));
            if (this.currentDataChoice != null) {
                this.stationsBox.setSelectedItem(this.currentDataChoice);
            }
            this.stationsBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        ProfilerTimeHeightControl.this.initStation((DataChoice)ProfilerTimeHeightControl.this.stationsBox.getSelectedItem());
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("setting station", exc);
                    }
                }
            });
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Stations: "), this.stationsBox, GuiUtils.hflow(Misc.newList(GuiUtils.rLabel(" Latest Data on Left: "), toggle))));
        } else {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Latest data on left: "), GuiUtils.leftCenter(toggle, GuiUtils.filler())));
        }
    }

    @Override
    public synchronized void dataChanged() {
        super.dataChanged();
        try {
            if (this.stationsBox != null) {
                this.initStation((DataChoice)this.stationsBox.getSelectedItem());
            } else {
                this.initStation(this.getDataChoice());
            }
        }
        catch (Exception exc) {
            ProfilerTimeHeightControl.logException("dataChanged", exc);
        }
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        try {
            this.setXAxisValues();
        }
        catch (Exception exc) {
            ProfilerTimeHeightControl.logException("applyPreferences", exc);
        }
    }

    @Override
    public void setLatestOnLeft(boolean yesorno) {
        this.isLatestOnLeft = yesorno;
    }

    @Override
    public boolean getLatestOnLeft() {
        return this.isLatestOnLeft;
    }

    public Color getForeground() {
        return this.timeHeightView.getForeground();
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.timeHeightView.getBackground();
    }

    public void setBackground(Color color) {
        this.background = color;
    }
}

