/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.ProfilerControl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.visad.display.FlowDisplayable;
import ucar.visad.display.WindBarbDisplayable;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;

public class ProfilerMultiStationControl
extends ProfilerControl {
    private boolean isPlanView = true;
    private Real currentVerticalInt = new Real(125.0);
    private FieldImpl fieldImpl;
    private FieldImpl workingFI;
    private boolean isSequence = false;
    private float currentLevel;
    private float levelValue = 17000.0f;
    private float initLevelValue = 3000.0f;
    private FlowDisplayable mappedDisplayable;
    private boolean displayIs3D = false;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!this.setData(dataChoice)) {
            return false;
        }
        FunctionType ftype = (FunctionType)this.fieldImpl.getType();
        FunctionType obFT = (FunctionType)ftype.getRange();
        RealTupleType rtt = obFT.getFlatRange();
        this.mappedDisplayable = new WindBarbDisplayable("profiler", rtt, true);
        this.addAttributedDisplayable(this.mappedDisplayable, 8);
        this.mappedDisplayable.setBarbOrientation(0);
        this.mappedDisplayable.setVisible(true);
        this.addDisplayable(this.mappedDisplayable);
        this.displayIs3D = this.isDisplay3D();
        while (!this.checkDataLevelValue(this.levelValue)) {
            this.levelValue *= 0.9f;
            this.currentVerticalInt = new Real((double)this.levelValue / 25.0);
        }
        if (this.levelValue < 5000.0f) {
            this.initLevelValue = 1000.0f;
        }
        this.loadData();
        return true;
    }

    public boolean checkDataLevelValue(float zlevel) throws VisADException, RemoteException {
        float interval = (float)this.currentVerticalInt.getValue();
        float zmin = zlevel - interval;
        float zmax = zlevel + interval;
        int i = 0;
        Set timeSet = this.fieldImpl.getDomainSet();
        if (i < timeSet.getLength()) {
            FlatField oneTimeFF = (FlatField)this.fieldImpl.getSample(i);
            for (int j = 0; j < oneTimeFF.getLength(); ++j) {
                Gridded3DSet tds = (Gridded3DSet)oneTimeFF.getDomainSet();
                float[][] latlonz = tds.getSamples(false);
                if (!(latlonz[2][j] >= zmin) || !(latlonz[2][j] <= zmax)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void loadData() throws VisADException, RemoteException {
        if (this.getIsPlanView() && this.workingFI != null) {
            this.resetDataVerticalLocation(new Real(0.0), this.initLevelValue, false);
            this.mappedDisplayable.loadData(this.workingFI);
        } else if (this.fieldImpl != null) {
            this.mappedDisplayable.loadData(this.fieldImpl);
        }
    }

    public GridDataInstance getGridDataInstance() {
        return (GridDataInstance)this.getDataInstance();
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        return new GridDataInstance(dataChoice, this.dataSelection, this.getRequestProperties());
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.setData(dataChoice)) {
            return false;
        }
        this.fieldImpl = this.getGridDataInstance().getGrid();
        if (this.fieldImpl == null) {
            return false;
        }
        if (this.mappedDisplayable != null) {
            this.loadData();
        }
        return true;
    }

    @Override
    protected JComponent doMakeExtraComponent() {
        if (this.getIsPlanView()) {
            JComboBox box = GuiUtils.createValueBox(this, "cmd.level", (int)this.initLevelValue, Misc.createIntervalList(500, (int)this.levelValue, 500), true);
            return GuiUtils.label("Plan level (m MSL): ", GuiUtils.wrap(box));
        }
        return this.doMakeVerticalIntervalComponent();
    }

    public void setIsPlanView(boolean value) {
        this.isPlanView = value;
    }

    public boolean getIsPlanView() {
        return this.isPlanView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        try {
            if (cmd.equals("cmd.level")) {
                this.setLevel(GuiUtils.getBoxValue((JComboBox)e.getSource()));
            } else if (cmd.equals("cmd.interval")) {
                this.setVerticalInterval(GuiUtils.getBoxValue((JComboBox)e.getSource()));
            } else {
                super.actionPerformed(e);
            }
        }
        catch (NumberFormatException nfe) {
            this.userErrorMessage("Incorrect number format");
        }
    }

    public void setLevel(float value) {
        this.levelValue = value;
        if (this.mappedDisplayable != null) {
            try {
                this.resetDataVerticalLocation(new Real(0.0), this.levelValue, false);
                this.mappedDisplayable.loadData(this.workingFI);
            }
            catch (Exception ve) {
                ProfilerMultiStationControl.logException("setLevel", ve);
            }
        }
    }

    public float getLevel() {
        return this.levelValue;
    }

    @Override
    public void setVerticalInterval(float value) {
        super.setVerticalInterval(value);
        if (!this.isPlanView && this.mappedDisplayable != null) {
            try {
                this.resetDataVerticalLocation(new Real(value), 0.0f, true);
                this.mappedDisplayable.loadData(this.workingFI);
            }
            catch (Exception ve) {
                ProfilerMultiStationControl.logException("setVerticalInterval", ve);
            }
        }
    }

    public void resetDataVerticalLocation(Real verticalInt, float zlevel, boolean use3D) throws VisADException, RemoteException {
        ArrayList<RealTuple> locList = new ArrayList<RealTuple>();
        ArrayList<RealTuple> dsList = new ArrayList<RealTuple>();
        ArrayList<RealTuple> seenLocations = new ArrayList<RealTuple>();
        if (verticalInt.getValue() != 0.0) {
            this.currentVerticalInt = verticalInt;
        }
        this.currentLevel = zlevel;
        float interval = (float)this.currentVerticalInt.getValue();
        float spacing = (float)verticalInt.getValue();
        float zmin = zlevel - interval;
        float zmax = zlevel + interval;
        Set timeSet = this.fieldImpl.getDomainSet();
        for (int i = 0; i < timeSet.getLength(); ++i) {
            FlatField oneTimeFF = (FlatField)this.fieldImpl.getSample(i);
            locList.clear();
            dsList.clear();
            int prvLevel = (int)zmin;
            for (int j = 0; j < oneTimeFF.getLength(); ++j) {
                RealTuple dirspd;
                RealTuple location;
                Gridded3DSet tds = (Gridded3DSet)oneTimeFF.getDomainSet();
                float[][] latlonz = tds.getSamples(false);
                if (use3D) {
                    if (!(latlonz[2][j] - (float)prvLevel >= spacing)) continue;
                    location = new RealTuple(new Real[]{new Real(latlonz[0][j]), new Real(latlonz[1][j]), new Real(latlonz[2][j])});
                    locList.add(location);
                    seenLocations.add(new RealTuple(new Real[]{new Real(latlonz[0][j]), new Real(latlonz[1][j])}));
                    dirspd = (RealTuple)oneTimeFF.getSample(j);
                    dsList.add(dirspd);
                    for (int idx = 0; idx < oneTimeFF.getLength(); ++idx) {
                        if (!(latlonz[2][idx] - (float)prvLevel >= spacing)) continue;
                        RealTuple tmpLoc = new RealTuple(new Real[]{new Real(latlonz[0][idx]), new Real(latlonz[1][idx])});
                        if (!seenLocations.contains(tmpLoc)) {
                            RealTuple locOther = new RealTuple(new Real[]{new Real(latlonz[0][idx]), new Real(latlonz[1][idx]), new Real(latlonz[2][idx])});
                            locList.add(locOther);
                            RealTuple dirspdOther = (RealTuple)oneTimeFF.getSample(idx);
                            dsList.add(dirspdOther);
                        }
                        seenLocations.add(tmpLoc);
                    }
                    prvLevel = (int)latlonz[2][j];
                    seenLocations.clear();
                    continue;
                }
                if (!(latlonz[2][j] >= zmin) || !(latlonz[2][j] <= zmax)) continue;
                location = new RealTuple(new Real[]{new Real(latlonz[0][j]), new Real(latlonz[1][j]), new Real(latlonz[2][j])});
                locList.add(location);
                dirspd = (RealTuple)oneTimeFF.getSample(j);
                dsList.add(dirspd);
            }
            Data[] ds = new RealTuple[dsList.size()];
            for (int jj = 0; jj < dsList.size(); ++jj) {
                ds[jj] = (RealTuple)dsList.get(jj);
            }
            if (ds.length == 0) {
                return;
            }
            FunctionType newonetimeFT = new FunctionType(RealTupleType.LatitudeLongitudeAltitude, ds[0].getType());
            int numPoints = locList.size();
            float[][] points = new float[3][numPoints];
            for (int curPoint = 0; curPoint < numPoints; ++curPoint) {
                points[0][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(0)).getValue();
                points[1][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(1)).getValue();
                points[2][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(2)).getValue();
            }
            Gridded3DSet locset = new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, points, numPoints);
            FlatField newonetimeFF = new FlatField(newonetimeFT, locset);
            newonetimeFF.setSamples(ds, false);
            if (i == 0 || this.workingFI == null) {
                this.workingFI = new FieldImpl(new FunctionType(((SetType)timeSet.getType()).getDomain(), newonetimeFF.getType()), timeSet);
            }
            this.workingFI.setSample(i, (Data)newonetimeFF);
        }
    }

    @Override
    public void setFlowScale(float value) {
        super.setFlowScale(value);
        if (this.mappedDisplayable != null) {
            this.mappedDisplayable.setFlowScale(value * 0.02f);
        }
    }

    @Override
    protected Range getInitialRange() throws RemoteException, VisADException {
        Range range = this.getDisplayConventions().getParamRange(this.paramName, this.displayUnit);
        if (range == null) {
            range = this.getRangeFromColorTable();
        }
        if (range == null) {
            return new Range(0.0, 100.0);
        }
        return range;
    }

    @Override
    public MapProjection getDataProjection() {
        MapProjection mp = null;
        try {
            FieldImpl data = this.fieldImpl;
            if (data != null && data instanceof FieldImpl) {
                try {
                    mp = GridUtil.getNavigation(GridUtil.getWholeSpatialDomain(data));
                }
                catch (Exception e) {
                    mp = null;
                }
            }
        }
        catch (Exception e) {
            ProfilerMultiStationControl.logException("Getting projection from data", e);
        }
        if (mp == null) {
            return null;
        }
        Rectangle2D.Float r2d = (Rectangle2D.Float)mp.getDefaultMapArea();
        float height = r2d.height;
        float width = r2d.width;
        float xx = r2d.x;
        float yy = r2d.y;
        if (height == 0.0f && width == 0.0f) {
            try {
                width = 2.0f;
                height = 2.0f;
                mp = new TrivialMapProjection(RealTupleType.SpatialEarth2DTuple, new Rectangle2D.Float(xx - 1.0f, yy - 1.0f, width, height));
            }
            catch (Exception e) {
                ProfilerMultiStationControl.logException(" getDataProjection", e);
            }
        }
        return mp;
    }

    private RealTuple getRealTupleForPoint(float rlat, float rlon) throws VisADException, RemoteException {
        RealTuple visadTup = this.earthToBoxTuple(new EarthLocationTuple(rlat, rlon, 0.0));
        Real[] reals = visadTup.getRealComponents();
        Real altreal = new Real((RealType)reals[2].getType(), 1.0);
        return new RealTuple(new Real[]{reals[0], reals[1]});
    }
}

