/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import visad.VisADException;

public abstract class ProfilerControl
extends DisplayControlImpl {
    protected final float scaleFactor = 0.02f;
    protected float flowScaleValue = 2.0f;
    protected float verticalIntervalValue = 250.0f;

    protected JComponent doMakeExtraComponent() {
        return null;
    }

    protected JComponent doMakeVerticalIntervalComponent() {
        JComboBox intervalBox = GuiUtils.createValueBox(this, "cmd.interval", (int)this.verticalIntervalValue, Misc.createIntervalList(250, 1000, 250), true);
        return GuiUtils.label("  Vertical interval (m): ", GuiUtils.wrap(intervalBox));
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        JPanel barbSizeBox = GuiUtils.wrap(GuiUtils.createValueBox(this, "cmd.barbsize", (int)this.flowScaleValue, Misc.createIntervalList(1, 10, 1), true));
        JComponent extra = this.doMakeExtraComponent();
        JPanel rightPanel = GuiUtils.leftCenter(extra != null ? GuiUtils.hflow(Misc.newList(barbSizeBox, extra)) : barbSizeBox, GuiUtils.filler());
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Windbarb size: "), rightPanel));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        try {
            if (cmd.equals("cmd.barbsize")) {
                this.setFlowScale(GuiUtils.getBoxValue((JComboBox)e.getSource()));
            } else if (cmd.equals("cmd.interval")) {
                this.setVerticalInterval(GuiUtils.getBoxValue((JComboBox)e.getSource()));
            } else {
                super.actionPerformed(e);
            }
        }
        catch (NumberFormatException nfe) {
            this.userErrorMessage("Incorrect number format");
        }
    }

    @Override
    public void initDone() {
        super.initDone();
        this.setFlowScale(this.flowScaleValue);
        this.setVerticalInterval(this.verticalIntervalValue);
    }

    public void setVerticalInterval(float value) {
        this.verticalIntervalValue = value;
    }

    public float getVerticalInterval() {
        return this.verticalIntervalValue;
    }

    public void setFlowScale(float f) {
        this.flowScaleValue = f;
    }

    public float getFlowScale() {
        return this.flowScaleValue;
    }
}

