/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.LineProbeControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Range;
import ucar.visad.display.Displayable;
import ucar.visad.display.ProfileLine;
import ucar.visad.display.XYDisplay;
import visad.CoordinateSystem;
import visad.Data;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;

public class ProfileControl
extends LineProbeControl {
    public static final String SHARE_PROFILE = "ProfileControl.SHARE_PROFILE";
    private XYDisplay profileDisplay;
    private FieldImpl myFieldImpl;
    private RealType parm;
    private RealType oldParmRT;
    private ProfileLine points;
    private ProfileLine line;
    private JLabel valueLabel;
    private boolean isSequence = false;
    private JLabel paramLabel;
    private int samplingMode;

    public ProfileControl() {
        this.setAttributeFlags(52);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.parm = RealType.getRealType("no_parameter_set");
        this.points = new ProfileLine("points");
        this.points.setPointSize(3.5f);
        this.points.setColor(Color.white);
        this.line = new ProfileLine("line");
        this.line.setLineWidth(1.5f);
        this.addAttributedDisplayable(this.line, 4);
        this.profileDisplay = new XYDisplay("vertprof", this.parm, RealType.Altitude);
        this.profileDisplay.setAspect(0.7, 1.0);
        this.addDisplayMaster(this.profileDisplay);
        this.profileDisplay.showAxisScales(true);
        this.paramLabel = new JLabel("                ");
        if (!this.setData(dataChoice)) {
            return false;
        }
        this.profileDisplay.setDisplayables(new Displayable[]{this.points, this.line, this.getInternalAnimation()});
        this.profileDisplay.draw();
        this.profileDisplay.getYAxisScale().setSnapToBox(true);
        this.doMakeProbe();
        this.samplingMode = this.getDefaultSamplingMode().equals("Weighted Average") ? 101 : 100;
        return true;
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            this.setViewParameters();
            this.loadProfile(this.getPosition());
        }
        catch (Exception exc) {
            ProfileControl.logException("initDone", exc);
        }
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Parameter:"), this.paramLabel));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Animation:"), GuiUtils.left(this.getAnimationWidget().getContents(false))));
        super.getControlWidgets(controlWidgets);
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.valueLabel = new JLabel(" ", 2);
        JComponent cmp = (JComponent)this.profileDisplay.getComponent();
        cmp.setPreferredSize(new Dimension(350, 400));
        return GuiUtils.topCenterBottom(this.valueLabel, cmp, this.doMakeWidgetComponent());
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws RemoteException, VisADException {
        if (!super.setData(dataChoice)) {
            return false;
        }
        if (this.paramLabel != null) {
            this.paramLabel.setText(dataChoice.toString());
        }
        this.myFieldImpl = this.getGridDataInstance().getGrid();
        this.isSequence = GridUtil.isTimeSequence(this.myFieldImpl);
        this.parm = this.getGridDataInstance().getRealType(0);
        this.setViewParameters();
        this.loadProfile(this.getPosition());
        return true;
    }

    private void displayProfileForCoord(FieldImpl fi, int NN) throws VisADException, RemoteException {
        FlatField ffld = this.isSequence ? (FlatField)fi.getSample(0) : (FlatField)fi;
        FunctionType ft = (FunctionType)ffld.getType();
        this.parm = (RealType)((RealTupleType)ft.getRange()).getComponent(0);
        RealType height = (RealType)ft.getDomain().getComponent(NN);
        RealTupleType domainType = new RealTupleType(RealType.Altitude);
        FunctionType pType = new FunctionType(domainType, this.parm);
        FunctionType profileType = null;
        FieldImpl profile = null;
        Gridded1DSet profileDomain = null;
        int numIters = 1;
        if (this.isSequence) {
            SampledSet timeDomain = (SampledSet)fi.getDomainSet();
            numIters = timeDomain.getLength();
            RealTupleType tMT = ((SetType)timeDomain.getType()).getDomain();
            profileType = new FunctionType(tMT, pType);
            profile = new FieldImpl(profileType, timeDomain);
        } else {
            profileType = pType;
        }
        for (int i = 0; i < numIters; ++i) {
            SampledSet ss = GridUtil.getSpatialDomain(fi, i);
            if (profileDomain == null || !GridUtil.isConstantSpatialDomain(fi)) {
                float[][] domainVals = ss.getSamples();
                if (!height.equals(RealType.Altitude)) {
                    domainVals = ss.getCoordinateSystem().toReference(domainVals, ss.getSetUnits());
                }
                try {
                    profileDomain = new Gridded1DSet((MathType)domainType, (float[][])new float[][]{domainVals[NN]}, domainVals[0].length, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, false);
                }
                catch (Exception e) {
                    break;
                }
            }
            FlatField ff = new FlatField(pType, profileDomain);
            if (this.isSequence) {
                ff.setSamples(((FlatField)fi.getSample(i)).getFloats(false));
                profile.setSample(i, (Data)ff);
                continue;
            }
            ff.setSamples(((FlatField)fi).getFloats(false));
            profile = ff;
        }
        this.points.setData(fi);
        if (profile != null) {
            this.line.setData(profile);
        }
        this.profileDisplay.reScale();
    }

    @Override
    protected void displayUnitChanged(Unit oldUnit, Unit newUnit) {
        super.displayUnitChanged(oldUnit, newUnit);
        Range r = this.getGridDataInstance().getRange(0);
        oldUnit = this.getGridDataInstance().getRawUnit(0);
        if (newUnit != null) {
            try {
                r = new Range(newUnit.toThis(r.getMin(), oldUnit), newUnit.toThis(r.getMax(), oldUnit));
            }
            catch (Exception exc) {
                ProfileControl.logException("Setting units", exc);
                return;
            }
            this.profileDisplay.setXDisplayUnit(newUnit);
        }
        this.profileDisplay.setXRange(r.getMin(), r.getMax());
    }

    @Override
    protected void probePositionChanged(RealTuple position) {
        try {
            this.loadProfile(position);
        }
        catch (Exception exc) {
            ProfileControl.logException("probePositionChanged", exc);
        }
    }

    public void loadProfile(RealTuple position) throws VisADException, RemoteException {
        Real[] reals;
        if (!this.getHaveInitialized()) {
            return;
        }
        if (this.myFieldImpl == null || position == null) {
            return;
        }
        LatLonPoint llp = null;
        RealTupleType rttype = (RealTupleType)position.getType();
        if (rttype.equals(RealTupleType.SpatialCartesian2DTuple)) {
            double[] values = position.getValues();
            EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{values[0], values[1], 1.0});
            llp = elt.getLatLonPoint();
        } else if (rttype.equals(RealTupleType.SpatialEarth2DTuple)) {
            reals = position.getRealComponents();
            llp = new LatLonTuple(reals[1], reals[0]);
        } else if (rttype.equals(RealTupleType.LatitudeLongitudeTuple)) {
            reals = position.getRealComponents();
            llp = new LatLonTuple(reals[0], reals[1]);
        } else {
            throw new VisADException("Can't convert position to navigable point");
        }
        FieldImpl newFI = GridUtil.getProfileAtLatLonPoint(this.myFieldImpl, llp, this.getDefaultSamplingModeValue());
        if (newFI != null) {
            this.displayProfileForCoord(newFI, 2);
        }
        if (this.valueLabel != null) {
            this.valueLabel.setText(this.getDisplayConventions().formatLatLonPoint(llp));
        }
    }

    private void setViewParameters() throws VisADException, RemoteException {
        if (this.parm != null) {
            this.profileDisplay.setXAxisType(this.parm);
            this.profileDisplay.getXAxisScale().setSnapToBox(true);
            if (this.paramLabel != null) {
                this.profileDisplay.getXAxisScale().setTitle(this.paramLabel.getText());
            }
            Unit units = this.getDisplayUnit();
            this.displayUnitChanged(units, this.getDisplayUnit(units));
        }
    }
}

