/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.ProbeControl;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.util.MidiManager;
import ucar.unidata.util.MidiProperties;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.visad.Util;
import visad.Data;
import visad.FieldImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.Text;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;

public class ProbeRowInfo {
    private String extra = "";
    private Data timeSample;
    private FieldImpl pointSample;
    private FieldImpl workingGrid;
    private EarthLocation lastPoint;
    private Set timeSet;
    private Unit unit;
    private Real level;
    private Real altitude;
    private int samplingMode;
    private MidiProperties midiProperties;
    private Object displayValue;
    private DataInstance dataInstance;
    private String pointParameter;
    private String stationName = "";
    private int pointIndex = -1;
    private MidiManager midiManager;
    private LineState lineState = new LineState(null, 1.0f, 0);
    private TupleType tupleType;

    public ProbeRowInfo() {
    }

    public ProbeRowInfo(ProbeControl control) {
        this.samplingMode = control.getDefaultSamplingModeValue();
    }

    public ProbeRowInfo(Real level, Real alt, int mode, Unit unit, MidiProperties midiProperties) {
        this.level = level;
        this.altitude = alt;
        this.samplingMode = mode;
        this.unit = unit;
        this.midiProperties = midiProperties;
    }

    public ProbeRowInfo(ProbeControl control, DataInstance dataInstance) {
        this(control);
        this.dataInstance = dataInstance;
    }

    public boolean isGrid() {
        return this.dataInstance instanceof GridDataInstance;
    }

    public boolean isPoint() {
        return !this.isGrid();
    }

    protected void setExtra(String s) {
        this.extra = s;
    }

    protected String getExtra() {
        return this.extra;
    }

    protected void clearCachedSamples() {
        this.pointSample = null;
        this.lastPoint = null;
        this.workingGrid = null;
        this.tupleType = null;
    }

    protected void setTimeSample(Data rt) throws VisADException, RemoteException {
        this.timeSample = rt == null ? null : (rt.isMissing() ? null : rt);
    }

    protected Data getTimeSample() {
        return this.timeSample;
    }

    protected void initWith(ProbeRowInfo that) {
        this.displayValue = that.displayValue;
        this.timeSample = that.timeSample;
        this.unit = that.unit;
        this.level = that.level;
        this.altitude = that.altitude;
        this.samplingMode = that.samplingMode;
        this.pointParameter = that.pointParameter;
        this.stationName = that.stationName;
        if (that.midiProperties != null) {
            this.midiProperties = new MidiProperties(that.midiProperties);
        }
        this.lineState.setChartName(that.lineState.getChartName());
        if (that.lineState.getRange() != null) {
            this.lineState.setRange(new Range(that.lineState.getRange()));
        }
    }

    protected void showSoundDialog(ProbeControl control) throws VisADException, RemoteException {
        if (this.midiProperties == null) {
            this.midiProperties = new MidiProperties();
        }
        if (this.midiProperties.showPropertyDialog(control.getWindow())) {
            MidiManager mm = this.getMidiManager();
            mm.setInstrument(this.midiProperties.getInstrumentName());
            try {
                control.updatePosition();
            }
            catch (Exception exc) {
                ProbeControl.logException("After changing sound", exc);
            }
        }
    }

    public String toString() {
        if (this.dataInstance == null) {
            return "";
        }
        return "" + this.dataInstance.getParamName();
    }

    protected void playSound(double value) {
        Range range = null;
        if (this.midiProperties == null || this.midiProperties.getMuted()) {
            return;
        }
        range = this.isGrid() ? this.getGridDataInstance().getRange(0) : new Range(0.0, 100.0);
        int note = (int)((double)this.midiProperties.getLowNote() + range.getPercent(value) * (double)(this.midiProperties.getHighNote() - this.midiProperties.getLowNote()));
        this.getMidiManager().play(note, 500L);
    }

    protected void setDisplayValue(Object value) {
        this.displayValue = value;
    }

    protected Object getDisplayValue() {
        return this.displayValue;
    }

    public GridDataInstance getGridDataInstance() {
        if (!this.isGrid()) {
            return null;
        }
        return (GridDataInstance)this.dataInstance;
    }

    public DataInstance getDataInstance() {
        return this.dataInstance;
    }

    protected void setDataInstance(DataInstance di) {
        this.dataInstance = di;
    }

    private MidiManager getMidiManager() {
        if (this.midiManager == null) {
            this.midiManager = new MidiManager(this.midiProperties);
        }
        return this.midiManager;
    }

    public TupleType getTupleType() throws VisADException, RemoteException {
        if (this.tupleType != null) {
            return this.tupleType;
        }
        if (this.isGrid()) {
            return null;
        }
        FieldImpl pointObs = (FieldImpl)this.getDataInstance().getData();
        if (pointObs == null) {
            return null;
        }
        int numObs = pointObs.getDomainSet().getLength();
        if (numObs == 0) {
            return null;
        }
        PointOb ob = (PointOb)pointObs.getSample(0);
        this.tupleType = (TupleType)((Tuple)ob.getData()).getType();
        return this.tupleType;
    }

    protected Real getRealValue() throws VisADException, RemoteException {
        return this.getRealValue(this.timeSample);
    }

    protected Real getRealValue(Data timeSample) throws VisADException, RemoteException {
        if (timeSample == null) {
            return null;
        }
        if (timeSample instanceof Real) {
            return (Real)timeSample;
        }
        if (timeSample instanceof FieldImpl) {
            Data data = ((FieldImpl)timeSample).getSample(0);
            if (data instanceof Real) {
                return (Real)data;
            }
            if (data instanceof PointOb) {
                PointOb ob = (PointOb)data;
                Tuple t = (Tuple)ob.getData();
                this.getPointIndex();
                if (this.pointIndex < 0) {
                    return null;
                }
                return (Real)t.getComponent(this.pointIndex);
            }
            return null;
        }
        return (Real)((RealTuple)timeSample).getComponent(0);
    }

    public String getPointParameterName() throws VisADException, RemoteException {
        if (this.pointParameter == null) {
            TupleType tt = this.getTupleType();
            if (tt == null) {
                return null;
            }
            for (int i = 0; i < tt.getDimension(); ++i) {
                if (!(tt.getComponent(i) instanceof RealType)) continue;
                this.setPointParameter(Util.cleanTypeName(tt.getComponent(i).toString()));
                break;
            }
        }
        return this.pointParameter;
    }

    public int getPointIndex() throws VisADException, RemoteException {
        if (this.pointIndex >= 0) {
            return this.pointIndex;
        }
        this.getPointParameterName();
        if (this.pointParameter != null) {
            TupleType tt = this.getTupleType();
            if (tt == null) {
                return -1;
            }
            for (int i = 0; i < tt.getDimension(); ++i) {
                if (!Util.cleanTypeName(tt.getComponent(i).toString()).equals(this.pointParameter)) continue;
                this.pointIndex = i;
                break;
            }
        }
        return this.pointIndex;
    }

    public void setUnit(Unit value) {
        Unit oldUnit = this.unit;
        this.unit = value;
        this.lineState.setRange(Util.convertRange(this.lineState.getRange(), oldUnit, value));
    }

    protected void setWorkingGrid(FieldImpl grid) {
        this.workingGrid = grid;
    }

    public FieldImpl getWorkingGrid() {
        return this.workingGrid;
    }

    protected void setPointSample(FieldImpl sample, EarthLocation elt) throws VisADException, RemoteException {
        this.pointSample = sample;
        this.lastPoint = elt;
    }

    public void setStationName(PointOb ob, DisplayControlImpl control) throws VisADException, RemoteException {
        Tuple t = (Tuple)ob.getData();
        Data[] comps = t.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Text)) continue;
            String name = StringUtil.replace(comps[i].getType().toString(), "(Text)", "").toLowerCase();
            if (name.toLowerCase().equals("station")) {
                this.stationName = comps[i].toString();
                return;
            }
            String canon = DataAlias.aliasToCanonical(name);
            if (canon == null || !canon.equals("IDN") && !canon.equals("ID")) continue;
            this.stationName = comps[i].toString();
            return;
        }
        this.stationName = control.getDisplayConventions().formatLatLonPoint(ob.getEarthLocation().getLatLonPoint());
    }

    protected Set getTimeSet() throws VisADException, RemoteException {
        if (this.pointSample != null) {
            return this.pointSample.getDomainSet();
        }
        return null;
    }

    public FieldImpl getPointSample() {
        return this.pointSample;
    }

    public FieldImpl getPointSample(EarthLocation elt) {
        if (!Misc.equals(elt, this.lastPoint)) {
            this.pointSample = null;
        }
        return this.pointSample;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setLevel(Real value) {
        this.level = value;
        this.clearCachedSamples();
    }

    public Real getLevel() {
        return this.level;
    }

    public void setAltitude(Real value) {
        this.altitude = value;
        this.clearCachedSamples();
    }

    public Real getAltitude() {
        return this.altitude;
    }

    public void setSamplingMode(int value) {
        this.samplingMode = value;
        this.clearCachedSamples();
    }

    public int getSamplingMode() {
        return this.samplingMode;
    }

    public void setMidiProperties(MidiProperties value) {
        this.midiProperties = value;
    }

    public MidiProperties getMidiProperties() {
        return this.midiProperties;
    }

    public void setLineState(LineState value) {
        this.lineState = value;
    }

    public LineState getLineState() {
        return this.lineState;
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setPointParameter(String value) {
        this.unit = null;
        this.pointParameter = value;
        this.pointIndex = -1;
        this.lastPoint = null;
    }

    public String getPointParameter() {
        return this.pointParameter;
    }
}

