/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.vecmath.Point3d;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.ProbeRowInfo;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.idv.control.chart.TimeSeriesChart;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.MidiProperties;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.ShapeUtility;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.PointProbe;
import ucar.visad.display.SelectorPoint;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADRay;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.util.DataUtility;

public class ProbeControl
extends DisplayControlImpl
implements DisplayableData.DragAdapter {
    public static final String SHARE_POSITION = "ProbeControl.SHARE_POSITION";
    public static final String SHARE_CHOICES = "ProbeControl.SHARE_CHOICES";
    public static final String SHARE_METHODS = "ProbeControl.SHARE_METHODS";
    public static final String SHARE_LEVELS = "ProbeControl.SHARE_LEVELS";
    public static final int COL_NAME = 0;
    public static final int COL_VALUE = 1;
    public static final int COL_EXTRA = 2;
    public static final int COL_LEVEL = 3;
    public static final int COL_SAMPLING = 4;
    public static final int NUM_COLS = 5;
    private LatLonWidget latLonWidget;
    private JComponent aniWidget;
    private boolean xFixed = false;
    private boolean yFixed = false;
    private boolean zFixed = false;
    private boolean updatePending = false;
    private boolean keepProbeAtHeight = true;
    private double probeRadius = 1.0;
    private JLabel timeLabel;
    private Real lastProbeAltitude;
    private List<ProbeRowInfo> infos = new ArrayList<ProbeRowInfo>();
    private Object INFO_MUTEX = new Object();
    private List _levels;
    private List _units;
    private List _altitudes;
    private List _methods;
    private List _sounds;
    private List times = new ArrayList();
    private JTable paramsTable;
    private JComponent tablePanel;
    JPanel panel;
    private boolean amExporting = false;
    private AbstractTableModel tableModel;
    private PointProbe probe;
    private String positionText;
    private RealTuple initPosition;
    private EarthLocation initLocation;
    private DisplayableData timeData;
    private String[] samplingLabels = new String[]{"Weighted Average", "Nearest Neighbor"};
    private String dataTemplate;
    private JLabel sideLegendReadout;
    private String marker;
    private TimeSeriesChart timeSeries;
    private boolean showTable = true;
    private boolean showTableInLegend = true;
    private boolean showSunriseSunset = false;
    private RealTupleType globePositionType;
    private JSlider probeSizeSlider;
    private GuiUtils.ColorSwatch probeColorSwatch;
    private JComboBox shapeCbx;
    private JCheckBox columnsCbx;

    public ProbeControl() {
        this.setAttributeFlags(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(List choices) throws VisADException, RemoteException {
        ProbeRowInfo info;
        int i;
        boolean singleTime = true;
        for (i = 0; i < choices.size(); ++i) {
            Set set;
            info = this.getRowInfo(i);
            Data data = info.getDataInstance().getData();
            if (!(data instanceof FieldImpl) || (set = ((FieldImpl)data).getDomainSet()) == null || set.getLength() <= 1) continue;
            singleTime = false;
            break;
        }
        if (singleTime) {
            ProbeControl.userMessage("Select at least two times for a time series");
            return false;
        }
        if (this._levels != null && this.infos.size() == 0) {
            for (i = 0; i < this._levels.size(); ++i) {
                Real level = (Real)Misc.safeGet(this._levels, i);
                Real alt = (Real)Misc.safeGet(this._altitudes, i);
                Object method = Misc.safeGet(this._methods, i);
                int theMethod = this.getDefaultSamplingModeValue();
                if (method != null) {
                    if (method instanceof TwoFacedObject) {
                        method = ((TwoFacedObject)method).getId();
                    }
                    theMethod = (Integer)method;
                }
                Unit unit = (Unit)Misc.safeGet(this._units, i);
                MidiProperties sound = (MidiProperties)Misc.safeGet(this._sounds, i);
                this.infos.add(new ProbeRowInfo(level, alt, theMethod, unit, sound));
            }
        }
        for (i = 0; i < choices.size(); ++i) {
            info = null;
            try {
                info = this.getRowInfo(i);
            }
            catch (BadDataException bde) {
                this.removeDataChoice((DataChoice)choices.get(i));
                this.infos.remove(i);
                continue;
            }
            finally {
                this.showNormalCursor();
            }
            if (info == null) {
                return false;
            }
            if (this.checkIfDataOk(info.getDataInstance())) continue;
            return false;
        }
        ActionListener llListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ProbeControl.this.handleLatLonWidgetChange();
            }
        };
        this.latLonWidget = new LatLonWidget("Lat: ", "Lon: ", "Alt: ", llListener);
        this.timeLabel = new JLabel("   ");
        this.getInternalAnimation();
        this.aniWidget = this.getAnimationWidget().getContents();
        if (this.inGlobeDisplay()) {
            RealType[] components = new RealType[]{RealType.XAxis, RealType.YAxis, RealType.ZAxis};
            this.globePositionType = new RealTupleType(components, null, null);
            this.probe = new PointProbe(new RealTuple(this.globePositionType, new double[]{0.0, 0.0, 0.0}));
            this.probe.getSelectorPoint().setDragAdapter(this);
        } else {
            this.probe = new PointProbe(0.0, 0.0, 0.0);
        }
        if (this.marker != null) {
            this.probe.setMarker(SelectorPoint.reduce(ShapeUtility.makeShape(this.marker)));
        }
        this.probe.setFixed(this.xFixed, this.yFixed, this.zFixed);
        this.probe.setAutoSize(true);
        this.probe.setVisible(true);
        this.probe.addPropertyChangeListener(this);
        if (this.initPosition != null) {
            this.probe.setPosition(this.initPosition);
        } else if (this.initLocation != null) {
            this.setEarthLocation(this.initLocation);
        }
        this.addDisplayable((Displayable)this.probe, 4);
        this.setContents(this.doMakeContents());
        if (this.getPointSize() != 1.0f) {
            this.probe.setPointSize(this.getPointSize());
        } else {
            this.probe.setPointSize(this.getDisplayScale());
        }
        return true;
    }

    @Override
    public void initDone() {
        try {
            super.initDone();
            if (this.initPosition == null && this.initLocation == null) {
                if (this.inGlobeDisplay()) {
                    this.resetProbePosition();
                } else {
                    double[] screenCenter = this.getScreenCenter();
                    this.probe.setPosition(new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{screenCenter[0], screenCenter[1], 0.0}));
                }
            }
            this.setTimesForAnimation();
            this.updatePosition();
            this.doMoveProbe();
        }
        catch (Exception exc) {
            ProbeControl.logException("In init done", exc);
        }
    }

    @Override
    protected void addPropertiesComponents(JTabbedPane jtp) {
        super.addPropertiesComponents(jtp);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(GuiUtils.rLabel("Size:"));
        this.probeSizeSlider = new JSlider(1, 2000, (int)(this.getPointSize() * 100.0f));
        comps.add(this.probeSizeSlider);
        this.probeColorSwatch = new GuiUtils.ColorSwatch(this.getColor(), "Probe Color");
        comps.add(GuiUtils.rLabel("Color:"));
        comps.add(GuiUtils.left(this.probeColorSwatch));
        TwoFacedObject selected = null;
        Vector<TwoFacedObject> shapes = new Vector<TwoFacedObject>();
        for (int i = 0; i < ShapeUtility.SHAPES.length; ++i) {
            TwoFacedObject tof = ShapeUtility.SHAPES[i];
            if (Misc.equals(tof.getId(), this.marker)) {
                selected = tof;
            }
            shapes.add(tof);
        }
        this.shapeCbx = new JComboBox(shapes);
        if (selected != null) {
            this.shapeCbx.setSelectedItem(selected);
        }
        comps.add(GuiUtils.rLabel("Shape:"));
        comps.add(GuiUtils.left(this.shapeCbx));
        jtp.addTab("Probe", GuiUtils.top(GuiUtils.formLayout(comps)));
    }

    @Override
    public boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        this.setPointSize((float)((double)this.probeSizeSlider.getValue() / 100.0));
        try {
            this.setColor(this.probeColorSwatch.getColor());
            TwoFacedObject tfo = (TwoFacedObject)this.shapeCbx.getSelectedItem();
            this.setMarker(tfo.getId().toString());
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        return true;
    }

    @Override
    public String getColorWidgetLabel() {
        return "Probe Color";
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        items.add("separator");
        ArrayList<JMenuItem> paramItems = new ArrayList<JMenuItem>();
        paramItems.add(GuiUtils.makeCheckboxMenuItem("Show Parameter Table", this, "showTable", null));
        paramItems.add(GuiUtils.makeCheckboxMenuItem("Show Readout In Legend", this, "showTableInLegend", null));
        paramItems.add(this.doMakeChangeParameterMenuItem());
        List choices = this.getDataChoices();
        for (int i = 0; i < choices.size(); ++i) {
            paramItems.addAll(this.getParameterMenuItems(i));
        }
        items.add(GuiUtils.makeMenu("Parameters", paramItems));
        JMenu chartMenu = new JMenu("Chart");
        items.add(chartMenu);
        chartMenu.add(GuiUtils.makeCheckboxMenuItem("Show Thumbnail in Legend", this.getChart(), "showThumb", null));
        chartMenu.add(GuiUtils.makeCheckboxMenuItem("Show Sunrise/Sunset Times", this, "showSunriseSunset", null));
        ArrayList chartMenuItems = new ArrayList();
        this.getChart().addViewMenuItems(chartMenuItems);
        GuiUtils.makeMenu(chartMenu, chartMenuItems);
        JMenu probeMenu = new JMenu("Probe");
        items.add(probeMenu);
        JMenu posMenu = new JMenu("Position");
        probeMenu.add(posMenu);
        posMenu.add(GuiUtils.makeMenuItem("Reset Probe Position", this, "resetProbePosition"));
        if (this.inGlobeDisplay()) {
            posMenu.add(GuiUtils.makeCheckboxMenuItem("Keep probe at height", this, "keepProbeAtHeight", null));
        } else {
            posMenu.add(GuiUtils.makeCheckboxMenuItem("Lock X Axis", this, "xFixed", null));
            posMenu.add(GuiUtils.makeCheckboxMenuItem("Lock Y Axis", this, "yFixed", null));
            posMenu.add(GuiUtils.makeCheckboxMenuItem("Lock Z Axis", this, "zFixed", null));
        }
        probeMenu.add(this.doMakeChangeColorMenu("Color"));
        JMenu sizeMenu = new JMenu("Size");
        probeMenu.add(sizeMenu);
        sizeMenu.add(GuiUtils.makeMenuItem("Increase", this, "increaseProbeSize"));
        sizeMenu.add(GuiUtils.makeMenuItem("Decrease", this, "decreaseProbeSize"));
        JMenu shapeMenu = new JMenu("Probe Shape");
        probeMenu.add(shapeMenu);
        for (int i = 0; i < ShapeUtility.SHAPES.length; ++i) {
            TwoFacedObject tof = ShapeUtility.SHAPES[i];
            String lbl = tof.toString();
            if (Misc.equals(tof.getId(), this.marker)) {
                lbl = ">" + lbl;
            }
            JMenuItem mi = GuiUtils.makeMenuItem(lbl, this, "setMarker", tof.getId());
            shapeMenu.add(mi);
        }
        GuiUtils.limitMenuSize(shapeMenu, "Shape Group ", 10);
    }

    @Override
    protected boolean shouldAddAnimationListener() {
        return true;
    }

    public void setEarthLocation(EarthLocation el) {
        try {
            if (this.probe == null) {
                this.initLocation = el;
                return;
            }
            double[] xyz = this.earthToBox(el);
            this.resetProbePosition(xyz[0], xyz[1], xyz[2]);
            this.updatePosition();
        }
        catch (Exception exc) {
            ProbeControl.logException("Error setting probe position", exc);
        }
    }

    @Override
    public void relocateDisplay(LatLonRect originalBounds, LatLonRect newBounds, boolean useDataProjection) {
        super.relocateDisplay(originalBounds, newBounds, false);
        double latRatio = 0.5;
        double lonRatio = 0.5;
        EarthLocationTuple el = null;
        try {
            double[] oldpvalues = this.probe.getPosition().getValues();
            el = (EarthLocationTuple)this.boxToEarth(new double[]{oldpvalues[0], oldpvalues[1], oldpvalues[2]}, false);
            if (originalBounds != null) {
                if (oldpvalues == null || oldpvalues.length != 3) {
                    return;
                }
                latRatio = (el.getLatitude().getValue() - originalBounds.getLatMin()) / (originalBounds.getLatMax() - originalBounds.getLatMin());
                lonRatio = (Misc.normalizeLongitude(el.getLongitude().getValue()) - originalBounds.getLonMin()) / (originalBounds.getLonMax() - originalBounds.getLonMin());
                if ((lonRatio = Math.abs(lonRatio)) > 1.0) {
                    lonRatio = 0.5;
                    latRatio = 0.5;
                }
            }
        }
        catch (Exception oldpvalues) {
            // empty catch block
        }
        double deltaLat = newBounds.getLatMax() - newBounds.getLatMin();
        double deltaLon = newBounds.getLonMax() - newBounds.getLonMin();
        LatLonPointImpl lowerLeft = newBounds.getLowerLeftPoint();
        double nlat = lowerLeft.getLatitude() + deltaLat * latRatio;
        double nlon = lowerLeft.getLongitude() + deltaLon * lonRatio;
        double nalt = 0.0;
        try {
            if (el != null) {
                nalt = el.getAltitude().getValue();
            }
            EarthLocation newel = ProbeControl.makeEarthLocation(nlat, nlon, nalt);
            this.setEarthLocation(newel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println("ProbeControl.relocate deltaLat = " + deltaLat + " deltaLon = " + deltaLon);
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        try {
            dsd.addPropertyValue(new Boolean(this.getChart().getShowThumb()), "showThumbNail", "Show Thumbnail", "Probe");
            dsd.addPropertyValue(this.getEarthLocationFromWidget(), "earthLocation", "Probe Position", "Probe");
            dsd.addPropertyValue(this.getInfos(), "infos", "Probe parameters", "Probe");
        }
        catch (Exception exc) {
            ProbeControl.logException("Error getting location", exc);
        }
        super.addDisplaySettings(dsd);
    }

    private EarthLocation getEarthLocationFromWidget() throws VisADException, RemoteException {
        double lat = this.latLonWidget.getLat();
        double lon = this.latLonWidget.getLon();
        double alt = this.latLonWidget.getAlt();
        return ProbeControl.makeEarthLocation(lat, lon, alt);
    }

    private void updateLatLonWidget(EarthLocation elt) {
        if (this.latLonWidget == null) {
            return;
        }
        LatLonPoint llp = elt.getLatLonPoint();
        this.latLonWidget.setLat(this.getDisplayConventions().formatLatLon(llp.getLatitude().getValue()));
        double lon = Misc.normalizeLongitude(llp.getLongitude().getValue());
        this.latLonWidget.setLon(this.getDisplayConventions().formatLatLon(lon));
        this.latLonWidget.setAlt(this.getDisplayConventions().formatAltitude(elt.getAltitude()));
    }

    private void handleLatLonWidgetChange() {
        try {
            this.setEarthLocation(this.getEarthLocationFromWidget());
        }
        catch (Exception exc) {
            ProbeControl.logException("Error setting lat/lon", exc);
        }
    }

    public void resetProbePosition() {
        if (this.inGlobeDisplay()) {
            try {
                Point3d p = new Point3d(0.0, 0.0, 1.0);
                NavigatedDisplay navDisplay = this.getNavigatedDisplay();
                navDisplay.applyRotation(p);
                this.probe.setPosition(new RealTuple(this.globePositionType, new double[]{p.x, p.y, p.z}));
            }
            catch (Exception exc) {
                ProbeControl.logException("Resetting probe position", exc);
            }
        } else {
            this.resetProbePosition(0.0, 0.0, 0.0);
        }
    }

    public void resetProbePosition(double lat, double lon, double alt) {
        try {
            if (this.probe == null) {
                return;
            }
            this.probe.setPosition(new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{lat, lon, alt}));
        }
        catch (Exception exc) {
            ProbeControl.logException("Resetting probe position", exc);
        }
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        JMenuItem mi = new JMenuItem("Change Display Format...");
        items.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String newFormat = GuiUtils.getInput("Enter a new value readout format:", " Format: ", ProbeControl.this.dataTemplate, null, " (Use HTML with %value%, %unit%, %rawvalue%, %rawunit%)", "Change Display Format");
                if (newFormat != null) {
                    ProbeControl.this.dataTemplate = newFormat;
                    ProbeControl.this.doMoveProbe();
                }
            }
        });
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (this.probe != null && dataId.equals(SHARE_POSITION)) {
            try {
                if (data[0] instanceof EarthLocationTuple) {
                    EarthLocationTuple elt = (EarthLocationTuple)data[0];
                    data[0] = this.earthToBoxTuple(elt);
                }
                this.probe.setPosition((RealTuple)data[0]);
            }
            catch (Exception exc) {
                ProbeControl.logException("receiveShareData.position", exc);
            }
            return;
        }
        if (dataId.equals(SHARE_CHOICES)) {
            try {
                this.processNewData((List)data[0]);
            }
            catch (Exception exc) {
                ProbeControl.logException("receiveShareData.data", exc);
            }
            return;
        }
        if (dataId.equals(SHARE_METHODS)) {
            try {
                this.doMoveProbe();
                this.fireStructureChanged();
            }
            catch (Exception exc) {
                ProbeControl.logException("receiveShareData.data", exc);
            }
            return;
        }
        if (dataId.equals(SHARE_LEVELS)) {
            try {
                this.doMoveProbe();
                this.fireStructureChanged();
            }
            catch (Exception exc) {
                ProbeControl.logException("receiveShareData.data", exc);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    @Override
    protected String getLongParamName() {
        String paramName = "Params: ";
        List choices = this.getDataChoices();
        if (choices == null) {
            System.err.println("Probe data choices are null");
            return "";
        }
        for (int i = 0; i < choices.size(); ++i) {
            ProbeRowInfo rowInfo = this.getRowInfo(i);
            if (i > 0) {
                paramName = paramName + ", ";
            }
            paramName = paramName + rowInfo.getDataInstance().getDataChoice().getName();
            if (i > 3) break;
        }
        if (choices.size() > 3) {
            paramName = paramName + ", ...";
        }
        return paramName;
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        this.doMoveProbe();
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList("%position%"));
        labels.addAll(Misc.newList("Probe Position"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        patterns.add("%position%");
        values.add(this.positionText);
    }

    @Override
    protected Set getDataTimeSet() throws RemoteException, VisADException {
        Animation animation = this.getInternalAnimation();
        if (animation != null) {
            return animation.getSet();
        }
        return null;
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        this.resetData(true);
    }

    protected void resetData(boolean clearCache) throws VisADException, RemoteException {
        if (clearCache) {
            this.clearCachedSamples();
        }
        this.updateLegendLabel();
        this.setTimesForAnimation();
        this.doMoveProbe();
        this.fireStructureChanged();
    }

    private void setTimesForAnimation() throws VisADException, RemoteException {
        Set myTimes = this.calculateTimeSet();
        if (myTimes == null) {
            return;
        }
        this.getAnimationWidget().setBaseTimes(myTimes);
    }

    @Override
    protected void addNewData(List newChoices) throws VisADException, RemoteException {
        this.processNewData(newChoices);
        this.doShare((Object)SHARE_CHOICES, newChoices);
    }

    private void copyParameter(int row) {
        try {
            DataChoice dc = this.getDataChoiceAtRow(row);
            if (dc == null) {
                return;
            }
            ProbeRowInfo oldInfo = this.getRowInfo(row);
            dc = dc.createClone();
            this.appendDataChoices(Misc.newList(dc));
            List choices = this.getDataChoices();
            ProbeRowInfo newRowInfo = this.getRowInfo(choices.size() - 1, false);
            newRowInfo.initWith(oldInfo);
            newRowInfo.setDataInstance(oldInfo.getDataInstance());
            this.resetData(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processNewData(List newChoices) throws VisADException, RemoteException {
        ArrayList<ProbeRowInfo> newInfos = new ArrayList<ProbeRowInfo>();
        this.showWaitCursor();
        for (int i = 0; i < newChoices.size(); ++i) {
            ProbeRowInfo info = new ProbeRowInfo(this);
            newInfos.add(info);
            DataChoice dc = (DataChoice)newChoices.get(i);
            this.initRowInfo(info, dc);
        }
        this.showNormalCursor();
        this.appendDataChoices(newChoices);
        this.infos.addAll(newInfos);
        this.resetData();
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        if (this.sideLegendReadout == null) {
            this.sideLegendReadout = new JLabel("<html><br></html>");
        }
        return GuiUtils.vbox(parentComp, this.sideLegendReadout, this.getChart().getThumb());
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        labels.add(this.positionText);
    }

    private Set calculateTimeSet() {
        List choices = this.getDataChoices();
        if (choices.isEmpty()) {
            return null;
        }
        Set newSet = null;
        for (int i = 0; i < choices.size(); ++i) {
            try {
                RealTupleType setType;
                ProbeRowInfo info = this.getRowInfo(i);
                Set set = info.getTimeSet();
                if (set == null || !(setType = ((SetType)set.getType()).getDomain()).equals(RealTupleType.Time1DTuple)) continue;
                if (newSet == null) {
                    newSet = set;
                    continue;
                }
                newSet = newSet.merge1DSets(set);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newSet;
    }

    public void setPosition(RealTuple p) {
        this.initPosition = p;
    }

    public RealTuple getPosition() throws VisADException, RemoteException {
        return this.probe != null ? this.probe.getPosition() : null;
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        this.probe = null;
        this.tableModel = null;
        this.infos = null;
        super.doRemove();
    }

    @Override
    protected void timeChanged(Real time) {
        GuiUtils.invokeInSwingThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProbeControl.this.updateTime();
                    ProbeControl.this.getChart().timeChanged();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("changePosition", exc);
                }
            }
        });
        super.timeChanged(time);
    }

    @Override
    public Image getImage(String what) throws Exception {
        if (what != null && what.equals("chart")) {
            this.setMainPanelDimensions();
            return ImageUtils.getImage(this.getChart().getContents());
        }
        return super.getImage(what);
    }

    @Override
    public boolean handleDragDirect(VisADRay ray, boolean first, int mouseModifiers) {
        return true;
    }

    @Override
    public boolean handleAddPoint(float[] x) {
        return true;
    }

    @Override
    public boolean constrainDragPoint(float[] position) {
        float x = position[0];
        float y = position[1];
        float z = position[2];
        double length = new Point3d(0.0, 0.0, 0.0).distance(new Point3d((double)x, (double)y, (double)z));
        if (!this.keepProbeAtHeight) {
            this.probeRadius = length;
            return true;
        }
        if (length != 0.0) {
            double newx = (double)x * (this.probeRadius / length);
            double newy = (double)y * (this.probeRadius / length);
            double newz = (double)z * (this.probeRadius / length);
            position[0] = (float)newx;
            position[1] = (float)newy;
            position[2] = (float)newz;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.getHaveInitialized() || !this.getActive()) {
            return;
        }
        if (evt.getPropertyName().equals("SelectorDisplay.position")) {
            try {
                if (this.updatePending) {
                    return;
                }
                RealTuple position = this.probe.getPosition();
                this.updatePending = true;
                this.updatePosition(position);
                this.doShare((Object)SHARE_POSITION, position);
            }
            catch (Exception exc) {
                ProbeControl.logException("Probe moved", exc);
            }
        } else {
            super.propertyChange(evt);
        }
    }

    public Real[] getLevelsAtRow(int row) {
        ProbeRowInfo rowInfo = this.getRowInfo(row);
        if (!rowInfo.isGrid()) {
            return null;
        }
        GridDataInstance gdi = rowInfo.getGridDataInstance();
        return gdi.getLevels();
    }

    public boolean haveLevelsAtRow(int row) {
        Real[] levelArray = this.getLevelsAtRow(row);
        return levelArray != null && levelArray.length > 1;
    }

    public void changePointParameter(Object[] param) {
        try {
            ProbeRowInfo rowInfo = (ProbeRowInfo)param[0];
            String name = (String)param[1];
            rowInfo.setPointParameter(name);
            this.doMoveProbe();
        }
        catch (Exception exc) {
            ProbeControl.logException("Changing parameter", exc);
        }
    }

    private List getParameterMenuItems(final int row) {
        ArrayList<JMenu> items = new ArrayList<JMenu>();
        ProbeRowInfo rowInfo = this.getRowInfo(row);
        JMenu paramMenu = new JMenu("Parameter " + this.getFieldName(row));
        items.add(paramMenu);
        if (!rowInfo.isGrid()) {
            try {
                TupleType t = rowInfo.getTupleType();
                if (t != null) {
                    ArrayList<JMenuItem> subItems = new ArrayList<JMenuItem>();
                    for (int i = 0; i < t.getDimension(); ++i) {
                        if (!(t.getComponent(i) instanceof RealType)) continue;
                        String name = t.getComponent(i).toString();
                        name = Util.cleanTypeName(name);
                        subItems.add(GuiUtils.makeMenuItem(name, this, "changePointParameter", new Object[]{rowInfo, name}));
                    }
                    if (subItems.size() > 0) {
                        paramMenu.add(GuiUtils.makeMenu("Select Point Parameter", subItems));
                    }
                }
            }
            catch (Exception exc) {
                ProbeControl.logException("Changing parameter", exc);
            }
        }
        JMenuItem jmi = new JMenuItem("Copy");
        paramMenu.add(jmi);
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProbeControl.this.copyParameter(row);
            }
        });
        paramMenu.add(GuiUtils.makeMenuItem("Chart Properties", this, "showLineProperties", rowInfo));
        jmi = new JMenuItem("Change Unit...");
        paramMenu.add(jmi);
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Unit newUnit = ProbeControl.this.getDisplayConventions().selectUnit(ProbeControl.this.getRowInfo(row).getUnit(), null);
                if (newUnit != null) {
                    ProbeControl.this.getRowInfo(row).setUnit(newUnit);
                    try {
                        ProbeControl.this.updatePosition();
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("After changing units", exc);
                    }
                }
            }
        });
        paramMenu.add(GuiUtils.makeMenuItem("Set Sound...", this, "showSoundDialog", this.getRowInfo(row)));
        jmi = new JMenuItem("Remove");
        paramMenu.add(jmi);
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProbeControl.this.removeField(row);
                ProbeControl.this.updateLegendLabel();
            }
        });
        return items;
    }

    @Override
    public Container doMakeContents() {
        this.tableModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                ProbeRowInfo rowInfo = ProbeControl.this.getRowInfo(rowIndex);
                if (columnIndex == 3) {
                    return ProbeControl.this.haveLevelsAtRow(rowIndex);
                }
                return columnIndex == 4;
            }

            @Override
            public int getRowCount() {
                List dataChoices = ProbeControl.this.getDataChoices();
                if (dataChoices == null) {
                    return 0;
                }
                return dataChoices.size();
            }

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                ProbeRowInfo rowInfo = ProbeControl.this.getRowInfo(rowIndex);
                if (columnIndex == 3) {
                    if (!rowInfo.isGrid()) {
                        return;
                    }
                    Real r = null;
                    if (aValue instanceof Real) {
                        r = (Real)aValue;
                    } else if (aValue instanceof TwoFacedObject) {
                        r = (Real)((TwoFacedObject)aValue).getId();
                    }
                    rowInfo.setLevel(r);
                    if (r != null) {
                        rowInfo.setAltitude(ProbeControl.this.getAltitudeAtLevel(rowInfo.getGridDataInstance(), r));
                    } else {
                        rowInfo.setAltitude(null);
                    }
                    try {
                        ProbeControl.this.updatePosition();
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("After changing levels", exc);
                    }
                    return;
                }
                if (columnIndex == 0) {
                    rowInfo.setPointParameter(aValue.toString());
                    return;
                }
                if (columnIndex == 4) {
                    rowInfo.setSamplingMode(ProbeControl.this.getSamplingModeValue(aValue.toString()));
                    ProbeControl.this.doMoveProbe();
                    return;
                }
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    return ProbeControl.this.getFieldName(row);
                }
                if (column == 1 && row < ProbeControl.this.getDataChoices().size()) {
                    if (ProbeControl.this.amExporting) {
                        Data raw = ProbeControl.this.getRowInfo(row).getTimeSample();
                        if (raw == null) {
                            return "missing";
                        }
                        if (raw instanceof Real) {
                            return raw;
                        }
                        RealTuple rt = (RealTuple)raw;
                        try {
                            return rt.getComponent(0);
                        }
                        catch (Exception exc) {
                            return null;
                        }
                    }
                    return ProbeControl.this.getRowInfo(row).getDisplayValue();
                }
                if (column == 2) {
                    return ProbeControl.this.getRowInfo(row).getExtra();
                }
                if (column == 3) {
                    if (!ProbeControl.this.haveLevelsAtRow(row)) {
                        return "--";
                    }
                    Real level = ProbeControl.this.getRowInfo(row).getLevel();
                    Real alt = ProbeControl.this.getRowInfo(row).getAltitude();
                    if (level == null || alt == null) {
                        if (ProbeControl.this.lastProbeAltitude != null) {
                            return (ProbeControl.this.amExporting ? "" : "Probe: ") + ProbeControl.this.getDisplayConventions().formatAltitude(ProbeControl.this.lastProbeAltitude);
                        }
                        return "";
                    }
                    return Util.labeledReal(level);
                }
                if (column == 4) {
                    return ProbeControl.this.getSamplingModeName(ProbeControl.this.getRowInfo(row).getSamplingMode());
                }
                return "";
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Parameter";
                    }
                    case 1: {
                        return "Value";
                    }
                    case 2: {
                        return "Min/Max/Avg";
                    }
                    case 3: {
                        return "Level";
                    }
                    case 4: {
                        return "Sampling";
                    }
                }
                return "";
            }
        };
        this.paramsTable = new JTable(this.tableModel);
        this.paramsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GuiUtils.isDeleteEvent(e)) {
                    ProbeControl.this.removeField(ProbeControl.this.paramsTable.getSelectedRow());
                }
            }
        });
        this.paramsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = ProbeControl.this.paramsTable.rowAtPoint(e.getPoint());
                if (row < 0 || row >= ProbeControl.this.getDataChoices().size()) {
                    return;
                }
                ProbeRowInfo rowInfo = ProbeControl.this.getRowInfo(row);
                if (!SwingUtilities.isRightMouseButton(e)) {
                    if (e.getClickCount() > 1 && rowInfo != null) {
                        ProbeControl.this.showLineProperties(rowInfo);
                    }
                    return;
                }
                List choices = ProbeControl.this.getDataChoices();
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem jmi = ProbeControl.this.doMakeChangeParameterMenuItem();
                popupMenu.add(jmi);
                popupMenu.addSeparator();
                for (int rowIdx = 0; rowIdx < ProbeControl.this.infos.size(); ++rowIdx) {
                    List items = ProbeControl.this.getParameterMenuItems(rowIdx);
                    GuiUtils.makePopupMenu(popupMenu, items);
                }
                popupMenu.show(ProbeControl.this.paramsTable, e.getX(), e.getY());
            }
        });
        this.paramsTable.setToolTipText("Right click to edit");
        JScrollPane scrollPane = new JScrollPane(this.paramsTable);
        this.paramsTable.getColumnModel().getColumn(3).setCellEditor(new LevelEditor());
        this.paramsTable.getColumnModel().getColumn(4).setCellEditor(new SamplingEditor());
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setHorizontalAlignment(4);
        this.paramsTable.getColumnModel().getColumn(1).setCellRenderer(cellRenderer);
        this.paramsTable.getColumnModel().getColumn(2).setCellRenderer(cellRenderer);
        this.paramsTable.getColumnModel().getColumn(3).setCellRenderer(cellRenderer);
        scrollPane.setPreferredSize(new Dimension(450, 100));
        JTableHeader header = this.paramsTable.getTableHeader();
        this.tablePanel = new JPanel();
        this.tablePanel.setVisible(this.showTable);
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(scrollPane);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        if (this.timeSeries != null) {
            this.timeSeries.setControl(this);
        }
        JTabbedPane tab = new JTabbedPane();
        ArrayList bottomComps = new ArrayList();
        JPanel bottomPanel = GuiUtils.leftRight(this.aniWidget, this.latLonWidget);
        bottomPanel = GuiUtils.inset((Component)bottomPanel, 5);
        JPanel bottom = GuiUtils.centerBottom(this.tablePanel, bottomPanel);
        JScrollPane chartScrollPane = new JScrollPane(this.getChart().getContents());
        chartScrollPane.setPreferredSize(new Dimension(450, 300));
        return GuiUtils.centerBottom(chartScrollPane, bottom);
    }

    @Override
    protected void popupDataDialog(String dialogMessage, Component from, boolean multiples, List categories) {
        super.popupDataDialog(dialogMessage, from, true, categories);
    }

    public void showLineProperties(ProbeRowInfo rowInfo) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    ProbeControl.this.updatePosition();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Updating position", exc);
                }
            }
        };
        LineState lineState = rowInfo.getLineState();
        lineState.showPropertiesDialog(listener, this.getChart().getPlotNames(), this.getChart().getCurrentRanges());
    }

    public void showSoundDialog(ProbeRowInfo info) {
        try {
            info.showSoundDialog(this);
        }
        catch (Exception exc) {
            ProbeControl.logException("shoing sound dialog", exc);
        }
    }

    private void removeField(int row) {
        if (row < 0) {
            return;
        }
        ProbeRowInfo info = this.getRowInfo(row);
        DataInstance di = info.getDataInstance();
        if (di != null) {
            this.removeDataChoice(di.getDataChoice());
        }
        this.infos.remove(row);
        try {
            this.setTimesForAnimation();
        }
        catch (Exception e) {
            ProbeControl.logException("Error updating times: ", e);
        }
        this.fireStructureChanged();
        this.doMoveProbe();
    }

    private void fireStructureChanged() {
        this.tableModel.fireTableStructureChanged();
        this.paramsTable.getColumnModel().getColumn(4).setCellEditor(new SamplingEditor());
        this.paramsTable.getColumnModel().getColumn(3).setCellEditor(new LevelEditor());
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setHorizontalAlignment(4);
        this.paramsTable.getColumnModel().getColumn(1).setCellRenderer(cellRenderer);
        this.paramsTable.getColumnModel().getColumn(2).setCellRenderer(cellRenderer);
        this.paramsTable.getColumnModel().getColumn(3).setCellRenderer(cellRenderer);
    }

    public DataChoice getDataChoiceAtRow(int row) {
        List choices = this.getDataChoices();
        if (row >= choices.size()) {
            return null;
        }
        return (DataChoice)choices.get(row);
    }

    String getFieldName(int row) {
        ProbeRowInfo rowInfo = this.getRowInfo(row);
        if (rowInfo.isPoint()) {
            String stationName = rowInfo.getStationName();
            if (stationName != null && stationName.length() > 0) {
                return rowInfo.getPointParameter() + "@" + stationName;
            }
            return rowInfo.getPointParameter();
        }
        if (rowInfo.getLineState().getName() != null) {
            return rowInfo.getLineState().getName();
        }
        return rowInfo.getDataInstance().getDataChoice().getName();
    }

    @Override
    protected String getChangeParameterLabel() {
        return "Add Parameter...";
    }

    private void doMoveProbe() {
        if (!this.getHaveInitialized()) {
            return;
        }
        try {
            this.updatePosition();
        }
        catch (Exception exc) {
            ProbeControl.logException("changePosition", exc);
        }
    }

    public void updatePosition() throws VisADException, RemoteException {
        this.updatePosition(this.probe.getPosition());
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        try {
            this.dataTemplate = null;
            this.updatePosition();
        }
        catch (Exception exc) {
            ProbeControl.logException("applyPreferences", exc);
        }
    }

    private void initRowUnits(List reals) {
    }

    private void updatePosition(final RealTuple position) throws VisADException, RemoteException {
        if (!this.getHaveInitialized()) {
            return;
        }
        GuiUtils.invokeInSwingThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProbeControl.this.updatePositionInSwingThread(position);
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Updating chart", exc);
                }
            }
        });
    }

    private void updatePositionInSwingThread(RealTuple position) throws VisADException, RemoteException {
        this.updatePending = false;
        double[] positionValues = position.getValues();
        EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{positionValues[0], positionValues[1], positionValues[2]}, false);
        LatLonPoint llp = elt.getLatLonPoint();
        this.lastProbeAltitude = elt.getAltitude();
        if (llp != null) {
            this.positionText = this.getDisplayConventions().formatLatLonPoint(llp);
            if (this.latLonWidget != null) {
                this.updateLatLonWidget(elt);
            }
        }
        this.updateTime();
        ArrayList<ProbeRowInfo> rowInfos = new ArrayList<ProbeRowInfo>();
        List choices = this.getDataChoices();
        for (int i = 0; i < choices.size(); ++i) {
            rowInfos.add(this.getRowInfo(i));
        }
        if (this.showSunriseSunset) {
            this.getChart().setLocation(Util.toLatLonPoint(llp));
        } else {
            this.getChart().setLocation(null);
        }
        this.getChart().setProbeSamples(rowInfos);
    }

    private void updateTime() throws VisADException, RemoteException {
        this.updateTimeInner();
    }

    private void updateTimeInner() throws VisADException, RemoteException {
        Set timeSet;
        if (!this.getHaveInitialized() || !this.getActive()) {
            return;
        }
        Animation animation = this.getInternalAnimation();
        int step = animation != null ? animation.getCurrent() : 0;
        Real aniValue = animation != null ? animation.getAniValue() : null;
        try {
            this.setData(aniValue, step);
        }
        catch (Exception exc) {
            ProbeControl.logException("Updating time", exc);
        }
        StringBuffer sideText = new StringBuffer();
        if (this.dataTemplate == null) {
            this.dataTemplate = this.getObjectStore().get("DisplayControlImpl.ProbeFormat", "<b>%value%</b> [%unit%] ");
        }
        this.dataTemplate = this.dataTemplate.trim();
        if (this.dataTemplate.equals("")) {
            this.dataTemplate = "%value%";
        }
        List choices = this.getDataChoices();
        for (int i = 0; i < choices.size(); ++i) {
            Real theValue = null;
            ProbeRowInfo info = this.getRowInfo(i);
            DataInstance dataInstance = info.getDataInstance();
            ArrayList<Real> reals = new ArrayList<Real>();
            Real theReal = info.getRealValue();
            if (theReal != null) {
                reals.add(theReal);
            }
            if (i > 0 && i < 8) {
                sideText.append("<br>");
            }
            if (i < 8) {
                sideText.append(this.getFieldName(i));
                String levString = null;
                if (this.haveLevelsAtRow(i)) {
                    Real level = info.getLevel();
                    Real alt = info.getAltitude();
                    if (level == null || alt == null) {
                        if (this.lastProbeAltitude != null) {
                            levString = this.getDisplayConventions().formatAltitude(this.lastProbeAltitude);
                        }
                    } else {
                        levString = Util.formatReal(level);
                    }
                }
                if (levString != null) {
                    sideText.append("(" + levString + ")");
                }
                sideText.append(": ");
            }
            if (reals.size() == 0) {
                info.setDisplayValue("missing");
                if (i >= 8) continue;
                sideText.append("missing");
                continue;
            }
            Unit rowUnit = info.getUnit();
            try {
                Real real;
                String valueStr = null;
                if (rowUnit != null) {
                    try {
                        valueStr = "";
                        for (int realsIdx = 0; realsIdx < reals.size(); ++realsIdx) {
                            String unit;
                            String value;
                            real = (Real)reals.get(realsIdx);
                            if (theValue == null) {
                                theValue = real;
                            }
                            if (Unit.canConvert(rowUnit, real.getUnit())) {
                                value = this.getDisplayConventions().format(real.getValue(rowUnit));
                                unit = rowUnit.toString();
                            } else {
                                value = this.getDisplayConventions().format(real.getValue());
                                unit = "" + real.getUnit();
                            }
                            String tmp = StringUtil.replace(this.dataTemplate, "%value%", value);
                            tmp = StringUtil.replace(tmp, "%unit%", unit);
                            tmp = StringUtil.replace(tmp, "%rawvalue%", "" + real.getValue());
                            tmp = StringUtil.replace(tmp, "%rawunit%", "" + real.getUnit());
                            if (realsIdx > 0) {
                                valueStr = valueStr + ", ";
                            }
                            valueStr = valueStr + tmp;
                        }
                        if (i < 8) {
                            sideText.append(valueStr);
                        }
                        valueStr = "<html>" + valueStr + "</html>";
                    }
                    catch (UnitException ue) {
                        ProbeControl.userMessage("Bad unit: " + rowUnit);
                    }
                }
                if (valueStr == null) {
                    valueStr = "";
                    for (int realsIdx = 0; realsIdx < reals.size(); ++realsIdx) {
                        real = (Real)reals.get(realsIdx);
                        if (theValue == null) {
                            theValue = real;
                        }
                        String tmp = this.getDisplayConventions().format(real.getValue());
                        if (realsIdx > 0) {
                            valueStr = valueStr + ", ";
                        }
                        valueStr = valueStr + tmp;
                    }
                    if (i < 8) {
                        sideText.append(valueStr);
                    }
                }
                info.setDisplayValue(valueStr);
                if (theValue == null) continue;
                info.playSound(theValue.getValue());
                continue;
            }
            catch (Exception exc) {
                ProbeControl.logException("Setting values", exc);
            }
        }
        if (this.sideLegendReadout == null) {
            this.sideLegendReadout = new JLabel();
        }
        if (this.getShowTableInLegend()) {
            this.sideLegendReadout.setText("<html>" + sideText.toString() + "</html>");
        } else {
            this.sideLegendReadout = new JLabel("<html><br></html>");
        }
        this.paramsTable.repaint();
        if (animation != null && (timeSet = animation.getSet()) != null) {
            RealTuple timeTuple = DataUtility.getSample(timeSet, step);
            if (this.timeLabel != null) {
                this.timeLabel.setText("" + (Real)timeTuple.getComponent(0));
            }
        }
        this.updateLegendLabel();
    }

    @Override
    protected void updateLegendLabel() {
        super.updateLegendLabel();
        String template = this.getDisplayListTemplate();
        if (template.contains("%position%")) {
            this.updateDisplayList();
        }
    }

    private ProbeRowInfo getRowInfo(int row) {
        return this.getRowInfo(row, true);
    }

    private ProbeRowInfo getRowInfo(int row, boolean andInitializeData) {
        ProbeRowInfo info;
        while (row >= this.infos.size()) {
            info = new ProbeRowInfo(this);
            this.infos.add(info);
        }
        info = this.infos.get(row);
        if (info == null) {
            return null;
        }
        if (andInitializeData && info.getDataInstance() == null) {
            List choices = this.getDataChoices();
            if (choices == null) {
                return null;
            }
            try {
                DataChoice dc = (DataChoice)choices.get(row);
                this.showWaitCursor();
                this.initRowInfo(info, dc);
                this.showNormalCursor();
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return info;
    }

    private void initRowInfo(ProbeRowInfo rowInfo, DataChoice dc) throws VisADException, RemoteException {
        rowInfo.setDataInstance(this.createDataInstance(dc));
        if (rowInfo.isGrid() || rowInfo.getPointParameter() == null) {
            // empty if block
        }
    }

    private DataInstance createDataInstance(DataChoice dc) throws VisADException, RemoteException {
        Data data = dc.getData(this.getDataSelection(), this.getRequestProperties());
        if (data instanceof FieldImpl && GridUtil.isGrid((FieldImpl)data)) {
            return new GridDataInstance(dc, this.getDataSelection(), this.getRequestProperties(), data);
        }
        return new DataInstance(dc, this.getDataSelection(), this.getRequestProperties(), data);
    }

    private EarthLocationTuple getProbeLocation() throws VisADException, RemoteException {
        RealTuple position = this.probe.getPosition();
        double[] positionValues = position.getValues();
        EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{positionValues[0], positionValues[1], positionValues[2]}, false);
        return elt;
    }

    private void clearCachedSamples() throws VisADException, RemoteException {
        ArrayList<Integer> badOnes = new ArrayList<Integer>();
        for (int rowIdx = 0; rowIdx < this.infos.size(); ++rowIdx) {
            ProbeRowInfo info = this.infos.get(rowIdx);
            info.clearCachedSamples();
            try {
                info.getDataInstance().reInitialize();
                continue;
            }
            catch (BadDataException bde) {
                badOnes.add(rowIdx);
            }
        }
        for (Integer bad : badOnes) {
            this.removeField(bad);
        }
    }

    private FieldImpl getSampleAtPoint(ProbeRowInfo info, EarthLocation elt, boolean useRowInfoCache) throws VisADException, RemoteException, Exception {
        LatLonPoint llp = elt.getLatLonPoint();
        FieldImpl sample = null;
        if (useRowInfoCache && (sample = info.getPointSample(elt)) != null) {
            return sample;
        }
        if (info.isPoint()) {
            FieldImpl pointObs = (FieldImpl)info.getDataInstance().getData();
            if (pointObs == null) {
                return null;
            }
            int numObs = pointObs.getDomainSet().getLength();
            ArrayList<PointOb> obs = new ArrayList<PointOb>();
            PointOb closest = null;
            double minDistance = 0.0;
            for (int i = 0; i < numObs; ++i) {
                PointOb ob = (PointOb)pointObs.getSample(i);
                double distance = Util.bearingDistance(ob.getEarthLocation(), elt).getValue();
                if (closest != null && !(distance < minDistance)) continue;
                closest = ob;
                minDistance = distance;
            }
            if (closest == null) {
                return null;
            }
            EarthLocation closestEL = closest.getEarthLocation();
            for (int i = 0; i < numObs; ++i) {
                PointOb ob = (PointOb)pointObs.getSample(i);
                if (!ob.getEarthLocation().equals(closestEL)) continue;
                obs.add(ob);
            }
            sample = PointObFactory.makeTimeSequenceOfPointObs(obs, 0, info.getPointIndex());
            if (useRowInfoCache) {
                info.setStationName((PointOb)obs.get(0), this);
                info.setPointSample(sample, elt);
                this.setTimesForAnimation();
            }
            return sample;
        }
        FieldImpl workingGrid = info.getWorkingGrid();
        if (workingGrid == null) {
            workingGrid = info.getGridDataInstance().getGrid();
            if (workingGrid == null) {
                return null;
            }
            if (GridUtil.is3D(workingGrid) && !GridUtil.isVolume(workingGrid)) {
                workingGrid = GridUtil.make2DGridFromSlice(workingGrid, false);
            }
        }
        sample = GridUtil.isVolume(workingGrid) ? (info.getAltitude() == null ? GridUtil.sample(workingGrid, elt, info.getSamplingMode()) : GridUtil.sample(workingGrid, new EarthLocationTuple(llp, info.getAltitude()), info.getSamplingMode())) : GridUtil.sample(workingGrid, llp, info.getSamplingMode());
        if (useRowInfoCache) {
            info.setWorkingGrid(workingGrid);
            info.setPointSample(sample, elt);
            this.setTimesForAnimation();
        }
        return sample;
    }

    @Override
    protected List getCursorReadoutInner(EarthLocation elt, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        for (int rowIdx = 0; rowIdx < this.infos.size(); ++rowIdx) {
            Unit unit;
            double value;
            Data rt;
            Real r;
            ProbeRowInfo info = this.infos.get(rowIdx);
            Data[] d = this.getSampleAt(info, elt, animationValue, animationStep, false);
            if (d == null || (r = info.getRealValue(rt = d[1])) == null || r.isMissing()) continue;
            if (l.size() == 0) {
                l.add("<tr><td>" + this.getMenuLabel() + ":" + "</td><td></td></tr>");
            }
            double d2 = value = (unit = info.getUnit()) != null ? r.getValue(unit) : r.getValue();
            if (unit == null) {
                unit = r.getUnit();
            }
            l.add("<tr><td>&nbsp;&nbsp;&nbsp;" + info.toString() + ":</td><td align=\"right\">" + Misc.format(value) + "[" + unit + "]</td></tr>");
            ReadoutInfo readoutInfo = new ReadoutInfo(this, r, elt, animationValue);
            readoutInfo.setUnit(unit);
            readoutInfo.setRange(info.getLineState().getRange());
            samples.add(readoutInfo);
        }
        return l;
    }

    private Data[] getSampleAt(ProbeRowInfo info, EarthLocation elt, Real aniValue, int step, boolean useRowInfoCache) throws Exception {
        FieldImpl sample = this.getSampleAtPoint(info, elt, useRowInfoCache);
        Data rt = null;
        if (sample != null) {
            rt = aniValue != null && !aniValue.isMissing() ? sample.evaluate(aniValue, info.getSamplingMode(), 202) : sample.getSample(step);
        }
        if (rt == null) {
            return null;
        }
        return new Data[]{sample, rt};
    }

    private void setData(Real aniValue, int step) throws VisADException, RemoteException, Exception {
        EarthLocationTuple elt = this.getProbeLocation();
        List choices = this.getDataChoices();
        for (int i = 0; i < choices.size(); ++i) {
            Unit rowUnit;
            ProbeRowInfo info = this.getRowInfo(i);
            Data[] d = this.getSampleAt(info, elt, aniValue, step, true);
            if (d == null) continue;
            FieldImpl sample = (FieldImpl)d[0];
            Data rt = d[1];
            if (rt == null) continue;
            info.setTimeSample(rt);
            Unit realUnit = null;
            Real realValue = info.getRealValue();
            if (realValue != null) {
                realUnit = realValue.getUnit();
            }
            if ((rowUnit = info.getUnit()) == null) {
                if (info.isGrid()) {
                    String name = info.getDataInstance().getParamName();
                    rowUnit = this.getDisplayConventions().selectDisplayUnit(name, realUnit);
                } else {
                    Real r = info.getRealValue();
                    if (r != null) {
                        rowUnit = r.getUnit();
                    }
                }
                info.setUnit(rowUnit);
            }
            if (!info.isGrid()) continue;
            info.setExtra("");
            float[][] values = sample.getFloats(false);
            if (values.length <= 0 || values[0].length <= 1) continue;
            float min = 0.0f;
            float max = 0.0f;
            float avg = 0.0f;
            for (int valueIdx = 0; valueIdx < values[0].length; ++valueIdx) {
                float value = values[0][valueIdx];
                if (valueIdx == 0 || value < min) {
                    min = value;
                }
                if (valueIdx == 0 || value > max) {
                    max = value;
                }
                avg += value;
            }
            avg /= (float)values[0].length;
            if (rowUnit != null && realUnit != null) {
                min = (float)rowUnit.toThis(min, realUnit);
                max = (float)rowUnit.toThis(max, realUnit);
                avg = (float)rowUnit.toThis(avg, realUnit);
            }
            info.setExtra(this.getDisplayConventions().format(min) + "/" + this.getDisplayConventions().format(max) + "/" + this.getDisplayConventions().format(avg));
        }
    }

    private Real getAltitudeAtLevel(GridDataInstance gdi, Real level) {
        Real altitude = null;
        try {
            altitude = GridUtil.getAltitude(gdi.getGrid(), level);
        }
        catch (VisADException ve) {
            altitude = new Real(RealType.Altitude);
        }
        return altitude;
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeMenuItem("Save Chart Image...", this.getChart(), "saveImage"));
        items.add(GuiUtils.makeMenuItem("Export Current Time as CSV...", this, "exportCsv"));
        items.add(GuiUtils.makeMenuItem("Export All Times as CSV...", this, "exportCsvAllTimes"));
    }

    public void exportCsv() {
        try {
            Animation animation = this.getInternalAnimation();
            int step = animation.getCurrent();
            Set aniSet = animation.getSet();
            DateTime[] times = Animation.getDateTimeArray(aniSet);
            if (times.length == 0) {
                return;
            }
            this.exportToCsv(new Real[]{times[step]});
            this.paramsTable.repaint();
        }
        catch (Exception exc) {
            ProbeControl.logException("Exporting to csv", exc);
        }
    }

    public void exportCsvAllTimes() {
        try {
            Animation animation = this.getInternalAnimation();
            Set aniSet = animation.getSet();
            Real[] times = Animation.getDateTimeArray(aniSet);
            this.exportToCsv(times);
            this.paramsTable.repaint();
        }
        catch (Exception exc) {
            ProbeControl.logException("Exporting to csv", exc);
        }
    }

    public void exportToCsv(Real[] times) {
        try {
            Real aniValue;
            int timeIdx;
            String filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_CSV, FileManager.FILTER_XLS), ".csv");
            if (filename == null) {
                return;
            }
            this.amExporting = true;
            List choices = this.getDataChoices();
            if (times.length == 0) {
                LogUtil.userMessage("No times to export");
                return;
            }
            this.setData(times[0], 0);
            ArrayList<List> rows = new ArrayList<List>();
            List cols = Misc.newList("Time");
            for (int row = 0; row < choices.size(); ++row) {
                ProbeRowInfo info = this.getRowInfo(row);
                cols.add(this.getFieldName(row));
            }
            rows.add(cols);
            for (timeIdx = 0; timeIdx < times.length; ++timeIdx) {
                aniValue = times[timeIdx];
                cols = Misc.newList("" + aniValue);
                rows.add(cols);
            }
            for (timeIdx = 0; timeIdx < times.length; ++timeIdx) {
                aniValue = times[timeIdx];
                for (int row = 0; row < choices.size(); ++row) {
                    cols = (List)rows.get(timeIdx + 1);
                    ProbeRowInfo info = this.getRowInfo(row);
                    Set timeSet = info.getTimeSet();
                    Data rt = null;
                    FieldImpl sample = info.getPointSample();
                    rt = sample != null && timeSet != null ? sample.evaluate(aniValue, info.getSamplingMode(), 202) : info.getPointSample().getSample(0);
                    if (rt == null) {
                        cols.add("missing");
                        continue;
                    }
                    if (info.getUnit() != null) {
                        Real real = null;
                        real = rt instanceof Real ? (Real)rt : (Real)((RealTuple)rt).getComponent(0);
                        cols.add(real.getValue(info.getUnit()));
                        continue;
                    }
                    cols.add(rt.toString());
                }
            }
            DataUtil.writeCsv(filename, rows);
        }
        catch (Exception exc) {
            ProbeControl.logException("Exporting to csv", exc);
        }
        this.amExporting = false;
    }

    public void setDataTemplate(String value) {
        this.dataTemplate = value;
    }

    public String getDataTemplate() {
        return this.dataTemplate;
    }

    public void setXFixed(boolean value) {
        this.xFixed = value;
        if (this.probe != null && this.getHaveInitialized()) {
            this.probe.setFixed(this.xFixed, this.yFixed, this.zFixed);
        }
    }

    public boolean getXFixed() {
        return this.xFixed;
    }

    public void setYFixed(boolean value) {
        this.yFixed = value;
        if (this.probe != null && this.getHaveInitialized()) {
            this.probe.setFixed(this.xFixed, this.yFixed, this.zFixed);
        }
    }

    public boolean getYFixed() {
        return this.yFixed;
    }

    public void setZFixed(boolean value) {
        this.zFixed = value;
        if (this.probe != null && this.getHaveInitialized()) {
            this.probe.setFixed(this.xFixed, this.yFixed, this.zFixed);
        }
    }

    public boolean getZFixed() {
        return this.zFixed;
    }

    public void setInfos(List<ProbeRowInfo> value) {
        this.infos = value;
    }

    public List<ProbeRowInfo> getInfos() {
        return this.infos;
    }

    public void setAltitudes(List l) {
        this._altitudes = l;
    }

    public void setLevels(List l) {
        this._levels = l;
    }

    public void setMethods(List l) {
        this._methods = l;
    }

    public void setUnits(List l) {
        this._units = l;
    }

    public void setSounds(List l) {
        this._sounds = l;
    }

    public void increaseProbeSize() {
        if (this.probe == null) {
            return;
        }
        float newPointSize = this.probe.getPointScale();
        this.setPointSize(newPointSize + newPointSize * 0.5f);
    }

    public void decreaseProbeSize() {
        if (this.probe == null) {
            return;
        }
        float newPointSize = this.probe.getPointScale();
        if ((newPointSize -= newPointSize * 0.5f) < 0.1f) {
            newPointSize = 0.1f;
        }
        this.setPointSize(newPointSize);
    }

    @Override
    public void setPointSize(float value) {
        super.setPointSize(value);
        if (this.probe != null) {
            try {
                this.probe.setAutoSize(false);
                this.probe.setPointSize(this.getPointSize());
                this.probe.setAutoSize(true);
            }
            catch (Exception exc) {
                ProbeControl.logException("Increasing probe size", exc);
            }
        }
    }

    public void setMarker(String value) {
        this.marker = value;
        if (this.probe != null && this.marker != null) {
            try {
                this.probe.setAutoSize(false);
                this.probe.setMarker(SelectorPoint.reduce(ShapeUtility.makeShape(this.marker)));
                this.probe.setAutoSize(true);
            }
            catch (Exception exc) {
                ProbeControl.logException("Setting marker", exc);
            }
        }
    }

    public String getMarker() {
        return this.marker;
    }

    public void setTimeSeries(TimeSeriesChart value) {
        this.timeSeries = value;
    }

    public TimeSeriesChart getTimeSeries() {
        return this.timeSeries;
    }

    public TimeSeriesChart getChart() {
        if (this.timeSeries == null) {
            this.timeSeries = new TimeSeriesChart(this, "Time Series");
            this.timeSeries.showAnimationTime(true);
        }
        return this.timeSeries;
    }

    public void setChartName(String newName) {
        this.timeSeries.setChartName(newName);
        this.updateDisplayList();
    }

    public void setShowThumbNail(boolean value) {
        this.getChart().setShowThumb(value);
    }

    public void setShowTable(boolean value) {
        this.showTable = value;
        if (this.tablePanel != null) {
            this.tablePanel.setVisible(this.showTable);
            this.tablePanel.invalidate();
            this.tablePanel.validate();
        }
    }

    public boolean getShowTable() {
        return this.showTable;
    }

    public void setShowTableInLegend(boolean value) {
        this.showTableInLegend = value;
        if (this.sideLegendReadout != null) {
            this.sideLegendReadout.setVisible(value);
        }
        this.doMoveProbe();
    }

    public boolean getShowTableInLegend() {
        return this.showTableInLegend;
    }

    public void setShowSunriseSunset(boolean value) {
        this.showSunriseSunset = value;
        this.doMoveProbe();
    }

    public boolean getShowSunriseSunset() {
        return this.showSunriseSunset;
    }

    public void setKeepProbeAtHeight(boolean value) {
        this.keepProbeAtHeight = value;
    }

    public boolean getKeepProbeAtHeight() {
        return this.keepProbeAtHeight;
    }

    public void setProbeRadius(double value) {
        this.probeRadius = value;
    }

    public double getProbeRadius() {
        return this.probeRadius;
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    public void viewpointChanged() {
        System.out.println("viewpointChanged");
        if (this.getMatchDisplayRegion() && this.reloadFromBounds) {
            try {
                NavigatedDisplay navDisplay = this.getMapDisplay();
                LatLonRect baseLLR = this.dataSelection.getGeoSelection().getLatLonRect();
                LatLonRect newLLR = navDisplay.getLatLonRect();
                if (baseLLR != null && !newLLR.containedIn(baseLLR)) {
                    this.loadDataFromViewBounds();
                }
                this.relocateDisplay(baseLLR, newLLR, false);
                this.reloadFromBounds = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasMapProjection() {
        if (this.infos == null) {
            return false;
        }
        if (this.infos.get(0).getDataInstance() instanceof GridDataInstance) {
            DataSelection ds = this.getDataSelection();
            Object t = ds.getProperty("Use_Progressive_Resolution");
            if (t != null) {
                this.isProgressiveResolution = (Boolean)t;
            }
            return true;
        }
        return false;
    }

    public class SamplingEditor
    extends DefaultCellEditor {
        public SamplingEditor() {
            super(new JComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            JComboBox box = (JComboBox)this.getComponent();
            GuiUtils.setListData(box, ProbeControl.this.samplingLabels);
            box.setSelectedItem(value);
            return box;
        }
    }

    public class LevelEditor
    extends DefaultCellEditor {
        public LevelEditor() {
            super(new JComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            JComboBox box = (JComboBox)this.getComponent();
            Object[] levels = ProbeControl.this.formatLevels(ProbeControl.this.getLevelsAtRow(rowIndex));
            List ll = Misc.toList(levels);
            ll.add(0, "Probe's");
            GuiUtils.setListData(box, ll.toArray());
            if (value instanceof Real) {
                value = Util.labeledReal((Real)value);
            }
            box.setSelectedItem(value);
            return box;
        }
    }
}

