/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.w3c.dom.Element;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.gis.KmlUtil;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointCloudDataSource;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.GlyphCreatorCommand;
import ucar.unidata.idv.control.drawing.PolyGlyph;
import ucar.unidata.idv.control.drawing.ShapeGlyph;
import ucar.unidata.ui.PropertyFilter;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.GeoUtils;
import ucar.visad.Util;
import ucar.visad.display.Displayable;
import ucar.visad.display.ImageRGBDisplayable;
import ucar.visad.display.VolumeDisplayable;
import visad.ConstantMap;
import visad.Data;
import visad.Display;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;
import visad.util.DataUtility;

public class PointCloudControl
extends DrawingControl {
    VolumeDisplayable myDisplay;
    ImageRGBDisplayable myRGBDisplay;
    boolean useTexture3D = true;
    MapProjection projection;
    private JTabbedPane tabbedPane;
    private int colorRangeIndex = -1;
    private Range[] dataRanges;
    private JComboBox colorParamsBox = null;
    private RealType[] rangeTypes;
    private boolean doFilter = false;
    private boolean doClip = true;
    private boolean showInside = true;
    private FieldImpl displayedData;
    private boolean hasRGB = false;
    private boolean isSequence = false;
    private boolean followTimeStep = false;
    private Hashtable<Integer, LatLonPoint> timeMap = new Hashtable();
    private Set animationSet;
    private PropertyFilter.FilterGui filterGui;
    private boolean matchAll = true;
    private boolean filtersEnabled = true;
    protected List filters = new ArrayList();

    public PointCloudControl() {
        this.setAttributeFlags(312);
        this.currentCmd = GlyphCreatorCommand.CMD_RECTANGLE;
    }

    @Override
    protected double getInitialZPosition() {
        return 1.0;
    }

    @Override
    protected boolean canHandleEvents() {
        if (this.tabbedPane != null) {
            return super.canHandleEvents() && this.tabbedPane.getSelectedIndex() != 0;
        }
        return super.canHandleEvents();
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeMenuItem("Export Points...", this, "exportPoints"));
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        if (this.isSequence) {
            items.add(GuiUtils.makeCheckboxMenuItem("Follow Time Steps", this, "followTimeStep", null));
        }
    }

    @Override
    protected void addFileMenuItems(List items, boolean forMenuBar) {
    }

    @Override
    protected boolean shouldAddAnimationListener() {
        return true;
    }

    @Override
    protected void timeChanged(Real time) {
        super.timeChanged(time);
        try {
            if (!this.isSequence || !this.followTimeStep || this.animationSet == null) {
                return;
            }
            int index = Util.findIndex(this.animationSet, time);
            if (index < 0) {
                return;
            }
            LatLonPoint llp = this.timeMap.get(new Integer(index));
            if (llp == null) {
                EarthLocationTuple el = new EarthLocationTuple(new Real(RealType.Latitude, 40.0), new Real(RealType.Longitude, -107.0), new Real(RealType.Altitude, 0.0));
                llp = el.getLatLonPoint();
                this.timeMap.put(new Integer(index), llp);
            }
            NavigatedDisplay navDisplay = this.getNavigatedDisplay();
            navDisplay.center(GeoUtils.toEarthLocation(llp), false);
        }
        catch (Exception exc) {
            this.followTimeStep = false;
            PointCloudControl.logException("Handling time change", exc);
        }
    }

    public void exportKml(String filename) throws Exception {
        try {
            FileOutputStream os = new FileOutputStream(filename);
            Element root = KmlUtil.kml(IOUtil.getFileTail(IOUtil.stripExtension(filename)));
            Element folder = KmlUtil.folder(root, "Points", false);
            KmlUtil.open(folder, false);
            FlatField points = null;
            this.isSequence = GridUtil.isTimeSequence(this.displayedData);
            points = this.isSequence ? (FlatField)this.displayedData.getSample(0, false) : (FlatField)this.displayedData;
            int latIndex = 2;
            int lonIndex = 1;
            int altIndex = 0;
            float[][] pts = points.getFloats(false);
            for (int i = 0; i < pts[0].length; ++i) {
                KmlUtil.placemark(folder, "", null, pts[latIndex][i], pts[lonIndex][i], pts[altIndex][i], null);
            }
            byte[] bytes = XmlUtil.toString(root).getBytes();
            ((OutputStream)os).write(bytes);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception exc) {
            PointCloudControl.logException("oops", exc);
        }
    }

    public void exportPoints() throws Exception {
        JComboBox publishCbx = this.getIdv().getPublishManager().getSelector("nc.export");
        String filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_CSV), ".csv", (JComponent)(publishCbx != null ? GuiUtils.top(publishCbx) : null));
        if (filename == null) {
            return;
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(filename));
        if (filename.toLowerCase().endsWith(".kml")) {
            this.exportKml(filename);
            if (os != null) {
                ((OutputStream)os).close();
            }
            return;
        }
        PrintWriter pw = new PrintWriter(os);
        FlatField points = null;
        this.isSequence = GridUtil.isTimeSequence(this.displayedData);
        points = this.isSequence ? (FlatField)this.displayedData.getSample(0, false) : (FlatField)this.displayedData;
        int latIndex = 2;
        int lonIndex = 1;
        int altIndex = 0;
        float[][] pts = points.getFloats(false);
        for (int i = 0; i < pts[0].length; ++i) {
            pw.print(pts[latIndex][i]);
            pw.print(",");
            pw.print(pts[lonIndex][i]);
            pw.print(",");
            pw.print(pts[altIndex][i]);
            for (int j = 3; j < pts.length; ++j) {
                pw.print(",");
                pw.print(pts[j][i]);
            }
            pw.print("\n");
        }
        ((OutputStream)os).close();
        this.getIdv().getPublishManager().publishContent(filename, null, publishCbx);
    }

    @Override
    protected List getShapeCommands() {
        return Misc.newList(GlyphCreatorCommand.CMD_RECTANGLE, GlyphCreatorCommand.CMD_POLYGON);
    }

    public int getColorRangeIndex() {
        return this.colorRangeIndex;
    }

    public void setColorRangeIndex(int index) {
        this.colorRangeIndex = index;
    }

    @Override
    public Range getColorRangeFromData() {
        if (this.dataRanges != null) {
            int rangeIndex = this.colorRangeIndex;
            if (this.colorRangeIndex < 0 || this.colorRangeIndex >= this.rangeTypes.length) {
                rangeIndex = this.rangeTypes.length - 1;
            }
            return this.dataRanges[rangeIndex];
        }
        return super.getColorRangeFromData();
    }

    @Override
    protected Range getInitialRange() throws RemoteException, VisADException {
        return this.getColorRangeFromData();
    }

    @Override
    public MapProjection getDataProjection() {
        return this.projection;
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        String ns;
        if (!super.init((DataChoice)null)) {
            return false;
        }
        if (!this.isDisplay3D()) {
            LogUtil.userMessage(log_, "Can't render point cloud in 2D display");
            return false;
        }
        Hashtable props = dataChoice.getProperties();
        if (props != null && props.get("doFilter") != null && (ns = (String)props.get("doFilter")) == "true") {
            this.doFilter = true;
        }
        if (this.doFilter) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (PointCloudControl.this.getHaveInitialized()) {
                        PointCloudControl.this.applyFilters();
                    }
                }
            };
            this.filterGui = new PropertyFilter.FilterGui(this.filters, this.getFilterNames(), this.filtersEnabled, this.matchAll, listener);
        }
        this.setEditable(true);
        return this.setData(dataChoice);
    }

    protected List getFilterNames() {
        try {
            DataInstance pdi = this.getDataInstance();
            if (pdi == null) {
                return null;
            }
            FieldImpl data = (FieldImpl)pdi.getData();
            Set domainSet = data.getDomainSet();
            int numObs = domainSet.getLength();
            if (numObs == 0) {
                return null;
            }
            FieldImpl ob = (FieldImpl)data.getSample(0);
            FunctionType ft0 = (FunctionType)ob.getType();
            RealType[] rt0 = ft0.getFlatRange().getRealComponents();
            ArrayList<Object> names = new ArrayList<Object>();
            names.add("--");
            for (int i = 0; i < rt0.length; ++i) {
                String typeId = rt0[i].toString();
                String typeName = Util.cleanTypeName(typeId);
                if (typeName.equals("Latitude") || typeName.equals("Longitude") || typeName.equals("Altitude")) continue;
                names.add(new TwoFacedObject((Object)typeName, typeId));
            }
            return names;
        }
        catch (Exception exc) {
            PointCloudControl.logException("Getting filter names", exc);
            return null;
        }
    }

    private void makeDisplay() throws VisADException, RemoteException {
        if (this.myDisplay != null || this.myRGBDisplay != null) {
            return;
        }
        if (this.hasRGB) {
            this.reallySetAttributeFlags(304);
            this.myRGBDisplay = new ImageRGBDisplayable("pointcloudrgb_" + this.getDataInstance().getDataChoice().getName());
            this.myRGBDisplay.addConstantMap(new ConstantMap(0.0, Display.PolygonMode));
            this.myRGBDisplay.addConstantMap(new ConstantMap(10.0, Display.CurvedSize));
            this.myRGBDisplay.setPointSize(this.getPointSize());
            this.addDisplayable((Displayable)this.myRGBDisplay, this.getAttributeFlags());
        } else {
            this.reallySetAttributeFlags(312);
            this.myDisplay = new VolumeDisplayable("pointcloud_" + this.getDataInstance().getDataChoice().getName());
            this.myDisplay.setUseRGBTypeForSelect(true);
            this.myDisplay.setPointSize(this.getPointSize());
            this.addDisplayable((Displayable)this.myDisplay, this.getAttributeFlags());
        }
    }

    @Override
    protected boolean showLocationWidgets() {
        return false;
    }

    @Override
    protected void initDisplayUnit() {
    }

    @Override
    public Unit getDistanceUnit() {
        return this.getDefaultDistanceUnit();
    }

    @Override
    protected boolean showTimeWidgets() {
        return false;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        super.doMakeContents();
        JComponent mine = this.doMakeWidgetComponent();
        JComponent controls = super.doMakeControlsPanel();
        JComponent shapes = this.doMakeShapesPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("Point Cloud", mine);
        this.tabbedPane.add("Clipping", controls);
        this.tabbedPane.add("Shapes", shapes);
        if (this.doFilter) {
            this.tabbedPane.add("Filters", this.doMakeFilterGui());
        }
        return this.tabbedPane;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        if (!this.hasRGB) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Color By:"), GuiUtils.left(this.doMakeColorByWidget())));
        }
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Point Size:"), GuiUtils.left(this.doMakePointSizeWidget())));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Clipping:"), GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.makeCheckbox("Clip Enabled", this, "doClip"), (Component)GuiUtils.makeCheckbox("Show Inside Region", this, "showInside"), GuiUtils.makeButton("Reload", this, "reloadPointData")))));
    }

    protected JComponent doMakeFilterGui() {
        JButton buttons = GuiUtils.makeButton("Apply Filters", this, "applyFilters");
        JPanel gui = GuiUtils.topCenter(GuiUtils.left(GuiUtils.inset((Component)buttons, 5)), this.filterGui.getContents());
        return gui;
    }

    public void initFilters() {
        if (this.filterGui != null) {
            this.filters = this.filterGui.getFilters();
            this.matchAll = this.filterGui.getMatchAll();
            this.filtersEnabled = this.filterGui.getEnabled();
        }
    }

    public void applyFilters() {
        this.initFilters();
        try {
            this.loadPointData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JComponent doMakeColorByWidget() {
        if (this.colorParamsBox == null) {
            this.colorParamsBox = new JComboBox();
            this.colorParamsBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PointCloudControl.this.myDisplay == null || !PointCloudControl.this.getHaveInitialized()) {
                        return;
                    }
                    try {
                        PointCloudControl.this.colorRangeIndex = PointCloudControl.this.colorParamsBox.getSelectedIndex();
                        PointCloudControl.this.setRange(PointCloudControl.this.getColorRangeFromData());
                        PointCloudControl.this.setSelectRange(PointCloudControl.this.getRange());
                    }
                    catch (Exception excp) {
                        DisplayControlBase.logException("Setting rgb type", excp);
                    }
                }
            });
            this.setColorParams();
        }
        return this.colorParamsBox;
    }

    private void setColorParams() {
        if (this.colorParamsBox != null && this.rangeTypes != null) {
            GuiUtils.setListData(this.colorParamsBox, this.rangeTypes);
        }
        this.colorParamsBox.setSelectedIndex(this.colorRangeIndex);
    }

    @Override
    public void setPointSize(float value) {
        super.setPointSize(value);
        try {
            if (this.myDisplay != null) {
                this.myDisplay.setPointSize(this.getPointSize());
            }
            if (this.myRGBDisplay != null) {
                this.myRGBDisplay.setPointSize(this.getPointSize());
            }
        }
        catch (Exception e) {
            PointCloudControl.logException("Setting point size", e);
        }
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (!(choice == null || super.setData(choice) && this.getNavigatedDisplay() != null)) {
            return false;
        }
        try {
            this.loadPointData();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        return true;
    }

    @Override
    protected void processData(Data data) {
        try {
            this.loadPointData(data);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public void reloadPointData() throws Exception {
        try {
            this.loadPointData();
        }
        catch (Exception exc) {
            PointCloudControl.logException("Loading points", exc);
        }
    }

    private void loadPointData() throws Exception {
        this.loadPointData(null);
    }

    private void loadPointData(Data newData) throws Exception {
        FieldImpl data;
        FieldImpl fieldImpl = data = newData == null ? (FieldImpl)this.getDataInstance().getData() : (FieldImpl)newData;
        if (this.filtersEnabled && this.filters.size() > 0) {
            try {
                LogUtil.message("Observation display: filtering data");
                Trace.call1("filterData");
                data = this.filterData(data);
                Trace.call2("filterData");
            }
            catch (Exception exc) {
                PointCloudControl.logException("Processing filters", exc);
            }
        }
        FieldImpl points = null;
        this.isSequence = GridUtil.isTimeSequence(data);
        points = this.isSequence ? (FieldImpl)data.getSample(0, false) : data;
        int latIndex = 2;
        int lonIndex = 1;
        int altIndex = 0;
        this.rangeTypes = ((TupleType)DataUtility.getRangeType(points)).getRealComponents();
        for (int i = 0; i < this.rangeTypes.length; ++i) {
            if (this.rangeTypes[i].equals(RealType.Latitude)) {
                latIndex = i;
            } else if (this.rangeTypes[i].equals(RealType.Longitude)) {
                lonIndex = i;
            } else if (this.rangeTypes[i].equals(RealType.Altitude)) {
                altIndex = i;
            }
            if (!this.rangeTypes[i].getName().equalsIgnoreCase(this.paramName)) continue;
            this.colorRangeIndex = i;
        }
        float[][] pts = points.getFloats(false);
        if (this.colorRangeIndex == -1) {
            this.colorRangeIndex = pts.length == 3 ? altIndex : pts.length - 1;
        }
        if (pts.length == 6) {
            boolean hasRed = false;
            boolean hasGreen = false;
            boolean hasBlue = false;
            for (int i = 0; i < this.rangeTypes.length; ++i) {
                String typeName = this.rangeTypes[i].toString().toLowerCase();
                if (typeName.indexOf("red") >= 0) {
                    hasRed = true;
                    continue;
                }
                if (typeName.indexOf("green") >= 0) {
                    hasGreen = true;
                    continue;
                }
                if (typeName.indexOf("blue") < 0) continue;
                hasBlue = true;
            }
            boolean bl = this.hasRGB = hasRed && hasGreen && hasBlue;
        }
        if (this.hasRGB) {
            this.colorRangeIndex = altIndex;
        }
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        int numFields = pts.length;
        float[] maxFields = new float[numFields];
        float[] minFields = new float[numFields];
        for (int i = 0; i < numFields; ++i) {
            maxFields[i] = Float.NEGATIVE_INFINITY;
            minFields[i] = Float.POSITIVE_INFINITY;
        }
        this.dataRanges = new Range[numFields];
        if (this.isSequence) {
            this.animationSet = data.getDomainSet();
        }
        int numTimes = !this.isSequence ? 1 : this.animationSet.getLength();
        int SCALE = 1000000;
        List glyphs = this.getGlyphs();
        int[] scales = new int[glyphs.size()];
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        if (this.doClip) {
            for (DrawingGlyph glyph : glyphs) {
                if (glyph instanceof ShapeGlyph && ((ShapeGlyph)glyph).getShapeType() == 0) {
                    ShapeGlyph shapeGlyph = (ShapeGlyph)glyph;
                    float[][] latLons = shapeGlyph.getLatLons();
                    shapes.add(ShapeGlyph.makeRectangle2D(latLons));
                    scales[shapes.size() - 1] = 1;
                    continue;
                }
                if (!(glyph instanceof PolyGlyph)) continue;
                float[][] latLons = glyph.getLatLons();
                int[] xs = new int[latLons[0].length];
                int[] ys = new int[latLons[0].length];
                for (int i = 0; i < latLons[0].length; ++i) {
                    xs[i] = (int)(latLons[1][i] * (float)SCALE);
                    ys[i] = (int)(latLons[0][i] * (float)SCALE);
                }
                shapes.add(new Polygon(xs, ys, xs.length));
                scales[shapes.size() - 1] = SCALE;
            }
        }
        for (int j = 0; j < numTimes; ++j) {
            if (j > 0) {
                pts = ((FieldImpl)data.getSample(j, false)).getFloats(false);
            }
            float timeminX = Float.POSITIVE_INFINITY;
            float timeminY = Float.POSITIVE_INFINITY;
            float timemaxX = Float.NEGATIVE_INFINITY;
            float timemaxY = Float.NEGATIVE_INFINITY;
            for (int k = 0; k < pts.length; ++k) {
                float[] paramPts = pts[k];
                for (int i = 0; i < paramPts.length; ++i) {
                    float value = paramPts[i];
                    if (value != value) continue;
                    maxFields[k] = Math.max(maxFields[k], value);
                    minFields[k] = Math.min(minFields[k], value);
                    if (k == lonIndex) {
                        timeminX = Math.min(timeminX, value);
                        timemaxX = Math.max(timemaxX, value);
                        continue;
                    }
                    if (k != latIndex) continue;
                    timeminY = Math.min(timeminY, value);
                    timemaxY = Math.max(timemaxY, value);
                }
            }
            EarthLocationTuple el = new EarthLocationTuple(new Real(RealType.Latitude, (double)(timeminY + (timemaxY - timeminY) / 2.0f)), new Real(RealType.Longitude, (double)(timeminX + (timemaxX - timeminX) / 2.0f)), new Real(RealType.Altitude, 0.0));
            this.timeMap.put(new Integer(j), el.getLatLonPoint());
            minX = Math.min(timeminX, minX);
            maxX = Math.max(timemaxX, maxX);
            minY = Math.min(timeminY, minY);
            maxY = Math.max(timemaxY, maxY);
        }
        if (shapes.size() > 0) {
            try {
                LogUtil.message("Observation display: clipping data");
                Trace.call1("clippingData");
                data = this.clippingData(data, shapes, scales, lonIndex, latIndex);
                Trace.call2("clippingData");
            }
            catch (Exception exc) {
                PointCloudControl.logException("Processing clipping", exc);
            }
        }
        for (int i = 0; i < numFields; ++i) {
            this.dataRanges[i] = Float.isInfinite(minFields[i]) || Float.isInfinite(maxFields[i]) ? new Range(Double.NaN, Double.NaN) : new Range(minFields[i], maxFields[i]);
        }
        float width = Math.max(maxX - minX, maxY - minY);
        float height = Math.max(maxY - minY, maxY - minY);
        Rectangle2D.Float rect = new Rectangle2D.Float(minX, minY, width, height);
        this.projection = new TrivialMapProjection(RealTupleType.SpatialEarth2DTuple, rect);
        this.displayedData = data;
        this.makeDisplay();
        if (this.myRGBDisplay != null) {
            this.myRGBDisplay.loadData(data);
        }
        if (this.myDisplay != null) {
            this.myDisplay.loadData(data, this.colorRangeIndex);
        }
    }

    protected FieldImpl clippingData(FieldImpl obs, List<Shape> shapes, int[] scales, int lonIndex, int latIndex) throws Exception {
        boolean isTimeSequence = GridUtil.isTimeSequence(obs);
        FieldImpl clippedField = null;
        if (isTimeSequence) {
            Set timeSet = obs.getDomainSet();
            clippedField = new FieldImpl((FunctionType)obs.getType(), timeSet);
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)obs.getSample(i);
                FieldImpl subTime = this.doTheActualClipping(oneTime, shapes, scales, lonIndex, latIndex);
                if (subTime == null) continue;
                clippedField.setSample(i, (Data)subTime, false);
            }
        } else {
            clippedField = this.doTheActualClipping(obs, shapes, scales, lonIndex, latIndex);
        }
        return clippedField;
    }

    private FieldImpl doTheActualClipping(FieldImpl points, List<Shape> shapes, int[] scales, int lonIndex, int latIndex) throws Exception {
        float[][] pts = points.getFloats(false);
        float[][] newPts = new float[pts.length][pts[0].length];
        int pointCnt = 0;
        for (int i = 0; i < pts[0].length; ++i) {
            int j;
            boolean ok = !this.showInside;
            for (j = 0; j < shapes.size(); ++j) {
                Shape shape = shapes.get(j);
                if (shape.contains(Misc.normalizeLongitude(pts[lonIndex][i]) * (double)scales[j], pts[latIndex][i] * (float)scales[j])) {
                    if (this.showInside) {
                        ok = true;
                        break;
                    }
                    ok = false;
                    break;
                }
                if (this.showInside) continue;
                ok = true;
            }
            if (!ok) continue;
            for (j = 0; j < pts.length; ++j) {
                newPts[j][pointCnt] = pts[j][i];
            }
            ++pointCnt;
        }
        pts = Misc.copy(newPts, pointCnt);
        FunctionType ft = (FunctionType)points.getType();
        FlatField data0 = PointCloudDataSource.makeField(ft.getRange(), pts);
        return data0;
    }

    protected FieldImpl filterData(FieldImpl obs) throws Exception {
        boolean isTimeSequence = GridUtil.isTimeSequence(obs);
        FieldImpl filteredField = null;
        if (isTimeSequence) {
            Set timeSet = obs.getDomainSet();
            filteredField = new FieldImpl((FunctionType)obs.getType(), timeSet);
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)obs.getSample(i);
                FieldImpl subTime = this.doTheActualFiltering(oneTime);
                if (subTime == null) continue;
                filteredField.setSample(i, (Data)subTime, false);
            }
        } else {
            filteredField = this.doTheActualFiltering(obs);
        }
        return filteredField;
    }

    private FieldImpl doTheActualFiltering(FieldImpl pointObs) throws Exception {
        if (pointObs == null || pointObs.isMissing()) {
            return pointObs;
        }
        FieldImpl retField = null;
        Set domainSet = pointObs.getDomainSet();
        int numObs = domainSet.getLength();
        Vector<Tuple> v = new Vector<Tuple>();
        Object[] tmpValues = new Object[this.filters.size()];
        for (int i = 0; i < numObs; ++i) {
            Data tmp = pointObs.getSample(i);
            if (!(tmp instanceof Tuple)) continue;
            Tuple tuple = (Tuple)tmp;
            TupleType tupleType = (TupleType)tuple.getType();
            RealType[] types = tupleType.getRealComponents();
            String[] typeNames = new String[types.length];
            for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
                typeNames[typeIdx] = types[typeIdx].toString();
            }
            boolean ok = true;
            boolean matchedSome = false;
            for (int filterIdx = 0; ok && filterIdx < this.filters.size(); ++filterIdx) {
                PropertyFilter filter = (PropertyFilter)this.filters.get(filterIdx);
                String paramName = filter.getName();
                Real dataElement = null;
                int dataIndex = -1;
                for (int typeIdx = 0; dataIndex == -1 && typeIdx < typeNames.length; ++typeIdx) {
                    if (!paramName.equals(typeNames[typeIdx])) continue;
                    dataIndex = typeIdx;
                }
                if (dataIndex < 0 || (dataElement = tuple.getRealComponents()[dataIndex]) == null) continue;
                if (dataElement.isMissing()) {
                    if (!this.matchAll) continue;
                    ok = false;
                    continue;
                }
                boolean filterOk = false;
                if (!(dataElement instanceof Real) || !filter.isNumericOperator()) {
                    filterOk = filter.ok(((Object)dataElement).toString().trim());
                } else {
                    Real obsReal = dataElement;
                    if (tmpValues[filterIdx] == null) {
                        String filterValue = filter.getValue().trim();
                        tmpValues[filterIdx] = filterValue;
                        Real filterReal = Util.toReal(filterValue);
                        if (filterReal != null) {
                            tmpValues[filterIdx] = obsReal.getUnit() == null ? new Double(filterReal.getValue()) : new Double(filterReal.getValue(obsReal.getUnit()));
                        }
                    }
                    filterOk = filter.ok(dataElement, tmpValues[filterIdx]);
                }
                if (filterOk) {
                    matchedSome = true;
                    if (this.matchAll) continue;
                    break;
                }
                if (!this.matchAll) continue;
                ok = false;
            }
            if (!ok || !matchedSome) continue;
            v.add(tuple);
        }
        if (v.isEmpty()) {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), 1));
        } else if (v.size() == numObs) {
            retField = pointObs;
        } else {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), v.size()));
            retField.setSamples(v.toArray(new Tuple[v.size()]), false, false);
        }
        return retField;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    public void setShowInside(boolean value) {
        this.showInside = value;
    }

    public boolean getShowInside() {
        return this.showInside;
    }

    public void setDoClip(boolean value) {
        this.doClip = value;
    }

    public boolean getDoClip() {
        return this.doClip;
    }

    public void setDoFilter(boolean value) {
        this.doFilter = value;
    }

    public List getFilters() {
        return this.filters;
    }

    public void setFilters(List value) {
        this.filters = value;
    }

    public boolean getDoFilter() {
        return this.doFilter;
    }

    public void setFollowTimeStep(boolean value) {
        this.followTimeStep = value;
    }

    public boolean getFollowTimeStep() {
        return this.followTimeStep;
    }
}

