/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.control.ControlWidget;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.RangeDialog;
import ucar.unidata.idv.control.RangeWidget;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.Util;
import ucar.visad.display.Contour2DDisplayable;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.ScalarMapSet;
import ucar.visad.display.ZSelector;
import visad.Data;
import visad.DisplayRealType;
import visad.FieldImpl;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public abstract class PlanViewControl
extends GridDisplayControl {
    public static final String MACRO_LEVEL = "%level%";
    public static final String SHARE_LEVEL = "PlanViewControl.SHARE_LEVEL";
    private ZSelector zSelector;
    private JComboBox levelBox;
    private JButton levelUpBtn;
    private JButton levelDownBtn;
    private JLabel levelLabel;
    private JCheckBox cycleLevelsCbx;
    protected Object[] currentLevels;
    private Object[] levelsFromData;
    protected JLabel levelReadout;
    private boolean levelEnabled = false;
    private boolean is2D = false;
    private boolean ignoreVerticalDimension = false;
    private boolean currentLevelAnimation = false;
    private int currentLevelIdx = -1;
    private DisplayableData planDisplay;
    private double lastZValue = 0.0;
    private FieldImpl workingGrid;
    protected FieldImpl currentSlice;
    protected Object currentLevel;
    private boolean loadedAny = false;
    private int animationLevel = -1;
    private boolean displayIs3D = false;
    protected DataChoice datachoice;
    private boolean multipleIsTopography = false;
    private boolean parameterIsTopography = false;
    ScalarMap parameterTopoMap = null;
    private VerticalRangeWidget verticalRangeWidget = null;
    private Range verticalRange;
    private Range levelColorRange;
    int polygonMode = 0;
    private String OldSmoothingType = "None";
    private int OldSmoothingFactor = 0;
    protected boolean haveEnsemble = false;

    public PlanViewControl() {
        this.setAttributeFlags(16);
    }

    @Override
    protected Data getCursorReadoutData() throws Exception {
        return this.currentSlice;
    }

    protected void setCurrentSlice(FieldImpl slice) throws Exception {
        this.currentSlice = slice;
    }

    protected FieldImpl getCurrentSlice() throws Exception {
        return this.currentSlice;
    }

    @Override
    protected List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        if (this.currentSlice == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String dcName = this.getDataChoice().getName();
        Map<Integer, String> translations = this.getIdv().getResourceManager().getTranslationsHashtable().get(dcName);
        boolean areWeTranslating = translations != null;
        int samplingModeValue = areWeTranslating ? this.getSamplingModeValue("Nearest Neighbor") : this.getSamplingModeValue(this.getObjectStore().get("DisplayControlImpl.SamplingMode", DEFAULT_SAMPLING_MODE));
        Real r = GridUtil.sampleToReal(this.currentSlice, el, animationValue, samplingModeValue);
        if (r != null) {
            ReadoutInfo readoutInfo = new ReadoutInfo(this, r, el, animationValue);
            readoutInfo.setUnit(this.getDisplayUnit());
            readoutInfo.setRange(this.getRange());
            samples.add(readoutInfo);
        }
        if (r != null && !r.isMissing()) {
            String formatted = areWeTranslating ? translations.get((int)r.getValue()) : this.formatForCursorReadout(r);
            result.add("<tr><td>" + this.getMenuLabel() + ":</td><td  align=\"right\">" + formatted + (this.currentLevel != null ? "@" + this.currentLevel : "") + "</td></tr>");
        }
        return result;
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Grid Projection";
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        if (this.currentLevel != null) {
            dsd.addPropertyValue(this.currentLevel, "settingsLevel", "Level", "Display");
        }
    }

    @Override
    public void addToRangeMenu(final RangeWidget rw, List items) {
        super.addToRangeMenu(rw, items);
        try {
            if (this.workingGrid != null && GridUtil.isVolume(this.workingGrid)) {
                final Range r = this.getLevelColorRange();
                if (r == null) {
                    return;
                }
                JMenuItem mi = new JMenuItem("From Displayed Data");
                items.add(mi);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        rw.setRangeDialog(PlanViewControl.this.convertColorRange(r));
                    }
                });
            }
        }
        catch (Exception exc) {
            PlanViewControl.logException("addToRangeMenu", exc);
        }
    }

    protected Range getLevelColorRange() {
        if (this.currentSlice == null) {
            return null;
        }
        try {
            Range[] range = GridUtil.getMinMax(this.currentSlice);
            int index = this.getColorRangeIndex();
            if (index >= range.length) {
                index = 0;
            }
            this.levelColorRange = range[index];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.levelColorRange == null) {
            return null;
        }
        return this.levelColorRange;
    }

    private void moveUpDown(int delta) {
        int max;
        int selected = this.levelBox.getSelectedIndex();
        if (selected >= 0 && (selected += delta) >= (max = this.levelBox.getItemCount())) {
            selected = max - 1;
        }
        if (selected < 0) {
            selected = 0;
        }
        this.levelBox.setSelectedIndex(selected);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.datachoice = dataChoice;
        Trace.call1("PlanView.init");
        Trace.call1("PlanView.initMisc");
        this.levelReadout = new JLabel(" ");
        this.setLevelReadoutLabel(this.formatLevel(null));
        this.levelBox = this.doMakeLevelControl(null);
        ImageIcon upIcon = GuiUtils.getImageIcon("/ucar/unidata/idv/control/images/LevelUp.gif");
        this.levelUpBtn = new JButton(upIcon);
        this.levelUpBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.levelUpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PlanViewControl.this.moveUpDown(-1);
            }
        });
        ImageIcon downIcon = GuiUtils.getImageIcon("/ucar/unidata/idv/control/images/LevelDown.gif");
        this.levelDownBtn = new JButton(downIcon);
        this.levelDownBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.levelDownBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PlanViewControl.this.moveUpDown(1);
            }
        });
        this.levelLabel = GuiUtils.rLabel(this.getLevelsLabel());
        this.levelLabel.setDisplayedMnemonic(GuiUtils.charToKeyCode("L"));
        this.levelLabel.setLabelFor(this.levelBox);
        this.cycleLevelsCbx = new JCheckBox("Cycle", false);
        int keyCode = GuiUtils.charToKeyCode("Y");
        if (keyCode != -1) {
            this.cycleLevelsCbx.setMnemonic(keyCode);
        }
        this.cycleLevelsCbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                PlanViewControl.this.setLevelAnimation(PlanViewControl.this.cycleLevelsCbx.isSelected());
            }
        });
        this.planDisplay = this.createPlanDisplay();
        this.planDisplay.setVisible(true);
        this.displayIs3D = this.isDisplay3D();
        this.zSelector = new ZSelector(-1.0, -1.0, -1.0);
        this.zSelector.addPropertyChangeListener(this);
        Trace.call2("PlanView.initMisc");
        boolean result = this.setData(dataChoice);
        if (!result) {
            return false;
        }
        if (this.shouldShowZSelector()) {
            this.addDisplayable((Displayable)this.zSelector, 4);
        }
        if (this.haveMultipleFields()) {
            if (this.shouldUseZPosition()) {
                this.addDisplayable((Displayable)this.planDisplay, 200);
            } else {
                this.addDisplayable((Displayable)this.planDisplay, 72);
            }
        } else if (this.shouldShowLevelWidget()) {
            this.addDisplayable(this.planDisplay);
        } else if (this.shouldUseZPosition()) {
            this.addDisplayable((Displayable)this.planDisplay, 128);
        } else {
            this.addDisplayable(this.planDisplay);
        }
        Trace.call2("PlanView.init");
        return result;
    }

    @Override
    public void initDone() {
        if (this.getParameterIsTopography()) {
            try {
                this.addParameterTopographyMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected JComboBox getPolyModeComboBox() {
        JComboBox polyModeCombo = new JComboBox();
        Object[] polyModes = new TwoFacedObject[]{new TwoFacedObject((Object)"Solid", new Integer(0)), new TwoFacedObject((Object)"Mesh", new Integer(1)), new TwoFacedObject((Object)"Points", new Integer(2))};
        GuiUtils.setListData(polyModeCombo, polyModes);
        polyModeCombo.setSelectedIndex(this.getPolygonMode() == 2 ? 2 : (this.getPolygonMode() == 1 ? 1 : 0));
        polyModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PlanViewControl.this.setPolygonMode((Integer)((TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem()).getId());
                    if (PlanViewControl.this.planDisplay != null && PlanViewControl.this.planDisplay instanceof Grid2DDisplayable) {
                        ((Grid2DDisplayable)PlanViewControl.this.planDisplay).setPolygonMode(PlanViewControl.this.getPolygonMode());
                    }
                }
                catch (Exception ve) {
                    DisplayControlBase.logException("setPolygonMode", ve);
                }
            }
        });
        return polyModeCombo;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectorDisplay.position")) {
            try {
                if (!this.getHaveInitialized()) {
                    return;
                }
                this.loadDataAtZ(this.zSelector.getPosition().getValue());
            }
            catch (Exception exc) {
                PlanViewControl.logException("", exc);
            }
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        super.doRemove();
        this.datachoice = null;
        this.workingGrid = null;
        this.parameterTopoMap = null;
    }

    @Override
    protected boolean haveMultipleFields() {
        return super.haveMultipleFields() && !this.getMultipleIsTopography();
    }

    @Override
    protected int getColorRangeIndex() {
        if (this.getMultipleIsTopography()) {
            return 0;
        }
        return super.getColorRangeIndex();
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        Trace.call1("PlanView.setData");
        boolean result = super.setData(dataChoice);
        if (!result) {
            Trace.call2("PlanView.setData");
            return false;
        }
        this.loadedAny = false;
        if (this.getGridDataInstance() != null) {
            this.haveEnsemble = this.getGridDataInstance().getNumEnsembles() > 1;
        }
        this.getGridDisplayable().setColoredByAnother(this.haveMultipleFields());
        if (this.getMultipleIsTopography()) {
            this.addTopographyMap();
        }
        Trace.call1("PlanView.getLevels");
        DataSelection tmpSelection = new DataSelection(this.getDataSelection());
        tmpSelection.setFromLevel(null);
        tmpSelection.setToLevel(null);
        List levelsList = dataChoice.getAllLevels(tmpSelection);
        Object[] levels = null;
        if (levelsList != null && levelsList.size() > 0) {
            levels = levelsList.toArray(new Object[levelsList.size()]);
        }
        if (levels == null) {
            levels = this.getGridDataInstance().getLevels();
        }
        if (this.currentLevel == null) {
            this.currentLevel = this.getDataSelection().getFromLevel();
        }
        if (levels != null && levels.length > 0 && this.currentLevel == null) {
            this.currentLevel = levels[0];
        }
        this.setLevels(levels);
        Trace.call2("PlanView.getLevels");
        levels = this.currentLevels;
        this.setDisplayableVisibility(this.zSelector, levels != null && levels.length > 0);
        this.loadDataAtLevel(this.currentLevel);
        Unit newUnit = this.getDisplayUnit();
        if (newUnit != null && !newUnit.equals(this.getRawDataUnit()) && Unit.canConvert(newUnit, this.getRawDataUnit())) {
            this.planDisplay.setDisplayUnit(newUnit);
        }
        this.processRequestProperties();
        DataChoice dc0 = dataChoice;
        while (dc0 instanceof DerivedDataChoice) {
            dc0 = (DataChoice)((DerivedDataChoice)dc0).getChoices().get(0);
        }
        String magStr = (String)dc0.getProperty("MAG");
        this.resolutionReadout = magStr != null && !magStr.isEmpty() ? magStr : null;
        Trace.call2("PlanView.setData");
        return true;
    }

    protected void addTopographyMap() throws VisADException, RemoteException {
        this.addTopographyMap(1);
    }

    protected void addParameterTopographyMap() throws VisADException, RemoteException {
        NavigatedDisplay nd = this.getNavigatedDisplay();
        if (nd == null) {
            return;
        }
        DisplayRealType vertType = this.getDisplayAltitudeType();
        ScalarMapSet mapSet = this.getPlanDisplay().getScalarMapSet();
        if (this.parameterTopoMap != null) {
            mapSet.remove(this.parameterTopoMap);
        }
        RealType paramTopoType = this.getGridDataInstance().getRealType(0);
        if (this.getPlanDisplay() instanceof Grid2DDisplayable) {
            paramTopoType = ((Grid2DDisplayable)this.getPlanDisplay()).getRGBRealType();
        } else if (this.getPlanDisplay() instanceof Contour2DDisplayable) {
            paramTopoType = ((Contour2DDisplayable)this.getPlanDisplay()).getRGBRealType();
        }
        this.parameterTopoMap = new ScalarMap(paramTopoType, vertType);
        this.parameterTopoMap.setOverrideUnit(this.getDisplayUnit());
        if (this.verticalRange != null) {
            this.setVerticalRange(this.verticalRange);
        }
        mapSet.add(this.parameterTopoMap);
        this.getPlanDisplay().setScalarMapSet(mapSet);
    }

    public void setVerticalRange(Range vertRange) {
        this.verticalRange = vertRange;
        if (vertRange != null) {
            try {
                if (this.parameterTopoMap != null) {
                    this.parameterTopoMap.setRange(vertRange.getMin(), vertRange.getMax());
                }
            }
            catch (Exception exc) {
                PlanViewControl.logException("Unable to set the vertical range ", exc);
            }
            if (this.verticalRangeWidget != null) {
                this.verticalRangeWidget.setRange(vertRange);
            }
        }
    }

    public Range getVerticalRange() {
        return this.verticalRange;
    }

    private void setLevelAnimation(boolean on) {
        if (!this.levelEnabled) {
            return;
        }
        if (this.currentLevelAnimation == on) {
            return;
        }
        this.currentLevelAnimation = on;
        if (this.currentLevelAnimation) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    PlanViewControl.this.animateLevel();
                }
            };
            t.start();
        }
    }

    private void animateLevel() {
        while (this.getActive() && this.levelEnabled && this.currentLevelAnimation && this.currentLevels != null) {
            ++this.currentLevelIdx;
            if (this.currentLevelIdx >= this.currentLevels.length) {
                this.currentLevelIdx = 0;
            }
            if (!this.getActive()) {
                return;
            }
            try {
                this.setLevelFromUser(this.currentLevels[this.currentLevelIdx]);
            }
            catch (Exception ie) {
                PlanViewControl.logException("Setting level", ie);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    public boolean haveLevels() {
        return this.levelEnabled;
    }

    public void setLevels(Object[] levels) {
        this.setOkToFireEvents(false);
        this.currentLevels = levels;
        boolean bl = this.levelEnabled = levels != null;
        if (!this.levelEnabled) {
            this.currentLevelAnimation = false;
            this.cycleLevelsCbx.setSelected(false);
        }
        if (this.is2D) {
            this.levelEnabled = false;
            this.currentLevelAnimation = false;
            this.cycleLevelsCbx.setSelected(false);
        }
        if (this.levelBox == null) {
            return;
        }
        this.levelBox.setEnabled(this.levelEnabled);
        this.levelUpBtn.setEnabled(this.levelEnabled);
        this.levelDownBtn.setEnabled(this.levelEnabled);
        this.levelLabel.setEnabled(this.levelEnabled);
        this.cycleLevelsCbx.setEnabled(this.levelEnabled);
        if (levels == null) {
            this.setLevelReadoutLabel(this.formatLevel(null));
        }
        GuiUtils.setListData(this.levelBox, this.formatLevels(levels));
        if (this.currentLevel != null) {
            this.levelBox.setSelectedItem(this.currentLevel);
        }
        this.setOkToFireEvents(true);
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        if (this.currentLevels != null) {
            final JMenu levelsMenu = new JMenu("Levels");
            levelsMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent e) {
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuSelected(MenuEvent e) {
                    PlanViewControl.this.handleLevelMenuSelected(levelsMenu);
                }
            });
            items.add(levelsMenu);
        }
        super.getEditMenuItems(items, forMenuBar);
    }

    private void handleLevelMenuSelected(JMenu levelMenu) {
        levelMenu.removeAll();
        if (this.currentLevels == null || this.currentLevels.length == 0) {
            levelMenu.add(new JLabel(" No levels "));
            return;
        }
        for (int i = 0; i < this.currentLevels.length; ++i) {
            final TwoFacedObject level = this.getLabeledReal(this.currentLevels[i]);
            JMenuItem mi = new JMenuItem("" + level);
            levelMenu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        PlanViewControl.this.setLevelFromUser(level.getId());
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("setLevel", exc);
                    }
                }
            });
        }
    }

    public DisplayableData getPlanDisplay() {
        return this.planDisplay;
    }

    public GridDisplayable getGridDisplayable() {
        return (GridDisplayable)((Object)this.planDisplay);
    }

    @Override
    public void setPointSize(float value) {
        super.setPointSize(value);
        if (this.planDisplay != null) {
            try {
                this.planDisplay.setPointSize(this.getPointSize());
            }
            catch (Exception e) {
                PlanViewControl.logException("Setting point size", e);
            }
        }
    }

    protected abstract DisplayableData createPlanDisplay() throws VisADException, RemoteException;

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        try {
            if (this.getMultipleIsTopography()) {
                this.addTopographyMap();
            }
            if (this.getParameterIsTopography()) {
                this.addParameterTopographyMap();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getLevel() {
        return this.currentLevel;
    }

    @Override
    public void setLevel(Object pl) {
        this.setLevel(pl, false);
    }

    public void setSettingsLevel(Object level) {
        this.setDataSelectionLevel(level);
        this.setLevel(level, false);
    }

    public void setDataSelectionLevel(Object level) {
        if (level instanceof String) {
            try {
                Real level1 = Util.toReal((String)level);
                this.getDataSelection().setLevel(level1);
            }
            catch (Exception e) {
                System.err.println("error parsing level: " + level + " " + e);
                this.getDataSelection().setLevel(level);
            }
        } else {
            this.getDataSelection().setLevel(level);
        }
    }

    @Override
    protected void setLevelFromUser(Object pl) throws VisADException, RemoteException {
        this.setLevelFromUser(pl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLevelFromUser(Object pl, boolean fromSelector) throws VisADException, RemoteException {
        if (this.getDataSelection().getFromLevel() != null && Misc.equals(this.getDataSelection().getFromLevel(), this.getDataSelection().getToLevel())) {
            Real realLevel = this.getLevelReal(pl);
            this.getDataSelection().setLevel(realLevel);
            this.getDataInstance().setDataSelection(this.getDataSelection());
        }
        if (this.workingGrid == null || !GridUtil.isVolume(this.workingGrid) && !Misc.equals(pl, this.currentLevel)) {
            this.showWaitCursor();
            try {
                this.getDataInstance().reInitialize();
            }
            finally {
                this.showNormalCursor();
            }
        }
        this.setLevel(pl, fromSelector);
    }

    private void setLevel(Object pl, boolean fromSelector) {
        try {
            if (!this.getHaveInitialized()) {
                this.currentLevel = pl;
            } else {
                this.deactivateDisplays();
                this.loadDataAtLevel(pl, fromSelector);
                this.doShare((Object)SHARE_LEVEL, pl);
                this.activateDisplays();
            }
        }
        catch (Exception exc) {
            PlanViewControl.logException("setLevel", exc);
        }
    }

    @Override
    public void relocateDisplay(LatLonRect originalBounds, LatLonRect newBounds, boolean useDataProjection) {
        try {
            super.relocateDisplay(originalBounds, newBounds, useDataProjection);
            NavigatedDisplay nd = this.getNavigatedDisplay();
            if (nd != null) {
                GeoSelection geoSelection = this.getDataSelection().getGeoSelection(true);
                this.getViewManager().setProjectionFromData(false);
                try {
                    Rectangle sbox = nd.getScreenBounds();
                    GeoLocationInfo ginfo = new GeoLocationInfo(newBounds);
                    geoSelection.setBoundingBox(ginfo);
                    geoSelection.setScreenBound(sbox);
                    geoSelection.setUseViewBounds(true);
                    this.getDataSelection().setGeoSelection(geoSelection);
                    this.dataChanged();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadDataAtLevel(Object level) throws VisADException, RemoteException {
        this.loadDataAtLevel(level, false);
    }

    private void loadDataAtLevel(Object level, boolean fromSelector) throws VisADException, RemoteException {
        Trace.call1("PlanView.loadData");
        if (this.loadedAny && level != null && level.equals(this.currentLevel)) {
            return;
        }
        if (level != null && !level.equals(this.currentLevel)) {
            this.getDataSelection().putProperty("levelChanged", true);
        }
        if (this.workingGrid == null || !GridUtil.isVolume(this.workingGrid) || level != null) {
            try {
                this.showWaitCursor();
                if (this.loadedAny) {
                    // empty if block
                }
                this.workingGrid = this.getGrid(this.getGridDataInstance());
                if (this.workingGrid == null) {
                    return;
                }
            }
            finally {
                this.showNormalCursor();
            }
        }
        this.loadedAny = true;
        this.currentLevel = level;
        this.currentSlice = null;
        int samplingMode = this.getSamplingModeValue(this.getDefaultSamplingMode());
        Real realLevel = this.getLevelReal(level);
        if (GridUtil.isVolume(this.workingGrid)) {
            if (level != null && this.currentLevels != null && this.hasLevel(level)) {
                samplingMode = 100;
            }
            if (level != null && this.currentLevels != null && this.currentLevels.length > 1) {
                if (realLevel == null) {
                    return;
                }
                this.currentSlice = this.displayIs3D && !this.getMultipleIsTopography() ? GridUtil.sliceAtLevel(this.workingGrid, realLevel, samplingMode) : GridUtil.make2DGridFromSlice(GridUtil.sliceAtLevel(this.workingGrid, realLevel, samplingMode));
                if (this.levelsFromData == null) {
                    this.levelsFromData = this.getGridDataInstance().getLevels();
                    this.setLevels(this.levelsFromData);
                }
            } else {
                this.currentSlice = this.workingGrid;
            }
        } else {
            this.currentSlice = this.workingGrid;
            if (GridUtil.is3D(this.currentSlice) && (!this.displayIs3D || this.getMultipleIsTopography() || this.getParameterIsTopography())) {
                this.currentSlice = GridUtil.make2DGridFromSlice(this.currentSlice);
            }
        }
        this.getGridDisplayable().loadData(this.getSliceForDisplay(this.currentSlice));
        if (level == null || realLevel == null || !this.displayIs3D) {
            return;
        }
        if (this.levelBox != null) {
            this.levelBox.setSelectedItem(this.getLabeledReal(level));
        }
        Real altitude = null;
        try {
            altitude = GridUtil.getAltitude(this.currentSlice, realLevel);
        }
        catch (Exception ve) {
            altitude = null;
        }
        if (altitude != null && !altitude.isMissing()) {
            EarthLocationTuple elt = new EarthLocationTuple(0.0, 0.0, altitude.getValue());
            if (!fromSelector) {
                this.lastZValue = this.earthToBox(elt)[2];
                this.zSelector.setZValue(this.lastZValue);
            }
            if (fromSelector) {
                level = GridUtil.getLevel(this.currentSlice, realLevel);
            }
        }
        this.setLevelReadoutLabel("Current level: " + this.formatLevel(level));
        String dlTemplate = this.getDisplayListTemplate();
        if (dlTemplate.contains(MACRO_LEVEL)) {
            this.updateLegendAndList();
        } else {
            this.updateLegendLabel();
        }
        Trace.call2("PlanView.loadData");
    }

    private boolean hasLevel(Object level) {
        if (this.currentLevels == null || level == null) {
            return false;
        }
        Object firstLevel = this.currentLevels[0];
        if (level.getClass().equals(firstLevel.getClass())) {
            return Arrays.binarySearch(this.currentLevels, level) >= 0;
        }
        if (level instanceof Real && firstLevel instanceof TwoFacedObject) {
            return TwoFacedObject.findId(level, Misc.toList(this.currentLevels)) != null;
        }
        return false;
    }

    protected FieldImpl getSliceForDisplay(FieldImpl slice) throws VisADException {
        FieldImpl retField = slice;
        if (slice != null) {
            if (this.getSkipValue() > 0) {
                retField = GridUtil.subset(retField, this.getSkipValue() + 1);
            }
            boolean isMTopo = this.getMultipleIsTopography();
            if (this.checkFlag(8192) && !this.getSmoothingType().equals("None")) {
                retField = GridUtil.smooth(retField, this.getSmoothingType(), this.getSmoothingFactor());
            }
            if (isMTopo) {
                try {
                    RealType rt0;
                    MathType[] rt = GridUtil.getParamType(retField).getComponents();
                    if (rt[1] instanceof RealTupleType) {
                        RealTupleType rtt = (RealTupleType)rt[1];
                        rt0 = (RealType)rtt.getComponent(0);
                    } else {
                        rt0 = (RealType)rt[1];
                    }
                    this.addTopographyMap(rt0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return retField;
    }

    @Override
    protected void applySmoothing() throws VisADException, RemoteException {
        if (!(!this.checkFlag(8192) || this.getGridDisplayable() == null || this.currentSlice == null || this.getSmoothingType().equalsIgnoreCase("None") && this.OldSmoothingType.equalsIgnoreCase("None") || this.getSmoothingType().equals(this.OldSmoothingType) && this.getSmoothingFactor() == this.OldSmoothingFactor)) {
            this.OldSmoothingType = this.getSmoothingType();
            this.OldSmoothingFactor = this.getSmoothingFactor();
            try {
                this.getGridDisplayable().loadData(this.getSliceForDisplay(this.currentSlice));
                if (this.getParameterIsTopography()) {
                    try {
                        this.addParameterTopographyMap();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ve) {
                PlanViewControl.logException("applySmoothing", ve);
            }
        }
    }

    @Override
    protected boolean checkFlag(int f) {
        if (f == 8192) {
            return super.checkFlag(f);
        }
        return super.checkFlag(f);
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList(MACRO_LEVEL));
        labels.addAll(Misc.newList("Level"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        patterns.add(MACRO_LEVEL);
        if (this.currentLevel == null) {
            values.add("");
        } else {
            values.add("" + this.formatLevel(this.currentLevel));
        }
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        if (this.currentLevel != null && !this.is2D) {
            labels.add("Level: " + this.formatLevel(this.currentLevel));
        }
    }

    protected String formatLevel(Object level) {
        if (level == null) {
            return "                                       ";
        }
        Real myLevel = this.getLevelReal(level);
        StringBuffer buf = new StringBuffer();
        if (this.currentLevel != null && this.currentLevel.toString().equals("SFC")) {
            buf.append("SFC ");
        } else if (this.currentLevel != null && this.currentLevel.toString().equals("MSL")) {
            buf.append("MSL ");
        } else if (this.currentLevel != null && this.currentLevel.toString().equals("TRO")) {
            buf.append("TRO ");
        } else {
            buf.append(this.getDisplayConventions().format(myLevel.getValue()));
            buf.append(" ");
            buf.append(myLevel.getUnit());
        }
        return buf.toString();
    }

    private void loadDataAtZ(double newZValue) throws VisADException, RemoteException {
        if (this.lastZValue == newZValue) {
            return;
        }
        this.lastZValue = newZValue;
        Real altitude = this.boxToEarth(new double[]{0.0, 0.0, newZValue}).getAltitude();
        this.setLevelFromUser(altitude, true);
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (!this.getHaveInitialized()) {
            return;
        }
        if (dataId.equals(SHARE_LEVEL)) {
            try {
                this.setLevelFromUser(data[0]);
            }
            catch (Exception exc) {
                PlanViewControl.logException("receiveShareData.level", exc);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    @Override
    public Container doMakeContents() {
        return GuiUtils.top(GuiUtils.vbox(Misc.newList(this.doMakeWidgetComponent())));
    }

    @Override
    public void getControlWidgets(List<ControlWidget> controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        if (this.shouldShowLevelWidget()) {
            JPanel levelUpDown = GuiUtils.doLayout(new Component[]{this.levelUpBtn, this.levelDownBtn}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
            JPanel levelSelector = GuiUtils.doLayout(new Component[]{this.levelBox, levelUpDown}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
            controlWidgets.add(new WrapperWidget(this, this.levelLabel, GuiUtils.left(levelSelector), GuiUtils.centerRight(this.levelReadout, this.cycleLevelsCbx)));
        }
        if (this.getParameterIsTopography()) {
            if (this.verticalRange == null) {
                this.verticalRange = this.getColorRangeFromData();
            }
            this.verticalRangeWidget = new VerticalRangeWidget(this, this.verticalRange);
            this.addRemovable(this.verticalRangeWidget);
            controlWidgets.add(this.verticalRangeWidget);
        }
    }

    @Override
    protected void displayUnitChanged(Unit oldUnit, Unit newUnit) {
        if (this.parameterTopoMap != null) {
            try {
                this.parameterTopoMap.setOverrideUnit(newUnit);
                if (this.verticalRangeWidget != null) {
                    Range newRange = Util.convertRange(this.verticalRangeWidget.getRange(), oldUnit, newUnit);
                    this.setVerticalRange(newRange);
                }
            }
            catch (Exception excp) {
                PlanViewControl.logException("Unable to set the topo override unit", excp);
            }
        }
    }

    protected boolean shouldShowLevelWidget() {
        return this.haveLevels();
    }

    protected boolean shouldShowZSelector() {
        boolean b = !this.getMultipleIsTopography() && this.haveLevels() && this.useZPosition() && !this.getParameterIsTopography();
        try {
            b = b && this.workingGrid != null && GridUtil.isVolume(this.workingGrid);
        }
        catch (Exception e) {
            b = false;
        }
        return b;
    }

    protected boolean shouldUseZPosition() {
        return !this.haveLevels() && !this.getMultipleIsTopography() && !this.getParameterIsTopography();
    }

    public void setIs2D(boolean v) {
        this.is2D = v;
    }

    public boolean getIs2D() {
        return this.is2D;
    }

    public void setLevelReadoutLabel(String text) {
        if (this.levelReadout != null) {
            this.levelReadout.setText(text);
        }
    }

    public void setMultipleIsTopography(boolean v) {
        this.multipleIsTopography = v;
    }

    public boolean getMultipleIsTopography() {
        return this.multipleIsTopography;
    }

    public void setParameterIsTopography(boolean v) {
        this.parameterIsTopography = v;
    }

    public boolean getParameterIsTopography() {
        return this.parameterIsTopography;
    }

    public void setIgnoreVerticalDimension(boolean v) {
        this.ignoreVerticalDimension = v;
    }

    public boolean getIgnoreVerticalDimension() {
        return this.ignoreVerticalDimension;
    }

    public String getLevelsLabel() {
        return "Levels:";
    }

    @Override
    public boolean canExportData() {
        return true;
    }

    @Override
    protected Data getDisplayedData() throws VisADException, RemoteException {
        if (this.planDisplay == null || this.planDisplay.getData() == null) {
            return null;
        }
        return this.planDisplay.getData();
    }

    @Override
    protected void applySkipFactor() {
        if (this.getGridDisplayable() != null && this.currentSlice != null) {
            try {
                this.getGridDisplayable().loadData(this.getSliceForDisplay(this.currentSlice));
            }
            catch (Exception ve) {
                PlanViewControl.logException("applySkipFactor", ve);
            }
        }
    }

    public void setPolygonMode(int v) {
        this.polygonMode = v;
    }

    public int getPolygonMode() {
        return this.polygonMode;
    }

    public class VerticalRangeWidget
    extends ControlWidget {
        private Range range;
        private JLabel label;
        private JButton button;
        private JLabel rhLabel;
        private RangeDialog rangeDialog;

        public VerticalRangeWidget(PlanViewControl control, Range range) {
            this(control, range, "Change Vertical Range");
        }

        public VerticalRangeWidget(PlanViewControl control, Range range, String dialogTitle) {
            super(control);
            this.label = new JLabel("Vertical Range:", 4);
            this.rhLabel = new JLabel(" ");
            this.setRange(range);
            this.button = new JButton("Change");
            this.button.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.showChangeRangeDialog();
        }

        public void showChangeRangeDialog() {
            if (this.rangeDialog == null) {
                this.rangeDialog = new RangeDialog(this.getDisplayControl(), this.range, "Change Vertical Range", "setVerticalRange", this.button);
            }
            this.rangeDialog.showDialog();
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range r) {
            this.range = r;
            if (r != null) {
                this.updateLabel();
                if (this.rangeDialog != null) {
                    this.rangeDialog.setRangeDialog(r);
                }
            }
        }

        private void updateLabel() {
            if (this.rhLabel == null) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("From: ");
            buf.append(this.getDisplayConventions().format(this.range.getMin()));
            buf.append(" To: ");
            buf.append(this.getDisplayConventions().format(this.range.getMax()));
            if (this.displayControl.getDisplayUnit() != null) {
                // empty if block
            }
            buf.append(" ");
            buf.append(this.displayControl.getDisplayUnit());
            this.rhLabel.setText(buf.toString());
        }

        public JLabel getLabel() {
            return this.label;
        }

        @Override
        public void fillList(List l, int columns) {
            l.add(this.label);
            l.add(GuiUtils.doLayout(new Component[]{GuiUtils.inset((Component)this.button, new Insets(0, 8, 0, 0)), new Label(" "), this.rhLabel, GuiUtils.filler()}, 4, GuiUtils.WT_NNNY, GuiUtils.WT_N));
        }

        public Range getRangeFromColorTable() {
            Range ctRange = null;
            ColorTable originalCT = this.getDisplayControl().getOldColorTableOrInitialColorTable();
            if (originalCT != null) {
                ctRange = originalCT.getRange();
            }
            return ctRange;
        }

        @Override
        public void doRemove() {
            super.doRemove();
            if (this.rangeDialog != null) {
                this.rangeDialog.doRemove();
                this.rangeDialog = null;
            }
        }
    }
}

