/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.display.DisplayMaster;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.KeyboardBehavior;
import visad.ScalarMap;
import visad.VisADException;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.KeyboardBehaviorJ2D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.ss.FancySSCell;

public class OmniControl
extends DisplayControlImpl {
    private FancySSCell display;
    private JList dataList;
    private Vector dataChoiceList = new Vector();
    private ArrayList dataInstances = new ArrayList();
    private ScalarMap[] scalarMaps = null;
    private String saveString = null;
    private String cellName = null;
    JComponent mycontents;

    public OmniControl() {
        this.setAttributeFlags(16);
    }

    @Override
    public boolean init(List choices) throws VisADException, RemoteException {
        DisplayRenderer dr;
        this.cellName = null;
        if (this.cellName == null) {
            this.cellName = this.getDisplayName() + "_" + Misc.getUniqueId();
        }
        this.display = new FancySSCell(this.cellName);
        this.display.setPreferredSize(new Dimension(256, 256));
        this.display.setAutoShowControls(false);
        this.display.setAutoDetect(this.scalarMaps == null);
        IdvPreferenceManager pm = this.getControlContext().getPreferenceManager();
        KeyboardBehavior kb = null;
        OmniControl omniControl = this;
        if (omniControl.display.canDo3D()) {
            this.display.setDimension(1);
            dr = (DisplayRendererJ3D)this.display.getDisplay().getDisplayRenderer();
            kb = new KeyboardBehaviorJ3D((DisplayRendererJ3D)dr);
            ((DisplayRendererJ3D)dr).addKeyboardBehavior((KeyboardBehaviorJ3D)kb);
        } else {
            this.display.setDimension(2);
            dr = (DisplayRendererJ2D)this.display.getDisplay().getDisplayRenderer();
            kb = new KeyboardBehaviorJ2D((DisplayRendererJ2D)dr);
            ((DisplayRendererJ2D)dr).addKeyboardBehavior((KeyboardBehaviorJ2D)kb);
        }
        if (kb != null) {
            DisplayMaster.setKeyboardEventMap(pm.getKeyboardMap(), kb);
        }
        DisplayImpl displayImpl = this.display.getDisplay();
        displayImpl.getDisplayRenderer().getMouseBehavior().getMouseHelper().setFunctionMap(pm.getMouseMap());
        this.dataList = new JList();
        this.dataList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OmniControl.this.showDataChoiceMenu(e);
            }
        });
        this.dataList.setVisibleRowCount(4);
        return this.setData(choices);
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        super.doRemove();
        this.display.hideWidgetFrame();
        DisplayImpl ssDisplay = this.display.getDisplay();
        if (ssDisplay != null) {
            ssDisplay.destroy();
        }
        this.display.destroyCell();
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        JButton mapping = new JButton("Mappings");
        JButton controls = new JButton("Controls");
        mapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OmniControl.this.display.addMapDialog();
            }
        });
        controls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OmniControl.this.display.showWidgetFrame();
            }
        });
        JScrollPane sp = new JScrollPane();
        sp.getViewport().setView(this.dataList);
        sp.setBorder(BorderFactory.createCompoundBorder(new TitledBorder("Data"), new BevelBorder(1)));
        this.mycontents = GuiUtils.centerBottom(this.display, GuiUtils.vbox(sp, GuiUtils.hbox(Misc.newList(mapping, controls))));
        return this.mycontents;
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties) {
        super.initAfterUnPersistence(vc, properties);
        try {
            if (this.scalarMaps != null) {
                this.display.setMaps(this.scalarMaps);
            }
            if (this.saveString != null) {
                this.display.setPartialSaveString(this.saveString, true);
            }
        }
        catch (Exception excp) {
            OmniControl.logException("initAfterUnPersistence:", excp);
        }
    }

    @Override
    protected String getChangeParameterLabel() {
        return "Add Parameter...";
    }

    @Override
    protected boolean setData(List newChoices) throws VisADException, RemoteException {
        this.createDataInstances(this.getDataChoices());
        return true;
    }

    @Override
    protected void addNewData(List newChoices) throws VisADException, RemoteException {
        this.processNewData(newChoices);
    }

    protected void processNewData(List newChoices) throws VisADException, RemoteException {
        this.appendDataChoices(newChoices);
        this.createDataInstances(newChoices);
    }

    private void removeData(int row) {
        DataInstance di = (DataInstance)this.dataInstances.get(row);
        try {
            this.display.removeData(di.getData());
            this.dataInstances.remove(row);
            this.dataChoiceList.remove(row);
            this.removeDataChoice(di.getDataChoice());
            this.dataList.setListData(this.dataChoiceList);
        }
        catch (Exception e) {
            OmniControl.logException("removeData:" + row, e);
        }
    }

    private void createDataInstances(List choices) throws VisADException, RemoteException {
        for (int i = 0; i < choices.size(); ++i) {
            DataInstance dataInstance = this.doMakeDataInstance((DataChoice)choices.get(i));
            if (!dataInstance.dataOk()) continue;
            this.display.addData(this.getData(dataInstance));
            this.dataInstances.add(dataInstance);
            this.dataChoiceList.add(dataInstance.getDataChoice());
        }
        this.dataList.setListData(this.dataChoiceList);
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        this.dataInstances.clear();
        this.dataChoiceList.clear();
        this.createDataInstances(this.getDataChoices());
        this.dataList.setListData(this.dataChoiceList);
    }

    private void showDataChoiceMenu(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me)) {
            final Point point = me.getPoint();
            JMenuItem mi = new JMenuItem("Remove");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    OmniControl.this.removeData(OmniControl.this.dataList.locationToIndex(point));
                }
            });
            ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
            items.add(mi);
            JPopupMenu menu = GuiUtils.makePopupMenu(items);
            if (menu != null) {
                menu.show(this.dataList, me.getX(), me.getY());
            }
        }
    }

    public ScalarMap[] getScalarMaps() {
        if (this.display != null) {
            this.scalarMaps = this.display.getMaps();
        }
        return this.scalarMaps;
    }

    public void setScalarMaps(ScalarMap[] maps) {
        this.scalarMaps = maps;
    }

    public String getCellName() {
        if (this.display != null) {
            this.cellName = this.display.getName();
        }
        return this.cellName;
    }

    public void setCellName(String name) {
        this.cellName = name;
    }

    public String getSaveString() {
        if (this.display != null) {
            this.saveString = this.display.getPartialSaveString();
        }
        return this.saveString;
    }

    public void setSaveString(String save) {
        this.saveString = save;
    }
}

