/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointDataInstance;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.idv.control.ObsDisplayControl;
import ucar.unidata.ui.TableSorter;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.UtcDate;
import ucar.visad.Util;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Scalar;
import visad.ScalarType;
import visad.Set;
import visad.Text;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;

public class ObsListControl
extends ObsDisplayControl {
    private static final String DEFAULT_FIELDS = "time,lat,lon,alt";
    private List dataList;
    private List colNames = new ArrayList();
    private List tableRows = new ArrayList();
    private Object TABLE_MUTEX = new Object();
    private JTable obsTable;
    private AbstractTableModel obsModel;
    private TableSorter sorter;
    private Hashtable nameToDescription = new Hashtable();
    JCheckBox includeHeaderCbx;
    private boolean exportingToCsv = false;
    public static boolean debug = false;

    public ObsListControl() {
        this.colString = DEFAULT_FIELDS;
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.setContents(this.doMakeContents());
        return this.setData(dataChoice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDisplay(List dataList) throws VisADException, RemoteException {
        MathType[] comps = null;
        int[] indices = null;
        Unit[] displayUnits = null;
        List cols = null;
        ArrayList<String> tmpColNames = new ArrayList<String>();
        ArrayList tmpRows = new ArrayList();
        boolean doDeclutterTime = this.getTimeDeclutterEnabled();
        Hashtable<Object, Object> seenObs = new Hashtable<Object, Object>();
        for (int dataIdx = 0; dataIdx < dataList.size(); ++dataIdx) {
            FieldImpl data = (FieldImpl)dataList.get(dataIdx);
            if (data == null) continue;
            Set set = data.getDomainSet();
            boolean shapeIndex = false;
            for (int i = 0; i < set.getLength(); ++i) {
                int colIdx;
                PointOb ob = (PointOb)data.getSample(i, false);
                if (doDeclutterTime) {
                    Object timeKey = this.getTimeKey(ob);
                    if (seenObs.get(timeKey) != null) continue;
                    seenObs.put(timeKey, timeKey);
                }
                Tuple obData = (Tuple)ob.getData();
                EarthLocation el = ob.getEarthLocation();
                if (indices == null) {
                    this.makeNameToDescription(ob);
                    TupleType tt = (TupleType)obData.getType();
                    cols = this.getFieldsToShow(tt);
                    comps = tt.getComponents();
                    indices = this.getIndicesToShow(tt);
                    displayUnits = new Unit[obData.getLength()];
                    for (colIdx = 0; colIdx < indices.length; ++colIdx) {
                        String colName = null;
                        if (indices[colIdx] != -1) {
                            colName = Util.cleanTypeName(comps[indices[colIdx]]);
                            displayUnits[indices[colIdx]] = this.getDisplayUnit((Scalar)obData.getComponent(indices[colIdx]));
                            String unitString = this.getDisplayUnitName((Scalar)obData.getComponent(indices[colIdx]));
                            if (unitString != null) {
                                colName = colName + " [" + unitString + "]";
                            }
                        } else if (cols.get(colIdx).equals("lat")) {
                            colName = this.getParamLabel("lat");
                        } else if (cols.get(colIdx).equals("lon")) {
                            colName = this.getParamLabel("lon");
                        } else if (cols.get(colIdx).equals("alt")) {
                            colName = this.getParamLabel("alt");
                            colName = colName + " [" + el.getAltitude().getUnit() + "]";
                        } else if (cols.get(colIdx).equals("time")) {
                            colName = this.getParamLabel("time");
                        }
                        if (colName == null) continue;
                        tmpColNames.add(Util.cleanTypeName(colName));
                    }
                }
                ArrayList<Object> rowData = new ArrayList<Object>();
                tmpRows.add(rowData);
                for (colIdx = 0; colIdx < indices.length; ++colIdx) {
                    void idx = indices[colIdx];
                    if (idx != -1) {
                        rowData.add(new RowData(obData.getComponent((int)idx), comps[idx], displayUnits[idx]));
                        continue;
                    }
                    if (cols.get(colIdx).equals("lat")) {
                        rowData.add(new RowData(el.getLatitude(), true));
                        continue;
                    }
                    if (cols.get(colIdx).equals("lon")) {
                        rowData.add(new RowData(el.getLongitude(), true));
                        continue;
                    }
                    if (cols.get(colIdx).equals("alt")) {
                        rowData.add(new RowData(el.getAltitude(), false));
                        continue;
                    }
                    if (!cols.get(colIdx).equals("time")) continue;
                    if (this.getShowDataRaw()) {
                        rowData.add(this.formatReal(ob.getDateTime()));
                        continue;
                    }
                    rowData.add(new RowData(ob.getDateTime()));
                }
            }
        }
        Object object = this.TABLE_MUTEX;
        synchronized (object) {
            this.tableRows = new ArrayList(tmpRows);
            this.colNames = new ArrayList(tmpColNames);
            if (this.obsModel != null) {
                this.obsModel.fireTableStructureChanged();
            }
        }
    }

    private Object formatReal(Real r) {
        if (this.getShowDataRaw()) {
            return new Double(r.getValue());
        }
        return new ObsDisplayControl.RealWrapper(this.getDisplayConventions().format(r.getValue()), r);
    }

    private Object formatLatLon(Real r) {
        if (this.getShowDataRaw()) {
            return new Double(r.getValue());
        }
        return new ObsDisplayControl.RealWrapper(this.getDisplayConventions().formatLatLon(r.getValue()), r);
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (!super.setData(choice)) {
            return false;
        }
        this.loadData();
        return true;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.obsModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public int getRowCount() {
                return ObsListControl.this.tableRows.size();
            }

            @Override
            public int getColumnCount() {
                return ObsListControl.this.colNames.size();
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object getValueAt(int row, int column) {
                Object object = ObsListControl.this.TABLE_MUTEX;
                synchronized (object) {
                    List rowData;
                    if (row < ObsListControl.this.tableRows.size() && column < (rowData = (List)ObsListControl.this.tableRows.get(row)).size()) {
                        Object value = rowData.get(column);
                        if (value instanceof RowData) {
                            value = ((RowData)value).getValue();
                        }
                        if (ObsListControl.this.exportingToCsv && Misc.equals("missing", value.toString())) {
                            return "NaN";
                        }
                        return value;
                    }
                    return "";
                }
            }

            @Override
            public String getColumnName(int column) {
                return ObsListControl.this.colNames.get(column).toString();
            }
        };
        this.sorter = new TableSorter(this.obsModel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Comparator getComparator(int column) {
                Object object = ObsListControl.this.TABLE_MUTEX;
                synchronized (object) {
                    Object obj;
                    if (ObsListControl.this.tableRows.size() > 0 && ((obj = ((List)ObsListControl.this.tableRows.get(0)).get(column)) instanceof Double || obj instanceof ObsDisplayControl.RealWrapper)) {
                        return COMPARABLE_COMAPRATOR;
                    }
                    return super.getComparator(column);
                }
            }
        };
        this.obsTable = new JTable(this.sorter);
        this.obsTable.setColumnModel(new DefaultTableColumnModel(){

            @Override
            public TableColumn getColumn(int index) {
                int cnt = this.getColumnCount();
                if (index >= cnt) {
                    int numTries = 0;
                    while (index >= cnt && numTries++ < 10) {
                        Misc.sleep(100L);
                    }
                }
                return super.getColumn(index);
            }
        });
        JTableHeader header = this.obsTable.getTableHeader();
        header.setToolTipText("Click to sort");
        this.sorter.setTableHeader(this.obsTable.getTableHeader());
        int width = 300;
        int height = 400;
        JScrollPane scroller = GuiUtils.makeScrollPane(this.obsTable, width, height);
        scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        scroller.setPreferredSize(new Dimension(width, height));
        scroller.setMinimumSize(new Dimension(width, height));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        tablePanel.add(header);
        tablePanel.add(scroller);
        JComponent[] timeDeclutterComps = this.getTimeDeclutterComps();
        JPanel timeDeclutterPanel = GuiUtils.hbox(Misc.newList(timeDeclutterComps[0], GuiUtils.rLabel("Only show every: "), timeDeclutterComps[1], GuiUtils.lLabel(" minutes"), new JLabel("     ")));
        JPanel topPanel = GuiUtils.leftCenterRight(this.doMakeFieldSelector(), GuiUtils.left(timeDeclutterPanel), this.doMakeShowRawSelector());
        return GuiUtils.topCenter(GuiUtils.inset((Component)topPanel, 5), tablePanel);
    }

    @Override
    protected void timeDeclutterChanged() {
        this.fieldSelectorChanged();
    }

    @Override
    protected TupleType getTupleType() throws RemoteException, VisADException {
        if (this.dataList == null || this.dataList.size() == 0) {
            return null;
        }
        FieldImpl data = (FieldImpl)this.dataList.get(0);
        Set set = data.getDomainSet();
        if (set.getLength() == 0) {
            return null;
        }
        PointOb ob = (PointOb)data.getSample(0, false);
        Tuple obData = (Tuple)ob.getData();
        return (TupleType)obData.getType();
    }

    @Override
    protected void fieldSelectorChanged() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                ObsListControl.this.loadData();
            }
        });
    }

    protected void loadData() {
        try {
            PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
            if (pdi == null) {
                return;
            }
            this.dataList = new ArrayList();
            FieldImpl data = (FieldImpl)pdi.getData();
            if (data == null) {
                return;
            }
            if (GridUtil.isTimeSequence(data)) {
                Set timeSet = data.getDomainSet();
                for (int i = 0; i < timeSet.getLength(); ++i) {
                    this.dataList.add(data.getSample(i, false));
                }
            } else {
                this.dataList.add(data);
            }
            this.makeDisplay(this.dataList);
        }
        catch (Exception excp) {
            ObsListControl.logException("loading data ", excp);
        }
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeMenuItem("Export Table to CSV...", this, "exportTable"));
        items.add(GuiUtils.makeMenuItem("Export all data to NetCDF...", this, "exportAsNetcdf", null, true));
    }

    public void exportTable() {
        String filename;
        if (this.includeHeaderCbx == null) {
            this.includeHeaderCbx = new JCheckBox("Include metadata header", true);
            this.includeHeaderCbx.setToolTipText("Should the IDV metadata header be included in the CSV file?");
        }
        if ((filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_CSV, FileManager.FILTER_XLS), ".csv", (JComponent)GuiUtils.top(this.includeHeaderCbx))) == null) {
            return;
        }
        this.exportingToCsv = true;
        GuiUtils.exportAsCsv(this.includeHeaderCbx.isSelected() ? this.makeFileHeader(this.sorter) : "", (TableModel)this.sorter, filename);
        this.exportingToCsv = false;
    }

    private void makeNameToDescription(PointOb ob) throws VisADException, RemoteException {
        this.nameToDescription.clear();
        DateTime dt = ob.getDateTime();
        this.nameToDescription.put(RealType.Time.getName(), this.makeDescription(dt));
        EarthLocation el = ob.getEarthLocation();
        this.nameToDescription.put(RealType.Latitude.getName(), this.makeDescription(el.getLatitude()));
        this.nameToDescription.put(RealType.Longitude.getName(), this.makeDescription(el.getLongitude()));
        this.nameToDescription.put(RealType.Altitude.getName(), this.makeDescription(el.getAltitude()));
        Tuple t = (Tuple)ob.getData();
        for (int i = 0; i < t.getDimension(); ++i) {
            Scalar s = (Scalar)t.getComponent(i);
            String cleanName = Util.cleanTypeName(s.getType().prettyString());
            if (this.nameToDescription.get(cleanName) != null) continue;
            this.nameToDescription.put(cleanName, this.makeDescription(s));
        }
    }

    private String makeDescription(Scalar s) {
        StringBuffer buf = new StringBuffer();
        String name = ((ScalarType)s.getType()).getName();
        name = Util.cleanTypeName(name);
        if (s instanceof Text) {
            buf.append(name + "(Text)");
        } else if (s instanceof DateTime && !this.getShowDataRaw()) {
            DateTime d = (DateTime)s;
            buf.append(name);
            buf.append("[fmt=");
            buf.append('\"' + DateTime.getFormatPattern() + '\"');
            buf.append("]");
        } else {
            buf.append(name);
            buf.append("[unit=\"");
            if (this.getShowDataRaw()) {
                buf.append(((Real)s).getUnit());
            } else {
                buf.append(this.getDisplayConventions().getDisplayUnit(name, ((Real)s).getUnit()));
            }
            buf.append("\"]");
        }
        return buf.toString();
    }

    private String makeFileHeader(TableSorter sorter) {
        int i;
        StringBuffer buf = new StringBuffer();
        int numParams = sorter.getColumnCount();
        Object[] names = new String[numParams];
        for (i = 0; i < numParams; ++i) {
            names[i] = this.removeUnitString(sorter.getColumnName(i));
            String desc = (String)this.nameToDescription.get(names[i]);
            if (((String)names[i]).equals(LABEL_TIME)) {
                names[i] = RealType.Time.getName();
                continue;
            }
            if (desc == null) {
                String key = (String)names[i] + "(Text)";
                String s = (String)this.nameToDescription.get(key);
                if (s == null) continue;
                names[i] = key;
                continue;
            }
            if (desc.indexOf("(Text)") < 0) continue;
            names[i] = (String)names[i] + "(Text)";
        }
        buf.append("(index) -> (");
        buf.append(StringUtil.join(",", names));
        buf.append(")\n");
        for (i = 0; i < numParams; ++i) {
            if (names[i] == RealType.Time.getName() && !this.getShowDataRaw()) {
                StringBuffer buf2 = new StringBuffer((String)names[i]);
                buf2.append("[fmt=");
                buf2.append("\"yyyy-MM-dd HH:mm:ss\"");
                buf2.append("]");
                names[i] = buf2.toString();
                continue;
            }
            String s = (String)this.nameToDescription.get(names[i]);
            if (s == null) continue;
            names[i] = s;
        }
        buf.append(StringUtil.join(",", names));
        buf.append("\n");
        return buf.toString();
    }

    private String removeUnitString(String name) {
        if (name.indexOf("[") > -1 && name.indexOf("]") > -1) {
            return name.substring(0, name.indexOf("[")).trim();
        }
        return name;
    }

    @Override
    public void doExport(String what, String filename) throws Exception {
        if (what.contains("csv")) {
            this.colString = "*";
            this.loadData();
            this.exportingToCsv = true;
            GuiUtils.exportAsCsv(this.makeFileHeader(this.sorter), (TableModel)this.sorter, filename + ".csv");
            this.exportingToCsv = false;
        }
        if (what.contains("netcdf")) {
            PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
            PointObFactory.writeToNetcdf(new File(filename + ".nc"), pdi.getTimeSequence());
        }
    }

    private class RowData {
        Object value;
        Data data;
        MathType type;
        Real alt;
        Real latLon;
        Real real;
        DateTime dttm;
        Unit displayUnit;

        public RowData(DateTime dttm) {
            this.dttm = dttm;
        }

        public RowData(Real value, boolean isLatLon) {
            if (isLatLon) {
                this.latLon = value;
            } else {
                this.real = value;
            }
        }

        public RowData(Data data, MathType type, Unit displayUnit) {
            this.displayUnit = displayUnit;
            this.data = data;
            this.type = type;
        }

        public Object getValue() {
            if (ObsListControl.this.exportingToCsv && this.dttm != null) {
                return UtcDate.formatUtcDate(this.dttm, "yyyy-MM-dd HH:mm:ss");
            }
            if (this.value == null) {
                if (this.data != null) {
                    this.value = ObsListControl.this.getColValue(this.data, this.type, false, this.displayUnit);
                } else if (this.latLon != null) {
                    this.value = ObsListControl.this.formatLatLon(this.latLon);
                } else if (this.dttm != null) {
                    this.value = this.dttm.toString();
                } else if (this.real != null) {
                    this.value = ObsListControl.this.formatReal(this.real);
                }
            }
            return this.value;
        }
    }
}

