/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointDataInstance;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.ui.PropertyFilter;
import ucar.unidata.ui.TwoListPanel;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.Scalar;
import visad.Set;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;

public abstract class ObsDisplayControl
extends DisplayControlImpl {
    private static final PropertyFilter dummyFilter = null;
    protected static final String FIELD_ALL = "*";
    protected static DecimalFormat format = new DecimalFormat("####.0");
    protected String colString = "*";
    protected static String LABEL_LAT = "Latitude";
    protected static String LABEL_LON = "Longitude";
    protected static String LABEL_ALT = "Altitude";
    protected static String LABEL_TIME = "Date/Time";
    protected List colNames = new ArrayList();
    private JTextField colField;
    private JDialog selectorWindow;
    private TwoListPanel twoListPanel;
    private boolean showDataRaw = false;
    private String dataTemplate = null;
    private double timeDeclutterMinutes = 1.0;
    JComponent[] timeDeclutterComps;
    private JTextField timeDeclutterFld;
    private boolean timeDeclutterEnabled = false;
    private JCheckBox timeDeclutterCbx;
    private Hashtable nameToLabel;
    private boolean ignoreTimeDeclutterEnabled = false;

    public ObsDisplayControl() {
        this.initLabels();
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        super.doRemove();
        if (this.selectorWindow != null) {
            this.selectorWindow.dispose();
        }
    }

    public void exportAsNetcdf() {
        try {
            JComboBox publishCbx = this.getIdv().getPublishManager().getSelector("nc.export");
            String filename = FileManager.getWriteFile(FileManager.FILTER_NETCDF, ".nc", (JComponent)(publishCbx != null ? GuiUtils.top(publishCbx) : null));
            if (filename == null) {
                return;
            }
            PointDataInstance pdi = (PointDataInstance)this.getDataInstance();
            PointObFactory.writeToNetcdf(new File(filename), pdi.getTimeSequence());
            this.getIdv().getPublishManager().publishContent(filename, null, publishCbx);
        }
        catch (Exception exc) {
            ObsDisplayControl.logException("Exporting point data to netcdf", exc);
        }
    }

    protected Object getColValue(Data data, MathType type, boolean useFormatPref) {
        Unit displayUnit = null;
        if (data instanceof Real) {
            displayUnit = this.getDisplayConventions().getDisplayUnit(type.toString(), ((Real)data).getUnit());
        }
        return this.getColValue(data, type, useFormatPref, displayUnit);
    }

    protected Object getColValue(Data data, MathType type, boolean useFormatPref, Unit displayUnit) {
        if (!(data instanceof Real)) {
            return data.toString();
        }
        try {
            Real r = (Real)data;
            if (this.getShowDataRaw()) {
                return new Double(r.getValue());
            }
            double value = displayUnit != null ? r.getValue(displayUnit) : r.getValue();
            if (value != value) {
                return new RealWrapper(this.getDisplayConventions().format(value), r);
            }
            if (useFormatPref) {
                String valueStr = null;
                if (displayUnit != null && !displayUnit.toString().equals("")) {
                    if (this.dataTemplate == null) {
                        this.dataTemplate = this.getObjectStore().get("DisplayControlImpl.ProbeFormat", "<b>%value%</b> [%unit%] ");
                        this.dataTemplate = this.dataTemplate.trim();
                        if (this.dataTemplate.equals("")) {
                            this.dataTemplate = "%value%";
                        }
                    }
                    valueStr = this.getDisplayConventions().format(value);
                    valueStr = StringUtil.replace(this.dataTemplate, "%value%", valueStr);
                    valueStr = StringUtil.replace(valueStr, "%rawvalue%", "" + r.getValue());
                    valueStr = StringUtil.replace(valueStr, "%unit%", displayUnit.toString());
                    valueStr = StringUtil.replace(valueStr, "%rawunit%", "" + r.getUnit());
                    valueStr = "<html>" + valueStr + "</html>";
                }
                if (valueStr == null) {
                    valueStr = this.getDisplayConventions().format(value);
                }
                return new RealWrapper(valueStr, r);
            }
            return new RealWrapper(this.getDisplayConventions().format(value), r);
        }
        catch (Exception exc) {
            return "error:" + exc;
        }
    }

    protected String getDisplayUnitName(Scalar data) {
        Unit displayUnit = this.getDisplayUnit(data);
        if (displayUnit == null || displayUnit.toString().equals("")) {
            return null;
        }
        return displayUnit.toString();
    }

    protected Unit getDisplayUnit(Scalar data) {
        Unit displayUnit;
        if (!(data instanceof Real)) {
            return null;
        }
        Real r = (Real)data;
        Unit unit = displayUnit = this.getShowDataRaw() ? r.getUnit() : this.getDisplayConventions().getDisplayUnit(r.getType().toString(), r.getUnit());
        if (displayUnit == null || displayUnit.toString().equals("")) {
            return null;
        }
        return displayUnit;
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        this.dataTemplate = null;
        this.fieldSelectorChanged();
    }

    protected FieldImpl doDeclutterTime(FieldImpl obs) throws VisADException, RemoteException {
        boolean isTimeSequence = GridUtil.isTimeSequence(obs);
        if (!isTimeSequence) {
            return obs;
        }
        Set timeSet = obs.getDomainSet();
        int numTimes = timeSet.getLength();
        ArrayList<FieldImpl> timeFields = new ArrayList<FieldImpl>();
        ArrayList<DateTime> timeValues = new ArrayList<DateTime>();
        Hashtable<Integer, Integer> seenTime = new Hashtable<Integer, Integer>();
        int seconds = (int)(this.timeDeclutterMinutes * 60.0);
        if (seconds == 0) {
            seconds = 1;
        }
        for (int timeIdx = 0; timeIdx < numTimes; ++timeIdx) {
            FieldImpl oneTime = (FieldImpl)obs.getSample(timeIdx);
            PointOb ob = null;
            int numObs = oneTime.getDomainSet().getLength();
            for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                PointOb tmpOb = (PointOb)oneTime.getSample(obIdx);
                double time = tmpOb.getDateTime().getValue();
                if (!(time > 0.0) && !(time < 0.0)) continue;
                ob = tmpOb;
                break;
            }
            if (ob == null) continue;
            Integer timeKey = new Integer((int)ob.getDateTime().getValue() / seconds);
            if (timeIdx < numTimes - 1 && seenTime.get(timeKey) != null) continue;
            seenTime.put(timeKey, timeKey);
            timeFields.add(oneTime);
            timeValues.add(ob.getDateTime());
        }
        if (timeValues.size() == 0) {
            System.err.println("found:" + timeValues.size());
            return obs;
        }
        DateTime[] times = timeValues.toArray(new DateTime[timeValues.size()]);
        FieldImpl newField = new FieldImpl((FunctionType)obs.getType(), CalendarDateTime.makeTimeSet(times));
        for (int i = 0; i < timeFields.size(); ++i) {
            newField.setSample(i, (Data)((FieldImpl)timeFields.get(i)), false);
        }
        return newField;
    }

    Object getTimeKey(PointOb ob) {
        int seconds = (int)(this.timeDeclutterMinutes * 60.0);
        return new Integer((int)ob.getDateTime().getValue() / seconds);
    }

    protected void timeDeclutterChanged() {
    }

    protected JComponent[] getTimeDeclutterComps() {
        if (this.timeDeclutterComps != null) {
            return this.timeDeclutterComps;
        }
        ActionListener timeDeclutterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    if (ObsDisplayControl.this.ignoreTimeDeclutterEnabled) {
                        return;
                    }
                    ObsDisplayControl.this.timeDeclutterMinutes = Misc.parseNumber(ObsDisplayControl.this.timeDeclutterFld.getText().trim());
                    if (ObsDisplayControl.this.timeDeclutterEnabled != ObsDisplayControl.this.timeDeclutterCbx.isSelected()) {
                        ObsDisplayControl.this.timeDeclutterEnabled = ObsDisplayControl.this.timeDeclutterCbx.isSelected();
                        ObsDisplayControl.this.timeDeclutterChanged();
                    } else if (ObsDisplayControl.this.timeDeclutterEnabled) {
                        ObsDisplayControl.this.timeDeclutterChanged();
                    }
                }
                catch (NumberFormatException nfe) {
                    ObsDisplayControl.this.userErrorMessage("Bad number format");
                }
            }
        };
        this.timeDeclutterFld = new JTextField(this.getDisplayConventions().format(this.getTimeDeclutterMinutes()), 5);
        this.timeDeclutterFld.addActionListener(timeDeclutterListener);
        this.timeDeclutterCbx = new JCheckBox("", this.getTimeDeclutterEnabled());
        this.timeDeclutterCbx.addActionListener(timeDeclutterListener);
        this.timeDeclutterComps = new JComponent[]{this.timeDeclutterCbx, this.timeDeclutterFld};
        return this.timeDeclutterComps;
    }

    protected boolean isIdParam(String name) {
        if ((name = StringUtil.replace(name, "(Text)", "").trim()).equalsIgnoreCase("ID") || name.equalsIgnoreCase("IDN")) {
            return true;
        }
        String canonical = DataAlias.aliasToCanonical(name);
        if (canonical != null) {
            return canonical.equals("ID") || canonical.equals("IDN");
        }
        return false;
    }

    protected String getParamLabel(String name) {
        String s;
        if (this.nameToLabel == null) {
            this.initLabels();
        }
        return (s = (String)this.nameToLabel.get(name)) != null ? s : name;
    }

    private void initLabels() {
        this.nameToLabel = new Hashtable();
        this.nameToLabel.put("lat", LABEL_LAT);
        this.nameToLabel.put("lon", LABEL_LON);
        this.nameToLabel.put("alt", LABEL_ALT);
        this.nameToLabel.put("time", LABEL_TIME);
    }

    protected List getFieldsToShow(TupleType tt) throws VisADException, RemoteException {
        if (this.colString.equals(FIELD_ALL)) {
            MathType[] comps = tt.getComponents();
            ArrayList<String> names = new ArrayList<String>();
            names.add("time");
            names.add("lat");
            names.add("lon");
            names.add("alt");
            for (int i = 0; i < comps.length; ++i) {
                String param = Util.cleanTypeName(comps[i].toString());
                names.add(param);
            }
            return names;
        }
        return StringUtil.split(this.colString, ",");
    }

    protected int[] getIndicesToShow(TupleType tt) throws VisADException, RemoteException {
        List cols = this.getFieldsToShow(tt);
        int[] indices = new int[cols.size()];
        MathType[] comps = tt.getComponents();
        for (int compIdx = 0; compIdx < comps.length; ++compIdx) {
        }
        for (int colIdx = 0; colIdx < cols.size(); ++colIdx) {
            String colName = cols.get(colIdx).toString();
            indices[colIdx] = this.getIndex(tt, colName);
            if (indices[colIdx] != -1) continue;
            indices[colIdx] = this.getIndex(tt, colName.toLowerCase());
            if (indices[colIdx] != -1) continue;
            indices[colIdx] = this.getIndex(tt, colName.toUpperCase());
        }
        return indices;
    }

    protected int getIndex(TupleType tType, String commaSeparatedNames) {
        List<String> l = StringUtil.split(commaSeparatedNames, ",", true, true);
        for (int i = 0; i < l.size(); ++i) {
            String name = l.get(i).toString();
            if (name.equals("time")) {
                return -1;
            }
            int index = Util.getIndex(tType, name);
            if (index != -1) {
                return index;
            }
            List aliases = DataAlias.getAliasesOf(name);
            if (aliases == null || aliases.isEmpty()) continue;
            for (int aliasIdx = 0; aliasIdx < aliases.size(); ++aliasIdx) {
                String alias = (String)aliases.get(aliasIdx);
                index = Util.getIndex(tType, alias);
                if (index == -1) continue;
                return index;
            }
        }
        return -1;
    }

    private void handleFieldSelectorEvent(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_APPLY) || cmd.equals(GuiUtils.CMD_OK)) {
            this.colString = StringUtil.join(",", TwoFacedObject.getIdStrings(this.twoListPanel.getCurrentEntries()));
            this.fieldSelectorChanged();
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL) || cmd.equals(GuiUtils.CMD_OK)) {
            this.selectorWindow.setVisible(false);
        }
    }

    public void showFieldSelector() {
        if (this.selectorWindow == null) {
            this.twoListPanel = new TwoListPanel(new ArrayList(), "All Fields", new ArrayList(), "Current Fields", null);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ObsDisplayControl.this.handleFieldSelectorEvent(ae);
                }
            };
            JPanel buttons = GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_APPLY, GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL});
            JPanel contents = GuiUtils.centerBottom(this.twoListPanel, buttons);
            this.selectorWindow = GuiUtils.createDialog(null, "Field Selector", false);
            this.selectorWindow.getContentPane().add(contents);
            this.selectorWindow.pack();
        }
        try {
            ArrayList<TwoFacedObject> selectedFields;
            ArrayList<TwoFacedObject> allFields = new ArrayList<TwoFacedObject>();
            TupleType tt = this.getTupleType();
            if (tt == null) {
                return;
            }
            MathType[] comps = tt.getComponents();
            allFields.add(new TwoFacedObject((Object)this.getParamLabel("time"), "time"));
            allFields.add(new TwoFacedObject((Object)this.getParamLabel("lat"), "lat"));
            allFields.add(new TwoFacedObject((Object)this.getParamLabel("lon"), "lon"));
            allFields.add(new TwoFacedObject((Object)this.getParamLabel("alt"), "alt"));
            for (int compIdx = 0; compIdx < comps.length; ++compIdx) {
                String name = Util.cleanTypeName(comps[compIdx]);
                allFields.add(new TwoFacedObject(name));
            }
            if (this.colString.equals(FIELD_ALL)) {
                selectedFields = new ArrayList<TwoFacedObject>(allFields);
            } else {
                ArrayList tfos = new ArrayList();
                List<String> names = StringUtil.split(this.colString, ",", true, true);
                selectedFields = new ArrayList();
                for (int i = 0; i < names.size(); ++i) {
                    String id = names.get(i);
                    selectedFields.add(new TwoFacedObject((Object)this.getParamLabel(id), id));
                }
            }
            this.twoListPanel.reinitialize(allFields, selectedFields);
            this.selectorWindow.setVisible(true);
        }
        catch (Exception exc) {
            ObsDisplayControl.logException("Showing field selector", exc);
        }
    }

    protected JPanel doMakeShowRawSelector() {
        JCheckBox rawCbx = new JCheckBox("Show Raw Data", this.getShowDataRaw());
        rawCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JCheckBox cbox = (JCheckBox)ae.getSource();
                if (cbox.isSelected() != ObsDisplayControl.this.getShowDataRaw()) {
                    ObsDisplayControl.this.setShowDataRaw(cbox.isSelected());
                    ObsDisplayControl.this.fieldSelectorChanged();
                }
            }
        });
        return GuiUtils.right(rawCbx);
    }

    protected JPanel doMakeFieldSelector() {
        JButton showBtn = new JButton("Select Fields");
        showBtn.setToolTipText("Change the  fields that are being displayed");
        showBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ObsDisplayControl.this.showFieldSelector();
            }
        });
        return GuiUtils.left(showBtn);
    }

    protected void fieldSelectorChanged() {
    }

    protected TupleType getTupleType() throws RemoteException, VisADException {
        return null;
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        DataSelection ds = this.getDataSelection();
        Object t = ds.getProperty("Use_Progressive_Resolution");
        if (t != null) {
            this.isProgressiveResolution = (Boolean)t;
        }
        return new PointDataInstance(dataChoice, this.getDataSelection(), this.getRequestProperties());
    }

    public void setColString(String value) {
        this.colString = value;
    }

    public String getColString() {
        return this.colString;
    }

    public void setShowDataRaw(boolean value) {
        this.showDataRaw = value;
        this.fieldSelectorChanged();
    }

    public boolean getShowDataRaw() {
        return this.showDataRaw;
    }

    public void setTimeDeclutterMinutes(double value) {
        this.timeDeclutterMinutes = value;
    }

    public void updateTimeDeclutterMinutes(double value) {
        this.timeDeclutterMinutes = value;
        this.timeDeclutterFld.setText(this.getDisplayConventions().format(this.getTimeDeclutterMinutes()));
    }

    public double getTimeDeclutterMinutes() {
        return this.timeDeclutterMinutes;
    }

    public void setTimeDeclutterEnabled(boolean value) {
        this.timeDeclutterEnabled = value;
        if (this.timeDeclutterCbx != null && value != this.timeDeclutterCbx.isSelected()) {
            this.ignoreTimeDeclutterEnabled = true;
            this.timeDeclutterCbx.setSelected(value);
            this.ignoreTimeDeclutterEnabled = false;
        }
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        dsd.addPropertyValue(new Boolean(this.getTimeDeclutterEnabled()), "timeDeclutterEnabled", "Subset Times", "Display");
        dsd.addPropertyValue(new Float(this.getTimeDeclutterMinutes()), "timeDeclutterMinutes", "Subset Interval (min)", "Display");
    }

    public boolean getTimeDeclutterEnabled() {
        return this.timeDeclutterEnabled;
    }

    protected static class RealWrapper
    implements Comparable {
        String lbl;
        Real value;

        public RealWrapper(String lbl, Real value) {
            this.lbl = lbl;
            this.value = value;
        }

        public int compareTo(Object that) {
            if (that instanceof RealWrapper) {
                return this.value.compareTo(((RealWrapper)that).value);
            }
            return this.toString().compareTo(that.toString());
        }

        public String toString() {
            return this.lbl;
        }
    }
}

