/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.Time;
import javax.swing.JPanel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.DisplayControlImpl;
import visad.VisADException;

public class MovieDisplayControl
extends DisplayControlImpl
implements ControllerListener {
    Player player = null;
    Component visualComponent = null;
    Component controlComponent = null;
    Component progressBar = null;
    boolean firstTime = true;
    long CachingSize = 0L;
    JPanel panel = null;
    int controlPanelHeight = 0;
    int videoWidth = 0;
    int videoHeight = 0;
    String mediaFile;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.mediaFile = dataChoice.getStringId();
        if (new File(this.mediaFile).exists()) {
            this.mediaFile = "file:" + this.mediaFile;
        }
        MediaLocator mrl = null;
        try {
            mrl = new MediaLocator(this.mediaFile);
            if (mrl == null) {
                MovieDisplayControl.userMessage("Can't build URL for " + this.mediaFile);
                return false;
            }
            try {
                this.player = Manager.createPlayer((MediaLocator)mrl);
            }
            catch (NoPlayerException e) {
                MovieDisplayControl.logException("Could not create player for " + mrl, (Exception)((Object)e));
                return false;
            }
        }
        catch (MalformedURLException e) {
            MovieDisplayControl.userMessage("Invalid media file URL!");
        }
        catch (IOException e) {
            MovieDisplayControl.userMessage("IO exception creating player for " + mrl);
            return false;
        }
        return true;
    }

    @Override
    public void initDone() {
        super.initDone();
        this.player.addControllerListener((ControllerListener)this);
        this.player.start();
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.panel = new JPanel();
        this.panel.setLayout(null);
        this.panel.setBounds(0, 0, 320, 240);
        return this.panel;
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (this.player == null) {
            return;
        }
        if (event instanceof RealizeCompleteEvent) {
            if (this.progressBar != null) {
                this.panel.remove(this.progressBar);
                this.progressBar = null;
            }
            int width = 320;
            int height = 0;
            if (this.controlComponent == null && (this.controlComponent = this.player.getControlPanelComponent()) != null) {
                this.controlPanelHeight = this.controlComponent.getPreferredSize().height;
                this.panel.add(this.controlComponent);
                height += this.controlPanelHeight;
            }
            if (this.visualComponent == null && (this.visualComponent = this.player.getVisualComponent()) != null) {
                this.panel.add(this.visualComponent);
                Dimension videoSize = this.visualComponent.getPreferredSize();
                this.videoWidth = videoSize.width;
                this.videoHeight = videoSize.height;
                width = this.videoWidth;
                height += this.videoHeight;
                this.visualComponent.setBounds(0, 0, this.videoWidth, this.videoHeight);
            }
            this.panel.setPreferredSize(new Dimension(width, height));
            this.panel.setMinimumSize(new Dimension(width, height));
            if (this.controlComponent != null) {
                this.controlComponent.setBounds(0, this.videoHeight, width, this.controlPanelHeight);
                this.controlComponent.invalidate();
            }
            this.redoGuiLayout();
        } else if (event instanceof CachingControlEvent) {
            if (this.player.getState() > 200) {
                return;
            }
            CachingControlEvent e = (CachingControlEvent)event;
            CachingControl cc = e.getCachingControl();
            if (this.progressBar == null && (this.progressBar = cc.getControlComponent()) != null) {
                this.panel.add(this.progressBar);
                this.panel.setSize(this.progressBar.getPreferredSize());
                this.redoGuiLayout();
            }
        } else if (event instanceof EndOfMediaEvent) {
            this.player.setMediaTime(new Time(0L));
            this.player.start();
        } else if (event instanceof ControllerErrorEvent) {
            this.player = null;
            MovieDisplayControl.userMessage(((ControllerErrorEvent)event).getMessage());
        } else if (event instanceof ControllerClosedEvent) {
            this.panel.removeAll();
        }
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        super.doRemove();
        if (this.player != null) {
            this.player.removeControllerListener((ControllerListener)this);
            this.player.stop();
            this.player.close();
            this.player = null;
        }
    }
}

