/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.chart.DataChoiceWrapper;
import ucar.unidata.idv.control.chart.HistogramWrapper;
import ucar.unidata.idv.control.chart.MyHistogramDataset;
import ucar.unidata.idv.control.multi.DisplayGroup;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.visad.Util;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.Unit;
import visad.VisADException;

public class McVHistogramWrapper
extends HistogramWrapper {
    private static final Logger logger = LoggerFactory.getLogger(McVHistogramWrapper.class);
    private DisplayControl imageControl;
    private XYPlot plot;
    private double low;
    private double high;

    public McVHistogramWrapper() {
    }

    public McVHistogramWrapper(String name, List dataChoices, DisplayControlImpl control) {
        super(name, dataChoices);
        this.imageControl = control;
    }

    private void createChart() {
        if (this.chartPanel != null) {
            return;
        }
        MyHistogramDataset dataset = new MyHistogramDataset();
        this.chart = ChartFactory.createHistogram((String)"Histogram", null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.chart.getXYPlot().setForegroundAlpha(0.75f);
        this.plot = (XYPlot)this.chart.getPlot();
        this.initXYPlot(this.plot);
        this.chartPanel = this.doMakeChartPanel(this.chart);
    }

    @Override
    public JComponent doMakeContents() {
        return super.doMakeContents();
    }

    public void clearHistogram() {
        if (this.chartPanel != null) {
            XYPlot tempPlot = this.chartPanel.getChart().getXYPlot();
            for (int i = 0; i < tempPlot.getDatasetCount(); ++i) {
                MyHistogramDataset dataset = (MyHistogramDataset)tempPlot.getDataset(i);
                if (dataset == null) continue;
                dataset.removeAllSeries();
            }
        }
    }

    public void saveImage() {
        JComboBox publishCbx = this.imageControl.getViewManager().getPublishManager().getSelector("nc.export");
        String filename = FileManager.getWriteFile(FileManager.FILTER_IMAGE, ".jpg", (JComponent)(publishCbx != null ? GuiUtils.top(publishCbx) : null));
        if (filename == null) {
            return;
        }
        try {
            ImageUtils.writeImageToFile(this.getContents(), filename);
            this.imageControl.getViewManager().getPublishManager().publishContent(filename, null, publishCbx);
        }
        catch (Exception exc) {
            LogUtil.logException("Capturing image", exc);
        }
    }

    public void loadData(FlatField data) throws IllegalArgumentException, RemoteException, VisADException {
        if (data == null || GridUtil.isAllMissing(data)) {
            throw new IllegalArgumentException("Nothing to show in histogram");
        }
        this.reallyLoadData(data);
    }

    private void reallyLoadData(FlatField data) throws VisADException, RemoteException {
        this.createChart();
        List dataChoiceWrappers = this.getDataChoiceWrappers();
        try {
            this.clearHistogram();
            Hashtable props = new Hashtable();
            ErrorEstimate[] errOut = new ErrorEstimate[1];
            for (int paramIdx = 0; paramIdx < dataChoiceWrappers.size(); ++paramIdx) {
                DataChoiceWrapper wrapper = (DataChoiceWrapper)dataChoiceWrappers.get(paramIdx);
                DataChoice dataChoice = wrapper.getDataChoice();
                props = dataChoice.getProperties();
                Unit defaultUnit = Util.getDefaultRangeUnits(data)[0];
                Unit unit = ((DisplayControlImpl)this.imageControl).getDisplayUnit();
                double[][] samples = data.getValues(false);
                double[] actualValues = this.filterData(samples[0], this.getTimeValues(samples, data))[0];
                if (defaultUnit != null && !defaultUnit.equals(unit)) {
                    actualValues = Unit.transformUnits(unit, errOut, defaultUnit, null, actualValues);
                }
                final NumberAxis domainAxis = new NumberAxis(wrapper.getLabel(unit));
                domainAxis.setAutoRangeIncludesZero(false);
                Object renderer = this.getStacked() ? new StackedXYBarRenderer() : new XYBarRenderer();
                if (this.plot == null && this.chartPanel != null) {
                    this.plot = this.chartPanel.getChart().getXYPlot();
                }
                double[] newactualValues = this.removeMissing(actualValues);
                this.plot.setRenderer(paramIdx, (XYItemRenderer)renderer);
                Color c = wrapper.getColor(paramIdx);
                domainAxis.setLabelPaint((Paint)c);
                renderer.setSeriesPaint(0, (Paint)c);
                MyHistogramDataset dataset = new MyHistogramDataset();
                dataset.setType(HistogramType.FREQUENCY);
                dataset.addSeries((Comparable)((Object)(dataChoice.getName() + " [" + unit + ']')), newactualValues, this.getBins());
                samples = null;
                actualValues = null;
                newactualValues = null;
                this.plot.setDomainAxis(paramIdx, (ValueAxis)domainAxis, false);
                this.plot.mapDatasetToDomainAxis(paramIdx, paramIdx);
                this.plot.setDataset(paramIdx, (XYDataset)dataset);
                domainAxis.addChangeListener(new AxisChangeListener(){

                    public void axisChanged(AxisChangeEvent ae) {
                        if (!McVHistogramWrapper.this.imageControl.isInitDone()) {
                            return;
                        }
                        Range range = domainAxis.getRange();
                        double newLow = Math.floor(range.getLowerBound() + 0.5);
                        double newHigh = Math.floor(range.getUpperBound() + 0.5);
                        double prevLow = McVHistogramWrapper.this.getLow();
                        double prevHigh = McVHistogramWrapper.this.getHigh();
                        try {
                            ucar.unidata.util.Range newRange = prevLow > prevHigh ? new ucar.unidata.util.Range(newHigh, newLow) : new ucar.unidata.util.Range(newLow, newHigh);
                            ((DisplayControlImpl)McVHistogramWrapper.this.imageControl).setRange(newRange);
                        }
                        catch (Exception e) {
                            logger.error("Cannot change range", e);
                        }
                    }
                });
                Range range = domainAxis.getRange();
                this.low = range.getLowerBound();
                this.high = range.getUpperBound();
            }
        }
        catch (Exception exc) {
            System.out.println("Exception exc=" + exc);
            LogUtil.logException("Error creating data set", exc);
        }
    }

    private double[] removeMissingValues(double[] samples) {
        ArrayList<Double> newSamples = new ArrayList<Double>();
        double[] outSamples = null;
        for (int i = 0; i < samples.length; ++i) {
            if (Double.isNaN(samples[i])) continue;
            newSamples.add(samples[i]);
        }
        outSamples = new double[newSamples.size()];
        int j = 0;
        for (Object e : newSamples) {
            outSamples[j++] = (Double)e;
        }
        return outSamples;
    }

    private double[] removeMissing(double[] vals) {
        int num = vals.length;
        int cnt = 0;
        int[] good = new int[num];
        for (int k = 0; k < num; ++k) {
            if (Double.isNaN(vals[k])) continue;
            good[cnt] = k;
            ++cnt;
        }
        if (cnt == num) {
            return vals;
        }
        double[] newVals = new double[cnt];
        for (int k = 0; k < cnt; ++k) {
            newVals[k] = vals[good[k]];
        }
        return newVals;
    }

    protected boolean modifyRange(double lowVal, double hiVal) {
        return this.modifyRange(lowVal, hiVal, true);
    }

    protected boolean modifyRange(double lowVal, double hiVal, boolean notify) {
        try {
            if (this.plot == null) {
                return false;
            }
            ValueAxis domainAxis = this.plot.getDomainAxis();
            Range newRange = new Range(lowVal, hiVal);
            domainAxis.setRange(newRange, domainAxis.isAutoRange(), notify);
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    protected Range getRange() {
        ValueAxis domainAxis = this.plot.getDomainAxis();
        return domainAxis.getRange();
    }

    protected void doReset() {
        this.resetPlot();
    }

    public void resetPlot() {
        if (this.chart == null) {
            return;
        }
        if (!(this.chart.getPlot() instanceof XYPlot)) {
            return;
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        int rcnt = plot.getRangeAxisCount();
        for (int i = 0; i < rcnt; ++i) {
            ValueAxis axis = plot.getRangeAxis(i);
            axis.setAutoRange(true);
        }
        int dcnt = plot.getDomainAxisCount();
        for (int i = 0; i < dcnt; ++i) {
            ValueAxis axis = plot.getDomainAxis(i);
            try {
                axis.setRange(this.low, this.high);
                continue;
            }
            catch (Exception e) {
                logger.warn("jfreechart does not like ranges to be high -> low", e);
            }
        }
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double val) {
        this.low = val;
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double val) {
        this.high = val;
    }

    @Override
    public void showPopup(JComponent where, int x, int y) {
        List items = new ArrayList();
        if ((items = this.getPopupMenuItems(items)).isEmpty()) {
            return;
        }
        GuiUtils.makePopupMenu(items).show(where, x, y);
    }

    @Override
    protected List getPopupMenuItems(List items) {
        items = super.getPopupMenuItems(items);
        for (Object o : items) {
            JMenuItem menuItem;
            if (!(o instanceof JMenuItem) || !"Properties...".equals((menuItem = (JMenuItem)o).getText())) continue;
            menuItem.setActionCommand("PROPERTIES");
            menuItem.addActionListener(this.buildHistoPropsListener());
        }
        return items;
    }

    private ActionListener buildHistoPropsListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String command = event.getActionCommand();
                if ("PROPERTIES".equals(command)) {
                    McVHistogramWrapper.this.showProperties();
                    return;
                }
            }
        };
    }

    @Override
    public boolean showProperties() {
        boolean result = !this.hasDisplayControl() ? this.showProperties(null, 0, 0) : super.showProperties();
        return result;
    }

    public boolean hasDisplayControl() {
        return this.getDisplayControl() != null;
    }

    @Override
    public boolean removeDisplayComponent() {
        if (GuiUtils.askYesNo("Remove Display", "Are you sure you want to remove: " + this.toString())) {
            DisplayGroup displayGroup = this.getDisplayGroup();
            if (displayGroup != null) {
                displayGroup.removeDisplayComponent(this);
            }
            if (this.hasDisplayControl()) {
                this.getDisplayControl().removeDisplayComponent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean doApplyProperties() {
        this.applyProperties();
        return true;
    }

    @Override
    public void doRemove() {
        this.isRemoved = true;
        List displayables = this.getDisplayables();
        if (this.hasDisplayControl() && !displayables.isEmpty()) {
            this.getDisplayControl().removeDisplayables(displayables);
        }
        this.firePropertyChange("prop.removed", null, this);
    }
}

