/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import ucar.unidata.data.DataChoice;
import ucar.unidata.gis.maps.LatLonData;
import ucar.unidata.gis.maps.LatLonLabelData;
import ucar.unidata.gis.maps.MapData;
import ucar.unidata.gis.maps.MapInfo;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.PluginManager;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.ZSlider;
import ucar.unidata.ui.LatLonLabelPanel;
import ucar.unidata.ui.LatLonPanel;
import ucar.unidata.ui.MapPanel;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.MapLines;
import visad.SampledSet;
import visad.VisADException;
import visad.georef.EarthLocation;

public class MapDisplayControl
extends DisplayControlImpl {
    public static final Color DEFAULT_MAP_COLOR = new Color(0, 204, 0);
    private JPanel contents;
    private double mapPosition = Double.NaN;
    private List<MapState> mapStates = new ArrayList<MapState>();
    private LatLonState latState = null;
    private LatLonState lonState = null;
    private LatLonLabelState latLabelState = null;
    private LatLonLabelState lonLabelState = null;
    private String initialMap;
    private String initialMapDescription;
    private CompositeDisplayable theHolder;
    private CompositeDisplayable mapsHolder;
    private CompositeDisplayable latLonHolder;
    private boolean isDefaultMap = false;
    private boolean initializeAsDefault = false;
    private List defaultMapData;
    private LatLonData defaultLatData;
    private LatLonData defaultLonData;
    private LatLonLabelData defaultLatLabelData;
    private LatLonLabelData defaultLonLabelData;
    private boolean ignoreNonVisibleMaps = true;
    private boolean myShowInDisplayList = false;
    private ZSlider levelSlider = null;
    private boolean ignoreSliderEvents = false;
    static int cnt = 0;
    int mycnt = cnt++;
    private JToggleButton applyToAllMapsBtn;
    private JToggleButton applyToAllLatLonBtn;
    private JToggleButton applyToAllLabelsBtn;
    private boolean applyChangesToAllMaps = false;
    private boolean applyChangesToAllLatLon = true;
    private boolean applyChangesToAllLabels = true;
    private boolean updatingOtherMapStates = false;
    double lastWidthDegrees = -1.0;

    public MapDisplayControl() {
        this.setLockVisibilityToggle(true);
    }

    public MapDisplayControl(MapViewManager mapViewManager, MapInfo mapInfo) {
        super(mapViewManager.getIdv());
        this.setLockVisibilityToggle(true);
        this.defaultViewManager = mapViewManager;
        this.mapPosition = this.getInitialZPosition();
        this.defaultMapData = mapInfo.getMapDataList();
        this.defaultLatData = mapInfo.getLatData();
        this.defaultLonData = mapInfo.getLonData();
        this.defaultLatLabelData = mapInfo.getLatLabelData();
        this.defaultLonLabelData = mapInfo.getLonLabelData();
        if (mapInfo.getJustLoadedLocalMaps()) {
            this.ignoreNonVisibleMaps = false;
        }
        if (mapViewManager.getUseGlobeDisplay()) {
            this.defaultLatLabelData.setSphere(true);
            this.defaultLonLabelData.setSphere(true);
        }
    }

    public MapDisplayControl(MapData mapData) {
        this.setLockVisibilityToggle(true);
        this.defaultMapData = mapData == null ? new ArrayList() : Misc.newList(mapData);
    }

    protected boolean xxxshouldAddControlListener() {
        return true;
    }

    public void xxxviewpointChanged() {
        super.viewpointChanged();
        try {
            if (this.latState == null || this.lonState == null) {
                return;
            }
            NavigatedDisplay navDisplay = this.getNavigatedDisplay();
            if (navDisplay == null || navDisplay.getDisplay() == null) {
                return;
            }
            Rectangle screenBounds = navDisplay.getScreenBounds();
            EarthLocation p1 = this.screenToEarth(0, 0);
            EarthLocation p2 = this.screenToEarth(screenBounds.width, 0);
            double diff = Math.abs(p1.getLongitude().getValue() - p2.getLongitude().getValue());
            if (diff != this.lastWidthDegrees) {
                this.lastWidthDegrees = diff;
                System.err.println("setting spacing:");
                this.latState.okToShare = false;
                this.lonState.okToShare = false;
                this.latState.setSpacing((float)(this.lastWidthDegrees / 10.0));
                this.lonState.setSpacing((float)(this.lastWidthDegrees / 10.0));
                this.latState.okToShare = true;
                this.lonState.okToShare = true;
            }
        }
        catch (Exception exc) {
            MapDisplayControl.logException("Viewpoint changed", exc);
        }
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        int cnt = 0;
        for (int i = 0; i < this.mapStates.size(); ++i) {
            MapState mapState = this.mapStates.get(i);
            if (!mapState.getVisible()) continue;
            labels.add(mapState.getDescription());
            if (cnt++ <= 2) continue;
            if (i >= this.mapStates.size() - 1) break;
            labels.add("...");
            break;
        }
    }

    public void loadNewMap(MapDisplayControl newMap) {
        this.setDisplayInactive();
        try {
            this.setLegendLabelTemplate(newMap.getLegendLabelTemplate());
            this.setDisplayListTemplate(newMap.getDisplayListTemplate());
            this.setShowInDisplayList(newMap.getShowInDisplayList());
            if (newMap.getDisplayListColor() != null) {
                this.setDisplayListColor(newMap.getDisplayListColor());
            }
            this.setCollapseLegend(newMap.getCollapseLegend());
            this.deactivateDisplays();
            this.latState.initWith(newMap.latState);
            this.lonState.initWith(newMap.lonState);
            this.latLabelState.initWith(newMap.latLabelState);
            this.lonLabelState.initWith(newMap.lonLabelState);
            if (this.getDisplayVisibility() != newMap.getDisplayVisibility()) {
                this.setDisplayVisibility(newMap.getDisplayVisibility());
            }
            for (MapState mapState : this.mapStates) {
                MapLines theMap = mapState.getMap();
                if (theMap == null) continue;
                this.mapsHolder.removeDisplayable(theMap);
            }
            if (this.latLonHolder != null) {
                this.latLonHolder.clearDisplayables();
            } else {
                this.latLonHolder = new CompositeDisplayable("latlonholder " + this.mycnt);
                this.theHolder.addDisplayable(this.latLonHolder);
            }
            this.latLonHolder.addDisplayable(this.latState.getLatLonLines());
            this.latLonHolder.addDisplayable(this.lonState.getLatLonLines());
            this.latLonHolder.addDisplayable(this.latLabelState.getLatLonLabels());
            this.latLonHolder.addDisplayable(this.lonLabelState.getLatLonLabels());
            this.mapStates = new ArrayList<MapState>();
            for (int i = 0; i < newMap.mapStates.size(); ++i) {
                MapState mapState;
                mapState = new MapState(newMap.mapStates.get(i));
                if (!mapState.init(this)) continue;
                this.mapStates.add(mapState);
            }
            this.mapPosition = newMap.mapPosition;
            if (this.contents != null) {
                this.fillContents();
            }
            this.setSliderPosition();
            this.applyMapPosition();
            this.activateDisplays();
            this.updateLegendLabel();
            if (newMap.getComponentHolder() != null) {
                if (this.getComponentHolder() != null) {
                    this.getComponentHolder().setObject(null);
                    this.getComponentHolder().doRemove();
                }
                this.setComponentHolder(newMap.getComponentHolder());
                newMap.setComponentHolder(null);
                this.getComponentHolder().setObject(this);
                this.getComponentHolder().displayControlHasInitialized();
            }
        }
        catch (Exception exc) {
            MapDisplayControl.logException("Loading new map", exc);
        }
        this.setDisplayActive();
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.theHolder = new CompositeDisplayable("theHolder " + this.mycnt);
        this.mapsHolder = new CompositeDisplayable("maps holder " + this.mycnt);
        this.latLonHolder = new CompositeDisplayable("latlonholder " + this.mycnt);
        this.theHolder.addDisplayable(this.mapsHolder);
        this.theHolder.addDisplayable(this.latLonHolder);
        this.addDisplayable(this.theHolder);
        boolean cnt = false;
        Trace.call1("MapDisplayControl.init");
        if (this.initializeAsDefault) {
            this.initialMap = null;
            this.initializeAsDefault = false;
            this.isDefaultMap = true;
            this.setCanDoRemoveAll(false);
            MapInfo mapInfo = this.getControlContext().getResourceManager().createMapInfo(this.inGlobeDisplay());
            if (mapInfo.getJustLoadedLocalMaps()) {
                this.ignoreNonVisibleMaps = false;
            }
            this.defaultMapData = mapInfo.getMapDataList();
            this.defaultLatData = mapInfo.getLatData();
            this.defaultLonData = mapInfo.getLonData();
            this.defaultLatLabelData = mapInfo.getLatLabelData();
            this.defaultLonLabelData = mapInfo.getLonLabelData();
            this.mapPosition = this.getInitialZPosition();
        }
        this.ignoreNonVisibleMaps = false;
        if (this.defaultMapData != null) {
            if (!this.defaultMapData.isEmpty()) {
                for (int i = 0; i < this.defaultMapData.size(); ++i) {
                    MapData mapData = (MapData)this.defaultMapData.get(i);
                    if (!mapData.getVisible() && this.ignoreNonVisibleMaps) continue;
                    this.addMap(new MapState(mapData));
                }
            } else if (!this.selectMap()) {
                return false;
            }
            this.defaultMapData = null;
        }
        if (this.defaultLatData != null) {
            this.latState = new LatLonState(this.defaultLatData);
            this.latState.init(this);
        }
        if (this.defaultLonData != null) {
            this.lonState = new LatLonState(this.defaultLonData);
            this.lonState.init(this);
        }
        if (this.latState != null) {
            this.latLonHolder.addDisplayable(this.latState.getLatLonLines());
        }
        if (this.lonState != null) {
            this.latLonHolder.addDisplayable(this.lonState.getLatLonLines());
        }
        if (this.defaultLatLabelData != null) {
            this.latLabelState = new LatLonLabelState(this.defaultLatLabelData);
            this.latLabelState.init(this);
        }
        if (this.defaultLonLabelData != null) {
            this.lonLabelState = new LatLonLabelState(this.defaultLonLabelData);
            this.lonLabelState.init(this);
        }
        if (this.latLabelState != null) {
            this.latLonHolder.addDisplayable(this.latLabelState.getLatLonLabels());
        }
        if (this.lonLabelState != null) {
            this.latLonHolder.addDisplayable(this.lonLabelState.getLatLonLabels());
        }
        if (this.initialMap != null && this.initialMap.trim().length() > 0 && !this.isDefaultMap) {
            this.addMap(this.initialMap, this.initialMapDescription != null ? this.initialMapDescription : this.initialMap);
            this.initialMap = null;
            this.initialMapDescription = null;
        }
        for (int i = 0; i < this.mapStates.size(); ++i) {
            this.mapStates.get(i).init(this);
        }
        if (Double.isNaN(this.mapPosition)) {
            this.mapPosition = this.getInitialZPosition();
        }
        this.setSliderPosition();
        this.applyMapPosition();
        Trace.call2("MapDisplayControl.init");
        return true;
    }

    private LatLonState createLatLonState(boolean latitude, float min, float max, float spacing) {
        LatLonState lls = new LatLonState(latitude, Color.blue, spacing, 1.0f, 1);
        lls.init(this);
        lls.setVisible(false);
        lls.setFastRendering(this.getDefaultFastRendering());
        lls.setMinValue(min);
        lls.setMaxValue(max);
        return lls;
    }

    private LatLonLabelState createLatLonLabelState(boolean latitude, float min, float max, float spacing) {
        LatLonLabelState lls = new LatLonLabelState(latitude, spacing);
        lls.init(this);
        lls.setVisible(false);
        lls.setFastRendering(this.getDefaultFastRendering());
        lls.setMinValue(min);
        lls.setMaxValue(max);
        lls.setSphere(((MapViewManager)this.getViewManager()).getUseGlobeDisplay());
        return lls;
    }

    public void merge(MapDisplayControl that) {
    }

    @Override
    public void setDisplayVisibility(boolean on) {
        try {
            super.setDisplayVisibility(on);
            for (int i = 0; i < this.mapStates.size(); ++i) {
                MapState mapState = this.mapStates.get(i);
                mapState.checkVisibility();
            }
            if (this.latState != null) {
                this.latState.checkVisibility();
                this.lonState.checkVisibility();
            }
            if (this.latLabelState != null) {
                this.latLabelState.checkVisibility();
                this.lonLabelState.checkVisibility();
            }
        }
        catch (Exception exc) {
            MapDisplayControl.logException("Setting visibility", exc);
        }
    }

    private void addMap(String mapPath, String description) {
        this.addMap(new MapState(mapPath, description, DEFAULT_MAP_COLOR, 1.0f, 0));
    }

    private void addMap(MapState mapState) {
        this.setDisplayInactive();
        if (mapState.init(this)) {
            this.mapStates.add(mapState);
            this.updateLegendLabel();
        }
        this.setDisplayActive();
    }

    public void setVisible(boolean visible) {
        if (this.mapStates != null && this.mapStates.size() > 0) {
            int len = this.mapStates.size();
            for (int i = 0; i < len; ++i) {
                MapState ms = this.mapStates.get(i);
                ms.setVisible(visible);
            }
        }
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        JMenu mapsMenu = new JMenu("Maps");
        GuiUtils.setIcon(mapsMenu, "/auxdata/ui/icons/map.png");
        items.add(mapsMenu);
        for (int i = 0; i < this.mapStates.size(); ++i) {
            final MapState mapState = this.mapStates.get(i);
            JCheckBoxMenuItem cbx = new JCheckBoxMenuItem(mapState.getDescription(), mapState.getVisible());
            cbx.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    mapState.setVisible(!mapState.getVisible());
                    mapState.mapPanel.setVisibility(mapState.getVisible());
                }
            });
            mapsMenu.add(cbx);
        }
        super.getViewMenuItems(items, forMenuBar);
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        JMenuItem mi = new JMenuItem("Add Your Own Map...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MapDisplayControl.this.selectMap();
            }
        });
        items.add(mi);
        JMenu addMapMenu = new JMenu("Add System Map");
        items.add(addMapMenu);
        List<MapData> maps = this.getControlContext().getResourceManager().getMaps();
        for (int i = 0; i < maps.size(); ++i) {
            final MapData mapData = maps.get(i);
            mi = new JMenuItem(mapData.getDescription());
            addMapMenu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MapState mapState = new MapState(mapData);
                    mapState.setVisible(true);
                    MapDisplayControl.this.addMap(mapState);
                    MapDisplayControl.this.fillContents();
                }
            });
        }
        GuiUtils.limitMenuSize(addMapMenu, "Maps ", 20);
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    protected void getFileMenuItems(List items, boolean forMenuBar) {
        super.getFileMenuItems(items, forMenuBar);
        JMenu defaultMenu = new JMenu("Default Maps");
        JMenuItem mi = new JMenuItem("Save as the Default Map Set");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MapDisplayControl.this.saveAsPreference();
            }
        });
        defaultMenu.add(mi);
        mi = new JMenuItem("Remove Local Map Defaults");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (GuiUtils.askYesNo("Remove Default Maps", "Are you sure you want to remove the default maps?")) {
                    if (MapDisplayControl.this.getControlContext().getResourceManager().removeLocalMaps(MapDisplayControl.this.inGlobeDisplay())) {
                        LogUtil.userMessage("This will take effect when you run the IDV next");
                    } else {
                        LogUtil.userMessage("There were no local default maps defined");
                    }
                }
            }
        });
        defaultMenu.add(mi);
        items.add(defaultMenu);
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeMenuItem("Export to Plugin", this, "saveToPlugin"));
    }

    protected boolean selectMap() {
        String filename;
        if (!LogUtil.getInteractiveMode()) {
            return false;
        }
        GuiUtils.ColorSwatch colorButton = new GuiUtils.ColorSwatch(DEFAULT_MAP_COLOR, "Set Map Line Color");
        colorButton.setToolTipText("Set the line color");
        JTextField catFld = new JTextField("Maps", 20);
        catFld.setToolTipText("Enter a category");
        JTextField nameFld = new JTextField("", 20);
        nameFld.setToolTipText("Enter an optional map name");
        final JTextField fileFld = new JTextField("", 20);
        JButton browseBtn = new JButton("Browse");
        browseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String filename = FileManager.getReadFile(new PatternFileFilter(".+\\.shp", "Shape Files (*.shp)"));
                if (filename != null) {
                    fileFld.setText(filename);
                }
            }
        });
        JComboBox<String> styleBox = new JComboBox<String>(new String[]{"_____", "_ _ _", ".....", "_._._"});
        styleBox.setMaximumSize(new Dimension(30, 16));
        styleBox.setToolTipText("Set the line style");
        styleBox.setSelectedIndex(0);
        JComboBox<String> widthBox = new JComboBox<String>(new String[]{"1.0", "1.5", "2.0", "2.5", "3.0"});
        widthBox.setToolTipText("Set the line width");
        widthBox.setMaximumSize(new Dimension(30, 16));
        widthBox.setEditable(true);
        while (true) {
            GuiUtils.setHFill();
            JPanel fileLine = GuiUtils.doLayout(new Component[]{fileFld, browseBtn}, 2, GuiUtils.WT_YN, GuiUtils.WT_N);
            JPanel nameLine = GuiUtils.left(GuiUtils.hbox(nameFld, new JLabel(" (Optional)")));
            GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
            JPanel panel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Map file or URL: "), fileLine, GuiUtils.rLabel("Name: "), nameLine, GuiUtils.rLabel("Catgegory: "), catFld, GuiUtils.rLabel("Color: "), GuiUtils.left(colorButton), GuiUtils.rLabel("Line style: "), GuiUtils.left(styleBox), GuiUtils.rLabel("Line width: "), GuiUtils.left(widthBox)}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            if (!GuiUtils.showOkCancelDialog(null, "Add a map", GuiUtils.inset((Component)panel, 4), null)) {
                return false;
            }
            filename = fileFld.getText().trim();
            if (filename.length() != 0) break;
            MapDisplayControl.userMessage("Please select a map file or URL");
        }
        String description = nameFld.getText().trim();
        if (description.trim().length() == 0) {
            description = IOUtil.getFileTail(IOUtil.stripExtension(filename));
        }
        MapState mapState = new MapState(filename, description, colorButton.getBackground(), Float.parseFloat((String)widthBox.getSelectedItem()), styleBox.getSelectedIndex());
        mapState.setCategory(catFld.getText().trim());
        mapState.setVisible(true);
        this.addMap(mapState);
        this.fillContents();
        return true;
    }

    private void saveAsPreference() {
        String xml = new MapInfo(this.mapStates, this.latState, this.lonState, this.latLabelState, this.lonLabelState, (float)this.mapPosition).getXml();
        this.getControlContext().getResourceManager().writeMapState(xml, this.inGlobeDisplay());
    }

    public void saveToPlugin() {
        MapState mapState;
        int i;
        JCheckBox onlySelected = new JCheckBox("Only use visible maps", true);
        JCheckBox includeFiles = new JCheckBox("Include map files in plugin", true);
        JCheckBox includeSettings = new JCheckBox("Include \"Settings\"", false);
        JPanel contents = GuiUtils.vbox(onlySelected, includeFiles, includeSettings);
        if (!GuiUtils.showOkCancelDialog(null, "Create Map Plugin", contents = GuiUtils.inset((Component)contents, 5), null)) {
            return;
        }
        PluginManager pluginManager = this.getControlContext().getIdv().getPluginManager();
        ArrayList<MapState> states = new ArrayList<MapState>();
        for (i = 0; i < this.mapStates.size(); ++i) {
            mapState = this.mapStates.get(i);
            if (!onlySelected.isSelected()) {
                states.add(mapState);
                continue;
            }
            if (!mapState.getVisible()) continue;
            states.add(mapState);
        }
        if (includeFiles.isSelected()) {
            for (i = 0; i < states.size(); ++i) {
                mapState = (MapState)states.get(i);
                pluginManager.addCreateFile(mapState.getSource());
            }
        }
        MapInfo mapInfo = includeSettings.isSelected() ? new MapInfo(states, this.latState, this.lonState, (float)this.mapPosition) : new MapInfo(states);
        String xml = mapInfo.getXml(!includeFiles.isSelected());
        pluginManager.addText(xml, "maps.xml");
    }

    @Override
    public Container doMakeContents() {
        LatLonLabelPanel lonLabelPanel;
        LatLonLabelPanel latLabelPanel;
        LatLonPanel lonPanel;
        LatLonPanel latPanel;
        this.contents = new JPanel(new BorderLayout());
        if (this.latState == null) {
            this.latState = this.createLatLonState(true, -90.0f, 90.0f, 30.0f);
        }
        if (this.lonState == null) {
            this.lonState = this.createLatLonState(false, -180.0f, 180.0f, 45.0f);
        }
        this.latState.other = this.lonState;
        this.lonState.other = this.latState;
        if (this.latLabelState == null) {
            this.latLabelState = this.createLatLonLabelState(true, -90.0f, 90.0f, 30.0f);
        }
        if (this.lonLabelState == null) {
            this.lonLabelState = this.createLatLonLabelState(false, -180.0f, 180.0f, 45.0f);
        }
        this.latLabelState.other = this.lonLabelState;
        this.lonLabelState.other = this.latLabelState;
        this.latState.myLatLonPanel = latPanel = new LatLonPanel(this.latState);
        this.lonState.myLatLonPanel = lonPanel = new LatLonPanel(this.lonState);
        JPanel llPanel = LatLonPanel.layoutPanels(latPanel, lonPanel);
        this.latLabelState.myLatLonLabelPanel = latLabelPanel = new LatLonLabelPanel(this.latLabelState);
        this.lonLabelState.myLatLonLabelPanel = lonLabelPanel = new LatLonLabelPanel(this.lonLabelState);
        JPanel lllPanel = LatLonLabelPanel.layoutPanels(latLabelPanel, lonLabelPanel);
        try {
            if (this.latLonHolder.displayableCount() == 0) {
                this.latLonHolder.addDisplayable(this.latState.getLatLonLines());
                this.latLonHolder.addDisplayable(this.lonState.getLatLonLines());
                this.latLonHolder.addDisplayable(this.latLabelState.getLatLonLabels());
                this.latLonHolder.addDisplayable(this.lonLabelState.getLatLonLabels());
            }
        }
        catch (Exception exc) {
            MapDisplayControl.logException("Initializing latlon lines", exc);
        }
        JScrollPane sp = new JScrollPane(this.contents, 20, 30);
        sp.setBorder(null);
        sp.getVerticalScrollBar().setUnitIncrement(10);
        JViewport vp = sp.getViewport();
        vp.setViewSize(new Dimension(600, 220));
        sp.setPreferredSize(new Dimension(600, 220));
        this.applyToAllLatLonBtn = GuiUtils.getToggleImageButton("/auxdata/ui/icons/link_break.png", "/auxdata/ui/icons/link.png", 0, 0, true);
        this.applyToAllLatLonBtn.setContentAreaFilled(false);
        this.applyToAllLatLonBtn.setSelected(this.applyChangesToAllLatLon);
        this.applyToAllLatLonBtn.setToolTipText("Apply changes to all lat/lon lines");
        this.applyToAllLabelsBtn = GuiUtils.getToggleImageButton("/auxdata/ui/icons/link_break.png", "/auxdata/ui/icons/link.png", 0, 0, true);
        this.applyToAllLabelsBtn.setContentAreaFilled(false);
        this.applyToAllLabelsBtn.setSelected(this.applyChangesToAllLabels);
        this.applyToAllLabelsBtn.setToolTipText("Apply changes to all lat/lon labels");
        JPanel latlonPanel = GuiUtils.topCenter(GuiUtils.vbox(GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.top(this.applyToAllLatLonBtn), GuiUtils.left(llPanel))), GuiUtils.filler(), GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.top(this.applyToAllLabelsBtn), GuiUtils.left(lllPanel)))), GuiUtils.filler());
        JScrollPane sp2 = new JScrollPane(latlonPanel, 20, 30);
        sp2.setBorder(null);
        sp2.getVerticalScrollBar().setUnitIncrement(10);
        JViewport vp2 = sp.getViewport();
        vp2.setViewSize(new Dimension(600, 220));
        sp2.setPreferredSize(new Dimension(600, 220));
        this.applyToAllMapsBtn = GuiUtils.getToggleImageButton("/auxdata/ui/icons/link_break.png", "/auxdata/ui/icons/link.png", 0, 0, true);
        this.applyToAllMapsBtn.setContentAreaFilled(false);
        this.applyToAllMapsBtn.setSelected(this.applyChangesToAllMaps);
        this.applyToAllMapsBtn.setToolTipText("Apply changes to all visible maps");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Maps", GuiUtils.topCenter(GuiUtils.left(this.applyToAllMapsBtn), sp));
        tabbedPane.add("Lat/Lon", sp2);
        JComponent retComp = tabbedPane;
        if (this.useZPosition()) {
            JPanel sliderPanel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Position: "), this.makePositionSlider()}, 2, GuiUtils.WT_YN, GuiUtils.WT_N);
            retComp = GuiUtils.centerBottom(tabbedPane, GuiUtils.inset((Component)GuiUtils.left(sliderPanel), new Insets(10, 30, 5, 0)));
        }
        this.fillContents();
        return retComp;
    }

    private void applyMapPosition() {
        try {
            if (Double.isNaN(this.mapPosition)) {
                this.mapPosition = this.getInitialZPosition();
            }
            this.theHolder.setConstantPosition(this.getVerticalValue(this.mapPosition), this.getNavigatedDisplay().getDisplayAltitudeType());
        }
        catch (Exception exc) {
            MapDisplayControl.logException("Setting map position", exc);
        }
    }

    private JComponent makePositionSlider() {
        this.levelSlider = new ZSlider(this.mapPosition){

            @Override
            public void valueHasBeenSet() {
                MapDisplayControl.this.mapPosition = this.getValue();
                MapDisplayControl.this.applyMapPosition();
            }
        };
        JComponent slider = this.levelSlider.getContents();
        Dimension size = new Dimension(500, slider.getPreferredSize().height);
        slider.setPreferredSize(size);
        slider.setMinimumSize(size);
        return slider;
    }

    private void setSliderPosition() {
        if (this.levelSlider != null) {
            this.levelSlider.setValue(this.mapPosition);
        }
    }

    private void fillContents() {
        int i;
        if (this.contents == null) {
            return;
        }
        this.contents.removeAll();
        ImageIcon upIcon = GuiUtils.getImageIcon("/ucar/unidata/idv/control/images/LevelUp.gif");
        ImageIcon downIcon = GuiUtils.getImageIcon("/ucar/unidata/idv/control/images/LevelDown.gif");
        ImageIcon removeIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/map_delete.png");
        ImageIcon addIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/database_add.png");
        int colCnt = 0;
        Hashtable catMap = new Hashtable();
        ArrayList<String> cats = new ArrayList<String>();
        for (int i2 = 0; i2 < this.mapStates.size(); ++i2) {
            ArrayList<JComponent> mapPanels;
            final int listIndex = i2;
            MapState mapState = this.mapStates.get(i2);
            String cat = mapState.getCategory();
            if (cat == null) {
                cat = "Maps";
            }
            if ((mapPanels = (ArrayList<JComponent>)catMap.get(cat)) == null) {
                mapPanels = new ArrayList<JComponent>();
                catMap.put(cat, mapPanels);
                cats.add(cat);
            }
            MapPanel mapPanel = new MapPanel(mapState);
            mapState.mapPanel = mapPanel;
            JButton addBtn = new JButton(addIcon);
            addBtn.setContentAreaFilled(false);
            addBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MapDisplayControl.this.loadMapAsDataSource(listIndex);
                }
            });
            addBtn.setToolTipText("Load this map as a data source");
            JButton removeBtn = new JButton(removeIcon);
            removeBtn.setContentAreaFilled(false);
            removeBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            removeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MapDisplayControl.this.removeMap(listIndex);
                }
            });
            removeBtn.setToolTipText("Remove the map");
            JButton moveUpBtn = new JButton(upIcon);
            moveUpBtn.setContentAreaFilled(false);
            moveUpBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            moveUpBtn.setToolTipText("Move the map up");
            moveUpBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MapDisplayControl.this.moveMap(listIndex, -1);
                }
            });
            moveUpBtn.setEnabled(listIndex > 0);
            JButton moveDownBtn = new JButton(downIcon);
            moveDownBtn.setContentAreaFilled(false);
            moveDownBtn.setToolTipText("Move the map down");
            moveDownBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            moveDownBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MapDisplayControl.this.moveMap(listIndex, 1);
                }
            });
            moveDownBtn.setEnabled(listIndex < this.mapStates.size() - 1);
            JPanel upDownPanel = GuiUtils.doLayout(new Component[]{moveUpBtn, moveDownBtn}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
            mapPanels.addAll(mapPanel.getGuiComponents());
            mapPanels.add(upDownPanel);
            mapPanels.add(removeBtn);
            mapPanels.add(addBtn);
            if (i2 != 0) continue;
            colCnt = mapPanels.size();
        }
        final ImageIcon openIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/CategoryOpen.gif");
        final ImageIcon closeIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/CategoryClosed.gif");
        ArrayList<JPanel> comps = new ArrayList<JPanel>();
        ArrayList<JToggleButton> cbxs = new ArrayList<JToggleButton>();
        for (i = 0; i < cats.size(); ++i) {
            String cat = (String)cats.get(i);
            List mapPanels = (List)catMap.get(cat);
            GuiUtils.tmpInsets = new Insets(3, 3, 3, 3);
            final JPanel catPanel = GuiUtils.inset((Component)GuiUtils.doLayout(mapPanels, colCnt, GuiUtils.WT_YN, GuiUtils.WT_N), new Insets(0, 10, 0, 0));
            final JToggleButton cbx = new JToggleButton(openIcon, true);
            cbxs.add(cbx);
            cbx.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            cbx.setContentAreaFilled(false);
            cbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    catPanel.setVisible(!catPanel.isVisible());
                    if (catPanel.isVisible()) {
                        cbx.setIcon(openIcon);
                    } else {
                        cbx.setIcon(closeIcon);
                    }
                }
            });
            comps.add(GuiUtils.leftCenter(GuiUtils.inset((Component)cbx, 5), new JLabel(cat)));
            comps.add(catPanel);
        }
        if (cbxs.size() > 1) {
            for (i = 0; i < cbxs.size(); ++i) {
                ((JToggleButton)cbxs.get(i)).doClick();
            }
        }
        JPanel mapGui = GuiUtils.vbox(comps);
        mapGui = GuiUtils.left(mapGui);
        this.contents.add(GuiUtils.top(mapGui));
        this.contents.repaint();
        this.contents.validate();
        this.updateLegendLabel();
    }

    private void loadMapAsDataSource(int index) {
        try {
            MapState mapState = this.mapStates.get(index);
            this.getIdv().makeDataSource(mapState.getSource(), "file.mapfile", new Hashtable());
            this.getIdv().getIdvUIManager().showDataSelector();
        }
        catch (Exception exc) {
            MapDisplayControl.logException("Removing map", exc);
        }
    }

    private void removeMap(int index) {
        try {
            MapState mapState = this.mapStates.remove(index);
            MapLines theMap = mapState.getMap();
            if (theMap != null) {
                this.mapsHolder.removeDisplayable(theMap);
            }
            this.fillContents();
        }
        catch (Exception exc) {
            MapDisplayControl.logException("Removing map", exc);
        }
    }

    private void moveMap(int index, int delta) {
        this.setDisplayInactive();
        try {
            MapLines theMap;
            int i;
            MapState mapState = this.mapStates.remove(index);
            this.mapStates.add(index + delta, mapState);
            this.deactivateDisplays();
            for (i = 0; i < this.mapStates.size(); ++i) {
                theMap = this.mapStates.get(i).getMap();
                if (theMap == null) continue;
                this.mapsHolder.removeDisplayable(theMap);
            }
            for (i = 0; i < this.mapStates.size(); ++i) {
                theMap = this.mapStates.get(i).getMap();
                if (theMap == null) continue;
                this.mapsHolder.addDisplayable(theMap);
            }
            this.fillContents();
            this.activateDisplays();
        }
        catch (Exception exc) {
            MapDisplayControl.logException("Moving map position", exc);
        }
        this.setDisplayActive();
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        this.applyMapPosition();
    }

    public void setInitialMap(String value) {
        this.initialMap = value;
    }

    public String getInitialMap() {
        return this.initialMap;
    }

    public void setInitialMapDescription(String value) {
        this.initialMapDescription = value;
    }

    public String getInitialMapDescription() {
        return this.initialMapDescription;
    }

    @Override
    protected boolean shouldApplyFastRendering() {
        return false;
    }

    @Override
    protected boolean getDefaultFastRendering() {
        return false;
    }

    private void mapStateChanged(MapState changedState, String what) {
        this.updateLegendLabel();
        if (what.equals("visible")) {
            return;
        }
        if (this.updatingOtherMapStates || !this.getApplyChangesToAllMaps()) {
            return;
        }
        this.updatingOtherMapStates = true;
        try {
            for (MapState mapState : this.mapStates) {
                if (mapState == changedState || !mapState.getVisible()) continue;
                if (what.equals("color")) {
                    mapState.setColor(changedState.getColor());
                } else if (what.equals("linewidth")) {
                    mapState.setLineWidth(changedState.getLineWidth());
                } else if (what.equals("linestyle")) {
                    mapState.setLineStyle(changedState.getLineStyle());
                } else if (what.equals("fastrendering")) {
                    mapState.setFastRendering(changedState.getFastRendering());
                } else {
                    if (what.equals("visible")) continue;
                    System.err.println("Unknown attribute:" + what);
                }
                if (mapState.mapPanel == null) continue;
                mapState.mapPanel.updateUI();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.updatingOtherMapStates = false;
    }

    public void setMapStates(List value) {
        this.mapStates = value;
    }

    public List getMapStates() {
        return this.mapStates;
    }

    public LatLonState getLatState() {
        return this.latState;
    }

    public void setLatState(LatLonState value) {
        this.latState = value;
    }

    public LatLonState getLonState() {
        return this.lonState;
    }

    public void setLonState(LatLonState value) {
        this.lonState = value;
    }

    public LatLonLabelState getLatLabelState() {
        return this.latLabelState;
    }

    public void setLatLabelState(LatLonLabelState value) {
        this.latLabelState = value;
    }

    public LatLonLabelState getLonLabelState() {
        return this.lonLabelState;
    }

    public void setLonLabelState(LatLonLabelState value) {
        this.lonLabelState = value;
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        List infos = this.getDisplayInfos();
        if (infos != null && infos.size() == 0) {
            this.theHolder.destroyAll();
        }
        super.doRemove();
        this.theHolder = null;
        this.mapsHolder = null;
        this.latLonHolder = null;
    }

    public void setInitializeAsDefault(boolean value) {
        this.initializeAsDefault = value;
    }

    public boolean getIsDefaultMap() {
        return this.isDefaultMap;
    }

    public void setIsDefaultMap(boolean value) {
        this.isDefaultMap = value;
        if (this.isDefaultMap) {
            this.setCanDoRemoveAll(false);
        }
    }

    public void setMapPosition(double value) {
        this.mapPosition = value;
    }

    public double getMapPosition() {
        return this.mapPosition;
    }

    @Override
    public void setShowInDisplayList(boolean value) {
        this.myShowInDisplayList = value;
        super.setShowInDisplayList(value);
    }

    @Override
    public boolean getShowInDisplayList() {
        return this.myShowInDisplayList;
    }

    public void setApplyChangesToAllMaps(boolean value) {
        this.applyChangesToAllMaps = value;
    }

    public boolean getApplyChangesToAllMaps() {
        if (this.applyToAllMapsBtn != null) {
            return this.applyToAllMapsBtn.isSelected();
        }
        return this.applyChangesToAllMaps;
    }

    public void setApplyChangesToAllLatLon(boolean value) {
        this.applyChangesToAllLatLon = value;
    }

    public boolean getApplyChangesToAllLatLon() {
        if (this.applyToAllLatLonBtn != null) {
            return this.applyToAllLatLonBtn.isSelected();
        }
        return this.applyChangesToAllLatLon;
    }

    public void setApplyChangesToAllLabels(boolean value) {
        this.applyChangesToAllLabels = value;
    }

    public boolean getApplyChangesToAllLabels() {
        if (this.applyToAllLabelsBtn != null) {
            return this.applyToAllLabelsBtn.isSelected();
        }
        return this.applyChangesToAllLabels;
    }

    @Override
    protected double getInitialZPosition() {
        MapViewManager mvm = this.defaultViewManager != null && this.defaultViewManager instanceof MapViewManager ? (MapViewManager)this.defaultViewManager : this.getMapViewManager();
        return mvm != null ? (double)mvm.getDefaultMapPosition() : super.getInitialZPosition() + 0.005;
    }

    public static class MapState
    extends MapData {
        private MapDisplayControl mapDisplayControl;
        private MapPanel mapPanel;
        private Object MAP_MUTEX = new Object();

        public MapState() {
        }

        public MapState(MapData that) {
            this.source = that.getSource();
            this.category = that.getCategory();
            this.visible = that.getVisible();
            this.mapColor = that.getColor();
            this.lineWidth = that.getLineWidth();
            this.lineStyle = that.getLineStyle();
            this.description = that.getDescription();
            this.fastRendering = that.getFastRendering();
        }

        public MapState(String mapPath, String description, Color mapColor, float lineWidth, int lineStyle) {
            super(mapPath, null);
            this.category = "Maps";
            this.visible = true;
            this.mapColor = mapColor;
            this.lineWidth = lineWidth;
            this.lineStyle = lineStyle;
            this.description = description;
        }

        private SampledSet getData(String source) {
            return MapInfo.createMapData(source);
        }

        protected void checkVisibility() {
            if (this.mapDisplayControl == null) {
                return;
            }
            boolean isVisible = this.getVisible() && this.mapDisplayControl.getDisplayVisibility();
            try {
                if (this.myMap == null) {
                    if (!isVisible) {
                        return;
                    }
                    SampledSet mapSet = this.getData(this.source);
                    if (mapSet == null) {
                        return;
                    }
                    this.myMap = new MapLines("Map:" + this.source);
                    this.myMap.setMapLines(mapSet);
                    this.applyStateToMap();
                    this.mapDisplayControl.mapsHolder.addDisplayable(this.myMap);
                }
                this.myMap.setVisible(isVisible);
            }
            catch (Exception exc) {
                MapDisplayControl.logException("Setting visibility", exc);
            }
        }

        public boolean init(MapDisplayControl mapDisplayControl) {
            this.mapDisplayControl = mapDisplayControl;
            try {
                if (this.myMap != null) {
                    return true;
                }
                this.checkVisibility();
                return true;
            }
            catch (Exception exc) {
                MapDisplayControl.logException("Making map:" + this.source, exc);
                return false;
            }
        }

        @Override
        protected void stateChanged() {
            try {
                this.checkVisibility();
                if (this.myMap == null) {
                    return;
                }
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        this.applyStateToMap();
                    }
                });
                if (this.mapDisplayControl != null) {
                    this.mapDisplayControl.updateLegendLabel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void applyStateToMap() {
            try {
                Object object = this.MAP_MUTEX;
                synchronized (object) {
                    this.myMap.setDisplayInactive();
                    this.myMap.setUseFastRendering(this.fastRendering);
                    this.myMap.setColor(this.mapColor);
                    this.myMap.setLineWidth(this.lineWidth);
                    this.myMap.setLineStyle(this.lineStyle);
                    this.myMap.setDisplayActive();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void attrChanged(String attr) {
            if (this.mapDisplayControl != null) {
                this.mapDisplayControl.mapStateChanged(this, attr);
            }
        }

        @Override
        public void setVisible(boolean v) {
            super.setVisible(v);
            this.attrChanged("visible");
        }

        @Override
        public void setLineStyle(int v) {
            super.setLineStyle(v);
            this.attrChanged("linestyle");
        }

        @Override
        public void setColor(Color v) {
            super.setColor(v);
            this.attrChanged("color");
        }

        @Override
        public void setLineWidth(float v) {
            super.setLineWidth(v);
            this.attrChanged("linewidth");
        }

        @Override
        public void setFastRendering(boolean v) {
            super.setFastRendering(v);
            this.attrChanged("fastrendering");
        }
    }

    public static class LatLonLabelState
    extends LatLonLabelData {
        private MapDisplayControl mapDisplayControl;
        LatLonLabelPanel myLatLonLabelPanel;
        private boolean ignoreStateChange = false;
        private boolean okToShare = true;
        private LatLonLabelState other;

        public LatLonLabelState() {
        }

        public LatLonLabelState(LatLonLabelData that) {
            super(that);
        }

        public LatLonLabelState(boolean isLatitude, float spacing) {
            super(isLatitude, spacing);
        }

        protected void init(MapDisplayControl mapDisplayControl) {
            this.mapDisplayControl = mapDisplayControl;
            MapViewManager mvm = mapDisplayControl.getMapViewManager();
            if (mvm != null) {
                this.setSphere(mvm.getUseGlobeDisplay());
            }
        }

        @Override
        public void initWith(LatLonLabelData that) {
            try {
                super.initWith(that);
                if (this.myLatLonLabelPanel != null) {
                    this.myLatLonLabelPanel.setLatLonLabelData(this);
                }
                this.getLatLonLabels();
            }
            catch (Exception exc) {
                MapDisplayControl.logException("initWith", exc);
            }
        }

        private void stateWasShared() {
            this.ignoreStateChange = true;
            if (this.myLatLonLabelPanel != null) {
                this.myLatLonLabelPanel.setLatLonLabelData(this);
            }
            this.ignoreStateChange = false;
            this.okToShare = true;
        }

        private boolean shouldShare() {
            return this.mapDisplayControl != null && this.mapDisplayControl.getApplyChangesToAllLabels() && this.other != null && this.okToShare && !this.ignoreStateChange;
        }

        @Override
        public void setColor(Color value) {
            boolean shouldShare = this.shouldShare() && !Misc.equals(value, this.getColor());
            super.setColor(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setColor(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setVisible(boolean value) {
            boolean shouldShare = this.shouldShare() && value != this.getVisible();
            super.setVisible(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setVisible(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setFastRendering(boolean value) {
            boolean shouldShare = this.shouldShare() && value != this.getFastRendering();
            super.setFastRendering(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setFastRendering(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setLabelLines(float[] values) {
            boolean shouldShare = false;
            super.setLabelLines(values);
            if (shouldShare && this.other != null) {
                this.other.okToShare = false;
                this.other.setLabelLines(values);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setInterval(float value) {
            boolean shouldShare = this.shouldShare() && value != this.getInterval();
            super.setInterval(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setInterval(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setBaseValue(float value) {
            boolean shouldShare = this.shouldShare() && value != this.getBaseValue();
            super.setBaseValue(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setBaseValue(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setFont(Object value) {
            boolean shouldShare = !Misc.equals(value, this.getFont());
            super.setFont(value);
            if (shouldShare && this.other != null) {
                this.other.okToShare = false;
                this.other.setFont(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setAlignment(String value) {
            boolean shouldShare = this.shouldShare() && !Misc.equals(value, this.getAlignment());
            super.setAlignment(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setAlignment(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setLabelFormat(String value) {
            boolean shouldShare = !Misc.equals(value, this.getLabelFormat());
            super.setLabelFormat(value);
            if (shouldShare && this.other != null) {
                this.other.okToShare = false;
                this.other.setLabelFormat(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setSphere(boolean value) {
            boolean shouldShare = !Misc.equals(value, this.getSphere());
            super.setSphere(value);
            if (shouldShare && this.other != null) {
                this.other.okToShare = false;
                this.other.setSphere(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setUse360(boolean value) {
            boolean shouldShare = false;
            super.setUse360(value);
            if (shouldShare && this.other != null) {
                this.other.okToShare = false;
                this.other.setUse360(value);
                this.other.stateWasShared();
            }
        }

        protected void checkVisibility() {
            if (this.myLatLonLabels == null || this.myLatLonLabelPanel == null) {
                return;
            }
            try {
                this.myLatLonLabels.setVisible(this.getRealVisibility());
            }
            catch (Exception exc) {
                MapDisplayControl.logException("Setting visibility", exc);
            }
        }

        @Override
        protected boolean getRealVisibility() {
            if (this.mapDisplayControl == null) {
                return super.getRealVisibility();
            }
            return super.getRealVisibility() && this.mapDisplayControl.getDisplayVisibility();
        }

        @Override
        public void stateChanged() {
            if (this.ignoreStateChange || this.myLatLonLabels == null || this.myLatLonLabelPanel == null) {
                return;
            }
            this.ignoreStateChange = true;
            try {
                if (this.okToShare) {
                    this.myLatLonLabelPanel.applyStateToData();
                }
                this.getLatLonLabels();
            }
            catch (Exception exc) {
                DisplayControlBase.logException("State change", exc);
            }
            this.ignoreStateChange = false;
        }

        public String toString() {
            return this.getIsLatitude() ? "map label state:latitude " : "map label state:longitude ";
        }
    }

    public static class LatLonState
    extends LatLonData {
        private MapDisplayControl mapDisplayControl;
        LatLonPanel myLatLonPanel;
        private boolean ignoreStateChange = false;
        private boolean okToShare = true;
        private LatLonState other;

        public LatLonState() {
        }

        public LatLonState(LatLonData that) {
            super(that);
        }

        public LatLonState(boolean isLatitude, Color color, float spacing, float lineWidth, int lineStyle) {
            super(isLatitude, color, spacing, lineWidth, lineStyle);
        }

        protected void init(MapDisplayControl mapDisplayControl) {
            this.mapDisplayControl = mapDisplayControl;
        }

        @Override
        public void initWith(LatLonData that) {
            try {
                super.initWith(that);
                if (this.myLatLonPanel != null) {
                    this.myLatLonPanel.setLatLonData(this);
                }
                this.getLatLonLines();
            }
            catch (Exception exc) {
                MapDisplayControl.logException("initWith", exc);
            }
        }

        private void stateWasShared() {
            this.ignoreStateChange = true;
            if (this.myLatLonPanel != null) {
                this.myLatLonPanel.setLatLonData(this);
            }
            this.ignoreStateChange = false;
            this.okToShare = true;
        }

        private boolean shouldShare() {
            return this.mapDisplayControl != null && this.mapDisplayControl.getApplyChangesToAllLatLon() && this.other != null && this.okToShare && !this.ignoreStateChange;
        }

        @Override
        public void setColor(Color value) {
            boolean shouldShare = this.shouldShare() && !Misc.equals(value, this.getColor());
            super.setColor(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setColor(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setVisible(boolean value) {
            boolean shouldShare = this.shouldShare() && value != this.getVisible();
            super.setVisible(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setVisible(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setFastRendering(boolean value) {
            boolean shouldShare = this.shouldShare() && value != this.getFastRendering();
            super.setFastRendering(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setFastRendering(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setLineStyle(int value) {
            boolean shouldShare = this.shouldShare() && value != this.getLineStyle();
            super.setLineStyle(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setLineStyle(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setSpacing(float value) {
            boolean shouldShare = this.shouldShare() && value != this.getSpacing();
            super.setSpacing(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setSpacing(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setBase(float value) {
            boolean shouldShare = this.shouldShare() && value != this.getBase();
            super.setBase(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setBase(value);
                this.other.stateWasShared();
            }
        }

        @Override
        public void setLineWidth(float value) {
            boolean shouldShare = this.shouldShare() && value != this.getLineWidth();
            super.setLineWidth(value);
            if (shouldShare) {
                this.other.okToShare = false;
                this.other.setLineWidth(value);
                this.other.stateWasShared();
            }
        }

        protected void checkVisibility() {
            if (this.myLatLon == null || this.myLatLonPanel == null) {
                return;
            }
            try {
                this.myLatLon.setVisible(this.getRealVisibility());
            }
            catch (Exception exc) {
                MapDisplayControl.logException("Setting visibility", exc);
            }
        }

        @Override
        protected boolean getRealVisibility() {
            if (this.mapDisplayControl == null) {
                return super.getRealVisibility();
            }
            return super.getRealVisibility() && this.mapDisplayControl.getDisplayVisibility();
        }

        @Override
        public void stateChanged() {
            if (this.ignoreStateChange || this.myLatLon == null || this.myLatLonPanel == null) {
                return;
            }
            this.ignoreStateChange = true;
            try {
                if (this.okToShare) {
                    this.myLatLonPanel.applyStateToData();
                }
                this.getLatLonLines();
            }
            catch (Exception exc) {
                DisplayControlBase.logException("State change", exc);
            }
            this.ignoreStateChange = false;
        }

        public String toString() {
            return this.getIsLatitude() ? "map state:latitude " : "map state:longitude ";
        }
    }
}

