/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.GeoUtils;
import ucar.visad.ShapeUtility;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.ShapeDisplayable;
import visad.Data;
import visad.DisplayEvent;
import visad.Gridded3DSet;
import visad.MathType;
import visad.PlotText;
import visad.RealTuple;
import visad.RealTupleType;
import visad.ScalarType;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.Tuple;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADQuadArray;
import visad.georef.EarthLocation;
import visad.georef.LatLonPoint;
import visad.java3d.DisplayRendererJ3D;

public class LocationIndicatorControl
extends DisplayControlImpl {
    public static final int CLIP_NONE = 0;
    public static final int CLIP_POSITIVE = 1;
    public static final int CLIP_NEGATIVE = 2;
    public static final int IDX_X = 0;
    public static final int IDX_Y = 1;
    public static final int IDX_Z = 2;
    public static String[] CLIP_NAMES1 = new String[]{"Above", "Left", "Bottom"};
    public static String[] CLIP_NAMES2 = new String[]{"Below", "Right", "Top"};
    private static float BOX = 0.99f;
    private double lastDisplayScale = 1.0;
    private boolean dragging = false;
    private float[] originLoc = new float[]{0.0f, 0.0f, 0.0f};
    private float[] pointLoc = new float[]{0.0f, 0.0f, 0.0f};
    private float[] minArray;
    private float[] maxArray;
    private boolean showPoint = false;
    private JCheckBox showPointCbx;
    private static int typeCnt = 0;
    private float span = BOX;
    private AxisInfo xInfo;
    private AxisInfo yInfo;
    private AxisInfo zInfo;
    private boolean visibleTextC = true;
    private boolean keepInBox = false;
    private CompositeDisplayable textHolder;
    private LocationReadout originReadout;
    private LocationReadout pointReadout;
    private LocationReadout xReadout;
    private LocationReadout yReadout;
    private LocationReadout zReadout;
    private ShapeDisplayable pointDisplayable;
    LineDrawing pointLine;
    private ShapeDisplayable cText;
    private boolean enabled = true;
    private JLabel bearingLbl = new JLabel("Bearing: ");
    private JLabel azimuthLbl = new JLabel(" ");
    private int lineWidth = 1;
    private Font font;
    private static final Font defaultFont = new Font("Monospaced", 0, 12);
    private JComboBox fontBox;
    private JComboBox fontSizeBox;
    CompositeDisplayable displayHolder;
    CompositeDisplayable solidHolder;
    Color solidColor;
    double solidAlphaPercent = 1.0;
    TextType textType;
    private JLabel sideLegendReadout;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.displayHolder = new CompositeDisplayable();
        this.solidHolder = new CompositeDisplayable();
        this.textHolder = new CompositeDisplayable();
        this.getXInfo().initDisplayables();
        this.getYInfo().initDisplayables();
        this.getZInfo().initDisplayables();
        this.addDisplayable(this.solidHolder);
        this.addDisplayable((Displayable)this.displayHolder, 4);
        this.displayHolder.addDisplayable(this.textHolder);
        Color c = this.getColor();
        if (c == null) {
            c = Color.red;
            this.setColor(c);
        }
        this.displayHolder.setColor(c);
        if (this.solidColor == null) {
            this.solidColor = Color.gray;
        }
        this.setSolidColor(this.solidColor);
        this.pointDisplayable = new ShapeDisplayable("Point" + typeCnt++, this.getTickMark());
        this.pointDisplayable.setAutoSize(true);
        this.pointLine = new LineDrawing("LocationIndicatorControl.xline");
        this.displayHolder.addDisplayable(this.pointDisplayable);
        this.displayHolder.addDisplayable(this.pointLine);
        this.cText = new ShapeDisplayable("Text" + typeCnt++, "");
        if (this.font == null) {
            this.font = defaultFont;
        }
        this.displayHolder.setLineWidth(this.getLineWidth());
        this.originReadout = new LocationReadout(this);
        this.pointReadout = new LocationReadout(this);
        this.xReadout = new LocationReadout(this);
        this.yReadout = new LocationReadout(this);
        this.zReadout = new LocationReadout(this);
        this.checkVisibility();
        this.updatePosition();
        return true;
    }

    public void updatePositionFromReadout(LocationReadout readout) {
        try {
            boolean ensureShowPoint = true;
            float[] readoutLoc = readout.getXYZ();
            if (readout == this.originReadout) {
                ensureShowPoint = false;
                this.originLoc = readoutLoc;
            } else if (readout == this.pointReadout) {
                this.pointLoc = readoutLoc;
            } else if (readout == this.xReadout) {
                this.pointLoc[0] = readoutLoc[0];
                this.originLoc[1] = readoutLoc[1];
                this.originLoc[2] = readoutLoc[2];
            } else if (readout == this.yReadout) {
                this.pointLoc[1] = readoutLoc[1];
                this.originLoc[0] = readoutLoc[0];
                this.originLoc[2] = readoutLoc[2];
            } else if (readout == this.zReadout) {
                this.pointLoc[2] = readoutLoc[2];
                this.originLoc[1] = readoutLoc[1];
                this.originLoc[0] = readoutLoc[0];
            }
            this.updatePosition();
            if (ensureShowPoint && !this.showPoint) {
                this.showPointCbx.setSelected(true);
                this.showPoint = true;
                this.checkVisibility();
            }
        }
        catch (Exception exc) {
            LocationIndicatorControl.logException("Updating position", exc);
        }
    }

    VisADGeometryArray getTickMark() throws VisADException, RemoteException {
        VisADGeometryArray marker = ShapeUtility.setSize(ShapeUtility.makeShape("CROSS"), 0.04f * this.getDisplayScale());
        double[] aspect = this.getNavigatedDisplay().getDisplayAspect();
        if (aspect != null && aspect.length > 2 && aspect[0] > 0.0 && aspect[1] > 0.0 && aspect[2] > 0.0) {
            marker = ShapeUtility.setSize(marker, (float)(1.0 / aspect[0]), (float)(1.0 / aspect[1]), (float)(1.0 / aspect[2]));
        }
        return marker;
    }

    public static void setPts(LineDrawing ld, float x1, float x2, float y1, float y2, float z1, float z2) throws VisADException, RemoteException {
        RealTupleType mathType = RealTupleType.SpatialCartesian3DTuple;
        float[][] pts = new float[][]{{x1, x2}, {y1, y2}, {z1, z2}};
        ld.setData(new Gridded3DSet((MathType)mathType, (float[][])pts, 2));
    }

    float[] getMin() {
        if (this.minArray == null) {
            this.minArray = new float[3];
        }
        this.minArray[0] = Math.min(-this.span, this.originLoc[0]);
        this.minArray[1] = Math.min(-this.span, this.originLoc[1]);
        this.minArray[2] = Math.min(-this.span, this.originLoc[2]);
        return this.minArray;
    }

    float[] getMax() {
        if (this.maxArray == null) {
            this.maxArray = new float[3];
        }
        this.maxArray[0] = Math.max(this.span, this.originLoc[0]);
        this.maxArray[1] = Math.max(this.span, this.originLoc[1]);
        this.maxArray[2] = Math.max(this.span, this.originLoc[2]);
        return this.maxArray;
    }

    private void checkClip(boolean onlyIfOn) {
        try {
            int coeff;
            double value;
            double oX = this.originLoc[0];
            double oY = this.originLoc[1];
            double oZ = this.originLoc[2];
            NavigatedDisplay navDisplay = this.getNavigatedDisplay();
            DisplayRendererJ3D dr = (DisplayRendererJ3D)navDisplay.getDisplay().getDisplayRenderer();
            AxisInfo axis = this.getXInfo();
            if (!onlyIfOn || axis.getClip() != 0) {
                value = oY;
                coeff = axis.getClipCoefficient();
                dr.setClip(axis.getIndex(), axis.getClip() != 0, 0.0f, coeff, 0.0f, (float)((double)(-coeff) * (value + (double)((float)coeff * 0.01f))));
            }
            axis = this.getYInfo();
            if (!onlyIfOn || axis.getClip() != 0) {
                value = oX;
                coeff = -axis.getClipCoefficient();
                dr.setClip(axis.getIndex(), axis.getClip() != 0, coeff, 0.0f, 0.0f, (float)((double)(-coeff) * (value + (double)((float)coeff * 0.01f))));
            }
            axis = this.getZInfo();
            if (!onlyIfOn || axis.getClip() != 0) {
                value = oZ;
                coeff = -axis.getClipCoefficient();
                dr.setClip(axis.getIndex(), axis.getClip() != 0, 0.0f, 0.0f, coeff, (float)((double)(-coeff) * (value + (double)((float)coeff * 0.01f))));
            }
        }
        catch (Exception exc) {
            LocationIndicatorControl.logException("Updating position", exc);
        }
    }

    private void updatePosition() throws VisADException, RemoteException {
        if (this.displayHolder == null) {
            return;
        }
        float[] min = this.getMin();
        float[] max = this.getMax();
        float ptX = this.pointLoc[0];
        float ptY = this.pointLoc[1];
        float ptZ = this.pointLoc[2];
        double oX = this.originLoc[0];
        double oY = this.originLoc[1];
        double oZ = this.originLoc[2];
        EarthLocation originEl = this.boxToEarth(oX, oY, oZ, false);
        EarthLocation ptEl = this.boxToEarth(ptX, ptY, ptZ, false);
        this.getXInfo().updateAxisPosition(originEl, ptEl);
        this.getYInfo().updateAxisPosition(originEl, ptEl);
        this.getZInfo().updateAxisPosition(originEl, ptEl);
        this.checkClip(true);
        Bearing result = Bearing.calculateBearing(originEl.getLatLonPoint().getLatitude().getValue(), originEl.getLatLonPoint().getLongitude().getValue(), ptEl.getLatLonPoint().getLatitude().getValue(), ptEl.getLatLonPoint().getLongitude().getValue(), null);
        if (this.azimuthLbl != null) {
            String bearingText = "";
            if (this.showPoint) {
                bearingText = "" + this.getDisplayConventions().formatAngle(result.getAngle());
            }
            this.azimuthLbl.setText(StringUtil.padRight(bearingText, 15));
        }
        LocationIndicatorControl.setPts(this.pointLine, ptX, (float)oX, ptY, (float)oY, ptZ, (float)oZ);
        this.pointDisplayable.setPoint(ptX, ptY, ptZ);
        StringBuffer legendSB = new StringBuffer();
        if (this.originReadout != null) {
            this.originReadout.setLocation(originEl);
            this.pointReadout.setLocation(ptEl);
            legendSB.append("Origin: " + this.originReadout.toString());
            if (this.showPoint) {
                legendSB.append("<br>Point: " + this.pointReadout.toString());
            }
            this.xReadout.setLocation(this.boxToEarth(ptX, this.originLoc[1], this.originLoc[2], false));
            this.yReadout.setLocation(this.boxToEarth(this.originLoc[0], ptY, this.originLoc[2], false));
            this.zReadout.setLocation(this.boxToEarth(this.originLoc[0], this.originLoc[1], ptZ, false));
        }
        if (this.sideLegendReadout == null) {
            this.sideLegendReadout = new JLabel("<html><br></html>");
        }
        this.sideLegendReadout.setText("<html>" + legendSB.toString() + "</html>");
        if (!this.dragging) {
            // empty if block
        }
    }

    private Tuple getTuple(double x, double y, double z, ScalarType textType) throws VisADException, RemoteException {
        return new Tuple(new Data[]{new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{x, y, z}), this.getLabel(x, y, z, textType)});
    }

    private Text getLabel(double x, double y, double z, ScalarType textType) throws VisADException, RemoteException {
        EarthLocation el = this.boxToEarth(x, y, z);
        String label = this.getControlContext().getDisplayConventions().formatEarthLocationShort(el);
        return new Text((TextType)textType, label);
    }

    private String getStr(double x, double y, double z) throws VisADException, RemoteException {
        EarthLocation el = this.boxToEarth(x, y, z);
        return this.getControlContext().getDisplayConventions().formatEarthLocationShort(el);
    }

    @Override
    public void setDisplayVisibility(boolean on) {
        super.setDisplayVisibility(on);
        this.checkVisibility();
    }

    protected void checkVisibility() {
        try {
            if (this.pointDisplayable == null) {
                return;
            }
            this.getXInfo().checkVisibility();
            this.getYInfo().checkVisibility();
            this.getZInfo().checkVisibility();
            this.pointDisplayable.setVisible(this.getDisplayVisibility() && this.showPoint);
            this.pointLine.setVisible(this.getDisplayVisibility() && this.showPoint);
        }
        catch (Exception exc) {
            LocationIndicatorControl.logException("Checking visibility", exc);
        }
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        this.clearCursor();
        this.displayHolder = null;
        super.doRemove();
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    protected void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
    }

    @Override
    public void viewpointChanged() {
        super.viewpointChanged();
        try {
            double newDisplayScale = this.getDisplayScale();
            if (Math.abs((this.lastDisplayScale - newDisplayScale) / this.lastDisplayScale) > 0.1) {
                this.lastDisplayScale = newDisplayScale;
                this.getXInfo().setLabelPosition();
                this.getYInfo().setLabelPosition();
                this.getZInfo().setLabelPosition();
            }
        }
        catch (Exception e) {
            LocationIndicatorControl.logException("Handling control changed", e);
        }
    }

    @Override
    public void projectionChanged() {
        try {
            super.projectionChanged();
            this.updatePosition();
        }
        catch (Exception e) {
            LocationIndicatorControl.logException("Handling projection changed", e);
        }
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        if (this.sideLegendReadout == null) {
            this.sideLegendReadout = new JLabel("<html><br></html>");
        }
        return GuiUtils.vbox(parentComp, this.sideLegendReadout);
    }

    protected boolean canHandleEvents() {
        if (!this.getEnabled() || !this.getHaveInitialized()) {
            return false;
        }
        return this.isGuiShown();
    }

    @Override
    public void handleDisplayChanged(DisplayEvent event) {
        InputEvent inputEvent = event.getInputEvent();
        int id = event.getId();
        if (id == 21) {
            return;
        }
        if (!this.canHandleEvents()) {
            return;
        }
        try {
            if (id == 16) {
                KeyEvent keyEvent;
                if (inputEvent instanceof KeyEvent && (keyEvent = (KeyEvent)inputEvent).isControlDown() && keyEvent.isAltDown()) {
                    int code = keyEvent.getKeyCode();
                    if (code == 79) {
                        this.originLoc = new float[]{0.0f, 0.0f, 0.0f};
                        this.pointLoc = new float[]{0.0f, 0.0f, 0.0f};
                    } else if (code == 76) {
                        this.originLoc[0] = -this.span;
                        this.pointLoc[0] = -this.span;
                    } else if (code == 82) {
                        this.originLoc[0] = this.span;
                        this.pointLoc[0] = this.span;
                    } else if (code == 84) {
                        this.originLoc[1] = this.span;
                        this.pointLoc[1] = this.span;
                    } else if (code == 66) {
                        this.originLoc[1] = -this.span;
                        this.pointLoc[1] = -this.span;
                    } else if (code == 85) {
                        this.originLoc[2] = this.span;
                        this.pointLoc[2] = this.span;
                    } else if (code == 68) {
                        this.originLoc[2] = -this.span;
                        this.pointLoc[2] = -this.span;
                    } else {
                        return;
                    }
                    this.updatePosition();
                }
                return;
            }
            if (id == 18) {
                if (!LocationIndicatorControl.isLeftButtonDown(event) || inputEvent.isShiftDown()) {
                    return;
                }
                this.dragging = true;
                double[] location = this.toBox(event);
                boolean doPoint = inputEvent.isControlDown() || inputEvent.isAltDown();
                float[] ptArray = doPoint ? this.pointLoc : this.originLoc;
                ptArray[0] = (float)(this.getXInfo().move ? location[0] : (double)ptArray[0]);
                ptArray[1] = (float)(this.getYInfo().move ? location[1] : (double)ptArray[1]);
                ptArray[2] = (float)(this.getZInfo().move ? location[2] : (double)ptArray[2]);
                if (this.keepInBox) {
                    ptArray[0] = Math.min(Math.max(-BOX, ptArray[0]), BOX);
                    ptArray[1] = Math.min(Math.max(-BOX, ptArray[1]), BOX);
                    ptArray[2] = Math.min(Math.max(-BOX, ptArray[2]), BOX);
                }
                float[] min = this.getMin();
                float[] max = this.getMax();
                this.pointLoc[0] = Math.min(max[0], Math.max(this.pointLoc[0], min[0]));
                this.pointLoc[1] = Math.min(max[1], Math.max(this.pointLoc[1], min[1]));
                this.pointLoc[2] = Math.min(max[2], Math.max(this.pointLoc[2], min[2]));
                if (doPoint && !this.showPoint) {
                    this.showPointCbx.setSelected(true);
                    this.showPoint = true;
                    this.checkVisibility();
                }
                this.updatePosition();
            } else if (id == 7) {
                if (!LocationIndicatorControl.isLeftButtonDown(event)) {
                    return;
                }
                this.dragging = false;
                this.updatePosition();
            }
        }
        catch (Exception e) {
            LocationIndicatorControl.logException("Handling display event changed", e);
        }
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        super.receiveShareData(from, dataId, data);
    }

    public void fontChanged(Object value) {
        this.setFont(this.getFont());
    }

    public void colorChanged(String colorName) {
        if (colorName != null) {
            this.setSolidColor(this.getDisplayConventions().getColor(colorName));
        }
    }

    public void lineWidthChanged(Integer v) {
        this.setLineWidth(v);
    }

    public void spanSliderChanged(int value) {
        try {
            double percent = (double)value / 100.0;
            this.setSpan((float)(percent * (double)BOX * 5.0));
            this.updatePosition();
        }
        catch (Exception exc) {
            LocationIndicatorControl.logException("Setting span position", exc);
        }
    }

    public void transparencyChanged(Object selected) {
        int value = 0;
        if (selected instanceof TwoFacedObject) {
            TwoFacedObject tfo = (TwoFacedObject)selected;
            value = (Integer)tfo.getId();
        } else {
            String text = selected.toString();
            try {
                text = StringUtil.replace(text, "%", "").trim();
                value = (int)new Float(text).floatValue();
            }
            catch (Exception e) {
                LocationIndicatorControl.logException("Setting transparency", e);
            }
        }
        value = 100 - value;
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        this.setSolidAlphaPercent((double)value / 100.0);
        this.setSolidColor(this.solidColor);
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        ArrayList<TwoFacedObject> transparencyItems = new ArrayList<TwoFacedObject>();
        int[] values = new int[]{0, 20, 40, 50, 60, 80, 100};
        int transInt = 100 - (int)(this.solidAlphaPercent * 100.0);
        TwoFacedObject selectedTfo = null;
        for (int i = 0; i < values.length; ++i) {
            TwoFacedObject tfo = new TwoFacedObject((Object)(values[i] + "%"), new Integer(values[i]));
            transparencyItems.add(tfo);
            if (values[i] != transInt) continue;
            selectedTfo = tfo;
        }
        if (selectedTfo == null) {
            selectedTfo = new TwoFacedObject((Object)(transInt + "%"), new Integer(transInt));
            transparencyItems.add(selectedTfo);
        }
        JComboBox solidColorBox = GuiUtils.makeComboBox(this.getDisplayConventions().getColorNameList(), this.getDisplayConventions().getColorName(this.solidColor), false, this, "colorChanged");
        JSlider spanSlider = GuiUtils.makeSlider(0, 100, (int)((double)this.span / 5.0 * 100.0), this, "spanSliderChanged");
        Component colorCbx = this.doMakeColorControl(this.getColor());
        Vector<Integer> lineWidths = new Vector<Integer>();
        for (int i = 1; i <= 10; ++i) {
            lineWidths.add(new Integer(i));
        }
        JComboBox widthComp = GuiUtils.makeComboBox(lineWidths, new Integer(this.lineWidth), false, this, "lineWidthChanged");
        this.fontBox = GuiUtils.makeComboBox(GuiUtils.getFontList(), new TwoFacedObject((Object)StringUtil.shorten(this.font.getName(), 24), this.font), false, this, "fontChanged");
        this.fontSizeBox = GuiUtils.makeComboBox(GuiUtils.getFontSizeList(), new Integer(this.font.getSize()), false, this, "fontChanged");
        this.azimuthLbl.setFont(Font.decode("monospaced"));
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel readoutPanel = GuiUtils.doLayout(new Component[]{GuiUtils.filler(), GuiUtils.cLabel("Latitude"), GuiUtils.cLabel("Longitude"), GuiUtils.cLabel("Altitude"), GuiUtils.rLabel(""), GuiUtils.rLabel("Origin:"), this.originReadout.latLbl, this.originReadout.lonLbl, this.originReadout.altComp, GuiUtils.filler(), GuiUtils.rLabel("Point:"), this.pointReadout.latLbl, this.pointReadout.lonLbl, this.pointReadout.altComp, GuiUtils.hbox(this.bearingLbl, this.azimuthLbl), GuiUtils.rLabel("X Tick:"), this.xReadout.latLbl, this.xReadout.lonLbl, this.xReadout.altComp, GuiUtils.filler(), GuiUtils.rLabel("Y Tick:"), this.yReadout.latLbl, this.yReadout.lonLbl, this.yReadout.altComp, GuiUtils.filler(), GuiUtils.rLabel("Z Tick:"), this.zReadout.latLbl, this.zReadout.lonLbl, this.zReadout.altComp, GuiUtils.filler()}, 5, GuiUtils.WT_N, GuiUtils.WT_N);
        JLabel helpLabel = new JLabel("<html><br>Drag: move origin; Control-drag: move point<br>Control-Alt-'key': move to<br>&nbsp;&nbsp;'o': origin; 'l': left; 'r': right; 't': top; 'b': bottom; 'u': up; 'd': down</html>");
        readoutPanel = GuiUtils.vbox((Component)readoutPanel, helpLabel);
        readoutPanel = GuiUtils.topLeft(readoutPanel);
        JPanel fontPanel = GuiUtils.left(GuiUtils.flow(new Component[]{this.fontBox, new JLabel("Size: "), this.fontSizeBox}));
        JPanel solidPanel = GuiUtils.hbox((Component)new JLabel("  Color: "), (Component)solidColorBox, (Component)new JLabel("  Transparency: "), GuiUtils.makeComboBox(transparencyItems, selectedTfo, true, this, "transparencyChanged"));
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel topPanel = GuiUtils.doLayout(new Component[]{GuiUtils.filler(), GuiUtils.cLabel("X"), GuiUtils.cLabel("Y"), GuiUtils.cLabel("Z"), GuiUtils.filler(), GuiUtils.rLabel("Move:"), GuiUtils.makeCheckbox("", this.getXInfo(), "move"), GuiUtils.makeCheckbox("", this.getYInfo(), "move"), GuiUtils.makeCheckbox("", this.getZInfo(), "move"), GuiUtils.hbox(GuiUtils.makeCheckbox("Keep in Box", this, "keepInBox"), GuiUtils.makeCheckbox("Enabled", this, "enabled")), GuiUtils.rLabel("Clip:"), this.getXInfo().makeClipBox(), this.getYInfo().makeClipBox(), this.getZInfo().makeClipBox(), GuiUtils.filler(), GuiUtils.rLabel("Visibility:"), GuiUtils.makeCheckbox("", this.getXInfo(), "visible"), GuiUtils.makeCheckbox("", this.getYInfo(), "visible"), GuiUtils.makeCheckbox("", this.getZInfo(), "visible"), GuiUtils.filler(), GuiUtils.rLabel("Labels:"), GuiUtils.makeCheckbox("", this.getXInfo(), "labelVisible"), GuiUtils.makeCheckbox("", this.getYInfo(), "labelVisible"), GuiUtils.makeCheckbox("", this.getZInfo(), "labelVisible"), GuiUtils.filler(), GuiUtils.rLabel("Solid:"), GuiUtils.makeCheckbox("", this.getXInfo(), "solid"), GuiUtils.makeCheckbox("", this.getYInfo(), "solid"), GuiUtils.makeCheckbox("", this.getZInfo(), "solid"), GuiUtils.left(solidPanel), GuiUtils.rLabel("Bearing Lines:"), GuiUtils.makeCheckbox("", this.getXInfo(), "showLines"), GuiUtils.makeCheckbox("", this.getYInfo(), "showLines"), GuiUtils.makeCheckbox("", this.getZInfo(), "showLines"), GuiUtils.filler()}, 5, GuiUtils.WT_N, GuiUtils.WT_N);
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        Component[] componentArray = new Component[6];
        componentArray[0] = GuiUtils.rLabel("Bearing Point:");
        this.showPointCbx = GuiUtils.makeCheckbox("Show point", this, "showPoint");
        componentArray[1] = GuiUtils.left(this.showPointCbx);
        componentArray[2] = GuiUtils.rLabel("Axis size:");
        componentArray[3] = spanSlider;
        componentArray[4] = GuiUtils.rLabel("Line Width:");
        componentArray[5] = GuiUtils.left(GuiUtils.hbox((Component)widthComp, (Component)GuiUtils.lLabel("  Color: "), GuiUtils.left(colorCbx)));
        JPanel bottomPanel = GuiUtils.doLayout(componentArray, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel orientPanel = GuiUtils.doLayout(new Component[]{GuiUtils.makeButton("Center At Origin", this, "centerAtOrigin"), GuiUtils.makeButton("Center At Point", this, "centerAtPoint")}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
        orientPanel = GuiUtils.topLeft(orientPanel);
        JPanel displayPanel = GuiUtils.topLeft(GuiUtils.vbox((Component)GuiUtils.left(topPanel), bottomPanel));
        tabbedPane.add("Location", readoutPanel);
        tabbedPane.add("Settings", displayPanel);
        tabbedPane.add("Orient", orientPanel);
        return tabbedPane;
    }

    public void rotateAbout(Integer i) {
        int index = i;
        System.err.println("index=" + index);
    }

    public void centerAtOrigin() {
        try {
            this.getNavigatedDisplay().center(this.originLoc[0], this.originLoc[1]);
        }
        catch (Exception exc) {
            LocationIndicatorControl.logException("Center", exc);
        }
    }

    public void centerAtPoint() {
        try {
            this.getNavigatedDisplay().center(this.pointLoc[0], this.pointLoc[1]);
        }
        catch (Exception exc) {
            LocationIndicatorControl.logException("Center", exc);
        }
    }

    public Color getSolidColor() {
        return this.solidColor;
    }

    public void setSolidColor(Color c) {
        this.solidColor = c;
        if (this.solidHolder != null) {
            try {
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(this.solidAlphaPercent * 255.0));
                this.solidHolder.setColor(c);
            }
            catch (Exception e) {
                LocationIndicatorControl.logException("Setting solid color", e);
            }
        }
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width;
        if (this.displayHolder != null) {
            try {
                this.displayHolder.setLineWidth(this.getLineWidth());
            }
            catch (Exception e) {
                LocationIndicatorControl.logException("Setting line width of scale", e);
            }
        }
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    private void clearCursor() {
        this.setCursor(null);
    }

    private void setCursor(int c) {
        this.setCursor(Cursor.getPredefinedCursor(c));
    }

    private void setCursor(Cursor c) {
        this.getViewManager().setCursorInDisplay(c);
    }

    public Font getFont() {
        if (this.fontBox == null) {
            return this.font;
        }
        this.font = (Font)((TwoFacedObject)this.fontBox.getSelectedItem()).getId();
        if (this.font == null) {
            this.font = defaultFont;
        }
        int fontSize = (Integer)this.fontSizeBox.getSelectedItem();
        return this.font.deriveFont((float)fontSize);
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.makeMenuItem("Set origin to address", this, "goToAddress", "origin"));
        items.add(GuiUtils.makeMenuItem("Set point to address", this, "goToAddress", "point"));
        items.add("separator");
        super.getViewMenuItems(items, forMenuBar);
    }

    public void goToAddress(final String which) {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                LocationIndicatorControl.this.goToAddressInner(which);
            }
        });
    }

    public void goToAddressInner(String which) {
        try {
            this.showWaitCursor();
            LatLonPoint llp = GeoUtils.getLocationOfAddress();
            this.showNormalCursor();
            if (llp == null) {
                return;
            }
            double[] xyz = this.earthToBox(GeoUtils.toEarthLocation(llp));
            if (which.equals("origin")) {
                this.originLoc = Misc.toFloat(xyz);
            } else {
                this.pointLoc = Misc.toFloat(xyz);
            }
            this.updatePosition();
        }
        catch (Exception e) {
            this.showNormalCursor();
            LocationIndicatorControl.logException("Error going to address", e);
        }
    }

    public void setFont(Font value) {
        this.font = value;
        try {
            if (this.textHolder != null) {
                float f = this.getDisplayScale() * ((float)this.font.getSize() / 12.0f);
            }
        }
        catch (Exception exc) {
            LocationIndicatorControl.logException("Setting font", exc);
        }
    }

    public void setOriginLoc(float[] value) {
        this.originLoc = value;
    }

    public float[] getOriginLoc() {
        return this.originLoc;
    }

    public void setPointLoc(float[] value) {
        this.pointLoc = value;
    }

    public float[] getPointLoc() {
        return this.pointLoc;
    }

    public void setVisibleX(boolean value) {
    }

    public void setSpan(float value) {
        this.span = value;
    }

    public float getSpan() {
        return this.span;
    }

    public void setKeepInBox(boolean value) {
        this.keepInBox = value;
    }

    public boolean getKeepInBox() {
        return this.keepInBox;
    }

    public AxisInfo getXInfo() {
        if (this.xInfo == null) {
            this.xInfo = new AxisInfo(this);
        }
        this.xInfo.index = 0;
        return this.xInfo;
    }

    public void setXInfo(AxisInfo info) {
        this.xInfo = info;
        if (this.xInfo != null) {
            this.xInfo.lic = this;
        }
    }

    public AxisInfo getYInfo() {
        if (this.yInfo == null) {
            this.yInfo = new AxisInfo(this);
        }
        this.yInfo.index = 1;
        return this.yInfo;
    }

    public void setYInfo(AxisInfo info) {
        this.yInfo = info;
        if (this.yInfo != null) {
            this.yInfo.lic = this;
        }
    }

    public AxisInfo getZInfo() {
        if (this.zInfo == null) {
            this.zInfo = new AxisInfo(this);
        }
        this.zInfo.index = 2;
        return this.zInfo;
    }

    public void setZInfo(AxisInfo info) {
        this.zInfo = info;
        if (this.zInfo != null) {
            this.zInfo.lic = this;
        }
    }

    public double[] latLonAltToXYZ(double lat, double lon, double alt) throws VisADException, RemoteException {
        return this.earthToBox(LocationIndicatorControl.makeEarthLocation(lat, lon, alt));
    }

    public void setShowPoint(boolean value) {
        this.showPoint = value;
        this.checkVisibility();
        try {
            this.updatePosition();
        }
        catch (Exception exc) {
            LocationIndicatorControl.logException("Updating position", exc);
        }
    }

    public boolean getShowPoint() {
        return this.showPoint;
    }

    public void setSolidAlphaPercent(double value) {
        this.solidAlphaPercent = value;
    }

    public double getSolidAlphaPercent() {
        return this.solidAlphaPercent;
    }

    private class LocationReadout
    implements ActionListener {
        JLabel altUnitLbl;
        JTextField latLbl;
        JTextField lonLbl;
        JTextField altLbl;
        JComponent altComp;
        double lat;
        double lon;
        double alt;
        String latString;
        String lonString;
        String altString;
        private LocationIndicatorControl lic;

        public LocationReadout(LocationIndicatorControl lic) {
            this.lic = lic;
            Font font = Font.decode("monospaced");
            this.altUnitLbl = new JLabel(" ");
            this.latLbl = new JTextField("", 10);
            this.latLbl.addActionListener(this);
            this.lonLbl = new JTextField("", 10);
            this.lonLbl.addActionListener(this);
            this.altLbl = new JTextField("", 10);
            this.altLbl.addActionListener(this);
            this.altComp = GuiUtils.hbox(this.altLbl, this.altUnitLbl);
            this.latLbl.setFont(font);
            this.lonLbl.setFont(font);
            this.altLbl.setFont(font);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.lic.updatePositionFromReadout(this);
        }

        public float[] getXYZ() throws VisADException, RemoteException, NumberFormatException {
            String newLatString = this.latLbl.getText().trim();
            String newLonString = this.lonLbl.getText().trim();
            String newAltString = this.altLbl.getText().trim();
            double newLat = this.lat;
            double newLon = this.lon;
            double newAlt = this.alt;
            if (!newLatString.equals(this.latString)) {
                newLat = Misc.parseDouble(newLatString);
            }
            if (!newLonString.equals(this.lonString)) {
                newLon = Misc.parseDouble(newLonString);
            }
            if (!newAltString.equals(this.altString)) {
                newAlt = Misc.parseDouble(newAltString);
            }
            float[] xyz = Misc.toFloat(this.lic.latLonAltToXYZ(newLat, newLon, newAlt));
            return xyz;
        }

        public void setLocation(EarthLocation el) {
            LatLonPoint llp = el.getLatLonPoint();
            this.lat = llp.getLatitude().getValue();
            this.lon = llp.getLongitude().getValue();
            this.alt = el.getAltitude().getValue();
            DisplayConventions dc = LocationIndicatorControl.this.getControlContext().getDisplayConventions();
            int pad = 0;
            this.latString = dc.formatLatLon(this.lat);
            this.latLbl.setText(StringUtil.padLeft(this.latString, pad));
            this.lonString = dc.formatLatLon(this.lon);
            this.lonLbl.setText(StringUtil.padLeft(this.lonString, pad));
            this.altUnitLbl.setText(" " + el.getAltitude().getUnit());
            this.altString = "" + dc.formatDistance(this.alt);
            this.altLbl.setText(this.altString);
        }

        public String toString() {
            return this.latLbl.getText() + "/" + this.lonLbl.getText() + " " + this.altLbl.getText();
        }
    }

    public static class AxisInfo {
        private double[] TEXT_START = new double[]{0.0, 0.0, 0.0};
        private double[] TEXT_BASE = new double[]{1.0, 0.0, 0.0};
        private double[] TEXT_UP = new double[]{0.0, 1.0, 1.0};
        private LocationIndicatorControl lic;
        private boolean showLines = false;
        private boolean visible = true;
        private boolean labelVisible = true;
        private boolean solid = false;
        private boolean move = true;
        private CompositeDisplayable axis;
        private LineDrawing axisLine;
        private LineDrawing line;
        private ShapeDisplayable tick;
        private ShapeDisplayable solidDisplayable;
        private int index;
        private ShapeDisplayable tickTextDisplayable;
        private float tickX = 0.0f;
        private float tickY = 0.0f;
        private float tickZ = 0.0f;
        private int clip = 0;
        private JComboBox clipBox;

        public AxisInfo() {
        }

        public AxisInfo(LocationIndicatorControl lic) {
            this.lic = lic;
        }

        public void initDisplayables() throws VisADException, RemoteException {
            float scale = this.lic.getDisplayScale();
            this.tickTextDisplayable = new ShapeDisplayable("Text" + typeCnt++, "-");
            this.lic.textHolder.addDisplayable(this.tickTextDisplayable);
            this.axis = new CompositeDisplayable();
            this.lic.displayHolder.addDisplayable(this.axis);
            this.axisLine = new LineDrawing("LocationIndicatorControl.axis");
            this.axis.addDisplayable(this.axisLine);
            this.line = new LineDrawing("LocationIndicatorControl.xline");
            this.axis.addDisplayable(this.line);
            this.line.setLineStyle(1);
            this.tick = new ShapeDisplayable("tick" + typeCnt++, this.lic.getTickMark());
            this.axis.addDisplayable(this.tick);
            this.solidDisplayable = new ShapeDisplayable("solid" + typeCnt++, "");
            this.lic.solidHolder.addDisplayable(this.solidDisplayable);
            this.tickTextDisplayable.setAutoSize(true);
            this.tick.setAutoSize(true);
        }

        public void checkVisibility() {
            if (this.axis == null) {
                return;
            }
            try {
                boolean mainVis = this.lic.getDisplayVisibility();
                this.axis.setVisible(mainVis && this.visible);
                this.solidDisplayable.setVisible(mainVis && this.solid);
                this.tick.setVisible(mainVis && this.visible && this.lic.getShowPoint());
                this.tickTextDisplayable.setVisible(mainVis && this.visible && this.lic.getShowPoint() && this.labelVisible);
                this.line.setVisible(mainVis && this.visible && this.lic.getShowPoint() && this.getShowLines());
            }
            catch (Exception e) {
                LocationIndicatorControl.logException("Check visibility", e);
            }
        }

        void updateAxisPosition(EarthLocation originEl, EarthLocation pointEl) throws VisADException, RemoteException {
            this.solidDisplayable.setMarker(this.makeSolid());
            float[] min = this.lic.getMin();
            float[] max = this.lic.getMax();
            float[] origin = this.lic.getOriginLoc();
            float[] point = this.lic.getPointLoc();
            this.tickX = this.index == 0 ? point[0] : origin[0];
            this.tickY = this.index == 1 ? point[1] : origin[1];
            this.tickZ = this.index == 2 ? point[2] : origin[2];
            this.tick.setPoint(this.tickX, this.tickY, this.tickZ);
            VisADGeometryArray textMarker = null;
            DisplayConventions dc = this.lic.getControlContext().getDisplayConventions();
            double[] aspect = this.lic.getNavigatedDisplay().getDisplayAspect();
            double zRotFactor = 1.0;
            if (aspect != null && aspect.length > 2 && aspect[2] > 0.0) {
                zRotFactor /= aspect[2];
            }
            this.TEXT_UP[2] = zRotFactor;
            double deltaTick = 0.05 * (double)this.lic.getDisplayScale();
            if (this.index == 0) {
                LocationIndicatorControl.setPts(this.axisLine, min[0], max[0], origin[1], origin[1], origin[2], origin[2]);
                LocationIndicatorControl.setPts(this.line, point[0], point[0], point[1], origin[1], point[2], origin[2]);
                String text = dc.formatLatLon(pointEl.getLatLonPoint().getLongitude().getValue());
                textMarker = PlotText.render_label(text, this.TEXT_START, this.TEXT_BASE, this.TEXT_UP, TextControl.Justification.CENTER, TextControl.Justification.TOP);
                this.tickTextDisplayable.setPoint(this.tickX, (double)this.tickY - deltaTick, (double)this.tickZ - deltaTick);
            } else if (this.index == 1) {
                LocationIndicatorControl.setPts(this.axisLine, origin[0], origin[0], min[1], max[1], origin[2], origin[2]);
                LocationIndicatorControl.setPts(this.line, point[0], origin[0], point[1], point[1], point[2], origin[2]);
                String text = dc.formatLatLon(pointEl.getLatLonPoint().getLatitude().getValue());
                textMarker = PlotText.render_label(text, this.TEXT_START, this.TEXT_BASE, this.TEXT_UP, TextControl.Justification.RIGHT, TextControl.Justification.CENTER);
                this.tickTextDisplayable.setPoint((double)this.tickX - deltaTick, this.tickY, (double)this.tickZ - deltaTick);
            } else {
                LocationIndicatorControl.setPts(this.axisLine, origin[0], origin[0], origin[1], origin[1], min[2], max[2]);
                LocationIndicatorControl.setPts(this.line, point[0], origin[0], point[1], origin[1], point[2], point[2]);
                String text = dc.formatLatLon(pointEl.getAltitude().getValue()) + pointEl.getAltitude().getUnit();
                textMarker = PlotText.render_label(text, this.TEXT_START, this.TEXT_BASE, this.TEXT_UP, TextControl.Justification.RIGHT, TextControl.Justification.TOP);
                this.tickTextDisplayable.setPoint((double)this.tickX - deltaTick, (double)this.tickY - deltaTick, this.tickZ);
            }
            this.setLabelPosition();
            this.tickTextDisplayable.setPointSize(this.lic.getDisplayScale());
            textMarker = ShapeUtility.setSize(textMarker, 0.05f);
            this.tickTextDisplayable.setMarker(textMarker);
        }

        public void setLabelPosition() throws VisADException, RemoteException {
            double deltaTick = 0.05 * (double)this.lic.getDisplayScale();
            if (this.index == 0) {
                this.tickTextDisplayable.setPoint(this.tickX, (double)this.tickY - deltaTick, (double)this.tickZ - deltaTick);
            } else if (this.index == 1) {
                this.tickTextDisplayable.setPoint((double)this.tickX - deltaTick, this.tickY, (double)this.tickZ - deltaTick);
            } else {
                this.tickTextDisplayable.setPoint((double)this.tickX - deltaTick, (double)this.tickY - deltaTick, this.tickZ);
            }
        }

        VisADGeometryArray makeSolid() {
            VisADQuadArray shape = new VisADQuadArray();
            float[] min = this.lic.getMin();
            float[] max = this.lic.getMax();
            float minX = min[0];
            float maxX = max[0];
            float minY = min[1];
            float maxY = max[1];
            float minZ = min[2];
            float maxZ = max[2];
            float ox = this.lic.originLoc[0];
            float oy = this.lic.originLoc[1];
            float oz = this.lic.originLoc[2];
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            if (this.index == 0) {
                nz = 1.0f;
                shape.coordinates = new float[]{minX, minY, oz, maxX, minY, oz, maxX, maxY, oz, minX, maxY, oz};
            } else if (this.index == 1) {
                nx = 1.0f;
                shape.coordinates = new float[]{ox, minY, maxZ, ox, minY, minZ, ox, maxY, minZ, ox, maxY, maxZ};
            } else {
                ny = 1.0f;
                shape.coordinates = new float[]{minX, oy, minZ, minX, oy, maxZ, maxX, oy, maxZ, maxX, oy, minZ};
            }
            shape.vertexCount = shape.coordinates.length / 3;
            shape.normals = new float[12];
            for (int i = 0; i < shape.normals.length; i += 3) {
                shape.normals[i] = nx;
                shape.normals[i + 1] = ny;
                shape.normals[i + 2] = nz;
            }
            return shape;
        }

        public void setShowLines(boolean value) {
            this.showLines = value;
            this.checkVisibility();
        }

        public boolean getShowLines() {
            return this.showLines;
        }

        public void setClip(int value) {
            this.clip = value;
            if (this.lic != null) {
                this.lic.checkClip(false);
            }
        }

        JComboBox makeClipBox() {
            Object[] items = new Object[]{new TwoFacedObject((Object)"None", 0), new TwoFacedObject((Object)CLIP_NAMES1[this.index], 1), new TwoFacedObject((Object)CLIP_NAMES2[this.index], 2)};
            this.clipBox = new JComboBox<Object>(items);
            this.clipBox.setSelectedIndex(this.clip);
            this.clipBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    clip = clipBox.getSelectedIndex();
                    lic.checkClip(false);
                }
            });
            return this.clipBox;
        }

        public int getClipCoefficient() {
            if (this.clip == 1) {
                return 1;
            }
            return -1;
        }

        public int getClip() {
            return this.clip;
        }

        public void setIndex(int value) {
            this.index = value;
        }

        public int getIndex() {
            return this.index;
        }

        public void setVisible(boolean value) {
            this.visible = value;
            if (this.lic != null) {
                this.lic.checkVisibility();
            }
        }

        public boolean getVisible() {
            return this.visible;
        }

        public void setLabelVisible(boolean value) {
            this.labelVisible = value;
            if (this.lic != null) {
                this.lic.checkVisibility();
            }
        }

        public boolean getLabelVisible() {
            return this.labelVisible;
        }

        public void setMove(boolean value) {
            this.move = value;
        }

        public boolean getMove() {
            return this.move;
        }

        public void setSolid(boolean value) {
            this.solid = value;
            if (this.lic != null) {
                this.lic.checkVisibility();
            }
        }

        public boolean getSolid() {
            return this.solid;
        }
    }
}

