/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.vecmath.Point3d;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.ShapeUtility;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.LineProbe;
import ucar.visad.display.SelectorPoint;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.VisADRay;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;

public abstract class LineProbeControl
extends GridDisplayControl {
    public static final String SHARE_PROFILE = "LineProbeControl.SHARE_PROFILE";
    public static final String PRESSURE_COORD = "pressure";
    public static final String HEIGHT_COORD = "height";
    private LineProbe probe;
    private RealTuple initPosition;
    private String marker;
    protected String positionText;

    public LineProbeControl() {
        this.setAttributeFlags(4);
    }

    public void doMakeProbe() throws VisADException, RemoteException {
        this.doMakeProbe(this.getColor());
    }

    public void doMakeProbe(Color c) throws VisADException, RemoteException {
        this.doMakeProbe(c, this.getDefaultViewDescriptor());
    }

    public void doMakeProbe(ViewDescriptor view) throws VisADException, RemoteException {
        this.doMakeProbe(this.getColor(), view);
    }

    public void doMakeProbe(Color probeColor, ViewDescriptor view) throws VisADException, RemoteException {
        this.probe = null;
        RealTuple position1 = this.initPosition;
        if (position1 == null) {
            position1 = this.getInitialLinePosition();
        }
        this.probe = this.inGlobeDisplay() ? new LineProbe(position1, new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{0.0, 0.0, 0.0}), null) : new LineProbe(position1);
        this.initPosition = this.probe.getPosition();
        if (this.inGlobeDisplay()) {
            this.probe.getSelectorPoint().setDragAdapter(new DisplayableData.DragAdapter(){

                @Override
                public boolean handleDragDirect(VisADRay ray, boolean first, int mouseModifiers) {
                    return true;
                }

                @Override
                public boolean constrainDragPoint(float[] x) {
                    LineProbeControl.this.constrainGlobePoint(x);
                    return true;
                }

                @Override
                public boolean handleAddPoint(float[] x) {
                    return true;
                }
            });
        }
        this.probe.setColor(probeColor);
        this.probe.setVisible(true);
        this.probe.addPropertyChangeListener(this);
        this.probe.setPointSize(this.getDisplayScale());
        if (this.marker != null) {
            this.probe.setMarker(SelectorPoint.reduce(ShapeUtility.makeShape(this.marker)));
        }
        this.probe.setAutoSize(true);
        this.addDisplayable((Displayable)this.probe, view, 4);
    }

    private void constrainGlobePoint(float[] position) {
        float x = position[0];
        float y = position[1];
        float z = position[2];
        double length = new Point3d(0.0, 0.0, 0.0).distance(new Point3d((double)x, (double)y, (double)z));
        double probeRadius = 1.5;
        if (length != 0.0) {
            double newx = (double)x * (probeRadius / length);
            double newy = (double)y * (probeRadius / length);
            double newz = (double)z * (probeRadius / length);
            position[0] = (float)newx;
            position[1] = (float)newy;
            position[2] = (float)newz;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectorDisplay.position")) {
            this.doMoveProbe();
        } else {
            super.propertyChange(evt);
        }
    }

    public void resetProbePosition() {
        try {
            this.setProbePosition(0.0, 0.0);
        }
        catch (Exception exc) {
            LineProbeControl.logException("Resetting probe position", exc);
        }
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        if (this.probe != null) {
            JMenuItem mi = new JMenuItem("Reset Probe Position");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LineProbeControl.this.resetProbePosition();
                }
            });
            items.add(mi);
        }
        super.getEditMenuItems(items, forMenuBar);
    }

    public void setProbePosition(RealTuple xy) throws VisADException, RemoteException {
        this.probe.setPosition(xy);
    }

    public void setProbePosition(double x, double y) throws VisADException, RemoteException {
        this.setProbePosition(new RealTuple(new Real[]{new Real(RealType.XAxis, x), new Real(RealType.YAxis, y)}));
    }

    public void setPosition(RealTuple p) {
        this.initPosition = p;
    }

    public RealTuple getPosition() throws VisADException, RemoteException {
        return this.probe != null ? this.probe.getPosition() : null;
    }

    public RealTuple getInitialPosition() {
        return this.initPosition;
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (dataId.equals("DisplayControlImpl.SHARE_POSITION")) {
            if (this.probe == null) {
                return;
            }
            try {
                this.probe.setPosition((RealTuple)data[0]);
                this.probePositionChanged(this.getPosition());
            }
            catch (Exception e) {
                LineProbeControl.logException("receiveShareData:" + dataId, e);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    protected void doMoveProbe() {
        try {
            RealTuple position = this.getPosition();
            this.probePositionChanged(position);
            this.doShare((Object)"DisplayControlImpl.SHARE_POSITION", position);
        }
        catch (Exception e) {
            LineProbeControl.logException("doMoveProfile", e);
        }
    }

    protected void probePositionChanged(RealTuple position) {
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        try {
            this.probePositionChanged(this.getPosition());
        }
        catch (Exception exc) {
            LineProbeControl.logException("projectionChanged", exc);
        }
    }

    public JMenu doMakeProbeMenu(JMenu probeMenu) {
        JMenu posMenu = new JMenu("Position");
        probeMenu.add(posMenu);
        posMenu.add(GuiUtils.makeMenuItem("Reset Probe Position", this, "resetProbePosition"));
        probeMenu.add(this.doMakeChangeColorMenu());
        JMenu sizeMenu = new JMenu("Size");
        probeMenu.add(sizeMenu);
        sizeMenu.add(GuiUtils.makeMenuItem("Increase", this, "increaseProbeSize"));
        sizeMenu.add(GuiUtils.makeMenuItem("Decrease", this, "decreaseProbeSize"));
        JMenu shapeMenu = new JMenu("Probe Shape");
        probeMenu.add(shapeMenu);
        for (int i = 0; i < ShapeUtility.SHAPES.length; ++i) {
            TwoFacedObject tof = ShapeUtility.SHAPES[i];
            String lbl = tof.toString();
            if (Misc.equals(tof.getId(), this.marker)) {
                lbl = ">" + lbl;
            }
            JMenuItem mi = GuiUtils.makeMenuItem(lbl, this, "setMarker", tof.getId());
            shapeMenu.add(mi);
        }
        GuiUtils.limitMenuSize(shapeMenu, "Shape Group ", 10);
        return probeMenu;
    }

    public void increaseProbeSize() {
        if (this.probe == null) {
            return;
        }
        float newPointSize = this.probe.getPointScale();
        this.setPointSize(newPointSize + newPointSize * 0.5f);
    }

    public void decreaseProbeSize() {
        if (this.probe == null) {
            return;
        }
        float newPointSize = this.probe.getPointScale();
        if ((newPointSize -= newPointSize * 0.5f) < 0.1f) {
            newPointSize = 0.1f;
        }
        this.setPointSize(newPointSize);
    }

    @Override
    public void setPointSize(float value) {
        super.setPointSize(value);
        if (this.probe != null) {
            try {
                this.probe.setAutoSize(false);
                this.probe.setPointSize(this.getPointSize());
                this.probe.setAutoSize(true);
            }
            catch (Exception exc) {
                LineProbeControl.logException("Increasing probe size", exc);
            }
        }
    }

    public RealTuple getGridCenterPosition() throws VisADException, RemoteException {
        LatLonPoint rt;
        RealTuple xyz;
        RealTuple pos = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{0.0, 0.0});
        if (this.getGridDataInstance() != null && (xyz = this.earthToBoxTuple(new EarthLocationTuple(rt = GridUtil.getCenterLatLonPoint(this.getGridDataInstance().getGrid()), new Real(RealType.Altitude, 0.0)))) != null) {
            pos = new RealTuple(new Real[]{(Real)xyz.getComponent(0), (Real)xyz.getComponent(1)});
        }
        return pos;
    }

    public RealTuple getInitialLinePosition() throws VisADException, RemoteException {
        if (this.inGlobeDisplay()) {
            Point3d p = new Point3d(0.0, 0.0, 1.0);
            NavigatedDisplay navDisplay = this.getNavigatedDisplay();
            navDisplay.applyRotation(p);
            return new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{p.x, p.y, p.z});
        }
        double[] center = this.getScreenCenter();
        return new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{center[0], center[1]});
    }

    public void setMarker(String value) {
        this.marker = value;
        if (this.probe != null && this.marker != null) {
            try {
                this.probe.setAutoSize(false);
                this.probe.setMarker(SelectorPoint.reduce(ShapeUtility.makeShape(this.marker)));
                this.probe.setAutoSize(true);
            }
            catch (Exception exc) {
                LineProbeControl.logException("Setting marker", exc);
            }
        }
    }

    public String getMarker() {
        return this.marker;
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList("%position%"));
        labels.addAll(Misc.newList("Probe Position"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        patterns.add("%position%");
        values.add(this.positionText);
    }

    @Override
    protected void updateLegendLabel() {
        super.updateLegendLabel();
        String template = this.getDisplayListTemplate();
        if (template.contains("%position%")) {
            this.updateDisplayList();
        }
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        labels.add(this.positionText);
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    public void viewpointChanged() {
        if (this.getMatchDisplayRegion() && this.reloadFromBounds) {
            try {
                NavigatedDisplay navDisplay = this.getMapDisplay();
                LatLonRect baseLLR = this.dataSelection.getGeoSelection().getLatLonRect();
                LatLonRect newLLR = navDisplay.getLatLonRect();
                if (baseLLR != null && !newLLR.containedIn(baseLLR)) {
                    GeoSelection gs = this.dataSelection.getGeoSelection();
                    GeoLocationInfo ginfo = new GeoLocationInfo(newLLR);
                    gs.setBoundingBox(ginfo);
                    this.updateDataSelection(this.dataSelection);
                    this.getGridDataInstance().setDataSelection(this.dataSelection);
                    this.getGridDataInstance().reInitialize();
                }
                this.relocateDisplay(baseLLR, newLLR, false);
                this.reloadFromBounds = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasMapProjection() {
        return true;
    }

    @Override
    public void relocateDisplay(LatLonRect originalBounds, LatLonRect newBounds, boolean useDataProjection) {
        super.relocateDisplay(originalBounds, newBounds, useDataProjection);
        double latRatio = 0.5;
        double lonRatio = 0.5;
        EarthLocationTuple el = null;
        double deltaLat = newBounds.getLatMax() - newBounds.getLatMin();
        LatLonPointImpl lowerLeft = newBounds.getLowerLeftPoint();
        double nlat = lowerLeft.getLatitude() + deltaLat * latRatio;
        double nlon = newBounds.getCenterLon();
        double nalt = 0.0;
        try {
            if (el != null) {
                nalt = el.getAltitude().getValue();
            }
            EarthLocation newel = LineProbeControl.makeEarthLocation(nlat, nlon, nalt);
            double[] ets = this.earthToBox(newel);
            this.setProbePosition(ets[0], ets[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

