/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.geom.Rectangle2D;
import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.SI;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.LambertAzimuthalEqualArea;
import visad.georef.MapProjection;

public class LambertAEA
extends MapProjection {
    CoordinateSystem cs;
    Rectangle2D rect;
    float earthRadius = 6367470.0f;

    public LambertAEA(float[][] corners, float lonCenter, float latCenter) throws VisADException {
        super(RealTupleType.SpatialEarth2DTuple, new Unit[]{SI.meter, SI.meter});
        this.cs = new LambertAzimuthalEqualArea(RealTupleType.SpatialEarth2DTuple, this.earthRadius, (double)lonCenter * (Math.PI / 180), (double)latCenter * (Math.PI / 180), 0.0, 0.0);
        float[][] xy = this.cs.fromReference(corners);
        float min_x = Float.MAX_VALUE;
        float min_y = Float.MAX_VALUE;
        float max_x = -3.4028235E38f;
        float max_y = -3.4028235E38f;
        for (int k = 0; k < xy[0].length; ++k) {
            if (xy[0][k] < min_x) {
                min_x = xy[0][k];
            }
            if (xy[1][k] < min_y) {
                min_y = xy[1][k];
            }
            if (xy[0][k] > max_x) {
                max_x = xy[0][k];
            }
            if (!(xy[1][k] > max_y)) continue;
            max_y = xy[1][k];
        }
        float del_x = max_x - min_x;
        float del_y = max_y - min_y;
        boolean forceSquareMapArea = true;
        if (forceSquareMapArea) {
            if (del_x < del_y) {
                del_x = del_y;
            } else if (del_y < del_x) {
                del_y = del_x;
            }
        }
        this.rect = new Rectangle2D.Float(-del_x / 2.0f, -del_y / 2.0f, del_x, del_y);
    }

    public LambertAEA(Rectangle2D ll_rect) throws VisADException {
        this(ll_rect, true);
    }

    public LambertAEA(Rectangle2D ll_rect, boolean forceSquareMapArea) throws VisADException {
        super(RealTupleType.SpatialEarth2DTuple, new Unit[]{SI.meter, SI.meter});
        float minLon = (float)ll_rect.getX();
        float minLat = (float)ll_rect.getY();
        float del_lon = (float)ll_rect.getWidth();
        float del_lat = (float)ll_rect.getHeight();
        float maxLon = minLon + del_lon;
        float maxLat = minLat + del_lat;
        float lonDiff = maxLon - minLon;
        float lonCenter = minLon + (maxLon - minLon) / 2.0f;
        if (lonDiff > 180.0f) {
            lonCenter += 180.0f;
        }
        float latCenter = minLat + (maxLat - minLat) / 2.0f;
        this.cs = new LambertAzimuthalEqualArea(RealTupleType.SpatialEarth2DTuple, this.earthRadius, (double)lonCenter * (Math.PI / 180), (double)latCenter * (Math.PI / 180), 0.0, 0.0);
        float[][] xy = this.cs.fromReference(new float[][]{{minLon, maxLon, minLon, maxLon}, {minLat, minLat, maxLat, maxLat}});
        float min_x = Float.MAX_VALUE;
        float min_y = Float.MAX_VALUE;
        float max_x = Float.MIN_VALUE;
        float max_y = Float.MIN_VALUE;
        for (int k = 0; k < xy[0].length; ++k) {
            if (xy[0][k] < min_x) {
                min_x = xy[0][k];
            }
            if (xy[1][k] < min_y) {
                min_y = xy[1][k];
            }
            if (xy[0][k] > max_x) {
                max_x = xy[0][k];
            }
            if (!(xy[1][k] > max_y)) continue;
            max_y = xy[1][k];
        }
        float del_x = max_x - min_x;
        float del_y = max_y - min_y;
        if (forceSquareMapArea) {
            if (del_x < del_y) {
                del_x = del_y;
            } else if (del_y < del_x) {
                del_y = del_x;
            }
        }
        min_x = -del_x / 2.0f;
        min_y = -del_y / 2.0f;
        this.rect = new Rectangle2D.Float(min_x, min_y, del_x, del_y);
    }

    @Override
    public Rectangle2D getDefaultMapArea() {
        return this.rect;
    }

    @Override
    public float[][] toReference(float[][] values) throws VisADException {
        return this.cs.toReference(values);
    }

    @Override
    public float[][] fromReference(float[][] values) throws VisADException {
        return this.cs.fromReference(values);
    }

    @Override
    public double[][] toReference(double[][] values) throws VisADException {
        return this.cs.toReference(values);
    }

    @Override
    public double[][] fromReference(double[][] values) throws VisADException {
        return this.cs.fromReference(values);
    }

    @Override
    public boolean equals(Object cs) {
        if (cs instanceof LambertAEA) {
            LambertAEA that = (LambertAEA)cs;
            if (this.cs.equals(that.cs) && this.getDefaultMapArea().equals(that.getDefaultMapArea())) {
                return true;
            }
        }
        return false;
    }
}

