/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.python.util.PythonInterpreter;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.AreaProbe;
import ucar.visad.display.CrossSectionSelector;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineProbe;
import ucar.visad.display.PointProbe;
import ucar.visad.display.SelectorDisplayable;
import ucar.visad.display.ZSelector;
import visad.Data;
import visad.Display;
import visad.Field;
import visad.FieldImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.python.JPythonEditor;

public class JythonControl
extends GridDisplayControl {
    public static final String PARAMNAME_THIS = "displayControl";
    public static final String PARAMNAME_PROBE = "probeData";
    private static final ControlDescriptor CD = null;
    public static final String PROBE_NONE = "none";
    public static final String PROBE_POINT = "point";
    public static final String PROBE_LEVEL = "level";
    public static final String PROBE_AREA = "area";
    public static final String PROBE_VERTICAL = "vertical";
    public static final String PROBE_TRANSECT = "transect";
    public static final String[] PROBES = new String[]{"none", "point", "level", "vertical", "transect", "area"};
    public static final String[] PROBE_NAMES = new String[]{"No probe", "Point probe", "Z level probe", "Vertical probe", "Transect probe", "Area probe"};
    private PythonInterpreter interpreter;
    List dataList = new ArrayList();
    private Hashtable jythonVars = new Hashtable();
    private JPanel jythonContainer;
    private JPanel sideLegendHolder;
    private Object initPosition;
    private AreaProbe areaProbe;
    private PointProbe pointProbe;
    private LineProbe verticalProbe;
    protected CrossSectionSelector transectProbe;
    private ZSelector levelProbe;
    private Object lastProbeLocation;
    private JLabel locationLabel;
    private String dataCategories;
    private String jythonDisplayCategory = "";
    private boolean developerMode = false;
    private String probeType = "point";
    JTextField labelFld;
    JTextArea categoriesFld;
    JTextField displayCategoryFld;
    private String jythonCode = null;
    private String myName;
    private JPythonEditor jythonEditor;
    private List saveMenuItems = new ArrayList();
    private List fileMenuItems = new ArrayList();
    private List editMenuItems = new ArrayList();
    private List viewMenuItems = new ArrayList();
    private boolean replaceNewData = false;
    private String newDataCallBack = null;
    private String jythonCodeURL = null;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        List l;
        this.doMakeProbe();
        if (this.developerMode && this.dataCategories == null && dataChoice != null && (l = dataChoice.getDataCategories(true)) != null) {
            this.dataCategories = StringUtil.join("\n", l);
        }
        if (this.jythonCode == null && this.jythonCodeURL != null) {
            this.jythonCode = IOUtil.readContents(this.jythonCodeURL, "");
        }
        this.setContents(this.doMakeContents());
        return true;
    }

    @Override
    public void initDone() {
        super.initDone();
        this.execJython("handleInit");
        try {
            this.setTimesForAnimation();
            this.probeMoved();
        }
        catch (Exception exc) {
            JythonControl.logException("initDone", exc);
        }
    }

    private void setTimesForAnimation() throws VisADException, RemoteException {
        Set myTimes = this.calculateTimeSet();
        if (myTimes == null) {
            return;
        }
        this.getAnimationWidget().setBaseTimes(myTimes);
    }

    private Set calculateTimeSet() {
        List choices = this.getDataChoices();
        if (choices.isEmpty()) {
            return null;
        }
        Set newSet = null;
        for (int i = 0; i < choices.size(); ++i) {
            try {
                GridDataInstance dataInstance = (GridDataInstance)this.getDataInstance();
                Set set = GridUtil.getTimeSet(dataInstance.getGrid());
                if (set == null) continue;
                if (newSet == null) {
                    newSet = set;
                    continue;
                }
                newSet = newSet.merge1DSets(set);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newSet;
    }

    @Override
    protected boolean shouldAddAnimationListener() {
        return true;
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            this.lastProbeLocation = this.getProbeLocation();
            this.execJython("handleTime", this.lastProbeLocation);
        }
        catch (Exception exc) {
            JythonControl.logException("Handling animation time", exc);
        }
        super.timeChanged(time);
    }

    private void doMakeProbe() throws VisADException, RemoteException {
        if (this.getDisplayInfos().size() > 0) {
            this.removeDisplayables();
        }
        this.transectProbe = null;
        this.verticalProbe = null;
        this.pointProbe = null;
        this.areaProbe = null;
        this.levelProbe = null;
        this.lastProbeLocation = null;
        boolean displayIs3D = this.isDisplay3D();
        if (this.probeType == null) {
            this.probeType = PROBE_NONE;
        }
        this.probeType = this.probeType.trim();
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!JythonControl.this.getHaveInitialized()) {
                    return;
                }
                if (evt.getPropertyName().equals("SelectorDisplay.position")) {
                    JythonControl.this.probeMoved();
                }
            }
        };
        SelectorDisplayable probe = null;
        if (this.probeType.equals(PROBE_POINT)) {
            this.pointProbe = new PointProbe(0.0, 0.0, 0.0);
            probe = this.pointProbe;
            if (this.initPosition != null) {
                this.pointProbe.setPosition((RealTuple)this.initPosition);
            }
        } else if (this.probeType.equals(PROBE_LEVEL)) {
            this.levelProbe = new ZSelector(-1.0, -1.0, -1.0);
            probe = this.levelProbe;
            if (this.initPosition != null) {
                this.levelProbe.setZValue(((Real)this.initPosition).getValue());
            }
        } else if (this.probeType.equals(PROBE_AREA)) {
            this.areaProbe = new AreaProbe();
            probe = this.areaProbe;
            if (this.initPosition != null) {
                this.areaProbe.setPosition((RealTuple)this.initPosition);
            }
        } else if (this.probeType.equals(PROBE_TRANSECT)) {
            this.transectProbe = new CrossSectionSelector();
            this.transectProbe.setZValue(0.95f);
            probe = this.transectProbe;
            if (this.initPosition != null) {
                this.transectProbe.setPosition((RealTuple[])this.initPosition);
            }
        } else if (this.probeType.equals(PROBE_VERTICAL)) {
            LineProbe lineProbe = this.verticalProbe = this.getDisplayAltitudeType().equals(Display.Radius) ? new LineProbe(new RealTuple(RealTupleType.SpatialEarth2DTuple, new double[]{0.0, 0.0})) : new LineProbe();
            if (this.initPosition != null) {
                this.verticalProbe.setPosition((RealTuple)this.initPosition);
            }
            probe = this.verticalProbe;
        } else if (this.probeType.equals(PROBE_NONE)) {
            // empty if block
        }
        if (probe != null) {
            this.addDisplayable((Displayable)probe, 4);
            Color color = this.getColor();
            if (color == null) {
                color = Color.blue;
            }
            probe.setColor(color);
            probe.addPropertyChangeListener(listener);
            probe.setPointSize(this.getDisplayScale());
            probe.setVisible(true);
            probe.setAutoSize(true);
        }
        this.initPosition = null;
    }

    public Object getVar(Object varName) {
        return this.jythonVars.get(varName);
    }

    public void setVar(Object varName, Object value) {
        if (varName.equals("chart") && this.jythonVars.get(varName) == null) {
            this.jythonVars.put(varName, value);
        } else if (!varName.equals("chart") && !value.toString().contains("FlatField  missing\n")) {
            this.jythonVars.put(varName, value);
        }
    }

    public void fixRange() {
        JFreeChart chart = (JFreeChart)this.jythonVars.get("chart");
        Range x = (Range)this.jythonVars.get("XRange");
        Range y = (Range)this.jythonVars.get("YRange");
        ValueAxis xa = chart.getXYPlot().getDomainAxis();
        ValueAxis ya = chart.getXYPlot().getRangeAxis();
        chart.getXYPlot().setRangeAxis(ya);
        chart.getXYPlot().setDomainAxis(xa);
    }

    private String makeProc(String procName, String p1) {
        return procName + "(" + p1 + ")";
    }

    private String makeProc(String procName, String p1, String p2) {
        return procName + "(" + p1 + "," + p2 + ")";
    }

    private String prop(String name, String value) {
        return name + "=" + value + ";";
    }

    public void writeToPlugin() {
        this.setMyName(this.labelFld.getText().trim());
        String label = this.getMyName();
        if (label == null || label.trim().length() == 0) {
            LogUtil.userMessage("You must enter a display name.");
            return;
        }
        label = label.trim();
        String id = "jythoncontrol_" + StringUtil.removeWhitespace(label.toLowerCase());
        String props = this.prop("displayName", label) + this.prop("windowVisible", "true") + this.prop("probeType", this.probeType) + this.prop("developerMode", "false");
        String categories = StringUtil.join(";", StringUtil.split(this.categoriesFld.getText(), "\n", true, true));
        String attrs = "\n\t" + XmlUtil.attr("id", id) + "\n" + "\t" + XmlUtil.attr("description", label) + "\n" + "\t" + XmlUtil.attr("class", this.getClass().getName()) + "\n" + "\t" + XmlUtil.attr("label", this.getMyName()) + "\n" + XmlUtil.attr("displaycategory", this.displayCategoryFld.getText().trim()) + "\n" + "\t" + XmlUtil.attr("categories", categories) + "\n" + "\t" + XmlUtil.attr("canstandalone", "false") + "\n" + "\t" + XmlUtil.attr("properties", props) + "\n";
        String body = "<property name=\"jythonCode\"><![CDATA[" + this.jythonCode + "]]></property>";
        String xml = XmlUtil.tag("control", attrs, body);
        this.getControlContext().getIdv().getPluginManager().addText(xml, "controls.xml");
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        this.dataList = null;
        this.execJython("handleData");
        this.lastProbeLocation = this.getProbeLocation();
        this.execJython("handleTime", this.lastProbeLocation);
    }

    public List getDataList() throws RemoteException, VisADException {
        if (this.dataList == null || this.dataList.size() == 0) {
            this.dataList = new ArrayList();
            List choices = this.getInitDataChoices();
            for (int i = 0; i < choices.size(); ++i) {
                Data data = ((DataChoice)choices.get(i)).getData(this.getDataSelection());
                this.dataList.add(data);
            }
        }
        return this.dataList;
    }

    public void execJython(String method) {
        this.execJython(method, null);
    }

    private void execJython(String method, Object probeLocation) {
        if (method == null || method.length() == 0) {
            return;
        }
        if (method.equals("handleInit")) {
            this.saveMenuItems = new ArrayList();
            this.fileMenuItems = new ArrayList();
            this.editMenuItems = new ArrayList();
            this.viewMenuItems = new ArrayList();
        }
        String code = "";
        try {
            PythonInterpreter interp = this.getMyInterpreter();
            if (probeLocation != null) {
                code = this.makeProc(method, PARAMNAME_THIS, PARAMNAME_PROBE);
                interp.set(PARAMNAME_PROBE, probeLocation);
            } else {
                code = this.makeProc(method, PARAMNAME_THIS);
            }
            interp.set(PARAMNAME_THIS, this);
            interp.exec(code);
        }
        catch (Exception exc) {
            JythonControl.logException("Error evaluating:" + code, exc);
        }
    }

    public Data sample() throws RemoteException, VisADException {
        return this.sampleIndex(0, false);
    }

    public Data sampleAtTime() throws RemoteException, VisADException {
        return this.sampleIndex(0, true);
    }

    public Data sampleIndex(int index, boolean atTime) throws RemoteException, VisADException {
        EarthLocationTuple[] probeData = this.getProbeLocation();
        if (probeData == null) {
            return null;
        }
        List data = this.getDataList();
        if (data == null || index >= data.size()) {
            return null;
        }
        return this.sampleData(probeData, (FieldImpl)data.get(index), atTime);
    }

    public List sampleAll() throws RemoteException, VisADException {
        return this.sampleAll(false);
    }

    public List sampleAllAtTime() throws RemoteException, VisADException {
        return this.sampleAll(true);
    }

    private List sampleAll(boolean atTime) throws RemoteException, VisADException {
        EarthLocationTuple[] probeData = this.getProbeLocation();
        if (probeData == null) {
            return null;
        }
        List data = this.getDataList();
        if (data == null || data.size() == 0) {
            return null;
        }
        ArrayList<Data> result = new ArrayList<Data>();
        for (int i = 0; i < data.size(); ++i) {
            result.add(this.sampleData(probeData, (FieldImpl)data.get(i), atTime));
        }
        return result;
    }

    public Data sampleDataAtProbe(FieldImpl field) throws RemoteException, VisADException {
        return this.sampleData(this.getProbeLocation(), field);
    }

    public Data sampleData(EarthLocationTuple[] loc, FieldImpl field) throws RemoteException, VisADException {
        return this.sampleData(loc, field, false);
    }

    public Real getAnimationTime() throws RemoteException, VisADException {
        Animation animation = this.getViewAnimation();
        if (animation != null && animation.getAniValue() != null) {
            return animation.getAniValue();
        }
        animation = this.getInternalAnimation(null);
        if (animation != null) {
            return animation.getAniValue();
        }
        return null;
    }

    public List getAnimationTimes() throws RemoteException, VisADException {
        Animation animation = this.getViewAnimation();
        if (animation != null) {
            Set set = animation.getSet();
            return Util.toList(set);
        }
        return null;
    }

    public List getTimesFromData() throws RemoteException, VisADException {
        List data = this.getDataList();
        ArrayList times = new ArrayList();
        for (int dataIdx = 0; dataIdx < data.size(); ++dataIdx) {
            FieldImpl field = (FieldImpl)data.get(dataIdx);
            Set timeSet = GridUtil.getTimeSet(field);
            if (timeSet == null) continue;
            List dataTimes = Util.toList(timeSet);
            for (int timeIdx = 0; timeIdx < dataTimes.size(); ++timeIdx) {
                Object t = dataTimes.get(timeIdx);
                if (times.contains(t)) continue;
                times.add(t);
            }
        }
        return times;
    }

    public Data sampleData(EarthLocationTuple[] loc, FieldImpl field, boolean atTime) throws RemoteException, VisADException {
        Real aniValue;
        Field sample = this.doSample(loc, field);
        if (sample == null) {
            return null;
        }
        if (atTime && (aniValue = this.getAnimationTime()) != null && !aniValue.isMissing()) {
            Set timeSet = sample.getDomainSet();
            Unit setUnit = timeSet.getSetUnits()[0];
            if (Unit.canConvert(aniValue.getUnit(), setUnit)) {
                double timeValue = aniValue.getValue(timeSet.getSetUnits()[0]);
                int[] index = timeSet.doubleToIndex(new double[][]{{timeValue}});
                return sample.getSample(index[0]);
            }
        }
        return sample;
    }

    private Field doSample(EarthLocationTuple[] loc, FieldImpl field) throws RemoteException, VisADException {
        if (loc == null || field == null) {
            return null;
        }
        int samplingMode = this.getDefaultSamplingModeValue();
        if (this.probeType.equals(PROBE_POINT)) {
            if (GridUtil.is3D(field)) {
                return GridUtil.sample(field, loc[0], samplingMode);
            }
            return GridUtil.sample(field, loc[0].getLatLonPoint(), samplingMode);
        }
        if (this.probeType.equals(PROBE_LEVEL)) {
            return GridUtil.sliceAtLevel(field, loc[0].getAltitude(), samplingMode);
        }
        if (this.probeType.equals(PROBE_AREA)) {
            throw new IllegalArgumentException("Sampling on area probe is not supported");
        }
        if (this.probeType.equals(PROBE_TRANSECT)) {
            return GridUtil.sliceAlongLatLonLine(field, loc[0].getLatLonPoint(), loc[1].getLatLonPoint(), samplingMode);
        }
        if (this.probeType.equals(PROBE_VERTICAL)) {
            return GridUtil.getProfileAtLatLonPoint(field, loc[0].getLatLonPoint(), samplingMode);
        }
        return null;
    }

    @Override
    protected String getChangeParameterLabel() {
        return "Add Parameter...";
    }

    @Override
    protected void addNewData(List newChoices) throws VisADException, RemoteException {
        this.dataList = null;
        if (this.replaceNewData) {
            this.setDataChoices(newChoices);
        } else {
            this.appendDataChoices(newChoices);
        }
        if (this.newDataCallBack == null) {
            this.execJython("handleData");
        } else {
            this.execJython(this.newDataCallBack);
        }
    }

    public void selectData(String message) {
        this.addData(message);
    }

    public void addData(String message) {
        this.selectData(message, null, false, false, null);
    }

    public void addData(String message, String callback) {
        this.selectData(message, callback, false, false, null);
    }

    public void replaceData(String message) {
        this.selectData(message, null, true, false, null);
    }

    public void replaceData(String message, String callback) {
        this.selectData(message, callback, true, false, null);
    }

    public void selectData(String message, String callback, boolean replace, boolean multiples, List categories) {
        this.replaceNewData = replace;
        this.newDataCallBack = callback;
        if (categories != null) {
            this.popupDataDialog(message, null, multiples, categories);
        } else {
            this.popupDataDialog(message, null, multiples, this.getCategories());
        }
        this.newDataCallBack = null;
        this.replaceNewData = false;
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        super.doRemove();
        if (this.interpreter != null) {
            this.getControlContext().getJythonManager().removeInterpreter(this.interpreter);
            this.interpreter = null;
        }
    }

    private PythonInterpreter getMyInterpreter() throws Exception {
        String code;
        if (this.interpreter == null) {
            this.interpreter = this.getControlContext().getJythonManager().createInterpreter();
        }
        if ((code = this.getJythonCode()) != null) {
            this.interpreter.exec(code);
        }
        return this.interpreter;
    }

    public Displayable getCurrentProbe() {
        if (this.pointProbe != null) {
            return this.pointProbe;
        }
        if (this.levelProbe != null) {
            return this.levelProbe;
        }
        if (this.verticalProbe != null) {
            return this.verticalProbe;
        }
        if (this.transectProbe != null) {
            return this.transectProbe;
        }
        if (this.areaProbe != null) {
            return this.areaProbe;
        }
        return null;
    }

    public Object getProbePosition() throws VisADException, RemoteException {
        if (this.pointProbe != null) {
            return this.pointProbe.getPosition();
        }
        if (this.levelProbe != null) {
            return this.levelProbe.getPosition();
        }
        if (this.verticalProbe != null) {
            return this.verticalProbe.getPosition();
        }
        if (this.transectProbe != null) {
            return this.transectProbe.getPosition();
        }
        if (this.areaProbe != null) {
            return this.areaProbe.getArea();
        }
        return null;
    }

    public void setProbePosition(Object p) {
        this.initPosition = p;
    }

    private void probeMoved() {
        try {
            EarthLocationTuple[] probeLocation = this.getProbeLocation();
            if (probeLocation != null) {
                if (Misc.equals(this.lastProbeLocation, probeLocation)) {
                    return;
                }
                this.lastProbeLocation = probeLocation;
                this.execJython("handleProbe", probeLocation);
            }
        }
        catch (Exception exc) {
            JythonControl.logException("Moving  probe", exc);
        }
    }

    public double[][] getProbeXYZ() throws VisADException, RemoteException {
        Displayable currentProbe = this.getCurrentProbe();
        if (currentProbe == null) {
            return null;
        }
        if (this.pointProbe != null) {
            return this.getPointProbeLocation();
        }
        if (this.areaProbe != null) {
            return this.getAreaProbeLocation();
        }
        if (this.verticalProbe != null) {
            return this.getVerticalProbeLocation();
        }
        if (this.transectProbe != null) {
            return this.getTransectProbeLocation();
        }
        if (this.levelProbe != null) {
            return this.getLevelProbeLocation();
        }
        return null;
    }

    public EarthLocationTuple[] getProbeLocation() throws VisADException, RemoteException {
        Displayable currentProbe = this.getCurrentProbe();
        if (currentProbe == null) {
            return null;
        }
        double[][] data = this.getProbeXYZ();
        if (data == null) {
            return null;
        }
        EarthLocationTuple[] elt = new EarthLocationTuple[data.length];
        for (int i = 0; i < data.length; ++i) {
            elt[i] = this.getELT(data[i][0], data[i][1], data[i][2]);
        }
        return elt;
    }

    private double[] getArray(double x, double y) {
        return this.getArray(x, y, 0.0);
    }

    private double[] getArray(double x, double y, double z) {
        return new double[]{x, y, z};
    }

    private EarthLocationTuple getELT(double x, double y, double z) throws VisADException, RemoteException {
        return (EarthLocationTuple)this.boxToEarth(new double[]{x, y, z});
    }

    private double[][] getPointProbeLocation() throws VisADException, RemoteException {
        double[] values = this.pointProbe.getPosition().getValues();
        return new double[][]{this.getArray(values[0], values[1], values[2])};
    }

    private double[][] getAreaProbeLocation() throws VisADException, RemoteException {
        double[] values = this.areaProbe.getArea().getValues();
        double left = Math.min(values[0], values[2]);
        double right = Math.max(values[0], values[2]);
        double top = Math.max(values[1], values[3]);
        double bottom = Math.min(values[1], values[3]);
        return new double[][]{this.getArray(left, top), this.getArray(right, top), this.getArray(right, bottom), this.getArray(left, bottom)};
    }

    private double[][] getVerticalProbeLocation() throws VisADException, RemoteException {
        double[] data;
        RealTuple position = this.verticalProbe.getPosition();
        RealTupleType rttype = (RealTupleType)position.getType();
        if (rttype.equals(RealTupleType.SpatialCartesian2DTuple)) {
            double[] values = position.getValues();
            data = this.getArray(values[0], values[1]);
        } else if (rttype.equals(RealTupleType.SpatialEarth2DTuple)) {
            Real[] reals = position.getRealComponents();
            data = this.getArray(reals[1].getValue(), reals[0].getValue());
        } else if (rttype.equals(RealTupleType.LatitudeLongitudeTuple)) {
            Real[] reals = position.getRealComponents();
            data = this.getArray(reals[0].getValue(), reals[1].getValue());
        } else {
            throw new VisADException("Can't convert position to navigable point");
        }
        if (data != null) {
            return new double[][]{data};
        }
        return null;
    }

    private double[][] getTransectProbeLocation() throws VisADException, RemoteException {
        RealTuple start = this.transectProbe.getStartPoint();
        RealTuple end = this.transectProbe.getEndPoint();
        double[] v1 = start.getValues();
        double[] v2 = end.getValues();
        return new double[][]{this.getArray(v1[0], v1[1]), this.getArray(v2[0], v2[1])};
    }

    private double[][] getLevelProbeLocation() throws VisADException, RemoteException {
        return new double[][]{this.getArray(0.0, 0.0, this.levelProbe.getPosition().getValue())};
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        super.receiveShareData(from, dataId, data);
    }

    private String getProbeName(String probe) {
        for (int i = 0; i < PROBES.length; ++i) {
            if (!PROBES[i].equals(probe)) continue;
            return PROBE_NAMES[i];
        }
        return "No probe";
    }

    @Override
    public Container doMakeContents() {
        this.jythonContainer = new JPanel(new BorderLayout());
        if (this.developerMode) {
            return this.doMakeDeveloperContents();
        }
        return this.jythonContainer;
    }

    private JComponent doMakeDeveloperContents() {
        this.labelFld = new JTextField(this.myName != null ? this.myName : "", 15);
        this.labelFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JythonControl.this.setMyName(JythonControl.this.labelFld.getText().trim());
            }
        });
        Vector<TwoFacedObject> probeItems = new Vector<TwoFacedObject>();
        for (int i = 0; i < PROBES.length; ++i) {
            probeItems.add(new TwoFacedObject((Object)PROBE_NAMES[i], PROBES[i]));
        }
        final JComboBox probeCbx = new JComboBox(probeItems);
        probeCbx.setSelectedItem(new TwoFacedObject((Object)this.getProbeName(this.probeType), this.probeType));
        probeCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    JythonControl.this.probeType = ((TwoFacedObject)probeCbx.getSelectedItem()).getId().toString();
                    JythonControl.this.doMakeProbe();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Changing probe type", exc);
                }
            }
        });
        this.displayCategoryFld = new JTextField(this.jythonDisplayCategory, 15);
        this.categoriesFld = new JTextArea("", 4, 20);
        if (this.dataCategories != null) {
            this.categoriesFld.setText(this.dataCategories);
        }
        Component[] comps = new Component[]{GuiUtils.rLabel("Display name: "), GuiUtils.left(this.labelFld), GuiUtils.rLabel("Display Category:"), GuiUtils.left(this.displayCategoryFld), GuiUtils.top(GuiUtils.rLabel("Data Categories:")), GuiUtils.left(new JScrollPane(this.categoriesFld)), GuiUtils.rLabel("Probe Type:"), GuiUtils.left(GuiUtils.hflow(Misc.newList(probeCbx, GuiUtils.rLabel("  Probe Color: "), this.doMakeColorControl(this.getColor()))))};
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel fldPanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NYN, GuiUtils.WT_N);
        try {
            if (this.jythonCode == null) {
                this.jythonCode = IOUtil.readContents("/ucar/unidata/idv/control/jythoncontrol.py", "");
            }
            this.jythonEditor = new JPythonEditor();
            this.jythonEditor.setText(this.jythonCode);
            this.jythonEditor.setPreferredSize(new Dimension(400, 300));
        }
        catch (VisADException exc) {
            JythonControl.logException("Creating Jython editor", exc);
        }
        JScrollPane jythonPanel = new JScrollPane(this.jythonEditor);
        JTabbedPane tab = GuiUtils.getNestedTabbedPane();
        tab.add("Settings", GuiUtils.top(fldPanel));
        List buttons = Misc.newList(GuiUtils.makeButton("Evaluate Init", this, "execJython", "handleInit"), GuiUtils.makeButton("Evaluate Data", this, "execJython", "handleData"));
        JPanel buttonPanel = GuiUtils.left(GuiUtils.hbox(buttons));
        tab.add("Jython", GuiUtils.topCenter(buttonPanel, jythonPanel));
        tab.add("Result GUI", this.jythonContainer);
        return tab;
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        if (this.sideLegendHolder == null) {
            this.sideLegendHolder = new JPanel(new BorderLayout());
        }
        return this.sideLegendHolder;
    }

    public void addJythonComponent(Component comp) {
        this.setJythonComponent(comp);
    }

    public void setLegendComponent(Component comp) {
        if (this.sideLegendHolder == null) {
            this.sideLegendHolder = new JPanel(new BorderLayout());
        }
        this.sideLegendHolder.removeAll();
        if (comp != null) {
            this.sideLegendHolder.add("Center", comp);
        }
    }

    public void setJythonComponent(Component comp) {
        this.jythonContainer.removeAll();
        if (comp != null) {
            this.jythonContainer.add("Center", comp);
        }
        this.redoGuiLayout();
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        if (this.developerMode) {
            items.add(GuiUtils.makeMenuItem("Write to Plugin", this, "writeToPlugin"));
        }
        items.addAll(this.saveMenuItems);
        super.getSaveMenuItems(items, forMenuBar);
    }

    @Override
    protected void getFileMenuItems(List items, boolean forMenuBar) {
        items.addAll(this.fileMenuItems);
        super.getFileMenuItems(items, forMenuBar);
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        items.addAll(this.editMenuItems);
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        items.addAll(this.viewMenuItems);
        super.getViewMenuItems(items, forMenuBar);
    }

    private void addMenuItem(List l, String name, String method) {
        l.add(GuiUtils.makeMenuItem(name, this, "execJython", method));
    }

    public void addFileMenuItem(String name, String method) {
        this.addMenuItem(this.fileMenuItems, name, method);
    }

    public void addSaveMenuItem(String name, String method) {
        this.addMenuItem(this.saveMenuItems, name, method);
    }

    public void addViewMenuItem(String name, String method) {
        this.addMenuItem(this.viewMenuItems, name, method);
    }

    public void addEditMenuItem(String name, String method) {
        this.addMenuItem(this.editMenuItems, name, method);
    }

    public void setProbeType(String value) {
        this.probeType = value;
    }

    public String getProbeType() {
        return this.probeType;
    }

    public void setDeveloperMode(boolean value) {
        this.developerMode = value;
    }

    public boolean getDeveloperMode() {
        return this.developerMode;
    }

    public void setMyName(String value) {
        this.myName = value;
    }

    public String getMyName() {
        if (this.labelFld != null) {
            return this.labelFld.getText().trim();
        }
        return this.myName;
    }

    public void setDataCategories(String value) {
        this.dataCategories = value;
    }

    public String getDataCategories() {
        if (this.categoriesFld != null) {
            return this.categoriesFld.getText();
        }
        return this.dataCategories;
    }

    public void setJythonDisplayCategory(String value) {
        this.jythonDisplayCategory = value;
    }

    public String getJythonDisplayCategory() {
        if (this.displayCategoryFld != null) {
            return this.displayCategoryFld.getText();
        }
        return this.jythonDisplayCategory;
    }

    public void setJythonCode(String value) {
        this.jythonCode = value;
    }

    public String getJythonCode() {
        if (this.developerMode) {
            if (this.jythonEditor != null) {
                return this.jythonEditor.getText();
            }
            return null;
        }
        return this.jythonCode;
    }

    public void setJythonCodeURL(String value) {
        this.jythonCodeURL = value;
    }

    public String getJythonCodeURL() {
        return this.jythonCodeURL;
    }
}

