/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Container;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.control.BaseImageControl;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import ucar.visad.display.ImageSequenceDisplayable;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;
import visad.meteorology.ImageSequence;
import visad.meteorology.ImageSequenceManager;
import visad.meteorology.SingleBandedImage;
import visad.meteorology.SingleBandedImageImpl;
import visad.util.DataUtility;

public class ImageSequenceControl
extends BaseImageControl {
    private ImageSequenceDisplayable sequenceDisplay;
    private ImageSequenceManager sequenceManager;
    private DataChoice choice;
    private JProgressBar progressBar;
    private JPanel progressPanel;
    private boolean keepRunning;
    private static int nextId = 0;
    private int myId;
    private static Object INSTANCE_MUTEX = new Object();
    private FieldImpl workingSequence;
    private boolean showProgressBar = true;
    private Unit myUnit;
    private boolean sequenceDisplayAdded = false;
    private boolean loadingFromBundle = false;

    public ImageSequenceControl() {
        this.setAttributeFlags(6312);
    }

    @Override
    public boolean init(DataChoice choice) throws VisADException, RemoteException {
        return this.init(choice, true);
    }

    protected boolean init(DataChoice choice, boolean doLoad) throws VisADException, RemoteException {
        if (!this.setData(choice)) {
            return false;
        }
        this.doMakeWindow();
        this.choice = choice;
        this.sequenceManager = new ImageSequenceManager();
        this.sequenceDisplay = new ImageSequenceDisplayable("Images", null, this.getInitialColorTable().getAlphaTable());
        this.sequenceDisplay.setTextureEnable(true);
        this.sequenceDisplay.setCurvedSize(this.getTextureQuality());
        if (EMPTY_IMAGE != null) {
            this.sequenceDisplay.loadData(EMPTY_IMAGE);
        }
        if (!this.getDisplayVisibility()) {
            this.sequenceDisplay.setVisible(false);
        }
        this.addAttributedDisplayable(this.sequenceDisplay, 168);
        if (this.sequenceDisplay.hasData()) {
            this.addDisplayable(this.sequenceDisplay);
            this.sequenceDisplayAdded = true;
        }
        this.loadingFromBundle = this.getIdv().getStateManager().getProperty("idv.loadingxml", false);
        if (doLoad) {
            this.showWaitCursor();
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    try {
                        ImageSequenceControl.this.loadData();
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("Loading data", exc);
                    }
                    ImageSequenceControl.this.showNormalCursor();
                }
            });
        }
        return true;
    }

    @Override
    protected void applyTextureQuality() throws VisADException, RemoteException {
        if (this.sequenceDisplay != null) {
            this.sequenceDisplay.setCurvedSize(this.getTextureQuality());
        }
    }

    @Override
    protected ColorTable getInitialColorTable() {
        ColorTable colorTable = super.getInitialColorTable();
        if (colorTable.getName().equalsIgnoreCase("default")) {
            colorTable = this.getDisplayConventions().getParamColorTable("image");
        }
        return colorTable;
    }

    @Override
    public Unit getDisplayUnit() {
        Unit unit = super.getDisplayUnit();
        if (unit == null) {
            unit = this.getDisplayUnit(this.myUnit);
            this.setDisplayUnit(unit);
        }
        return unit;
    }

    @Override
    public void initDone() {
        super.initDone();
    }

    @Override
    protected Container doMakeContents() {
        JButton cancelButton = GuiUtils.makeImageButton("/auxdata/ui/icons/Exit16.gif", this, "cancelPressed");
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setString("Selected images not available");
        this.progressBar.setStringPainted(true);
        this.progressPanel = GuiUtils.leftCenter(cancelButton, this.progressBar);
        return this.getShowProgressBar() ? GuiUtils.topCenter(this.progressPanel, this.doMakeWidgetComponent()) : this.doMakeWidgetComponent();
    }

    public void cancelPressed() {
        this.keepRunning = false;
    }

    @Override
    protected Range getInitialRange() throws RemoteException, VisADException {
        Range range = this.getDisplayConventions().getParamRange(this.paramName, this.getDisplayUnit());
        if (range == null && (range = this.getRangeFromColorTable()) != null && range.getMin() == range.getMax()) {
            range = null;
        }
        if (range == null) {
            range = this.getDisplayConventions().getParamRange("image", this.getDisplayUnit());
        }
        if (range == null) {
            return new Range(0.0, 255.0);
        }
        return range;
    }

    @Override
    protected boolean checkIfDataOk(DataInstance di) throws VisADException, RemoteException {
        return true;
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        super.resetData();
        this.loadData(false);
    }

    private void loadData() {
        this.loadData(true);
    }

    private void loadData(boolean firsttime) {
        Trace.call1("ImageControl.loadData");
        try {
            this.loadDataInner(firsttime);
        }
        catch (Exception exc) {
            ImageSequenceControl.logException("Loading image data", exc);
            try {
                this.doRemove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.call2("ImageControl.loadData");
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        return new GridDataInstance(dataChoice, this.getDataSelection(), this.getRequestProperties(), EMPTY_IMAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataInner(boolean firsttime) {
        if (firsttime) {
            Object object = INSTANCE_MUTEX;
            synchronized (object) {
                this.myId = nextId++;
            }
        }
        this.keepRunning = true;
        boolean hasComposite = this.choice instanceof CompositeDataChoice;
        boolean hasUserSelection = false;
        List choices = hasComposite ? ((CompositeDataChoice)this.choice).getDataChoices() : Misc.newList(this.choice);
        List selectionTimes = this.getDataSelection().getTimes();
        if (selectionTimes != null) {
            hasUserSelection = true;
        }
        if (selectionTimes == null) {
            selectionTimes = this.choice.getSelectedDateTimes();
        }
        DataSelection selectionToUse = null;
        selectionToUse = hasComposite ? new DataSelection(Misc.newList(new Integer(0))) : new DataSelection(this.getDataSelection());
        if (selectionTimes != null) {
            selectionTimes = TwoFacedObject.getIdList(selectionTimes);
        }
        int numImages = 1;
        if (selectionTimes != null && selectionTimes.size() > 0) {
            numImages = selectionTimes.size();
        } else if (this.choice instanceof CompositeDataChoice) {
            numImages = ((CompositeDataChoice)this.choice).getNumChildren();
        }
        this.sequenceManager.clearSequence();
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(numImages);
        int displayedCnt = 1;
        FunctionType newType = null;
        ImageSequence sequence = null;
        boolean loadedOnlyOne = false;
        boolean haveSetImageSequence = false;
        for (int dataChoiceIdx = 0; dataChoiceIdx < choices.size(); ++dataChoiceIdx) {
            if (!this.keepRunning) {
                this.progressBar.setValue(0);
                this.progressBar.setString("Loading cancelled");
                break;
            }
            try {
                if (!this.getActive()) {
                    return;
                }
                DataChoice dataChoice = (DataChoice)choices.get(dataChoiceIdx);
                if (hasComposite && selectionTimes != null && selectionTimes.size() > 0 && selectionTimes.indexOf(new Integer(dataChoiceIdx)) == -1) continue;
                this.progressBar.setString("Loading " + displayedCnt + " of " + numImages + " images");
                Data theData = null;
                Trace.call1("ImageControl.getData");
                try {
                    theData = dataChoice.getData(selectionToUse, this.getRequestProperties());
                }
                catch (VisADException ve) {
                    System.out.println(ve);
                }
                Trace.call2("ImageControl.getData");
                if (theData == null) continue;
                if (!this.getActive()) {
                    return;
                }
                SingleBandedImage image = (SingleBandedImage)theData;
                if (displayedCnt == 1) {
                    FunctionType imageType = (FunctionType)image.getType();
                    RealType rangeType = (RealType)imageType.getFlatRange().getComponent(0);
                    this.myUnit = DataUtility.getRangeUnits((FlatField)((Object)image))[0];
                    this.setDisplayUnit(this.myUnit);
                    newType = new FunctionType(imageType.getDomain(), new RealTupleType(DataUtil.makeRealType(rangeType.getName() + "_Sequence_" + this.myId, rangeType.getDefaultUnit())));
                }
                Trace.call1("ImageControl-changeMathType");
                image = new SingleBandedImageImpl((FlatField)Util.clone(image, newType, false, false), image.getStartTime(), image.getDescription(), false);
                Trace.call2("ImageControl-changeMathType");
                sequence = this.sequenceManager.addImageToSequence(image);
                this.progressBar.setValue(displayedCnt);
                this.progressBar.setString("Loaded " + displayedCnt + " of " + numImages + " images");
                if (displayedCnt == 1) {
                    this.checkImageSize((FieldImpl)((Object)image));
                    this.setDisplayInactive();
                    this.getDataInstance().setTheData(theData);
                    Trace.call1("ImageControl-addingDisplayable");
                    if (!this.sequenceDisplayAdded) {
                        if (firsttime) {
                            this.sequenceDisplay.setImageSequence(this.getWorkingSequence((FieldImpl)((Object)sequence)));
                            haveSetImageSequence = true;
                        }
                        this.addDisplayable(this.sequenceDisplay);
                    } else if (firsttime) {
                        MapProjection mp = GridUtil.getNavigation((FieldImpl)((Object)sequence));
                        MapViewManager mvm = this.getMapViewManager();
                        if (mp != null && mvm != null && !this.loadingFromBundle) {
                            mvm.setMapProjection(mp, true, this.getDisplayConventions().getMapProjectionLabel(mp, this), true);
                        }
                        this.sequenceDisplay.setImageSequence(this.getWorkingSequence((FieldImpl)((Object)sequence)));
                        haveSetImageSequence = true;
                    }
                    this.updateLegendAndList();
                    Trace.call2("ImageControl-addingDisplayable");
                    loadedOnlyOne = true;
                    this.setDisplayActive();
                } else {
                    loadedOnlyOne = false;
                }
                ++displayedCnt;
                continue;
            }
            catch (DataCancelException dce) {
                try {
                    this.doRemove();
                }
                catch (Exception exc) {
                    ImageSequenceControl.logException("Calling doRemove", exc);
                }
                return;
            }
            catch (Exception e) {
                ImageSequenceControl.logException("Creating image sequence", e);
                this.displayControlFailed();
                return;
            }
        }
        if (sequence != null) {
            if (!haveSetImageSequence) {
                try {
                    this.sequenceDisplay.setImageSequence(this.getWorkingSequence((FieldImpl)((Object)sequence)));
                }
                catch (Exception e) {
                    ImageSequenceControl.logException("Creating image sequence", e);
                }
            }
            try {
                this.workingSequence = (FieldImpl)((Object)sequence);
                if (!loadedOnlyOne) {
                    this.sequenceDisplay.setImageSequence(this.getWorkingSequence((FieldImpl)((Object)sequence)));
                }
                if (this.getSkipValue() != 0) {
                    this.applySkipFactor();
                }
                this.skipSlider.setEnabled(true);
            }
            catch (Exception e) {
                ImageSequenceControl.logException("Loading image sequence", e);
                this.displayControlFailed();
            }
            this.updateLegendAndList();
            this.notifyViewManagersOfChange();
        } else {
            ImageSequenceControl.userMessage("Selected image(s) not available");
        }
        this.keepRunning = false;
        if (this.progressPanel.getParent() != null && this.getShowProgressBar()) {
            Container parent = this.progressPanel.getParent();
            parent.remove(this.progressPanel);
            parent.repaint();
            parent.validate();
        }
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        super.doRemove();
        if (this.sequenceManager != null) {
            this.sequenceManager.clearSequence();
        }
        this.sequenceManager = null;
        this.workingSequence = null;
    }

    protected void setWorkingSequence(FieldImpl sequence) throws VisADException, RemoteException {
        this.workingSequence = sequence;
        this.sequenceDisplay.setImageSequence(this.workingSequence);
    }

    private FieldImpl getWorkingSequence(FieldImpl sequence) throws VisADException {
        if (this.getSkipValue() <= 0) {
            return sequence;
        }
        return GridUtil.subset((FieldImpl)((Object)this.sequenceManager.getImageSequence()), this.getSkipValue() + 1);
    }

    @Override
    protected void applySkipFactor() {
        if (this.sequenceManager.getImageSequence() == null) {
            return;
        }
        try {
            this.setWorkingSequence(GridUtil.subset((FieldImpl)((Object)this.sequenceManager.getImageSequence()), this.getSkipValue() + 1));
        }
        catch (Exception ve) {
            ImageSequenceControl.logException("applySkipFactor", ve);
        }
    }

    @Override
    public Range getColorRangeFromData() {
        try {
            if (this.sequenceDisplay != null && this.sequenceDisplay.getData() != null) {
                return this.convertColorRange(GridUtil.getMinMax((FieldImpl)this.sequenceDisplay.getData())[0], this.myUnit);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void setAlphaFromSlider(float newAlpha) {
        try {
            super.setAlphaFromSlider(newAlpha);
        }
        catch (Exception e) {
            ImageSequenceControl.logException("Setting alpha value", e);
        }
    }

    public void setShowProgressBar(boolean value) {
        this.showProgressBar = value;
    }

    public boolean getShowProgressBar() {
        return this.showProgressBar;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }
}

