/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.idv.control.McVHistogramWrapper;
import ucar.unidata.idv.control.PlanViewControl;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.VisADException;
import visad.meteorology.ImageSequenceImpl;

public class ImagePlanViewControl
extends PlanViewControl {
    public List descripters;
    private McVHistogramWrapper histoWrapper;
    private FlatField image;
    private DataSourceImpl dataSource;

    public ImagePlanViewControl() {
        this.setAttributeFlags(6184);
    }

    private void setInitialHistogramRange() {
        try {
            Range range = this.getRange();
            double lo = range.getMin();
            double hi = range.getMax();
            this.histoWrapper.setHigh(hi);
            this.histoWrapper.setLow(lo);
        }
        catch (Exception exc) {
            ImagePlanViewControl.logException("setInitialHistogramRange", exc);
        }
    }

    @Override
    public Container doMakeContents() {
        try {
            MyTabbedPane tab = new MyTabbedPane();
            tab.add("Settings", GuiUtils.inset((Component)GuiUtils.top(this.doMakeWidgetComponent()), 5));
            if (!(this.datachoice instanceof DerivedDataChoice)) {
                tab.add("Histogram", this.getHistogramTabComponent());
            }
            return tab;
        }
        catch (Exception exc) {
            ImagePlanViewControl.logException("doMakeContents", exc);
            return null;
        }
    }

    protected JComponent getHistogramTabComponent() {
        ArrayList<DataChoice> choices = new ArrayList<DataChoice>();
        if (this.datachoice == null) {
            this.datachoice = this.getDataChoice();
        }
        choices.add(this.datachoice);
        this.histoWrapper = new McVHistogramWrapper("histo", choices, this);
        this.dataSource = this.getDataSource();
        if (this.dataSource == null) {
            try {
                this.image = (FlatField)this.datachoice.getData(this.getDataSelection());
                this.histoWrapper.loadData(this.image);
            }
            catch (IllegalArgumentException e) {
                ImagePlanViewControl.logException("Could not create histogram: nothing to show!", e);
            }
            catch (RemoteException | VisADException e) {
                ImagePlanViewControl.logException("Could not create histogram!", e);
            }
        } else {
            Hashtable props = this.dataSource.getProperties();
            try {
                DataSelection testSelection = this.datachoice.getDataSelection();
                DataSelection realSelection = this.getDataSelection();
                if (testSelection == null) {
                    this.datachoice.setDataSelection(realSelection);
                }
                ImageSequenceImpl seq = null;
                if (this.dataSelection == null) {
                    this.dataSelection = this.dataSource.getDataSelection();
                }
                if (this.dataSelection == null) {
                    this.image = (FlatField)this.dataSource.getData(this.datachoice, null, props);
                    if (this.image == null) {
                        this.image = (FlatField)this.datachoice.getData(null);
                    }
                } else {
                    Data data = this.dataSource.getData(this.datachoice, null, this.dataSelection, props);
                    if (data instanceof ImageSequenceImpl) {
                        seq = (ImageSequenceImpl)data;
                    } else if (data instanceof FlatField) {
                        this.image = (FlatField)data;
                    } else if (data instanceof FieldImpl) {
                        this.image = (FlatField)((FieldImpl)data).getSample(0, false);
                    } else {
                        throw new Exception("Histogram must be made from a FlatField");
                    }
                }
                if (seq != null && seq.getImageCount() > 0) {
                    this.image = (FlatField)((Object)seq.getImage(0));
                }
                try {
                    this.histoWrapper.loadData(this.image);
                }
                catch (IllegalArgumentException e) {
                    ImagePlanViewControl.logException("Could not create histogram: nothing to show!", e);
                }
            }
            catch (Exception e) {
                ImagePlanViewControl.logException("attempting to set up histogram", e);
            }
        }
        JComponent histoComp = this.histoWrapper.doMakeContents();
        JButton resetButton = new JButton("Update");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImagePlanViewControl.this.getIdv().showWaitCursor();
                ImagePlanViewControl.this.updateHistogramPanel();
                ImagePlanViewControl.this.setInitialHistogramRange();
                ImagePlanViewControl.this.getIdv().clearWaitCursor();
            }
        });
        JPanel resetPanel = GuiUtils.center(GuiUtils.inset((Component)GuiUtils.wrap(resetButton), 4));
        return GuiUtils.centerBottom(histoComp, resetPanel);
    }

    public void updateHistogramPanel() {
        Hashtable props = this.dataSource.getProperties();
        try {
            DataSelection testSelection = this.datachoice.getDataSelection();
            DataSelection realSelection = this.getDataSelection();
            if (testSelection == null) {
                this.datachoice.setDataSelection(realSelection);
            }
            ImageSequenceImpl seq = null;
            if (this.dataSelection == null) {
                this.dataSelection = this.dataSource.getDataSelection();
            }
            if (this.dataSelection == null) {
                this.image = (FlatField)this.dataSource.getData(this.datachoice, null, props);
                if (this.image == null) {
                    this.image = (FlatField)this.datachoice.getData(null);
                }
            } else {
                Data data = this.dataSource.getData(this.datachoice, null, this.dataSelection, props);
                if (data instanceof ImageSequenceImpl) {
                    seq = (ImageSequenceImpl)data;
                } else if (data instanceof FlatField) {
                    this.image = (FlatField)data;
                } else if (data instanceof FieldImpl) {
                    this.image = (FlatField)((FieldImpl)data).getSample(0, false);
                } else {
                    throw new Exception("Histogram must be made from a FlatField");
                }
            }
            if (seq != null && seq.getImageCount() > 0) {
                this.image = (FlatField)((Object)seq.getImage(0));
            }
            try {
                this.histoWrapper.loadData(this.image);
            }
            catch (IllegalArgumentException e) {
                ImagePlanViewControl.logException("Could not create histogram: nothing to show!", e);
            }
        }
        catch (Exception e) {
            ImagePlanViewControl.logException("attempting to set up histogram", e);
        }
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Save Chart Image...", this.getChart(), "saveImage"));
    }

    public McVHistogramWrapper getChart() {
        if (this.histoWrapper == null) {
            this.getHistogramTabComponent();
            this.setInitialHistogramRange();
        }
        return this.histoWrapper;
    }

    @Override
    public void setRange(Range newRange) throws RemoteException, VisADException {
        super.setRange(newRange);
        if (this.histoWrapper != null) {
            this.histoWrapper.modifyRange(newRange.getMin(), newRange.getMax(), false);
        }
    }

    @Override
    protected DisplayableData createPlanDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable gridDisplay = new Grid2DDisplayable("ImagePlanViewControl_" + (this.datachoice != null ? this.datachoice.toString() : ""), true);
        gridDisplay.setTextureEnable(true);
        gridDisplay.setCurvedSize(this.getTextureQuality());
        this.addAttributedDisplayable(gridDisplay);
        return gridDisplay;
    }

    @Override
    protected void applyTextureQuality() throws VisADException, RemoteException {
        if (this.getGridDisplay() != null) {
            this.getGridDisplay().setCurvedSize(this.getTextureQuality());
        }
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        boolean fromBundle = this.getIdv().getStateManager().getProperty("idv.loadingxml", false);
        if (fromBundle) {
            String magStr;
            boolean mdr = this.getMatchDisplayRegion();
            dataChoice.setProperty("MatchDisplayRegion", mdr);
            boolean result = super.setData(dataChoice);
            if (!result) {
                ImagePlanViewControl.userMessage("Selected image(s) not available");
            }
            if ((magStr = (String)dataChoice.getProperty("MAG")) != null && !magStr.isEmpty()) {
                this.resolutionReadout = magStr;
            }
            return result;
        }
        boolean hasCorner = this.dataSelection.getProperty("Region_Selection_Has_Conner", false);
        boolean result = super.setData(dataChoice);
        if (!result) {
            if (hasCorner) {
                ImagePlanViewControl.userMessage("Selected region bounding box is not big enough");
            } else {
                ImagePlanViewControl.userMessage("Selected image(s) not available");
            }
        }
        return result;
    }

    @Override
    protected ColorTable getInitialColorTable() {
        ColorTable colorTable = super.getInitialColorTable();
        if (colorTable.getName().equalsIgnoreCase("default")) {
            colorTable = this.getDisplayConventions().getParamColorTable("image");
        }
        return colorTable;
    }

    Grid2DDisplayable getGridDisplay() {
        return (Grid2DDisplayable)this.getPlanDisplay();
    }

    public boolean getAllowSmoothing() {
        return false;
    }

    @Override
    protected Range getInitialRange() throws RemoteException, VisADException {
        Range dataRange;
        Range range = this.getDisplayConventions().getParamRange(this.paramName, this.getDisplayUnit());
        if (range == null && (range = this.getRangeFromColorTable()) != null && range.getMin() == range.getMax()) {
            range = null;
        }
        boolean usingImage = false;
        Range imageRange = this.getDisplayConventions().getParamRange("image", this.getDisplayUnit());
        if (range != null && Misc.equals(range, imageRange)) {
            usingImage = true;
        }
        if (range != null && usingImage && this.getGridDataInstance() != null && (dataRange = this.getDataRangeInColorUnits()) != null && (range.getMin() > dataRange.getMin() || range.getMax() < dataRange.getMax())) {
            range = dataRange;
        }
        if (range == null) {
            range = super.getInitialRange();
        }
        return range;
    }

    @Override
    protected FieldImpl getSliceForDisplay(FieldImpl slice) throws VisADException {
        this.checkImageSize(slice);
        return super.getSliceForDisplay(slice);
    }

    @Override
    public String getSkipWidgetLabel() {
        return "Pixel Sampling";
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Native Image Projection";
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    public void setDescripters(List descripters) {
        this.descripters = descripters;
    }

    public List getDescripters() {
        return this.descripters;
    }

    public DataSourceImpl getDataSource() {
        DataSourceImpl ds = null;
        List dataSources = this.getDataSources();
        if (!dataSources.isEmpty()) {
            ds = (DataSourceImpl)dataSources.get(0);
        }
        return ds;
    }

    public void resetColorTable() {
        try {
            this.revertToDefaultColorTable();
            this.revertToDefaultRange();
            this.histoWrapper.resetPlot();
        }
        catch (Exception e) {
            ImagePlanViewControl.logException("problem resetting color table", e);
        }
    }

    private class MyTabbedPane
    extends JTabbedPane
    implements ChangeListener {
        boolean painted = false;
        boolean popupFlag = false;
        boolean haveDoneHistogramInit = false;

        public MyTabbedPane() {
            this.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int index = this.getSelectedIndex();
            if (index >= 0 && this.getTitleAt(index).equals("Histogram") && !this.haveDoneHistogramInit) {
                ImagePlanViewControl.this.getIdv().showWaitCursor();
                this.setComponentAt(index, GuiUtils.inset((Component)ImagePlanViewControl.this.getHistogramTabComponent(), 5));
                ImagePlanViewControl.this.setInitialHistogramRange();
                ImagePlanViewControl.this.getIdv().clearWaitCursor();
            }
        }

        private void setPopupFlag(boolean flag) {
            this.popupFlag = flag;
        }

        @Override
        public void paint(Graphics g) {
            if (!this.painted) {
                this.painted = true;
            }
            super.paint(g);
        }
    }
}

