/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.gis.mcidasmap.McidasMap;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.ui.ImagePanel;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.XmlTree;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.view.station.StationLocationMap;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.UtcDate;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.Displayable;
import ucar.visad.display.ImageRGBDisplayable;
import ucar.visad.display.IndicatorPoint;
import ucar.visad.display.PickableLineDrawing;
import visad.ActionImpl;
import visad.CommonUnit;
import visad.DateTime;
import visad.Display;
import visad.FlatField;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonTuple;

public class ImageMovieControl
extends DisplayControlImpl {
    public static final String TAG_IMAGESET = "imageset";
    public static final String TAG_IMAGES = "images";
    public static final String TAG_IMAGESETS = "imagesets";
    public static final String TAG_IMAGE = "image";
    public static final String ATTR_BASE = "base";
    public static final String ATTR_DESC = "desc";
    public static final String ATTR_LAT = "lat";
    public static final String ATTR_LON = "lon";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_GROUP = "group";
    public static final String ATTR_ROOT = "root";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_TIME = "time";
    public static final String ATTR_INDEX = "index";
    private static final int DATETYPE_INDEX = 0;
    private static final int DATETYPE_FILENAME = 1;
    private ImageRGBDisplayable imageDisplay;
    private visad.georef.LatLonPoint imageLocation = null;
    private boolean showImageInDisplay = false;
    private int dateType = 1;
    private String imageSetUrl;
    private Element imageSetRoot;
    private boolean doImageSet = true;
    private boolean doImageSetResources = true;
    private JTabbedPane tabbedPane;
    private XmlTree imageSetsTree;
    private JList fileList;
    private visad.georef.LatLonPoint[] latLons = null;
    private boolean enabled = true;
    private boolean ignoreEvents = false;
    private JCheckBox enabledCbx;
    private String dateFormat = "yyyy_MM_dd_HH_mm_ss_Z";
    private String datePattern = "image_(.*)_\\d*.jpg";
    private JRadioButton indexBtn;
    private JTextField formatFld;
    private JTextField patternFld;
    private JTextField dirFld;
    private List times;
    private Hashtable<String, NamedStationImpl> idToStation = new Hashtable();
    private Hashtable<NamedStationImpl, Element> stationToElement = new Hashtable();
    private Hashtable<Element, NamedStationImpl> elementToStation = new Hashtable();
    private Hashtable<String, Element> urlToRoot = new Hashtable();
    private StationLocationMap stationMap;
    private List<NamedStationImpl> stations;
    private String directory;
    private JLabel descLabel = new JLabel(" ");
    private ImagePanel imagePanel;
    private ImagePanel previewPanel;
    private JCheckBox previewCbx;
    private Element lastPreviewNode;
    private int pointIndex = -1;
    private IndicatorPoint selectedPoint;
    private PickableLineDrawing locations;
    private List pointNodes = new ArrayList();
    private boolean justOneFile = false;
    private Element imageSetsRoot;
    private List extraCollections = new ArrayList();
    private Hashtable haveSeen = new Hashtable();
    private float alpha = 1.0f;
    private float lastScale = Float.NaN;
    Image lastDataImage;
    private visad.georef.LatLonPoint lastImageLocation = null;
    private String tocFiles;

    public ColorTable getRGBColorTable() {
        return this.getDisplayConventions().getParamColorTable(TAG_IMAGE);
    }

    @Override
    protected List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        Element element;
        String url;
        List[] files;
        NamedStationImpl closest = null;
        double minDistance = 0.0;
        LatLonPointImpl llp = new LatLonPointImpl(el.getLatitude().getValue(CommonUnit.degree), el.getLongitude().getValue(CommonUnit.degree));
        if (this.stations == null) {
            return null;
        }
        for (NamedStationImpl station : this.stations) {
            EarthLocation el2 = station.getEarthLocation();
            LatLonPointImpl llp2 = new LatLonPointImpl(el2.getLatitude().getValue(CommonUnit.degree), el2.getLongitude().getValue(CommonUnit.degree));
            Bearing bearing = Bearing.calculateBearing(llp, (LatLonPoint)llp2, null);
            double distance = bearing.getDistance();
            if (closest != null && !(distance < minDistance)) continue;
            minDistance = distance;
            closest = station;
        }
        if (closest != null && (files = this.loadFilesFromXml(url = this.getImageSetUrl(element = this.stationToElement.get(closest)), null))[0].size() > 0) {
            ReadoutInfo info = new ReadoutInfo(this, null, closest.getEarthLocation(), (DateTime)files[1].get(files[1].size() - 1));
            info.setImageUrl(files[0].get(files[0].size() - 1).toString());
            info.setImageName(closest.getName());
            samples.add(info);
        }
        return null;
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        super.init(dataChoice);
        this.imageDisplay = new ImageRGBDisplayable("ImageDisplayable");
        ColorTable colorTable = this.getRGBColorTable();
        this.imageDisplay.setRangeForColor(0.0, 255.0);
        this.imageDisplay.setColorPalette(colorTable.getTable());
        if ((double)this.getAlpha() != 1.0) {
            this.imageDisplay.setAlpha(this.getAlpha());
        }
        this.addDisplayable(this.imageDisplay);
        this.locations = new PickableLineDrawing("ImageMoviePoint");
        this.selectedPoint = new IndicatorPoint("Selected Point", RealTupleType.LatitudeLongitudeTuple);
        this.setPointSize();
        this.stationMap = new StationLocationMap(false);
        this.stationMap.addPropertyChangeListener("selectedStation", this);
        McidasMap mmr = new McidasMap("/auxdata/maps/OUTLUSAM");
        mmr.setColor(Color.blue);
        this.stationMap.setMapRenderer(mmr);
        LambertConformal proj = new LambertConformal(40.0, -100.0, 60.0, 20.0);
        ProjectionRect rect = new ProjectionRect(-2000.0, -1800.0, 2500.0, 1800.0);
        proj.setDefaultMapArea(rect);
        this.stationMap.setProjectionImpl(proj);
        this.imageSetsTree = new XmlTree(this.getImageSetsRoot(), true){

            @Override
            public void doDoubleClick(XmlTree theTree, Element node) {
                if (node.getTagName().equals(ImageMovieControl.TAG_IMAGESET)) {
                    ImageMovieControl.this.selectImageSet(node);
                    GuiUtils.showComponentInTabs(ImageMovieControl.this.tabbedPane);
                }
            }

            @Override
            public void doClick(XmlTree theTree, Element node) {
                NamedStationImpl station = (NamedStationImpl)ImageMovieControl.this.elementToStation.get(node);
                if (station != null && ImageMovieControl.this.stationMap != null) {
                    ImageMovieControl.this.stationMap.setSelectedStations(Misc.newList(station));
                }
                ImageMovieControl.this.doPreview(node);
            }
        };
        this.times = new ArrayList();
        if (dataChoice != null) {
            String path = dataChoice.getStringId();
            if (!this.extraCollections.contains(path)) {
                this.importImageSet(path);
            }
            if (this.imageSetRoot != null) {
                this.justOneFile = true;
                return true;
            }
            this.doImageSetResources = false;
        }
        if (!this.doImageSet) {
            File dir;
            if (this.directory == null && (dir = FileManager.getDirectory(this.directory, "Please select a directory")) != null) {
                this.directory = dir.toString();
            }
            if (this.directory == null) {
                return false;
            }
        } else {
            this.loadFilesFromXml();
        }
        return true;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Transparency:"), this.doMakeAlphaSlider()));
    }

    @Override
    protected void getFileMenuItems(List items, boolean forMenuBar) {
        super.getFileMenuItems(items, forMenuBar);
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Import Image Set From File", this, "importImageSetFromFile"));
        items.add(GuiUtils.makeMenuItem("Import Image Set From URL", this, "importImageSetFromURL"));
    }

    public void importImageSet(String path) {
        if (path == null) {
            return;
        }
        if (this.haveSeen.get(path = path.trim()) != null) {
            return;
        }
        try {
            Element root = this.getRoot(path);
            if (root == null) {
                LogUtil.userErrorMessage("Could not load the image set xml: " + path);
                return;
            }
            if (root.getTagName().equals(TAG_IMAGES)) {
                this.pointIndex = -1;
                this.imageSetRoot = root;
                this.imageSetUrl = path;
                this.reloadFiles();
                if (this.tabbedPane != null) {
                    this.tabbedPane.setSelectedIndex(0);
                }
            } else if (root.getTagName().equals(TAG_IMAGESETS)) {
                this.haveSeen.put(path, path);
                if (this.extraCollections.contains(path)) {
                    LogUtil.userMessage("This image set is already loaded");
                } else {
                    this.extraCollections.add(path);
                    this.appendImageSetXml(root);
                    this.loadImageSetsMap();
                    this.imageSetsTree.loadTree();
                }
            } else {
                LogUtil.userErrorMessage("Unknown XML root:" + root.getTagName());
            }
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Error loading image set xml", exc);
        }
    }

    public void importImageSetFromFile() {
        this.importImageSet(FileManager.getReadFile(FileManager.FILTER_XML));
    }

    public void importImageSetFromURL() {
        this.importImageSet(GuiUtils.getInput("Enter a URL to an image set xml file", "URL: ", ""));
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    public void viewpointChanged() {
        try {
            super.viewpointChanged();
            float scale = this.getDisplayScale();
            if (scale == this.lastScale) {
                return;
            }
            this.lastScale = scale;
            if (this.lastDataImage != null) {
                this.lastDataImage = null;
                this.lastImageLocation = null;
                this.loadImage(this.getImagePanel().getImage());
            }
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Handling viewpoint changed", exc);
        }
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.makeCheckboxMenuItem("Show image in display", this, "showImageInDisplay", null));
        super.getViewMenuItems(items, forMenuBar);
    }

    protected JComponent doMakeAlphaSlider() {
        JSlider alphaSlider = GuiUtils.makeSlider(0, 100, 100 - (int)(this.getAlpha() * 100.0f), this, "setInverseAlphaFromSlider");
        JPanel transLabel = GuiUtils.leftRight(GuiUtils.lLabel("0%"), GuiUtils.rLabel("100%"));
        return GuiUtils.vbox(alphaSlider, transLabel);
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    protected void setAlphaFromSlider(float newAlpha) {
        try {
            this.alpha = newAlpha;
            if (this.imageDisplay != null) {
                this.imageDisplay.setAlpha(newAlpha);
            }
        }
        catch (Exception e) {
            ImageMovieControl.logException("Setting alpha value", e);
        }
    }

    public void setInverseAlphaFromSlider(int sliderValue) {
        sliderValue = 100 - sliderValue;
        this.setAlphaFromSlider((float)((double)sliderValue / 100.0));
    }

    private void loadImage(Image image) {
        try {
            if (image == null || this.getImageLocation() == null || !this.showImageInDisplay) {
                this.lastDataImage = null;
                this.lastImageLocation = null;
                this.imageDisplay.setVisible(false);
                return;
            }
            if (this.lastImageLocation == this.getImageLocation()) {
                this.lastDataImage = null;
                this.lastImageLocation = null;
                this.imageDisplay.setVisible(false);
                return;
            }
            this.lastDataImage = image;
            this.imageDisplay.setVisible(this.getDisplayVisibility());
            image = ImageUtils.resize(image, 150, -1);
            FlatField imageData = Util.makeField(image, true);
            Linear2DSet imageDomain = (Linear2DSet)imageData.getDomainSet();
            this.lastImageLocation = this.getImageLocation();
            int[] screen = this.earthToScreen(new EarthLocationTuple(this.getImageLocation(), new Real(RealType.Altitude, 0.0)));
            int width = imageDomain.getX().getLength();
            int height = imageDomain.getY().getLength();
            int left = screen[0];
            int right = screen[0] + width;
            int top = screen[1];
            int bottom = screen[1] + height;
            double[] origin = this.screenToBox(left, top);
            double[] lr = this.screenToBox(right, bottom);
            Linear2DSet domain = new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float)origin[0], (float)lr[0], imageDomain.getX().getLength(), (float)origin[1], (float)lr[1], imageDomain.getY().getLength());
            FlatField newImageData = (FlatField)GridUtil.setSpatialDomain(imageData, domain);
            this.imageDisplay.loadData(newImageData);
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Making image data", exc);
        }
    }

    private void setImageForTime() {
        this.getImagePanel().setSelectedFile(this.getImagePanel().getCurrentIndex());
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.enabledCbx = GuiUtils.makeCheckbox("Enabled", this, "enabled");
        this.tabbedPane = new JTabbedPane();
        this.previewCbx = new JCheckBox("Preview", false);
        this.previewCbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ImageMovieControl.this.doPreview(ImageMovieControl.this.lastPreviewNode);
            }
        });
        this.previewPanel = new ImagePanel();
        JComponent animContents = this.getAnimationWidget().getContents();
        JPanel topPanel = GuiUtils.left(animContents);
        JPanel moviePanel = GuiUtils.topCenterBottom(topPanel, this.getImagePanel(), GuiUtils.left(this.descLabel));
        this.fileList = new JList();
        this.addMoviesToList();
        this.patternFld = new JTextField(this.datePattern, 40);
        this.formatFld = new JTextField(this.dateFormat, 40);
        this.indexBtn = new JRadioButton("Use animation index in list", this.dateType == 0);
        GuiUtils.addActionListener(this.indexBtn, this, "dateTypeButtonPressed", new Integer(0));
        JRadioButton nameBtn = new JRadioButton("Extract from filename", this.dateType == 1);
        GuiUtils.addActionListener(this.indexBtn, this, "dateTypeButtonPressed", new Integer(1));
        GuiUtils.buttonGroup(this.indexBtn, nameBtn);
        this.patternFld.setToolTipText("Use this to extract the date string from the file name");
        this.formatFld.setToolTipText("Use this to extract the date from the date string");
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel fields = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Date pattern:"), this.patternFld, GuiUtils.rLabel("Date format:"), this.formatFld}, 2, GuiUtils.WT_NYN, GuiUtils.WT_N);
        JPanel namePanel = GuiUtils.vbox(nameBtn, GuiUtils.inset((Component)fields, new Insets(0, 20, 0, 0)));
        JPanel settingsTop = GuiUtils.vbox(GuiUtils.left(this.enabledCbx), GuiUtils.left(new JLabel("How is time determined:")), namePanel, GuiUtils.left(this.indexBtn));
        this.dirFld = new JTextField(this.directory, 30);
        JButton dirBtn = GuiUtils.makeButton("Reload Files", this, "reloadFiles");
        JPanel dirPanel = GuiUtils.hbox((Component)new JLabel("Directory: "), (Component)this.dirFld, dirBtn);
        JPanel filesTop = !this.doImageSet ? dirPanel : new JPanel();
        JScrollPane filesSp = GuiUtils.makeScrollPane(this.fileList, 200, 200);
        filesSp.setPreferredSize(new Dimension(200, 200));
        JPanel filesListPanel = GuiUtils.topCenter(GuiUtils.left(new JLabel("Images:")), filesSp);
        JPanel filesPanel = GuiUtils.topCenter(filesTop, filesListPanel);
        if (this.justOneFile) {
            this.reloadFiles();
            return moviePanel;
        }
        this.tabbedPane.add("Movie", moviePanel);
        if (!this.doImageSet) {
            this.tabbedPane.add("Settings", GuiUtils.inset((Component)GuiUtils.top(filesPanel), 5));
        }
        if (this.doImageSet) {
            this.doMakeImageSetTree(this.tabbedPane);
        }
        this.tabbedPane.add("Settings", GuiUtils.inset((Component)GuiUtils.top(this.doMakeWidgetComponent()), 5));
        return this.tabbedPane;
    }

    private boolean appendImageSetXml(String path) throws Exception {
        if (this.haveSeen.get(path) != null) {
            return true;
        }
        this.haveSeen.put(path, path);
        String contents = IOUtil.readContents(path, this.getClass(), null);
        if (contents == null) {
            return false;
        }
        return this.appendImageSetXml(XmlUtil.getRoot(contents));
    }

    private boolean appendImageSetXml(Element element) throws Exception {
        if (element == null) {
            return false;
        }
        element = (Element)this.getImageSetsRoot().getOwnerDocument().importNode(element, true);
        this.getImageSetsRoot().appendChild(element);
        return true;
    }

    private void loadImageSetsMap() throws VisADException, RemoteException, Exception {
        this.stations = new ArrayList<NamedStationImpl>();
        ArrayList<visad.georef.LatLonPoint> locs = new ArrayList<visad.georef.LatLonPoint>();
        List children = XmlUtil.findDescendants(this.getImageSetsRoot(), TAG_IMAGESET);
        this.pointNodes = new ArrayList();
        for (int cidx = 0; cidx < children.size(); ++cidx) {
            Element child = (Element)children.get(cidx);
            String latString = XmlUtil.getAttribute((Node)child, ATTR_LAT, (String)null);
            if (latString == null) continue;
            String lonString = XmlUtil.getAttribute(child, ATTR_LON);
            String id = XmlUtil.getAttribute(child, ATTR_NAME);
            NamedStationImpl station = new NamedStationImpl(id, XmlUtil.getAttribute(child, ATTR_NAME), Misc.decodeLatLon(latString), Misc.decodeLatLon(lonString), 0.0, CommonUnit.meter);
            this.stations.add(station);
            locs.add(station.getEarthLocation().getLatLonPoint());
            this.pointNodes.add(child);
            this.idToStation.put(id, station);
            this.stationToElement.put(station, child);
            this.elementToStation.put(child, station);
        }
        if (locs.size() > 0) {
            this.latLons = locs.toArray(new LatLonTuple[locs.size()]);
            this.locations.setData(Util.indexedField(this.latLons, false));
            this.stationMap.setStations(this.stations);
        }
    }

    private void doMakeImageSetTree(JTabbedPane tabbedPane) {
        try {
            if (this.tocFiles != null) {
                this.extraCollections.addAll(StringUtil.split(this.tocFiles, ";", true, true));
            } else if (this.doImageSetResources) {
                XmlResourceCollection xrc = this.getControlContext().getResourceManager().getXmlResources(IdvResourceManager.RSC_IMAGESETS);
                for (int i = 0; i < xrc.size(); ++i) {
                    try {
                        this.appendImageSetXml(xrc.get(i).toString());
                        continue;
                    }
                    catch (Exception exc) {
                        ImageMovieControl.logException("Error reading xml: " + xrc.get(i), exc);
                    }
                }
            }
            for (int i = 0; i < this.extraCollections.size(); ++i) {
                try {
                    this.appendImageSetXml(this.extraCollections.get(i).toString());
                    continue;
                }
                catch (Exception exc) {
                    ImageMovieControl.logException("Error reading xml: " + this.extraCollections.get(i).toString(), exc);
                }
            }
            this.imageSetsTree.loadTree();
            this.loadImageSetsMap();
            this.locations.addAction(new ActionImpl("Image Movie Probe Action"){
                private boolean first;
                {
                    this.first = true;
                }

                @Override
                public void doAction() {
                    if (this.first) {
                        this.first = false;
                    } else {
                        try {
                            int i = ImageMovieControl.this.locations.getCloseIndex();
                            if (i >= 0) {
                                ImageMovieControl.this.selectImageSet((Element)ImageMovieControl.this.pointNodes.get(i));
                            }
                        }
                        catch (Exception ex) {
                            DisplayControlBase.logException(ex);
                        }
                    }
                }
            });
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Error reading xml", exc);
        }
        JScrollPane treeScroller = this.imageSetsTree.getScroller();
        this.stationMap.setPreferredSize(new Dimension(100, 100));
        treeScroller.setPreferredSize(new Dimension(100, 100));
        this.previewPanel.setPreferredSize(new Dimension(100, 100));
        this.previewPanel.setSize(new Dimension(100, 100));
        JButton loadButton = GuiUtils.makeButton("Load Image Set", this, "loadSelectedImageSet");
        JPanel previewContents = GuiUtils.topCenter(GuiUtils.left(this.previewCbx), GuiUtils.inset((Component)this.previewPanel, 5));
        JPanel leftPanel = GuiUtils.doLayout(new Component[]{treeScroller, previewContents}, 1, GuiUtils.WT_Y, GuiUtils.WT_Y);
        JPanel imageSetsPanel = GuiUtils.doLayout(new Component[]{leftPanel, this.stationMap}, 2, new double[]{0.3, 1.0}, GuiUtils.WT_Y);
        imageSetsPanel = GuiUtils.centerBottom(imageSetsPanel, GuiUtils.wrap(GuiUtils.inset((Component)loadButton, 5)));
        tabbedPane.add("Image Sets", GuiUtils.inset((Component)imageSetsPanel, 5));
        if (this.imageSetUrl != null) {
            this.reloadFiles();
        } else if (this.pointIndex >= 0 && this.pointIndex < this.pointNodes.size()) {
            this.selectImageSet((Element)this.pointNodes.get(this.pointIndex));
        }
        if (!this.justOneFile) {
            this.addDisplayable((Displayable)this.locations, 132);
            this.addDisplayable((Displayable)this.selectedPoint, 132);
        }
    }

    private Element getImageSetsRoot() {
        if (this.imageSetsRoot == null) {
            try {
                this.imageSetsRoot = XmlUtil.getRoot("<dummy name=\"Image Sets\"/>");
            }
            catch (Exception exc) {
                throw new IllegalStateException("Could not create tree root");
            }
        }
        return this.imageSetsRoot;
    }

    public void setTocFiles(String files) {
        this.tocFiles = files;
    }

    @Override
    protected void timeChanged(Real time) {
        super.timeChanged(time);
        try {
            this.getImagePanel().setSelectedFile(this.getInternalAnimation().getCurrent());
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Error setting time", exc);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("selectedStation")) {
            List selected = this.stationMap.getSelectedStations();
            if (selected.size() == 0) {
                return;
            }
            Element element = this.stationToElement.get(selected.get(0));
            if (element == null) {
                return;
            }
            this.imageSetsTree.selectElement(element);
            if (this.stationMap.getWasDoubleClick()) {
                this.selectImageSet(element);
            } else {
                this.doPreview(element);
            }
        } else {
            super.propertyChange(event);
        }
    }

    public void loadSelectedImageSet() {
        List l = this.imageSetsTree.getSelectedElements();
        if (l.size() > 0) {
            this.selectImageSet((Element)l.get(0));
            GuiUtils.showComponentInTabs(this.tabbedPane);
        }
    }

    private visad.georef.LatLonPoint getImageLocation() {
        if (this.imageLocation == null) {
            this.setSelectedPoint();
        }
        return this.imageLocation;
    }

    private void setSelectedPoint() {
        this.imageLocation = null;
        visad.georef.LatLonPoint[] tmpLatLons = this.latLons;
        int tmpPointIndex = this.pointIndex;
        if (tmpLatLons == null) {
            return;
        }
        if (tmpPointIndex >= 0 && tmpPointIndex < tmpLatLons.length) {
            try {
                this.imageLocation = tmpLatLons[tmpPointIndex];
                this.selectedPoint.setPoint((RealTuple)((Object)tmpLatLons[tmpPointIndex]));
            }
            catch (Exception exc) {
                ImageMovieControl.logException("Error setting indicator point", exc);
            }
            NamedStationImpl station = this.elementToStation.get(this.pointNodes.get(tmpPointIndex));
            if (station != null && this.stationMap != null) {
                this.stationMap.setSelectedStations(Misc.newList(station));
            }
        }
    }

    private void doPreview(Element node) {
        try {
            this.previewPanel.setImage(null);
            this.doPreviewInner(node);
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Error loading preview", exc);
        }
    }

    private Element getRoot(String url) throws Exception {
        if (url == null) {
            return null;
        }
        Element root = this.urlToRoot.get(url);
        if (root == null && (root = XmlUtil.getRoot(url, this.getClass())) != null) {
            this.urlToRoot.put(url, root);
        }
        return root;
    }

    private void doPreviewInner(Element node) throws Exception {
        XmlNodeList children;
        this.lastPreviewNode = node;
        if (node == null || !this.previewCbx.isSelected()) {
            return;
        }
        String url = this.getImageSetUrl(node);
        if (url == null) {
            return;
        }
        Element root = this.getRoot(url);
        String base = XmlUtil.getAttribute((Node)root, ATTR_BASE, (String)null);
        if (base == null) {
            base = IOUtil.getFileRoot(url);
        }
        if ((children = XmlUtil.getElements(root, TAG_IMAGE)).getLength() == 0) {
            return;
        }
        Element latestChild = null;
        String format = XmlUtil.getAttribute((Node)root, ATTR_FORMAT, "yyyyMMddHHmmz");
        double latestTime = 0.0;
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            String time = XmlUtil.getAttribute(child, ATTR_TIME);
            DateTime dateTime = UtcDate.createDateTime(time, format);
            if (i != 0 && !(dateTime.getValue() > latestTime)) continue;
            latestTime = dateTime.getValue();
            latestChild = child;
        }
        if (latestChild == null) {
            return;
        }
        url = XmlUtil.getAttribute(latestChild, ATTR_FILE);
        if (base != null && !url.startsWith("http:") && !url.startsWith(File.separator + "") && url.indexOf(":") < 0) {
            url = !base.endsWith("/") && !url.startsWith("/") ? base + "/" + url : base + url;
        }
        this.previewPanel.setImage(ImageUtils.getImageFile(url));
    }

    private String getImageSetUrl(Element node) {
        String url;
        block1: {
            Element root = XmlUtil.findAncestor(node, TAG_IMAGESETS);
            String base = this.imageSetsRoot == null ? null : XmlUtil.getAttribute((Node)root, ATTR_BASE, (String)null);
            url = XmlUtil.getAttribute((Node)node, ATTR_INDEX, (String)null);
            if (url == null) {
                return null;
            }
            if (base == null) break block1;
            url = !base.endsWith("/") && !url.startsWith("/") ? base + "/" + url : base + url;
        }
        return url;
    }

    private void selectImageSet(Element node) {
        String name = XmlUtil.getAttribute((Node)node, ATTR_NAME, (String)null);
        if (name != null) {
            LogUtil.message("Location: " + name);
        }
        this.pointIndex = this.pointNodes.indexOf(node);
        this.setSelectedPoint();
        this.imageSetRoot = null;
        this.imageSetUrl = this.getImageSetUrl(node);
        this.reloadFiles();
        this.tabbedPane.setSelectedIndex(0);
    }

    public void reloadFiles() {
        if (!this.doImageSet) {
            this.loadFilesFromDirectory();
        } else {
            this.loadFilesFromXml();
        }
        this.addMoviesToList();
        this.setImageForTime();
    }

    public void loadFilesFromXml() {
        ArrayList<String> files = new ArrayList<String>();
        this.times = new ArrayList();
        if (this.imageSetUrl == null) {
            return;
        }
        try {
            int i;
            String base;
            if (this.imageSetRoot == null) {
                this.imageSetRoot = this.getRoot(this.imageSetUrl);
            }
            if ((base = XmlUtil.getAttribute((Node)this.imageSetRoot, ATTR_BASE, (String)null)) == null) {
                base = IOUtil.getFileRoot(this.imageSetUrl);
            }
            String format = XmlUtil.getAttribute((Node)this.imageSetRoot, ATTR_FORMAT, "yyyyMMddHHmmz");
            XmlNodeList children = XmlUtil.getElements(this.imageSetRoot, TAG_IMAGE);
            List<FileDate> fileDates = new ArrayList();
            for (i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                String url = XmlUtil.getAttribute(child, ATTR_FILE);
                String time = XmlUtil.getAttribute(child, ATTR_TIME);
                if (base != null && !url.startsWith("http:") && !url.startsWith(File.separator + "") && url.indexOf(":") < 0) {
                    url = !base.endsWith("/") && !url.startsWith("/") ? base + "/" + url : base + url;
                }
                DateTime dateTime = UtcDate.createDateTime(time, format);
                fileDates.add(new FileDate(url, dateTime));
            }
            fileDates = Misc.sort(fileDates);
            for (i = 0; i < fileDates.size(); ++i) {
                FileDate fd = (FileDate)fileDates.get(i);
                files.add(fd.file);
                this.times.add(fd.dttm);
            }
            this.getImagePanel().setFiles(files);
            GuiUtils.invokeInSwingThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Animation animation = ImageMovieControl.this.getInternalAnimation();
                        ImageMovieControl.this.setAnimationSet(ImageMovieControl.this.times);
                        animation.setCurrent(ImageMovieControl.this.times.size() - 1);
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("Setting animation times", exc);
                    }
                }
            });
            String group = XmlUtil.getAttribute((Node)this.imageSetRoot, ATTR_GROUP, "");
            String desc = XmlUtil.getAttribute((Node)this.imageSetRoot, ATTR_DESC, "");
            if (desc.length() > 0) {
                desc = " - " + desc;
            }
            this.descLabel.setText(group + " - " + XmlUtil.getAttribute((Node)this.imageSetRoot, ATTR_NAME, "") + desc);
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Error reading xml", exc);
        }
    }

    public List[] loadFilesFromXml(String imageSetUrl, Element imageSetRoot) {
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        if (imageSetUrl == null) {
            return new List[]{files, times};
        }
        try {
            int i;
            String base;
            if (imageSetRoot == null) {
                imageSetRoot = this.getRoot(imageSetUrl);
            }
            if ((base = XmlUtil.getAttribute((Node)imageSetRoot, ATTR_BASE, (String)null)) == null) {
                base = IOUtil.getFileRoot(imageSetUrl);
            }
            String format = XmlUtil.getAttribute((Node)imageSetRoot, ATTR_FORMAT, "yyyyMMddHHmmz");
            XmlNodeList children = XmlUtil.getElements(imageSetRoot, TAG_IMAGE);
            List<FileDate> fileDates = new ArrayList();
            for (i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                String url = XmlUtil.getAttribute(child, ATTR_FILE);
                String time = XmlUtil.getAttribute(child, ATTR_TIME);
                if (base != null && !url.startsWith("http:") && !url.startsWith(File.separator + "") && url.indexOf(":") < 0) {
                    url = !base.endsWith("/") && !url.startsWith("/") ? base + "/" + url : base + url;
                }
                DateTime dateTime = UtcDate.createDateTime(time, format);
                fileDates.add(new FileDate(url, dateTime));
            }
            fileDates = Misc.sort(fileDates);
            for (i = 0; i < fileDates.size(); ++i) {
                FileDate fd = (FileDate)fileDates.get(i);
                files.add(fd.file);
                times.add(fd.dttm);
            }
            return new List[]{files, times};
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Error reading xml", exc);
            return new List[]{files, times};
        }
    }

    public void loadFilesFromDirectory() {
        try {
            File dir = new File(this.getDirectory());
            String filePattern = this.dateType == 0 ? "\\.jpg$,\\.jpeg$,\\.gif$,\\.png$" : this.datePattern;
            File[] imageFiles = IOUtil.sortFilesOnAge(dir, new PatternFileFilter(filePattern, false), false);
            ArrayList<String> files = new ArrayList<String>();
            String errorMsg = null;
            Pattern pattern = Pattern.compile(this.getDatePattern());
            for (int i = 0; i < imageFiles.length; ++i) {
                String f = imageFiles[i].toString();
                String name = new File(f).getName();
                try {
                    Matcher matcher = pattern.matcher(name);
                    if (!matcher.find()) {
                        errorMsg = "Could not match pattern:" + name;
                        break;
                    }
                    if (matcher.groupCount() < 1) {
                        errorMsg = "No groups in pattern:" + this.getDatePattern();
                        break;
                    }
                    name = matcher.group(1);
                    DateTime dttm = UtcDate.createDateTime(name, this.getDateFormat());
                    files.add(f);
                    this.times.add(dttm);
                }
                catch (Exception exc) {
                    errorMsg = "Error extracting the date from the filename:" + name + "\n" + "Format:" + this.dateFormat;
                    break;
                }
                if (errorMsg == null) continue;
                LogUtil.userErrorMessage(errorMsg);
                this.setEnabled(false);
                if (this.enabledCbx == null) continue;
                this.enabledCbx.setSelected(false);
            }
            if (files.size() == 0) {
                ImageMovieControl.userMessage("No files were found using the pattern:" + pattern);
            }
            this.getImagePanel().setFiles(files);
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Error finding files", exc);
        }
    }

    @Override
    protected void applyZPosition() throws VisADException, RemoteException {
        this.deactivateDisplays();
        if (this.imageDisplay != null) {
            this.imageDisplay.setConstantPosition(this.getZPosition() + 0.01, Display.ZAxis);
        }
        super.applyZPosition();
        this.activateDisplays();
    }

    public void dateTypeButtonPressed(Integer v) {
    }

    private void addMoviesToList() {
        Vector<String> items = new Vector<String>();
        List files = this.getImagePanel().getFiles();
        List times = this.times;
        for (int i = 0; i < files.size(); ++i) {
            items.add(times.get(i).toString());
        }
        if (this.fileList != null) {
            this.fileList.setListData(items);
        }
    }

    private ImagePanel getImagePanel() {
        if (this.imagePanel == null) {
            this.imagePanel = new ImagePanel(){

                @Override
                public void setImage(Image image) {
                    super.setImage(image);
                    ImageMovieControl.this.loadImage(ImageMovieControl.this.imagePanel.getImage());
                }
            };
            this.imagePanel.setPreferredSize(new Dimension(300, 300));
        }
        return this.imagePanel;
    }

    @Override
    public void initDone() {
        if (this.getImagePanel().getFiles().size() == 0 && this.tabbedPane.getTabCount() > 1) {
            this.tabbedPane.setSelectedIndex(1);
        }
        this.setImageForTime();
        super.initDone();
    }

    private void setPointSize() {
        try {
            this.locations.setPointSize(5.0f);
            this.selectedPoint.setPointSize(10.0f);
        }
        catch (Exception exc) {
            ImageMovieControl.logException("Set point size ", exc);
        }
    }

    public void setDirectory(String value) {
        this.directory = value;
    }

    public String getDirectory() {
        if (this.dirFld != null) {
            this.directory = this.dirFld.getText().trim();
        }
        return this.directory;
    }

    public void setFiles(List value) {
    }

    public void setDateFormat(String value) {
        this.dateFormat = value;
    }

    public String getDateFormat() {
        if (this.formatFld != null) {
            this.dateFormat = this.formatFld.getText().trim();
        }
        return this.dateFormat;
    }

    public void setDatePattern(String value) {
        this.datePattern = value;
    }

    public String getDatePattern() {
        if (this.patternFld != null) {
            this.datePattern = this.patternFld.getText().trim();
        }
        return this.datePattern;
    }

    public void setEnabled(boolean value) {
        if (this.enabled == value) {
            return;
        }
        this.enabled = value;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setDateType(int value) {
        this.dateType = value;
    }

    public int getDateType() {
        if (this.indexBtn != null) {
            this.dateType = this.indexBtn.isSelected() ? 0 : 1;
        }
        return this.dateType;
    }

    public void setImageSetUrl(String value) {
        this.imageSetUrl = value;
    }

    public String getImageSetUrl() {
        return this.imageSetUrl;
    }

    public void setDoImageSet(boolean value) {
        this.doImageSet = value;
    }

    public boolean getDoImageSet() {
        return this.doImageSet;
    }

    public void setPointIndex(int value) {
        this.pointIndex = value;
    }

    public int getPointIndex() {
        return this.pointIndex;
    }

    public void setAnimationMode(int value) {
    }

    public void setExtraCollections(List value) {
        this.extraCollections = value;
    }

    public List getExtraCollections() {
        return this.extraCollections;
    }

    public void setShowImageInDisplay(boolean value) {
        this.showImageInDisplay = value;
        if (this.imageDisplay != null) {
            this.loadImage(this.getImagePanel().getImage());
        }
    }

    public boolean getShowImageInDisplay() {
        return this.showImageInDisplay;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    public static void main(String[] args) throws Exception {
        Hashtable<String, double[]> zipcodes = new Hashtable<String, double[]>();
        for (String line : StringUtil.split(IOUtil.readContents("zip_codes.csv", ImageMovieControl.class), "\n", true, true)) {
            List<String> toks;
            if (line.length() == 0 || line.startsWith("#") || (toks = StringUtil.split(line, ",", true, false)).size() < 3 || toks.get(2).length() == 0 || toks.get(3).length() == 0) continue;
            zipcodes.put(toks.get(0), new double[]{new Double(toks.get(1)), new Double(toks.get(2))});
        }
        Hashtable<String, CameraInfo> seen = new Hashtable<String, CameraInfo>();
        ArrayList<CameraInfo> cameras = new ArrayList<CameraInfo>();
        File dir = new File(".");
        File[] files = dir.listFiles();
        Hashtable<String, Integer> zips = new Hashtable<String, Integer>();
        for (File f : files) {
            if (!f.getName().toString().startsWith("cam_")) continue;
            Element root = XmlUtil.getRoot(f.toString(), ImageMovieControl.class);
            List nodes = XmlUtil.findDescendants(root, "aws:camera");
            for (Element camNode : nodes) {
                String id = XmlUtil.getAttribute(camNode, "id");
                String zipCode = XmlUtil.getAttribute(camNode, "zipcode");
                double distance = XmlUtil.getAttribute((Node)camNode, "distance", 0.0);
                if (id.equals("BLDBC")) {
                    zipCode = "80303";
                }
                double[] latlon = (double[])zipcodes.get(zipCode);
                String name = XmlUtil.getAttribute(camNode, ATTR_NAME);
                if (latlon == null) continue;
                double lat = latlon[0];
                double lon = latlon[1];
                id = id.replace(",", "_");
                name = name.replace(",", " ");
                CameraInfo cameraInfo = new CameraInfo(id, name, latlon[0], latlon[1], distance);
                CameraInfo old = (CameraInfo)seen.get(id);
                if (old != null) {
                    if (!(old.distance > cameraInfo.distance)) continue;
                    old.distance = cameraInfo.distance;
                    continue;
                }
                seen.put(id, cameraInfo);
                cameras.add(cameraInfo);
                Integer cnt = (Integer)zips.get(zipCode);
                if (cnt != null) continue;
                zips.put(zipCode, new Integer(1));
            }
        }
        FileOutputStream fos = new FileOutputStream("weatherbugcameras.xml");
        fos.write(new String("<stationtable name=\"WeatherBug Web Cams\">\n").getBytes());
        for (CameraInfo camInfo : cameras) {
            StringBuffer sb = new StringBuffer();
            String imageUrl = "http://wwc.instacam.com/instacamimg/" + camInfo.id + "/" + camInfo.id + "_s.jpg";
            String html = "<h3>WeatherBug WebCam</h3><b>" + camInfo.name + "</b><br><img src=\"" + imageUrl + "\">";
            sb.append(XmlUtil.openTag("station", XmlUtil.attrs(ATTR_NAME, camInfo.name, ATTR_LAT, "" + camInfo.lat, ATTR_LON, "" + camInfo.lon, "imageurl", imageUrl)));
            sb.append("<![CDATA[" + html + "]]></station>\n");
            fos.write(sb.toString().getBytes());
        }
        fos.write(new String("</stationtable>\n").getBytes());
        fos.close();
        System.err.println("#cameras:" + cameras.size());
    }

    public static class CameraInfo {
        String id;
        String name;
        double lat;
        double lon;
        double distance;

        public CameraInfo(String id, String name, double lat, double lon, double distance) {
            this.id = id;
            this.name = name;
            this.lat = lat;
            this.lon = lon;
            this.distance = distance;
        }
    }

    private static class FileDate
    implements Comparable {
        String file;
        DateTime dttm;

        public FileDate(String file, DateTime dttm) {
            this.file = file;
            this.dttm = dttm;
        }

        public int compareTo(Object o) {
            FileDate that = (FileDate)o;
            if (this.dttm.getValue() < that.dttm.getValue()) {
                return -1;
            }
            if (this.dttm.getValue() > that.dttm.getValue()) {
                return 1;
            }
            return 0;
        }
    }
}

