/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.idv.control.BaseImageControl;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.visad.display.Displayable;
import ucar.visad.display.ImageRGBDisplayable;
import visad.ConstantMap;
import visad.Display;
import visad.FieldImpl;
import visad.RealType;
import visad.VisADException;

public class ImageControl
extends BaseImageControl {
    ImageRGBDisplayable imageDisplay;
    private RealType topoType = null;
    private boolean multipleIsTopography = false;
    private boolean useTexture = true;
    private JLabel sideLegendReadout;

    @Override
    protected ColorTable getInitialColorTable() {
        return this.getDisplayConventions().getParamColorTable("image");
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.imageDisplay = new ImageRGBDisplayable("plan_color_" + this.paramName);
        this.setImageTexture(this.useTexture);
        if ((double)this.getAlpha() != 1.0) {
            this.imageDisplay.setAlpha(this.getAlpha());
        }
        if (EMPTY_RGB_IMAGE != null) {
            this.imageDisplay.setData(EMPTY_RGB_IMAGE);
        }
        this.addDisplayable((Displayable)this.imageDisplay, this.getImageFlags());
        if (dataChoice != null) {
            return this.setData(dataChoice);
        }
        return true;
    }

    @Override
    protected JComponent getExtraLegendComponent(int legendType) {
        JComponent parentComp = super.getExtraLegendComponent(legendType);
        if (legendType == 0) {
            return parentComp;
        }
        if (this.sideLegendReadout == null) {
            this.sideLegendReadout = new JLabel("<html><br></html>");
        }
        return GuiUtils.vbox(this.sideLegendReadout, parentComp);
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Transparency:"), this.doMakeAlphaSlider()));
        if (this.getMultipleIsTopography()) {
            JCheckBox toggle = new JCheckBox("", this.useTexture);
            toggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ImageControl.this.useTexture = ((JCheckBox)e.getSource()).isSelected();
                        ImageControl.this.setImageTexture(ImageControl.this.useTexture);
                    }
                    catch (Exception ve) {
                        DisplayControlBase.logException("useTexture", ve);
                    }
                }
            });
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Display:"), GuiUtils.left(GuiUtils.hbox(new Component[]{GuiUtils.rLabel("Texture: "), toggle}))));
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        return GuiUtils.topLeft(this.doMakeWidgetComponent());
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        boolean result = super.setData(dataChoice);
        if (!result) {
            return false;
        }
        if (this.haveMultipleFields()) {
            this.addTopographyMap(3);
        }
        FieldImpl fieldImpl = this.getGridDataInstance().getGrid();
        this.checkImageSize(fieldImpl);
        this.imageDisplay.loadData(this.getWorkingImage(fieldImpl));
        DataChoice dc0 = null;
        dc0 = dataChoice instanceof DerivedDataChoice ? (DataChoice)((DerivedDataChoice)dataChoice).getChoices().get(0) : dataChoice;
        String magStr = (String)dc0.getProperty("MAG");
        if (magStr != null) {
            if (this.sideLegendReadout == null) {
                this.sideLegendReadout = new JLabel("<html><br></html>");
            }
            this.sideLegendReadout.setText("<html>" + magStr + "</html>");
        }
        return true;
    }

    @Override
    protected boolean haveMultipleFields() {
        GridDataInstance gdi = this.getGridDataInstance();
        if (gdi == null) {
            return false;
        }
        return gdi.getNumRealTypes() > 3;
    }

    public void setMultipleIsTopography(boolean v) {
        this.multipleIsTopography = v;
    }

    public boolean getMultipleIsTopography() {
        return this.multipleIsTopography;
    }

    @Override
    protected void setAlphaFromSlider(float newAlpha) {
        try {
            super.setAlphaFromSlider(newAlpha);
            if (this.imageDisplay != null) {
                this.imageDisplay.setAlpha(newAlpha);
            }
        }
        catch (Exception e) {
            ImageControl.logException("Setting alpha value", e);
        }
    }

    protected int getImageFlags() {
        int imageFlags = 8;
        if (!this.getMultipleIsTopography()) {
            imageFlags |= 0x80;
        }
        return imageFlags;
    }

    public void setUseTexture(boolean v) {
        this.useTexture = v;
    }

    public boolean getUseTexture() {
        return this.useTexture;
    }

    private void setImageTexture(boolean useTexture) {
        if (this.imageDisplay != null) {
            try {
                this.imageDisplay.addConstantMap(new ConstantMap(useTexture ? 1.0 : 0.0, Display.TextureEnable));
            }
            catch (Exception e) {
                ImageControl.logException("Setting smooth value", e);
            }
        }
    }
}

