/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.SelectRangeWidget;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Range;
import ucar.visad.display.ColorScale;

public abstract class HydraControl
extends DisplayControlImpl {
    public void updateRange(Range range) {
        if (this.ctw != null) {
            this.ctw.setRange(range);
        }
        try {
            SelectRangeWidget srw = this.getSelectRangeWidget(range);
            if (srw != null) {
                srw.setRange(range);
            }
        }
        catch (Exception e) {
            LogUtil.logException("Error updating select range widget", e);
        }
        if (this.colorScales != null) {
            ColorScale scale = (ColorScale)this.colorScales.get(0);
            try {
                scale.setRangeForColor(range.getMin(), range.getMax());
            }
            catch (Exception exc) {
                LogUtil.logException("Error updating display ColorScale range", exc);
            }
        }
    }

    public void handleChannelChange(float newChan) {
    }
}

